% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{require.quiet}
\alias{require.quiet}
\alias{qrequire}
\alias{qlibrary}
\alias{mrequire}
\title{Loading Packages}
\usage{
require.quiet(...)

qrequire(...)

qlibrary(...)

mrequire(msg, package, lib.loc = NULL, quietly = FALSE)
}
\arguments{
\item{...}{extra arguments passed to \code{\link{library}} or \code{\link{require}}.}

\item{msg}{error message to use, to which is appended the string
\code{' requires package <pkg>'} to build the error message.}

\item{package}{name of the package to load.}

\item{lib.loc}{a character vector describing the location of \R
    library trees to search through, or \code{NULL}.  The default value
    of \code{NULL} corresponds to all libraries currently known to
    \code{\link[base]{.libPaths}()}.
    Non-existent library trees are silently ignored.}

\item{quietly}{a logical.  If \code{TRUE}, no message confirming
    package attaching is printed, and most often, no errors/warnings are
    printed if package attaching fails.}
}
\value{
No return value, called to load packages.
}
\description{
\code{require.quiet} silently requires a package, and \code{qrequire} is an alias to \code{require.quiet}.
}
\section{Functions}{
\itemize{
\item \code{qlibrary()}: silently loads a package.

\item \code{mrequire()}: tries loading a package with base \code{\link{require}}
and stops with a -- custom -- error message if it fails to do so.

}}
\examples{

mrequire('Running this example', 'stringr')
try( mrequire('Doing impossible things', 'notapackage') )

}
\seealso{
Other require: 
\code{\link{irequire}()}
}
\concept{require}
