% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested_model_info.R
\name{get_nested_model_info}
\alias{get_nested_model_info}
\title{Resolve Nested Model Representation}
\usage{
get_nested_model_info(fit1, fit0)
}
\arguments{
\item{fit1}{A fitted model object (e.g., from \code{lm}, \code{lmer}, etc.).}

\item{fit0}{A nested model specification: a model object, a formula (e.g., \code{~ . - x}),
a character vector of term names to remove, or a restriction matrix.}
}
\value{
A list with:
\describe{
\item{formula_large}{Formula for \code{fit1}.}
\item{formula_small}{Formula for resolved \code{fit0}.}
\item{large_model}{The full model \code{fit1}.}
\item{small_model}{The nested model \code{fit0}.}
\item{L}{Restriction matrix defining the nested model.}
}
}
\description{
Constructs or extracts a nested model (\code{fit0}) from a full model (\code{fit1})
using flexible input: a model object, formula, character string, or matrix.

This function is useful for preparing models for comparison, e.g., via likelihood ratio test.
}
\examples{
if (requireNamespace("lme4", quietly = TRUE)) {
  library(lme4)
  data(sleepstudy)
  fit1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)
  fit0 <- lmer(Reaction ~ (Days | Subject), sleepstudy)

  get_nested_model_info(fit1, fit0)               # as model object
  get_nested_model_info(fit1, ~ . - Days)         # as formula
  get_nested_model_info(fit1, "Days")             # as string
  ## get_nested_model_info(fit1, c(0, 1))         # numeric (converted to matrix)
}

}
