% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.r
\name{lighter}
\alias{lighter}
\title{Make a munsell colour lighter}
\usage{
lighter(col, steps = 1)
}
\arguments{
\item{col}{character vector of Munsell colours}

\item{steps}{number of steps to take in increasing value}
}
\value{
character vector of Munsell colours
}
\description{
Increases the value of the Munsell colour.
}
\examples{
lighter("5PB 2/4")
cols <- c("5PB 2/4", "5Y 6/8")
p <- plot_mnsl(c(cols, lighter(cols), lighter(cols, 2)))
p + ggplot2::facet_wrap(~ names, ncol = 2)
# lighter and darker are usually reversible
lighter(darker("5PB 2/4"))
# unless you try to pass though white or black
lighter(darker("5PB 1/4"))
}
