% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{encode_colour}
\alias{encode_colour}
\title{Encode colours into RGB hex-strings}
\usage{
encode_colour(colour, alpha = NULL, from = "rgb", white = "D65")
}
\arguments{
\item{colour}{A numeric matrix (or an object coercible to one) with colours
encoded in the rows and the different colour space values in the columns. For
all colourspaces except \code{'cmyk'} this will mean a matrix with three columns -
for \code{'cmyk'} it means four columns.}

\item{alpha}{A numeric vector between 0 and 1. Will be recycled to the number
of rows in \code{colour}. If \code{NULL} or a single \code{NA} it will be ignored.}

\item{from}{The input colour space. Allowed values are: \code{"cmy"},
\code{"cmyk"}, \code{"hsl"}, \code{"hsb"}, \code{"hsv"}, \code{"lab"} (CIE L*ab), \code{"hunterlab"}
(Hunter Lab), \code{"lch"} (CIE Lch(ab) / polarLAB), \code{"luv"}, \code{"rgb"} (sRGB),
\code{"xyz"}, \code{"yxy"} (CIE xyY), or \code{"hcl"} (CIE Lch(uv) / polarLuv)}

\item{white}{The white reference of the input colour space. Will only have an
effect for relative colour spaces such as Lab and luv. Any value accepted by
\code{\link[=as_white_ref]{as_white_ref()}} allowed.}
}
\value{
A character vector with colours encoded as \verb{#RRGGBB(AA)}
}
\description{
This is a version of \code{\link[grDevices:rgb]{grDevices::rgb()}} that works with the standard colour
format used in farver (matrix or data.frame with colours in rows). It further
support taking input from any colour space.
}
\note{
The output may differ slightly from that of \code{\link[grDevices:rgb]{grDevices::rgb()}} since
\code{rgb()} doesn't round numeric values correctly.
}
\section{Handling of non-finite and out of bounds values}{

\code{NA}, \code{NaN}, \code{-Inf}, and \code{Inf} are treated as invalid input and will result
in \code{NA} values for the colour. If a given colourspace has finite bounds in
some of their channels, the input will be capped before conversion, and the
output will be capped before returning, so that both input and output colours
are valid colours in their respective space. This means that converting back
and forth between two colourspaces may result in a change in the colour if
the gamut of one of the spaces is less than the other.
}

\examples{
spectrum <- decode_colour(rainbow(10))

encode_colour(spectrum)

# Attach alpha values
encode_colour(spectrum, alpha = c(0.5, 1))

# Encode from a different colour space
spectrum_hcl <- convert_colour(spectrum, 'rgb', 'hcl')
encode_colour(spectrum_hcl, from = 'hcl')

}
\seealso{
Other encoding and decoding functions: 
\code{\link{decode_colour}()},
\code{\link{manip_channel}}
}
\concept{encoding and decoding functions}
