% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{dyCrosshair}
\alias{dyCrosshair}
\title{The dyCrosshair plugin draws a crosshair line over the point closest to the
mouse when the user hovers over the graph. It has a "direction" option which
is provided in the R wrapper function and then forwarded to the plugin using
the "options" argument to dyPlugin.}
\usage{
dyCrosshair(dygraph, direction = c("both", "horizontal", "vertical"))
}
\arguments{
\item{dygraph}{Dygraph to add plugin to}

\item{direction}{Crosshair direction. Valid options are: "both", "horizontal",
"vertical"}
}
\value{
Dygraph with Crosshair plugin enabled
}
\description{
The dyCrosshair plugin draws a crosshair line over the point closest to the
mouse when the user hovers over the graph. It has a "direction" option which
is provided in the R wrapper function and then forwarded to the plugin using
the "options" argument to dyPlugin.
}
\examples{
library(dygraphs)
dygraph(ldeaths) \%>\%
  dyRangeSelector() \%>\%
  dyCrosshair(direction = "vertical")

}
