% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bench_process_memory.R
\name{bench_process_memory}
\alias{bench_process_memory}
\title{Retrieve the current and maximum memory from the R process}
\usage{
bench_process_memory()
}
\description{
The memory reported here will likely differ from that reported by \code{gc()}, as
this includes all memory from the R process, including any child processes
and memory allocated outside R's garbage collector heap.
}
\details{
The OS APIs used are as follows
\subsection{Windows}{
\itemize{
\item \href{https://learn.microsoft.com/en-us/windows/win32/api/psapi/ns-psapi-process_memory_counters}{PROCESS_MEMORY_COUNTERS.WorkingSetSize}
\item \href{https://learn.microsoft.com/en-us/windows/win32/api/psapi/ns-psapi-process_memory_counters}{PROCESS_MEMORY_COUNTERS.PeakWorkingSetSize}
}
}

\subsection{macOS}{
\itemize{
\item \href{https://developer.apple.com/documentation/kernel/1537934-task_info?language=occ}{task_info(TASK_BASIC_INFO)}
\item \href{https://developer.apple.com/library/archive/documentation/System/Conceptual/ManPages_iPhoneOS/man2/getrusage.2.html}{rusage.ru_maxrss}
}
}

\subsection{linux}{
\itemize{
\item \href{https://man7.org/linux/man-pages/man5/proc.5.html}{/proc/pid/status VmSize}
\item \href{https://man7.org/linux/man-pages/man5/proc.5.html}{/proc/pid/status VmPeak}
}
}
}
