% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_192_profile.R
\name{plot_192_profile}
\alias{plot_192_profile}
\title{Plot 192 trinucleotide profile}
\usage{
plot_192_profile(mut_matrix, colors = NA, ymax = 0.2, condensed = FALSE)
}
\arguments{
\item{mut_matrix}{192 trinucleotide profile matrix}

\item{colors}{6 value color vector}

\item{ymax}{Y axis maximum value, default = 0.2}

\item{condensed}{More condensed plotting format. Default = F.}
}
\value{
192 trinucleotide profile plot
}
\description{
Plot relative contribution of 192 trinucleotides
}
\examples{
## See the 'mut_matrix_stranded()' example for how we obtained the
## mutation matrix with transcriptional strand information:
mut_mat_s <- readRDS(system.file("states/mut_mat_s_data.rds",
  package = "MutationalPatterns"
))

## Plot profile for some of the samples
plot_192_profile(mut_mat_s[, c(1, 4, 7)])

## You can create a more condensed version of the plot
plot_192_profile(mut_mat_s[, c(1, 4, 7)], condensed = TRUE)

## It's also possible to plot signatures, for example signatures
## generated with NMF
## See 'extract_signatures()' on how we obtained these signatures.
nmf_res_strand <- readRDS(system.file("states/nmf_res_strand_data.rds",
  package = "MutationalPatterns"
))

## Optionally, provide signature names
colnames(nmf_res_strand$signatures) <- c("Signature A", "Signature B")

## Generate the plot
plot_192_profile(nmf_res_strand$signatures)
}
\seealso{
\code{\link{mut_matrix_stranded}},
\code{\link{extract_signatures}},
\code{\link{plot_96_profile}}
}
