% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateObject.R
\name{validateObject}
\alias{validateObject}
\alias{registerValidateObjectFunction}
\alias{registerValidateObjectHeightFunction}
\alias{registerValidateObjectDimensionsFunction}
\alias{registerValidateObjectSatisfiesInterface}
\alias{registerValidateObjectDerivedFrom}
\title{Validate an object's on-disk representation}
\usage{
validateObject(path, metadata = NULL)

registerValidateObjectFunction(type, fun, existing = c("old", "new", "error"))

registerValidateObjectHeightFunction(
  type,
  fun,
  existing = c("old", "new", "error")
)

registerValidateObjectDimensionsFunction(
  type,
  fun,
  existing = c("old", "new", "error")
)

registerValidateObjectSatisfiesInterface(
  type,
  interface,
  action = c("add", "remove")
)

registerValidateObjectDerivedFrom(type, parent, action = c("add", "remove"))
}
\arguments{
\item{path}{String containing a path to a directory, itself created with a \code{\link{saveObject}} method.}

\item{metadata}{List containing metadata for the object.
If this is not supplied, it is automatically read from the \code{OBJECT} file inside \code{path}.}

\item{type}{String specifying the name of type of the object.}

\item{fun}{For \code{registerValidateObjectFunction}, a function that accepts \code{path} and \code{metadata}, and raises an error if the object at \code{path} is invalid.
It can be assumed that \code{metadata} is a list created by reading \code{OBJECT}.

For \code{registerValidateObjectHeightFunction}, a function that accepts \code{path} and \code{metadata}, and returns an integer specifying the \dQuote{height} of the object.
This is usually the length for vector-like or 1-dimensional objects, and the extent of the first dimension for higher-dimensional objects.

For \code{registerValidateObjectDimensionsFunction}, a function that accepts \code{path} and \code{metadata}, and returns an integer vector specifying the dimensions of the object.

This may also be \code{NULL} to delete an existing registry from any of the functions mentioned above.}

\item{existing}{Logical scalar indicating the action to take if a function has already been registered for \code{type} -
keep the old or new function, or throw an error.}

\item{interface}{String specifying the name of the interface that is represented by \code{type}.}

\item{action}{String specifying whether to add or remove \code{type} from the list of types that implements \code{interface} or is derived from \code{parent}.}

\item{parent}{String specifying the parent object from which \code{type} is derived.}
}
\value{
For \code{validateObject}, \code{NULL} is returned invisibly upon success, otherwise an error is raised.

For the \code{registerValidObject*Function} functions, the supplied \code{fun} is added to the corresponding registry for \code{type}.
If \code{fun = NULL}, any existing entry for \code{type} is removed; a logical scalar is returned indicating whether removal was performed.

For the \code{registerValidateObjectSatisfiesInterface} and \code{registerValidateObjectDerivedFrom} functions, \code{type} is added to or removed from relevant list of types.
A logical scalar is returned indicating whether the \code{type} was added or removed - this may be \code{FALSE} if \code{type} was already present or absent, respectively.
}
\description{
Validate an object's on-disk representation against the \pkg{takane} specifications.
This is done by dispatching to an appropriate validation function based on the type in the \code{OBJECT} file.
}
\examples{
library(S4Vectors)
df <- DataFrame(A=1:10, B=LETTERS[1:10])

tmp <- tempfile()
saveObject(df, tmp)
validateObject(tmp)

}
\seealso{
\url{https://github.com/ArtifactDB/takane}, for detailed specifications of the on-disk representation for various Bioconductor objects.
}
\author{
Aaron Lun
}
