# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.oracledatabase.aio import OracleDatabaseMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestOracleDatabaseMgmtExadbVmClustersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(OracleDatabaseMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_list_by_subscription(self, resource_group):
        response = self.client.exadb_vm_clusters.list_by_subscription()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.exadb_vm_clusters.begin_create_or_update(
                resource_group_name=resource_group.name,
                exadb_vm_cluster_name="str",
                resource={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "displayName": "str",
                        "enabledEcpuCount": 0,
                        "exascaleDbStorageVaultId": "str",
                        "hostname": "str",
                        "nodeCount": 0,
                        "shape": "str",
                        "sshPublicKeys": ["str"],
                        "subnetId": "str",
                        "totalEcpuCount": 0,
                        "vmFileSystemStorage": {"totalSizeInGbs": 0},
                        "vnetId": "str",
                        "backupSubnetCidr": "str",
                        "backupSubnetOcid": "str",
                        "clusterName": "str",
                        "dataCollectionOptions": {
                            "isDiagnosticsEventsEnabled": bool,
                            "isHealthMonitoringEnabled": bool,
                            "isIncidentLogsEnabled": bool,
                        },
                        "domain": "str",
                        "giVersion": "str",
                        "gridImageOcid": "str",
                        "gridImageType": "str",
                        "iormConfigCache": {
                            "dbPlans": [{"dbName": "str", "flashCacheLimit": "str", "share": 0}],
                            "lifecycleDetails": "str",
                            "lifecycleState": "str",
                            "objective": "str",
                        },
                        "licenseModel": "str",
                        "lifecycleDetails": "str",
                        "lifecycleState": "str",
                        "listenerPort": 0,
                        "memorySizeInGbs": 0,
                        "nsgCidrs": [{"source": "str", "destinationPortRange": {"max": 0, "min": 0}}],
                        "nsgUrl": "str",
                        "ociUrl": "str",
                        "ocid": "str",
                        "privateZoneOcid": "str",
                        "provisioningState": "str",
                        "scanDnsName": "str",
                        "scanDnsRecordId": "str",
                        "scanIpIds": ["str"],
                        "scanListenerPortTcp": 0,
                        "scanListenerPortTcpSsl": 0,
                        "shapeAttribute": "str",
                        "snapshotFileSystemStorage": {"totalSizeInGbs": 0},
                        "subnetOcid": "str",
                        "systemVersion": "str",
                        "timeZone": "str",
                        "totalFileSystemStorage": {"totalSizeInGbs": 0},
                        "vipIds": ["str"],
                        "zoneOcid": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                    "zones": ["str"],
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_get(self, resource_group):
        response = await self.client.exadb_vm_clusters.get(
            resource_group_name=resource_group.name,
            exadb_vm_cluster_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_begin_update(self, resource_group):
        response = await (
            await self.client.exadb_vm_clusters.begin_update(
                resource_group_name=resource_group.name,
                exadb_vm_cluster_name="str",
                properties={"properties": {"nodeCount": 0}, "tags": {"str": "str"}, "zones": ["str"]},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_begin_delete(self, resource_group):
        response = await (
            await self.client.exadb_vm_clusters.begin_delete(
                resource_group_name=resource_group.name,
                exadb_vm_cluster_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_list_by_resource_group(self, resource_group):
        response = self.client.exadb_vm_clusters.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_exadb_vm_clusters_begin_remove_vms(self, resource_group):
        response = await (
            await self.client.exadb_vm_clusters.begin_remove_vms(
                resource_group_name=resource_group.name,
                exadb_vm_cluster_name="str",
                body={"dbNodes": [{"dbNodeId": "str"}]},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
