dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl This file is supposed to be the same as PnetCDF's test_iput.m4
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id$ */

dnl
dnl The command-line m4 macro "PNETCDF" is to differentiate PnetCDF and netCDF
dnl in terms of function prefix names (ncmpi_ vs. nc_), integer data types
dnl (MPI_Offset vs. size_t), and function name substrings for external data
dnl types.
dnl

ifdef(`PNETCDF',`dnl
#define NC_ERR_CODE_NAME ncmpi_strerrno',`dnl
#define NC_ERR_CODE_NAME nc_err_code_name')

define(`EXPECT_ERR',`error("expecting $1 but got %s",NC_ERR_CODE_NAME($2));')dnl

define(`IntType', `ifdef(`PNETCDF',`MPI_Offset',`size_t')')dnl
define(`PTRDType',`ifdef(`PNETCDF',`MPI_Offset',`ptrdiff_t')')dnl
define(`TestFunc',`ifdef(`PNETCDF',`test_ncmpi_iput_$1',`test_nc_iput_$1')')dnl
define(`APIFunc',` ifdef(`PNETCDF',`ncmpi_$1',`nc_$1')')dnl

define(`FileOpen', `ifdef(`PNETCDF',`ncmpi_open(comm, $1, $2, info, &ncid)', `file_open($1, $2, &ncid)')')dnl
define(`FileCreate',`ifdef(`PNETCDF',`ncmpi_create(comm, $1, $2, info, &ncid)', `file_create($1, $2, &ncid)')')dnl
define(`FileDelete',`ifdef(`PNETCDF',`ncmpi_delete($1,$2)',`nc_delete($1)')')dnl

define(`VarArgs',   `ifdef(`PNETCDF',`int numVars',`void')')dnl
define(`AttVarArgs',`ifdef(`PNETCDF',`int numGatts,int numVars',`void')')dnl

define(`iPutVar1',`ifdef(`PNETCDF',`ncmpi_iput_var1_$1',`nc_iput_var1_$1')')dnl
define(`iPutVar', `ifdef(`PNETCDF',`ncmpi_iput_var_$1', `nc_iput_var_$1')')dnl
define(`iPutVara',`ifdef(`PNETCDF',`ncmpi_iput_vara_$1',`nc_iput_vara_$1')')dnl
define(`iPutVars',`ifdef(`PNETCDF',`ncmpi_iput_vars_$1',`nc_iput_vars_$1')')dnl
define(`iPutVarm',`ifdef(`PNETCDF',`ncmpi_iput_varm_$1',`nc_iput_varm_$1')')dnl
define(`DefVars',`ifdef(`PNETCDF',`def_vars($1,$2)',`def_vars($1)')')dnl

undefine(`index')dnl
dnl dnl dnl
dnl
dnl Macros
dnl
dnl dnl dnl
dnl
dnl Upcase(str)
dnl
define(`Upcase',dnl
`dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)')dnl
dnl dnl dnl
dnl
dnl NCT_ITYPE(type)
dnl
define(`NCT_ITYPE', ``NCT_'Upcase($1)')dnl
dnl

define(`CheckText', `ifelse(`$1',`text', , `== (NCT_ITYPE($1) == NCT_TEXT)')')dnl
define(`IfCheckTextChar', `ifelse(`$1',`text', `if ($2 != NC_CHAR)')')dnl
define(`CheckNumRange',
       `ifelse(`$1',`text', `1',
               `inRange3(cdf_format, $2,$3,NCT_ITYPE($1)) && ($2 >= (double)$1_min && $2 <= (double)$1_max)')')dnl
define(`CheckRange3',
       `ifelse(`$1',`text', `1',
               `inRange3(cdf_format, $2,$3,NCT_ITYPE($1))')')dnl


#include "tests.h"

static double
hash2nc(const nc_type xtype, int v_rank, MPI_Offset *index)
{
    double min;
    double max;

    switch (xtype) {
        /* no type conversion will happen for NC_CHAR, use in-memory limits */
        case NC_CHAR:   min = CHAR_MIN;     max = (double)CHAR_MAX;     break;
        case NC_BYTE:   min = X_BYTE_MIN;   max = (double)X_BYTE_MAX;   break;
        case NC_SHORT:  min = X_SHORT_MIN;  max = (double)X_SHORT_MAX;  break;
        case NC_INT:    min = X_INT_MIN;    max = (double)X_INT_MAX;    break;
        case NC_FLOAT:  min = X_FLOAT_MIN;  max = (double)X_FLOAT_MAX;  break;
        case NC_DOUBLE: min = X_DOUBLE_MIN; max = (double)X_DOUBLE_MAX; break;
        case NC_UBYTE:  min = 0;            max = (double)X_UCHAR_MAX;  break;
        case NC_USHORT: min = 0;            max = (double)X_USHORT_MAX; break;
        case NC_UINT:   min = 0;            max = (double)X_UINT_MAX;   break;
        case NC_INT64:  min = X_INT64_MIN;  max = (double)X_INT64_MAX;  break;
        case NC_UINT64: min = 0;            max = (double)X_UINT64_MAX; break;
        default:
            return NC_EBADTYPE;
    }

    return MAX(min, MIN(max, hash(xtype, v_rank, index)));
}

static int
dbls2ncs(size_t nels, int xtype, double *inBuf, void *outBuf)
{
    size_t i;
    char *p = (char*)outBuf;
    for (i=0; i<nels; i++) {
        switch (xtype) {
            case NC_CHAR:   {char      a = inBuf[i]; memcpy(p, &a, 1); break;}
            case NC_BYTE:   {schar     a = inBuf[i]; memcpy(p, &a, 1); break;}
            case NC_SHORT:  {short     a = inBuf[i]; memcpy(p, &a, 2); break;}
            case NC_INT:    {int       a = inBuf[i]; memcpy(p, &a, 4); break;}
            case NC_FLOAT:  {float     a = inBuf[i]; memcpy(p, &a, 4); break;}
            case NC_DOUBLE: {double    a = inBuf[i]; memcpy(p, &a, 8); break;}
            case NC_UBYTE:  {uchar     a = inBuf[i]; memcpy(p, &a, 1); break;}
            case NC_USHORT: {ushort    a = inBuf[i]; memcpy(p, &a, 2); break;}
            case NC_UINT:   {uint      a = inBuf[i]; memcpy(p, &a, 4); break;}
            case NC_INT64:  {longlong  a = inBuf[i]; memcpy(p, &a, 8); break;}
            case NC_UINT64: {ulonglong a = inBuf[i]; memcpy(p, &a, 8); break;}
            default:
                return NC_EBADTYPE;
        }
        p += sizeof_nctype(xtype);
    }
    return NC_NOERR;
}

int
TestFunc(var1)(VarArgs)
{
    int i, err, ncid, nok=0, reqid, status;
    IntType j, index[MAX_RANK];
    MPI_Datatype datatype;
    double value[1];

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iput_var1)(BAD_ID, 0, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iput_var1)(ncid, BAD_VARID, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = APIFunc(iput_var1)(BAD_ID, i, NULL, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = APIFunc(iput_var1)(ncid, i, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            index[j] = var_shape[i][j]; /* out of boundary check */
            err = APIFunc(iput_var1)(ncid, i, index, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            index[j] = 0;
        }

        for (j = 0; j < var_nels[i]; j++) {
            double buf;
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            value[0] = hash2nc(var_type[i], var_rank[i], index);
            err = dbl2nc(value[0], var_type[i], &buf);
            IF (err != NC_NOERR)
                error("error in dbl2nc");

            err = APIFunc(iput_var1)(ncid, i, index, &buf, 1, datatype, &reqid);
            IF (err != NC_NOERR)
                error("iput_var1: %s", APIFunc(strerror)(err));
            ELSE_NOK

            err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
            assert(err == status);
            IF (err != NC_NOERR)
                error("wait_all: err=%s", APIFunc(strerror)(err));
            else IF (status != NC_NOERR)
                error("wait_all: status=%s", APIFunc(strerror)(status));
            ELSE_NOK
        }
    }

    nok += check_vars(ncid, numVars);

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}

dnl
define(`TEST_NC_IPUT_VAR1',dnl
`dnl
int
TestFunc(var1)_$1(VarArgs)
{
    int i, err, ncid, cdf_format, nok=0, reqid, status;
    int canConvert;      /* Both text or both numeric */
    IntType j, index[MAX_RANK];
    $1 value[1];
    int bb_enabled=0;


    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    {
        int flag;
        char hint[MPI_MAX_INFO_VAL];
        MPI_Info infoused;

        ncmpi_inq_file_info(ncid, &infoused);
        MPI_Info_get(infoused, "nc_burst_buf", MPI_MAX_INFO_VAL - 1, hint, &flag);
        if (flag && strcasecmp(hint, "enable") == 0)
            bb_enabled = 1;
        MPI_Info_free(&infoused);
    }

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR)
        error("inq_format: %s", APIFunc(strerror)(err));

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iPutVar1($1)(BAD_ID, 0, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iPutVar1($1)(ncid, BAD_VARID, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = iPutVar1($1)(BAD_ID, i, NULL, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = iPutVar1($1)(ncid, i, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK
')dnl

        /* test NC_EINVALCOORDS */
        for (j = 0; j < var_rank[i]; j++) index[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            index[j] = var_shape[i][j]; /* out of boundary check */
            err = iPutVar1($1)(ncid, i, index, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                index[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            index[j] = 0;
        }

        for (j = 0; j < var_nels[i]; j++) {
            ifelse(`$1',`text',,`$1 orig_value;')
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            if (canConvert)
                value[0] = hash_$1(cdf_format, var_type[i], var_rank[i], index,
                                   NCT_ITYPE($1));
            ifelse(`$1',`text',,`orig_value = value[0];')
            err = iPutVar1($1)(ncid, i, index, value, &reqid);
            if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
                error("iPutVar1($1): %s", APIFunc(strerror)(err));
            if (err == NC_NOERR || err == NC_ERANGE) {
                /* NF_ERANGE is not a fatal error, still call wait
                 * Flush the burst buffer to reveal potential error
                 */
                int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                if (bb_enabled)
                    err = err_w;
                else if (err_w != NC_NOERR)
                    error("wait_all: err=%s", APIFunc(strerror)(err));
            }
            if (canConvert) {
                if (CheckRange3($1, orig_value, var_type[i])) {
                    IF (err != NC_NOERR)
                        error("%s", APIFunc(strerror)(err));
                } else {
                    IF (err != NC_ERANGE) {
                        EXPECT_ERR(NC_ERANGE, err)
                        error("\n\t\tfor type %s value %.17e %ld",
                                s_nc_type(var_type[i]),
                                (double)value[0], (long)value[0]);
                    }
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            }
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    nok += check_vars_$1(scratch, numVars);

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_IPUT_VAR1(text)
TEST_NC_IPUT_VAR1(uchar)
TEST_NC_IPUT_VAR1(schar)
TEST_NC_IPUT_VAR1(short)
TEST_NC_IPUT_VAR1(int)
TEST_NC_IPUT_VAR1(long)
TEST_NC_IPUT_VAR1(float)
TEST_NC_IPUT_VAR1(double)
TEST_NC_IPUT_VAR1(ushort)
TEST_NC_IPUT_VAR1(uint)
TEST_NC_IPUT_VAR1(longlong)
TEST_NC_IPUT_VAR1(ulonglong)

int
TestFunc(var)(VarArgs)
{
    int i, err, ncid, varid, nok=0, reqid, status;
    IntType j, index[MAX_RANK];
    MPI_Datatype datatype;
    double value[MAX_NELS], ncbuf[MAX_NELS];

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iput_var)(BAD_ID, 0, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iput_var)(ncid, BAD_VARID, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    /* Because var API is writing the entire variables. We need at first
     * make sure there are non-zero records to write */

    /* Write record number NRECS to force writing of preceding records */
    /* Assumes variable cr is char vector with UNLIMITED dimension */
    err = APIFunc(inq_varid)(ncid, "cr", &varid);
    IF (err != NC_NOERR)
        error("inq_varid: %s", APIFunc(strerror)(err));
    index[0] = NRECS-1;
    err = APIFunc(iput_var1_text)(ncid, varid, index, "x", &reqid);
    IF (err != NC_NOERR)
        error("iput_var1_text: %s", APIFunc(strerror)(err));
    err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
    assert(err == status);
    IF (err != NC_NOERR)
        error("wait_all: %s", APIFunc(strerror)(err));

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = APIFunc(iput_var)(BAD_ID, i, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != 0) error("error in toMixedBase");
            ncbuf[j] = hash2nc(var_type[i], var_rank[i], index);
        }
        /* type convert ncbuf[] to value[] */
        err = dbls2ncs(var_nels[i], var_type[i], ncbuf, value);
        IF (err != NC_NOERR)
            error("error in dbls2ncs");

        err = APIFunc(iput_var)(ncid, i, value, var_nels[i], datatype, &reqid);
        IF (err != NC_NOERR)
            error("iput_var: %s", APIFunc(strerror)(err));
        ELSE_NOK

        err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
        assert(err == status);
        IF (err != NC_NOERR)
            error("wait_all: %s", APIFunc(strerror)(err));
        ELSE_NOK
    }

    nok += check_vars(ncid, numVars);

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}

dnl
define(`TEST_NC_IPUT_VAR',dnl
`dnl
int
TestFunc(var)_$1(VarArgs)
{
    int i, err, ncid, varid, cdf_format, nok=0, reqid, status;
    int canConvert;      /* Both text or both numeric */
    int allInExtRange=1; /* all values within external range? */
    IntType j, index[MAX_RANK];
    $1 value[MAX_NELS];
    int bb_enabled=0;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    {
        int flag;
        char hint[MPI_MAX_INFO_VAL];
        MPI_Info infoused;

        ncmpi_inq_file_info(ncid, &infoused);
        MPI_Info_get(infoused, "nc_burst_buf", MPI_MAX_INFO_VAL - 1, hint, &flag);
        if (flag && strcasecmp(hint, "enable") == 0)
            bb_enabled = 1;
        MPI_Info_free(&infoused);
    }

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR)
        error("inq_format: %s", APIFunc(strerror)(err));

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iPutVar($1)(BAD_ID, 0, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iPutVar($1)(ncid, BAD_VARID, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        if (var_dimid[i][0] == RECDIM) continue; /* fixed-size variables only */

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = iPutVar($1)(BAD_ID, i, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        if (canConvert) {
            for (allInExtRange = 1, j = 0; j < var_nels[i]; j++) {
                err = toMixedBase(j, var_rank[i], var_shape[i], index);
                IF (err != 0) error("error in toMixedBase");
                value[j]= hash_$1(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_ITYPE($1));
                IfCheckTextChar($1, var_type[i])
                    allInExtRange &= inRange3(cdf_format, (double)value[j],
                                              var_type[i], NCT_ITYPE($1));
            }
        }
        err = iPutVar($1)(ncid, i, value, &reqid);
        if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
            error("iPutVar($1): %s", APIFunc(strerror)(err));
        if (err == NC_NOERR || err == NC_ERANGE) {
            /* NF_ERANGE is not a fatal error, still call wait
             * Flush the burst buffer to reveal potential error
             */
            int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
            if (bb_enabled)
                err = err_w;
            else if (err_w != NC_NOERR)
                error("wait_all: err=%s", APIFunc(strerror)(err));
        }
        if (canConvert) {
            if (allInExtRange) {
                IF (err != NC_NOERR)
                    error("%s", APIFunc(strerror)(err));
            } else {
                IF (err != NC_ERANGE) {
                    EXPECT_ERR(NC_ERANGE, err)
                    error("\n\t\tfor type %s value %.17e %ld",
                          s_nc_type(var_type[i]),
                          (double)value[0], (long)value[0]);
                }
            }
        } else {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
    }

    /* Preceeding has written nothing for record variables, now try */
    /* again with more than 0 records */

    /* Write record number NRECS to force writing of preceding records */
    /* Assumes variable cr is char vector with UNLIMITED dimension */
    err = APIFunc(inq_varid)(ncid, "cr", &varid);
    IF (err != NC_NOERR)
        error("inq_varid: %s", APIFunc(strerror)(err));
    index[0] = NRECS-1;
    err = APIFunc(iput_var1_text)(ncid, varid, index, "x", &reqid);
    IF (err != NC_NOERR)
        error("iput_var1_text: %s", APIFunc(strerror)(err));
    else {
        err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
        assert(err == status);
        IF (err != NC_NOERR)
            error("wait_all: err=%s", APIFunc(strerror)(err));
        else IF (status != NC_NOERR)
            error("wait_all: status=%s", APIFunc(strerror)(status));
    }

    for (i = 0; i < numVars; i++) {
        if (var_dimid[i][0] != RECDIM) continue;  /* only test record variables */
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        if (canConvert) {
            for (allInExtRange = 1, j = 0; j < var_nels[i]; j++) {
                err = toMixedBase(j, var_rank[i], var_shape[i], index);
                IF (err != 0) error("error in toMixedBase");
                value[j]= hash_$1(cdf_format, var_type[i], var_rank[i], index,
                                  NCT_ITYPE($1));
                IfCheckTextChar($1, var_type[i])
                    allInExtRange &= inRange3(cdf_format, (double)value[j],
                                              var_type[i], NCT_ITYPE($1));
            }
        }
        err = iPutVar($1)(ncid, i, value, &reqid);
        if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
            error("iPutVar($1): %s", APIFunc(strerror)(err));
        if (err == NC_NOERR || err == NC_ERANGE) {
            /* NF_ERANGE is not a fatal error, still call wait
             * Flush the burst buffer to reveal potential error
             */
            int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
            if (bb_enabled)
                err = err_w;
            else if (err_w != NC_NOERR)
                error("wait_all: err=%s", APIFunc(strerror)(err));
        }
        if (canConvert) {
            if (allInExtRange) {
                IF (err != NC_NOERR)
                    error("%s", APIFunc(strerror)(err));
            } else {
                IF (err != NC_ERANGE) {
                    EXPECT_ERR(NC_ERANGE, err)
                    error("\n\t\tfor type %s value %.17e %ld",
                          s_nc_type(var_type[i]),
                          (double)value[0], (long)value[0]);
                }
            }
        } else {
            IF (err != NC_ECHAR)
                EXPECT_ERR(NC_ECHAR, err)
            ELSE_NOK
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    nok += check_vars_$1(scratch, numVars);

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_IPUT_VAR(text)
TEST_NC_IPUT_VAR(uchar)
TEST_NC_IPUT_VAR(schar)
TEST_NC_IPUT_VAR(short)
TEST_NC_IPUT_VAR(int)
TEST_NC_IPUT_VAR(long)
TEST_NC_IPUT_VAR(float)
TEST_NC_IPUT_VAR(double)
TEST_NC_IPUT_VAR(ushort)
TEST_NC_IPUT_VAR(uint)
TEST_NC_IPUT_VAR(longlong)
TEST_NC_IPUT_VAR(ulonglong)

int
TestFunc(vara)(VarArgs)
{
    int i, j, k, err, ncid, nok=0, nslabs, reqid, status;
    double value[MAX_NELS], ncbuf[MAX_NELS];
    IntType start[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], index[MAX_RANK];
    MPI_Datatype datatype;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }
    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iput_vara)(BAD_ID, 0, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iput_vara)(ncid, BAD_VARID, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = APIFunc(iput_vara)(BAD_ID, i, NULL, NULL, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = APIFunc(iput_vara)(ncid, i, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = APIFunc(iput_vara)(ncid, i, start, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;
            err = APIFunc(iput_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDG, err)
            ELSE_NOK
            edge[j] = 1;
        }

        /* Check correct error returned when nothing to put, when edge[*]==0 */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == RECDIM) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_vara)(ncid, i, start, edge, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = APIFunc(iput_vara)(ncid, i, start, edge, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            IntType nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            for (j = 0; j < nels; j++) {
                int d;
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != 0) error("error in toMixedBase");
                for (d = 0; d < var_rank[i]; d++)
                    index[d] += start[d];
                ncbuf[j] = hash2nc(var_type[i], var_rank[i], index);
            }
            /* type convert ncbuf[] to value[] */
            err = dbls2ncs(nels, var_type[i], ncbuf, value);
            IF (err != NC_NOERR)
                error("error in dbls2ncs");

            err = APIFunc(iput_vara)(ncid, i, start, edge, value, nels, datatype, &reqid);
            IF (err != NC_NOERR)
                error("iput_vara: %s", APIFunc(strerror)(err));
            ELSE_NOK

            err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
            assert(err == status);
            IF (err != NC_NOERR)
                error("wait_all: err=%s", APIFunc(strerror)(err));
            else IF (status != NC_NOERR)
                error("wait_all: status=%s", APIFunc(strerror)(status));
            ELSE_NOK
        }
    }

    nok += check_vars(ncid, numVars);

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}

dnl
define(`TEST_NC_IPUT_VARA',dnl
`dnl
int
TestFunc(vara)_$1(VarArgs)
{
    int i, k, err, ncid, cdf_format, nslabs, nok=0, reqid, status;
    int canConvert;      /* Both text or both numeric */
    int allInExtRange=1; /* all values within external range? */
    IntType j;
    IntType start[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], index[MAX_RANK];
    $1 value[MAX_NELS];

    int bb_enabled=0;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    {
        int flag;
        char hint[MPI_MAX_INFO_VAL];
        MPI_Info infoused;

        ncmpi_inq_file_info(ncid, &infoused);
        MPI_Info_get(infoused, "nc_burst_buf", MPI_MAX_INFO_VAL - 1, hint, &flag);
        if (flag && strcasecmp(hint, "enable") == 0)
            bb_enabled = 1;
        MPI_Info_free(&infoused);
    }


    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR)
        error("inq_format: %s", APIFunc(strerror)(err));

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iPutVara($1)(BAD_ID, 0, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iPutVara($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = iPutVara($1)(BAD_ID, i, NULL, NULL, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = iPutVara($1)(ncid, i, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = iPutVara($1)(ncid, i, start, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iPutVara($1)(ncid, i, start, edge, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iPutVara($1)(ncid, i, start, edge, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
        }

        /* Check correct error returned when nothing to put, when edge[*]==0 */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iPutVara($1)(ncid, i, start, edge, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;     /* out of boundary check */
            err = iPutVara($1)(ncid, i, start, edge, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            IntType nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            if (canConvert) {
                for (allInExtRange = 1, j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], edge, index);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index[d] += start[d];
                    value[j]= hash_$1(cdf_format, var_type[i], var_rank[i], index,
                                      NCT_ITYPE($1));
                    IfCheckTextChar($1, var_type[i])
                        allInExtRange &= inRange3(cdf_format, (double)value[j],
                                                  var_type[i], NCT_ITYPE($1));
                }
            }
            err = iPutVara($1)(ncid, i, start, edge, value, &reqid);
            if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
                error("iPutVara($1): %s", APIFunc(strerror)(err));
            if (err == NC_NOERR || err == NC_ERANGE) {
                /* NF_ERANGE is not a fatal error, still call wait
                 * Flush the burst buffer to reveal potential error
                 */
                int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                if (bb_enabled)
                    err = err_w;
                else if (err_w != NC_NOERR)
                    error("wait_all: err=%s", APIFunc(strerror)(err));
            }
            if (canConvert) {
                if (allInExtRange) {
                    IF (err != NC_NOERR)
                        EXPECT_ERR(NC_NOERR, err)
                } else {
                    IF (err != NC_ERANGE)
                        EXPECT_ERR(NC_ERANGE, err)
                }
            } else {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
            }
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    nok += check_vars_$1(scratch, numVars);

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_IPUT_VARA(text)
TEST_NC_IPUT_VARA(uchar)
TEST_NC_IPUT_VARA(schar)
TEST_NC_IPUT_VARA(short)
TEST_NC_IPUT_VARA(int)
TEST_NC_IPUT_VARA(long)
TEST_NC_IPUT_VARA(float)
TEST_NC_IPUT_VARA(double)
TEST_NC_IPUT_VARA(ushort)
TEST_NC_IPUT_VARA(uint)
TEST_NC_IPUT_VARA(longlong)
TEST_NC_IPUT_VARA(ulonglong)

int
TestFunc(vars)(VarArgs)
{
    int i, j, k, err, ncid, nok=0, nslabs, reqid, status;
    double value[MAX_NELS], ncbuf[MAX_NELS];
    IntType start[MAX_RANK], index[MAX_RANK], index2[MAX_RANK];
    IntType count[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], sstride[MAX_RANK];
    PTRDType stride[MAX_RANK];
    MPI_Datatype datatype;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }
    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iput_vars)(BAD_ID, 0, NULL, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iput_vars)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = APIFunc(iput_vars)(BAD_ID, i, NULL, NULL, NULL, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = APIFunc(iput_vars)(ncid, i, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = APIFunc(iput_vars)(ncid, i, start, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = APIFunc(iput_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDG, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;  /* strided edge error check */
            err = APIFunc(iput_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check correct error returned even when nothing to put */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_vars)(ncid, i, start, edge, stride, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = APIFunc(iput_vars)(ncid, i, start, edge, stride, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            IntType nstarts=1; /* number of different starts */
            int m;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                IntType nels;
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    ncbuf[j] = hash2nc(var_type[i], var_rank[i], index2);
                }
                /* type convert ncbuf[] to value[] */
                err = dbls2ncs(nels, var_type[i], ncbuf, value);
                IF (err != NC_NOERR)
                    error("error in dbls2ncs");

                err = APIFunc(iput_vars)(ncid, i, index, count, stride, value, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    EXPECT_ERR(NC_NOERR, err)
                ELSE_NOK

                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR)
                    error("wait_all: err=%s", APIFunc(strerror)(err));
                else IF (status != NC_NOERR)
                    error("wait_all: status=%s", APIFunc(strerror)(status));
                ELSE_NOK
            }
        }
    }

    nok += check_vars(ncid, numVars);

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}

dnl
define(`TEST_NC_IPUT_VARS',dnl
`dnl
int
TestFunc(vars)_$1(VarArgs)
{
    int i, k, err, ncid, cdf_format, nslabs, nok=0, reqid, status;
    int canConvert;      /* Both text or both numeric */
    int allInExtRange=1; /* all values within external range? */
    IntType j;
    IntType start[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], count[MAX_RANK], sstride[MAX_RANK];
    PTRDType stride[MAX_RANK];
    $1 value[MAX_NELS];
    int bb_enabled=0;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    {
        int flag;
        char hint[MPI_MAX_INFO_VAL];
        MPI_Info infoused;

        ncmpi_inq_file_info(ncid, &infoused);
        MPI_Info_get(infoused, "nc_burst_buf", MPI_MAX_INFO_VAL - 1, hint, &flag);
        if (flag && strcasecmp(hint, "enable") == 0)
            bb_enabled = 1;
        MPI_Info_free(&infoused);
    }

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR)
        error("inq_format: %s", APIFunc(strerror)(err));

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iPutVars($1)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iPutVars($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = iPutVars($1)(BAD_ID, i, NULL, NULL, NULL, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = iPutVars($1)(ncid, i, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = iPutVars($1)(ncid, i, start, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j]; /* out of boundary check */
            err = iPutVars($1)(ncid, i, start, edge, stride, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iPutVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;  /* strided edge error check */
            err = iPutVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }

        /* Check correct error returned when nothing to put, when edge[*]==0 */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iPutVars($1)(ncid, i, start, edge, stride, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;     /* out of boundary check */
            err = iPutVars($1)(ncid, i, start, edge, stride, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            int m;
            IntType nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                IntType nels;
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                for (nels=1, j=0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                if (canConvert) {
                    for (allInExtRange = 1, j = 0; j < nels; j++) {
                        int d;
                        err = toMixedBase(j, var_rank[i], count, index2);
                        IF (err != 0) error("error in toMixedBase");
                        for (d = 0; d < var_rank[i]; d++)
                            index2[d] = index[d] + index2[d] * stride[d];
                        value[j] = hash_$1(cdf_format, var_type[i], var_rank[i],
                                           index2, NCT_ITYPE($1));
                        IfCheckTextChar($1, var_type[i])
                            allInExtRange &= inRange3(cdf_format, (double)value[j],
                                                      var_type[i], NCT_ITYPE($1));
                    }
                }
                err = iPutVars($1)(ncid, i, index, count, stride, value, &reqid);
                if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
                    error("iPutVars($1): %s", APIFunc(strerror)(err));
                if (err == NC_NOERR || err == NC_ERANGE) {
                    /* NF_ERANGE is not a fatal error, still call wait
                     * Flush the burst buffer to reveal potential error
                     */
                    int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                    if (bb_enabled)
                        err = err_w;
                    else if (err_w != NC_NOERR)
                        error("wait_all: err=%s", APIFunc(strerror)(err));
                }
                if (canConvert) {
                    if (allInExtRange) {
                        IF (err != NC_NOERR)
                            error("%s", APIFunc(strerror)(err));
                    } else {
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                    ELSE_NOK
                }
            }
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    nok += check_vars_$1(scratch, numVars);

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_IPUT_VARS(text)
TEST_NC_IPUT_VARS(uchar)
TEST_NC_IPUT_VARS(schar)
TEST_NC_IPUT_VARS(short)
TEST_NC_IPUT_VARS(int)
TEST_NC_IPUT_VARS(long)
TEST_NC_IPUT_VARS(float)
TEST_NC_IPUT_VARS(double)
TEST_NC_IPUT_VARS(ushort)
TEST_NC_IPUT_VARS(uint)
TEST_NC_IPUT_VARS(longlong)
TEST_NC_IPUT_VARS(ulonglong)

int
TestFunc(varm)(VarArgs)
{
    int i, j, k, err, ncid, nok=0, nslabs, reqid, status;
    double value[MAX_NELS], ncbuf[MAX_NELS];
    IntType start[MAX_RANK], index[MAX_RANK], index2[MAX_RANK];
    IntType count[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], sstride[MAX_RANK];
    PTRDType stride[MAX_RANK], imap[MAX_RANK];
    MPI_Datatype datatype;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }
    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = APIFunc(iput_varm)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = APIFunc(iput_varm)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL, 1, MPI_DATATYPE_NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = APIFunc(iput_varm)(BAD_ID, i, NULL, NULL, NULL, NULL, value, 1, MPI_DATATYPE_NULL, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        datatype = nc_mpi_type(var_type[i]);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = APIFunc(iput_varm)(ncid, i, NULL, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = APIFunc(iput_varm)(ncid, i, start, NULL, NULL, NULL, value, 1, datatype, &reqid);
        if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = APIFunc(iput_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDG, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;  /* strided edge error check */
            err = APIFunc(iput_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check correct error returned even when nothing to put */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = APIFunc(iput_varm)(ncid, i, start, edge, stride, imap, value, 0, datatype, &reqid);
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1; /* out of boundary check */
            err = APIFunc(iput_varm)(ncid, i, start, edge, stride, imap, value, 1, datatype, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            IntType nstarts=1; /* number of different starts */
            int m;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                IntType nels;
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                for (j = 0; j < nels; j++) {
                    int d;
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != 0) error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    ncbuf[j] = hash2nc(var_type[i], var_rank[i], index2);
                }
                /* type convert ncbuf[] to value[] */
                err = dbls2ncs(nels, var_type[i], ncbuf, value);
                IF (err != NC_NOERR)
                    error("error in dbls2ncs");

                err = APIFunc(iput_varm)(ncid, i, index, count, stride, imap, value, nels, datatype, &reqid);
                IF (err != NC_NOERR)
                    error("iput_varm: %s", APIFunc(strerror)(err));
                ELSE_NOK

                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR)
                    error("wait_all: err=%s", APIFunc(strerror)(err));
                else IF (status != NC_NOERR)
                    error("wait_all: status=%s", APIFunc(strerror)(status));
                ELSE_NOK
            }
        }
    }

    nok += check_vars(ncid, numVars);

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}

dnl
define(`TEST_NC_IPUT_VARM',dnl
`dnl
int
TestFunc(varm)_$1(VarArgs)
{
    int i, k, err, ncid, cdf_format, nslabs, nok=0, reqid, status;
    int canConvert;      /* Both text or both numeric */
    int allInExtRange=1; /* all values within external range? */
    IntType j;
    IntType start[MAX_RANK], edge[MAX_RANK], mid[MAX_RANK], index[MAX_RANK];
    IntType index2[MAX_RANK], count[MAX_RANK], sstride[MAX_RANK];
    PTRDType stride[MAX_RANK], imap[MAX_RANK];
    $1 value[MAX_NELS];
    int bb_enabled=0;

    err = FileCreate(scratch, NC_CLOBBER);
    IF (err != NC_NOERR) {
        error("create: %s", APIFunc(strerror)(err));
        return nok;
    }

    {
        int flag;
        char hint[MPI_MAX_INFO_VAL];
        MPI_Info infoused;

        ncmpi_inq_file_info(ncid, &infoused);
        MPI_Info_get(infoused, "nc_burst_buf", MPI_MAX_INFO_VAL - 1, hint, &flag);
        if (flag && strcasecmp(hint, "enable") == 0)
            bb_enabled = 1;
        MPI_Info_free(&infoused);
    }

    err = APIFunc(inq_format)(ncid, &cdf_format);
    IF (err != NC_NOERR)
        error("inq_format: %s", APIFunc(strerror)(err));

    def_dims(ncid);
    DefVars(ncid, numVars);

    err = APIFunc(enddef)(ncid);
    IF (err != NC_NOERR)
        error("enddef: %s", APIFunc(strerror)(err));

    /* check if can detect a bad file ID */
    err = iPutVarm($1)(BAD_ID, 0, NULL, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_EBADID)
        EXPECT_ERR(NC_EBADID, err)
    ELSE_NOK

    /* check if can detect a bad variable ID */
    err = iPutVarm($1)(ncid, BAD_VARID, NULL, NULL, NULL, NULL, NULL, NULL);
    IF (err != NC_ENOTVAR)
        EXPECT_ERR(NC_ENOTVAR, err)
    ELSE_NOK

    for (i = 0; i < numVars; i++) {
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);

        value[0] = 5;  /* reset to a value within bounds */

        /* check if can detect a bad file ID */
        err = iPutVarm($1)(BAD_ID, i, NULL, NULL, NULL, NULL, value, NULL);
        IF (err != NC_EBADID)
            EXPECT_ERR(NC_EBADID, err)
        ELSE_NOK

        canConvert = (var_type[i] == NC_CHAR) CheckText($1);

        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }

ifdef(`PNETCDF',`dnl
        /* for non-scalar variables, argument start cannot be NULL */
        err = iPutVarm($1)(ncid, i, NULL, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) { /* scalar variable */
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EINVALCOORDS) {
            EXPECT_ERR(NC_EINVALCOORDS, err)
        }
        ELSE_NOK

        /* for non-scalar variables, argument count cannot be NULL */
        err = iPutVarm($1)(ncid, i, start, NULL, NULL, NULL, value, &reqid);
        if (!canConvert) {
            IF (err != NC_ECHAR) EXPECT_ERR(NC_ECHAR, err)
        }
        else if (var_rank[i] == 0) {
            IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            else {
                err = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                assert(err == status);
                IF (err != NC_NOERR) EXPECT_ERR(NC_NOERR, err)
            }
        }
        else IF (err != NC_EEDGE) {
            EXPECT_ERR(NC_EEDGE, err)
        }
        ELSE_NOK
')dnl

        /* first test when edge[*] > 0 */
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j]; /* out of boundary check */
            err = iPutVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
            edge[j] = var_shape[i][j] + 1;  /* edge error check */
            err = iPutVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_EEDGE)
                EXPECT_ERR(NC_EEDGE, err)
            ELSE_NOK
            edge[j] = 1;
            stride[j] = 0;  /* strided edge error check */
            err = iPutVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_ESTRIDE)
                EXPECT_ERR(NC_ESTRIDE, err)
            ELSE_NOK
            stride[j] = 1;
        }
        /* Check correct error returned even when nothing to put */
        for (j = 0; j < var_rank[i]; j++) edge[j] = 0;

        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] == 0) continue; /* skip record dim */
            start[j] = var_shape[i][j];
            err = iPutVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            if (!canConvert) {
                IF (err != NC_ECHAR)
                    EXPECT_ERR(NC_ECHAR, err)
                ELSE_NOK
                start[j] = 0;
                continue;
            }
#ifndef RELAX_COORD_BOUND
            IF (err != NC_EINVALCOORDS) /* not allowed even when edge[j]==0 */
                EXPECT_ERR(NC_EINVALCOORDS, err)
#else
            IF (err != NC_NOERR) /* allowed when edge[j]==0 */
                EXPECT_ERR(NC_NOERR, err)
#endif
            ELSE_NOK
            start[j] = var_shape[i][j]+1;     /* out of boundary check */
            err = iPutVarm($1)(ncid, i, start, edge, stride, imap, value, &reqid);
            IF (err != NC_EINVALCOORDS)
                EXPECT_ERR(NC_EINVALCOORDS, err)
            ELSE_NOK
            start[j] = 0;
        }
        for (j = 0; j < var_rank[i]; j++) edge[j] = 1;

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            int m;
            IntType nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                IntType nels;
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != 0) error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                if (canConvert) {
                    for (allInExtRange = 1, j = 0; j < nels; j++) {
                        int d;
                        err = toMixedBase(j, var_rank[i], count, index2);
                        IF (err != 0) error("error in toMixedBase");
                        for (d = 0; d < var_rank[i]; d++)
                            index2[d] = index[d] + index2[d] * stride[d];
                        value[j] = hash_$1(cdf_format, var_type[i], var_rank[i],
                                           index2, NCT_ITYPE($1));
                        IfCheckTextChar($1, var_type[i])
                            allInExtRange &= inRange3(cdf_format, (double)value[j],
                                                      var_type[i], NCT_ITYPE($1));
                    }
                }
                err = iPutVarm($1)(ncid, i, index, count, stride, imap, value, &reqid);
                if (bb_enabled && err != NC_ECHAR && err != NC_NOERR)
                    error("iPutVarm($1): %s", APIFunc(strerror)(err));
                if (err == NC_NOERR || err == NC_ERANGE) {
                    /* NF_ERANGE is not a fatal error, still call wait
                     * Flush the burst buffer to reveal potential error
                     */
                    int err_w = APIFunc(wait_all)(ncid, 1, &reqid, &status);
                    if (bb_enabled)
                        err = err_w;
                    else if (err_w != NC_NOERR)
                        error("wait_all: err=%s", APIFunc(strerror)(err));
                }
                if (canConvert) {
                    if (allInExtRange) {
                        IF (err != NC_NOERR)
                            error("%s", APIFunc(strerror)(err));
                    } else {
                        IF (err != NC_ERANGE)
                            EXPECT_ERR(NC_ERANGE, err)
                    }
                } else {
                    IF (err != NC_ECHAR)
                        EXPECT_ERR(NC_ECHAR, err)
                    ELSE_NOK
                }
            }
        }
    }

    err = APIFunc(close)(ncid);
    IF (err != NC_NOERR)
        error("close: %s", APIFunc(strerror)(err));

    nok += check_vars_$1(scratch, numVars);

    err = FileDelete(scratch, info);
    IF (err != NC_NOERR)
        error("delete file %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_IPUT_VARM(text)
TEST_NC_IPUT_VARM(uchar)
TEST_NC_IPUT_VARM(schar)
TEST_NC_IPUT_VARM(short)
TEST_NC_IPUT_VARM(int)
TEST_NC_IPUT_VARM(long)
TEST_NC_IPUT_VARM(float)
TEST_NC_IPUT_VARM(double)
TEST_NC_IPUT_VARM(ushort)
TEST_NC_IPUT_VARM(uint)
TEST_NC_IPUT_VARM(longlong)
TEST_NC_IPUT_VARM(ulonglong)

