/* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

/*! \file wizard.h
	\brief Zarządzanie czarodziejem
*/

#ifndef __LW_WIZARD_H
#define __LW_WIZARD_H

#include <libxml/tree.h>

enum LWDirection {
LW_DIRECTION_EAST=0,
LW_DIRECTION_SOUTH=1,
LW_DIRECTION_WEST=2,
LW_DIRECTION_NORTH=3
};

enum LWTurn {
LW_TURN_LEFT=0,
LW_TURN_RIGHT=1
};

class LWPiece;
class LWBoard;
class LWPixmap;
class LWValue;

/*! \class LWWizard
	\brief Zarządzanie czarodziejem

	Klasa zarządzająca czarodziejem
*/
class LWWizard {
private:
gboolean visibility;
gdouble sleep_time;
LWDirection direction;
LWPiece *piece;
LWPixmap *direction_pixmaps[4];
gboolean inverted_grounds;
LWPiece *getPieceNth (gint n);
gboolean createOne (LWPixmap *pixmap, gint n);
public:
LWWizard (LWPiece *a_piece);
LWWizard (const LWWizard *wizard, LWBoard *board);
~LWWizard ();
void restoreFromXML (xmlNode *node);
void setDirection (LWDirection a_direction);
void turn (LWTurn turn);
LWDirection getDirection ();
void setSpeed (gint speed);
guint getPauseTime ();
void hide ();
void show ();
void create (LWValue *value);
gboolean isCreatingPossible ();
gboolean stepForward ();
gboolean stepBack ();
void setPiece (LWPiece *piece);
LWPiece *getPiece ();
void enableInvertedGrounds (gboolean inverted);
LWPixmap *getDirectionPixmap (LWDirection a_direction);
};

#include "piece.h"
#include "value.h"

#endif
