var win = window,
    doc = win.document,
    fromCharCode = String.fromCharCode,
    push = Array.prototype.push,
    min = Math.min,
    max = Math.max;

Gordon = {
    debug: false,
    qualityValues: {
        LOW: "low",
        AUTO_LOW: "autolow",
        AUTO_HIGH: "autohigh",
        MEDIUM: "medium",
        HIGH: "high",
        BEST: "best"
    },
    scaleValues: {
        SHOW_ALL: "showall",
        NO_ORDER: "noorder",
        EXACT_FIT: "exactfit"
    },
    validSignatures: {
        SWF: "FWS",
        COMPRESSED_SWF: "CWS"
    },
    readyStates: {
        LOADING: 0,
        UNINITIALIZED: 1,
        LOADED: 2,
        INTERACTIVE: 3,
        COMPLETE: 4
    },
    tagCodes: {
        END: 0,
        SHOW_FRAME: 1,
        DEFINE_SHAPE: 2,
        PLACE_OBJECT: 4,
        REMOVE_OBJECT: 5,
        DEFINE_BITS: 6,
        DEFINE_BUTTON: 7,
        JPEG_TABLES: 8,
        SET_BACKGROUND_COLOR: 9,
        DEFINE_FONT: 10,
        DEFINE_TEXT: 11,
        DO_ACTION: 12,
        DEFINE_FONT_INFO: 13,
        DEFINE_SOUND: 14,
        START_SOUND: 15,
        DEFINE_BUTTON_SOUND: 17,
        SOUND_STREAM_HEAD: 18,
        SOUND_STREAM_BLOCK: 19,
        DEFINE_BITS_LOSSLESS: 20,
        DEFINE_BITS_JPEG2: 21,
        DEFINE_SHAPE2: 22,
        DEFINE_BUTTON_CXFORM: 23,
        PROTECT: 24,
        PLACE_OBJECT2: 26,
        REMOVE_OBJECT2: 28,
        DEFINE_SHAPE3: 32,
        DEFINE_TEXT2: 33,
        DEFINE_BUTTON2: 34,
        DEFINE_BITS_JPEG3: 35,
        DEFINE_BITS_LOSSLESS2: 36,
        DEFINE_EDIT_TEXT: 37,
        DEFINE_SPRITE: 39,
        FRAME_LABEL: 43,
        SOUND_STREAM_HEAD2: 45,
        DEFINE_MORPH_SHAPE: 46,
        DEFINE_FONT2: 48,
        EXPORT_ASSETS: 56,
        IMPORT_ASSETS: 57,
        ENABLE_DEBUGGER: 58,
        DO_INIT_ACTION: 59,
        DEFINE_VIDEO_STREAM: 60,
        VIDEO_FRAME: 61,
        DEFINE_FONT_INFO2: 62,
        ENABLE_DEBUGGER2: 64,
        SCRIPT_LIMITS: 65,
        SET_TAB_INDEX: 66,
        FILE_ATTRIBUTES: 69,
        PLACE_OBJECT3: 70,
        IMPORT_ASSETS2: 71,
        DEFINE_FONT_ALIGN_ZONES: 73,
        CSM_TEXT_SETTINGS: 74,
        DEFINE_FONT3: 75,
        SYMBOL_CLASS: 76,
        METADATA: 77,
        DEFINE_SCALING_GRID: 78,
        DO_ABC: 82,
        DEFINE_SHAPE4: 83,
        DEFINE_MORPH_SHAPE2: 84,
        DEFINE_SCENE_AND_FRAME_LABEL_DATA: 86,
        DEFINE_BINARY_DATA: 87,
        DEFINE_FONT_NAME: 88,
        START_SOUND2: 89,
        DEFINE_BITS_JPEG4: 90,
        DEFINE_FONT4: 91
    },
    controlTags: [0, 1, 4, 5, 15, 18, 19, 26, 28, 43, 45],
    tagNames: {},
    tagHandlers: {},
    fillStyleTypes: {
        SOLID: 0x00, 
        LINEAR_GRADIENT: 0x10, 
        RADIAL_GRADIENT: 0x12,
        FOCAL_RADIAL_GRADIENT: 0x13,
        REPEATING_BITMAP: 0x40, 
        CLIPPED_BITMAP: 0x41, 
        NON_SMOOTHED_REPEATING_BITMAP: 0x42,
        NON_SMOOTHED_CLIPPED_BITMAP: 0x43
    },
    spreadModes: {
        PAD: 0,
        REFLECT: 1,
        REPEAT: 2
    },
    interpolationModes: {
        RGB: 0,
        LINEAR_RGB: 1
    },
    styleChangeStates: {
        MOVE_TO: 0x01,
        LEFT_FILL_STYLE: 0x02,
        RIGHT_FILL_STYLE: 0x04,
        LINE_STYLE: 0x08,
        NEW_STYLES: 0x10
    },
    buttonStates: {
        UP: 0x01,
        OVER: 0x02,
        DOWN: 0x04,
        HIT: 0x08
    },
    mouseButtons: {
        LEFT: 1,
        RIGHT: 2,
        MIDDLE: 3
    },
    textStyleFlags: {
        HAS_FONT: 0x08,
        HAS_COLOR: 0x04,
        HAS_XOFFSET: 0x01,
        HAS_YOFFSET: 0x02
    },
    actionCodes: {
        NEXT_FRAME: 0x04,
        PREVIOUS_FRAME: 0x05,
        PLAY: 0x06,
        STOP: 0x07,
        TOGGLE_QUALITY: 0x08,
        STOP_SOUNDS: 0x09,
        ADD: 0x0a,
        SUBTRACT: 0x0b,
        MULTIPLY: 0x0c,
        DIVIDE: 0x0d,
        EQUALS: 0x0e,
        LESS: 0x0f,
        AND: 0x10,
        OR: 0x11,
        NOT: 0x12,
        STRING_EQUALS: 0x13,
        STRING_LENGTH: 0x14,
        STRING_EXTRACT: 0x15,
        POP: 0x17,
        TO_INTEGER: 0x18,
        GET_VARIABLE: 0x1c,
        SET_VARIABLE: 0x1d,
        SET_TARGET2: 0x20,
        STRING_ADD: 0x21,
        GET_PROPERTY: 0x22,
        SET_PROPERTY: 0x23,
        CLONE_SPRITE: 0x24,
        REMOVE_SPRITE: 0x25,
        TRACE: 0x26,
        START_DRAG: 0x27,
        END_DRAG: 0x28,
        STRING_LESS: 0x29,
        THROW: 0x2a,
        CAST_OP: 0x2b,
        IMPLEMENTS_OP: 0x2c,
        FS_COMMAND2: 0x2d,
        RANDOM_NUMBER: 0x30,
        MBSTRING_LENGTH: 0x31,
        CHAR_TO_ASCII: 0x32,
        ASCII_TO_CHAR: 0x33,
        GET_TIME: 0x34,
        MBSTRING_EXTRACT: 0x35,
        MBCHAR_TO_ASCII: 0x36,
        MBASCII_TO_CHAR: 0x37,
        DELETE: 0x3a,
        DELETE2: 0x3b,
        DEFINE_LOCAL: 0x3c,
        CALL_FUNCTION: 0x3d,
        RETURN: 0x3e,
        MODULO: 0x3f,
        NEW_OBJECT: 0x40,
        DEFINE_LOCAL2: 0x41,
        INIT_ARRAY: 0x42,
        INIT_OBJECT: 0x43,
        TYPE_OF: 0x44,
        TARGET_PATH: 0x45,
        ENUMERATE: 0x46,
        ADD2: 0x47,
        LESS2: 0x48,
        EQUALS2: 0x49,
        TO_NUMBER: 0x4a,
        TO_STRING: 0x4b,
        PUSH_DUPLICATE: 0x4c,
        STACK_SWAP: 0x4d,
        GET_MEMBER: 0x4e,
        SET_MEMBER: 0x4f,
        INCREMENT: 0x50,
        DECREMENT: 0x51,
        CALL_METHOD: 0x52,
        NEW_METHOD: 0x53,
        INSTANCE_OF: 0x54,
        ENUMERATE2: 0x55,
        DO_INIT_ACTION: 0x59,
        BIT_AND: 0x60,
        BIT_OR: 0x61,
        BIT_XOR: 0x62,
        BIT_LSHIFT: 0x63,
        BIT_RSHIFT: 0x64,
        BIT_URSHIFT: 0x65,
        STRICT_EQUALS: 0x66,
        GREATER: 0x67,
        STRING_GREATER: 0x68,
        EXTENDS: 0x69,
        GOTO_FRAME: 0x81,
        DO_ABC: 0x82,
        GET_URL: 0x83,
        STORE_REGISTER: 0x87,
        CONSTANT_POOL: 0x88,
        WAIT_FOR_FRAME: 0x8a,
        SET_TARGET: 0x8b,
        SET_GO_TO_LABEL: 0x8c,
        WAIT_FOR_FRAME2: 0x8d,
        DEFINE_FUNCTION2: 0x8e,
        TRY: 0x8f,
        WITH: 0x94,
        PUSH: 0x96,
        JUMP: 0x99,
        GET_URL2: 0x9a,
        DEFINE_FUNCTION: 0x9b,
        IF: 0x9d,
        CALL: 0x9e,
        GOTO_FRAME2: 0x9f
    },
    valueTypes: {
        STRING: 0,
        FLOATING_POINT: 1,
        NULL: 2,
        UNDEFINED: 3,
        REGISTER: 4,
        BOOLEAN: 5,
        DOUBLE: 6,
        INTEGER: 7,
        CONSTANT8: 8,
        SWIFF_CONSTANT16: 9
    },
    urlTargets: {
        SELF: "_self",
        BLANK: "_blank",
        PARENT: "_parent",
        TOP: "_top"
    },
    bitmapFormats: {
        COLORMAPPED: 3,
        RGB15: 4,
        RGB24: 5
    },
    placeFlags: {
        MOVE: 0x01,
        HAS_CHARACTER: 0x02,
        HAS_MATRIX: 0x04,
        HAS_CXFORM: 0x08,
        HAS_RATIO: 0x10,
        HAS_NAME: 0x20,
        HAS_CLIP_DEPTH: 0x40,
        HAS_CLIP_ACTIONS: 0x80
    },
    defaultRenderer: null
};

(function(){
    var t = Gordon.tagCodes,
        n = Gordon.tagNames,
        h = Gordon.tagHandlers;
    for(var name in t){
        var code = t[name];
        n[code] = name;
        h[code] = "_handle" + name.toLowerCase().replace(/(^|_)([a-z])/g, function(match, p1, p2){
            return p2.toUpperCase();
        });
    }
})();

var console = window.console || {
    log: function(){}
}

function trace(){
    if(Gordon.debug){ console.log.apply(console, arguments); }
}
