// Copyright The Notary Project Authors.
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package asn1

import (
	"encoding/asn1"
	"testing"
)

func TestEqual(t *testing.T) {
	m := asn1.RawValue{
		Tag:       asn1.TagNull,
		FullBytes: []byte{asn1.TagNull, 0},
	}
	n := asn1.NullRawValue
	n.FullBytes = []byte{asn1.TagNull, 0}

	if !EqualRawValue(m, n) {
		t.Fatal("expected to be equal")
	}

	n = asn1.NullRawValue
	if EqualRawValue(m, n) {
		t.Fatal("expected to be unequal")
	}
}
