# AMP HTML ⚡

[![Greenkeeper badge](https://badges.greenkeeper.io/ampproject/amphtml.svg)](https://greenkeeper.io/)

[AMP HTML](https://www.ampproject.org/docs/get_started/about-amp.html) is a way to build web pages that render with reliable and fast performance. It is our attempt at fixing what many perceive as painfully slow page load times – especially when reading content on the mobile web.  AMP HTML is built on existing web technologies; an AMP page will load (quickly) in any modern browser.

You can learn more at [ampproject.org](https://www.ampproject.org/) including [what AMP is](https://www.ampproject.org/learn/about-amp/), [how it works](https://www.ampproject.org/learn/how-amp-works/) and the importance of [validation in AMP](https://www.ampproject.org/docs/guides/validate).  You can also walk through [creating an AMP page](https://www.ampproject.org/docs/get_started/create) and read through the [reference docs](https://www.ampproject.org/docs/reference/components).

## We'd love your help making AMP better!

There are a lot of ways you can [contribute](CONTRIBUTING.md) to making AMP better! You can [report bugs and feature requests](CONTRIBUTING.md#reporting-issues-with-amp) or ideally become an [ongoing participant](CONTRIBUTING.md#ongoing-participation) in the AMP Project community and [contribute code to the open source project](CONTRIBUTING.md#contributing-code).

We enthusiastically welcome new contributors to the AMP Project **_even if you have no experience being part of an open source project_**.  We've got some [tips for new contributors](https://github.com/ampproject/amphtml/blob/master/CONTRIBUTING.md#tips-for-new-open-source-contributors) and guides to getting started (both a [detailed version](contributing/getting-started-e2e.md) and a [TL;DR](contributing/getting-started-quick.md)).

If you're new here, sign up for our [Slack](https://docs.google.com/forms/d/e/1FAIpQLSd83J2IZA6cdR6jPwABGsJE8YL4pkypAbKMGgUZZriU7Qu6Tg/viewform?fbzx=4406980310789882877) and say "Hi!" in the appropriately named [#welcome-contributors](https://amphtml.slack.com/messages/welcome-contributors/) channel ❤️️

## Further reading

If you are creating AMP pages,
check out the docs on [ampproject.org](https://www.ampproject.org/) and samples on [ampbyexample.com](https://ampbyexample.com/).

Reference:
* [Component reference](https://www.ampproject.org/docs/reference/components)

Resources:
* [AMP on StackOverflow](https://stackoverflow.com/questions/tagged/amp-html)
* [Release schedule](contributing/release-schedule.md)

Technical specifications:
* [Format specification](spec/amp-html-format.md)
* [Custom element specification](spec/amp-html-components.md)

## Who makes AMP HTML?

AMP HTML is made by the [AMP Project](https://www.ampproject.org/).  If you're a [contributor to the open source community](https://github.com/ampproject/amphtml/graphs/contributors) this includes you!

## Security disclosures

The AMP Project accepts responsible security disclosures through the [Google Application Security program](https://www.google.com/about/appsecurity/).

## Code of conduct

The AMP Project strives for a positive and growing project community that provides a safe environment for everyone.  All members, committers and volunteers in the community are required to act according to the [code of conduct](CODE_OF_CONDUCT.md).

## License

AMP HTML is licensed under the [Apache License, Version 2.0](LICENSE).
