//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armstoragecache_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c7f3e601fd326ca910c3d2939b516e15581e7e41/specification/storagecache/resource-manager/Microsoft.StorageCache/stable/2023-05-01/examples/AscResourceUsages_Get.json
func ExampleAscUsagesClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armstoragecache.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewAscUsagesClient().NewListPager("eastus", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ResourceUsagesListResult = armstoragecache.ResourceUsagesListResult{
		// 	Value: []*armstoragecache.ResourceUsage{
		// 		{
		// 			Name: &armstoragecache.ResourceUsageName{
		// 				LocalizedValue: to.Ptr("Cache"),
		// 				Value: to.Ptr("Cache"),
		// 			},
		// 			CurrentValue: to.Ptr[int32](1),
		// 			Limit: to.Ptr[int32](4),
		// 			Unit: to.Ptr("Count"),
		// 		},
		// 		{
		// 			Name: &armstoragecache.ResourceUsageName{
		// 				LocalizedValue: to.Ptr("AmlFilesystem"),
		// 				Value: to.Ptr("AmlFilesystem"),
		// 			},
		// 			CurrentValue: to.Ptr[int32](0),
		// 			Limit: to.Ptr[int32](4),
		// 			Unit: to.Ptr("Count"),
		// 	}},
		// }
	}
}
