//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsecurity_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Put.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_CreateOrUpdate_createABaseline() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().CreateOrUpdate(ctx, "VA1234", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions{Body: &armsecurity.RuleResultsInput{
		LatestScan: to.Ptr(false),
		Results: [][]*string{
			{
				to.Ptr("userA"),
				to.Ptr("SELECT")},
			{
				to.Ptr("userB"),
				to.Ptr("SELECT")}},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RuleResults = armsecurity.RuleResults{
	// 	Name: to.Ptr("VA1234"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 	Properties: &armsecurity.RuleResultsProperties{
	// 		Results: [][]*string{
	// 			[]*string{
	// 				to.Ptr("userA"),
	// 				to.Ptr("SELECT")},
	// 				[]*string{
	// 					to.Ptr("userB"),
	// 					to.Ptr("SELECT")}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_PutLatest.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_CreateOrUpdate_createABaselineUsingTheLatestScanResults() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().CreateOrUpdate(ctx, "VA1234", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientCreateOrUpdateOptions{Body: &armsecurity.RuleResultsInput{
		LatestScan: to.Ptr(true),
		Results:    [][]*string{},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RuleResults = armsecurity.RuleResults{
	// 	Name: to.Ptr("VA1234"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 	Properties: &armsecurity.RuleResultsProperties{
	// 		Results: [][]*string{
	// 			[]*string{
	// 				to.Ptr("userA"),
	// 				to.Ptr("SELECT")},
	// 				[]*string{
	// 					to.Ptr("userB"),
	// 					to.Ptr("SELECT")}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Get.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().Get(ctx, "VA1234", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RuleResults = armsecurity.RuleResults{
	// 	Name: to.Ptr("VA1234"),
	// 	Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 	Properties: &armsecurity.RuleResultsProperties{
	// 		Results: [][]*string{
	// 			[]*string{
	// 				to.Ptr("userA"),
	// 				to.Ptr("SELECT")},
	// 				[]*string{
	// 					to.Ptr("userB"),
	// 					to.Ptr("SELECT")}},
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Delete.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().Delete(ctx, "VA1234", "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_List.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().List(ctx, "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RulesResults = armsecurity.RulesResults{
	// 	Value: []*armsecurity.RuleResults{
	// 		{
	// 			Name: to.Ptr("VA1234"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 			Properties: &armsecurity.RuleResultsProperties{
	// 				Results: [][]*string{
	// 					[]*string{
	// 						to.Ptr("userA"),
	// 						to.Ptr("SELECT")},
	// 						[]*string{
	// 							to.Ptr("userB"),
	// 							to.Ptr("SELECT")}},
	// 						},
	// 					},
	// 					{
	// 						Name: to.Ptr("VA5678"),
	// 						Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 						ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA5678"),
	// 						Properties: &armsecurity.RuleResultsProperties{
	// 							Results: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 								},
	// 						}},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_Add.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_Add_createABaselineForAllRules() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().Add(ctx, "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddOptions{Body: &armsecurity.RulesResultsInput{
		LatestScan: to.Ptr(false),
		Results: map[string][][]*string{
			"VA1234": {
				{
					to.Ptr("userA"),
					to.Ptr("SELECT")},
				{
					to.Ptr("userB"),
					to.Ptr("SELECT")}},
			"VA5678": {
				{
					to.Ptr("Test"),
					to.Ptr("0.0.0.0"),
					to.Ptr("125.125.125.125")}},
		},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RulesResults = armsecurity.RulesResults{
	// 	Value: []*armsecurity.RuleResults{
	// 		{
	// 			Name: to.Ptr("VA1234"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 			Properties: &armsecurity.RuleResultsProperties{
	// 				Results: [][]*string{
	// 					[]*string{
	// 						to.Ptr("userA"),
	// 						to.Ptr("SELECT")},
	// 						[]*string{
	// 							to.Ptr("userB"),
	// 							to.Ptr("SELECT")}},
	// 						},
	// 					},
	// 					{
	// 						Name: to.Ptr("VA5678"),
	// 						Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 						ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA5678"),
	// 						Properties: &armsecurity.RuleResultsProperties{
	// 							Results: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 								},
	// 						}},
	// 					}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e716082ac474f182e2220e4f38f1d6191e7636cf/specification/security/resource-manager/Microsoft.Security/preview/2023-02-01-preview/examples/sqlVulnerabilityAssessmentsBaselineRuleOperations/ArcMachineBaselineRules_AddLatest.json
func ExampleSQLVulnerabilityAssessmentBaselineRulesClient_Add_createABaselineForAllRulesUsingTheLatestScanResults() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsecurity.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLVulnerabilityAssessmentBaselineRulesClient().Add(ctx, "55555555-6666-7777-8888-999999999999", "subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master", &armsecurity.SQLVulnerabilityAssessmentBaselineRulesClientAddOptions{Body: &armsecurity.RulesResultsInput{
		LatestScan: to.Ptr(true),
		Results:    map[string][][]*string{},
	},
	})
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RulesResults = armsecurity.RulesResults{
	// 	Value: []*armsecurity.RuleResults{
	// 		{
	// 			Name: to.Ptr("VA1234"),
	// 			Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA1234"),
	// 			Properties: &armsecurity.RuleResultsProperties{
	// 				Results: [][]*string{
	// 					[]*string{
	// 						to.Ptr("userA"),
	// 						to.Ptr("SELECT")},
	// 						[]*string{
	// 							to.Ptr("userB"),
	// 							to.Ptr("SELECT")}},
	// 						},
	// 					},
	// 					{
	// 						Name: to.Ptr("VA5678"),
	// 						Type: to.Ptr("Microsoft.Security/sqlVulnerabilityAssessments/baselineRules"),
	// 						ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Rg/providers/Microsoft.HybridCompute/machines/MyMachine/sqlServers/server1/databases/master/providers/Microsoft.Security/sqlVulnerabilityAssessments/default/baselineRules/VA5678"),
	// 						Properties: &armsecurity.RuleResultsProperties{
	// 							Results: [][]*string{
	// 								[]*string{
	// 									to.Ptr("Test"),
	// 									to.Ptr("0.0.0.0"),
	// 									to.Ptr("125.125.125.125")}},
	// 								},
	// 						}},
	// 					}
}
