//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armrecoveryservicesbackup_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v3"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a4ddec441435d1ef766c4f160eda658a69cc5dc2/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/BackupResourceEncryptionConfig_Get.json
func ExampleBackupResourceEncryptionConfigsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBackupResourceEncryptionConfigsClient().Get(ctx, "rishTestVault", "rishgrp", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.BackupResourceEncryptionConfigExtendedResource = armrecoveryservicesbackup.BackupResourceEncryptionConfigExtendedResource{
	// 	Name: to.Ptr("backupResourceEncryptionConfig"),
	// 	Type: to.Ptr("Microsoft.RecoveryServices/vaults/backupEncryptionConfigs"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rishgrp/providers/Microsoft.RecoveryServicesBVTD2/vaults/rishTestVault/backupEncryptionConfigs/backupResourceEncryptionConfig"),
	// 	Properties: &armrecoveryservicesbackup.BackupResourceEncryptionConfigExtended{
	// 		EncryptionAtRestType: to.Ptr(armrecoveryservicesbackup.EncryptionAtRestTypeCustomerManaged),
	// 		InfrastructureEncryptionState: to.Ptr(armrecoveryservicesbackup.InfrastructureEncryptionStateDisabled),
	// 		KeyURI: to.Ptr("https://gktestkv1.vault.azure.net/keys/Test1/ed2e8cdc7f86477ebf0c6462b504a9ed"),
	// 		LastUpdateStatus: to.Ptr(armrecoveryservicesbackup.LastUpdateStatusSucceeded),
	// 		SubscriptionID: to.Ptr("1a2311d9-66f5-47d3-a9fb-7a37da63934b"),
	// 		UseSystemAssignedIdentity: to.Ptr(false),
	// 		UserAssignedIdentity: to.Ptr("/subscriptions/85bf5e8c-3084-4f42-add2-746ebb7e97b2/resourcegroups/defaultrg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/examplemsi"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/a4ddec441435d1ef766c4f160eda658a69cc5dc2/specification/recoveryservicesbackup/resource-manager/Microsoft.RecoveryServices/stable/2023-04-01/examples/BackupResourceEncryptionConfig_Put.json
func ExampleBackupResourceEncryptionConfigsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armrecoveryservicesbackup.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewBackupResourceEncryptionConfigsClient().Update(ctx, "source-rsv", "test-rg", armrecoveryservicesbackup.BackupResourceEncryptionConfigResource{
		Properties: &armrecoveryservicesbackup.BackupResourceEncryptionConfig{
			EncryptionAtRestType:          to.Ptr(armrecoveryservicesbackup.EncryptionAtRestTypeCustomerManaged),
			InfrastructureEncryptionState: to.Ptr(armrecoveryservicesbackup.InfrastructureEncryptionState("true")),
			KeyURI:                        to.Ptr("https://gktestkv1.vault.azure.net/keys/Test1/ed2e8cdc7f86477ebf0c6462b504a9ed"),
			SubscriptionID:                to.Ptr("1a2311d9-66f5-47d3-a9fb-7a37da63934b"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
