//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cdn/armcdn/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
	"time"
)

// LogAnalyticsServer is a fake server for instances of the armcdn.LogAnalyticsClient type.
type LogAnalyticsServer struct {
	// GetLogAnalyticsLocations is the fake for method LogAnalyticsClient.GetLogAnalyticsLocations
	// HTTP status codes to indicate success: http.StatusOK
	GetLogAnalyticsLocations func(ctx context.Context, resourceGroupName string, profileName string, options *armcdn.LogAnalyticsClientGetLogAnalyticsLocationsOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetLogAnalyticsLocationsResponse], errResp azfake.ErrorResponder)

	// GetLogAnalyticsMetrics is the fake for method LogAnalyticsClient.GetLogAnalyticsMetrics
	// HTTP status codes to indicate success: http.StatusOK
	GetLogAnalyticsMetrics func(ctx context.Context, resourceGroupName string, profileName string, metrics []armcdn.LogMetric, dateTimeBegin time.Time, dateTimeEnd time.Time, granularity armcdn.LogMetricsGranularity, customDomains []string, protocols []string, options *armcdn.LogAnalyticsClientGetLogAnalyticsMetricsOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetLogAnalyticsMetricsResponse], errResp azfake.ErrorResponder)

	// GetLogAnalyticsRankings is the fake for method LogAnalyticsClient.GetLogAnalyticsRankings
	// HTTP status codes to indicate success: http.StatusOK
	GetLogAnalyticsRankings func(ctx context.Context, resourceGroupName string, profileName string, rankings []armcdn.LogRanking, metrics []armcdn.LogRankingMetric, maxRanking int32, dateTimeBegin time.Time, dateTimeEnd time.Time, options *armcdn.LogAnalyticsClientGetLogAnalyticsRankingsOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetLogAnalyticsRankingsResponse], errResp azfake.ErrorResponder)

	// GetLogAnalyticsResources is the fake for method LogAnalyticsClient.GetLogAnalyticsResources
	// HTTP status codes to indicate success: http.StatusOK
	GetLogAnalyticsResources func(ctx context.Context, resourceGroupName string, profileName string, options *armcdn.LogAnalyticsClientGetLogAnalyticsResourcesOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetLogAnalyticsResourcesResponse], errResp azfake.ErrorResponder)

	// GetWafLogAnalyticsMetrics is the fake for method LogAnalyticsClient.GetWafLogAnalyticsMetrics
	// HTTP status codes to indicate success: http.StatusOK
	GetWafLogAnalyticsMetrics func(ctx context.Context, resourceGroupName string, profileName string, metrics []armcdn.WafMetric, dateTimeBegin time.Time, dateTimeEnd time.Time, granularity armcdn.WafGranularity, options *armcdn.LogAnalyticsClientGetWafLogAnalyticsMetricsOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetWafLogAnalyticsMetricsResponse], errResp azfake.ErrorResponder)

	// GetWafLogAnalyticsRankings is the fake for method LogAnalyticsClient.GetWafLogAnalyticsRankings
	// HTTP status codes to indicate success: http.StatusOK
	GetWafLogAnalyticsRankings func(ctx context.Context, resourceGroupName string, profileName string, metrics []armcdn.WafMetric, dateTimeBegin time.Time, dateTimeEnd time.Time, maxRanking int32, rankings []armcdn.WafRankingType, options *armcdn.LogAnalyticsClientGetWafLogAnalyticsRankingsOptions) (resp azfake.Responder[armcdn.LogAnalyticsClientGetWafLogAnalyticsRankingsResponse], errResp azfake.ErrorResponder)
}

// NewLogAnalyticsServerTransport creates a new instance of LogAnalyticsServerTransport with the provided implementation.
// The returned LogAnalyticsServerTransport instance is connected to an instance of armcdn.LogAnalyticsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLogAnalyticsServerTransport(srv *LogAnalyticsServer) *LogAnalyticsServerTransport {
	return &LogAnalyticsServerTransport{srv: srv}
}

// LogAnalyticsServerTransport connects instances of armcdn.LogAnalyticsClient to instances of LogAnalyticsServer.
// Don't use this type directly, use NewLogAnalyticsServerTransport instead.
type LogAnalyticsServerTransport struct {
	srv *LogAnalyticsServer
}

// Do implements the policy.Transporter interface for LogAnalyticsServerTransport.
func (l *LogAnalyticsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LogAnalyticsClient.GetLogAnalyticsLocations":
		resp, err = l.dispatchGetLogAnalyticsLocations(req)
	case "LogAnalyticsClient.GetLogAnalyticsMetrics":
		resp, err = l.dispatchGetLogAnalyticsMetrics(req)
	case "LogAnalyticsClient.GetLogAnalyticsRankings":
		resp, err = l.dispatchGetLogAnalyticsRankings(req)
	case "LogAnalyticsClient.GetLogAnalyticsResources":
		resp, err = l.dispatchGetLogAnalyticsResources(req)
	case "LogAnalyticsClient.GetWafLogAnalyticsMetrics":
		resp, err = l.dispatchGetWafLogAnalyticsMetrics(req)
	case "LogAnalyticsClient.GetWafLogAnalyticsRankings":
		resp, err = l.dispatchGetWafLogAnalyticsRankings(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetLogAnalyticsLocations(req *http.Request) (*http.Response, error) {
	if l.srv.GetLogAnalyticsLocations == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLogAnalyticsLocations not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogAnalyticsLocations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetLogAnalyticsLocations(req.Context(), resourceGroupNameParam, profileNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ContinentsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetLogAnalyticsMetrics(req *http.Request) (*http.Response, error) {
	if l.srv.GetLogAnalyticsMetrics == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLogAnalyticsMetrics not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogAnalyticsMetrics`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	metricsEscaped := qp["metrics"]
	metricsUnescaped := make([]string, len(metricsEscaped))
	for i, v := range metricsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		metricsUnescaped[i] = u
	}
	metricsParam := make([]armcdn.LogMetric, len(metricsUnescaped))
	for i := 0; i < len(metricsUnescaped); i++ {
		metricsParam[i] = armcdn.LogMetric(metricsUnescaped[i])
	}
	dateTimeBeginUnescaped, err := url.QueryUnescape(qp.Get("dateTimeBegin"))
	if err != nil {
		return nil, err
	}
	dateTimeBeginParam, err := time.Parse(time.RFC3339Nano, dateTimeBeginUnescaped)
	if err != nil {
		return nil, err
	}
	dateTimeEndUnescaped, err := url.QueryUnescape(qp.Get("dateTimeEnd"))
	if err != nil {
		return nil, err
	}
	dateTimeEndParam, err := time.Parse(time.RFC3339Nano, dateTimeEndUnescaped)
	if err != nil {
		return nil, err
	}
	granularityParam, err := parseWithCast(qp.Get("granularity"), func(v string) (armcdn.LogMetricsGranularity, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armcdn.LogMetricsGranularity(p), nil
	})
	if err != nil {
		return nil, err
	}
	groupByEscaped := qp["groupBy"]
	groupByUnescaped := make([]string, len(groupByEscaped))
	for i, v := range groupByEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		groupByUnescaped[i] = u
	}
	groupByParam := make([]armcdn.LogMetricsGroupBy, len(groupByUnescaped))
	for i := 0; i < len(groupByUnescaped); i++ {
		groupByParam[i] = armcdn.LogMetricsGroupBy(groupByUnescaped[i])
	}
	continentsEscaped := qp["continents"]
	continentsParam := make([]string, len(continentsEscaped))
	for i, v := range continentsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		continentsParam[i] = u
	}
	countryOrRegionsEscaped := qp["countryOrRegions"]
	countryOrRegionsParam := make([]string, len(countryOrRegionsEscaped))
	for i, v := range countryOrRegionsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		countryOrRegionsParam[i] = u
	}
	customDomainsEscaped := qp["customDomains"]
	customDomainsParam := make([]string, len(customDomainsEscaped))
	for i, v := range customDomainsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		customDomainsParam[i] = u
	}
	protocolsEscaped := qp["protocols"]
	protocolsParam := make([]string, len(protocolsEscaped))
	for i, v := range protocolsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		protocolsParam[i] = u
	}
	var options *armcdn.LogAnalyticsClientGetLogAnalyticsMetricsOptions
	if len(groupByParam) > 0 || len(continentsParam) > 0 || len(countryOrRegionsParam) > 0 {
		options = &armcdn.LogAnalyticsClientGetLogAnalyticsMetricsOptions{
			GroupBy:          groupByParam,
			Continents:       continentsParam,
			CountryOrRegions: countryOrRegionsParam,
		}
	}
	respr, errRespr := l.srv.GetLogAnalyticsMetrics(req.Context(), resourceGroupNameParam, profileNameParam, metricsParam, dateTimeBeginParam, dateTimeEndParam, granularityParam, customDomainsParam, protocolsParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MetricsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetLogAnalyticsRankings(req *http.Request) (*http.Response, error) {
	if l.srv.GetLogAnalyticsRankings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLogAnalyticsRankings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogAnalyticsRankings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	rankingsEscaped := qp["rankings"]
	rankingsUnescaped := make([]string, len(rankingsEscaped))
	for i, v := range rankingsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		rankingsUnescaped[i] = u
	}
	rankingsParam := make([]armcdn.LogRanking, len(rankingsUnescaped))
	for i := 0; i < len(rankingsUnescaped); i++ {
		rankingsParam[i] = armcdn.LogRanking(rankingsUnescaped[i])
	}
	metricsEscaped := qp["metrics"]
	metricsUnescaped := make([]string, len(metricsEscaped))
	for i, v := range metricsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		metricsUnescaped[i] = u
	}
	metricsParam := make([]armcdn.LogRankingMetric, len(metricsUnescaped))
	for i := 0; i < len(metricsUnescaped); i++ {
		metricsParam[i] = armcdn.LogRankingMetric(metricsUnescaped[i])
	}
	maxRankingUnescaped, err := url.QueryUnescape(qp.Get("maxRanking"))
	if err != nil {
		return nil, err
	}
	maxRankingParam, err := parseWithCast(maxRankingUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	dateTimeBeginUnescaped, err := url.QueryUnescape(qp.Get("dateTimeBegin"))
	if err != nil {
		return nil, err
	}
	dateTimeBeginParam, err := time.Parse(time.RFC3339Nano, dateTimeBeginUnescaped)
	if err != nil {
		return nil, err
	}
	dateTimeEndUnescaped, err := url.QueryUnescape(qp.Get("dateTimeEnd"))
	if err != nil {
		return nil, err
	}
	dateTimeEndParam, err := time.Parse(time.RFC3339Nano, dateTimeEndUnescaped)
	if err != nil {
		return nil, err
	}
	customDomainsEscaped := qp["customDomains"]
	customDomainsParam := make([]string, len(customDomainsEscaped))
	for i, v := range customDomainsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		customDomainsParam[i] = u
	}
	var options *armcdn.LogAnalyticsClientGetLogAnalyticsRankingsOptions
	if len(customDomainsParam) > 0 {
		options = &armcdn.LogAnalyticsClientGetLogAnalyticsRankingsOptions{
			CustomDomains: customDomainsParam,
		}
	}
	respr, errRespr := l.srv.GetLogAnalyticsRankings(req.Context(), resourceGroupNameParam, profileNameParam, rankingsParam, metricsParam, maxRankingParam, dateTimeBeginParam, dateTimeEndParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RankingsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetLogAnalyticsResources(req *http.Request) (*http.Response, error) {
	if l.srv.GetLogAnalyticsResources == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLogAnalyticsResources not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogAnalyticsResources`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.GetLogAnalyticsResources(req.Context(), resourceGroupNameParam, profileNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ResourcesResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetWafLogAnalyticsMetrics(req *http.Request) (*http.Response, error) {
	if l.srv.GetWafLogAnalyticsMetrics == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWafLogAnalyticsMetrics not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getWafLogAnalyticsMetrics`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	metricsEscaped := qp["metrics"]
	metricsUnescaped := make([]string, len(metricsEscaped))
	for i, v := range metricsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		metricsUnescaped[i] = u
	}
	metricsParam := make([]armcdn.WafMetric, len(metricsUnescaped))
	for i := 0; i < len(metricsUnescaped); i++ {
		metricsParam[i] = armcdn.WafMetric(metricsUnescaped[i])
	}
	dateTimeBeginUnescaped, err := url.QueryUnescape(qp.Get("dateTimeBegin"))
	if err != nil {
		return nil, err
	}
	dateTimeBeginParam, err := time.Parse(time.RFC3339Nano, dateTimeBeginUnescaped)
	if err != nil {
		return nil, err
	}
	dateTimeEndUnescaped, err := url.QueryUnescape(qp.Get("dateTimeEnd"))
	if err != nil {
		return nil, err
	}
	dateTimeEndParam, err := time.Parse(time.RFC3339Nano, dateTimeEndUnescaped)
	if err != nil {
		return nil, err
	}
	granularityParam, err := parseWithCast(qp.Get("granularity"), func(v string) (armcdn.WafGranularity, error) {
		p, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armcdn.WafGranularity(p), nil
	})
	if err != nil {
		return nil, err
	}
	actionsEscaped := qp["actions"]
	actionsUnescaped := make([]string, len(actionsEscaped))
	for i, v := range actionsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		actionsUnescaped[i] = u
	}
	actionsParam := make([]armcdn.WafAction, len(actionsUnescaped))
	for i := 0; i < len(actionsUnescaped); i++ {
		actionsParam[i] = armcdn.WafAction(actionsUnescaped[i])
	}
	groupByEscaped := qp["groupBy"]
	groupByUnescaped := make([]string, len(groupByEscaped))
	for i, v := range groupByEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		groupByUnescaped[i] = u
	}
	groupByParam := make([]armcdn.WafRankingGroupBy, len(groupByUnescaped))
	for i := 0; i < len(groupByUnescaped); i++ {
		groupByParam[i] = armcdn.WafRankingGroupBy(groupByUnescaped[i])
	}
	ruleTypesEscaped := qp["ruleTypes"]
	ruleTypesUnescaped := make([]string, len(ruleTypesEscaped))
	for i, v := range ruleTypesEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		ruleTypesUnescaped[i] = u
	}
	ruleTypesParam := make([]armcdn.WafRuleType, len(ruleTypesUnescaped))
	for i := 0; i < len(ruleTypesUnescaped); i++ {
		ruleTypesParam[i] = armcdn.WafRuleType(ruleTypesUnescaped[i])
	}
	var options *armcdn.LogAnalyticsClientGetWafLogAnalyticsMetricsOptions
	if len(actionsParam) > 0 || len(groupByParam) > 0 || len(ruleTypesParam) > 0 {
		options = &armcdn.LogAnalyticsClientGetWafLogAnalyticsMetricsOptions{
			Actions:   actionsParam,
			GroupBy:   groupByParam,
			RuleTypes: ruleTypesParam,
		}
	}
	respr, errRespr := l.srv.GetWafLogAnalyticsMetrics(req.Context(), resourceGroupNameParam, profileNameParam, metricsParam, dateTimeBeginParam, dateTimeEndParam, granularityParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WafMetricsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LogAnalyticsServerTransport) dispatchGetWafLogAnalyticsRankings(req *http.Request) (*http.Response, error) {
	if l.srv.GetWafLogAnalyticsRankings == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetWafLogAnalyticsRankings not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Cdn/profiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getWafLogAnalyticsRankings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	metricsEscaped := qp["metrics"]
	metricsUnescaped := make([]string, len(metricsEscaped))
	for i, v := range metricsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		metricsUnescaped[i] = u
	}
	metricsParam := make([]armcdn.WafMetric, len(metricsUnescaped))
	for i := 0; i < len(metricsUnescaped); i++ {
		metricsParam[i] = armcdn.WafMetric(metricsUnescaped[i])
	}
	dateTimeBeginUnescaped, err := url.QueryUnescape(qp.Get("dateTimeBegin"))
	if err != nil {
		return nil, err
	}
	dateTimeBeginParam, err := time.Parse(time.RFC3339Nano, dateTimeBeginUnescaped)
	if err != nil {
		return nil, err
	}
	dateTimeEndUnescaped, err := url.QueryUnescape(qp.Get("dateTimeEnd"))
	if err != nil {
		return nil, err
	}
	dateTimeEndParam, err := time.Parse(time.RFC3339Nano, dateTimeEndUnescaped)
	if err != nil {
		return nil, err
	}
	maxRankingUnescaped, err := url.QueryUnescape(qp.Get("maxRanking"))
	if err != nil {
		return nil, err
	}
	maxRankingParam, err := parseWithCast(maxRankingUnescaped, func(v string) (int32, error) {
		p, parseErr := strconv.ParseInt(v, 10, 32)
		if parseErr != nil {
			return 0, parseErr
		}
		return int32(p), nil
	})
	if err != nil {
		return nil, err
	}
	rankingsEscaped := qp["rankings"]
	rankingsUnescaped := make([]string, len(rankingsEscaped))
	for i, v := range rankingsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		rankingsUnescaped[i] = u
	}
	rankingsParam := make([]armcdn.WafRankingType, len(rankingsUnescaped))
	for i := 0; i < len(rankingsUnescaped); i++ {
		rankingsParam[i] = armcdn.WafRankingType(rankingsUnescaped[i])
	}
	actionsEscaped := qp["actions"]
	actionsUnescaped := make([]string, len(actionsEscaped))
	for i, v := range actionsEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		actionsUnescaped[i] = u
	}
	actionsParam := make([]armcdn.WafAction, len(actionsUnescaped))
	for i := 0; i < len(actionsUnescaped); i++ {
		actionsParam[i] = armcdn.WafAction(actionsUnescaped[i])
	}
	ruleTypesEscaped := qp["ruleTypes"]
	ruleTypesUnescaped := make([]string, len(ruleTypesEscaped))
	for i, v := range ruleTypesEscaped {
		u, unescapeErr := url.QueryUnescape(v)
		if unescapeErr != nil {
			return nil, unescapeErr
		}
		ruleTypesUnescaped[i] = u
	}
	ruleTypesParam := make([]armcdn.WafRuleType, len(ruleTypesUnescaped))
	for i := 0; i < len(ruleTypesUnescaped); i++ {
		ruleTypesParam[i] = armcdn.WafRuleType(ruleTypesUnescaped[i])
	}
	var options *armcdn.LogAnalyticsClientGetWafLogAnalyticsRankingsOptions
	if len(actionsParam) > 0 || len(ruleTypesParam) > 0 {
		options = &armcdn.LogAnalyticsClientGetWafLogAnalyticsRankingsOptions{
			Actions:   actionsParam,
			RuleTypes: ruleTypesParam,
		}
	}
	respr, errRespr := l.srv.GetWafLogAnalyticsRankings(req.Context(), resourceGroupNameParam, profileNameParam, metricsParam, dateTimeBeginParam, dateTimeEndParam, maxRankingParam, rankingsParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).WafRankingsResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
