//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armapimanagement.ClientFactory type.
type ServerFactory struct {
	APIServer                                  APIServer
	APIDiagnosticServer                        APIDiagnosticServer
	APIExportServer                            APIExportServer
	APIIssueAttachmentServer                   APIIssueAttachmentServer
	APIIssueServer                             APIIssueServer
	APIIssueCommentServer                      APIIssueCommentServer
	APIOperationServer                         APIOperationServer
	APIOperationPolicyServer                   APIOperationPolicyServer
	APIPolicyServer                            APIPolicyServer
	APIProductServer                           APIProductServer
	APIReleaseServer                           APIReleaseServer
	APIRevisionServer                          APIRevisionServer
	APISchemaServer                            APISchemaServer
	APITagDescriptionServer                    APITagDescriptionServer
	APIVersionSetServer                        APIVersionSetServer
	APIWikiServer                              APIWikiServer
	APIWikisServer                             APIWikisServer
	AuthorizationAccessPolicyServer            AuthorizationAccessPolicyServer
	AuthorizationServer                        AuthorizationServer
	AuthorizationLoginLinksServer              AuthorizationLoginLinksServer
	AuthorizationProviderServer                AuthorizationProviderServer
	AuthorizationServerServer                  AuthorizationServerServer
	BackendServer                              BackendServer
	CacheServer                                CacheServer
	CertificateServer                          CertificateServer
	Server                                     Server
	ContentItemServer                          ContentItemServer
	ContentTypeServer                          ContentTypeServer
	DelegationSettingsServer                   DelegationSettingsServer
	DeletedServicesServer                      DeletedServicesServer
	DiagnosticServer                           DiagnosticServer
	DocumentationServer                        DocumentationServer
	EmailTemplateServer                        EmailTemplateServer
	GatewayAPIServer                           GatewayAPIServer
	GatewayCertificateAuthorityServer          GatewayCertificateAuthorityServer
	GatewayServer                              GatewayServer
	GatewayHostnameConfigurationServer         GatewayHostnameConfigurationServer
	GlobalSchemaServer                         GlobalSchemaServer
	GraphQLAPIResolverServer                   GraphQLAPIResolverServer
	GraphQLAPIResolverPolicyServer             GraphQLAPIResolverPolicyServer
	GroupServer                                GroupServer
	GroupUserServer                            GroupUserServer
	IdentityProviderServer                     IdentityProviderServer
	IssueServer                                IssueServer
	LoggerServer                               LoggerServer
	NamedValueServer                           NamedValueServer
	NetworkStatusServer                        NetworkStatusServer
	NotificationServer                         NotificationServer
	NotificationRecipientEmailServer           NotificationRecipientEmailServer
	NotificationRecipientUserServer            NotificationRecipientUserServer
	OpenIDConnectProviderServer                OpenIDConnectProviderServer
	OperationServer                            OperationServer
	OperationsServer                           OperationsServer
	OutboundNetworkDependenciesEndpointsServer OutboundNetworkDependenciesEndpointsServer
	PolicyServer                               PolicyServer
	PolicyDescriptionServer                    PolicyDescriptionServer
	PolicyFragmentServer                       PolicyFragmentServer
	PortalConfigServer                         PortalConfigServer
	PortalRevisionServer                       PortalRevisionServer
	PortalSettingsServer                       PortalSettingsServer
	PrivateEndpointConnectionServer            PrivateEndpointConnectionServer
	ProductAPIServer                           ProductAPIServer
	ProductServer                              ProductServer
	ProductGroupServer                         ProductGroupServer
	ProductPolicyServer                        ProductPolicyServer
	ProductSubscriptionsServer                 ProductSubscriptionsServer
	ProductWikiServer                          ProductWikiServer
	ProductWikisServer                         ProductWikisServer
	QuotaByCounterKeysServer                   QuotaByCounterKeysServer
	QuotaByPeriodKeysServer                    QuotaByPeriodKeysServer
	RegionServer                               RegionServer
	ReportsServer                              ReportsServer
	SKUsServer                                 SKUsServer
	ServiceServer                              ServiceServer
	ServiceSKUsServer                          ServiceSKUsServer
	SignInSettingsServer                       SignInSettingsServer
	SignUpSettingsServer                       SignUpSettingsServer
	SubscriptionServer                         SubscriptionServer
	TagServer                                  TagServer
	TagResourceServer                          TagResourceServer
	TenantAccessServer                         TenantAccessServer
	TenantAccessGitServer                      TenantAccessGitServer
	TenantConfigurationServer                  TenantConfigurationServer
	TenantSettingsServer                       TenantSettingsServer
	UserServer                                 UserServer
	UserConfirmationPasswordServer             UserConfirmationPasswordServer
	UserGroupServer                            UserGroupServer
	UserIdentitiesServer                       UserIdentitiesServer
	UserSubscriptionServer                     UserSubscriptionServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armapimanagement.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armapimanagement.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                          *ServerFactory
	trMu                                         sync.Mutex
	trAPIServer                                  *APIServerTransport
	trAPIDiagnosticServer                        *APIDiagnosticServerTransport
	trAPIExportServer                            *APIExportServerTransport
	trAPIIssueAttachmentServer                   *APIIssueAttachmentServerTransport
	trAPIIssueServer                             *APIIssueServerTransport
	trAPIIssueCommentServer                      *APIIssueCommentServerTransport
	trAPIOperationServer                         *APIOperationServerTransport
	trAPIOperationPolicyServer                   *APIOperationPolicyServerTransport
	trAPIPolicyServer                            *APIPolicyServerTransport
	trAPIProductServer                           *APIProductServerTransport
	trAPIReleaseServer                           *APIReleaseServerTransport
	trAPIRevisionServer                          *APIRevisionServerTransport
	trAPISchemaServer                            *APISchemaServerTransport
	trAPITagDescriptionServer                    *APITagDescriptionServerTransport
	trAPIVersionSetServer                        *APIVersionSetServerTransport
	trAPIWikiServer                              *APIWikiServerTransport
	trAPIWikisServer                             *APIWikisServerTransport
	trAuthorizationAccessPolicyServer            *AuthorizationAccessPolicyServerTransport
	trAuthorizationServer                        *AuthorizationServerTransport
	trAuthorizationLoginLinksServer              *AuthorizationLoginLinksServerTransport
	trAuthorizationProviderServer                *AuthorizationProviderServerTransport
	trAuthorizationServerServer                  *AuthorizationServerServerTransport
	trBackendServer                              *BackendServerTransport
	trCacheServer                                *CacheServerTransport
	trCertificateServer                          *CertificateServerTransport
	trServer                                     *ServerTransport
	trContentItemServer                          *ContentItemServerTransport
	trContentTypeServer                          *ContentTypeServerTransport
	trDelegationSettingsServer                   *DelegationSettingsServerTransport
	trDeletedServicesServer                      *DeletedServicesServerTransport
	trDiagnosticServer                           *DiagnosticServerTransport
	trDocumentationServer                        *DocumentationServerTransport
	trEmailTemplateServer                        *EmailTemplateServerTransport
	trGatewayAPIServer                           *GatewayAPIServerTransport
	trGatewayCertificateAuthorityServer          *GatewayCertificateAuthorityServerTransport
	trGatewayServer                              *GatewayServerTransport
	trGatewayHostnameConfigurationServer         *GatewayHostnameConfigurationServerTransport
	trGlobalSchemaServer                         *GlobalSchemaServerTransport
	trGraphQLAPIResolverServer                   *GraphQLAPIResolverServerTransport
	trGraphQLAPIResolverPolicyServer             *GraphQLAPIResolverPolicyServerTransport
	trGroupServer                                *GroupServerTransport
	trGroupUserServer                            *GroupUserServerTransport
	trIdentityProviderServer                     *IdentityProviderServerTransport
	trIssueServer                                *IssueServerTransport
	trLoggerServer                               *LoggerServerTransport
	trNamedValueServer                           *NamedValueServerTransport
	trNetworkStatusServer                        *NetworkStatusServerTransport
	trNotificationServer                         *NotificationServerTransport
	trNotificationRecipientEmailServer           *NotificationRecipientEmailServerTransport
	trNotificationRecipientUserServer            *NotificationRecipientUserServerTransport
	trOpenIDConnectProviderServer                *OpenIDConnectProviderServerTransport
	trOperationServer                            *OperationServerTransport
	trOperationsServer                           *OperationsServerTransport
	trOutboundNetworkDependenciesEndpointsServer *OutboundNetworkDependenciesEndpointsServerTransport
	trPolicyServer                               *PolicyServerTransport
	trPolicyDescriptionServer                    *PolicyDescriptionServerTransport
	trPolicyFragmentServer                       *PolicyFragmentServerTransport
	trPortalConfigServer                         *PortalConfigServerTransport
	trPortalRevisionServer                       *PortalRevisionServerTransport
	trPortalSettingsServer                       *PortalSettingsServerTransport
	trPrivateEndpointConnectionServer            *PrivateEndpointConnectionServerTransport
	trProductAPIServer                           *ProductAPIServerTransport
	trProductServer                              *ProductServerTransport
	trProductGroupServer                         *ProductGroupServerTransport
	trProductPolicyServer                        *ProductPolicyServerTransport
	trProductSubscriptionsServer                 *ProductSubscriptionsServerTransport
	trProductWikiServer                          *ProductWikiServerTransport
	trProductWikisServer                         *ProductWikisServerTransport
	trQuotaByCounterKeysServer                   *QuotaByCounterKeysServerTransport
	trQuotaByPeriodKeysServer                    *QuotaByPeriodKeysServerTransport
	trRegionServer                               *RegionServerTransport
	trReportsServer                              *ReportsServerTransport
	trSKUsServer                                 *SKUsServerTransport
	trServiceServer                              *ServiceServerTransport
	trServiceSKUsServer                          *ServiceSKUsServerTransport
	trSignInSettingsServer                       *SignInSettingsServerTransport
	trSignUpSettingsServer                       *SignUpSettingsServerTransport
	trSubscriptionServer                         *SubscriptionServerTransport
	trTagServer                                  *TagServerTransport
	trTagResourceServer                          *TagResourceServerTransport
	trTenantAccessServer                         *TenantAccessServerTransport
	trTenantAccessGitServer                      *TenantAccessGitServerTransport
	trTenantConfigurationServer                  *TenantConfigurationServerTransport
	trTenantSettingsServer                       *TenantSettingsServerTransport
	trUserServer                                 *UserServerTransport
	trUserConfirmationPasswordServer             *UserConfirmationPasswordServerTransport
	trUserGroupServer                            *UserGroupServerTransport
	trUserIdentitiesServer                       *UserIdentitiesServerTransport
	trUserSubscriptionServer                     *UserSubscriptionServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "APIClient":
		initServer(s, &s.trAPIServer, func() *APIServerTransport { return NewAPIServerTransport(&s.srv.APIServer) })
		resp, err = s.trAPIServer.Do(req)
	case "APIDiagnosticClient":
		initServer(s, &s.trAPIDiagnosticServer, func() *APIDiagnosticServerTransport {
			return NewAPIDiagnosticServerTransport(&s.srv.APIDiagnosticServer)
		})
		resp, err = s.trAPIDiagnosticServer.Do(req)
	case "APIExportClient":
		initServer(s, &s.trAPIExportServer, func() *APIExportServerTransport { return NewAPIExportServerTransport(&s.srv.APIExportServer) })
		resp, err = s.trAPIExportServer.Do(req)
	case "APIIssueAttachmentClient":
		initServer(s, &s.trAPIIssueAttachmentServer, func() *APIIssueAttachmentServerTransport {
			return NewAPIIssueAttachmentServerTransport(&s.srv.APIIssueAttachmentServer)
		})
		resp, err = s.trAPIIssueAttachmentServer.Do(req)
	case "APIIssueClient":
		initServer(s, &s.trAPIIssueServer, func() *APIIssueServerTransport { return NewAPIIssueServerTransport(&s.srv.APIIssueServer) })
		resp, err = s.trAPIIssueServer.Do(req)
	case "APIIssueCommentClient":
		initServer(s, &s.trAPIIssueCommentServer, func() *APIIssueCommentServerTransport {
			return NewAPIIssueCommentServerTransport(&s.srv.APIIssueCommentServer)
		})
		resp, err = s.trAPIIssueCommentServer.Do(req)
	case "APIOperationClient":
		initServer(s, &s.trAPIOperationServer, func() *APIOperationServerTransport { return NewAPIOperationServerTransport(&s.srv.APIOperationServer) })
		resp, err = s.trAPIOperationServer.Do(req)
	case "APIOperationPolicyClient":
		initServer(s, &s.trAPIOperationPolicyServer, func() *APIOperationPolicyServerTransport {
			return NewAPIOperationPolicyServerTransport(&s.srv.APIOperationPolicyServer)
		})
		resp, err = s.trAPIOperationPolicyServer.Do(req)
	case "APIPolicyClient":
		initServer(s, &s.trAPIPolicyServer, func() *APIPolicyServerTransport { return NewAPIPolicyServerTransport(&s.srv.APIPolicyServer) })
		resp, err = s.trAPIPolicyServer.Do(req)
	case "APIProductClient":
		initServer(s, &s.trAPIProductServer, func() *APIProductServerTransport { return NewAPIProductServerTransport(&s.srv.APIProductServer) })
		resp, err = s.trAPIProductServer.Do(req)
	case "APIReleaseClient":
		initServer(s, &s.trAPIReleaseServer, func() *APIReleaseServerTransport { return NewAPIReleaseServerTransport(&s.srv.APIReleaseServer) })
		resp, err = s.trAPIReleaseServer.Do(req)
	case "APIRevisionClient":
		initServer(s, &s.trAPIRevisionServer, func() *APIRevisionServerTransport { return NewAPIRevisionServerTransport(&s.srv.APIRevisionServer) })
		resp, err = s.trAPIRevisionServer.Do(req)
	case "APISchemaClient":
		initServer(s, &s.trAPISchemaServer, func() *APISchemaServerTransport { return NewAPISchemaServerTransport(&s.srv.APISchemaServer) })
		resp, err = s.trAPISchemaServer.Do(req)
	case "APITagDescriptionClient":
		initServer(s, &s.trAPITagDescriptionServer, func() *APITagDescriptionServerTransport {
			return NewAPITagDescriptionServerTransport(&s.srv.APITagDescriptionServer)
		})
		resp, err = s.trAPITagDescriptionServer.Do(req)
	case "APIVersionSetClient":
		initServer(s, &s.trAPIVersionSetServer, func() *APIVersionSetServerTransport {
			return NewAPIVersionSetServerTransport(&s.srv.APIVersionSetServer)
		})
		resp, err = s.trAPIVersionSetServer.Do(req)
	case "APIWikiClient":
		initServer(s, &s.trAPIWikiServer, func() *APIWikiServerTransport { return NewAPIWikiServerTransport(&s.srv.APIWikiServer) })
		resp, err = s.trAPIWikiServer.Do(req)
	case "APIWikisClient":
		initServer(s, &s.trAPIWikisServer, func() *APIWikisServerTransport { return NewAPIWikisServerTransport(&s.srv.APIWikisServer) })
		resp, err = s.trAPIWikisServer.Do(req)
	case "AuthorizationAccessPolicyClient":
		initServer(s, &s.trAuthorizationAccessPolicyServer, func() *AuthorizationAccessPolicyServerTransport {
			return NewAuthorizationAccessPolicyServerTransport(&s.srv.AuthorizationAccessPolicyServer)
		})
		resp, err = s.trAuthorizationAccessPolicyServer.Do(req)
	case "AuthorizationClient":
		initServer(s, &s.trAuthorizationServer, func() *AuthorizationServerTransport {
			return NewAuthorizationServerTransport(&s.srv.AuthorizationServer)
		})
		resp, err = s.trAuthorizationServer.Do(req)
	case "AuthorizationLoginLinksClient":
		initServer(s, &s.trAuthorizationLoginLinksServer, func() *AuthorizationLoginLinksServerTransport {
			return NewAuthorizationLoginLinksServerTransport(&s.srv.AuthorizationLoginLinksServer)
		})
		resp, err = s.trAuthorizationLoginLinksServer.Do(req)
	case "AuthorizationProviderClient":
		initServer(s, &s.trAuthorizationProviderServer, func() *AuthorizationProviderServerTransport {
			return NewAuthorizationProviderServerTransport(&s.srv.AuthorizationProviderServer)
		})
		resp, err = s.trAuthorizationProviderServer.Do(req)
	case "AuthorizationServerClient":
		initServer(s, &s.trAuthorizationServerServer, func() *AuthorizationServerServerTransport {
			return NewAuthorizationServerServerTransport(&s.srv.AuthorizationServerServer)
		})
		resp, err = s.trAuthorizationServerServer.Do(req)
	case "BackendClient":
		initServer(s, &s.trBackendServer, func() *BackendServerTransport { return NewBackendServerTransport(&s.srv.BackendServer) })
		resp, err = s.trBackendServer.Do(req)
	case "CacheClient":
		initServer(s, &s.trCacheServer, func() *CacheServerTransport { return NewCacheServerTransport(&s.srv.CacheServer) })
		resp, err = s.trCacheServer.Do(req)
	case "CertificateClient":
		initServer(s, &s.trCertificateServer, func() *CertificateServerTransport { return NewCertificateServerTransport(&s.srv.CertificateServer) })
		resp, err = s.trCertificateServer.Do(req)
	case "Client":
		initServer(s, &s.trServer, func() *ServerTransport { return NewServerTransport(&s.srv.Server) })
		resp, err = s.trServer.Do(req)
	case "ContentItemClient":
		initServer(s, &s.trContentItemServer, func() *ContentItemServerTransport { return NewContentItemServerTransport(&s.srv.ContentItemServer) })
		resp, err = s.trContentItemServer.Do(req)
	case "ContentTypeClient":
		initServer(s, &s.trContentTypeServer, func() *ContentTypeServerTransport { return NewContentTypeServerTransport(&s.srv.ContentTypeServer) })
		resp, err = s.trContentTypeServer.Do(req)
	case "DelegationSettingsClient":
		initServer(s, &s.trDelegationSettingsServer, func() *DelegationSettingsServerTransport {
			return NewDelegationSettingsServerTransport(&s.srv.DelegationSettingsServer)
		})
		resp, err = s.trDelegationSettingsServer.Do(req)
	case "DeletedServicesClient":
		initServer(s, &s.trDeletedServicesServer, func() *DeletedServicesServerTransport {
			return NewDeletedServicesServerTransport(&s.srv.DeletedServicesServer)
		})
		resp, err = s.trDeletedServicesServer.Do(req)
	case "DiagnosticClient":
		initServer(s, &s.trDiagnosticServer, func() *DiagnosticServerTransport { return NewDiagnosticServerTransport(&s.srv.DiagnosticServer) })
		resp, err = s.trDiagnosticServer.Do(req)
	case "DocumentationClient":
		initServer(s, &s.trDocumentationServer, func() *DocumentationServerTransport {
			return NewDocumentationServerTransport(&s.srv.DocumentationServer)
		})
		resp, err = s.trDocumentationServer.Do(req)
	case "EmailTemplateClient":
		initServer(s, &s.trEmailTemplateServer, func() *EmailTemplateServerTransport {
			return NewEmailTemplateServerTransport(&s.srv.EmailTemplateServer)
		})
		resp, err = s.trEmailTemplateServer.Do(req)
	case "GatewayAPIClient":
		initServer(s, &s.trGatewayAPIServer, func() *GatewayAPIServerTransport { return NewGatewayAPIServerTransport(&s.srv.GatewayAPIServer) })
		resp, err = s.trGatewayAPIServer.Do(req)
	case "GatewayCertificateAuthorityClient":
		initServer(s, &s.trGatewayCertificateAuthorityServer, func() *GatewayCertificateAuthorityServerTransport {
			return NewGatewayCertificateAuthorityServerTransport(&s.srv.GatewayCertificateAuthorityServer)
		})
		resp, err = s.trGatewayCertificateAuthorityServer.Do(req)
	case "GatewayClient":
		initServer(s, &s.trGatewayServer, func() *GatewayServerTransport { return NewGatewayServerTransport(&s.srv.GatewayServer) })
		resp, err = s.trGatewayServer.Do(req)
	case "GatewayHostnameConfigurationClient":
		initServer(s, &s.trGatewayHostnameConfigurationServer, func() *GatewayHostnameConfigurationServerTransport {
			return NewGatewayHostnameConfigurationServerTransport(&s.srv.GatewayHostnameConfigurationServer)
		})
		resp, err = s.trGatewayHostnameConfigurationServer.Do(req)
	case "GlobalSchemaClient":
		initServer(s, &s.trGlobalSchemaServer, func() *GlobalSchemaServerTransport { return NewGlobalSchemaServerTransport(&s.srv.GlobalSchemaServer) })
		resp, err = s.trGlobalSchemaServer.Do(req)
	case "GraphQLAPIResolverClient":
		initServer(s, &s.trGraphQLAPIResolverServer, func() *GraphQLAPIResolverServerTransport {
			return NewGraphQLAPIResolverServerTransport(&s.srv.GraphQLAPIResolverServer)
		})
		resp, err = s.trGraphQLAPIResolverServer.Do(req)
	case "GraphQLAPIResolverPolicyClient":
		initServer(s, &s.trGraphQLAPIResolverPolicyServer, func() *GraphQLAPIResolverPolicyServerTransport {
			return NewGraphQLAPIResolverPolicyServerTransport(&s.srv.GraphQLAPIResolverPolicyServer)
		})
		resp, err = s.trGraphQLAPIResolverPolicyServer.Do(req)
	case "GroupClient":
		initServer(s, &s.trGroupServer, func() *GroupServerTransport { return NewGroupServerTransport(&s.srv.GroupServer) })
		resp, err = s.trGroupServer.Do(req)
	case "GroupUserClient":
		initServer(s, &s.trGroupUserServer, func() *GroupUserServerTransport { return NewGroupUserServerTransport(&s.srv.GroupUserServer) })
		resp, err = s.trGroupUserServer.Do(req)
	case "IdentityProviderClient":
		initServer(s, &s.trIdentityProviderServer, func() *IdentityProviderServerTransport {
			return NewIdentityProviderServerTransport(&s.srv.IdentityProviderServer)
		})
		resp, err = s.trIdentityProviderServer.Do(req)
	case "IssueClient":
		initServer(s, &s.trIssueServer, func() *IssueServerTransport { return NewIssueServerTransport(&s.srv.IssueServer) })
		resp, err = s.trIssueServer.Do(req)
	case "LoggerClient":
		initServer(s, &s.trLoggerServer, func() *LoggerServerTransport { return NewLoggerServerTransport(&s.srv.LoggerServer) })
		resp, err = s.trLoggerServer.Do(req)
	case "NamedValueClient":
		initServer(s, &s.trNamedValueServer, func() *NamedValueServerTransport { return NewNamedValueServerTransport(&s.srv.NamedValueServer) })
		resp, err = s.trNamedValueServer.Do(req)
	case "NetworkStatusClient":
		initServer(s, &s.trNetworkStatusServer, func() *NetworkStatusServerTransport {
			return NewNetworkStatusServerTransport(&s.srv.NetworkStatusServer)
		})
		resp, err = s.trNetworkStatusServer.Do(req)
	case "NotificationClient":
		initServer(s, &s.trNotificationServer, func() *NotificationServerTransport { return NewNotificationServerTransport(&s.srv.NotificationServer) })
		resp, err = s.trNotificationServer.Do(req)
	case "NotificationRecipientEmailClient":
		initServer(s, &s.trNotificationRecipientEmailServer, func() *NotificationRecipientEmailServerTransport {
			return NewNotificationRecipientEmailServerTransport(&s.srv.NotificationRecipientEmailServer)
		})
		resp, err = s.trNotificationRecipientEmailServer.Do(req)
	case "NotificationRecipientUserClient":
		initServer(s, &s.trNotificationRecipientUserServer, func() *NotificationRecipientUserServerTransport {
			return NewNotificationRecipientUserServerTransport(&s.srv.NotificationRecipientUserServer)
		})
		resp, err = s.trNotificationRecipientUserServer.Do(req)
	case "OpenIDConnectProviderClient":
		initServer(s, &s.trOpenIDConnectProviderServer, func() *OpenIDConnectProviderServerTransport {
			return NewOpenIDConnectProviderServerTransport(&s.srv.OpenIDConnectProviderServer)
		})
		resp, err = s.trOpenIDConnectProviderServer.Do(req)
	case "OperationClient":
		initServer(s, &s.trOperationServer, func() *OperationServerTransport { return NewOperationServerTransport(&s.srv.OperationServer) })
		resp, err = s.trOperationServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "OutboundNetworkDependenciesEndpointsClient":
		initServer(s, &s.trOutboundNetworkDependenciesEndpointsServer, func() *OutboundNetworkDependenciesEndpointsServerTransport {
			return NewOutboundNetworkDependenciesEndpointsServerTransport(&s.srv.OutboundNetworkDependenciesEndpointsServer)
		})
		resp, err = s.trOutboundNetworkDependenciesEndpointsServer.Do(req)
	case "PolicyClient":
		initServer(s, &s.trPolicyServer, func() *PolicyServerTransport { return NewPolicyServerTransport(&s.srv.PolicyServer) })
		resp, err = s.trPolicyServer.Do(req)
	case "PolicyDescriptionClient":
		initServer(s, &s.trPolicyDescriptionServer, func() *PolicyDescriptionServerTransport {
			return NewPolicyDescriptionServerTransport(&s.srv.PolicyDescriptionServer)
		})
		resp, err = s.trPolicyDescriptionServer.Do(req)
	case "PolicyFragmentClient":
		initServer(s, &s.trPolicyFragmentServer, func() *PolicyFragmentServerTransport {
			return NewPolicyFragmentServerTransport(&s.srv.PolicyFragmentServer)
		})
		resp, err = s.trPolicyFragmentServer.Do(req)
	case "PortalConfigClient":
		initServer(s, &s.trPortalConfigServer, func() *PortalConfigServerTransport { return NewPortalConfigServerTransport(&s.srv.PortalConfigServer) })
		resp, err = s.trPortalConfigServer.Do(req)
	case "PortalRevisionClient":
		initServer(s, &s.trPortalRevisionServer, func() *PortalRevisionServerTransport {
			return NewPortalRevisionServerTransport(&s.srv.PortalRevisionServer)
		})
		resp, err = s.trPortalRevisionServer.Do(req)
	case "PortalSettingsClient":
		initServer(s, &s.trPortalSettingsServer, func() *PortalSettingsServerTransport {
			return NewPortalSettingsServerTransport(&s.srv.PortalSettingsServer)
		})
		resp, err = s.trPortalSettingsServer.Do(req)
	case "PrivateEndpointConnectionClient":
		initServer(s, &s.trPrivateEndpointConnectionServer, func() *PrivateEndpointConnectionServerTransport {
			return NewPrivateEndpointConnectionServerTransport(&s.srv.PrivateEndpointConnectionServer)
		})
		resp, err = s.trPrivateEndpointConnectionServer.Do(req)
	case "ProductAPIClient":
		initServer(s, &s.trProductAPIServer, func() *ProductAPIServerTransport { return NewProductAPIServerTransport(&s.srv.ProductAPIServer) })
		resp, err = s.trProductAPIServer.Do(req)
	case "ProductClient":
		initServer(s, &s.trProductServer, func() *ProductServerTransport { return NewProductServerTransport(&s.srv.ProductServer) })
		resp, err = s.trProductServer.Do(req)
	case "ProductGroupClient":
		initServer(s, &s.trProductGroupServer, func() *ProductGroupServerTransport { return NewProductGroupServerTransport(&s.srv.ProductGroupServer) })
		resp, err = s.trProductGroupServer.Do(req)
	case "ProductPolicyClient":
		initServer(s, &s.trProductPolicyServer, func() *ProductPolicyServerTransport {
			return NewProductPolicyServerTransport(&s.srv.ProductPolicyServer)
		})
		resp, err = s.trProductPolicyServer.Do(req)
	case "ProductSubscriptionsClient":
		initServer(s, &s.trProductSubscriptionsServer, func() *ProductSubscriptionsServerTransport {
			return NewProductSubscriptionsServerTransport(&s.srv.ProductSubscriptionsServer)
		})
		resp, err = s.trProductSubscriptionsServer.Do(req)
	case "ProductWikiClient":
		initServer(s, &s.trProductWikiServer, func() *ProductWikiServerTransport { return NewProductWikiServerTransport(&s.srv.ProductWikiServer) })
		resp, err = s.trProductWikiServer.Do(req)
	case "ProductWikisClient":
		initServer(s, &s.trProductWikisServer, func() *ProductWikisServerTransport { return NewProductWikisServerTransport(&s.srv.ProductWikisServer) })
		resp, err = s.trProductWikisServer.Do(req)
	case "QuotaByCounterKeysClient":
		initServer(s, &s.trQuotaByCounterKeysServer, func() *QuotaByCounterKeysServerTransport {
			return NewQuotaByCounterKeysServerTransport(&s.srv.QuotaByCounterKeysServer)
		})
		resp, err = s.trQuotaByCounterKeysServer.Do(req)
	case "QuotaByPeriodKeysClient":
		initServer(s, &s.trQuotaByPeriodKeysServer, func() *QuotaByPeriodKeysServerTransport {
			return NewQuotaByPeriodKeysServerTransport(&s.srv.QuotaByPeriodKeysServer)
		})
		resp, err = s.trQuotaByPeriodKeysServer.Do(req)
	case "RegionClient":
		initServer(s, &s.trRegionServer, func() *RegionServerTransport { return NewRegionServerTransport(&s.srv.RegionServer) })
		resp, err = s.trRegionServer.Do(req)
	case "ReportsClient":
		initServer(s, &s.trReportsServer, func() *ReportsServerTransport { return NewReportsServerTransport(&s.srv.ReportsServer) })
		resp, err = s.trReportsServer.Do(req)
	case "SKUsClient":
		initServer(s, &s.trSKUsServer, func() *SKUsServerTransport { return NewSKUsServerTransport(&s.srv.SKUsServer) })
		resp, err = s.trSKUsServer.Do(req)
	case "ServiceClient":
		initServer(s, &s.trServiceServer, func() *ServiceServerTransport { return NewServiceServerTransport(&s.srv.ServiceServer) })
		resp, err = s.trServiceServer.Do(req)
	case "ServiceSKUsClient":
		initServer(s, &s.trServiceSKUsServer, func() *ServiceSKUsServerTransport { return NewServiceSKUsServerTransport(&s.srv.ServiceSKUsServer) })
		resp, err = s.trServiceSKUsServer.Do(req)
	case "SignInSettingsClient":
		initServer(s, &s.trSignInSettingsServer, func() *SignInSettingsServerTransport {
			return NewSignInSettingsServerTransport(&s.srv.SignInSettingsServer)
		})
		resp, err = s.trSignInSettingsServer.Do(req)
	case "SignUpSettingsClient":
		initServer(s, &s.trSignUpSettingsServer, func() *SignUpSettingsServerTransport {
			return NewSignUpSettingsServerTransport(&s.srv.SignUpSettingsServer)
		})
		resp, err = s.trSignUpSettingsServer.Do(req)
	case "SubscriptionClient":
		initServer(s, &s.trSubscriptionServer, func() *SubscriptionServerTransport { return NewSubscriptionServerTransport(&s.srv.SubscriptionServer) })
		resp, err = s.trSubscriptionServer.Do(req)
	case "TagClient":
		initServer(s, &s.trTagServer, func() *TagServerTransport { return NewTagServerTransport(&s.srv.TagServer) })
		resp, err = s.trTagServer.Do(req)
	case "TagResourceClient":
		initServer(s, &s.trTagResourceServer, func() *TagResourceServerTransport { return NewTagResourceServerTransport(&s.srv.TagResourceServer) })
		resp, err = s.trTagResourceServer.Do(req)
	case "TenantAccessClient":
		initServer(s, &s.trTenantAccessServer, func() *TenantAccessServerTransport { return NewTenantAccessServerTransport(&s.srv.TenantAccessServer) })
		resp, err = s.trTenantAccessServer.Do(req)
	case "TenantAccessGitClient":
		initServer(s, &s.trTenantAccessGitServer, func() *TenantAccessGitServerTransport {
			return NewTenantAccessGitServerTransport(&s.srv.TenantAccessGitServer)
		})
		resp, err = s.trTenantAccessGitServer.Do(req)
	case "TenantConfigurationClient":
		initServer(s, &s.trTenantConfigurationServer, func() *TenantConfigurationServerTransport {
			return NewTenantConfigurationServerTransport(&s.srv.TenantConfigurationServer)
		})
		resp, err = s.trTenantConfigurationServer.Do(req)
	case "TenantSettingsClient":
		initServer(s, &s.trTenantSettingsServer, func() *TenantSettingsServerTransport {
			return NewTenantSettingsServerTransport(&s.srv.TenantSettingsServer)
		})
		resp, err = s.trTenantSettingsServer.Do(req)
	case "UserClient":
		initServer(s, &s.trUserServer, func() *UserServerTransport { return NewUserServerTransport(&s.srv.UserServer) })
		resp, err = s.trUserServer.Do(req)
	case "UserConfirmationPasswordClient":
		initServer(s, &s.trUserConfirmationPasswordServer, func() *UserConfirmationPasswordServerTransport {
			return NewUserConfirmationPasswordServerTransport(&s.srv.UserConfirmationPasswordServer)
		})
		resp, err = s.trUserConfirmationPasswordServer.Do(req)
	case "UserGroupClient":
		initServer(s, &s.trUserGroupServer, func() *UserGroupServerTransport { return NewUserGroupServerTransport(&s.srv.UserGroupServer) })
		resp, err = s.trUserGroupServer.Do(req)
	case "UserIdentitiesClient":
		initServer(s, &s.trUserIdentitiesServer, func() *UserIdentitiesServerTransport {
			return NewUserIdentitiesServerTransport(&s.srv.UserIdentitiesServer)
		})
		resp, err = s.trUserIdentitiesServer.Do(req)
	case "UserSubscriptionClient":
		initServer(s, &s.trUserSubscriptionServer, func() *UserSubscriptionServerTransport {
			return NewUserSubscriptionServerTransport(&s.srv.UserSubscriptionServer)
		})
		resp, err = s.trUserSubscriptionServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
