// SPDX-License-Identifier: MIT

package cmd

import (
	"fmt"
	"strings"
)

type enumType struct {
	Enum     []string
	Default  string
	selected string
}

func (o enumType) Join() string {
	return strings.Join(o.Enum, ",")
}

func (o *enumType) Set(value string) error {
	for _, enum := range o.Enum {
		if strings.EqualFold(enum, value) {
			o.selected = value
			return nil
		}
	}

	return fmt.Errorf("%v", o.Allowed())
}

func (o *enumType) Allowed() string {
	return fmt.Sprintf("allowed values are %s", o.Join())
}

func (o *enumType) GetDefaultText() string {
	return fmt.Sprintf("%s, %s", o.Default, o.Allowed())
}

func (o enumType) Get() any {
	return o.String()
}

func (o enumType) String() string {
	if o.selected == "" {
		return o.Default
	}
	return o.selected
}
