
#include "Meta_Maps.h"

#include <glbinding/gl/enum.h>

using namespace gl;


namespace glbinding
{


const std::unordered_map<GLenum, std::string> Meta_StringsByEnum =
{
    { GLenum::GL_SKIP_COMPONENTS1_NV, "GL_SKIP_COMPONENTS1_NV" },
    { GLenum::GL_SKIP_COMPONENTS2_NV, "GL_SKIP_COMPONENTS2_NV" },
    { GLenum::GL_SKIP_COMPONENTS3_NV, "GL_SKIP_COMPONENTS3_NV" },
    { GLenum::GL_SKIP_COMPONENTS4_NV, "GL_SKIP_COMPONENTS4_NV" },
    { GLenum::GL_NEXT_BUFFER_NV, "GL_NEXT_BUFFER_NV" },
    { GLenum::GL_NONE, "GL_NONE" },
    { GLenum::GL_LINES, "GL_LINES" },
    { GLenum::GL_LINE_LOOP, "GL_LINE_LOOP" },
    { GLenum::GL_LINE_STRIP, "GL_LINE_STRIP" },
    { GLenum::GL_TRIANGLES, "GL_TRIANGLES" },
    { GLenum::GL_TRIANGLE_STRIP, "GL_TRIANGLE_STRIP" },
    { GLenum::GL_TRIANGLE_FAN, "GL_TRIANGLE_FAN" },
    { GLenum::GL_QUADS, "GL_QUADS" },
    { GLenum::GL_QUAD_STRIP, "GL_QUAD_STRIP" },
    { GLenum::GL_POLYGON, "GL_POLYGON" },
    { GLenum::GL_LINES_ADJACENCY, "GL_LINES_ADJACENCY" },
    { GLenum::GL_LINE_STRIP_ADJACENCY, "GL_LINE_STRIP_ADJACENCY" },
    { GLenum::GL_TRIANGLES_ADJACENCY, "GL_TRIANGLES_ADJACENCY" },
    { GLenum::GL_TRIANGLE_STRIP_ADJACENCY, "GL_TRIANGLE_STRIP_ADJACENCY" },
    { GLenum::GL_PATCHES, "GL_PATCHES" },
    { GLenum::GL_ALPHA_REF_COMMAND_NV, "GL_ALPHA_REF_COMMAND_NV" },
    { GLenum::GL_SMOOTH_CUBIC_CURVE_TO_NV, "GL_SMOOTH_CUBIC_CURVE_TO_NV" },
    { GLenum::GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV, "GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV" },
    { GLenum::GL_FRONT_FACE_COMMAND_NV, "GL_FRONT_FACE_COMMAND_NV" },
    { GLenum::GL_RELATIVE_SMALL_CCW_ARC_TO_NV, "GL_RELATIVE_SMALL_CCW_ARC_TO_NV" },
    { GLenum::GL_SMALL_CW_ARC_TO_NV, "GL_SMALL_CW_ARC_TO_NV" },
    { GLenum::GL_RELATIVE_SMALL_CW_ARC_TO_NV, "GL_RELATIVE_SMALL_CW_ARC_TO_NV" },
    { GLenum::GL_LARGE_CCW_ARC_TO_NV, "GL_LARGE_CCW_ARC_TO_NV" },
    { GLenum::GL_RELATIVE_LARGE_CCW_ARC_TO_NV, "GL_RELATIVE_LARGE_CCW_ARC_TO_NV" },
    { GLenum::GL_LARGE_CW_ARC_TO_NV, "GL_LARGE_CW_ARC_TO_NV" },
    { GLenum::GL_RELATIVE_LARGE_CW_ARC_TO_NV, "GL_RELATIVE_LARGE_CW_ARC_TO_NV" },
    { GLenum::GL_CONIC_CURVE_TO_NV, "GL_CONIC_CURVE_TO_NV" },
    { GLenum::GL_RELATIVE_CONIC_CURVE_TO_NV, "GL_RELATIVE_CONIC_CURVE_TO_NV" },
    { GLenum::GL_SHARED_EDGE_NV, "GL_SHARED_EDGE_NV" },
    { GLenum::GL_ROUNDED_RECT_NV, "GL_ROUNDED_RECT_NV" },
    { GLenum::GL_RELATIVE_ROUNDED_RECT_NV, "GL_RELATIVE_ROUNDED_RECT_NV" },
    { GLenum::GL_ROUNDED_RECT2_NV, "GL_ROUNDED_RECT2_NV" },
    { GLenum::GL_RELATIVE_ROUNDED_RECT2_NV, "GL_RELATIVE_ROUNDED_RECT2_NV" },
    { GLenum::GL_ROUNDED_RECT4_NV, "GL_ROUNDED_RECT4_NV" },
    { GLenum::GL_RELATIVE_ROUNDED_RECT4_NV, "GL_RELATIVE_ROUNDED_RECT4_NV" },
    { GLenum::GL_ROUNDED_RECT8_NV, "GL_ROUNDED_RECT8_NV" },
    { GLenum::GL_RELATIVE_ROUNDED_RECT8_NV, "GL_RELATIVE_ROUNDED_RECT8_NV" },
    { GLenum::GL_RESTART_PATH_NV, "GL_RESTART_PATH_NV" },
    { GLenum::GL_DUP_FIRST_CUBIC_CURVE_TO_NV, "GL_DUP_FIRST_CUBIC_CURVE_TO_NV" },
    { GLenum::GL_DUP_LAST_CUBIC_CURVE_TO_NV, "GL_DUP_LAST_CUBIC_CURVE_TO_NV" },
    { GLenum::GL_RECT_NV, "GL_RECT_NV" },
    { GLenum::GL_RELATIVE_RECT_NV, "GL_RELATIVE_RECT_NV" },
    { GLenum::GL_CIRCULAR_CCW_ARC_TO_NV, "GL_CIRCULAR_CCW_ARC_TO_NV" },
    { GLenum::GL_CIRCULAR_CW_ARC_TO_NV, "GL_CIRCULAR_CW_ARC_TO_NV" },
    { GLenum::GL_CIRCULAR_TANGENT_ARC_TO_NV, "GL_CIRCULAR_TANGENT_ARC_TO_NV" },
    { GLenum::GL_ARC_TO_NV, "GL_ARC_TO_NV" },
    { GLenum::GL_RELATIVE_ARC_TO_NV, "GL_RELATIVE_ARC_TO_NV" },
    { GLenum::GL_ACCUM, "GL_ACCUM" },
    { GLenum::GL_LOAD, "GL_LOAD" },
    { GLenum::GL_RETURN, "GL_RETURN" },
    { GLenum::GL_MULT, "GL_MULT" },
    { GLenum::GL_ADD, "GL_ADD" },
    { GLenum::GL_NEVER, "GL_NEVER" },
    { GLenum::GL_LESS, "GL_LESS" },
    { GLenum::GL_EQUAL, "GL_EQUAL" },
    { GLenum::GL_LEQUAL, "GL_LEQUAL" },
    { GLenum::GL_GREATER, "GL_GREATER" },
    { GLenum::GL_NOTEQUAL, "GL_NOTEQUAL" },
    { GLenum::GL_GEQUAL, "GL_GEQUAL" },
    { GLenum::GL_ALWAYS, "GL_ALWAYS" },
    { GLenum::GL_SRC_COLOR, "GL_SRC_COLOR" },
    { GLenum::GL_ONE_MINUS_SRC_COLOR, "GL_ONE_MINUS_SRC_COLOR" },
    { GLenum::GL_SRC_ALPHA, "GL_SRC_ALPHA" },
    { GLenum::GL_ONE_MINUS_SRC_ALPHA, "GL_ONE_MINUS_SRC_ALPHA" },
    { GLenum::GL_DST_ALPHA, "GL_DST_ALPHA" },
    { GLenum::GL_ONE_MINUS_DST_ALPHA, "GL_ONE_MINUS_DST_ALPHA" },
    { GLenum::GL_DST_COLOR, "GL_DST_COLOR" },
    { GLenum::GL_ONE_MINUS_DST_COLOR, "GL_ONE_MINUS_DST_COLOR" },
    { GLenum::GL_SRC_ALPHA_SATURATE, "GL_SRC_ALPHA_SATURATE" },
    { GLenum::GL_FRONT_LEFT, "GL_FRONT_LEFT" },
    { GLenum::GL_FRONT_RIGHT, "GL_FRONT_RIGHT" },
    { GLenum::GL_BACK_LEFT, "GL_BACK_LEFT" },
    { GLenum::GL_BACK_RIGHT, "GL_BACK_RIGHT" },
    { GLenum::GL_FRONT, "GL_FRONT" },
    { GLenum::GL_BACK, "GL_BACK" },
    { GLenum::GL_LEFT, "GL_LEFT" },
    { GLenum::GL_RIGHT, "GL_RIGHT" },
    { GLenum::GL_FRONT_AND_BACK, "GL_FRONT_AND_BACK" },
    { GLenum::GL_AUX0, "GL_AUX0" },
    { GLenum::GL_AUX1, "GL_AUX1" },
    { GLenum::GL_AUX2, "GL_AUX2" },
    { GLenum::GL_AUX3, "GL_AUX3" },
    { GLenum::GL_INVALID_ENUM, "GL_INVALID_ENUM" },
    { GLenum::GL_INVALID_VALUE, "GL_INVALID_VALUE" },
    { GLenum::GL_INVALID_OPERATION, "GL_INVALID_OPERATION" },
    { GLenum::GL_STACK_OVERFLOW, "GL_STACK_OVERFLOW" },
    { GLenum::GL_STACK_UNDERFLOW, "GL_STACK_UNDERFLOW" },
    { GLenum::GL_OUT_OF_MEMORY, "GL_OUT_OF_MEMORY" },
    { GLenum::GL_INVALID_FRAMEBUFFER_OPERATION, "GL_INVALID_FRAMEBUFFER_OPERATION" },
    { GLenum::GL_CONTEXT_LOST, "GL_CONTEXT_LOST" },
    { GLenum::GL_2D, "GL_2D" },
    { GLenum::GL_3D, "GL_3D" },
    { GLenum::GL_3D_COLOR, "GL_3D_COLOR" },
    { GLenum::GL_3D_COLOR_TEXTURE, "GL_3D_COLOR_TEXTURE" },
    { GLenum::GL_4D_COLOR_TEXTURE, "GL_4D_COLOR_TEXTURE" },
    { GLenum::GL_PASS_THROUGH_TOKEN, "GL_PASS_THROUGH_TOKEN" },
    { GLenum::GL_POINT_TOKEN, "GL_POINT_TOKEN" },
    { GLenum::GL_LINE_TOKEN, "GL_LINE_TOKEN" },
    { GLenum::GL_POLYGON_TOKEN, "GL_POLYGON_TOKEN" },
    { GLenum::GL_BITMAP_TOKEN, "GL_BITMAP_TOKEN" },
    { GLenum::GL_DRAW_PIXEL_TOKEN, "GL_DRAW_PIXEL_TOKEN" },
    { GLenum::GL_COPY_PIXEL_TOKEN, "GL_COPY_PIXEL_TOKEN" },
    { GLenum::GL_LINE_RESET_TOKEN, "GL_LINE_RESET_TOKEN" },
    { GLenum::GL_EXP, "GL_EXP" },
    { GLenum::GL_EXP2, "GL_EXP2" },
    { GLenum::GL_CW, "GL_CW" },
    { GLenum::GL_CCW, "GL_CCW" },
    { GLenum::GL_COEFF, "GL_COEFF" },
    { GLenum::GL_ORDER, "GL_ORDER" },
    { GLenum::GL_DOMAIN, "GL_DOMAIN" },
    { GLenum::GL_CURRENT_COLOR, "GL_CURRENT_COLOR" },
    { GLenum::GL_CURRENT_INDEX, "GL_CURRENT_INDEX" },
    { GLenum::GL_CURRENT_NORMAL, "GL_CURRENT_NORMAL" },
    { GLenum::GL_CURRENT_TEXTURE_COORDS, "GL_CURRENT_TEXTURE_COORDS" },
    { GLenum::GL_CURRENT_RASTER_COLOR, "GL_CURRENT_RASTER_COLOR" },
    { GLenum::GL_CURRENT_RASTER_INDEX, "GL_CURRENT_RASTER_INDEX" },
    { GLenum::GL_CURRENT_RASTER_TEXTURE_COORDS, "GL_CURRENT_RASTER_TEXTURE_COORDS" },
    { GLenum::GL_CURRENT_RASTER_POSITION, "GL_CURRENT_RASTER_POSITION" },
    { GLenum::GL_CURRENT_RASTER_POSITION_VALID, "GL_CURRENT_RASTER_POSITION_VALID" },
    { GLenum::GL_CURRENT_RASTER_DISTANCE, "GL_CURRENT_RASTER_DISTANCE" },
    { GLenum::GL_POINT_SMOOTH, "GL_POINT_SMOOTH" },
    { GLenum::GL_POINT_SIZE, "GL_POINT_SIZE" },
    { GLenum::GL_POINT_SIZE_RANGE, "GL_POINT_SIZE_RANGE" },
    { GLenum::GL_POINT_SIZE_GRANULARITY, "GL_POINT_SIZE_GRANULARITY" },
    { GLenum::GL_LINE_SMOOTH, "GL_LINE_SMOOTH" },
    { GLenum::GL_LINE_WIDTH, "GL_LINE_WIDTH" },
    { GLenum::GL_LINE_WIDTH_RANGE, "GL_LINE_WIDTH_RANGE" },
    { GLenum::GL_LINE_WIDTH_GRANULARITY, "GL_LINE_WIDTH_GRANULARITY" },
    { GLenum::GL_LINE_STIPPLE, "GL_LINE_STIPPLE" },
    { GLenum::GL_LINE_STIPPLE_PATTERN, "GL_LINE_STIPPLE_PATTERN" },
    { GLenum::GL_LINE_STIPPLE_REPEAT, "GL_LINE_STIPPLE_REPEAT" },
    { GLenum::GL_LIST_MODE, "GL_LIST_MODE" },
    { GLenum::GL_MAX_LIST_NESTING, "GL_MAX_LIST_NESTING" },
    { GLenum::GL_LIST_BASE, "GL_LIST_BASE" },
    { GLenum::GL_LIST_INDEX, "GL_LIST_INDEX" },
    { GLenum::GL_POLYGON_MODE, "GL_POLYGON_MODE" },
    { GLenum::GL_POLYGON_SMOOTH, "GL_POLYGON_SMOOTH" },
    { GLenum::GL_POLYGON_STIPPLE, "GL_POLYGON_STIPPLE" },
    { GLenum::GL_EDGE_FLAG, "GL_EDGE_FLAG" },
    { GLenum::GL_CULL_FACE, "GL_CULL_FACE" },
    { GLenum::GL_CULL_FACE_MODE, "GL_CULL_FACE_MODE" },
    { GLenum::GL_FRONT_FACE, "GL_FRONT_FACE" },
    { GLenum::GL_LIGHTING, "GL_LIGHTING" },
    { GLenum::GL_LIGHT_MODEL_LOCAL_VIEWER, "GL_LIGHT_MODEL_LOCAL_VIEWER" },
    { GLenum::GL_LIGHT_MODEL_TWO_SIDE, "GL_LIGHT_MODEL_TWO_SIDE" },
    { GLenum::GL_LIGHT_MODEL_AMBIENT, "GL_LIGHT_MODEL_AMBIENT" },
    { GLenum::GL_SHADE_MODEL, "GL_SHADE_MODEL" },
    { GLenum::GL_COLOR_MATERIAL_FACE, "GL_COLOR_MATERIAL_FACE" },
    { GLenum::GL_COLOR_MATERIAL_PARAMETER, "GL_COLOR_MATERIAL_PARAMETER" },
    { GLenum::GL_COLOR_MATERIAL, "GL_COLOR_MATERIAL" },
    { GLenum::GL_FOG, "GL_FOG" },
    { GLenum::GL_FOG_INDEX, "GL_FOG_INDEX" },
    { GLenum::GL_FOG_DENSITY, "GL_FOG_DENSITY" },
    { GLenum::GL_FOG_START, "GL_FOG_START" },
    { GLenum::GL_FOG_END, "GL_FOG_END" },
    { GLenum::GL_FOG_MODE, "GL_FOG_MODE" },
    { GLenum::GL_FOG_COLOR, "GL_FOG_COLOR" },
    { GLenum::GL_DEPTH_RANGE, "GL_DEPTH_RANGE" },
    { GLenum::GL_DEPTH_TEST, "GL_DEPTH_TEST" },
    { GLenum::GL_DEPTH_WRITEMASK, "GL_DEPTH_WRITEMASK" },
    { GLenum::GL_DEPTH_CLEAR_VALUE, "GL_DEPTH_CLEAR_VALUE" },
    { GLenum::GL_DEPTH_FUNC, "GL_DEPTH_FUNC" },
    { GLenum::GL_ACCUM_CLEAR_VALUE, "GL_ACCUM_CLEAR_VALUE" },
    { GLenum::GL_STENCIL_TEST, "GL_STENCIL_TEST" },
    { GLenum::GL_STENCIL_CLEAR_VALUE, "GL_STENCIL_CLEAR_VALUE" },
    { GLenum::GL_STENCIL_FUNC, "GL_STENCIL_FUNC" },
    { GLenum::GL_STENCIL_VALUE_MASK, "GL_STENCIL_VALUE_MASK" },
    { GLenum::GL_STENCIL_FAIL, "GL_STENCIL_FAIL" },
    { GLenum::GL_STENCIL_PASS_DEPTH_FAIL, "GL_STENCIL_PASS_DEPTH_FAIL" },
    { GLenum::GL_STENCIL_PASS_DEPTH_PASS, "GL_STENCIL_PASS_DEPTH_PASS" },
    { GLenum::GL_STENCIL_REF, "GL_STENCIL_REF" },
    { GLenum::GL_STENCIL_WRITEMASK, "GL_STENCIL_WRITEMASK" },
    { GLenum::GL_MATRIX_MODE, "GL_MATRIX_MODE" },
    { GLenum::GL_NORMALIZE, "GL_NORMALIZE" },
    { GLenum::GL_VIEWPORT, "GL_VIEWPORT" },
    { GLenum::GL_MODELVIEW_STACK_DEPTH, "GL_MODELVIEW_STACK_DEPTH" },
    { GLenum::GL_PROJECTION_STACK_DEPTH, "GL_PROJECTION_STACK_DEPTH" },
    { GLenum::GL_TEXTURE_STACK_DEPTH, "GL_TEXTURE_STACK_DEPTH" },
    { GLenum::GL_MODELVIEW_MATRIX, "GL_MODELVIEW_MATRIX" },
    { GLenum::GL_PROJECTION_MATRIX, "GL_PROJECTION_MATRIX" },
    { GLenum::GL_TEXTURE_MATRIX, "GL_TEXTURE_MATRIX" },
    { GLenum::GL_ATTRIB_STACK_DEPTH, "GL_ATTRIB_STACK_DEPTH" },
    { GLenum::GL_CLIENT_ATTRIB_STACK_DEPTH, "GL_CLIENT_ATTRIB_STACK_DEPTH" },
    { GLenum::GL_ALPHA_TEST, "GL_ALPHA_TEST" },
    { GLenum::GL_ALPHA_TEST_FUNC, "GL_ALPHA_TEST_FUNC" },
    { GLenum::GL_ALPHA_TEST_REF, "GL_ALPHA_TEST_REF" },
    { GLenum::GL_DITHER, "GL_DITHER" },
    { GLenum::GL_BLEND_DST, "GL_BLEND_DST" },
    { GLenum::GL_BLEND_SRC, "GL_BLEND_SRC" },
    { GLenum::GL_BLEND, "GL_BLEND" },
    { GLenum::GL_LOGIC_OP_MODE, "GL_LOGIC_OP_MODE" },
    { GLenum::GL_INDEX_LOGIC_OP, "GL_INDEX_LOGIC_OP" },
    { GLenum::GL_COLOR_LOGIC_OP, "GL_COLOR_LOGIC_OP" },
    { GLenum::GL_AUX_BUFFERS, "GL_AUX_BUFFERS" },
    { GLenum::GL_DRAW_BUFFER, "GL_DRAW_BUFFER" },
    { GLenum::GL_READ_BUFFER, "GL_READ_BUFFER" },
    { GLenum::GL_SCISSOR_BOX, "GL_SCISSOR_BOX" },
    { GLenum::GL_SCISSOR_TEST, "GL_SCISSOR_TEST" },
    { GLenum::GL_INDEX_CLEAR_VALUE, "GL_INDEX_CLEAR_VALUE" },
    { GLenum::GL_INDEX_WRITEMASK, "GL_INDEX_WRITEMASK" },
    { GLenum::GL_COLOR_CLEAR_VALUE, "GL_COLOR_CLEAR_VALUE" },
    { GLenum::GL_COLOR_WRITEMASK, "GL_COLOR_WRITEMASK" },
    { GLenum::GL_INDEX_MODE, "GL_INDEX_MODE" },
    { GLenum::GL_RGBA_MODE, "GL_RGBA_MODE" },
    { GLenum::GL_DOUBLEBUFFER, "GL_DOUBLEBUFFER" },
    { GLenum::GL_STEREO, "GL_STEREO" },
    { GLenum::GL_RENDER_MODE, "GL_RENDER_MODE" },
    { GLenum::GL_PERSPECTIVE_CORRECTION_HINT, "GL_PERSPECTIVE_CORRECTION_HINT" },
    { GLenum::GL_POINT_SMOOTH_HINT, "GL_POINT_SMOOTH_HINT" },
    { GLenum::GL_LINE_SMOOTH_HINT, "GL_LINE_SMOOTH_HINT" },
    { GLenum::GL_POLYGON_SMOOTH_HINT, "GL_POLYGON_SMOOTH_HINT" },
    { GLenum::GL_FOG_HINT, "GL_FOG_HINT" },
    { GLenum::GL_TEXTURE_GEN_S, "GL_TEXTURE_GEN_S" },
    { GLenum::GL_TEXTURE_GEN_T, "GL_TEXTURE_GEN_T" },
    { GLenum::GL_TEXTURE_GEN_R, "GL_TEXTURE_GEN_R" },
    { GLenum::GL_TEXTURE_GEN_Q, "GL_TEXTURE_GEN_Q" },
    { GLenum::GL_PIXEL_MAP_I_TO_I, "GL_PIXEL_MAP_I_TO_I" },
    { GLenum::GL_PIXEL_MAP_S_TO_S, "GL_PIXEL_MAP_S_TO_S" },
    { GLenum::GL_PIXEL_MAP_I_TO_R, "GL_PIXEL_MAP_I_TO_R" },
    { GLenum::GL_PIXEL_MAP_I_TO_G, "GL_PIXEL_MAP_I_TO_G" },
    { GLenum::GL_PIXEL_MAP_I_TO_B, "GL_PIXEL_MAP_I_TO_B" },
    { GLenum::GL_PIXEL_MAP_I_TO_A, "GL_PIXEL_MAP_I_TO_A" },
    { GLenum::GL_PIXEL_MAP_R_TO_R, "GL_PIXEL_MAP_R_TO_R" },
    { GLenum::GL_PIXEL_MAP_G_TO_G, "GL_PIXEL_MAP_G_TO_G" },
    { GLenum::GL_PIXEL_MAP_B_TO_B, "GL_PIXEL_MAP_B_TO_B" },
    { GLenum::GL_PIXEL_MAP_A_TO_A, "GL_PIXEL_MAP_A_TO_A" },
    { GLenum::GL_PIXEL_MAP_I_TO_I_SIZE, "GL_PIXEL_MAP_I_TO_I_SIZE" },
    { GLenum::GL_PIXEL_MAP_S_TO_S_SIZE, "GL_PIXEL_MAP_S_TO_S_SIZE" },
    { GLenum::GL_PIXEL_MAP_I_TO_R_SIZE, "GL_PIXEL_MAP_I_TO_R_SIZE" },
    { GLenum::GL_PIXEL_MAP_I_TO_G_SIZE, "GL_PIXEL_MAP_I_TO_G_SIZE" },
    { GLenum::GL_PIXEL_MAP_I_TO_B_SIZE, "GL_PIXEL_MAP_I_TO_B_SIZE" },
    { GLenum::GL_PIXEL_MAP_I_TO_A_SIZE, "GL_PIXEL_MAP_I_TO_A_SIZE" },
    { GLenum::GL_PIXEL_MAP_R_TO_R_SIZE, "GL_PIXEL_MAP_R_TO_R_SIZE" },
    { GLenum::GL_PIXEL_MAP_G_TO_G_SIZE, "GL_PIXEL_MAP_G_TO_G_SIZE" },
    { GLenum::GL_PIXEL_MAP_B_TO_B_SIZE, "GL_PIXEL_MAP_B_TO_B_SIZE" },
    { GLenum::GL_PIXEL_MAP_A_TO_A_SIZE, "GL_PIXEL_MAP_A_TO_A_SIZE" },
    { GLenum::GL_UNPACK_SWAP_BYTES, "GL_UNPACK_SWAP_BYTES" },
    { GLenum::GL_UNPACK_LSB_FIRST, "GL_UNPACK_LSB_FIRST" },
    { GLenum::GL_UNPACK_ROW_LENGTH, "GL_UNPACK_ROW_LENGTH" },
    { GLenum::GL_UNPACK_SKIP_ROWS, "GL_UNPACK_SKIP_ROWS" },
    { GLenum::GL_UNPACK_SKIP_PIXELS, "GL_UNPACK_SKIP_PIXELS" },
    { GLenum::GL_UNPACK_ALIGNMENT, "GL_UNPACK_ALIGNMENT" },
    { GLenum::GL_PACK_SWAP_BYTES, "GL_PACK_SWAP_BYTES" },
    { GLenum::GL_PACK_LSB_FIRST, "GL_PACK_LSB_FIRST" },
    { GLenum::GL_PACK_ROW_LENGTH, "GL_PACK_ROW_LENGTH" },
    { GLenum::GL_PACK_SKIP_ROWS, "GL_PACK_SKIP_ROWS" },
    { GLenum::GL_PACK_SKIP_PIXELS, "GL_PACK_SKIP_PIXELS" },
    { GLenum::GL_PACK_ALIGNMENT, "GL_PACK_ALIGNMENT" },
    { GLenum::GL_MAP_COLOR, "GL_MAP_COLOR" },
    { GLenum::GL_MAP_STENCIL, "GL_MAP_STENCIL" },
    { GLenum::GL_INDEX_SHIFT, "GL_INDEX_SHIFT" },
    { GLenum::GL_INDEX_OFFSET, "GL_INDEX_OFFSET" },
    { GLenum::GL_RED_SCALE, "GL_RED_SCALE" },
    { GLenum::GL_RED_BIAS, "GL_RED_BIAS" },
    { GLenum::GL_ZOOM_X, "GL_ZOOM_X" },
    { GLenum::GL_ZOOM_Y, "GL_ZOOM_Y" },
    { GLenum::GL_GREEN_SCALE, "GL_GREEN_SCALE" },
    { GLenum::GL_GREEN_BIAS, "GL_GREEN_BIAS" },
    { GLenum::GL_BLUE_SCALE, "GL_BLUE_SCALE" },
    { GLenum::GL_BLUE_BIAS, "GL_BLUE_BIAS" },
    { GLenum::GL_ALPHA_SCALE, "GL_ALPHA_SCALE" },
    { GLenum::GL_ALPHA_BIAS, "GL_ALPHA_BIAS" },
    { GLenum::GL_DEPTH_SCALE, "GL_DEPTH_SCALE" },
    { GLenum::GL_DEPTH_BIAS, "GL_DEPTH_BIAS" },
    { GLenum::GL_MAX_EVAL_ORDER, "GL_MAX_EVAL_ORDER" },
    { GLenum::GL_MAX_LIGHTS, "GL_MAX_LIGHTS" },
    { GLenum::GL_MAX_CLIP_DISTANCES, "GL_MAX_CLIP_DISTANCES" },
    { GLenum::GL_MAX_TEXTURE_SIZE, "GL_MAX_TEXTURE_SIZE" },
    { GLenum::GL_MAX_PIXEL_MAP_TABLE, "GL_MAX_PIXEL_MAP_TABLE" },
    { GLenum::GL_MAX_ATTRIB_STACK_DEPTH, "GL_MAX_ATTRIB_STACK_DEPTH" },
    { GLenum::GL_MAX_MODELVIEW_STACK_DEPTH, "GL_MAX_MODELVIEW_STACK_DEPTH" },
    { GLenum::GL_MAX_NAME_STACK_DEPTH, "GL_MAX_NAME_STACK_DEPTH" },
    { GLenum::GL_MAX_PROJECTION_STACK_DEPTH, "GL_MAX_PROJECTION_STACK_DEPTH" },
    { GLenum::GL_MAX_TEXTURE_STACK_DEPTH, "GL_MAX_TEXTURE_STACK_DEPTH" },
    { GLenum::GL_MAX_VIEWPORT_DIMS, "GL_MAX_VIEWPORT_DIMS" },
    { GLenum::GL_MAX_CLIENT_ATTRIB_STACK_DEPTH, "GL_MAX_CLIENT_ATTRIB_STACK_DEPTH" },
    { GLenum::GL_SUBPIXEL_BITS, "GL_SUBPIXEL_BITS" },
    { GLenum::GL_INDEX_BITS, "GL_INDEX_BITS" },
    { GLenum::GL_RED_BITS, "GL_RED_BITS" },
    { GLenum::GL_GREEN_BITS, "GL_GREEN_BITS" },
    { GLenum::GL_BLUE_BITS, "GL_BLUE_BITS" },
    { GLenum::GL_ALPHA_BITS, "GL_ALPHA_BITS" },
    { GLenum::GL_DEPTH_BITS, "GL_DEPTH_BITS" },
    { GLenum::GL_STENCIL_BITS, "GL_STENCIL_BITS" },
    { GLenum::GL_ACCUM_RED_BITS, "GL_ACCUM_RED_BITS" },
    { GLenum::GL_ACCUM_GREEN_BITS, "GL_ACCUM_GREEN_BITS" },
    { GLenum::GL_ACCUM_BLUE_BITS, "GL_ACCUM_BLUE_BITS" },
    { GLenum::GL_ACCUM_ALPHA_BITS, "GL_ACCUM_ALPHA_BITS" },
    { GLenum::GL_NAME_STACK_DEPTH, "GL_NAME_STACK_DEPTH" },
    { GLenum::GL_AUTO_NORMAL, "GL_AUTO_NORMAL" },
    { GLenum::GL_MAP1_COLOR_4, "GL_MAP1_COLOR_4" },
    { GLenum::GL_MAP1_INDEX, "GL_MAP1_INDEX" },
    { GLenum::GL_MAP1_NORMAL, "GL_MAP1_NORMAL" },
    { GLenum::GL_MAP1_TEXTURE_COORD_1, "GL_MAP1_TEXTURE_COORD_1" },
    { GLenum::GL_MAP1_TEXTURE_COORD_2, "GL_MAP1_TEXTURE_COORD_2" },
    { GLenum::GL_MAP1_TEXTURE_COORD_3, "GL_MAP1_TEXTURE_COORD_3" },
    { GLenum::GL_MAP1_TEXTURE_COORD_4, "GL_MAP1_TEXTURE_COORD_4" },
    { GLenum::GL_MAP1_VERTEX_3, "GL_MAP1_VERTEX_3" },
    { GLenum::GL_MAP1_VERTEX_4, "GL_MAP1_VERTEX_4" },
    { GLenum::GL_MAP2_COLOR_4, "GL_MAP2_COLOR_4" },
    { GLenum::GL_MAP2_INDEX, "GL_MAP2_INDEX" },
    { GLenum::GL_MAP2_NORMAL, "GL_MAP2_NORMAL" },
    { GLenum::GL_MAP2_TEXTURE_COORD_1, "GL_MAP2_TEXTURE_COORD_1" },
    { GLenum::GL_MAP2_TEXTURE_COORD_2, "GL_MAP2_TEXTURE_COORD_2" },
    { GLenum::GL_MAP2_TEXTURE_COORD_3, "GL_MAP2_TEXTURE_COORD_3" },
    { GLenum::GL_MAP2_TEXTURE_COORD_4, "GL_MAP2_TEXTURE_COORD_4" },
    { GLenum::GL_MAP2_VERTEX_3, "GL_MAP2_VERTEX_3" },
    { GLenum::GL_MAP2_VERTEX_4, "GL_MAP2_VERTEX_4" },
    { GLenum::GL_MAP1_GRID_DOMAIN, "GL_MAP1_GRID_DOMAIN" },
    { GLenum::GL_MAP1_GRID_SEGMENTS, "GL_MAP1_GRID_SEGMENTS" },
    { GLenum::GL_MAP2_GRID_DOMAIN, "GL_MAP2_GRID_DOMAIN" },
    { GLenum::GL_MAP2_GRID_SEGMENTS, "GL_MAP2_GRID_SEGMENTS" },
    { GLenum::GL_TEXTURE_1D, "GL_TEXTURE_1D" },
    { GLenum::GL_TEXTURE_2D, "GL_TEXTURE_2D" },
    { GLenum::GL_FEEDBACK_BUFFER_POINTER, "GL_FEEDBACK_BUFFER_POINTER" },
    { GLenum::GL_FEEDBACK_BUFFER_SIZE, "GL_FEEDBACK_BUFFER_SIZE" },
    { GLenum::GL_FEEDBACK_BUFFER_TYPE, "GL_FEEDBACK_BUFFER_TYPE" },
    { GLenum::GL_SELECTION_BUFFER_POINTER, "GL_SELECTION_BUFFER_POINTER" },
    { GLenum::GL_SELECTION_BUFFER_SIZE, "GL_SELECTION_BUFFER_SIZE" },
    { GLenum::GL_TEXTURE_WIDTH, "GL_TEXTURE_WIDTH" },
    { GLenum::GL_TEXTURE_HEIGHT, "GL_TEXTURE_HEIGHT" },
    { GLenum::GL_TEXTURE_COMPONENTS, "GL_TEXTURE_COMPONENTS" },
    { GLenum::GL_TEXTURE_BORDER_COLOR, "GL_TEXTURE_BORDER_COLOR" },
    { GLenum::GL_TEXTURE_BORDER, "GL_TEXTURE_BORDER" },
    { GLenum::GL_TEXTURE_TARGET, "GL_TEXTURE_TARGET" },
    { GLenum::GL_DONT_CARE, "GL_DONT_CARE" },
    { GLenum::GL_FASTEST, "GL_FASTEST" },
    { GLenum::GL_NICEST, "GL_NICEST" },
    { GLenum::GL_AMBIENT, "GL_AMBIENT" },
    { GLenum::GL_DIFFUSE, "GL_DIFFUSE" },
    { GLenum::GL_SPECULAR, "GL_SPECULAR" },
    { GLenum::GL_POSITION, "GL_POSITION" },
    { GLenum::GL_SPOT_DIRECTION, "GL_SPOT_DIRECTION" },
    { GLenum::GL_SPOT_EXPONENT, "GL_SPOT_EXPONENT" },
    { GLenum::GL_SPOT_CUTOFF, "GL_SPOT_CUTOFF" },
    { GLenum::GL_CONSTANT_ATTENUATION, "GL_CONSTANT_ATTENUATION" },
    { GLenum::GL_LINEAR_ATTENUATION, "GL_LINEAR_ATTENUATION" },
    { GLenum::GL_QUADRATIC_ATTENUATION, "GL_QUADRATIC_ATTENUATION" },
    { GLenum::GL_COMPILE, "GL_COMPILE" },
    { GLenum::GL_COMPILE_AND_EXECUTE, "GL_COMPILE_AND_EXECUTE" },
    { GLenum::GL_BYTE, "GL_BYTE" },
    { GLenum::GL_UNSIGNED_BYTE, "GL_UNSIGNED_BYTE" },
    { GLenum::GL_SHORT, "GL_SHORT" },
    { GLenum::GL_UNSIGNED_SHORT, "GL_UNSIGNED_SHORT" },
    { GLenum::GL_INT, "GL_INT" },
    { GLenum::GL_UNSIGNED_INT, "GL_UNSIGNED_INT" },
    { GLenum::GL_FLOAT, "GL_FLOAT" },
    { GLenum::GL_2_BYTES, "GL_2_BYTES" },
    { GLenum::GL_3_BYTES, "GL_3_BYTES" },
    { GLenum::GL_4_BYTES, "GL_4_BYTES" },
    { GLenum::GL_DOUBLE, "GL_DOUBLE" },
    { GLenum::GL_HALF_FLOAT, "GL_HALF_FLOAT" },
    { GLenum::GL_FIXED, "GL_FIXED" },
    { GLenum::GL_INT64_ARB, "GL_INT64_ARB" },
    { GLenum::GL_UNSIGNED_INT64_ARB, "GL_UNSIGNED_INT64_ARB" },
    { GLenum::GL_CLEAR, "GL_CLEAR" },
    { GLenum::GL_AND, "GL_AND" },
    { GLenum::GL_AND_REVERSE, "GL_AND_REVERSE" },
    { GLenum::GL_COPY, "GL_COPY" },
    { GLenum::GL_AND_INVERTED, "GL_AND_INVERTED" },
    { GLenum::GL_NOOP, "GL_NOOP" },
    { GLenum::GL_XOR, "GL_XOR" },
    { GLenum::GL_OR, "GL_OR" },
    { GLenum::GL_NOR, "GL_NOR" },
    { GLenum::GL_EQUIV, "GL_EQUIV" },
    { GLenum::GL_INVERT, "GL_INVERT" },
    { GLenum::GL_OR_REVERSE, "GL_OR_REVERSE" },
    { GLenum::GL_COPY_INVERTED, "GL_COPY_INVERTED" },
    { GLenum::GL_OR_INVERTED, "GL_OR_INVERTED" },
    { GLenum::GL_NAND, "GL_NAND" },
    { GLenum::GL_SET, "GL_SET" },
    { GLenum::GL_EMISSION, "GL_EMISSION" },
    { GLenum::GL_SHININESS, "GL_SHININESS" },
    { GLenum::GL_AMBIENT_AND_DIFFUSE, "GL_AMBIENT_AND_DIFFUSE" },
    { GLenum::GL_COLOR_INDEXES, "GL_COLOR_INDEXES" },
    { GLenum::GL_MODELVIEW, "GL_MODELVIEW" },
    { GLenum::GL_PROJECTION, "GL_PROJECTION" },
    { GLenum::GL_TEXTURE, "GL_TEXTURE" },
    { GLenum::GL_COLOR, "GL_COLOR" },
    { GLenum::GL_DEPTH, "GL_DEPTH" },
    { GLenum::GL_STENCIL, "GL_STENCIL" },
    { GLenum::GL_COLOR_INDEX, "GL_COLOR_INDEX" },
    { GLenum::GL_STENCIL_INDEX, "GL_STENCIL_INDEX" },
    { GLenum::GL_DEPTH_COMPONENT, "GL_DEPTH_COMPONENT" },
    { GLenum::GL_RED, "GL_RED" },
    { GLenum::GL_GREEN, "GL_GREEN" },
    { GLenum::GL_BLUE, "GL_BLUE" },
    { GLenum::GL_ALPHA, "GL_ALPHA" },
    { GLenum::GL_RGB, "GL_RGB" },
    { GLenum::GL_RGBA, "GL_RGBA" },
    { GLenum::GL_LUMINANCE, "GL_LUMINANCE" },
    { GLenum::GL_LUMINANCE_ALPHA, "GL_LUMINANCE_ALPHA" },
    { GLenum::GL_BITMAP, "GL_BITMAP" },
    { GLenum::GL_POINT, "GL_POINT" },
    { GLenum::GL_LINE, "GL_LINE" },
    { GLenum::GL_FILL, "GL_FILL" },
    { GLenum::GL_RENDER, "GL_RENDER" },
    { GLenum::GL_FEEDBACK, "GL_FEEDBACK" },
    { GLenum::GL_SELECT, "GL_SELECT" },
    { GLenum::GL_FLAT, "GL_FLAT" },
    { GLenum::GL_SMOOTH, "GL_SMOOTH" },
    { GLenum::GL_KEEP, "GL_KEEP" },
    { GLenum::GL_REPLACE, "GL_REPLACE" },
    { GLenum::GL_INCR, "GL_INCR" },
    { GLenum::GL_DECR, "GL_DECR" },
    { GLenum::GL_VENDOR, "GL_VENDOR" },
    { GLenum::GL_RENDERER, "GL_RENDERER" },
    { GLenum::GL_VERSION, "GL_VERSION" },
    { GLenum::GL_EXTENSIONS, "GL_EXTENSIONS" },
    { GLenum::GL_S, "GL_S" },
    { GLenum::GL_T, "GL_T" },
    { GLenum::GL_R, "GL_R" },
    { GLenum::GL_Q, "GL_Q" },
    { GLenum::GL_MODULATE, "GL_MODULATE" },
    { GLenum::GL_DECAL, "GL_DECAL" },
    { GLenum::GL_TEXTURE_ENV_MODE, "GL_TEXTURE_ENV_MODE" },
    { GLenum::GL_TEXTURE_ENV_COLOR, "GL_TEXTURE_ENV_COLOR" },
    { GLenum::GL_TEXTURE_ENV, "GL_TEXTURE_ENV" },
    { GLenum::GL_EYE_LINEAR, "GL_EYE_LINEAR" },
    { GLenum::GL_OBJECT_LINEAR, "GL_OBJECT_LINEAR" },
    { GLenum::GL_SPHERE_MAP, "GL_SPHERE_MAP" },
    { GLenum::GL_TEXTURE_GEN_MODE, "GL_TEXTURE_GEN_MODE" },
    { GLenum::GL_OBJECT_PLANE, "GL_OBJECT_PLANE" },
    { GLenum::GL_EYE_PLANE, "GL_EYE_PLANE" },
    { GLenum::GL_NEAREST, "GL_NEAREST" },
    { GLenum::GL_LINEAR, "GL_LINEAR" },
    { GLenum::GL_NEAREST_MIPMAP_NEAREST, "GL_NEAREST_MIPMAP_NEAREST" },
    { GLenum::GL_LINEAR_MIPMAP_NEAREST, "GL_LINEAR_MIPMAP_NEAREST" },
    { GLenum::GL_NEAREST_MIPMAP_LINEAR, "GL_NEAREST_MIPMAP_LINEAR" },
    { GLenum::GL_LINEAR_MIPMAP_LINEAR, "GL_LINEAR_MIPMAP_LINEAR" },
    { GLenum::GL_TEXTURE_MAG_FILTER, "GL_TEXTURE_MAG_FILTER" },
    { GLenum::GL_TEXTURE_MIN_FILTER, "GL_TEXTURE_MIN_FILTER" },
    { GLenum::GL_TEXTURE_WRAP_S, "GL_TEXTURE_WRAP_S" },
    { GLenum::GL_TEXTURE_WRAP_T, "GL_TEXTURE_WRAP_T" },
    { GLenum::GL_CLAMP, "GL_CLAMP" },
    { GLenum::GL_REPEAT, "GL_REPEAT" },
    { GLenum::GL_POLYGON_OFFSET_UNITS, "GL_POLYGON_OFFSET_UNITS" },
    { GLenum::GL_POLYGON_OFFSET_POINT, "GL_POLYGON_OFFSET_POINT" },
    { GLenum::GL_POLYGON_OFFSET_LINE, "GL_POLYGON_OFFSET_LINE" },
    { GLenum::GL_R3_G3_B2, "GL_R3_G3_B2" },
    { GLenum::GL_V2F, "GL_V2F" },
    { GLenum::GL_V3F, "GL_V3F" },
    { GLenum::GL_C4UB_V2F, "GL_C4UB_V2F" },
    { GLenum::GL_C4UB_V3F, "GL_C4UB_V3F" },
    { GLenum::GL_C3F_V3F, "GL_C3F_V3F" },
    { GLenum::GL_N3F_V3F, "GL_N3F_V3F" },
    { GLenum::GL_C4F_N3F_V3F, "GL_C4F_N3F_V3F" },
    { GLenum::GL_T2F_V3F, "GL_T2F_V3F" },
    { GLenum::GL_T4F_V4F, "GL_T4F_V4F" },
    { GLenum::GL_T2F_C4UB_V3F, "GL_T2F_C4UB_V3F" },
    { GLenum::GL_T2F_C3F_V3F, "GL_T2F_C3F_V3F" },
    { GLenum::GL_T2F_N3F_V3F, "GL_T2F_N3F_V3F" },
    { GLenum::GL_T2F_C4F_N3F_V3F, "GL_T2F_C4F_N3F_V3F" },
    { GLenum::GL_T4F_C4F_N3F_V4F, "GL_T4F_C4F_N3F_V4F" },
    { GLenum::GL_CLIP_DISTANCE0, "GL_CLIP_DISTANCE0" },
    { GLenum::GL_CLIP_DISTANCE1, "GL_CLIP_DISTANCE1" },
    { GLenum::GL_CLIP_DISTANCE2, "GL_CLIP_DISTANCE2" },
    { GLenum::GL_CLIP_DISTANCE3, "GL_CLIP_DISTANCE3" },
    { GLenum::GL_CLIP_DISTANCE4, "GL_CLIP_DISTANCE4" },
    { GLenum::GL_CLIP_DISTANCE5, "GL_CLIP_DISTANCE5" },
    { GLenum::GL_CLIP_DISTANCE6, "GL_CLIP_DISTANCE6" },
    { GLenum::GL_CLIP_DISTANCE7, "GL_CLIP_DISTANCE7" },
    { GLenum::GL_LIGHT0, "GL_LIGHT0" },
    { GLenum::GL_LIGHT1, "GL_LIGHT1" },
    { GLenum::GL_LIGHT2, "GL_LIGHT2" },
    { GLenum::GL_LIGHT3, "GL_LIGHT3" },
    { GLenum::GL_LIGHT4, "GL_LIGHT4" },
    { GLenum::GL_LIGHT5, "GL_LIGHT5" },
    { GLenum::GL_LIGHT6, "GL_LIGHT6" },
    { GLenum::GL_LIGHT7, "GL_LIGHT7" },
    { GLenum::GL_ABGR_EXT, "GL_ABGR_EXT" },
    { GLenum::GL_CONSTANT_COLOR, "GL_CONSTANT_COLOR" },
    { GLenum::GL_ONE_MINUS_CONSTANT_COLOR, "GL_ONE_MINUS_CONSTANT_COLOR" },
    { GLenum::GL_CONSTANT_ALPHA, "GL_CONSTANT_ALPHA" },
    { GLenum::GL_ONE_MINUS_CONSTANT_ALPHA, "GL_ONE_MINUS_CONSTANT_ALPHA" },
    { GLenum::GL_BLEND_COLOR, "GL_BLEND_COLOR" },
    { GLenum::GL_FUNC_ADD, "GL_FUNC_ADD" },
    { GLenum::GL_MIN, "GL_MIN" },
    { GLenum::GL_MAX, "GL_MAX" },
    { GLenum::GL_BLEND_EQUATION, "GL_BLEND_EQUATION" },
    { GLenum::GL_FUNC_SUBTRACT, "GL_FUNC_SUBTRACT" },
    { GLenum::GL_FUNC_REVERSE_SUBTRACT, "GL_FUNC_REVERSE_SUBTRACT" },
    { GLenum::GL_CMYK_EXT, "GL_CMYK_EXT" },
    { GLenum::GL_CMYKA_EXT, "GL_CMYKA_EXT" },
    { GLenum::GL_PACK_CMYK_HINT_EXT, "GL_PACK_CMYK_HINT_EXT" },
    { GLenum::GL_UNPACK_CMYK_HINT_EXT, "GL_UNPACK_CMYK_HINT_EXT" },
    { GLenum::GL_CONVOLUTION_1D, "GL_CONVOLUTION_1D" },
    { GLenum::GL_CONVOLUTION_2D, "GL_CONVOLUTION_2D" },
    { GLenum::GL_SEPARABLE_2D, "GL_SEPARABLE_2D" },
    { GLenum::GL_CONVOLUTION_BORDER_MODE, "GL_CONVOLUTION_BORDER_MODE" },
    { GLenum::GL_CONVOLUTION_FILTER_SCALE, "GL_CONVOLUTION_FILTER_SCALE" },
    { GLenum::GL_CONVOLUTION_FILTER_BIAS, "GL_CONVOLUTION_FILTER_BIAS" },
    { GLenum::GL_REDUCE, "GL_REDUCE" },
    { GLenum::GL_CONVOLUTION_FORMAT, "GL_CONVOLUTION_FORMAT" },
    { GLenum::GL_CONVOLUTION_WIDTH, "GL_CONVOLUTION_WIDTH" },
    { GLenum::GL_CONVOLUTION_HEIGHT, "GL_CONVOLUTION_HEIGHT" },
    { GLenum::GL_MAX_CONVOLUTION_WIDTH, "GL_MAX_CONVOLUTION_WIDTH" },
    { GLenum::GL_MAX_CONVOLUTION_HEIGHT, "GL_MAX_CONVOLUTION_HEIGHT" },
    { GLenum::GL_POST_CONVOLUTION_RED_SCALE, "GL_POST_CONVOLUTION_RED_SCALE" },
    { GLenum::GL_POST_CONVOLUTION_GREEN_SCALE, "GL_POST_CONVOLUTION_GREEN_SCALE" },
    { GLenum::GL_POST_CONVOLUTION_BLUE_SCALE, "GL_POST_CONVOLUTION_BLUE_SCALE" },
    { GLenum::GL_POST_CONVOLUTION_ALPHA_SCALE, "GL_POST_CONVOLUTION_ALPHA_SCALE" },
    { GLenum::GL_POST_CONVOLUTION_RED_BIAS, "GL_POST_CONVOLUTION_RED_BIAS" },
    { GLenum::GL_POST_CONVOLUTION_GREEN_BIAS, "GL_POST_CONVOLUTION_GREEN_BIAS" },
    { GLenum::GL_POST_CONVOLUTION_BLUE_BIAS, "GL_POST_CONVOLUTION_BLUE_BIAS" },
    { GLenum::GL_POST_CONVOLUTION_ALPHA_BIAS, "GL_POST_CONVOLUTION_ALPHA_BIAS" },
    { GLenum::GL_HISTOGRAM, "GL_HISTOGRAM" },
    { GLenum::GL_PROXY_HISTOGRAM, "GL_PROXY_HISTOGRAM" },
    { GLenum::GL_HISTOGRAM_WIDTH, "GL_HISTOGRAM_WIDTH" },
    { GLenum::GL_HISTOGRAM_FORMAT, "GL_HISTOGRAM_FORMAT" },
    { GLenum::GL_HISTOGRAM_RED_SIZE, "GL_HISTOGRAM_RED_SIZE" },
    { GLenum::GL_HISTOGRAM_GREEN_SIZE, "GL_HISTOGRAM_GREEN_SIZE" },
    { GLenum::GL_HISTOGRAM_BLUE_SIZE, "GL_HISTOGRAM_BLUE_SIZE" },
    { GLenum::GL_HISTOGRAM_ALPHA_SIZE, "GL_HISTOGRAM_ALPHA_SIZE" },
    { GLenum::GL_HISTOGRAM_LUMINANCE_SIZE, "GL_HISTOGRAM_LUMINANCE_SIZE" },
    { GLenum::GL_HISTOGRAM_SINK, "GL_HISTOGRAM_SINK" },
    { GLenum::GL_MINMAX, "GL_MINMAX" },
    { GLenum::GL_MINMAX_FORMAT, "GL_MINMAX_FORMAT" },
    { GLenum::GL_MINMAX_SINK, "GL_MINMAX_SINK" },
    { GLenum::GL_TABLE_TOO_LARGE, "GL_TABLE_TOO_LARGE" },
    { GLenum::GL_UNSIGNED_BYTE_3_3_2, "GL_UNSIGNED_BYTE_3_3_2" },
    { GLenum::GL_UNSIGNED_SHORT_4_4_4_4, "GL_UNSIGNED_SHORT_4_4_4_4" },
    { GLenum::GL_UNSIGNED_SHORT_5_5_5_1, "GL_UNSIGNED_SHORT_5_5_5_1" },
    { GLenum::GL_UNSIGNED_INT_8_8_8_8, "GL_UNSIGNED_INT_8_8_8_8" },
    { GLenum::GL_UNSIGNED_INT_10_10_10_2, "GL_UNSIGNED_INT_10_10_10_2" },
    { GLenum::GL_POLYGON_OFFSET_FILL, "GL_POLYGON_OFFSET_FILL" },
    { GLenum::GL_POLYGON_OFFSET_FACTOR, "GL_POLYGON_OFFSET_FACTOR" },
    { GLenum::GL_POLYGON_OFFSET_BIAS_EXT, "GL_POLYGON_OFFSET_BIAS_EXT" },
    { GLenum::GL_RESCALE_NORMAL, "GL_RESCALE_NORMAL" },
    { GLenum::GL_ALPHA4, "GL_ALPHA4" },
    { GLenum::GL_ALPHA8, "GL_ALPHA8" },
    { GLenum::GL_ALPHA12, "GL_ALPHA12" },
    { GLenum::GL_ALPHA16, "GL_ALPHA16" },
    { GLenum::GL_LUMINANCE4, "GL_LUMINANCE4" },
    { GLenum::GL_LUMINANCE8, "GL_LUMINANCE8" },
    { GLenum::GL_LUMINANCE12, "GL_LUMINANCE12" },
    { GLenum::GL_LUMINANCE16, "GL_LUMINANCE16" },
    { GLenum::GL_LUMINANCE4_ALPHA4, "GL_LUMINANCE4_ALPHA4" },
    { GLenum::GL_LUMINANCE6_ALPHA2, "GL_LUMINANCE6_ALPHA2" },
    { GLenum::GL_LUMINANCE8_ALPHA8, "GL_LUMINANCE8_ALPHA8" },
    { GLenum::GL_LUMINANCE12_ALPHA4, "GL_LUMINANCE12_ALPHA4" },
    { GLenum::GL_LUMINANCE12_ALPHA12, "GL_LUMINANCE12_ALPHA12" },
    { GLenum::GL_LUMINANCE16_ALPHA16, "GL_LUMINANCE16_ALPHA16" },
    { GLenum::GL_INTENSITY, "GL_INTENSITY" },
    { GLenum::GL_INTENSITY4, "GL_INTENSITY4" },
    { GLenum::GL_INTENSITY8, "GL_INTENSITY8" },
    { GLenum::GL_INTENSITY12, "GL_INTENSITY12" },
    { GLenum::GL_INTENSITY16, "GL_INTENSITY16" },
    { GLenum::GL_RGB2_EXT, "GL_RGB2_EXT" },
    { GLenum::GL_RGB4, "GL_RGB4" },
    { GLenum::GL_RGB5, "GL_RGB5" },
    { GLenum::GL_RGB8, "GL_RGB8" },
    { GLenum::GL_RGB10, "GL_RGB10" },
    { GLenum::GL_RGB12, "GL_RGB12" },
    { GLenum::GL_RGB16, "GL_RGB16" },
    { GLenum::GL_RGBA2, "GL_RGBA2" },
    { GLenum::GL_RGBA4, "GL_RGBA4" },
    { GLenum::GL_RGB5_A1, "GL_RGB5_A1" },
    { GLenum::GL_RGBA8, "GL_RGBA8" },
    { GLenum::GL_RGB10_A2, "GL_RGB10_A2" },
    { GLenum::GL_RGBA12, "GL_RGBA12" },
    { GLenum::GL_RGBA16, "GL_RGBA16" },
    { GLenum::GL_TEXTURE_RED_SIZE, "GL_TEXTURE_RED_SIZE" },
    { GLenum::GL_TEXTURE_GREEN_SIZE, "GL_TEXTURE_GREEN_SIZE" },
    { GLenum::GL_TEXTURE_BLUE_SIZE, "GL_TEXTURE_BLUE_SIZE" },
    { GLenum::GL_TEXTURE_ALPHA_SIZE, "GL_TEXTURE_ALPHA_SIZE" },
    { GLenum::GL_TEXTURE_LUMINANCE_SIZE, "GL_TEXTURE_LUMINANCE_SIZE" },
    { GLenum::GL_TEXTURE_INTENSITY_SIZE, "GL_TEXTURE_INTENSITY_SIZE" },
    { GLenum::GL_REPLACE_EXT, "GL_REPLACE_EXT" },
    { GLenum::GL_PROXY_TEXTURE_1D, "GL_PROXY_TEXTURE_1D" },
    { GLenum::GL_PROXY_TEXTURE_2D, "GL_PROXY_TEXTURE_2D" },
    { GLenum::GL_TEXTURE_TOO_LARGE_EXT, "GL_TEXTURE_TOO_LARGE_EXT" },
    { GLenum::GL_TEXTURE_PRIORITY, "GL_TEXTURE_PRIORITY" },
    { GLenum::GL_TEXTURE_RESIDENT, "GL_TEXTURE_RESIDENT" },
    { GLenum::GL_TEXTURE_BINDING_1D, "GL_TEXTURE_BINDING_1D" },
    { GLenum::GL_TEXTURE_BINDING_2D, "GL_TEXTURE_BINDING_2D" },
    { GLenum::GL_TEXTURE_BINDING_3D, "GL_TEXTURE_BINDING_3D" },
    { GLenum::GL_PACK_SKIP_IMAGES, "GL_PACK_SKIP_IMAGES" },
    { GLenum::GL_PACK_IMAGE_HEIGHT, "GL_PACK_IMAGE_HEIGHT" },
    { GLenum::GL_UNPACK_SKIP_IMAGES, "GL_UNPACK_SKIP_IMAGES" },
    { GLenum::GL_UNPACK_IMAGE_HEIGHT, "GL_UNPACK_IMAGE_HEIGHT" },
    { GLenum::GL_TEXTURE_3D, "GL_TEXTURE_3D" },
    { GLenum::GL_PROXY_TEXTURE_3D, "GL_PROXY_TEXTURE_3D" },
    { GLenum::GL_TEXTURE_DEPTH, "GL_TEXTURE_DEPTH" },
    { GLenum::GL_TEXTURE_WRAP_R, "GL_TEXTURE_WRAP_R" },
    { GLenum::GL_MAX_3D_TEXTURE_SIZE, "GL_MAX_3D_TEXTURE_SIZE" },
    { GLenum::GL_VERTEX_ARRAY, "GL_VERTEX_ARRAY" },
    { GLenum::GL_NORMAL_ARRAY, "GL_NORMAL_ARRAY" },
    { GLenum::GL_COLOR_ARRAY, "GL_COLOR_ARRAY" },
    { GLenum::GL_INDEX_ARRAY, "GL_INDEX_ARRAY" },
    { GLenum::GL_TEXTURE_COORD_ARRAY, "GL_TEXTURE_COORD_ARRAY" },
    { GLenum::GL_EDGE_FLAG_ARRAY, "GL_EDGE_FLAG_ARRAY" },
    { GLenum::GL_VERTEX_ARRAY_SIZE, "GL_VERTEX_ARRAY_SIZE" },
    { GLenum::GL_VERTEX_ARRAY_TYPE, "GL_VERTEX_ARRAY_TYPE" },
    { GLenum::GL_VERTEX_ARRAY_STRIDE, "GL_VERTEX_ARRAY_STRIDE" },
    { GLenum::GL_VERTEX_ARRAY_COUNT_EXT, "GL_VERTEX_ARRAY_COUNT_EXT" },
    { GLenum::GL_NORMAL_ARRAY_TYPE, "GL_NORMAL_ARRAY_TYPE" },
    { GLenum::GL_NORMAL_ARRAY_STRIDE, "GL_NORMAL_ARRAY_STRIDE" },
    { GLenum::GL_NORMAL_ARRAY_COUNT_EXT, "GL_NORMAL_ARRAY_COUNT_EXT" },
    { GLenum::GL_COLOR_ARRAY_SIZE, "GL_COLOR_ARRAY_SIZE" },
    { GLenum::GL_COLOR_ARRAY_TYPE, "GL_COLOR_ARRAY_TYPE" },
    { GLenum::GL_COLOR_ARRAY_STRIDE, "GL_COLOR_ARRAY_STRIDE" },
    { GLenum::GL_COLOR_ARRAY_COUNT_EXT, "GL_COLOR_ARRAY_COUNT_EXT" },
    { GLenum::GL_INDEX_ARRAY_TYPE, "GL_INDEX_ARRAY_TYPE" },
    { GLenum::GL_INDEX_ARRAY_STRIDE, "GL_INDEX_ARRAY_STRIDE" },
    { GLenum::GL_INDEX_ARRAY_COUNT_EXT, "GL_INDEX_ARRAY_COUNT_EXT" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_SIZE, "GL_TEXTURE_COORD_ARRAY_SIZE" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_TYPE, "GL_TEXTURE_COORD_ARRAY_TYPE" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_STRIDE, "GL_TEXTURE_COORD_ARRAY_STRIDE" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_COUNT_EXT, "GL_TEXTURE_COORD_ARRAY_COUNT_EXT" },
    { GLenum::GL_EDGE_FLAG_ARRAY_STRIDE, "GL_EDGE_FLAG_ARRAY_STRIDE" },
    { GLenum::GL_EDGE_FLAG_ARRAY_COUNT_EXT, "GL_EDGE_FLAG_ARRAY_COUNT_EXT" },
    { GLenum::GL_VERTEX_ARRAY_POINTER, "GL_VERTEX_ARRAY_POINTER" },
    { GLenum::GL_NORMAL_ARRAY_POINTER, "GL_NORMAL_ARRAY_POINTER" },
    { GLenum::GL_COLOR_ARRAY_POINTER, "GL_COLOR_ARRAY_POINTER" },
    { GLenum::GL_INDEX_ARRAY_POINTER, "GL_INDEX_ARRAY_POINTER" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_POINTER, "GL_TEXTURE_COORD_ARRAY_POINTER" },
    { GLenum::GL_EDGE_FLAG_ARRAY_POINTER, "GL_EDGE_FLAG_ARRAY_POINTER" },
    { GLenum::GL_INTERLACE_SGIX, "GL_INTERLACE_SGIX" },
    { GLenum::GL_DETAIL_TEXTURE_2D_SGIS, "GL_DETAIL_TEXTURE_2D_SGIS" },
    { GLenum::GL_DETAIL_TEXTURE_2D_BINDING_SGIS, "GL_DETAIL_TEXTURE_2D_BINDING_SGIS" },
    { GLenum::GL_LINEAR_DETAIL_SGIS, "GL_LINEAR_DETAIL_SGIS" },
    { GLenum::GL_LINEAR_DETAIL_ALPHA_SGIS, "GL_LINEAR_DETAIL_ALPHA_SGIS" },
    { GLenum::GL_LINEAR_DETAIL_COLOR_SGIS, "GL_LINEAR_DETAIL_COLOR_SGIS" },
    { GLenum::GL_DETAIL_TEXTURE_LEVEL_SGIS, "GL_DETAIL_TEXTURE_LEVEL_SGIS" },
    { GLenum::GL_DETAIL_TEXTURE_MODE_SGIS, "GL_DETAIL_TEXTURE_MODE_SGIS" },
    { GLenum::GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS, "GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS" },
    { GLenum::GL_MULTISAMPLE, "GL_MULTISAMPLE" },
    { GLenum::GL_SAMPLE_ALPHA_TO_COVERAGE, "GL_SAMPLE_ALPHA_TO_COVERAGE" },
    { GLenum::GL_SAMPLE_ALPHA_TO_ONE, "GL_SAMPLE_ALPHA_TO_ONE" },
    { GLenum::GL_SAMPLE_COVERAGE, "GL_SAMPLE_COVERAGE" },
    { GLenum::GL_1PASS_EXT, "GL_1PASS_EXT" },
    { GLenum::GL_2PASS_0_EXT, "GL_2PASS_0_EXT" },
    { GLenum::GL_2PASS_1_EXT, "GL_2PASS_1_EXT" },
    { GLenum::GL_4PASS_0_EXT, "GL_4PASS_0_EXT" },
    { GLenum::GL_4PASS_1_EXT, "GL_4PASS_1_EXT" },
    { GLenum::GL_4PASS_2_EXT, "GL_4PASS_2_EXT" },
    { GLenum::GL_4PASS_3_EXT, "GL_4PASS_3_EXT" },
    { GLenum::GL_SAMPLE_BUFFERS, "GL_SAMPLE_BUFFERS" },
    { GLenum::GL_SAMPLES, "GL_SAMPLES" },
    { GLenum::GL_SAMPLE_COVERAGE_VALUE, "GL_SAMPLE_COVERAGE_VALUE" },
    { GLenum::GL_SAMPLE_COVERAGE_INVERT, "GL_SAMPLE_COVERAGE_INVERT" },
    { GLenum::GL_SAMPLE_PATTERN_EXT, "GL_SAMPLE_PATTERN_EXT" },
    { GLenum::GL_LINEAR_SHARPEN_SGIS, "GL_LINEAR_SHARPEN_SGIS" },
    { GLenum::GL_LINEAR_SHARPEN_ALPHA_SGIS, "GL_LINEAR_SHARPEN_ALPHA_SGIS" },
    { GLenum::GL_LINEAR_SHARPEN_COLOR_SGIS, "GL_LINEAR_SHARPEN_COLOR_SGIS" },
    { GLenum::GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS, "GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS" },
    { GLenum::GL_COLOR_MATRIX, "GL_COLOR_MATRIX" },
    { GLenum::GL_COLOR_MATRIX_STACK_DEPTH, "GL_COLOR_MATRIX_STACK_DEPTH" },
    { GLenum::GL_MAX_COLOR_MATRIX_STACK_DEPTH, "GL_MAX_COLOR_MATRIX_STACK_DEPTH" },
    { GLenum::GL_POST_COLOR_MATRIX_RED_SCALE, "GL_POST_COLOR_MATRIX_RED_SCALE" },
    { GLenum::GL_POST_COLOR_MATRIX_GREEN_SCALE, "GL_POST_COLOR_MATRIX_GREEN_SCALE" },
    { GLenum::GL_POST_COLOR_MATRIX_BLUE_SCALE, "GL_POST_COLOR_MATRIX_BLUE_SCALE" },
    { GLenum::GL_POST_COLOR_MATRIX_ALPHA_SCALE, "GL_POST_COLOR_MATRIX_ALPHA_SCALE" },
    { GLenum::GL_POST_COLOR_MATRIX_RED_BIAS, "GL_POST_COLOR_MATRIX_RED_BIAS" },
    { GLenum::GL_POST_COLOR_MATRIX_GREEN_BIAS, "GL_POST_COLOR_MATRIX_GREEN_BIAS" },
    { GLenum::GL_POST_COLOR_MATRIX_BLUE_BIAS, "GL_POST_COLOR_MATRIX_BLUE_BIAS" },
    { GLenum::GL_POST_COLOR_MATRIX_ALPHA_BIAS, "GL_POST_COLOR_MATRIX_ALPHA_BIAS" },
    { GLenum::GL_TEXTURE_COLOR_TABLE_SGI, "GL_TEXTURE_COLOR_TABLE_SGI" },
    { GLenum::GL_PROXY_TEXTURE_COLOR_TABLE_SGI, "GL_PROXY_TEXTURE_COLOR_TABLE_SGI" },
    { GLenum::GL_TEXTURE_ENV_BIAS_SGIX, "GL_TEXTURE_ENV_BIAS_SGIX" },
    { GLenum::GL_TEXTURE_COMPARE_FAIL_VALUE_ARB, "GL_TEXTURE_COMPARE_FAIL_VALUE_ARB" },
    { GLenum::GL_BLEND_DST_RGB, "GL_BLEND_DST_RGB" },
    { GLenum::GL_BLEND_SRC_RGB, "GL_BLEND_SRC_RGB" },
    { GLenum::GL_BLEND_DST_ALPHA, "GL_BLEND_DST_ALPHA" },
    { GLenum::GL_BLEND_SRC_ALPHA, "GL_BLEND_SRC_ALPHA" },
    { GLenum::GL_422_EXT, "GL_422_EXT" },
    { GLenum::GL_422_REV_EXT, "GL_422_REV_EXT" },
    { GLenum::GL_422_AVERAGE_EXT, "GL_422_AVERAGE_EXT" },
    { GLenum::GL_422_REV_AVERAGE_EXT, "GL_422_REV_AVERAGE_EXT" },
    { GLenum::GL_COLOR_TABLE, "GL_COLOR_TABLE" },
    { GLenum::GL_POST_CONVOLUTION_COLOR_TABLE, "GL_POST_CONVOLUTION_COLOR_TABLE" },
    { GLenum::GL_POST_COLOR_MATRIX_COLOR_TABLE, "GL_POST_COLOR_MATRIX_COLOR_TABLE" },
    { GLenum::GL_PROXY_COLOR_TABLE, "GL_PROXY_COLOR_TABLE" },
    { GLenum::GL_PROXY_POST_CONVOLUTION_COLOR_TABLE, "GL_PROXY_POST_CONVOLUTION_COLOR_TABLE" },
    { GLenum::GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE, "GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE" },
    { GLenum::GL_COLOR_TABLE_SCALE, "GL_COLOR_TABLE_SCALE" },
    { GLenum::GL_COLOR_TABLE_BIAS, "GL_COLOR_TABLE_BIAS" },
    { GLenum::GL_COLOR_TABLE_FORMAT, "GL_COLOR_TABLE_FORMAT" },
    { GLenum::GL_COLOR_TABLE_WIDTH, "GL_COLOR_TABLE_WIDTH" },
    { GLenum::GL_COLOR_TABLE_RED_SIZE, "GL_COLOR_TABLE_RED_SIZE" },
    { GLenum::GL_COLOR_TABLE_GREEN_SIZE, "GL_COLOR_TABLE_GREEN_SIZE" },
    { GLenum::GL_COLOR_TABLE_BLUE_SIZE, "GL_COLOR_TABLE_BLUE_SIZE" },
    { GLenum::GL_COLOR_TABLE_ALPHA_SIZE, "GL_COLOR_TABLE_ALPHA_SIZE" },
    { GLenum::GL_COLOR_TABLE_LUMINANCE_SIZE, "GL_COLOR_TABLE_LUMINANCE_SIZE" },
    { GLenum::GL_COLOR_TABLE_INTENSITY_SIZE, "GL_COLOR_TABLE_INTENSITY_SIZE" },
    { GLenum::GL_BGR, "GL_BGR" },
    { GLenum::GL_BGRA, "GL_BGRA" },
    { GLenum::GL_COLOR_INDEX1_EXT, "GL_COLOR_INDEX1_EXT" },
    { GLenum::GL_COLOR_INDEX2_EXT, "GL_COLOR_INDEX2_EXT" },
    { GLenum::GL_COLOR_INDEX4_EXT, "GL_COLOR_INDEX4_EXT" },
    { GLenum::GL_COLOR_INDEX8_EXT, "GL_COLOR_INDEX8_EXT" },
    { GLenum::GL_COLOR_INDEX12_EXT, "GL_COLOR_INDEX12_EXT" },
    { GLenum::GL_COLOR_INDEX16_EXT, "GL_COLOR_INDEX16_EXT" },
    { GLenum::GL_MAX_ELEMENTS_VERTICES, "GL_MAX_ELEMENTS_VERTICES" },
    { GLenum::GL_MAX_ELEMENTS_INDICES, "GL_MAX_ELEMENTS_INDICES" },
    { GLenum::GL_PHONG_WIN, "GL_PHONG_WIN" },
    { GLenum::GL_PHONG_HINT_WIN, "GL_PHONG_HINT_WIN" },
    { GLenum::GL_FOG_SPECULAR_TEXTURE_WIN, "GL_FOG_SPECULAR_TEXTURE_WIN" },
    { GLenum::GL_TEXTURE_INDEX_SIZE_EXT, "GL_TEXTURE_INDEX_SIZE_EXT" },
    { GLenum::GL_PARAMETER_BUFFER_ARB, "GL_PARAMETER_BUFFER_ARB" },
    { GLenum::GL_PARAMETER_BUFFER_BINDING_ARB, "GL_PARAMETER_BUFFER_BINDING_ARB" },
    { GLenum::GL_CLIP_VOLUME_CLIPPING_HINT_EXT, "GL_CLIP_VOLUME_CLIPPING_HINT_EXT" },
    { GLenum::GL_DUAL_ALPHA4_SGIS, "GL_DUAL_ALPHA4_SGIS" },
    { GLenum::GL_DUAL_ALPHA8_SGIS, "GL_DUAL_ALPHA8_SGIS" },
    { GLenum::GL_DUAL_ALPHA12_SGIS, "GL_DUAL_ALPHA12_SGIS" },
    { GLenum::GL_DUAL_ALPHA16_SGIS, "GL_DUAL_ALPHA16_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE4_SGIS, "GL_DUAL_LUMINANCE4_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE8_SGIS, "GL_DUAL_LUMINANCE8_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE12_SGIS, "GL_DUAL_LUMINANCE12_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE16_SGIS, "GL_DUAL_LUMINANCE16_SGIS" },
    { GLenum::GL_DUAL_INTENSITY4_SGIS, "GL_DUAL_INTENSITY4_SGIS" },
    { GLenum::GL_DUAL_INTENSITY8_SGIS, "GL_DUAL_INTENSITY8_SGIS" },
    { GLenum::GL_DUAL_INTENSITY12_SGIS, "GL_DUAL_INTENSITY12_SGIS" },
    { GLenum::GL_DUAL_INTENSITY16_SGIS, "GL_DUAL_INTENSITY16_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE_ALPHA4_SGIS, "GL_DUAL_LUMINANCE_ALPHA4_SGIS" },
    { GLenum::GL_DUAL_LUMINANCE_ALPHA8_SGIS, "GL_DUAL_LUMINANCE_ALPHA8_SGIS" },
    { GLenum::GL_QUAD_ALPHA4_SGIS, "GL_QUAD_ALPHA4_SGIS" },
    { GLenum::GL_QUAD_ALPHA8_SGIS, "GL_QUAD_ALPHA8_SGIS" },
    { GLenum::GL_QUAD_LUMINANCE4_SGIS, "GL_QUAD_LUMINANCE4_SGIS" },
    { GLenum::GL_QUAD_LUMINANCE8_SGIS, "GL_QUAD_LUMINANCE8_SGIS" },
    { GLenum::GL_QUAD_INTENSITY4_SGIS, "GL_QUAD_INTENSITY4_SGIS" },
    { GLenum::GL_QUAD_INTENSITY8_SGIS, "GL_QUAD_INTENSITY8_SGIS" },
    { GLenum::GL_DUAL_TEXTURE_SELECT_SGIS, "GL_DUAL_TEXTURE_SELECT_SGIS" },
    { GLenum::GL_QUAD_TEXTURE_SELECT_SGIS, "GL_QUAD_TEXTURE_SELECT_SGIS" },
    { GLenum::GL_POINT_SIZE_MIN, "GL_POINT_SIZE_MIN" },
    { GLenum::GL_POINT_SIZE_MAX, "GL_POINT_SIZE_MAX" },
    { GLenum::GL_POINT_FADE_THRESHOLD_SIZE, "GL_POINT_FADE_THRESHOLD_SIZE" },
    { GLenum::GL_POINT_DISTANCE_ATTENUATION, "GL_POINT_DISTANCE_ATTENUATION" },
    { GLenum::GL_FOG_FUNC_SGIS, "GL_FOG_FUNC_SGIS" },
    { GLenum::GL_FOG_FUNC_POINTS_SGIS, "GL_FOG_FUNC_POINTS_SGIS" },
    { GLenum::GL_MAX_FOG_FUNC_POINTS_SGIS, "GL_MAX_FOG_FUNC_POINTS_SGIS" },
    { GLenum::GL_CLAMP_TO_BORDER, "GL_CLAMP_TO_BORDER" },
    { GLenum::GL_TEXTURE_MULTI_BUFFER_HINT_SGIX, "GL_TEXTURE_MULTI_BUFFER_HINT_SGIX" },
    { GLenum::GL_CLAMP_TO_EDGE, "GL_CLAMP_TO_EDGE" },
    { GLenum::GL_PACK_SKIP_VOLUMES_SGIS, "GL_PACK_SKIP_VOLUMES_SGIS" },
    { GLenum::GL_PACK_IMAGE_DEPTH_SGIS, "GL_PACK_IMAGE_DEPTH_SGIS" },
    { GLenum::GL_UNPACK_SKIP_VOLUMES_SGIS, "GL_UNPACK_SKIP_VOLUMES_SGIS" },
    { GLenum::GL_UNPACK_IMAGE_DEPTH_SGIS, "GL_UNPACK_IMAGE_DEPTH_SGIS" },
    { GLenum::GL_TEXTURE_4D_SGIS, "GL_TEXTURE_4D_SGIS" },
    { GLenum::GL_PROXY_TEXTURE_4D_SGIS, "GL_PROXY_TEXTURE_4D_SGIS" },
    { GLenum::GL_TEXTURE_4DSIZE_SGIS, "GL_TEXTURE_4DSIZE_SGIS" },
    { GLenum::GL_TEXTURE_WRAP_Q_SGIS, "GL_TEXTURE_WRAP_Q_SGIS" },
    { GLenum::GL_MAX_4D_TEXTURE_SIZE_SGIS, "GL_MAX_4D_TEXTURE_SIZE_SGIS" },
    { GLenum::GL_PIXEL_TEX_GEN_SGIX, "GL_PIXEL_TEX_GEN_SGIX" },
    { GLenum::GL_TEXTURE_MIN_LOD, "GL_TEXTURE_MIN_LOD" },
    { GLenum::GL_TEXTURE_MAX_LOD, "GL_TEXTURE_MAX_LOD" },
    { GLenum::GL_TEXTURE_BASE_LEVEL, "GL_TEXTURE_BASE_LEVEL" },
    { GLenum::GL_TEXTURE_MAX_LEVEL, "GL_TEXTURE_MAX_LEVEL" },
    { GLenum::GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX, "GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX" },
    { GLenum::GL_PIXEL_TILE_CACHE_INCREMENT_SGIX, "GL_PIXEL_TILE_CACHE_INCREMENT_SGIX" },
    { GLenum::GL_PIXEL_TILE_WIDTH_SGIX, "GL_PIXEL_TILE_WIDTH_SGIX" },
    { GLenum::GL_PIXEL_TILE_HEIGHT_SGIX, "GL_PIXEL_TILE_HEIGHT_SGIX" },
    { GLenum::GL_PIXEL_TILE_GRID_WIDTH_SGIX, "GL_PIXEL_TILE_GRID_WIDTH_SGIX" },
    { GLenum::GL_PIXEL_TILE_GRID_HEIGHT_SGIX, "GL_PIXEL_TILE_GRID_HEIGHT_SGIX" },
    { GLenum::GL_PIXEL_TILE_GRID_DEPTH_SGIX, "GL_PIXEL_TILE_GRID_DEPTH_SGIX" },
    { GLenum::GL_PIXEL_TILE_CACHE_SIZE_SGIX, "GL_PIXEL_TILE_CACHE_SIZE_SGIX" },
    { GLenum::GL_FILTER4_SGIS, "GL_FILTER4_SGIS" },
    { GLenum::GL_TEXTURE_FILTER4_SIZE_SGIS, "GL_TEXTURE_FILTER4_SIZE_SGIS" },
    { GLenum::GL_SPRITE_SGIX, "GL_SPRITE_SGIX" },
    { GLenum::GL_SPRITE_MODE_SGIX, "GL_SPRITE_MODE_SGIX" },
    { GLenum::GL_SPRITE_AXIS_SGIX, "GL_SPRITE_AXIS_SGIX" },
    { GLenum::GL_SPRITE_TRANSLATION_SGIX, "GL_SPRITE_TRANSLATION_SGIX" },
    { GLenum::GL_SPRITE_AXIAL_SGIX, "GL_SPRITE_AXIAL_SGIX" },
    { GLenum::GL_SPRITE_OBJECT_ALIGNED_SGIX, "GL_SPRITE_OBJECT_ALIGNED_SGIX" },
    { GLenum::GL_SPRITE_EYE_ALIGNED_SGIX, "GL_SPRITE_EYE_ALIGNED_SGIX" },
    { GLenum::GL_TEXTURE_4D_BINDING_SGIS, "GL_TEXTURE_4D_BINDING_SGIS" },
    { GLenum::GL_IGNORE_BORDER_HP, "GL_IGNORE_BORDER_HP" },
    { GLenum::GL_CONSTANT_BORDER, "GL_CONSTANT_BORDER" },
    { GLenum::GL_REPLICATE_BORDER, "GL_REPLICATE_BORDER" },
    { GLenum::GL_CONVOLUTION_BORDER_COLOR, "GL_CONVOLUTION_BORDER_COLOR" },
    { GLenum::GL_IMAGE_SCALE_X_HP, "GL_IMAGE_SCALE_X_HP" },
    { GLenum::GL_IMAGE_SCALE_Y_HP, "GL_IMAGE_SCALE_Y_HP" },
    { GLenum::GL_IMAGE_TRANSLATE_X_HP, "GL_IMAGE_TRANSLATE_X_HP" },
    { GLenum::GL_IMAGE_TRANSLATE_Y_HP, "GL_IMAGE_TRANSLATE_Y_HP" },
    { GLenum::GL_IMAGE_ROTATE_ANGLE_HP, "GL_IMAGE_ROTATE_ANGLE_HP" },
    { GLenum::GL_IMAGE_ROTATE_ORIGIN_X_HP, "GL_IMAGE_ROTATE_ORIGIN_X_HP" },
    { GLenum::GL_IMAGE_ROTATE_ORIGIN_Y_HP, "GL_IMAGE_ROTATE_ORIGIN_Y_HP" },
    { GLenum::GL_IMAGE_MAG_FILTER_HP, "GL_IMAGE_MAG_FILTER_HP" },
    { GLenum::GL_IMAGE_MIN_FILTER_HP, "GL_IMAGE_MIN_FILTER_HP" },
    { GLenum::GL_IMAGE_CUBIC_WEIGHT_HP, "GL_IMAGE_CUBIC_WEIGHT_HP" },
    { GLenum::GL_CUBIC_HP, "GL_CUBIC_HP" },
    { GLenum::GL_AVERAGE_HP, "GL_AVERAGE_HP" },
    { GLenum::GL_IMAGE_TRANSFORM_2D_HP, "GL_IMAGE_TRANSFORM_2D_HP" },
    { GLenum::GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP, "GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP" },
    { GLenum::GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP, "GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP" },
    { GLenum::GL_OCCLUSION_TEST_HP, "GL_OCCLUSION_TEST_HP" },
    { GLenum::GL_OCCLUSION_TEST_RESULT_HP, "GL_OCCLUSION_TEST_RESULT_HP" },
    { GLenum::GL_TEXTURE_LIGHTING_MODE_HP, "GL_TEXTURE_LIGHTING_MODE_HP" },
    { GLenum::GL_TEXTURE_POST_SPECULAR_HP, "GL_TEXTURE_POST_SPECULAR_HP" },
    { GLenum::GL_TEXTURE_PRE_SPECULAR_HP, "GL_TEXTURE_PRE_SPECULAR_HP" },
    { GLenum::GL_LINEAR_CLIPMAP_LINEAR_SGIX, "GL_LINEAR_CLIPMAP_LINEAR_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_CENTER_SGIX, "GL_TEXTURE_CLIPMAP_CENTER_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_FRAME_SGIX, "GL_TEXTURE_CLIPMAP_FRAME_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_OFFSET_SGIX, "GL_TEXTURE_CLIPMAP_OFFSET_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX, "GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX, "GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX" },
    { GLenum::GL_TEXTURE_CLIPMAP_DEPTH_SGIX, "GL_TEXTURE_CLIPMAP_DEPTH_SGIX" },
    { GLenum::GL_MAX_CLIPMAP_DEPTH_SGIX, "GL_MAX_CLIPMAP_DEPTH_SGIX" },
    { GLenum::GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX, "GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX" },
    { GLenum::GL_POST_TEXTURE_FILTER_BIAS_SGIX, "GL_POST_TEXTURE_FILTER_BIAS_SGIX" },
    { GLenum::GL_POST_TEXTURE_FILTER_SCALE_SGIX, "GL_POST_TEXTURE_FILTER_SCALE_SGIX" },
    { GLenum::GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX, "GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX" },
    { GLenum::GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX, "GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX" },
    { GLenum::GL_REFERENCE_PLANE_SGIX, "GL_REFERENCE_PLANE_SGIX" },
    { GLenum::GL_REFERENCE_PLANE_EQUATION_SGIX, "GL_REFERENCE_PLANE_EQUATION_SGIX" },
    { GLenum::GL_IR_INSTRUMENT1_SGIX, "GL_IR_INSTRUMENT1_SGIX" },
    { GLenum::GL_INSTRUMENT_BUFFER_POINTER_SGIX, "GL_INSTRUMENT_BUFFER_POINTER_SGIX" },
    { GLenum::GL_INSTRUMENT_MEASUREMENTS_SGIX, "GL_INSTRUMENT_MEASUREMENTS_SGIX" },
    { GLenum::GL_LIST_PRIORITY_SGIX, "GL_LIST_PRIORITY_SGIX" },
    { GLenum::GL_CALLIGRAPHIC_FRAGMENT_SGIX, "GL_CALLIGRAPHIC_FRAGMENT_SGIX" },
    { GLenum::GL_FRAMEZOOM_SGIX, "GL_FRAMEZOOM_SGIX" },
    { GLenum::GL_FRAMEZOOM_FACTOR_SGIX, "GL_FRAMEZOOM_FACTOR_SGIX" },
    { GLenum::GL_MAX_FRAMEZOOM_FACTOR_SGIX, "GL_MAX_FRAMEZOOM_FACTOR_SGIX" },
    { GLenum::GL_TEXTURE_LOD_BIAS_S_SGIX, "GL_TEXTURE_LOD_BIAS_S_SGIX" },
    { GLenum::GL_TEXTURE_LOD_BIAS_T_SGIX, "GL_TEXTURE_LOD_BIAS_T_SGIX" },
    { GLenum::GL_TEXTURE_LOD_BIAS_R_SGIX, "GL_TEXTURE_LOD_BIAS_R_SGIX" },
    { GLenum::GL_GENERATE_MIPMAP, "GL_GENERATE_MIPMAP" },
    { GLenum::GL_GENERATE_MIPMAP_HINT, "GL_GENERATE_MIPMAP_HINT" },
    { GLenum::GL_GEOMETRY_DEFORMATION_SGIX, "GL_GEOMETRY_DEFORMATION_SGIX" },
    { GLenum::GL_TEXTURE_DEFORMATION_SGIX, "GL_TEXTURE_DEFORMATION_SGIX" },
    { GLenum::GL_DEFORMATIONS_MASK_SGIX, "GL_DEFORMATIONS_MASK_SGIX" },
    { GLenum::GL_MAX_DEFORMATION_ORDER_SGIX, "GL_MAX_DEFORMATION_ORDER_SGIX" },
    { GLenum::GL_FOG_OFFSET_SGIX, "GL_FOG_OFFSET_SGIX" },
    { GLenum::GL_FOG_OFFSET_VALUE_SGIX, "GL_FOG_OFFSET_VALUE_SGIX" },
    { GLenum::GL_TEXTURE_COMPARE_SGIX, "GL_TEXTURE_COMPARE_SGIX" },
    { GLenum::GL_TEXTURE_COMPARE_OPERATOR_SGIX, "GL_TEXTURE_COMPARE_OPERATOR_SGIX" },
    { GLenum::GL_TEXTURE_LEQUAL_R_SGIX, "GL_TEXTURE_LEQUAL_R_SGIX" },
    { GLenum::GL_TEXTURE_GEQUAL_R_SGIX, "GL_TEXTURE_GEQUAL_R_SGIX" },
    { GLenum::GL_DEPTH_COMPONENT16, "GL_DEPTH_COMPONENT16" },
    { GLenum::GL_DEPTH_COMPONENT24, "GL_DEPTH_COMPONENT24" },
    { GLenum::GL_DEPTH_COMPONENT32, "GL_DEPTH_COMPONENT32" },
    { GLenum::GL_ARRAY_ELEMENT_LOCK_FIRST_EXT, "GL_ARRAY_ELEMENT_LOCK_FIRST_EXT" },
    { GLenum::GL_ARRAY_ELEMENT_LOCK_COUNT_EXT, "GL_ARRAY_ELEMENT_LOCK_COUNT_EXT" },
    { GLenum::GL_CULL_VERTEX_EXT, "GL_CULL_VERTEX_EXT" },
    { GLenum::GL_CULL_VERTEX_EYE_POSITION_EXT, "GL_CULL_VERTEX_EYE_POSITION_EXT" },
    { GLenum::GL_CULL_VERTEX_OBJECT_POSITION_EXT, "GL_CULL_VERTEX_OBJECT_POSITION_EXT" },
    { GLenum::GL_IUI_V2F_EXT, "GL_IUI_V2F_EXT" },
    { GLenum::GL_IUI_V3F_EXT, "GL_IUI_V3F_EXT" },
    { GLenum::GL_IUI_N3F_V2F_EXT, "GL_IUI_N3F_V2F_EXT" },
    { GLenum::GL_IUI_N3F_V3F_EXT, "GL_IUI_N3F_V3F_EXT" },
    { GLenum::GL_T2F_IUI_V2F_EXT, "GL_T2F_IUI_V2F_EXT" },
    { GLenum::GL_T2F_IUI_V3F_EXT, "GL_T2F_IUI_V3F_EXT" },
    { GLenum::GL_T2F_IUI_N3F_V2F_EXT, "GL_T2F_IUI_N3F_V2F_EXT" },
    { GLenum::GL_T2F_IUI_N3F_V3F_EXT, "GL_T2F_IUI_N3F_V3F_EXT" },
    { GLenum::GL_INDEX_TEST_EXT, "GL_INDEX_TEST_EXT" },
    { GLenum::GL_INDEX_TEST_FUNC_EXT, "GL_INDEX_TEST_FUNC_EXT" },
    { GLenum::GL_INDEX_TEST_REF_EXT, "GL_INDEX_TEST_REF_EXT" },
    { GLenum::GL_INDEX_MATERIAL_EXT, "GL_INDEX_MATERIAL_EXT" },
    { GLenum::GL_INDEX_MATERIAL_PARAMETER_EXT, "GL_INDEX_MATERIAL_PARAMETER_EXT" },
    { GLenum::GL_INDEX_MATERIAL_FACE_EXT, "GL_INDEX_MATERIAL_FACE_EXT" },
    { GLenum::GL_YCRCB_422_SGIX, "GL_YCRCB_422_SGIX" },
    { GLenum::GL_YCRCB_444_SGIX, "GL_YCRCB_444_SGIX" },
    { GLenum::GL_WRAP_BORDER_SUN, "GL_WRAP_BORDER_SUN" },
    { GLenum::GL_UNPACK_CONSTANT_DATA_SUNX, "GL_UNPACK_CONSTANT_DATA_SUNX" },
    { GLenum::GL_TEXTURE_CONSTANT_DATA_SUNX, "GL_TEXTURE_CONSTANT_DATA_SUNX" },
    { GLenum::GL_TRIANGLE_LIST_SUN, "GL_TRIANGLE_LIST_SUN" },
    { GLenum::GL_REPLACEMENT_CODE_SUN, "GL_REPLACEMENT_CODE_SUN" },
    { GLenum::GL_GLOBAL_ALPHA_SUN, "GL_GLOBAL_ALPHA_SUN" },
    { GLenum::GL_GLOBAL_ALPHA_FACTOR_SUN, "GL_GLOBAL_ALPHA_FACTOR_SUN" },
    { GLenum::GL_TEXTURE_COLOR_WRITEMASK_SGIS, "GL_TEXTURE_COLOR_WRITEMASK_SGIS" },
    { GLenum::GL_EYE_DISTANCE_TO_POINT_SGIS, "GL_EYE_DISTANCE_TO_POINT_SGIS" },
    { GLenum::GL_OBJECT_DISTANCE_TO_POINT_SGIS, "GL_OBJECT_DISTANCE_TO_POINT_SGIS" },
    { GLenum::GL_EYE_DISTANCE_TO_LINE_SGIS, "GL_EYE_DISTANCE_TO_LINE_SGIS" },
    { GLenum::GL_OBJECT_DISTANCE_TO_LINE_SGIS, "GL_OBJECT_DISTANCE_TO_LINE_SGIS" },
    { GLenum::GL_EYE_POINT_SGIS, "GL_EYE_POINT_SGIS" },
    { GLenum::GL_OBJECT_POINT_SGIS, "GL_OBJECT_POINT_SGIS" },
    { GLenum::GL_EYE_LINE_SGIS, "GL_EYE_LINE_SGIS" },
    { GLenum::GL_OBJECT_LINE_SGIS, "GL_OBJECT_LINE_SGIS" },
    { GLenum::GL_LIGHT_MODEL_COLOR_CONTROL, "GL_LIGHT_MODEL_COLOR_CONTROL" },
    { GLenum::GL_SINGLE_COLOR, "GL_SINGLE_COLOR" },
    { GLenum::GL_SEPARATE_SPECULAR_COLOR, "GL_SEPARATE_SPECULAR_COLOR" },
    { GLenum::GL_SHARED_TEXTURE_PALETTE_EXT, "GL_SHARED_TEXTURE_PALETTE_EXT" },
    { GLenum::GL_TEXT_FRAGMENT_SHADER_ATI, "GL_TEXT_FRAGMENT_SHADER_ATI" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING, "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE, "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE, "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT, "GL_FRAMEBUFFER_DEFAULT" },
    { GLenum::GL_FRAMEBUFFER_UNDEFINED, "GL_FRAMEBUFFER_UNDEFINED" },
    { GLenum::GL_DEPTH_STENCIL_ATTACHMENT, "GL_DEPTH_STENCIL_ATTACHMENT" },
    { GLenum::GL_MAJOR_VERSION, "GL_MAJOR_VERSION" },
    { GLenum::GL_MINOR_VERSION, "GL_MINOR_VERSION" },
    { GLenum::GL_NUM_EXTENSIONS, "GL_NUM_EXTENSIONS" },
    { GLenum::GL_CONTEXT_FLAGS, "GL_CONTEXT_FLAGS" },
    { GLenum::GL_BUFFER_IMMUTABLE_STORAGE, "GL_BUFFER_IMMUTABLE_STORAGE" },
    { GLenum::GL_BUFFER_STORAGE_FLAGS, "GL_BUFFER_STORAGE_FLAGS" },
    { GLenum::GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED, "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED" },
    { GLenum::GL_INDEX, "GL_INDEX" },
    { GLenum::GL_COMPRESSED_RED, "GL_COMPRESSED_RED" },
    { GLenum::GL_COMPRESSED_RG, "GL_COMPRESSED_RG" },
    { GLenum::GL_RG, "GL_RG" },
    { GLenum::GL_RG_INTEGER, "GL_RG_INTEGER" },
    { GLenum::GL_R8, "GL_R8" },
    { GLenum::GL_R16, "GL_R16" },
    { GLenum::GL_RG8, "GL_RG8" },
    { GLenum::GL_RG16, "GL_RG16" },
    { GLenum::GL_R16F, "GL_R16F" },
    { GLenum::GL_R32F, "GL_R32F" },
    { GLenum::GL_RG16F, "GL_RG16F" },
    { GLenum::GL_RG32F, "GL_RG32F" },
    { GLenum::GL_R8I, "GL_R8I" },
    { GLenum::GL_R8UI, "GL_R8UI" },
    { GLenum::GL_R16I, "GL_R16I" },
    { GLenum::GL_R16UI, "GL_R16UI" },
    { GLenum::GL_R32I, "GL_R32I" },
    { GLenum::GL_R32UI, "GL_R32UI" },
    { GLenum::GL_RG8I, "GL_RG8I" },
    { GLenum::GL_RG8UI, "GL_RG8UI" },
    { GLenum::GL_RG16I, "GL_RG16I" },
    { GLenum::GL_RG16UI, "GL_RG16UI" },
    { GLenum::GL_RG32I, "GL_RG32I" },
    { GLenum::GL_RG32UI, "GL_RG32UI" },
    { GLenum::GL_SYNC_CL_EVENT_ARB, "GL_SYNC_CL_EVENT_ARB" },
    { GLenum::GL_SYNC_CL_EVENT_COMPLETE_ARB, "GL_SYNC_CL_EVENT_COMPLETE_ARB" },
    { GLenum::GL_DEBUG_OUTPUT_SYNCHRONOUS, "GL_DEBUG_OUTPUT_SYNCHRONOUS" },
    { GLenum::GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH, "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH" },
    { GLenum::GL_DEBUG_CALLBACK_FUNCTION, "GL_DEBUG_CALLBACK_FUNCTION" },
    { GLenum::GL_DEBUG_CALLBACK_USER_PARAM, "GL_DEBUG_CALLBACK_USER_PARAM" },
    { GLenum::GL_DEBUG_SOURCE_API, "GL_DEBUG_SOURCE_API" },
    { GLenum::GL_DEBUG_SOURCE_WINDOW_SYSTEM, "GL_DEBUG_SOURCE_WINDOW_SYSTEM" },
    { GLenum::GL_DEBUG_SOURCE_SHADER_COMPILER, "GL_DEBUG_SOURCE_SHADER_COMPILER" },
    { GLenum::GL_DEBUG_SOURCE_THIRD_PARTY, "GL_DEBUG_SOURCE_THIRD_PARTY" },
    { GLenum::GL_DEBUG_SOURCE_APPLICATION, "GL_DEBUG_SOURCE_APPLICATION" },
    { GLenum::GL_DEBUG_SOURCE_OTHER, "GL_DEBUG_SOURCE_OTHER" },
    { GLenum::GL_DEBUG_TYPE_ERROR, "GL_DEBUG_TYPE_ERROR" },
    { GLenum::GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR, "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR" },
    { GLenum::GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR, "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR" },
    { GLenum::GL_DEBUG_TYPE_PORTABILITY, "GL_DEBUG_TYPE_PORTABILITY" },
    { GLenum::GL_DEBUG_TYPE_PERFORMANCE, "GL_DEBUG_TYPE_PERFORMANCE" },
    { GLenum::GL_DEBUG_TYPE_OTHER, "GL_DEBUG_TYPE_OTHER" },
    { GLenum::GL_LOSE_CONTEXT_ON_RESET, "GL_LOSE_CONTEXT_ON_RESET" },
    { GLenum::GL_GUILTY_CONTEXT_RESET, "GL_GUILTY_CONTEXT_RESET" },
    { GLenum::GL_INNOCENT_CONTEXT_RESET, "GL_INNOCENT_CONTEXT_RESET" },
    { GLenum::GL_UNKNOWN_CONTEXT_RESET, "GL_UNKNOWN_CONTEXT_RESET" },
    { GLenum::GL_RESET_NOTIFICATION_STRATEGY, "GL_RESET_NOTIFICATION_STRATEGY" },
    { GLenum::GL_PROGRAM_BINARY_RETRIEVABLE_HINT, "GL_PROGRAM_BINARY_RETRIEVABLE_HINT" },
    { GLenum::GL_PROGRAM_SEPARABLE, "GL_PROGRAM_SEPARABLE" },
    { GLenum::GL_ACTIVE_PROGRAM, "GL_ACTIVE_PROGRAM" },
    { GLenum::GL_PROGRAM_PIPELINE_BINDING, "GL_PROGRAM_PIPELINE_BINDING" },
    { GLenum::GL_MAX_VIEWPORTS, "GL_MAX_VIEWPORTS" },
    { GLenum::GL_VIEWPORT_SUBPIXEL_BITS, "GL_VIEWPORT_SUBPIXEL_BITS" },
    { GLenum::GL_VIEWPORT_BOUNDS_RANGE, "GL_VIEWPORT_BOUNDS_RANGE" },
    { GLenum::GL_LAYER_PROVOKING_VERTEX, "GL_LAYER_PROVOKING_VERTEX" },
    { GLenum::GL_VIEWPORT_INDEX_PROVOKING_VERTEX, "GL_VIEWPORT_INDEX_PROVOKING_VERTEX" },
    { GLenum::GL_UNDEFINED_VERTEX, "GL_UNDEFINED_VERTEX" },
    { GLenum::GL_NO_RESET_NOTIFICATION, "GL_NO_RESET_NOTIFICATION" },
    { GLenum::GL_MAX_COMPUTE_SHARED_MEMORY_SIZE, "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE" },
    { GLenum::GL_MAX_COMPUTE_UNIFORM_COMPONENTS, "GL_MAX_COMPUTE_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS, "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_COMPUTE_ATOMIC_COUNTERS, "GL_MAX_COMPUTE_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS" },
    { GLenum::GL_COMPUTE_WORK_GROUP_SIZE, "GL_COMPUTE_WORK_GROUP_SIZE" },
    { GLenum::GL_DEBUG_TYPE_MARKER, "GL_DEBUG_TYPE_MARKER" },
    { GLenum::GL_DEBUG_TYPE_PUSH_GROUP, "GL_DEBUG_TYPE_PUSH_GROUP" },
    { GLenum::GL_DEBUG_TYPE_POP_GROUP, "GL_DEBUG_TYPE_POP_GROUP" },
    { GLenum::GL_DEBUG_SEVERITY_NOTIFICATION, "GL_DEBUG_SEVERITY_NOTIFICATION" },
    { GLenum::GL_MAX_DEBUG_GROUP_STACK_DEPTH, "GL_MAX_DEBUG_GROUP_STACK_DEPTH" },
    { GLenum::GL_DEBUG_GROUP_STACK_DEPTH, "GL_DEBUG_GROUP_STACK_DEPTH" },
    { GLenum::GL_MAX_UNIFORM_LOCATIONS, "GL_MAX_UNIFORM_LOCATIONS" },
    { GLenum::GL_INTERNALFORMAT_SUPPORTED, "GL_INTERNALFORMAT_SUPPORTED" },
    { GLenum::GL_INTERNALFORMAT_PREFERRED, "GL_INTERNALFORMAT_PREFERRED" },
    { GLenum::GL_INTERNALFORMAT_RED_SIZE, "GL_INTERNALFORMAT_RED_SIZE" },
    { GLenum::GL_INTERNALFORMAT_GREEN_SIZE, "GL_INTERNALFORMAT_GREEN_SIZE" },
    { GLenum::GL_INTERNALFORMAT_BLUE_SIZE, "GL_INTERNALFORMAT_BLUE_SIZE" },
    { GLenum::GL_INTERNALFORMAT_ALPHA_SIZE, "GL_INTERNALFORMAT_ALPHA_SIZE" },
    { GLenum::GL_INTERNALFORMAT_DEPTH_SIZE, "GL_INTERNALFORMAT_DEPTH_SIZE" },
    { GLenum::GL_INTERNALFORMAT_STENCIL_SIZE, "GL_INTERNALFORMAT_STENCIL_SIZE" },
    { GLenum::GL_INTERNALFORMAT_SHARED_SIZE, "GL_INTERNALFORMAT_SHARED_SIZE" },
    { GLenum::GL_INTERNALFORMAT_RED_TYPE, "GL_INTERNALFORMAT_RED_TYPE" },
    { GLenum::GL_INTERNALFORMAT_GREEN_TYPE, "GL_INTERNALFORMAT_GREEN_TYPE" },
    { GLenum::GL_INTERNALFORMAT_BLUE_TYPE, "GL_INTERNALFORMAT_BLUE_TYPE" },
    { GLenum::GL_INTERNALFORMAT_ALPHA_TYPE, "GL_INTERNALFORMAT_ALPHA_TYPE" },
    { GLenum::GL_INTERNALFORMAT_DEPTH_TYPE, "GL_INTERNALFORMAT_DEPTH_TYPE" },
    { GLenum::GL_INTERNALFORMAT_STENCIL_TYPE, "GL_INTERNALFORMAT_STENCIL_TYPE" },
    { GLenum::GL_MAX_WIDTH, "GL_MAX_WIDTH" },
    { GLenum::GL_MAX_HEIGHT, "GL_MAX_HEIGHT" },
    { GLenum::GL_MAX_DEPTH, "GL_MAX_DEPTH" },
    { GLenum::GL_MAX_LAYERS, "GL_MAX_LAYERS" },
    { GLenum::GL_MAX_COMBINED_DIMENSIONS, "GL_MAX_COMBINED_DIMENSIONS" },
    { GLenum::GL_COLOR_COMPONENTS, "GL_COLOR_COMPONENTS" },
    { GLenum::GL_DEPTH_COMPONENTS, "GL_DEPTH_COMPONENTS" },
    { GLenum::GL_STENCIL_COMPONENTS, "GL_STENCIL_COMPONENTS" },
    { GLenum::GL_COLOR_RENDERABLE, "GL_COLOR_RENDERABLE" },
    { GLenum::GL_DEPTH_RENDERABLE, "GL_DEPTH_RENDERABLE" },
    { GLenum::GL_STENCIL_RENDERABLE, "GL_STENCIL_RENDERABLE" },
    { GLenum::GL_FRAMEBUFFER_RENDERABLE, "GL_FRAMEBUFFER_RENDERABLE" },
    { GLenum::GL_FRAMEBUFFER_RENDERABLE_LAYERED, "GL_FRAMEBUFFER_RENDERABLE_LAYERED" },
    { GLenum::GL_FRAMEBUFFER_BLEND, "GL_FRAMEBUFFER_BLEND" },
    { GLenum::GL_READ_PIXELS, "GL_READ_PIXELS" },
    { GLenum::GL_READ_PIXELS_FORMAT, "GL_READ_PIXELS_FORMAT" },
    { GLenum::GL_READ_PIXELS_TYPE, "GL_READ_PIXELS_TYPE" },
    { GLenum::GL_TEXTURE_IMAGE_FORMAT, "GL_TEXTURE_IMAGE_FORMAT" },
    { GLenum::GL_TEXTURE_IMAGE_TYPE, "GL_TEXTURE_IMAGE_TYPE" },
    { GLenum::GL_GET_TEXTURE_IMAGE_FORMAT, "GL_GET_TEXTURE_IMAGE_FORMAT" },
    { GLenum::GL_GET_TEXTURE_IMAGE_TYPE, "GL_GET_TEXTURE_IMAGE_TYPE" },
    { GLenum::GL_MIPMAP, "GL_MIPMAP" },
    { GLenum::GL_MANUAL_GENERATE_MIPMAP, "GL_MANUAL_GENERATE_MIPMAP" },
    { GLenum::GL_AUTO_GENERATE_MIPMAP, "GL_AUTO_GENERATE_MIPMAP" },
    { GLenum::GL_COLOR_ENCODING, "GL_COLOR_ENCODING" },
    { GLenum::GL_SRGB_READ, "GL_SRGB_READ" },
    { GLenum::GL_SRGB_WRITE, "GL_SRGB_WRITE" },
    { GLenum::GL_SRGB_DECODE_ARB, "GL_SRGB_DECODE_ARB" },
    { GLenum::GL_FILTER, "GL_FILTER" },
    { GLenum::GL_VERTEX_TEXTURE, "GL_VERTEX_TEXTURE" },
    { GLenum::GL_TESS_CONTROL_TEXTURE, "GL_TESS_CONTROL_TEXTURE" },
    { GLenum::GL_TESS_EVALUATION_TEXTURE, "GL_TESS_EVALUATION_TEXTURE" },
    { GLenum::GL_GEOMETRY_TEXTURE, "GL_GEOMETRY_TEXTURE" },
    { GLenum::GL_FRAGMENT_TEXTURE, "GL_FRAGMENT_TEXTURE" },
    { GLenum::GL_COMPUTE_TEXTURE, "GL_COMPUTE_TEXTURE" },
    { GLenum::GL_TEXTURE_SHADOW, "GL_TEXTURE_SHADOW" },
    { GLenum::GL_TEXTURE_GATHER, "GL_TEXTURE_GATHER" },
    { GLenum::GL_TEXTURE_GATHER_SHADOW, "GL_TEXTURE_GATHER_SHADOW" },
    { GLenum::GL_SHADER_IMAGE_LOAD, "GL_SHADER_IMAGE_LOAD" },
    { GLenum::GL_SHADER_IMAGE_STORE, "GL_SHADER_IMAGE_STORE" },
    { GLenum::GL_SHADER_IMAGE_ATOMIC, "GL_SHADER_IMAGE_ATOMIC" },
    { GLenum::GL_IMAGE_TEXEL_SIZE, "GL_IMAGE_TEXEL_SIZE" },
    { GLenum::GL_IMAGE_COMPATIBILITY_CLASS, "GL_IMAGE_COMPATIBILITY_CLASS" },
    { GLenum::GL_IMAGE_PIXEL_FORMAT, "GL_IMAGE_PIXEL_FORMAT" },
    { GLenum::GL_IMAGE_PIXEL_TYPE, "GL_IMAGE_PIXEL_TYPE" },
    { GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST, "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST" },
    { GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST, "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST" },
    { GLenum::GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE, "GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE" },
    { GLenum::GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE, "GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE" },
    { GLenum::GL_TEXTURE_COMPRESSED_BLOCK_WIDTH, "GL_TEXTURE_COMPRESSED_BLOCK_WIDTH" },
    { GLenum::GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT, "GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT" },
    { GLenum::GL_TEXTURE_COMPRESSED_BLOCK_SIZE, "GL_TEXTURE_COMPRESSED_BLOCK_SIZE" },
    { GLenum::GL_CLEAR_BUFFER, "GL_CLEAR_BUFFER" },
    { GLenum::GL_TEXTURE_VIEW, "GL_TEXTURE_VIEW" },
    { GLenum::GL_VIEW_COMPATIBILITY_CLASS, "GL_VIEW_COMPATIBILITY_CLASS" },
    { GLenum::GL_FULL_SUPPORT, "GL_FULL_SUPPORT" },
    { GLenum::GL_CAVEAT_SUPPORT, "GL_CAVEAT_SUPPORT" },
    { GLenum::GL_IMAGE_CLASS_4_X_32, "GL_IMAGE_CLASS_4_X_32" },
    { GLenum::GL_IMAGE_CLASS_2_X_32, "GL_IMAGE_CLASS_2_X_32" },
    { GLenum::GL_IMAGE_CLASS_1_X_32, "GL_IMAGE_CLASS_1_X_32" },
    { GLenum::GL_IMAGE_CLASS_4_X_16, "GL_IMAGE_CLASS_4_X_16" },
    { GLenum::GL_IMAGE_CLASS_2_X_16, "GL_IMAGE_CLASS_2_X_16" },
    { GLenum::GL_IMAGE_CLASS_1_X_16, "GL_IMAGE_CLASS_1_X_16" },
    { GLenum::GL_IMAGE_CLASS_4_X_8, "GL_IMAGE_CLASS_4_X_8" },
    { GLenum::GL_IMAGE_CLASS_2_X_8, "GL_IMAGE_CLASS_2_X_8" },
    { GLenum::GL_IMAGE_CLASS_1_X_8, "GL_IMAGE_CLASS_1_X_8" },
    { GLenum::GL_IMAGE_CLASS_11_11_10, "GL_IMAGE_CLASS_11_11_10" },
    { GLenum::GL_IMAGE_CLASS_10_10_10_2, "GL_IMAGE_CLASS_10_10_10_2" },
    { GLenum::GL_VIEW_CLASS_128_BITS, "GL_VIEW_CLASS_128_BITS" },
    { GLenum::GL_VIEW_CLASS_96_BITS, "GL_VIEW_CLASS_96_BITS" },
    { GLenum::GL_VIEW_CLASS_64_BITS, "GL_VIEW_CLASS_64_BITS" },
    { GLenum::GL_VIEW_CLASS_48_BITS, "GL_VIEW_CLASS_48_BITS" },
    { GLenum::GL_VIEW_CLASS_32_BITS, "GL_VIEW_CLASS_32_BITS" },
    { GLenum::GL_VIEW_CLASS_24_BITS, "GL_VIEW_CLASS_24_BITS" },
    { GLenum::GL_VIEW_CLASS_16_BITS, "GL_VIEW_CLASS_16_BITS" },
    { GLenum::GL_VIEW_CLASS_8_BITS, "GL_VIEW_CLASS_8_BITS" },
    { GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGB, "GL_VIEW_CLASS_S3TC_DXT1_RGB" },
    { GLenum::GL_VIEW_CLASS_S3TC_DXT1_RGBA, "GL_VIEW_CLASS_S3TC_DXT1_RGBA" },
    { GLenum::GL_VIEW_CLASS_S3TC_DXT3_RGBA, "GL_VIEW_CLASS_S3TC_DXT3_RGBA" },
    { GLenum::GL_VIEW_CLASS_S3TC_DXT5_RGBA, "GL_VIEW_CLASS_S3TC_DXT5_RGBA" },
    { GLenum::GL_VIEW_CLASS_RGTC1_RED, "GL_VIEW_CLASS_RGTC1_RED" },
    { GLenum::GL_VIEW_CLASS_RGTC2_RG, "GL_VIEW_CLASS_RGTC2_RG" },
    { GLenum::GL_VIEW_CLASS_BPTC_UNORM, "GL_VIEW_CLASS_BPTC_UNORM" },
    { GLenum::GL_VIEW_CLASS_BPTC_FLOAT, "GL_VIEW_CLASS_BPTC_FLOAT" },
    { GLenum::GL_VERTEX_ATTRIB_BINDING, "GL_VERTEX_ATTRIB_BINDING" },
    { GLenum::GL_VERTEX_ATTRIB_RELATIVE_OFFSET, "GL_VERTEX_ATTRIB_RELATIVE_OFFSET" },
    { GLenum::GL_VERTEX_BINDING_DIVISOR, "GL_VERTEX_BINDING_DIVISOR" },
    { GLenum::GL_VERTEX_BINDING_OFFSET, "GL_VERTEX_BINDING_OFFSET" },
    { GLenum::GL_VERTEX_BINDING_STRIDE, "GL_VERTEX_BINDING_STRIDE" },
    { GLenum::GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET, "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET" },
    { GLenum::GL_MAX_VERTEX_ATTRIB_BINDINGS, "GL_MAX_VERTEX_ATTRIB_BINDINGS" },
    { GLenum::GL_TEXTURE_VIEW_MIN_LEVEL, "GL_TEXTURE_VIEW_MIN_LEVEL" },
    { GLenum::GL_TEXTURE_VIEW_NUM_LEVELS, "GL_TEXTURE_VIEW_NUM_LEVELS" },
    { GLenum::GL_TEXTURE_VIEW_MIN_LAYER, "GL_TEXTURE_VIEW_MIN_LAYER" },
    { GLenum::GL_TEXTURE_VIEW_NUM_LAYERS, "GL_TEXTURE_VIEW_NUM_LAYERS" },
    { GLenum::GL_TEXTURE_IMMUTABLE_LEVELS, "GL_TEXTURE_IMMUTABLE_LEVELS" },
    { GLenum::GL_BUFFER, "GL_BUFFER" },
    { GLenum::GL_SHADER, "GL_SHADER" },
    { GLenum::GL_PROGRAM, "GL_PROGRAM" },
    { GLenum::GL_QUERY, "GL_QUERY" },
    { GLenum::GL_PROGRAM_PIPELINE, "GL_PROGRAM_PIPELINE" },
    { GLenum::GL_MAX_VERTEX_ATTRIB_STRIDE, "GL_MAX_VERTEX_ATTRIB_STRIDE" },
    { GLenum::GL_SAMPLER, "GL_SAMPLER" },
    { GLenum::GL_DISPLAY_LIST, "GL_DISPLAY_LIST" },
    { GLenum::GL_MAX_LABEL_LENGTH, "GL_MAX_LABEL_LENGTH" },
    { GLenum::GL_NUM_SHADING_LANGUAGE_VERSIONS, "GL_NUM_SHADING_LANGUAGE_VERSIONS" },
    { GLenum::GL_QUERY_TARGET, "GL_QUERY_TARGET" },
    { GLenum::GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB, "GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB" },
    { GLenum::GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB, "GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB" },
    { GLenum::GL_VERTICES_SUBMITTED_ARB, "GL_VERTICES_SUBMITTED_ARB" },
    { GLenum::GL_PRIMITIVES_SUBMITTED_ARB, "GL_PRIMITIVES_SUBMITTED_ARB" },
    { GLenum::GL_VERTEX_SHADER_INVOCATIONS_ARB, "GL_VERTEX_SHADER_INVOCATIONS_ARB" },
    { GLenum::GL_TESS_CONTROL_SHADER_PATCHES_ARB, "GL_TESS_CONTROL_SHADER_PATCHES_ARB" },
    { GLenum::GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB, "GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB" },
    { GLenum::GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB, "GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB" },
    { GLenum::GL_FRAGMENT_SHADER_INVOCATIONS_ARB, "GL_FRAGMENT_SHADER_INVOCATIONS_ARB" },
    { GLenum::GL_COMPUTE_SHADER_INVOCATIONS_ARB, "GL_COMPUTE_SHADER_INVOCATIONS_ARB" },
    { GLenum::GL_CLIPPING_INPUT_PRIMITIVES_ARB, "GL_CLIPPING_INPUT_PRIMITIVES_ARB" },
    { GLenum::GL_CLIPPING_OUTPUT_PRIMITIVES_ARB, "GL_CLIPPING_OUTPUT_PRIMITIVES_ARB" },
    { GLenum::GL_SPARSE_BUFFER_PAGE_SIZE_ARB, "GL_SPARSE_BUFFER_PAGE_SIZE_ARB" },
    { GLenum::GL_MAX_CULL_DISTANCES, "GL_MAX_CULL_DISTANCES" },
    { GLenum::GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES, "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES" },
    { GLenum::GL_CONTEXT_RELEASE_BEHAVIOR, "GL_CONTEXT_RELEASE_BEHAVIOR" },
    { GLenum::GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH, "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH" },
    { GLenum::GL_CONVOLUTION_HINT_SGIX, "GL_CONVOLUTION_HINT_SGIX" },
    { GLenum::GL_YCRCB_SGIX, "GL_YCRCB_SGIX" },
    { GLenum::GL_YCRCBA_SGIX, "GL_YCRCBA_SGIX" },
    { GLenum::GL_ALPHA_MIN_SGIX, "GL_ALPHA_MIN_SGIX" },
    { GLenum::GL_ALPHA_MAX_SGIX, "GL_ALPHA_MAX_SGIX" },
    { GLenum::GL_SCALEBIAS_HINT_SGIX, "GL_SCALEBIAS_HINT_SGIX" },
    { GLenum::GL_ASYNC_MARKER_SGIX, "GL_ASYNC_MARKER_SGIX" },
    { GLenum::GL_PIXEL_TEX_GEN_MODE_SGIX, "GL_PIXEL_TEX_GEN_MODE_SGIX" },
    { GLenum::GL_ASYNC_HISTOGRAM_SGIX, "GL_ASYNC_HISTOGRAM_SGIX" },
    { GLenum::GL_MAX_ASYNC_HISTOGRAM_SGIX, "GL_MAX_ASYNC_HISTOGRAM_SGIX" },
    { GLenum::GL_PIXEL_TRANSFORM_2D_EXT, "GL_PIXEL_TRANSFORM_2D_EXT" },
    { GLenum::GL_PIXEL_MAG_FILTER_EXT, "GL_PIXEL_MAG_FILTER_EXT" },
    { GLenum::GL_PIXEL_MIN_FILTER_EXT, "GL_PIXEL_MIN_FILTER_EXT" },
    { GLenum::GL_PIXEL_CUBIC_WEIGHT_EXT, "GL_PIXEL_CUBIC_WEIGHT_EXT" },
    { GLenum::GL_CUBIC_EXT, "GL_CUBIC_EXT" },
    { GLenum::GL_AVERAGE_EXT, "GL_AVERAGE_EXT" },
    { GLenum::GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT, "GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT" },
    { GLenum::GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT, "GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT" },
    { GLenum::GL_PIXEL_TRANSFORM_2D_MATRIX_EXT, "GL_PIXEL_TRANSFORM_2D_MATRIX_EXT" },
    { GLenum::GL_FRAGMENT_MATERIAL_EXT, "GL_FRAGMENT_MATERIAL_EXT" },
    { GLenum::GL_FRAGMENT_NORMAL_EXT, "GL_FRAGMENT_NORMAL_EXT" },
    { GLenum::GL_FRAGMENT_COLOR_EXT, "GL_FRAGMENT_COLOR_EXT" },
    { GLenum::GL_ATTENUATION_EXT, "GL_ATTENUATION_EXT" },
    { GLenum::GL_SHADOW_ATTENUATION_EXT, "GL_SHADOW_ATTENUATION_EXT" },
    { GLenum::GL_TEXTURE_APPLICATION_MODE_EXT, "GL_TEXTURE_APPLICATION_MODE_EXT" },
    { GLenum::GL_TEXTURE_LIGHT_EXT, "GL_TEXTURE_LIGHT_EXT" },
    { GLenum::GL_TEXTURE_MATERIAL_FACE_EXT, "GL_TEXTURE_MATERIAL_FACE_EXT" },
    { GLenum::GL_TEXTURE_MATERIAL_PARAMETER_EXT, "GL_TEXTURE_MATERIAL_PARAMETER_EXT" },
    { GLenum::GL_PIXEL_TEXTURE_SGIS, "GL_PIXEL_TEXTURE_SGIS" },
    { GLenum::GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS, "GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS" },
    { GLenum::GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS, "GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS" },
    { GLenum::GL_PIXEL_GROUP_COLOR_SGIS, "GL_PIXEL_GROUP_COLOR_SGIS" },
    { GLenum::GL_ASYNC_TEX_IMAGE_SGIX, "GL_ASYNC_TEX_IMAGE_SGIX" },
    { GLenum::GL_ASYNC_DRAW_PIXELS_SGIX, "GL_ASYNC_DRAW_PIXELS_SGIX" },
    { GLenum::GL_ASYNC_READ_PIXELS_SGIX, "GL_ASYNC_READ_PIXELS_SGIX" },
    { GLenum::GL_MAX_ASYNC_TEX_IMAGE_SGIX, "GL_MAX_ASYNC_TEX_IMAGE_SGIX" },
    { GLenum::GL_MAX_ASYNC_DRAW_PIXELS_SGIX, "GL_MAX_ASYNC_DRAW_PIXELS_SGIX" },
    { GLenum::GL_MAX_ASYNC_READ_PIXELS_SGIX, "GL_MAX_ASYNC_READ_PIXELS_SGIX" },
    { GLenum::GL_UNSIGNED_BYTE_2_3_3_REV, "GL_UNSIGNED_BYTE_2_3_3_REV" },
    { GLenum::GL_UNSIGNED_SHORT_5_6_5, "GL_UNSIGNED_SHORT_5_6_5" },
    { GLenum::GL_UNSIGNED_SHORT_5_6_5_REV, "GL_UNSIGNED_SHORT_5_6_5_REV" },
    { GLenum::GL_UNSIGNED_SHORT_4_4_4_4_REV, "GL_UNSIGNED_SHORT_4_4_4_4_REV" },
    { GLenum::GL_UNSIGNED_SHORT_1_5_5_5_REV, "GL_UNSIGNED_SHORT_1_5_5_5_REV" },
    { GLenum::GL_UNSIGNED_INT_8_8_8_8_REV, "GL_UNSIGNED_INT_8_8_8_8_REV" },
    { GLenum::GL_UNSIGNED_INT_2_10_10_10_REV, "GL_UNSIGNED_INT_2_10_10_10_REV" },
    { GLenum::GL_TEXTURE_MAX_CLAMP_S_SGIX, "GL_TEXTURE_MAX_CLAMP_S_SGIX" },
    { GLenum::GL_TEXTURE_MAX_CLAMP_T_SGIX, "GL_TEXTURE_MAX_CLAMP_T_SGIX" },
    { GLenum::GL_TEXTURE_MAX_CLAMP_R_SGIX, "GL_TEXTURE_MAX_CLAMP_R_SGIX" },
    { GLenum::GL_MIRRORED_REPEAT, "GL_MIRRORED_REPEAT" },
    { GLenum::GL_RGB_S3TC, "GL_RGB_S3TC" },
    { GLenum::GL_RGB4_S3TC, "GL_RGB4_S3TC" },
    { GLenum::GL_RGBA_S3TC, "GL_RGBA_S3TC" },
    { GLenum::GL_RGBA4_S3TC, "GL_RGBA4_S3TC" },
    { GLenum::GL_RGBA_DXT5_S3TC, "GL_RGBA_DXT5_S3TC" },
    { GLenum::GL_RGBA4_DXT5_S3TC, "GL_RGBA4_DXT5_S3TC" },
    { GLenum::GL_VERTEX_PRECLIP_SGIX, "GL_VERTEX_PRECLIP_SGIX" },
    { GLenum::GL_VERTEX_PRECLIP_HINT_SGIX, "GL_VERTEX_PRECLIP_HINT_SGIX" },
    { GLenum::GL_COMPRESSED_RGB_S3TC_DXT1_EXT, "GL_COMPRESSED_RGB_S3TC_DXT1_EXT" },
    { GLenum::GL_COMPRESSED_RGBA_S3TC_DXT1_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT" },
    { GLenum::GL_COMPRESSED_RGBA_S3TC_DXT3_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT" },
    { GLenum::GL_COMPRESSED_RGBA_S3TC_DXT5_EXT, "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT" },
    { GLenum::GL_PARALLEL_ARRAYS_INTEL, "GL_PARALLEL_ARRAYS_INTEL" },
    { GLenum::GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL, "GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL" },
    { GLenum::GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL, "GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL" },
    { GLenum::GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL, "GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL, "GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL" },
    { GLenum::GL_PERFQUERY_DONOT_FLUSH_INTEL, "GL_PERFQUERY_DONOT_FLUSH_INTEL" },
    { GLenum::GL_PERFQUERY_FLUSH_INTEL, "GL_PERFQUERY_FLUSH_INTEL" },
    { GLenum::GL_PERFQUERY_WAIT_INTEL, "GL_PERFQUERY_WAIT_INTEL" },
    { GLenum::GL_TEXTURE_MEMORY_LAYOUT_INTEL, "GL_TEXTURE_MEMORY_LAYOUT_INTEL" },
    { GLenum::GL_FRAGMENT_LIGHTING_SGIX, "GL_FRAGMENT_LIGHTING_SGIX" },
    { GLenum::GL_FRAGMENT_COLOR_MATERIAL_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_SGIX" },
    { GLenum::GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX" },
    { GLenum::GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX, "GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX" },
    { GLenum::GL_MAX_FRAGMENT_LIGHTS_SGIX, "GL_MAX_FRAGMENT_LIGHTS_SGIX" },
    { GLenum::GL_MAX_ACTIVE_LIGHTS_SGIX, "GL_MAX_ACTIVE_LIGHTS_SGIX" },
    { GLenum::GL_CURRENT_RASTER_NORMAL_SGIX, "GL_CURRENT_RASTER_NORMAL_SGIX" },
    { GLenum::GL_LIGHT_ENV_MODE_SGIX, "GL_LIGHT_ENV_MODE_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX, "GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX, "GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX, "GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX, "GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT0_SGIX, "GL_FRAGMENT_LIGHT0_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT1_SGIX, "GL_FRAGMENT_LIGHT1_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT2_SGIX, "GL_FRAGMENT_LIGHT2_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT3_SGIX, "GL_FRAGMENT_LIGHT3_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT4_SGIX, "GL_FRAGMENT_LIGHT4_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT5_SGIX, "GL_FRAGMENT_LIGHT5_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT6_SGIX, "GL_FRAGMENT_LIGHT6_SGIX" },
    { GLenum::GL_FRAGMENT_LIGHT7_SGIX, "GL_FRAGMENT_LIGHT7_SGIX" },
    { GLenum::GL_PACK_RESAMPLE_SGIX, "GL_PACK_RESAMPLE_SGIX" },
    { GLenum::GL_UNPACK_RESAMPLE_SGIX, "GL_UNPACK_RESAMPLE_SGIX" },
    { GLenum::GL_RESAMPLE_DECIMATE_SGIX, "GL_RESAMPLE_DECIMATE_SGIX" },
    { GLenum::GL_RESAMPLE_REPLICATE_SGIX, "GL_RESAMPLE_REPLICATE_SGIX" },
    { GLenum::GL_RESAMPLE_ZERO_FILL_SGIX, "GL_RESAMPLE_ZERO_FILL_SGIX" },
    { GLenum::GL_TANGENT_ARRAY_EXT, "GL_TANGENT_ARRAY_EXT" },
    { GLenum::GL_BINORMAL_ARRAY_EXT, "GL_BINORMAL_ARRAY_EXT" },
    { GLenum::GL_CURRENT_TANGENT_EXT, "GL_CURRENT_TANGENT_EXT" },
    { GLenum::GL_CURRENT_BINORMAL_EXT, "GL_CURRENT_BINORMAL_EXT" },
    { GLenum::GL_TANGENT_ARRAY_TYPE_EXT, "GL_TANGENT_ARRAY_TYPE_EXT" },
    { GLenum::GL_TANGENT_ARRAY_STRIDE_EXT, "GL_TANGENT_ARRAY_STRIDE_EXT" },
    { GLenum::GL_BINORMAL_ARRAY_TYPE_EXT, "GL_BINORMAL_ARRAY_TYPE_EXT" },
    { GLenum::GL_BINORMAL_ARRAY_STRIDE_EXT, "GL_BINORMAL_ARRAY_STRIDE_EXT" },
    { GLenum::GL_TANGENT_ARRAY_POINTER_EXT, "GL_TANGENT_ARRAY_POINTER_EXT" },
    { GLenum::GL_BINORMAL_ARRAY_POINTER_EXT, "GL_BINORMAL_ARRAY_POINTER_EXT" },
    { GLenum::GL_MAP1_TANGENT_EXT, "GL_MAP1_TANGENT_EXT" },
    { GLenum::GL_MAP2_TANGENT_EXT, "GL_MAP2_TANGENT_EXT" },
    { GLenum::GL_MAP1_BINORMAL_EXT, "GL_MAP1_BINORMAL_EXT" },
    { GLenum::GL_MAP2_BINORMAL_EXT, "GL_MAP2_BINORMAL_EXT" },
    { GLenum::GL_NEAREST_CLIPMAP_NEAREST_SGIX, "GL_NEAREST_CLIPMAP_NEAREST_SGIX" },
    { GLenum::GL_NEAREST_CLIPMAP_LINEAR_SGIX, "GL_NEAREST_CLIPMAP_LINEAR_SGIX" },
    { GLenum::GL_LINEAR_CLIPMAP_NEAREST_SGIX, "GL_LINEAR_CLIPMAP_NEAREST_SGIX" },
    { GLenum::GL_FOG_COORDINATE_SOURCE, "GL_FOG_COORDINATE_SOURCE" },
    { GLenum::GL_FOG_COORD, "GL_FOG_COORD" },
    { GLenum::GL_FRAGMENT_DEPTH, "GL_FRAGMENT_DEPTH" },
    { GLenum::GL_CURRENT_FOG_COORD, "GL_CURRENT_FOG_COORD" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_TYPE, "GL_FOG_COORDINATE_ARRAY_TYPE" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_STRIDE, "GL_FOG_COORDINATE_ARRAY_STRIDE" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_POINTER, "GL_FOG_COORDINATE_ARRAY_POINTER" },
    { GLenum::GL_FOG_COORDINATE_ARRAY, "GL_FOG_COORDINATE_ARRAY" },
    { GLenum::GL_COLOR_SUM, "GL_COLOR_SUM" },
    { GLenum::GL_CURRENT_SECONDARY_COLOR, "GL_CURRENT_SECONDARY_COLOR" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_SIZE, "GL_SECONDARY_COLOR_ARRAY_SIZE" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_TYPE, "GL_SECONDARY_COLOR_ARRAY_TYPE" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_STRIDE, "GL_SECONDARY_COLOR_ARRAY_STRIDE" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_POINTER, "GL_SECONDARY_COLOR_ARRAY_POINTER" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY, "GL_SECONDARY_COLOR_ARRAY" },
    { GLenum::GL_CURRENT_RASTER_SECONDARY_COLOR, "GL_CURRENT_RASTER_SECONDARY_COLOR" },
    { GLenum::GL_ALIASED_POINT_SIZE_RANGE, "GL_ALIASED_POINT_SIZE_RANGE" },
    { GLenum::GL_ALIASED_LINE_WIDTH_RANGE, "GL_ALIASED_LINE_WIDTH_RANGE" },
    { GLenum::GL_SCREEN_COORDINATES_REND, "GL_SCREEN_COORDINATES_REND" },
    { GLenum::GL_INVERTED_SCREEN_W_REND, "GL_INVERTED_SCREEN_W_REND" },
    { GLenum::GL_TEXTURE0, "GL_TEXTURE0" },
    { GLenum::GL_TEXTURE1, "GL_TEXTURE1" },
    { GLenum::GL_TEXTURE2, "GL_TEXTURE2" },
    { GLenum::GL_TEXTURE3, "GL_TEXTURE3" },
    { GLenum::GL_TEXTURE4, "GL_TEXTURE4" },
    { GLenum::GL_TEXTURE5, "GL_TEXTURE5" },
    { GLenum::GL_TEXTURE6, "GL_TEXTURE6" },
    { GLenum::GL_TEXTURE7, "GL_TEXTURE7" },
    { GLenum::GL_TEXTURE8, "GL_TEXTURE8" },
    { GLenum::GL_TEXTURE9, "GL_TEXTURE9" },
    { GLenum::GL_TEXTURE10, "GL_TEXTURE10" },
    { GLenum::GL_TEXTURE11, "GL_TEXTURE11" },
    { GLenum::GL_TEXTURE12, "GL_TEXTURE12" },
    { GLenum::GL_TEXTURE13, "GL_TEXTURE13" },
    { GLenum::GL_TEXTURE14, "GL_TEXTURE14" },
    { GLenum::GL_TEXTURE15, "GL_TEXTURE15" },
    { GLenum::GL_TEXTURE16, "GL_TEXTURE16" },
    { GLenum::GL_TEXTURE17, "GL_TEXTURE17" },
    { GLenum::GL_TEXTURE18, "GL_TEXTURE18" },
    { GLenum::GL_TEXTURE19, "GL_TEXTURE19" },
    { GLenum::GL_TEXTURE20, "GL_TEXTURE20" },
    { GLenum::GL_TEXTURE21, "GL_TEXTURE21" },
    { GLenum::GL_TEXTURE22, "GL_TEXTURE22" },
    { GLenum::GL_TEXTURE23, "GL_TEXTURE23" },
    { GLenum::GL_TEXTURE24, "GL_TEXTURE24" },
    { GLenum::GL_TEXTURE25, "GL_TEXTURE25" },
    { GLenum::GL_TEXTURE26, "GL_TEXTURE26" },
    { GLenum::GL_TEXTURE27, "GL_TEXTURE27" },
    { GLenum::GL_TEXTURE28, "GL_TEXTURE28" },
    { GLenum::GL_TEXTURE29, "GL_TEXTURE29" },
    { GLenum::GL_TEXTURE30, "GL_TEXTURE30" },
    { GLenum::GL_TEXTURE31, "GL_TEXTURE31" },
    { GLenum::GL_ACTIVE_TEXTURE, "GL_ACTIVE_TEXTURE" },
    { GLenum::GL_CLIENT_ACTIVE_TEXTURE, "GL_CLIENT_ACTIVE_TEXTURE" },
    { GLenum::GL_MAX_TEXTURE_UNITS, "GL_MAX_TEXTURE_UNITS" },
    { GLenum::GL_TRANSPOSE_MODELVIEW_MATRIX, "GL_TRANSPOSE_MODELVIEW_MATRIX" },
    { GLenum::GL_TRANSPOSE_PROJECTION_MATRIX, "GL_TRANSPOSE_PROJECTION_MATRIX" },
    { GLenum::GL_TRANSPOSE_TEXTURE_MATRIX, "GL_TRANSPOSE_TEXTURE_MATRIX" },
    { GLenum::GL_TRANSPOSE_COLOR_MATRIX, "GL_TRANSPOSE_COLOR_MATRIX" },
    { GLenum::GL_SUBTRACT, "GL_SUBTRACT" },
    { GLenum::GL_MAX_RENDERBUFFER_SIZE, "GL_MAX_RENDERBUFFER_SIZE" },
    { GLenum::GL_COMPRESSED_ALPHA, "GL_COMPRESSED_ALPHA" },
    { GLenum::GL_COMPRESSED_LUMINANCE, "GL_COMPRESSED_LUMINANCE" },
    { GLenum::GL_COMPRESSED_LUMINANCE_ALPHA, "GL_COMPRESSED_LUMINANCE_ALPHA" },
    { GLenum::GL_COMPRESSED_INTENSITY, "GL_COMPRESSED_INTENSITY" },
    { GLenum::GL_COMPRESSED_RGB, "GL_COMPRESSED_RGB" },
    { GLenum::GL_COMPRESSED_RGBA, "GL_COMPRESSED_RGBA" },
    { GLenum::GL_TEXTURE_COMPRESSION_HINT, "GL_TEXTURE_COMPRESSION_HINT" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER" },
    { GLenum::GL_ALL_COMPLETED_NV, "GL_ALL_COMPLETED_NV" },
    { GLenum::GL_FENCE_STATUS_NV, "GL_FENCE_STATUS_NV" },
    { GLenum::GL_FENCE_CONDITION_NV, "GL_FENCE_CONDITION_NV" },
    { GLenum::GL_TEXTURE_RECTANGLE, "GL_TEXTURE_RECTANGLE" },
    { GLenum::GL_TEXTURE_BINDING_RECTANGLE, "GL_TEXTURE_BINDING_RECTANGLE" },
    { GLenum::GL_PROXY_TEXTURE_RECTANGLE, "GL_PROXY_TEXTURE_RECTANGLE" },
    { GLenum::GL_MAX_RECTANGLE_TEXTURE_SIZE, "GL_MAX_RECTANGLE_TEXTURE_SIZE" },
    { GLenum::GL_DEPTH_STENCIL, "GL_DEPTH_STENCIL" },
    { GLenum::GL_UNSIGNED_INT_24_8, "GL_UNSIGNED_INT_24_8" },
    { GLenum::GL_MAX_TEXTURE_LOD_BIAS, "GL_MAX_TEXTURE_LOD_BIAS" },
    { GLenum::GL_TEXTURE_MAX_ANISOTROPY_EXT, "GL_TEXTURE_MAX_ANISOTROPY_EXT" },
    { GLenum::GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT" },
    { GLenum::GL_TEXTURE_FILTER_CONTROL, "GL_TEXTURE_FILTER_CONTROL" },
    { GLenum::GL_TEXTURE_LOD_BIAS, "GL_TEXTURE_LOD_BIAS" },
    { GLenum::GL_MODELVIEW1_STACK_DEPTH_EXT, "GL_MODELVIEW1_STACK_DEPTH_EXT" },
    { GLenum::GL_COMBINE4_NV, "GL_COMBINE4_NV" },
    { GLenum::GL_MAX_SHININESS_NV, "GL_MAX_SHININESS_NV" },
    { GLenum::GL_MAX_SPOT_EXPONENT_NV, "GL_MAX_SPOT_EXPONENT_NV" },
    { GLenum::GL_MODELVIEW1_MATRIX_EXT, "GL_MODELVIEW1_MATRIX_EXT" },
    { GLenum::GL_INCR_WRAP, "GL_INCR_WRAP" },
    { GLenum::GL_DECR_WRAP, "GL_DECR_WRAP" },
    { GLenum::GL_VERTEX_WEIGHTING_EXT, "GL_VERTEX_WEIGHTING_EXT" },
    { GLenum::GL_MODELVIEW1_ARB, "GL_MODELVIEW1_ARB" },
    { GLenum::GL_CURRENT_VERTEX_WEIGHT_EXT, "GL_CURRENT_VERTEX_WEIGHT_EXT" },
    { GLenum::GL_VERTEX_WEIGHT_ARRAY_EXT, "GL_VERTEX_WEIGHT_ARRAY_EXT" },
    { GLenum::GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT, "GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT" },
    { GLenum::GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT, "GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT" },
    { GLenum::GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT, "GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT" },
    { GLenum::GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT, "GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT" },
    { GLenum::GL_NORMAL_MAP, "GL_NORMAL_MAP" },
    { GLenum::GL_REFLECTION_MAP, "GL_REFLECTION_MAP" },
    { GLenum::GL_TEXTURE_CUBE_MAP, "GL_TEXTURE_CUBE_MAP" },
    { GLenum::GL_TEXTURE_BINDING_CUBE_MAP, "GL_TEXTURE_BINDING_CUBE_MAP" },
    { GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_X, "GL_TEXTURE_CUBE_MAP_POSITIVE_X" },
    { GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_X, "GL_TEXTURE_CUBE_MAP_NEGATIVE_X" },
    { GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Y, "GL_TEXTURE_CUBE_MAP_POSITIVE_Y" },
    { GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y" },
    { GLenum::GL_TEXTURE_CUBE_MAP_POSITIVE_Z, "GL_TEXTURE_CUBE_MAP_POSITIVE_Z" },
    { GLenum::GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z" },
    { GLenum::GL_PROXY_TEXTURE_CUBE_MAP, "GL_PROXY_TEXTURE_CUBE_MAP" },
    { GLenum::GL_MAX_CUBE_MAP_TEXTURE_SIZE, "GL_MAX_CUBE_MAP_TEXTURE_SIZE" },
    { GLenum::GL_VERTEX_ARRAY_RANGE_APPLE, "GL_VERTEX_ARRAY_RANGE_APPLE" },
    { GLenum::GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE, "GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE" },
    { GLenum::GL_VERTEX_ARRAY_STORAGE_HINT_APPLE, "GL_VERTEX_ARRAY_STORAGE_HINT_APPLE" },
    { GLenum::GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV, "GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV" },
    { GLenum::GL_VERTEX_ARRAY_RANGE_POINTER_APPLE, "GL_VERTEX_ARRAY_RANGE_POINTER_APPLE" },
    { GLenum::GL_REGISTER_COMBINERS_NV, "GL_REGISTER_COMBINERS_NV" },
    { GLenum::GL_VARIABLE_A_NV, "GL_VARIABLE_A_NV" },
    { GLenum::GL_VARIABLE_B_NV, "GL_VARIABLE_B_NV" },
    { GLenum::GL_VARIABLE_C_NV, "GL_VARIABLE_C_NV" },
    { GLenum::GL_VARIABLE_D_NV, "GL_VARIABLE_D_NV" },
    { GLenum::GL_VARIABLE_E_NV, "GL_VARIABLE_E_NV" },
    { GLenum::GL_VARIABLE_F_NV, "GL_VARIABLE_F_NV" },
    { GLenum::GL_VARIABLE_G_NV, "GL_VARIABLE_G_NV" },
    { GLenum::GL_CONSTANT_COLOR0_NV, "GL_CONSTANT_COLOR0_NV" },
    { GLenum::GL_CONSTANT_COLOR1_NV, "GL_CONSTANT_COLOR1_NV" },
    { GLenum::GL_PRIMARY_COLOR_NV, "GL_PRIMARY_COLOR_NV" },
    { GLenum::GL_SECONDARY_COLOR_NV, "GL_SECONDARY_COLOR_NV" },
    { GLenum::GL_SPARE0_NV, "GL_SPARE0_NV" },
    { GLenum::GL_SPARE1_NV, "GL_SPARE1_NV" },
    { GLenum::GL_DISCARD_NV, "GL_DISCARD_NV" },
    { GLenum::GL_E_TIMES_F_NV, "GL_E_TIMES_F_NV" },
    { GLenum::GL_SPARE0_PLUS_SECONDARY_COLOR_NV, "GL_SPARE0_PLUS_SECONDARY_COLOR_NV" },
    { GLenum::GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV, "GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV" },
    { GLenum::GL_MULTISAMPLE_FILTER_HINT_NV, "GL_MULTISAMPLE_FILTER_HINT_NV" },
    { GLenum::GL_PER_STAGE_CONSTANTS_NV, "GL_PER_STAGE_CONSTANTS_NV" },
    { GLenum::GL_UNSIGNED_IDENTITY_NV, "GL_UNSIGNED_IDENTITY_NV" },
    { GLenum::GL_UNSIGNED_INVERT_NV, "GL_UNSIGNED_INVERT_NV" },
    { GLenum::GL_EXPAND_NORMAL_NV, "GL_EXPAND_NORMAL_NV" },
    { GLenum::GL_EXPAND_NEGATE_NV, "GL_EXPAND_NEGATE_NV" },
    { GLenum::GL_HALF_BIAS_NORMAL_NV, "GL_HALF_BIAS_NORMAL_NV" },
    { GLenum::GL_HALF_BIAS_NEGATE_NV, "GL_HALF_BIAS_NEGATE_NV" },
    { GLenum::GL_SIGNED_IDENTITY_NV, "GL_SIGNED_IDENTITY_NV" },
    { GLenum::GL_SIGNED_NEGATE_NV, "GL_SIGNED_NEGATE_NV" },
    { GLenum::GL_SCALE_BY_TWO_NV, "GL_SCALE_BY_TWO_NV" },
    { GLenum::GL_SCALE_BY_FOUR_NV, "GL_SCALE_BY_FOUR_NV" },
    { GLenum::GL_SCALE_BY_ONE_HALF_NV, "GL_SCALE_BY_ONE_HALF_NV" },
    { GLenum::GL_BIAS_BY_NEGATIVE_ONE_HALF_NV, "GL_BIAS_BY_NEGATIVE_ONE_HALF_NV" },
    { GLenum::GL_COMBINER_INPUT_NV, "GL_COMBINER_INPUT_NV" },
    { GLenum::GL_COMBINER_MAPPING_NV, "GL_COMBINER_MAPPING_NV" },
    { GLenum::GL_COMBINER_COMPONENT_USAGE_NV, "GL_COMBINER_COMPONENT_USAGE_NV" },
    { GLenum::GL_COMBINER_AB_DOT_PRODUCT_NV, "GL_COMBINER_AB_DOT_PRODUCT_NV" },
    { GLenum::GL_COMBINER_CD_DOT_PRODUCT_NV, "GL_COMBINER_CD_DOT_PRODUCT_NV" },
    { GLenum::GL_COMBINER_MUX_SUM_NV, "GL_COMBINER_MUX_SUM_NV" },
    { GLenum::GL_COMBINER_SCALE_NV, "GL_COMBINER_SCALE_NV" },
    { GLenum::GL_COMBINER_BIAS_NV, "GL_COMBINER_BIAS_NV" },
    { GLenum::GL_COMBINER_AB_OUTPUT_NV, "GL_COMBINER_AB_OUTPUT_NV" },
    { GLenum::GL_COMBINER_CD_OUTPUT_NV, "GL_COMBINER_CD_OUTPUT_NV" },
    { GLenum::GL_COMBINER_SUM_OUTPUT_NV, "GL_COMBINER_SUM_OUTPUT_NV" },
    { GLenum::GL_MAX_GENERAL_COMBINERS_NV, "GL_MAX_GENERAL_COMBINERS_NV" },
    { GLenum::GL_NUM_GENERAL_COMBINERS_NV, "GL_NUM_GENERAL_COMBINERS_NV" },
    { GLenum::GL_COLOR_SUM_CLAMP_NV, "GL_COLOR_SUM_CLAMP_NV" },
    { GLenum::GL_COMBINER0_NV, "GL_COMBINER0_NV" },
    { GLenum::GL_COMBINER1_NV, "GL_COMBINER1_NV" },
    { GLenum::GL_COMBINER2_NV, "GL_COMBINER2_NV" },
    { GLenum::GL_COMBINER3_NV, "GL_COMBINER3_NV" },
    { GLenum::GL_COMBINER4_NV, "GL_COMBINER4_NV" },
    { GLenum::GL_COMBINER5_NV, "GL_COMBINER5_NV" },
    { GLenum::GL_COMBINER6_NV, "GL_COMBINER6_NV" },
    { GLenum::GL_COMBINER7_NV, "GL_COMBINER7_NV" },
    { GLenum::GL_PRIMITIVE_RESTART_NV, "GL_PRIMITIVE_RESTART_NV" },
    { GLenum::GL_PRIMITIVE_RESTART_INDEX_NV, "GL_PRIMITIVE_RESTART_INDEX_NV" },
    { GLenum::GL_FOG_DISTANCE_MODE_NV, "GL_FOG_DISTANCE_MODE_NV" },
    { GLenum::GL_EYE_RADIAL_NV, "GL_EYE_RADIAL_NV" },
    { GLenum::GL_EYE_PLANE_ABSOLUTE_NV, "GL_EYE_PLANE_ABSOLUTE_NV" },
    { GLenum::GL_EMBOSS_LIGHT_NV, "GL_EMBOSS_LIGHT_NV" },
    { GLenum::GL_EMBOSS_CONSTANT_NV, "GL_EMBOSS_CONSTANT_NV" },
    { GLenum::GL_EMBOSS_MAP_NV, "GL_EMBOSS_MAP_NV" },
    { GLenum::GL_RED_MIN_CLAMP_INGR, "GL_RED_MIN_CLAMP_INGR" },
    { GLenum::GL_GREEN_MIN_CLAMP_INGR, "GL_GREEN_MIN_CLAMP_INGR" },
    { GLenum::GL_BLUE_MIN_CLAMP_INGR, "GL_BLUE_MIN_CLAMP_INGR" },
    { GLenum::GL_ALPHA_MIN_CLAMP_INGR, "GL_ALPHA_MIN_CLAMP_INGR" },
    { GLenum::GL_RED_MAX_CLAMP_INGR, "GL_RED_MAX_CLAMP_INGR" },
    { GLenum::GL_GREEN_MAX_CLAMP_INGR, "GL_GREEN_MAX_CLAMP_INGR" },
    { GLenum::GL_BLUE_MAX_CLAMP_INGR, "GL_BLUE_MAX_CLAMP_INGR" },
    { GLenum::GL_ALPHA_MAX_CLAMP_INGR, "GL_ALPHA_MAX_CLAMP_INGR" },
    { GLenum::GL_INTERLACE_READ_INGR, "GL_INTERLACE_READ_INGR" },
    { GLenum::GL_COMBINE, "GL_COMBINE" },
    { GLenum::GL_COMBINE_RGB, "GL_COMBINE_RGB" },
    { GLenum::GL_COMBINE_ALPHA, "GL_COMBINE_ALPHA" },
    { GLenum::GL_RGB_SCALE, "GL_RGB_SCALE" },
    { GLenum::GL_ADD_SIGNED, "GL_ADD_SIGNED" },
    { GLenum::GL_INTERPOLATE, "GL_INTERPOLATE" },
    { GLenum::GL_CONSTANT, "GL_CONSTANT" },
    { GLenum::GL_PRIMARY_COLOR, "GL_PRIMARY_COLOR" },
    { GLenum::GL_PREVIOUS, "GL_PREVIOUS" },
    { GLenum::GL_SOURCE0_RGB, "GL_SOURCE0_RGB" },
    { GLenum::GL_SOURCE1_RGB, "GL_SOURCE1_RGB" },
    { GLenum::GL_SOURCE2_RGB, "GL_SOURCE2_RGB" },
    { GLenum::GL_SOURCE3_RGB_NV, "GL_SOURCE3_RGB_NV" },
    { GLenum::GL_SOURCE0_ALPHA, "GL_SOURCE0_ALPHA" },
    { GLenum::GL_SOURCE1_ALPHA, "GL_SOURCE1_ALPHA" },
    { GLenum::GL_SOURCE2_ALPHA, "GL_SOURCE2_ALPHA" },
    { GLenum::GL_SOURCE3_ALPHA_NV, "GL_SOURCE3_ALPHA_NV" },
    { GLenum::GL_OPERAND0_RGB, "GL_OPERAND0_RGB" },
    { GLenum::GL_OPERAND1_RGB, "GL_OPERAND1_RGB" },
    { GLenum::GL_OPERAND2_RGB, "GL_OPERAND2_RGB" },
    { GLenum::GL_OPERAND3_RGB_NV, "GL_OPERAND3_RGB_NV" },
    { GLenum::GL_OPERAND0_ALPHA, "GL_OPERAND0_ALPHA" },
    { GLenum::GL_OPERAND1_ALPHA, "GL_OPERAND1_ALPHA" },
    { GLenum::GL_OPERAND2_ALPHA, "GL_OPERAND2_ALPHA" },
    { GLenum::GL_OPERAND3_ALPHA_NV, "GL_OPERAND3_ALPHA_NV" },
    { GLenum::GL_PACK_SUBSAMPLE_RATE_SGIX, "GL_PACK_SUBSAMPLE_RATE_SGIX" },
    { GLenum::GL_UNPACK_SUBSAMPLE_RATE_SGIX, "GL_UNPACK_SUBSAMPLE_RATE_SGIX" },
    { GLenum::GL_PIXEL_SUBSAMPLE_4444_SGIX, "GL_PIXEL_SUBSAMPLE_4444_SGIX" },
    { GLenum::GL_PIXEL_SUBSAMPLE_2424_SGIX, "GL_PIXEL_SUBSAMPLE_2424_SGIX" },
    { GLenum::GL_PIXEL_SUBSAMPLE_4242_SGIX, "GL_PIXEL_SUBSAMPLE_4242_SGIX" },
    { GLenum::GL_PERTURB_EXT, "GL_PERTURB_EXT" },
    { GLenum::GL_TEXTURE_NORMAL_EXT, "GL_TEXTURE_NORMAL_EXT" },
    { GLenum::GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE, "GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE" },
    { GLenum::GL_TRANSFORM_HINT_APPLE, "GL_TRANSFORM_HINT_APPLE" },
    { GLenum::GL_UNPACK_CLIENT_STORAGE_APPLE, "GL_UNPACK_CLIENT_STORAGE_APPLE" },
    { GLenum::GL_BUFFER_OBJECT_APPLE, "GL_BUFFER_OBJECT_APPLE" },
    { GLenum::GL_STORAGE_CLIENT_APPLE, "GL_STORAGE_CLIENT_APPLE" },
    { GLenum::GL_VERTEX_ARRAY_BINDING, "GL_VERTEX_ARRAY_BINDING" },
    { GLenum::GL_TEXTURE_RANGE_LENGTH_APPLE, "GL_TEXTURE_RANGE_LENGTH_APPLE" },
    { GLenum::GL_TEXTURE_RANGE_POINTER_APPLE, "GL_TEXTURE_RANGE_POINTER_APPLE" },
    { GLenum::GL_YCBCR_422_APPLE, "GL_YCBCR_422_APPLE" },
    { GLenum::GL_UNSIGNED_SHORT_8_8_MESA, "GL_UNSIGNED_SHORT_8_8_MESA" },
    { GLenum::GL_UNSIGNED_SHORT_8_8_REV_MESA, "GL_UNSIGNED_SHORT_8_8_REV_MESA" },
    { GLenum::GL_TEXTURE_STORAGE_HINT_APPLE, "GL_TEXTURE_STORAGE_HINT_APPLE" },
    { GLenum::GL_STORAGE_PRIVATE_APPLE, "GL_STORAGE_PRIVATE_APPLE" },
    { GLenum::GL_STORAGE_CACHED_APPLE, "GL_STORAGE_CACHED_APPLE" },
    { GLenum::GL_STORAGE_SHARED_APPLE, "GL_STORAGE_SHARED_APPLE" },
    { GLenum::GL_REPLACEMENT_CODE_ARRAY_SUN, "GL_REPLACEMENT_CODE_ARRAY_SUN" },
    { GLenum::GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN, "GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN" },
    { GLenum::GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN, "GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN" },
    { GLenum::GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN, "GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN" },
    { GLenum::GL_R1UI_V3F_SUN, "GL_R1UI_V3F_SUN" },
    { GLenum::GL_R1UI_C4UB_V3F_SUN, "GL_R1UI_C4UB_V3F_SUN" },
    { GLenum::GL_R1UI_C3F_V3F_SUN, "GL_R1UI_C3F_V3F_SUN" },
    { GLenum::GL_R1UI_N3F_V3F_SUN, "GL_R1UI_N3F_V3F_SUN" },
    { GLenum::GL_R1UI_C4F_N3F_V3F_SUN, "GL_R1UI_C4F_N3F_V3F_SUN" },
    { GLenum::GL_R1UI_T2F_V3F_SUN, "GL_R1UI_T2F_V3F_SUN" },
    { GLenum::GL_R1UI_T2F_N3F_V3F_SUN, "GL_R1UI_T2F_N3F_V3F_SUN" },
    { GLenum::GL_R1UI_T2F_C4F_N3F_V3F_SUN, "GL_R1UI_T2F_C4F_N3F_V3F_SUN" },
    { GLenum::GL_SLICE_ACCUM_SUN, "GL_SLICE_ACCUM_SUN" },
    { GLenum::GL_QUAD_MESH_SUN, "GL_QUAD_MESH_SUN" },
    { GLenum::GL_TRIANGLE_MESH_SUN, "GL_TRIANGLE_MESH_SUN" },
    { GLenum::GL_VERTEX_PROGRAM_ARB, "GL_VERTEX_PROGRAM_ARB" },
    { GLenum::GL_VERTEX_STATE_PROGRAM_NV, "GL_VERTEX_STATE_PROGRAM_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_ENABLED, "GL_VERTEX_ATTRIB_ARRAY_ENABLED" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_SIZE, "GL_VERTEX_ATTRIB_ARRAY_SIZE" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_STRIDE, "GL_VERTEX_ATTRIB_ARRAY_STRIDE" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_TYPE, "GL_VERTEX_ATTRIB_ARRAY_TYPE" },
    { GLenum::GL_CURRENT_VERTEX_ATTRIB, "GL_CURRENT_VERTEX_ATTRIB" },
    { GLenum::GL_PROGRAM_LENGTH_ARB, "GL_PROGRAM_LENGTH_ARB" },
    { GLenum::GL_PROGRAM_STRING_ARB, "GL_PROGRAM_STRING_ARB" },
    { GLenum::GL_MODELVIEW_PROJECTION_NV, "GL_MODELVIEW_PROJECTION_NV" },
    { GLenum::GL_IDENTITY_NV, "GL_IDENTITY_NV" },
    { GLenum::GL_INVERSE_NV, "GL_INVERSE_NV" },
    { GLenum::GL_TRANSPOSE_NV, "GL_TRANSPOSE_NV" },
    { GLenum::GL_INVERSE_TRANSPOSE_NV, "GL_INVERSE_TRANSPOSE_NV" },
    { GLenum::GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB, "GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB" },
    { GLenum::GL_MAX_PROGRAM_MATRICES_ARB, "GL_MAX_PROGRAM_MATRICES_ARB" },
    { GLenum::GL_MATRIX0_NV, "GL_MATRIX0_NV" },
    { GLenum::GL_MATRIX1_NV, "GL_MATRIX1_NV" },
    { GLenum::GL_MATRIX2_NV, "GL_MATRIX2_NV" },
    { GLenum::GL_MATRIX3_NV, "GL_MATRIX3_NV" },
    { GLenum::GL_MATRIX4_NV, "GL_MATRIX4_NV" },
    { GLenum::GL_MATRIX5_NV, "GL_MATRIX5_NV" },
    { GLenum::GL_MATRIX6_NV, "GL_MATRIX6_NV" },
    { GLenum::GL_MATRIX7_NV, "GL_MATRIX7_NV" },
    { GLenum::GL_CURRENT_MATRIX_STACK_DEPTH_ARB, "GL_CURRENT_MATRIX_STACK_DEPTH_ARB" },
    { GLenum::GL_CURRENT_MATRIX_ARB, "GL_CURRENT_MATRIX_ARB" },
    { GLenum::GL_PROGRAM_POINT_SIZE, "GL_PROGRAM_POINT_SIZE" },
    { GLenum::GL_VERTEX_PROGRAM_TWO_SIDE, "GL_VERTEX_PROGRAM_TWO_SIDE" },
    { GLenum::GL_PROGRAM_PARAMETER_NV, "GL_PROGRAM_PARAMETER_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_POINTER, "GL_VERTEX_ATTRIB_ARRAY_POINTER" },
    { GLenum::GL_PROGRAM_TARGET_NV, "GL_PROGRAM_TARGET_NV" },
    { GLenum::GL_PROGRAM_RESIDENT_NV, "GL_PROGRAM_RESIDENT_NV" },
    { GLenum::GL_TRACK_MATRIX_NV, "GL_TRACK_MATRIX_NV" },
    { GLenum::GL_TRACK_MATRIX_TRANSFORM_NV, "GL_TRACK_MATRIX_TRANSFORM_NV" },
    { GLenum::GL_VERTEX_PROGRAM_BINDING_NV, "GL_VERTEX_PROGRAM_BINDING_NV" },
    { GLenum::GL_PROGRAM_ERROR_POSITION_ARB, "GL_PROGRAM_ERROR_POSITION_ARB" },
    { GLenum::GL_OFFSET_TEXTURE_RECTANGLE_NV, "GL_OFFSET_TEXTURE_RECTANGLE_NV" },
    { GLenum::GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV, "GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV" },
    { GLenum::GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV, "GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV" },
    { GLenum::GL_DEPTH_CLAMP, "GL_DEPTH_CLAMP" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY0_NV, "GL_VERTEX_ATTRIB_ARRAY0_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY1_NV, "GL_VERTEX_ATTRIB_ARRAY1_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY2_NV, "GL_VERTEX_ATTRIB_ARRAY2_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY3_NV, "GL_VERTEX_ATTRIB_ARRAY3_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY4_NV, "GL_VERTEX_ATTRIB_ARRAY4_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY5_NV, "GL_VERTEX_ATTRIB_ARRAY5_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY6_NV, "GL_VERTEX_ATTRIB_ARRAY6_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY7_NV, "GL_VERTEX_ATTRIB_ARRAY7_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY8_NV, "GL_VERTEX_ATTRIB_ARRAY8_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY9_NV, "GL_VERTEX_ATTRIB_ARRAY9_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY10_NV, "GL_VERTEX_ATTRIB_ARRAY10_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY11_NV, "GL_VERTEX_ATTRIB_ARRAY11_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY12_NV, "GL_VERTEX_ATTRIB_ARRAY12_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY13_NV, "GL_VERTEX_ATTRIB_ARRAY13_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY14_NV, "GL_VERTEX_ATTRIB_ARRAY14_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY15_NV, "GL_VERTEX_ATTRIB_ARRAY15_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB0_4_NV, "GL_MAP1_VERTEX_ATTRIB0_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB1_4_NV, "GL_MAP1_VERTEX_ATTRIB1_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB2_4_NV, "GL_MAP1_VERTEX_ATTRIB2_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB3_4_NV, "GL_MAP1_VERTEX_ATTRIB3_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB4_4_NV, "GL_MAP1_VERTEX_ATTRIB4_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB5_4_NV, "GL_MAP1_VERTEX_ATTRIB5_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB6_4_NV, "GL_MAP1_VERTEX_ATTRIB6_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB7_4_NV, "GL_MAP1_VERTEX_ATTRIB7_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB8_4_NV, "GL_MAP1_VERTEX_ATTRIB8_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB9_4_NV, "GL_MAP1_VERTEX_ATTRIB9_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB10_4_NV, "GL_MAP1_VERTEX_ATTRIB10_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB11_4_NV, "GL_MAP1_VERTEX_ATTRIB11_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB12_4_NV, "GL_MAP1_VERTEX_ATTRIB12_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB13_4_NV, "GL_MAP1_VERTEX_ATTRIB13_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB14_4_NV, "GL_MAP1_VERTEX_ATTRIB14_4_NV" },
    { GLenum::GL_MAP1_VERTEX_ATTRIB15_4_NV, "GL_MAP1_VERTEX_ATTRIB15_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB0_4_NV, "GL_MAP2_VERTEX_ATTRIB0_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB1_4_NV, "GL_MAP2_VERTEX_ATTRIB1_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB2_4_NV, "GL_MAP2_VERTEX_ATTRIB2_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB3_4_NV, "GL_MAP2_VERTEX_ATTRIB3_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB4_4_NV, "GL_MAP2_VERTEX_ATTRIB4_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB5_4_NV, "GL_MAP2_VERTEX_ATTRIB5_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB6_4_NV, "GL_MAP2_VERTEX_ATTRIB6_4_NV" },
    { GLenum::GL_PROGRAM_BINDING_ARB, "GL_PROGRAM_BINDING_ARB" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB8_4_NV, "GL_MAP2_VERTEX_ATTRIB8_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB9_4_NV, "GL_MAP2_VERTEX_ATTRIB9_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB10_4_NV, "GL_MAP2_VERTEX_ATTRIB10_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB11_4_NV, "GL_MAP2_VERTEX_ATTRIB11_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB12_4_NV, "GL_MAP2_VERTEX_ATTRIB12_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB13_4_NV, "GL_MAP2_VERTEX_ATTRIB13_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB14_4_NV, "GL_MAP2_VERTEX_ATTRIB14_4_NV" },
    { GLenum::GL_MAP2_VERTEX_ATTRIB15_4_NV, "GL_MAP2_VERTEX_ATTRIB15_4_NV" },
    { GLenum::GL_TEXTURE_COMPRESSED_IMAGE_SIZE, "GL_TEXTURE_COMPRESSED_IMAGE_SIZE" },
    { GLenum::GL_TEXTURE_COMPRESSED, "GL_TEXTURE_COMPRESSED" },
    { GLenum::GL_NUM_COMPRESSED_TEXTURE_FORMATS, "GL_NUM_COMPRESSED_TEXTURE_FORMATS" },
    { GLenum::GL_COMPRESSED_TEXTURE_FORMATS, "GL_COMPRESSED_TEXTURE_FORMATS" },
    { GLenum::GL_MAX_VERTEX_UNITS_ARB, "GL_MAX_VERTEX_UNITS_ARB" },
    { GLenum::GL_ACTIVE_VERTEX_UNITS_ARB, "GL_ACTIVE_VERTEX_UNITS_ARB" },
    { GLenum::GL_WEIGHT_SUM_UNITY_ARB, "GL_WEIGHT_SUM_UNITY_ARB" },
    { GLenum::GL_VERTEX_BLEND_ARB, "GL_VERTEX_BLEND_ARB" },
    { GLenum::GL_CURRENT_WEIGHT_ARB, "GL_CURRENT_WEIGHT_ARB" },
    { GLenum::GL_WEIGHT_ARRAY_TYPE_ARB, "GL_WEIGHT_ARRAY_TYPE_ARB" },
    { GLenum::GL_WEIGHT_ARRAY_STRIDE_ARB, "GL_WEIGHT_ARRAY_STRIDE_ARB" },
    { GLenum::GL_WEIGHT_ARRAY_SIZE_ARB, "GL_WEIGHT_ARRAY_SIZE_ARB" },
    { GLenum::GL_WEIGHT_ARRAY_POINTER_ARB, "GL_WEIGHT_ARRAY_POINTER_ARB" },
    { GLenum::GL_WEIGHT_ARRAY_ARB, "GL_WEIGHT_ARRAY_ARB" },
    { GLenum::GL_DOT3_RGB, "GL_DOT3_RGB" },
    { GLenum::GL_DOT3_RGBA, "GL_DOT3_RGBA" },
    { GLenum::GL_COMPRESSED_RGB_FXT1_3DFX, "GL_COMPRESSED_RGB_FXT1_3DFX" },
    { GLenum::GL_COMPRESSED_RGBA_FXT1_3DFX, "GL_COMPRESSED_RGBA_FXT1_3DFX" },
    { GLenum::GL_MULTISAMPLE_3DFX, "GL_MULTISAMPLE_3DFX" },
    { GLenum::GL_SAMPLE_BUFFERS_3DFX, "GL_SAMPLE_BUFFERS_3DFX" },
    { GLenum::GL_SAMPLES_3DFX, "GL_SAMPLES_3DFX" },
    { GLenum::GL_EVAL_2D_NV, "GL_EVAL_2D_NV" },
    { GLenum::GL_EVAL_TRIANGULAR_2D_NV, "GL_EVAL_TRIANGULAR_2D_NV" },
    { GLenum::GL_MAP_TESSELLATION_NV, "GL_MAP_TESSELLATION_NV" },
    { GLenum::GL_MAP_ATTRIB_U_ORDER_NV, "GL_MAP_ATTRIB_U_ORDER_NV" },
    { GLenum::GL_MAP_ATTRIB_V_ORDER_NV, "GL_MAP_ATTRIB_V_ORDER_NV" },
    { GLenum::GL_EVAL_FRACTIONAL_TESSELLATION_NV, "GL_EVAL_FRACTIONAL_TESSELLATION_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB0_NV, "GL_EVAL_VERTEX_ATTRIB0_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB1_NV, "GL_EVAL_VERTEX_ATTRIB1_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB2_NV, "GL_EVAL_VERTEX_ATTRIB2_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB3_NV, "GL_EVAL_VERTEX_ATTRIB3_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB4_NV, "GL_EVAL_VERTEX_ATTRIB4_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB5_NV, "GL_EVAL_VERTEX_ATTRIB5_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB6_NV, "GL_EVAL_VERTEX_ATTRIB6_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB7_NV, "GL_EVAL_VERTEX_ATTRIB7_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB8_NV, "GL_EVAL_VERTEX_ATTRIB8_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB9_NV, "GL_EVAL_VERTEX_ATTRIB9_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB10_NV, "GL_EVAL_VERTEX_ATTRIB10_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB11_NV, "GL_EVAL_VERTEX_ATTRIB11_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB12_NV, "GL_EVAL_VERTEX_ATTRIB12_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB13_NV, "GL_EVAL_VERTEX_ATTRIB13_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB14_NV, "GL_EVAL_VERTEX_ATTRIB14_NV" },
    { GLenum::GL_EVAL_VERTEX_ATTRIB15_NV, "GL_EVAL_VERTEX_ATTRIB15_NV" },
    { GLenum::GL_MAX_MAP_TESSELLATION_NV, "GL_MAX_MAP_TESSELLATION_NV" },
    { GLenum::GL_MAX_RATIONAL_EVAL_ORDER_NV, "GL_MAX_RATIONAL_EVAL_ORDER_NV" },
    { GLenum::GL_MAX_PROGRAM_PATCH_ATTRIBS_NV, "GL_MAX_PROGRAM_PATCH_ATTRIBS_NV" },
    { GLenum::GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV, "GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV" },
    { GLenum::GL_UNSIGNED_INT_S8_S8_8_8_NV, "GL_UNSIGNED_INT_S8_S8_8_8_NV" },
    { GLenum::GL_UNSIGNED_INT_8_8_S8_S8_REV_NV, "GL_UNSIGNED_INT_8_8_S8_S8_REV_NV" },
    { GLenum::GL_DSDT_MAG_INTENSITY_NV, "GL_DSDT_MAG_INTENSITY_NV" },
    { GLenum::GL_SHADER_CONSISTENT_NV, "GL_SHADER_CONSISTENT_NV" },
    { GLenum::GL_TEXTURE_SHADER_NV, "GL_TEXTURE_SHADER_NV" },
    { GLenum::GL_SHADER_OPERATION_NV, "GL_SHADER_OPERATION_NV" },
    { GLenum::GL_CULL_MODES_NV, "GL_CULL_MODES_NV" },
    { GLenum::GL_OFFSET_TEXTURE_2D_MATRIX_NV, "GL_OFFSET_TEXTURE_2D_MATRIX_NV" },
    { GLenum::GL_OFFSET_TEXTURE_2D_SCALE_NV, "GL_OFFSET_TEXTURE_2D_SCALE_NV" },
    { GLenum::GL_OFFSET_TEXTURE_2D_BIAS_NV, "GL_OFFSET_TEXTURE_2D_BIAS_NV" },
    { GLenum::GL_PREVIOUS_TEXTURE_INPUT_NV, "GL_PREVIOUS_TEXTURE_INPUT_NV" },
    { GLenum::GL_CONST_EYE_NV, "GL_CONST_EYE_NV" },
    { GLenum::GL_PASS_THROUGH_NV, "GL_PASS_THROUGH_NV" },
    { GLenum::GL_CULL_FRAGMENT_NV, "GL_CULL_FRAGMENT_NV" },
    { GLenum::GL_OFFSET_TEXTURE_2D_NV, "GL_OFFSET_TEXTURE_2D_NV" },
    { GLenum::GL_DEPENDENT_AR_TEXTURE_2D_NV, "GL_DEPENDENT_AR_TEXTURE_2D_NV" },
    { GLenum::GL_DEPENDENT_GB_TEXTURE_2D_NV, "GL_DEPENDENT_GB_TEXTURE_2D_NV" },
    { GLenum::GL_SURFACE_STATE_NV, "GL_SURFACE_STATE_NV" },
    { GLenum::GL_DOT_PRODUCT_NV, "GL_DOT_PRODUCT_NV" },
    { GLenum::GL_DOT_PRODUCT_DEPTH_REPLACE_NV, "GL_DOT_PRODUCT_DEPTH_REPLACE_NV" },
    { GLenum::GL_DOT_PRODUCT_TEXTURE_2D_NV, "GL_DOT_PRODUCT_TEXTURE_2D_NV" },
    { GLenum::GL_DOT_PRODUCT_TEXTURE_3D_NV, "GL_DOT_PRODUCT_TEXTURE_3D_NV" },
    { GLenum::GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV, "GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV" },
    { GLenum::GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV, "GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV" },
    { GLenum::GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV, "GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV" },
    { GLenum::GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV, "GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV" },
    { GLenum::GL_HILO_NV, "GL_HILO_NV" },
    { GLenum::GL_DSDT_NV, "GL_DSDT_NV" },
    { GLenum::GL_DSDT_MAG_NV, "GL_DSDT_MAG_NV" },
    { GLenum::GL_DSDT_MAG_VIB_NV, "GL_DSDT_MAG_VIB_NV" },
    { GLenum::GL_HILO16_NV, "GL_HILO16_NV" },
    { GLenum::GL_SIGNED_HILO_NV, "GL_SIGNED_HILO_NV" },
    { GLenum::GL_SIGNED_HILO16_NV, "GL_SIGNED_HILO16_NV" },
    { GLenum::GL_SIGNED_RGBA_NV, "GL_SIGNED_RGBA_NV" },
    { GLenum::GL_SIGNED_RGBA8_NV, "GL_SIGNED_RGBA8_NV" },
    { GLenum::GL_SURFACE_REGISTERED_NV, "GL_SURFACE_REGISTERED_NV" },
    { GLenum::GL_SIGNED_RGB_NV, "GL_SIGNED_RGB_NV" },
    { GLenum::GL_SIGNED_RGB8_NV, "GL_SIGNED_RGB8_NV" },
    { GLenum::GL_SURFACE_MAPPED_NV, "GL_SURFACE_MAPPED_NV" },
    { GLenum::GL_SIGNED_LUMINANCE_NV, "GL_SIGNED_LUMINANCE_NV" },
    { GLenum::GL_SIGNED_LUMINANCE8_NV, "GL_SIGNED_LUMINANCE8_NV" },
    { GLenum::GL_SIGNED_LUMINANCE_ALPHA_NV, "GL_SIGNED_LUMINANCE_ALPHA_NV" },
    { GLenum::GL_SIGNED_LUMINANCE8_ALPHA8_NV, "GL_SIGNED_LUMINANCE8_ALPHA8_NV" },
    { GLenum::GL_SIGNED_ALPHA_NV, "GL_SIGNED_ALPHA_NV" },
    { GLenum::GL_SIGNED_ALPHA8_NV, "GL_SIGNED_ALPHA8_NV" },
    { GLenum::GL_SIGNED_INTENSITY_NV, "GL_SIGNED_INTENSITY_NV" },
    { GLenum::GL_SIGNED_INTENSITY8_NV, "GL_SIGNED_INTENSITY8_NV" },
    { GLenum::GL_DSDT8_NV, "GL_DSDT8_NV" },
    { GLenum::GL_DSDT8_MAG8_NV, "GL_DSDT8_MAG8_NV" },
    { GLenum::GL_DSDT8_MAG8_INTENSITY8_NV, "GL_DSDT8_MAG8_INTENSITY8_NV" },
    { GLenum::GL_SIGNED_RGB_UNSIGNED_ALPHA_NV, "GL_SIGNED_RGB_UNSIGNED_ALPHA_NV" },
    { GLenum::GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV, "GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV" },
    { GLenum::GL_HI_SCALE_NV, "GL_HI_SCALE_NV" },
    { GLenum::GL_LO_SCALE_NV, "GL_LO_SCALE_NV" },
    { GLenum::GL_DS_SCALE_NV, "GL_DS_SCALE_NV" },
    { GLenum::GL_DT_SCALE_NV, "GL_DT_SCALE_NV" },
    { GLenum::GL_MAGNITUDE_SCALE_NV, "GL_MAGNITUDE_SCALE_NV" },
    { GLenum::GL_VIBRANCE_SCALE_NV, "GL_VIBRANCE_SCALE_NV" },
    { GLenum::GL_HI_BIAS_NV, "GL_HI_BIAS_NV" },
    { GLenum::GL_LO_BIAS_NV, "GL_LO_BIAS_NV" },
    { GLenum::GL_DS_BIAS_NV, "GL_DS_BIAS_NV" },
    { GLenum::GL_DT_BIAS_NV, "GL_DT_BIAS_NV" },
    { GLenum::GL_MAGNITUDE_BIAS_NV, "GL_MAGNITUDE_BIAS_NV" },
    { GLenum::GL_VIBRANCE_BIAS_NV, "GL_VIBRANCE_BIAS_NV" },
    { GLenum::GL_TEXTURE_BORDER_VALUES_NV, "GL_TEXTURE_BORDER_VALUES_NV" },
    { GLenum::GL_TEXTURE_HI_SIZE_NV, "GL_TEXTURE_HI_SIZE_NV" },
    { GLenum::GL_TEXTURE_LO_SIZE_NV, "GL_TEXTURE_LO_SIZE_NV" },
    { GLenum::GL_TEXTURE_DS_SIZE_NV, "GL_TEXTURE_DS_SIZE_NV" },
    { GLenum::GL_TEXTURE_DT_SIZE_NV, "GL_TEXTURE_DT_SIZE_NV" },
    { GLenum::GL_TEXTURE_MAG_SIZE_NV, "GL_TEXTURE_MAG_SIZE_NV" },
    { GLenum::GL_MODELVIEW2_ARB, "GL_MODELVIEW2_ARB" },
    { GLenum::GL_MODELVIEW3_ARB, "GL_MODELVIEW3_ARB" },
    { GLenum::GL_MODELVIEW4_ARB, "GL_MODELVIEW4_ARB" },
    { GLenum::GL_MODELVIEW5_ARB, "GL_MODELVIEW5_ARB" },
    { GLenum::GL_MODELVIEW6_ARB, "GL_MODELVIEW6_ARB" },
    { GLenum::GL_MODELVIEW7_ARB, "GL_MODELVIEW7_ARB" },
    { GLenum::GL_MODELVIEW8_ARB, "GL_MODELVIEW8_ARB" },
    { GLenum::GL_MODELVIEW9_ARB, "GL_MODELVIEW9_ARB" },
    { GLenum::GL_MODELVIEW10_ARB, "GL_MODELVIEW10_ARB" },
    { GLenum::GL_MODELVIEW11_ARB, "GL_MODELVIEW11_ARB" },
    { GLenum::GL_MODELVIEW12_ARB, "GL_MODELVIEW12_ARB" },
    { GLenum::GL_MODELVIEW13_ARB, "GL_MODELVIEW13_ARB" },
    { GLenum::GL_MODELVIEW14_ARB, "GL_MODELVIEW14_ARB" },
    { GLenum::GL_MODELVIEW15_ARB, "GL_MODELVIEW15_ARB" },
    { GLenum::GL_MODELVIEW16_ARB, "GL_MODELVIEW16_ARB" },
    { GLenum::GL_MODELVIEW17_ARB, "GL_MODELVIEW17_ARB" },
    { GLenum::GL_MODELVIEW18_ARB, "GL_MODELVIEW18_ARB" },
    { GLenum::GL_MODELVIEW19_ARB, "GL_MODELVIEW19_ARB" },
    { GLenum::GL_MODELVIEW20_ARB, "GL_MODELVIEW20_ARB" },
    { GLenum::GL_MODELVIEW21_ARB, "GL_MODELVIEW21_ARB" },
    { GLenum::GL_MODELVIEW22_ARB, "GL_MODELVIEW22_ARB" },
    { GLenum::GL_MODELVIEW23_ARB, "GL_MODELVIEW23_ARB" },
    { GLenum::GL_MODELVIEW24_ARB, "GL_MODELVIEW24_ARB" },
    { GLenum::GL_MODELVIEW25_ARB, "GL_MODELVIEW25_ARB" },
    { GLenum::GL_MODELVIEW26_ARB, "GL_MODELVIEW26_ARB" },
    { GLenum::GL_MODELVIEW27_ARB, "GL_MODELVIEW27_ARB" },
    { GLenum::GL_MODELVIEW28_ARB, "GL_MODELVIEW28_ARB" },
    { GLenum::GL_MODELVIEW29_ARB, "GL_MODELVIEW29_ARB" },
    { GLenum::GL_MODELVIEW30_ARB, "GL_MODELVIEW30_ARB" },
    { GLenum::GL_MODELVIEW31_ARB, "GL_MODELVIEW31_ARB" },
    { GLenum::GL_DOT3_RGB_EXT, "GL_DOT3_RGB_EXT" },
    { GLenum::GL_PROGRAM_BINARY_LENGTH, "GL_PROGRAM_BINARY_LENGTH" },
    { GLenum::GL_MIRROR_CLAMP_ATI, "GL_MIRROR_CLAMP_ATI" },
    { GLenum::GL_MIRROR_CLAMP_TO_EDGE, "GL_MIRROR_CLAMP_TO_EDGE" },
    { GLenum::GL_MODULATE_ADD_ATI, "GL_MODULATE_ADD_ATI" },
    { GLenum::GL_MODULATE_SIGNED_ADD_ATI, "GL_MODULATE_SIGNED_ADD_ATI" },
    { GLenum::GL_MODULATE_SUBTRACT_ATI, "GL_MODULATE_SUBTRACT_ATI" },
    { GLenum::GL_SET_AMD, "GL_SET_AMD" },
    { GLenum::GL_REPLACE_VALUE_AMD, "GL_REPLACE_VALUE_AMD" },
    { GLenum::GL_STENCIL_OP_VALUE_AMD, "GL_STENCIL_OP_VALUE_AMD" },
    { GLenum::GL_STENCIL_BACK_OP_VALUE_AMD, "GL_STENCIL_BACK_OP_VALUE_AMD" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_LONG, "GL_VERTEX_ATTRIB_ARRAY_LONG" },
    { GLenum::GL_OCCLUSION_QUERY_EVENT_MASK_AMD, "GL_OCCLUSION_QUERY_EVENT_MASK_AMD" },
    { GLenum::GL_YCBCR_MESA, "GL_YCBCR_MESA" },
    { GLenum::GL_PACK_INVERT_MESA, "GL_PACK_INVERT_MESA" },
    { GLenum::GL_TEXTURE_1D_STACK_MESAX, "GL_TEXTURE_1D_STACK_MESAX" },
    { GLenum::GL_TEXTURE_2D_STACK_MESAX, "GL_TEXTURE_2D_STACK_MESAX" },
    { GLenum::GL_PROXY_TEXTURE_1D_STACK_MESAX, "GL_PROXY_TEXTURE_1D_STACK_MESAX" },
    { GLenum::GL_PROXY_TEXTURE_2D_STACK_MESAX, "GL_PROXY_TEXTURE_2D_STACK_MESAX" },
    { GLenum::GL_TEXTURE_1D_STACK_BINDING_MESAX, "GL_TEXTURE_1D_STACK_BINDING_MESAX" },
    { GLenum::GL_TEXTURE_2D_STACK_BINDING_MESAX, "GL_TEXTURE_2D_STACK_BINDING_MESAX" },
    { GLenum::GL_STATIC_ATI, "GL_STATIC_ATI" },
    { GLenum::GL_DYNAMIC_ATI, "GL_DYNAMIC_ATI" },
    { GLenum::GL_PRESERVE_ATI, "GL_PRESERVE_ATI" },
    { GLenum::GL_DISCARD_ATI, "GL_DISCARD_ATI" },
    { GLenum::GL_BUFFER_SIZE, "GL_BUFFER_SIZE" },
    { GLenum::GL_BUFFER_USAGE, "GL_BUFFER_USAGE" },
    { GLenum::GL_ARRAY_OBJECT_BUFFER_ATI, "GL_ARRAY_OBJECT_BUFFER_ATI" },
    { GLenum::GL_ARRAY_OBJECT_OFFSET_ATI, "GL_ARRAY_OBJECT_OFFSET_ATI" },
    { GLenum::GL_ELEMENT_ARRAY_ATI, "GL_ELEMENT_ARRAY_ATI" },
    { GLenum::GL_ELEMENT_ARRAY_TYPE_ATI, "GL_ELEMENT_ARRAY_TYPE_ATI" },
    { GLenum::GL_ELEMENT_ARRAY_POINTER_ATI, "GL_ELEMENT_ARRAY_POINTER_ATI" },
    { GLenum::GL_MAX_VERTEX_STREAMS_ATI, "GL_MAX_VERTEX_STREAMS_ATI" },
    { GLenum::GL_VERTEX_STREAM0_ATI, "GL_VERTEX_STREAM0_ATI" },
    { GLenum::GL_VERTEX_STREAM1_ATI, "GL_VERTEX_STREAM1_ATI" },
    { GLenum::GL_VERTEX_STREAM2_ATI, "GL_VERTEX_STREAM2_ATI" },
    { GLenum::GL_VERTEX_STREAM3_ATI, "GL_VERTEX_STREAM3_ATI" },
    { GLenum::GL_VERTEX_STREAM4_ATI, "GL_VERTEX_STREAM4_ATI" },
    { GLenum::GL_VERTEX_STREAM5_ATI, "GL_VERTEX_STREAM5_ATI" },
    { GLenum::GL_VERTEX_STREAM6_ATI, "GL_VERTEX_STREAM6_ATI" },
    { GLenum::GL_VERTEX_STREAM7_ATI, "GL_VERTEX_STREAM7_ATI" },
    { GLenum::GL_VERTEX_SOURCE_ATI, "GL_VERTEX_SOURCE_ATI" },
    { GLenum::GL_BUMP_ROT_MATRIX_ATI, "GL_BUMP_ROT_MATRIX_ATI" },
    { GLenum::GL_BUMP_ROT_MATRIX_SIZE_ATI, "GL_BUMP_ROT_MATRIX_SIZE_ATI" },
    { GLenum::GL_BUMP_NUM_TEX_UNITS_ATI, "GL_BUMP_NUM_TEX_UNITS_ATI" },
    { GLenum::GL_BUMP_TEX_UNITS_ATI, "GL_BUMP_TEX_UNITS_ATI" },
    { GLenum::GL_DUDV_ATI, "GL_DUDV_ATI" },
    { GLenum::GL_DU8DV8_ATI, "GL_DU8DV8_ATI" },
    { GLenum::GL_BUMP_ENVMAP_ATI, "GL_BUMP_ENVMAP_ATI" },
    { GLenum::GL_BUMP_TARGET_ATI, "GL_BUMP_TARGET_ATI" },
    { GLenum::GL_VERTEX_SHADER_EXT, "GL_VERTEX_SHADER_EXT" },
    { GLenum::GL_VERTEX_SHADER_BINDING_EXT, "GL_VERTEX_SHADER_BINDING_EXT" },
    { GLenum::GL_OP_INDEX_EXT, "GL_OP_INDEX_EXT" },
    { GLenum::GL_OP_NEGATE_EXT, "GL_OP_NEGATE_EXT" },
    { GLenum::GL_OP_DOT3_EXT, "GL_OP_DOT3_EXT" },
    { GLenum::GL_OP_DOT4_EXT, "GL_OP_DOT4_EXT" },
    { GLenum::GL_OP_MUL_EXT, "GL_OP_MUL_EXT" },
    { GLenum::GL_OP_ADD_EXT, "GL_OP_ADD_EXT" },
    { GLenum::GL_OP_MADD_EXT, "GL_OP_MADD_EXT" },
    { GLenum::GL_OP_FRAC_EXT, "GL_OP_FRAC_EXT" },
    { GLenum::GL_OP_MAX_EXT, "GL_OP_MAX_EXT" },
    { GLenum::GL_OP_MIN_EXT, "GL_OP_MIN_EXT" },
    { GLenum::GL_OP_SET_GE_EXT, "GL_OP_SET_GE_EXT" },
    { GLenum::GL_OP_SET_LT_EXT, "GL_OP_SET_LT_EXT" },
    { GLenum::GL_OP_CLAMP_EXT, "GL_OP_CLAMP_EXT" },
    { GLenum::GL_OP_FLOOR_EXT, "GL_OP_FLOOR_EXT" },
    { GLenum::GL_OP_ROUND_EXT, "GL_OP_ROUND_EXT" },
    { GLenum::GL_OP_EXP_BASE_2_EXT, "GL_OP_EXP_BASE_2_EXT" },
    { GLenum::GL_OP_LOG_BASE_2_EXT, "GL_OP_LOG_BASE_2_EXT" },
    { GLenum::GL_OP_POWER_EXT, "GL_OP_POWER_EXT" },
    { GLenum::GL_OP_RECIP_EXT, "GL_OP_RECIP_EXT" },
    { GLenum::GL_OP_RECIP_SQRT_EXT, "GL_OP_RECIP_SQRT_EXT" },
    { GLenum::GL_OP_SUB_EXT, "GL_OP_SUB_EXT" },
    { GLenum::GL_OP_CROSS_PRODUCT_EXT, "GL_OP_CROSS_PRODUCT_EXT" },
    { GLenum::GL_OP_MULTIPLY_MATRIX_EXT, "GL_OP_MULTIPLY_MATRIX_EXT" },
    { GLenum::GL_OP_MOV_EXT, "GL_OP_MOV_EXT" },
    { GLenum::GL_OUTPUT_VERTEX_EXT, "GL_OUTPUT_VERTEX_EXT" },
    { GLenum::GL_OUTPUT_COLOR0_EXT, "GL_OUTPUT_COLOR0_EXT" },
    { GLenum::GL_OUTPUT_COLOR1_EXT, "GL_OUTPUT_COLOR1_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD0_EXT, "GL_OUTPUT_TEXTURE_COORD0_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD1_EXT, "GL_OUTPUT_TEXTURE_COORD1_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD2_EXT, "GL_OUTPUT_TEXTURE_COORD2_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD3_EXT, "GL_OUTPUT_TEXTURE_COORD3_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD4_EXT, "GL_OUTPUT_TEXTURE_COORD4_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD5_EXT, "GL_OUTPUT_TEXTURE_COORD5_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD6_EXT, "GL_OUTPUT_TEXTURE_COORD6_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD7_EXT, "GL_OUTPUT_TEXTURE_COORD7_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD8_EXT, "GL_OUTPUT_TEXTURE_COORD8_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD9_EXT, "GL_OUTPUT_TEXTURE_COORD9_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD10_EXT, "GL_OUTPUT_TEXTURE_COORD10_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD11_EXT, "GL_OUTPUT_TEXTURE_COORD11_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD12_EXT, "GL_OUTPUT_TEXTURE_COORD12_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD13_EXT, "GL_OUTPUT_TEXTURE_COORD13_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD14_EXT, "GL_OUTPUT_TEXTURE_COORD14_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD15_EXT, "GL_OUTPUT_TEXTURE_COORD15_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD16_EXT, "GL_OUTPUT_TEXTURE_COORD16_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD17_EXT, "GL_OUTPUT_TEXTURE_COORD17_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD18_EXT, "GL_OUTPUT_TEXTURE_COORD18_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD19_EXT, "GL_OUTPUT_TEXTURE_COORD19_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD20_EXT, "GL_OUTPUT_TEXTURE_COORD20_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD21_EXT, "GL_OUTPUT_TEXTURE_COORD21_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD22_EXT, "GL_OUTPUT_TEXTURE_COORD22_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD23_EXT, "GL_OUTPUT_TEXTURE_COORD23_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD24_EXT, "GL_OUTPUT_TEXTURE_COORD24_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD25_EXT, "GL_OUTPUT_TEXTURE_COORD25_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD26_EXT, "GL_OUTPUT_TEXTURE_COORD26_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD27_EXT, "GL_OUTPUT_TEXTURE_COORD27_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD28_EXT, "GL_OUTPUT_TEXTURE_COORD28_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD29_EXT, "GL_OUTPUT_TEXTURE_COORD29_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD30_EXT, "GL_OUTPUT_TEXTURE_COORD30_EXT" },
    { GLenum::GL_OUTPUT_TEXTURE_COORD31_EXT, "GL_OUTPUT_TEXTURE_COORD31_EXT" },
    { GLenum::GL_OUTPUT_FOG_EXT, "GL_OUTPUT_FOG_EXT" },
    { GLenum::GL_SCALAR_EXT, "GL_SCALAR_EXT" },
    { GLenum::GL_VECTOR_EXT, "GL_VECTOR_EXT" },
    { GLenum::GL_MATRIX_EXT, "GL_MATRIX_EXT" },
    { GLenum::GL_VARIANT_EXT, "GL_VARIANT_EXT" },
    { GLenum::GL_INVARIANT_EXT, "GL_INVARIANT_EXT" },
    { GLenum::GL_LOCAL_CONSTANT_EXT, "GL_LOCAL_CONSTANT_EXT" },
    { GLenum::GL_LOCAL_EXT, "GL_LOCAL_EXT" },
    { GLenum::GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT" },
    { GLenum::GL_MAX_VERTEX_SHADER_VARIANTS_EXT, "GL_MAX_VERTEX_SHADER_VARIANTS_EXT" },
    { GLenum::GL_MAX_VERTEX_SHADER_INVARIANTS_EXT, "GL_MAX_VERTEX_SHADER_INVARIANTS_EXT" },
    { GLenum::GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" },
    { GLenum::GL_MAX_VERTEX_SHADER_LOCALS_EXT, "GL_MAX_VERTEX_SHADER_LOCALS_EXT" },
    { GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT" },
    { GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT" },
    { GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" },
    { GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT" },
    { GLenum::GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT, "GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT" },
    { GLenum::GL_VERTEX_SHADER_INSTRUCTIONS_EXT, "GL_VERTEX_SHADER_INSTRUCTIONS_EXT" },
    { GLenum::GL_VERTEX_SHADER_VARIANTS_EXT, "GL_VERTEX_SHADER_VARIANTS_EXT" },
    { GLenum::GL_VERTEX_SHADER_INVARIANTS_EXT, "GL_VERTEX_SHADER_INVARIANTS_EXT" },
    { GLenum::GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT, "GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT" },
    { GLenum::GL_VERTEX_SHADER_LOCALS_EXT, "GL_VERTEX_SHADER_LOCALS_EXT" },
    { GLenum::GL_VERTEX_SHADER_OPTIMIZED_EXT, "GL_VERTEX_SHADER_OPTIMIZED_EXT" },
    { GLenum::GL_X_EXT, "GL_X_EXT" },
    { GLenum::GL_Y_EXT, "GL_Y_EXT" },
    { GLenum::GL_Z_EXT, "GL_Z_EXT" },
    { GLenum::GL_W_EXT, "GL_W_EXT" },
    { GLenum::GL_NEGATIVE_X_EXT, "GL_NEGATIVE_X_EXT" },
    { GLenum::GL_NEGATIVE_Y_EXT, "GL_NEGATIVE_Y_EXT" },
    { GLenum::GL_NEGATIVE_Z_EXT, "GL_NEGATIVE_Z_EXT" },
    { GLenum::GL_NEGATIVE_W_EXT, "GL_NEGATIVE_W_EXT" },
    { GLenum::GL_ZERO_EXT, "GL_ZERO_EXT" },
    { GLenum::GL_ONE_EXT, "GL_ONE_EXT" },
    { GLenum::GL_NEGATIVE_ONE_EXT, "GL_NEGATIVE_ONE_EXT" },
    { GLenum::GL_NORMALIZED_RANGE_EXT, "GL_NORMALIZED_RANGE_EXT" },
    { GLenum::GL_FULL_RANGE_EXT, "GL_FULL_RANGE_EXT" },
    { GLenum::GL_CURRENT_VERTEX_EXT, "GL_CURRENT_VERTEX_EXT" },
    { GLenum::GL_MVP_MATRIX_EXT, "GL_MVP_MATRIX_EXT" },
    { GLenum::GL_VARIANT_VALUE_EXT, "GL_VARIANT_VALUE_EXT" },
    { GLenum::GL_VARIANT_DATATYPE_EXT, "GL_VARIANT_DATATYPE_EXT" },
    { GLenum::GL_VARIANT_ARRAY_STRIDE_EXT, "GL_VARIANT_ARRAY_STRIDE_EXT" },
    { GLenum::GL_VARIANT_ARRAY_TYPE_EXT, "GL_VARIANT_ARRAY_TYPE_EXT" },
    { GLenum::GL_VARIANT_ARRAY_EXT, "GL_VARIANT_ARRAY_EXT" },
    { GLenum::GL_VARIANT_ARRAY_POINTER_EXT, "GL_VARIANT_ARRAY_POINTER_EXT" },
    { GLenum::GL_INVARIANT_VALUE_EXT, "GL_INVARIANT_VALUE_EXT" },
    { GLenum::GL_INVARIANT_DATATYPE_EXT, "GL_INVARIANT_DATATYPE_EXT" },
    { GLenum::GL_LOCAL_CONSTANT_VALUE_EXT, "GL_LOCAL_CONSTANT_VALUE_EXT" },
    { GLenum::GL_LOCAL_CONSTANT_DATATYPE_EXT, "GL_LOCAL_CONSTANT_DATATYPE_EXT" },
    { GLenum::GL_PN_TRIANGLES_ATI, "GL_PN_TRIANGLES_ATI" },
    { GLenum::GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI, "GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI" },
    { GLenum::GL_PN_TRIANGLES_POINT_MODE_ATI, "GL_PN_TRIANGLES_POINT_MODE_ATI" },
    { GLenum::GL_PN_TRIANGLES_NORMAL_MODE_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_ATI" },
    { GLenum::GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI, "GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI" },
    { GLenum::GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI, "GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI" },
    { GLenum::GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI, "GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI" },
    { GLenum::GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI" },
    { GLenum::GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI, "GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI" },
    { GLenum::GL_VBO_FREE_MEMORY_ATI, "GL_VBO_FREE_MEMORY_ATI" },
    { GLenum::GL_TEXTURE_FREE_MEMORY_ATI, "GL_TEXTURE_FREE_MEMORY_ATI" },
    { GLenum::GL_RENDERBUFFER_FREE_MEMORY_ATI, "GL_RENDERBUFFER_FREE_MEMORY_ATI" },
    { GLenum::GL_NUM_PROGRAM_BINARY_FORMATS, "GL_NUM_PROGRAM_BINARY_FORMATS" },
    { GLenum::GL_PROGRAM_BINARY_FORMATS, "GL_PROGRAM_BINARY_FORMATS" },
    { GLenum::GL_STENCIL_BACK_FUNC, "GL_STENCIL_BACK_FUNC" },
    { GLenum::GL_STENCIL_BACK_FAIL, "GL_STENCIL_BACK_FAIL" },
    { GLenum::GL_STENCIL_BACK_PASS_DEPTH_FAIL, "GL_STENCIL_BACK_PASS_DEPTH_FAIL" },
    { GLenum::GL_STENCIL_BACK_PASS_DEPTH_PASS, "GL_STENCIL_BACK_PASS_DEPTH_PASS" },
    { GLenum::GL_FRAGMENT_PROGRAM_ARB, "GL_FRAGMENT_PROGRAM_ARB" },
    { GLenum::GL_PROGRAM_ALU_INSTRUCTIONS_ARB, "GL_PROGRAM_ALU_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_TEX_INSTRUCTIONS_ARB, "GL_PROGRAM_TEX_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_TEX_INDIRECTIONS_ARB, "GL_PROGRAM_TEX_INDIRECTIONS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, "GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB, "GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB" },
    { GLenum::GL_RGBA32F, "GL_RGBA32F" },
    { GLenum::GL_RGB32F, "GL_RGB32F" },
    { GLenum::GL_ALPHA_FLOAT32_APPLE, "GL_ALPHA_FLOAT32_APPLE" },
    { GLenum::GL_INTENSITY_FLOAT32_APPLE, "GL_INTENSITY_FLOAT32_APPLE" },
    { GLenum::GL_LUMINANCE_FLOAT32_APPLE, "GL_LUMINANCE_FLOAT32_APPLE" },
    { GLenum::GL_LUMINANCE_ALPHA_FLOAT32_APPLE, "GL_LUMINANCE_ALPHA_FLOAT32_APPLE" },
    { GLenum::GL_RGBA16F, "GL_RGBA16F" },
    { GLenum::GL_RGB16F, "GL_RGB16F" },
    { GLenum::GL_ALPHA_FLOAT16_APPLE, "GL_ALPHA_FLOAT16_APPLE" },
    { GLenum::GL_INTENSITY_FLOAT16_APPLE, "GL_INTENSITY_FLOAT16_APPLE" },
    { GLenum::GL_LUMINANCE_FLOAT16_APPLE, "GL_LUMINANCE_FLOAT16_APPLE" },
    { GLenum::GL_LUMINANCE_ALPHA_FLOAT16_APPLE, "GL_LUMINANCE_ALPHA_FLOAT16_APPLE" },
    { GLenum::GL_RGBA_FLOAT_MODE_ARB, "GL_RGBA_FLOAT_MODE_ARB" },
    { GLenum::GL_MAX_DRAW_BUFFERS, "GL_MAX_DRAW_BUFFERS" },
    { GLenum::GL_DRAW_BUFFER0, "GL_DRAW_BUFFER0" },
    { GLenum::GL_DRAW_BUFFER1, "GL_DRAW_BUFFER1" },
    { GLenum::GL_DRAW_BUFFER2, "GL_DRAW_BUFFER2" },
    { GLenum::GL_DRAW_BUFFER3, "GL_DRAW_BUFFER3" },
    { GLenum::GL_DRAW_BUFFER4, "GL_DRAW_BUFFER4" },
    { GLenum::GL_DRAW_BUFFER5, "GL_DRAW_BUFFER5" },
    { GLenum::GL_DRAW_BUFFER6, "GL_DRAW_BUFFER6" },
    { GLenum::GL_DRAW_BUFFER7, "GL_DRAW_BUFFER7" },
    { GLenum::GL_DRAW_BUFFER8, "GL_DRAW_BUFFER8" },
    { GLenum::GL_DRAW_BUFFER9, "GL_DRAW_BUFFER9" },
    { GLenum::GL_DRAW_BUFFER10, "GL_DRAW_BUFFER10" },
    { GLenum::GL_DRAW_BUFFER11, "GL_DRAW_BUFFER11" },
    { GLenum::GL_DRAW_BUFFER12, "GL_DRAW_BUFFER12" },
    { GLenum::GL_DRAW_BUFFER13, "GL_DRAW_BUFFER13" },
    { GLenum::GL_DRAW_BUFFER14, "GL_DRAW_BUFFER14" },
    { GLenum::GL_DRAW_BUFFER15, "GL_DRAW_BUFFER15" },
    { GLenum::GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI, "GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI" },
    { GLenum::GL_BLEND_EQUATION_ALPHA, "GL_BLEND_EQUATION_ALPHA" },
    { GLenum::GL_SUBSAMPLE_DISTANCE_AMD, "GL_SUBSAMPLE_DISTANCE_AMD" },
    { GLenum::GL_MATRIX_PALETTE_ARB, "GL_MATRIX_PALETTE_ARB" },
    { GLenum::GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB, "GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB" },
    { GLenum::GL_MAX_PALETTE_MATRICES_ARB, "GL_MAX_PALETTE_MATRICES_ARB" },
    { GLenum::GL_CURRENT_PALETTE_MATRIX_ARB, "GL_CURRENT_PALETTE_MATRIX_ARB" },
    { GLenum::GL_MATRIX_INDEX_ARRAY_ARB, "GL_MATRIX_INDEX_ARRAY_ARB" },
    { GLenum::GL_CURRENT_MATRIX_INDEX_ARB, "GL_CURRENT_MATRIX_INDEX_ARB" },
    { GLenum::GL_MATRIX_INDEX_ARRAY_SIZE_ARB, "GL_MATRIX_INDEX_ARRAY_SIZE_ARB" },
    { GLenum::GL_MATRIX_INDEX_ARRAY_TYPE_ARB, "GL_MATRIX_INDEX_ARRAY_TYPE_ARB" },
    { GLenum::GL_MATRIX_INDEX_ARRAY_STRIDE_ARB, "GL_MATRIX_INDEX_ARRAY_STRIDE_ARB" },
    { GLenum::GL_MATRIX_INDEX_ARRAY_POINTER_ARB, "GL_MATRIX_INDEX_ARRAY_POINTER_ARB" },
    { GLenum::GL_TEXTURE_DEPTH_SIZE, "GL_TEXTURE_DEPTH_SIZE" },
    { GLenum::GL_DEPTH_TEXTURE_MODE, "GL_DEPTH_TEXTURE_MODE" },
    { GLenum::GL_TEXTURE_COMPARE_MODE, "GL_TEXTURE_COMPARE_MODE" },
    { GLenum::GL_TEXTURE_COMPARE_FUNC, "GL_TEXTURE_COMPARE_FUNC" },
    { GLenum::GL_COMPARE_REF_TO_TEXTURE, "GL_COMPARE_REF_TO_TEXTURE" },
    { GLenum::GL_TEXTURE_CUBE_MAP_SEAMLESS, "GL_TEXTURE_CUBE_MAP_SEAMLESS" },
    { GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV" },
    { GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV" },
    { GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV" },
    { GLenum::GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV, "GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV" },
    { GLenum::GL_OFFSET_HILO_TEXTURE_2D_NV, "GL_OFFSET_HILO_TEXTURE_2D_NV" },
    { GLenum::GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV, "GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV" },
    { GLenum::GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV" },
    { GLenum::GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV, "GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV" },
    { GLenum::GL_DEPENDENT_HILO_TEXTURE_2D_NV, "GL_DEPENDENT_HILO_TEXTURE_2D_NV" },
    { GLenum::GL_DEPENDENT_RGB_TEXTURE_3D_NV, "GL_DEPENDENT_RGB_TEXTURE_3D_NV" },
    { GLenum::GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV, "GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV" },
    { GLenum::GL_DOT_PRODUCT_PASS_THROUGH_NV, "GL_DOT_PRODUCT_PASS_THROUGH_NV" },
    { GLenum::GL_DOT_PRODUCT_TEXTURE_1D_NV, "GL_DOT_PRODUCT_TEXTURE_1D_NV" },
    { GLenum::GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV, "GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV" },
    { GLenum::GL_HILO8_NV, "GL_HILO8_NV" },
    { GLenum::GL_SIGNED_HILO8_NV, "GL_SIGNED_HILO8_NV" },
    { GLenum::GL_FORCE_BLUE_TO_ONE_NV, "GL_FORCE_BLUE_TO_ONE_NV" },
    { GLenum::GL_POINT_SPRITE, "GL_POINT_SPRITE" },
    { GLenum::GL_COORD_REPLACE, "GL_COORD_REPLACE" },
    { GLenum::GL_POINT_SPRITE_R_MODE_NV, "GL_POINT_SPRITE_R_MODE_NV" },
    { GLenum::GL_QUERY_COUNTER_BITS, "GL_QUERY_COUNTER_BITS" },
    { GLenum::GL_CURRENT_QUERY, "GL_CURRENT_QUERY" },
    { GLenum::GL_QUERY_RESULT, "GL_QUERY_RESULT" },
    { GLenum::GL_QUERY_RESULT_AVAILABLE, "GL_QUERY_RESULT_AVAILABLE" },
    { GLenum::GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV, "GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV" },
    { GLenum::GL_MAX_VERTEX_ATTRIBS, "GL_MAX_VERTEX_ATTRIBS" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_NORMALIZED, "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED" },
    { GLenum::GL_MAX_TESS_CONTROL_INPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS" },
    { GLenum::GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS, "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS" },
    { GLenum::GL_DEPTH_STENCIL_TO_RGBA_NV, "GL_DEPTH_STENCIL_TO_RGBA_NV" },
    { GLenum::GL_DEPTH_STENCIL_TO_BGRA_NV, "GL_DEPTH_STENCIL_TO_BGRA_NV" },
    { GLenum::GL_FRAGMENT_PROGRAM_NV, "GL_FRAGMENT_PROGRAM_NV" },
    { GLenum::GL_MAX_TEXTURE_COORDS, "GL_MAX_TEXTURE_COORDS" },
    { GLenum::GL_MAX_TEXTURE_IMAGE_UNITS, "GL_MAX_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_FRAGMENT_PROGRAM_BINDING_NV, "GL_FRAGMENT_PROGRAM_BINDING_NV" },
    { GLenum::GL_PROGRAM_ERROR_STRING_ARB, "GL_PROGRAM_ERROR_STRING_ARB" },
    { GLenum::GL_PROGRAM_FORMAT_ASCII_ARB, "GL_PROGRAM_FORMAT_ASCII_ARB" },
    { GLenum::GL_PROGRAM_FORMAT_ARB, "GL_PROGRAM_FORMAT_ARB" },
    { GLenum::GL_WRITE_PIXEL_DATA_RANGE_NV, "GL_WRITE_PIXEL_DATA_RANGE_NV" },
    { GLenum::GL_READ_PIXEL_DATA_RANGE_NV, "GL_READ_PIXEL_DATA_RANGE_NV" },
    { GLenum::GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV, "GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV" },
    { GLenum::GL_READ_PIXEL_DATA_RANGE_LENGTH_NV, "GL_READ_PIXEL_DATA_RANGE_LENGTH_NV" },
    { GLenum::GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV, "GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV" },
    { GLenum::GL_READ_PIXEL_DATA_RANGE_POINTER_NV, "GL_READ_PIXEL_DATA_RANGE_POINTER_NV" },
    { GLenum::GL_GEOMETRY_SHADER_INVOCATIONS, "GL_GEOMETRY_SHADER_INVOCATIONS" },
    { GLenum::GL_FLOAT_R_NV, "GL_FLOAT_R_NV" },
    { GLenum::GL_FLOAT_RG_NV, "GL_FLOAT_RG_NV" },
    { GLenum::GL_FLOAT_RGB_NV, "GL_FLOAT_RGB_NV" },
    { GLenum::GL_FLOAT_RGBA_NV, "GL_FLOAT_RGBA_NV" },
    { GLenum::GL_FLOAT_R16_NV, "GL_FLOAT_R16_NV" },
    { GLenum::GL_FLOAT_R32_NV, "GL_FLOAT_R32_NV" },
    { GLenum::GL_FLOAT_RG16_NV, "GL_FLOAT_RG16_NV" },
    { GLenum::GL_FLOAT_RG32_NV, "GL_FLOAT_RG32_NV" },
    { GLenum::GL_FLOAT_RGB16_NV, "GL_FLOAT_RGB16_NV" },
    { GLenum::GL_FLOAT_RGB32_NV, "GL_FLOAT_RGB32_NV" },
    { GLenum::GL_FLOAT_RGBA16_NV, "GL_FLOAT_RGBA16_NV" },
    { GLenum::GL_FLOAT_RGBA32_NV, "GL_FLOAT_RGBA32_NV" },
    { GLenum::GL_TEXTURE_FLOAT_COMPONENTS_NV, "GL_TEXTURE_FLOAT_COMPONENTS_NV" },
    { GLenum::GL_FLOAT_CLEAR_COLOR_VALUE_NV, "GL_FLOAT_CLEAR_COLOR_VALUE_NV" },
    { GLenum::GL_FLOAT_RGBA_MODE_NV, "GL_FLOAT_RGBA_MODE_NV" },
    { GLenum::GL_TEXTURE_UNSIGNED_REMAP_MODE_NV, "GL_TEXTURE_UNSIGNED_REMAP_MODE_NV" },
    { GLenum::GL_DEPTH_BOUNDS_TEST_EXT, "GL_DEPTH_BOUNDS_TEST_EXT" },
    { GLenum::GL_DEPTH_BOUNDS_EXT, "GL_DEPTH_BOUNDS_EXT" },
    { GLenum::GL_ARRAY_BUFFER, "GL_ARRAY_BUFFER" },
    { GLenum::GL_ELEMENT_ARRAY_BUFFER, "GL_ELEMENT_ARRAY_BUFFER" },
    { GLenum::GL_ARRAY_BUFFER_BINDING, "GL_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_ELEMENT_ARRAY_BUFFER_BINDING, "GL_ELEMENT_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_VERTEX_ARRAY_BUFFER_BINDING, "GL_VERTEX_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_NORMAL_ARRAY_BUFFER_BINDING, "GL_NORMAL_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_COLOR_ARRAY_BUFFER_BINDING, "GL_COLOR_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_INDEX_ARRAY_BUFFER_BINDING, "GL_INDEX_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING, "GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_EDGE_FLAG_ARRAY_BUFFER_BINDING, "GL_EDGE_FLAG_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING, "GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING, "GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_WEIGHT_ARRAY_BUFFER_BINDING, "GL_WEIGHT_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING, "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING" },
    { GLenum::GL_PROGRAM_INSTRUCTIONS_ARB, "GL_PROGRAM_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB, "GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB, "GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB" },
    { GLenum::GL_PROGRAM_TEMPORARIES_ARB, "GL_PROGRAM_TEMPORARIES_ARB" },
    { GLenum::GL_MAX_PROGRAM_TEMPORARIES_ARB, "GL_MAX_PROGRAM_TEMPORARIES_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_TEMPORARIES_ARB, "GL_PROGRAM_NATIVE_TEMPORARIES_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB, "GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB" },
    { GLenum::GL_PROGRAM_PARAMETERS_ARB, "GL_PROGRAM_PARAMETERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_PARAMETERS_ARB, "GL_MAX_PROGRAM_PARAMETERS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_PARAMETERS_ARB, "GL_PROGRAM_NATIVE_PARAMETERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB, "GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB" },
    { GLenum::GL_PROGRAM_ATTRIBS_ARB, "GL_PROGRAM_ATTRIBS_ARB" },
    { GLenum::GL_MAX_PROGRAM_ATTRIBS_ARB, "GL_MAX_PROGRAM_ATTRIBS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_ATTRIBS_ARB, "GL_PROGRAM_NATIVE_ATTRIBS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB, "GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB" },
    { GLenum::GL_PROGRAM_ADDRESS_REGISTERS_ARB, "GL_PROGRAM_ADDRESS_REGISTERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB, "GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB" },
    { GLenum::GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, "GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB, "GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB, "GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB" },
    { GLenum::GL_MAX_PROGRAM_ENV_PARAMETERS_ARB, "GL_MAX_PROGRAM_ENV_PARAMETERS_ARB" },
    { GLenum::GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB, "GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB" },
    { GLenum::GL_TRANSPOSE_CURRENT_MATRIX_ARB, "GL_TRANSPOSE_CURRENT_MATRIX_ARB" },
    { GLenum::GL_READ_ONLY, "GL_READ_ONLY" },
    { GLenum::GL_WRITE_ONLY, "GL_WRITE_ONLY" },
    { GLenum::GL_READ_WRITE, "GL_READ_WRITE" },
    { GLenum::GL_BUFFER_ACCESS, "GL_BUFFER_ACCESS" },
    { GLenum::GL_BUFFER_MAPPED, "GL_BUFFER_MAPPED" },
    { GLenum::GL_BUFFER_MAP_POINTER, "GL_BUFFER_MAP_POINTER" },
    { GLenum::GL_WRITE_DISCARD_NV, "GL_WRITE_DISCARD_NV" },
    { GLenum::GL_TIME_ELAPSED, "GL_TIME_ELAPSED" },
    { GLenum::GL_MATRIX0_ARB, "GL_MATRIX0_ARB" },
    { GLenum::GL_MATRIX1_ARB, "GL_MATRIX1_ARB" },
    { GLenum::GL_MATRIX2_ARB, "GL_MATRIX2_ARB" },
    { GLenum::GL_MATRIX3_ARB, "GL_MATRIX3_ARB" },
    { GLenum::GL_MATRIX4_ARB, "GL_MATRIX4_ARB" },
    { GLenum::GL_MATRIX5_ARB, "GL_MATRIX5_ARB" },
    { GLenum::GL_MATRIX6_ARB, "GL_MATRIX6_ARB" },
    { GLenum::GL_MATRIX7_ARB, "GL_MATRIX7_ARB" },
    { GLenum::GL_MATRIX8_ARB, "GL_MATRIX8_ARB" },
    { GLenum::GL_MATRIX9_ARB, "GL_MATRIX9_ARB" },
    { GLenum::GL_MATRIX10_ARB, "GL_MATRIX10_ARB" },
    { GLenum::GL_MATRIX11_ARB, "GL_MATRIX11_ARB" },
    { GLenum::GL_MATRIX12_ARB, "GL_MATRIX12_ARB" },
    { GLenum::GL_MATRIX13_ARB, "GL_MATRIX13_ARB" },
    { GLenum::GL_MATRIX14_ARB, "GL_MATRIX14_ARB" },
    { GLenum::GL_MATRIX15_ARB, "GL_MATRIX15_ARB" },
    { GLenum::GL_MATRIX16_ARB, "GL_MATRIX16_ARB" },
    { GLenum::GL_MATRIX17_ARB, "GL_MATRIX17_ARB" },
    { GLenum::GL_MATRIX18_ARB, "GL_MATRIX18_ARB" },
    { GLenum::GL_MATRIX19_ARB, "GL_MATRIX19_ARB" },
    { GLenum::GL_MATRIX20_ARB, "GL_MATRIX20_ARB" },
    { GLenum::GL_MATRIX21_ARB, "GL_MATRIX21_ARB" },
    { GLenum::GL_MATRIX22_ARB, "GL_MATRIX22_ARB" },
    { GLenum::GL_MATRIX23_ARB, "GL_MATRIX23_ARB" },
    { GLenum::GL_MATRIX24_ARB, "GL_MATRIX24_ARB" },
    { GLenum::GL_MATRIX25_ARB, "GL_MATRIX25_ARB" },
    { GLenum::GL_MATRIX26_ARB, "GL_MATRIX26_ARB" },
    { GLenum::GL_MATRIX27_ARB, "GL_MATRIX27_ARB" },
    { GLenum::GL_MATRIX28_ARB, "GL_MATRIX28_ARB" },
    { GLenum::GL_MATRIX29_ARB, "GL_MATRIX29_ARB" },
    { GLenum::GL_MATRIX30_ARB, "GL_MATRIX30_ARB" },
    { GLenum::GL_MATRIX31_ARB, "GL_MATRIX31_ARB" },
    { GLenum::GL_STREAM_DRAW, "GL_STREAM_DRAW" },
    { GLenum::GL_STREAM_READ, "GL_STREAM_READ" },
    { GLenum::GL_STREAM_COPY, "GL_STREAM_COPY" },
    { GLenum::GL_STATIC_DRAW, "GL_STATIC_DRAW" },
    { GLenum::GL_STATIC_READ, "GL_STATIC_READ" },
    { GLenum::GL_STATIC_COPY, "GL_STATIC_COPY" },
    { GLenum::GL_DYNAMIC_DRAW, "GL_DYNAMIC_DRAW" },
    { GLenum::GL_DYNAMIC_READ, "GL_DYNAMIC_READ" },
    { GLenum::GL_DYNAMIC_COPY, "GL_DYNAMIC_COPY" },
    { GLenum::GL_PIXEL_PACK_BUFFER, "GL_PIXEL_PACK_BUFFER" },
    { GLenum::GL_PIXEL_UNPACK_BUFFER, "GL_PIXEL_UNPACK_BUFFER" },
    { GLenum::GL_PIXEL_PACK_BUFFER_BINDING, "GL_PIXEL_PACK_BUFFER_BINDING" },
    { GLenum::GL_PIXEL_UNPACK_BUFFER_BINDING, "GL_PIXEL_UNPACK_BUFFER_BINDING" },
    { GLenum::GL_DEPTH24_STENCIL8, "GL_DEPTH24_STENCIL8" },
    { GLenum::GL_TEXTURE_STENCIL_SIZE, "GL_TEXTURE_STENCIL_SIZE" },
    { GLenum::GL_STENCIL_TAG_BITS_EXT, "GL_STENCIL_TAG_BITS_EXT" },
    { GLenum::GL_STENCIL_CLEAR_TAG_VALUE_EXT, "GL_STENCIL_CLEAR_TAG_VALUE_EXT" },
    { GLenum::GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV, "GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV" },
    { GLenum::GL_MAX_PROGRAM_CALL_DEPTH_NV, "GL_MAX_PROGRAM_CALL_DEPTH_NV" },
    { GLenum::GL_MAX_PROGRAM_IF_DEPTH_NV, "GL_MAX_PROGRAM_IF_DEPTH_NV" },
    { GLenum::GL_MAX_PROGRAM_LOOP_DEPTH_NV, "GL_MAX_PROGRAM_LOOP_DEPTH_NV" },
    { GLenum::GL_MAX_PROGRAM_LOOP_COUNT_NV, "GL_MAX_PROGRAM_LOOP_COUNT_NV" },
    { GLenum::GL_SRC1_COLOR, "GL_SRC1_COLOR" },
    { GLenum::GL_ONE_MINUS_SRC1_COLOR, "GL_ONE_MINUS_SRC1_COLOR" },
    { GLenum::GL_ONE_MINUS_SRC1_ALPHA, "GL_ONE_MINUS_SRC1_ALPHA" },
    { GLenum::GL_MAX_DUAL_SOURCE_DRAW_BUFFERS, "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_INTEGER, "GL_VERTEX_ATTRIB_ARRAY_INTEGER" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_DIVISOR, "GL_VERTEX_ATTRIB_ARRAY_DIVISOR" },
    { GLenum::GL_MAX_ARRAY_TEXTURE_LAYERS, "GL_MAX_ARRAY_TEXTURE_LAYERS" },
    { GLenum::GL_MIN_PROGRAM_TEXEL_OFFSET, "GL_MIN_PROGRAM_TEXEL_OFFSET" },
    { GLenum::GL_MAX_PROGRAM_TEXEL_OFFSET, "GL_MAX_PROGRAM_TEXEL_OFFSET" },
    { GLenum::GL_PROGRAM_ATTRIB_COMPONENTS_NV, "GL_PROGRAM_ATTRIB_COMPONENTS_NV" },
    { GLenum::GL_PROGRAM_RESULT_COMPONENTS_NV, "GL_PROGRAM_RESULT_COMPONENTS_NV" },
    { GLenum::GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV, "GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV" },
    { GLenum::GL_MAX_PROGRAM_RESULT_COMPONENTS_NV, "GL_MAX_PROGRAM_RESULT_COMPONENTS_NV" },
    { GLenum::GL_STENCIL_TEST_TWO_SIDE_EXT, "GL_STENCIL_TEST_TWO_SIDE_EXT" },
    { GLenum::GL_ACTIVE_STENCIL_FACE_EXT, "GL_ACTIVE_STENCIL_FACE_EXT" },
    { GLenum::GL_MIRROR_CLAMP_TO_BORDER_EXT, "GL_MIRROR_CLAMP_TO_BORDER_EXT" },
    { GLenum::GL_SAMPLES_PASSED, "GL_SAMPLES_PASSED" },
    { GLenum::GL_GEOMETRY_VERTICES_OUT, "GL_GEOMETRY_VERTICES_OUT" },
    { GLenum::GL_GEOMETRY_INPUT_TYPE, "GL_GEOMETRY_INPUT_TYPE" },
    { GLenum::GL_GEOMETRY_OUTPUT_TYPE, "GL_GEOMETRY_OUTPUT_TYPE" },
    { GLenum::GL_SAMPLER_BINDING, "GL_SAMPLER_BINDING" },
    { GLenum::GL_CLAMP_VERTEX_COLOR, "GL_CLAMP_VERTEX_COLOR" },
    { GLenum::GL_CLAMP_FRAGMENT_COLOR, "GL_CLAMP_FRAGMENT_COLOR" },
    { GLenum::GL_CLAMP_READ_COLOR, "GL_CLAMP_READ_COLOR" },
    { GLenum::GL_FIXED_ONLY, "GL_FIXED_ONLY" },
    { GLenum::GL_TESS_CONTROL_PROGRAM_NV, "GL_TESS_CONTROL_PROGRAM_NV" },
    { GLenum::GL_TESS_EVALUATION_PROGRAM_NV, "GL_TESS_EVALUATION_PROGRAM_NV" },
    { GLenum::GL_FRAGMENT_SHADER_ATI, "GL_FRAGMENT_SHADER_ATI" },
    { GLenum::GL_REG_0_ATI, "GL_REG_0_ATI" },
    { GLenum::GL_REG_1_ATI, "GL_REG_1_ATI" },
    { GLenum::GL_REG_2_ATI, "GL_REG_2_ATI" },
    { GLenum::GL_REG_3_ATI, "GL_REG_3_ATI" },
    { GLenum::GL_REG_4_ATI, "GL_REG_4_ATI" },
    { GLenum::GL_REG_5_ATI, "GL_REG_5_ATI" },
    { GLenum::GL_REG_6_ATI, "GL_REG_6_ATI" },
    { GLenum::GL_REG_7_ATI, "GL_REG_7_ATI" },
    { GLenum::GL_REG_8_ATI, "GL_REG_8_ATI" },
    { GLenum::GL_REG_9_ATI, "GL_REG_9_ATI" },
    { GLenum::GL_REG_10_ATI, "GL_REG_10_ATI" },
    { GLenum::GL_REG_11_ATI, "GL_REG_11_ATI" },
    { GLenum::GL_REG_12_ATI, "GL_REG_12_ATI" },
    { GLenum::GL_REG_13_ATI, "GL_REG_13_ATI" },
    { GLenum::GL_REG_14_ATI, "GL_REG_14_ATI" },
    { GLenum::GL_REG_15_ATI, "GL_REG_15_ATI" },
    { GLenum::GL_REG_16_ATI, "GL_REG_16_ATI" },
    { GLenum::GL_REG_17_ATI, "GL_REG_17_ATI" },
    { GLenum::GL_REG_18_ATI, "GL_REG_18_ATI" },
    { GLenum::GL_REG_19_ATI, "GL_REG_19_ATI" },
    { GLenum::GL_REG_20_ATI, "GL_REG_20_ATI" },
    { GLenum::GL_REG_21_ATI, "GL_REG_21_ATI" },
    { GLenum::GL_REG_22_ATI, "GL_REG_22_ATI" },
    { GLenum::GL_REG_23_ATI, "GL_REG_23_ATI" },
    { GLenum::GL_REG_24_ATI, "GL_REG_24_ATI" },
    { GLenum::GL_REG_25_ATI, "GL_REG_25_ATI" },
    { GLenum::GL_REG_26_ATI, "GL_REG_26_ATI" },
    { GLenum::GL_REG_27_ATI, "GL_REG_27_ATI" },
    { GLenum::GL_REG_28_ATI, "GL_REG_28_ATI" },
    { GLenum::GL_REG_29_ATI, "GL_REG_29_ATI" },
    { GLenum::GL_REG_30_ATI, "GL_REG_30_ATI" },
    { GLenum::GL_REG_31_ATI, "GL_REG_31_ATI" },
    { GLenum::GL_CON_0_ATI, "GL_CON_0_ATI" },
    { GLenum::GL_CON_1_ATI, "GL_CON_1_ATI" },
    { GLenum::GL_CON_2_ATI, "GL_CON_2_ATI" },
    { GLenum::GL_CON_3_ATI, "GL_CON_3_ATI" },
    { GLenum::GL_CON_4_ATI, "GL_CON_4_ATI" },
    { GLenum::GL_CON_5_ATI, "GL_CON_5_ATI" },
    { GLenum::GL_CON_6_ATI, "GL_CON_6_ATI" },
    { GLenum::GL_CON_7_ATI, "GL_CON_7_ATI" },
    { GLenum::GL_CON_8_ATI, "GL_CON_8_ATI" },
    { GLenum::GL_CON_9_ATI, "GL_CON_9_ATI" },
    { GLenum::GL_CON_10_ATI, "GL_CON_10_ATI" },
    { GLenum::GL_CON_11_ATI, "GL_CON_11_ATI" },
    { GLenum::GL_CON_12_ATI, "GL_CON_12_ATI" },
    { GLenum::GL_CON_13_ATI, "GL_CON_13_ATI" },
    { GLenum::GL_CON_14_ATI, "GL_CON_14_ATI" },
    { GLenum::GL_CON_15_ATI, "GL_CON_15_ATI" },
    { GLenum::GL_CON_16_ATI, "GL_CON_16_ATI" },
    { GLenum::GL_CON_17_ATI, "GL_CON_17_ATI" },
    { GLenum::GL_CON_18_ATI, "GL_CON_18_ATI" },
    { GLenum::GL_CON_19_ATI, "GL_CON_19_ATI" },
    { GLenum::GL_CON_20_ATI, "GL_CON_20_ATI" },
    { GLenum::GL_CON_21_ATI, "GL_CON_21_ATI" },
    { GLenum::GL_CON_22_ATI, "GL_CON_22_ATI" },
    { GLenum::GL_CON_23_ATI, "GL_CON_23_ATI" },
    { GLenum::GL_CON_24_ATI, "GL_CON_24_ATI" },
    { GLenum::GL_CON_25_ATI, "GL_CON_25_ATI" },
    { GLenum::GL_CON_26_ATI, "GL_CON_26_ATI" },
    { GLenum::GL_CON_27_ATI, "GL_CON_27_ATI" },
    { GLenum::GL_CON_28_ATI, "GL_CON_28_ATI" },
    { GLenum::GL_CON_29_ATI, "GL_CON_29_ATI" },
    { GLenum::GL_CON_30_ATI, "GL_CON_30_ATI" },
    { GLenum::GL_CON_31_ATI, "GL_CON_31_ATI" },
    { GLenum::GL_MOV_ATI, "GL_MOV_ATI" },
    { GLenum::GL_ADD_ATI, "GL_ADD_ATI" },
    { GLenum::GL_MUL_ATI, "GL_MUL_ATI" },
    { GLenum::GL_SUB_ATI, "GL_SUB_ATI" },
    { GLenum::GL_DOT3_ATI, "GL_DOT3_ATI" },
    { GLenum::GL_DOT4_ATI, "GL_DOT4_ATI" },
    { GLenum::GL_MAD_ATI, "GL_MAD_ATI" },
    { GLenum::GL_LERP_ATI, "GL_LERP_ATI" },
    { GLenum::GL_CND_ATI, "GL_CND_ATI" },
    { GLenum::GL_CND0_ATI, "GL_CND0_ATI" },
    { GLenum::GL_DOT2_ADD_ATI, "GL_DOT2_ADD_ATI" },
    { GLenum::GL_SECONDARY_INTERPOLATOR_ATI, "GL_SECONDARY_INTERPOLATOR_ATI" },
    { GLenum::GL_NUM_FRAGMENT_REGISTERS_ATI, "GL_NUM_FRAGMENT_REGISTERS_ATI" },
    { GLenum::GL_NUM_FRAGMENT_CONSTANTS_ATI, "GL_NUM_FRAGMENT_CONSTANTS_ATI" },
    { GLenum::GL_NUM_PASSES_ATI, "GL_NUM_PASSES_ATI" },
    { GLenum::GL_NUM_INSTRUCTIONS_PER_PASS_ATI, "GL_NUM_INSTRUCTIONS_PER_PASS_ATI" },
    { GLenum::GL_NUM_INSTRUCTIONS_TOTAL_ATI, "GL_NUM_INSTRUCTIONS_TOTAL_ATI" },
    { GLenum::GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI, "GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI" },
    { GLenum::GL_NUM_LOOPBACK_COMPONENTS_ATI, "GL_NUM_LOOPBACK_COMPONENTS_ATI" },
    { GLenum::GL_COLOR_ALPHA_PAIRING_ATI, "GL_COLOR_ALPHA_PAIRING_ATI" },
    { GLenum::GL_SWIZZLE_STR_ATI, "GL_SWIZZLE_STR_ATI" },
    { GLenum::GL_SWIZZLE_STQ_ATI, "GL_SWIZZLE_STQ_ATI" },
    { GLenum::GL_SWIZZLE_STR_DR_ATI, "GL_SWIZZLE_STR_DR_ATI" },
    { GLenum::GL_SWIZZLE_STQ_DQ_ATI, "GL_SWIZZLE_STQ_DQ_ATI" },
    { GLenum::GL_SWIZZLE_STRQ_ATI, "GL_SWIZZLE_STRQ_ATI" },
    { GLenum::GL_SWIZZLE_STRQ_DQ_ATI, "GL_SWIZZLE_STRQ_DQ_ATI" },
    { GLenum::GL_INTERLACE_OML, "GL_INTERLACE_OML" },
    { GLenum::GL_INTERLACE_READ_OML, "GL_INTERLACE_READ_OML" },
    { GLenum::GL_FORMAT_SUBSAMPLE_24_24_OML, "GL_FORMAT_SUBSAMPLE_24_24_OML" },
    { GLenum::GL_FORMAT_SUBSAMPLE_244_244_OML, "GL_FORMAT_SUBSAMPLE_244_244_OML" },
    { GLenum::GL_PACK_RESAMPLE_OML, "GL_PACK_RESAMPLE_OML" },
    { GLenum::GL_UNPACK_RESAMPLE_OML, "GL_UNPACK_RESAMPLE_OML" },
    { GLenum::GL_RESAMPLE_REPLICATE_OML, "GL_RESAMPLE_REPLICATE_OML" },
    { GLenum::GL_RESAMPLE_ZERO_FILL_OML, "GL_RESAMPLE_ZERO_FILL_OML" },
    { GLenum::GL_RESAMPLE_AVERAGE_OML, "GL_RESAMPLE_AVERAGE_OML" },
    { GLenum::GL_RESAMPLE_DECIMATE_OML, "GL_RESAMPLE_DECIMATE_OML" },
    { GLenum::GL_VERTEX_ATTRIB_MAP1_APPLE, "GL_VERTEX_ATTRIB_MAP1_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP2_APPLE, "GL_VERTEX_ATTRIB_MAP2_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE, "GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE, "GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE, "GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE, "GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE, "GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE, "GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE, "GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE" },
    { GLenum::GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE, "GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE" },
    { GLenum::GL_DRAW_PIXELS_APPLE, "GL_DRAW_PIXELS_APPLE" },
    { GLenum::GL_FENCE_APPLE, "GL_FENCE_APPLE" },
    { GLenum::GL_ELEMENT_ARRAY_APPLE, "GL_ELEMENT_ARRAY_APPLE" },
    { GLenum::GL_ELEMENT_ARRAY_TYPE_APPLE, "GL_ELEMENT_ARRAY_TYPE_APPLE" },
    { GLenum::GL_ELEMENT_ARRAY_POINTER_APPLE, "GL_ELEMENT_ARRAY_POINTER_APPLE" },
    { GLenum::GL_COLOR_FLOAT_APPLE, "GL_COLOR_FLOAT_APPLE" },
    { GLenum::GL_UNIFORM_BUFFER, "GL_UNIFORM_BUFFER" },
    { GLenum::GL_BUFFER_SERIALIZED_MODIFY_APPLE, "GL_BUFFER_SERIALIZED_MODIFY_APPLE" },
    { GLenum::GL_BUFFER_FLUSHING_UNMAP_APPLE, "GL_BUFFER_FLUSHING_UNMAP_APPLE" },
    { GLenum::GL_AUX_DEPTH_STENCIL_APPLE, "GL_AUX_DEPTH_STENCIL_APPLE" },
    { GLenum::GL_PACK_ROW_BYTES_APPLE, "GL_PACK_ROW_BYTES_APPLE" },
    { GLenum::GL_UNPACK_ROW_BYTES_APPLE, "GL_UNPACK_ROW_BYTES_APPLE" },
    { GLenum::GL_RELEASED_APPLE, "GL_RELEASED_APPLE" },
    { GLenum::GL_VOLATILE_APPLE, "GL_VOLATILE_APPLE" },
    { GLenum::GL_RETAINED_APPLE, "GL_RETAINED_APPLE" },
    { GLenum::GL_UNDEFINED_APPLE, "GL_UNDEFINED_APPLE" },
    { GLenum::GL_PURGEABLE_APPLE, "GL_PURGEABLE_APPLE" },
    { GLenum::GL_RGB_422_APPLE, "GL_RGB_422_APPLE" },
    { GLenum::GL_UNIFORM_BUFFER_BINDING, "GL_UNIFORM_BUFFER_BINDING" },
    { GLenum::GL_UNIFORM_BUFFER_START, "GL_UNIFORM_BUFFER_START" },
    { GLenum::GL_UNIFORM_BUFFER_SIZE, "GL_UNIFORM_BUFFER_SIZE" },
    { GLenum::GL_MAX_VERTEX_UNIFORM_BLOCKS, "GL_MAX_VERTEX_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_GEOMETRY_UNIFORM_BLOCKS, "GL_MAX_GEOMETRY_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_FRAGMENT_UNIFORM_BLOCKS, "GL_MAX_FRAGMENT_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_COMBINED_UNIFORM_BLOCKS, "GL_MAX_COMBINED_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_UNIFORM_BUFFER_BINDINGS, "GL_MAX_UNIFORM_BUFFER_BINDINGS" },
    { GLenum::GL_MAX_UNIFORM_BLOCK_SIZE, "GL_MAX_UNIFORM_BLOCK_SIZE" },
    { GLenum::GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS" },
    { GLenum::GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT, "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT" },
    { GLenum::GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH, "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH" },
    { GLenum::GL_ACTIVE_UNIFORM_BLOCKS, "GL_ACTIVE_UNIFORM_BLOCKS" },
    { GLenum::GL_UNIFORM_TYPE, "GL_UNIFORM_TYPE" },
    { GLenum::GL_UNIFORM_SIZE, "GL_UNIFORM_SIZE" },
    { GLenum::GL_UNIFORM_NAME_LENGTH, "GL_UNIFORM_NAME_LENGTH" },
    { GLenum::GL_UNIFORM_BLOCK_INDEX, "GL_UNIFORM_BLOCK_INDEX" },
    { GLenum::GL_UNIFORM_OFFSET, "GL_UNIFORM_OFFSET" },
    { GLenum::GL_UNIFORM_ARRAY_STRIDE, "GL_UNIFORM_ARRAY_STRIDE" },
    { GLenum::GL_UNIFORM_MATRIX_STRIDE, "GL_UNIFORM_MATRIX_STRIDE" },
    { GLenum::GL_UNIFORM_IS_ROW_MAJOR, "GL_UNIFORM_IS_ROW_MAJOR" },
    { GLenum::GL_UNIFORM_BLOCK_BINDING, "GL_UNIFORM_BLOCK_BINDING" },
    { GLenum::GL_UNIFORM_BLOCK_DATA_SIZE, "GL_UNIFORM_BLOCK_DATA_SIZE" },
    { GLenum::GL_UNIFORM_BLOCK_NAME_LENGTH, "GL_UNIFORM_BLOCK_NAME_LENGTH" },
    { GLenum::GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS, "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS" },
    { GLenum::GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES, "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER" },
    { GLenum::GL_TEXTURE_SRGB_DECODE_EXT, "GL_TEXTURE_SRGB_DECODE_EXT" },
    { GLenum::GL_DECODE_EXT, "GL_DECODE_EXT" },
    { GLenum::GL_SKIP_DECODE_EXT, "GL_SKIP_DECODE_EXT" },
    { GLenum::GL_PROGRAM_PIPELINE_OBJECT_EXT, "GL_PROGRAM_PIPELINE_OBJECT_EXT" },
    { GLenum::GL_RGB_RAW_422_APPLE, "GL_RGB_RAW_422_APPLE" },
    { GLenum::GL_FRAGMENT_SHADER, "GL_FRAGMENT_SHADER" },
    { GLenum::GL_VERTEX_SHADER, "GL_VERTEX_SHADER" },
    { GLenum::GL_PROGRAM_OBJECT_ARB, "GL_PROGRAM_OBJECT_ARB" },
    { GLenum::GL_SHADER_OBJECT_ARB, "GL_SHADER_OBJECT_ARB" },
    { GLenum::GL_MAX_FRAGMENT_UNIFORM_COMPONENTS, "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_VERTEX_UNIFORM_COMPONENTS, "GL_MAX_VERTEX_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_VARYING_COMPONENTS, "GL_MAX_VARYING_COMPONENTS" },
    { GLenum::GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS, "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS, "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_OBJECT_TYPE_ARB, "GL_OBJECT_TYPE_ARB" },
    { GLenum::GL_SHADER_TYPE, "GL_SHADER_TYPE" },
    { GLenum::GL_FLOAT_VEC2, "GL_FLOAT_VEC2" },
    { GLenum::GL_FLOAT_VEC3, "GL_FLOAT_VEC3" },
    { GLenum::GL_FLOAT_VEC4, "GL_FLOAT_VEC4" },
    { GLenum::GL_INT_VEC2, "GL_INT_VEC2" },
    { GLenum::GL_INT_VEC3, "GL_INT_VEC3" },
    { GLenum::GL_INT_VEC4, "GL_INT_VEC4" },
    { GLenum::GL_BOOL, "GL_BOOL" },
    { GLenum::GL_BOOL_VEC2, "GL_BOOL_VEC2" },
    { GLenum::GL_BOOL_VEC3, "GL_BOOL_VEC3" },
    { GLenum::GL_BOOL_VEC4, "GL_BOOL_VEC4" },
    { GLenum::GL_FLOAT_MAT2, "GL_FLOAT_MAT2" },
    { GLenum::GL_FLOAT_MAT3, "GL_FLOAT_MAT3" },
    { GLenum::GL_FLOAT_MAT4, "GL_FLOAT_MAT4" },
    { GLenum::GL_SAMPLER_1D, "GL_SAMPLER_1D" },
    { GLenum::GL_SAMPLER_2D, "GL_SAMPLER_2D" },
    { GLenum::GL_SAMPLER_3D, "GL_SAMPLER_3D" },
    { GLenum::GL_SAMPLER_CUBE, "GL_SAMPLER_CUBE" },
    { GLenum::GL_SAMPLER_1D_SHADOW, "GL_SAMPLER_1D_SHADOW" },
    { GLenum::GL_SAMPLER_2D_SHADOW, "GL_SAMPLER_2D_SHADOW" },
    { GLenum::GL_SAMPLER_2D_RECT, "GL_SAMPLER_2D_RECT" },
    { GLenum::GL_SAMPLER_2D_RECT_SHADOW, "GL_SAMPLER_2D_RECT_SHADOW" },
    { GLenum::GL_FLOAT_MAT2x3, "GL_FLOAT_MAT2x3" },
    { GLenum::GL_FLOAT_MAT2x4, "GL_FLOAT_MAT2x4" },
    { GLenum::GL_FLOAT_MAT3x2, "GL_FLOAT_MAT3x2" },
    { GLenum::GL_FLOAT_MAT3x4, "GL_FLOAT_MAT3x4" },
    { GLenum::GL_FLOAT_MAT4x2, "GL_FLOAT_MAT4x2" },
    { GLenum::GL_FLOAT_MAT4x3, "GL_FLOAT_MAT4x3" },
    { GLenum::GL_DELETE_STATUS, "GL_DELETE_STATUS" },
    { GLenum::GL_COMPILE_STATUS, "GL_COMPILE_STATUS" },
    { GLenum::GL_LINK_STATUS, "GL_LINK_STATUS" },
    { GLenum::GL_VALIDATE_STATUS, "GL_VALIDATE_STATUS" },
    { GLenum::GL_INFO_LOG_LENGTH, "GL_INFO_LOG_LENGTH" },
    { GLenum::GL_ATTACHED_SHADERS, "GL_ATTACHED_SHADERS" },
    { GLenum::GL_ACTIVE_UNIFORMS, "GL_ACTIVE_UNIFORMS" },
    { GLenum::GL_ACTIVE_UNIFORM_MAX_LENGTH, "GL_ACTIVE_UNIFORM_MAX_LENGTH" },
    { GLenum::GL_SHADER_SOURCE_LENGTH, "GL_SHADER_SOURCE_LENGTH" },
    { GLenum::GL_ACTIVE_ATTRIBUTES, "GL_ACTIVE_ATTRIBUTES" },
    { GLenum::GL_ACTIVE_ATTRIBUTE_MAX_LENGTH, "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH" },
    { GLenum::GL_FRAGMENT_SHADER_DERIVATIVE_HINT, "GL_FRAGMENT_SHADER_DERIVATIVE_HINT" },
    { GLenum::GL_SHADING_LANGUAGE_VERSION, "GL_SHADING_LANGUAGE_VERSION" },
    { GLenum::GL_CURRENT_PROGRAM, "GL_CURRENT_PROGRAM" },
    { GLenum::GL_PALETTE4_RGB8_OES, "GL_PALETTE4_RGB8_OES" },
    { GLenum::GL_PALETTE4_RGBA8_OES, "GL_PALETTE4_RGBA8_OES" },
    { GLenum::GL_PALETTE4_R5_G6_B5_OES, "GL_PALETTE4_R5_G6_B5_OES" },
    { GLenum::GL_PALETTE4_RGBA4_OES, "GL_PALETTE4_RGBA4_OES" },
    { GLenum::GL_PALETTE4_RGB5_A1_OES, "GL_PALETTE4_RGB5_A1_OES" },
    { GLenum::GL_PALETTE8_RGB8_OES, "GL_PALETTE8_RGB8_OES" },
    { GLenum::GL_PALETTE8_RGBA8_OES, "GL_PALETTE8_RGBA8_OES" },
    { GLenum::GL_PALETTE8_R5_G6_B5_OES, "GL_PALETTE8_R5_G6_B5_OES" },
    { GLenum::GL_PALETTE8_RGBA4_OES, "GL_PALETTE8_RGBA4_OES" },
    { GLenum::GL_PALETTE8_RGB5_A1_OES, "GL_PALETTE8_RGB5_A1_OES" },
    { GLenum::GL_IMPLEMENTATION_COLOR_READ_TYPE, "GL_IMPLEMENTATION_COLOR_READ_TYPE" },
    { GLenum::GL_IMPLEMENTATION_COLOR_READ_FORMAT, "GL_IMPLEMENTATION_COLOR_READ_FORMAT" },
    { GLenum::GL_COUNTER_TYPE_AMD, "GL_COUNTER_TYPE_AMD" },
    { GLenum::GL_COUNTER_RANGE_AMD, "GL_COUNTER_RANGE_AMD" },
    { GLenum::GL_UNSIGNED_INT64_AMD, "GL_UNSIGNED_INT64_AMD" },
    { GLenum::GL_PERCENTAGE_AMD, "GL_PERCENTAGE_AMD" },
    { GLenum::GL_PERFMON_RESULT_AVAILABLE_AMD, "GL_PERFMON_RESULT_AVAILABLE_AMD" },
    { GLenum::GL_PERFMON_RESULT_SIZE_AMD, "GL_PERFMON_RESULT_SIZE_AMD" },
    { GLenum::GL_PERFMON_RESULT_AMD, "GL_PERFMON_RESULT_AMD" },
    { GLenum::GL_TEXTURE_RED_TYPE, "GL_TEXTURE_RED_TYPE" },
    { GLenum::GL_TEXTURE_GREEN_TYPE, "GL_TEXTURE_GREEN_TYPE" },
    { GLenum::GL_TEXTURE_BLUE_TYPE, "GL_TEXTURE_BLUE_TYPE" },
    { GLenum::GL_TEXTURE_ALPHA_TYPE, "GL_TEXTURE_ALPHA_TYPE" },
    { GLenum::GL_TEXTURE_LUMINANCE_TYPE, "GL_TEXTURE_LUMINANCE_TYPE" },
    { GLenum::GL_TEXTURE_INTENSITY_TYPE, "GL_TEXTURE_INTENSITY_TYPE" },
    { GLenum::GL_TEXTURE_DEPTH_TYPE, "GL_TEXTURE_DEPTH_TYPE" },
    { GLenum::GL_UNSIGNED_NORMALIZED, "GL_UNSIGNED_NORMALIZED" },
    { GLenum::GL_TEXTURE_1D_ARRAY, "GL_TEXTURE_1D_ARRAY" },
    { GLenum::GL_PROXY_TEXTURE_1D_ARRAY, "GL_PROXY_TEXTURE_1D_ARRAY" },
    { GLenum::GL_TEXTURE_2D_ARRAY, "GL_TEXTURE_2D_ARRAY" },
    { GLenum::GL_PROXY_TEXTURE_2D_ARRAY, "GL_PROXY_TEXTURE_2D_ARRAY" },
    { GLenum::GL_TEXTURE_BINDING_1D_ARRAY, "GL_TEXTURE_BINDING_1D_ARRAY" },
    { GLenum::GL_TEXTURE_BINDING_2D_ARRAY, "GL_TEXTURE_BINDING_2D_ARRAY" },
    { GLenum::GL_GEOMETRY_PROGRAM_NV, "GL_GEOMETRY_PROGRAM_NV" },
    { GLenum::GL_MAX_PROGRAM_OUTPUT_VERTICES_NV, "GL_MAX_PROGRAM_OUTPUT_VERTICES_NV" },
    { GLenum::GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV, "GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV" },
    { GLenum::GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS, "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_TEXTURE_BUFFER, "GL_TEXTURE_BUFFER" },
    { GLenum::GL_MAX_TEXTURE_BUFFER_SIZE, "GL_MAX_TEXTURE_BUFFER_SIZE" },
    { GLenum::GL_TEXTURE_BINDING_BUFFER, "GL_TEXTURE_BINDING_BUFFER" },
    { GLenum::GL_TEXTURE_BUFFER_DATA_STORE_BINDING, "GL_TEXTURE_BUFFER_DATA_STORE_BINDING" },
    { GLenum::GL_TEXTURE_BUFFER_FORMAT_ARB, "GL_TEXTURE_BUFFER_FORMAT_ARB" },
    { GLenum::GL_ANY_SAMPLES_PASSED, "GL_ANY_SAMPLES_PASSED" },
    { GLenum::GL_SAMPLE_SHADING, "GL_SAMPLE_SHADING" },
    { GLenum::GL_MIN_SAMPLE_SHADING_VALUE, "GL_MIN_SAMPLE_SHADING_VALUE" },
    { GLenum::GL_R11F_G11F_B10F, "GL_R11F_G11F_B10F" },
    { GLenum::GL_UNSIGNED_INT_10F_11F_11F_REV, "GL_UNSIGNED_INT_10F_11F_11F_REV" },
    { GLenum::GL_RGBA_SIGNED_COMPONENTS_EXT, "GL_RGBA_SIGNED_COMPONENTS_EXT" },
    { GLenum::GL_RGB9_E5, "GL_RGB9_E5" },
    { GLenum::GL_UNSIGNED_INT_5_9_9_9_REV, "GL_UNSIGNED_INT_5_9_9_9_REV" },
    { GLenum::GL_TEXTURE_SHARED_SIZE, "GL_TEXTURE_SHARED_SIZE" },
    { GLenum::GL_SRGB, "GL_SRGB" },
    { GLenum::GL_SRGB8, "GL_SRGB8" },
    { GLenum::GL_SRGB_ALPHA, "GL_SRGB_ALPHA" },
    { GLenum::GL_SRGB8_ALPHA8, "GL_SRGB8_ALPHA8" },
    { GLenum::GL_SLUMINANCE_ALPHA, "GL_SLUMINANCE_ALPHA" },
    { GLenum::GL_SLUMINANCE8_ALPHA8, "GL_SLUMINANCE8_ALPHA8" },
    { GLenum::GL_SLUMINANCE, "GL_SLUMINANCE" },
    { GLenum::GL_SLUMINANCE8, "GL_SLUMINANCE8" },
    { GLenum::GL_COMPRESSED_SRGB, "GL_COMPRESSED_SRGB" },
    { GLenum::GL_COMPRESSED_SRGB_ALPHA, "GL_COMPRESSED_SRGB_ALPHA" },
    { GLenum::GL_COMPRESSED_SLUMINANCE, "GL_COMPRESSED_SLUMINANCE" },
    { GLenum::GL_COMPRESSED_SLUMINANCE_ALPHA, "GL_COMPRESSED_SLUMINANCE_ALPHA" },
    { GLenum::GL_COMPRESSED_SRGB_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT" },
    { GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT" },
    { GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT" },
    { GLenum::GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT, "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT" },
    { GLenum::GL_COMPRESSED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_LUMINANCE_LATC1_EXT" },
    { GLenum::GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT" },
    { GLenum::GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT" },
    { GLenum::GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT, "GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT" },
    { GLenum::GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV, "GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV, "GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH, "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH" },
    { GLenum::GL_BACK_PRIMARY_COLOR_NV, "GL_BACK_PRIMARY_COLOR_NV" },
    { GLenum::GL_BACK_SECONDARY_COLOR_NV, "GL_BACK_SECONDARY_COLOR_NV" },
    { GLenum::GL_TEXTURE_COORD_NV, "GL_TEXTURE_COORD_NV" },
    { GLenum::GL_CLIP_DISTANCE_NV, "GL_CLIP_DISTANCE_NV" },
    { GLenum::GL_VERTEX_ID_NV, "GL_VERTEX_ID_NV" },
    { GLenum::GL_PRIMITIVE_ID_NV, "GL_PRIMITIVE_ID_NV" },
    { GLenum::GL_GENERIC_ATTRIB_NV, "GL_GENERIC_ATTRIB_NV" },
    { GLenum::GL_TRANSFORM_FEEDBACK_ATTRIBS_NV, "GL_TRANSFORM_FEEDBACK_ATTRIBS_NV" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_MODE, "GL_TRANSFORM_FEEDBACK_BUFFER_MODE" },
    { GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS" },
    { GLenum::GL_ACTIVE_VARYINGS_NV, "GL_ACTIVE_VARYINGS_NV" },
    { GLenum::GL_ACTIVE_VARYING_MAX_LENGTH_NV, "GL_ACTIVE_VARYING_MAX_LENGTH_NV" },
    { GLenum::GL_TRANSFORM_FEEDBACK_VARYINGS, "GL_TRANSFORM_FEEDBACK_VARYINGS" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_START, "GL_TRANSFORM_FEEDBACK_BUFFER_START" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_SIZE, "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE" },
    { GLenum::GL_TRANSFORM_FEEDBACK_RECORD_NV, "GL_TRANSFORM_FEEDBACK_RECORD_NV" },
    { GLenum::GL_PRIMITIVES_GENERATED, "GL_PRIMITIVES_GENERATED" },
    { GLenum::GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN, "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN" },
    { GLenum::GL_RASTERIZER_DISCARD, "GL_RASTERIZER_DISCARD" },
    { GLenum::GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS, "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS" },
    { GLenum::GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS, "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS" },
    { GLenum::GL_INTERLEAVED_ATTRIBS, "GL_INTERLEAVED_ATTRIBS" },
    { GLenum::GL_SEPARATE_ATTRIBS, "GL_SEPARATE_ATTRIBS" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER, "GL_TRANSFORM_FEEDBACK_BUFFER" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_BINDING, "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING" },
    { GLenum::GL_POINT_SPRITE_COORD_ORIGIN, "GL_POINT_SPRITE_COORD_ORIGIN" },
    { GLenum::GL_LOWER_LEFT, "GL_LOWER_LEFT" },
    { GLenum::GL_UPPER_LEFT, "GL_UPPER_LEFT" },
    { GLenum::GL_STENCIL_BACK_REF, "GL_STENCIL_BACK_REF" },
    { GLenum::GL_STENCIL_BACK_VALUE_MASK, "GL_STENCIL_BACK_VALUE_MASK" },
    { GLenum::GL_STENCIL_BACK_WRITEMASK, "GL_STENCIL_BACK_WRITEMASK" },
    { GLenum::GL_DRAW_FRAMEBUFFER_BINDING, "GL_DRAW_FRAMEBUFFER_BINDING" },
    { GLenum::GL_RENDERBUFFER_BINDING, "GL_RENDERBUFFER_BINDING" },
    { GLenum::GL_READ_FRAMEBUFFER, "GL_READ_FRAMEBUFFER" },
    { GLenum::GL_DRAW_FRAMEBUFFER, "GL_DRAW_FRAMEBUFFER" },
    { GLenum::GL_READ_FRAMEBUFFER_BINDING, "GL_READ_FRAMEBUFFER_BINDING" },
    { GLenum::GL_RENDERBUFFER_SAMPLES, "GL_RENDERBUFFER_SAMPLES" },
    { GLenum::GL_DEPTH_COMPONENT32F, "GL_DEPTH_COMPONENT32F" },
    { GLenum::GL_DEPTH32F_STENCIL8, "GL_DEPTH32F_STENCIL8" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME, "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER" },
    { GLenum::GL_FRAMEBUFFER_COMPLETE, "GL_FRAMEBUFFER_COMPLETE" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT, "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT, "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT, "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT, "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER, "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER, "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER" },
    { GLenum::GL_FRAMEBUFFER_UNSUPPORTED, "GL_FRAMEBUFFER_UNSUPPORTED" },
    { GLenum::GL_MAX_COLOR_ATTACHMENTS, "GL_MAX_COLOR_ATTACHMENTS" },
    { GLenum::GL_COLOR_ATTACHMENT0, "GL_COLOR_ATTACHMENT0" },
    { GLenum::GL_COLOR_ATTACHMENT1, "GL_COLOR_ATTACHMENT1" },
    { GLenum::GL_COLOR_ATTACHMENT2, "GL_COLOR_ATTACHMENT2" },
    { GLenum::GL_COLOR_ATTACHMENT3, "GL_COLOR_ATTACHMENT3" },
    { GLenum::GL_COLOR_ATTACHMENT4, "GL_COLOR_ATTACHMENT4" },
    { GLenum::GL_COLOR_ATTACHMENT5, "GL_COLOR_ATTACHMENT5" },
    { GLenum::GL_COLOR_ATTACHMENT6, "GL_COLOR_ATTACHMENT6" },
    { GLenum::GL_COLOR_ATTACHMENT7, "GL_COLOR_ATTACHMENT7" },
    { GLenum::GL_COLOR_ATTACHMENT8, "GL_COLOR_ATTACHMENT8" },
    { GLenum::GL_COLOR_ATTACHMENT9, "GL_COLOR_ATTACHMENT9" },
    { GLenum::GL_COLOR_ATTACHMENT10, "GL_COLOR_ATTACHMENT10" },
    { GLenum::GL_COLOR_ATTACHMENT11, "GL_COLOR_ATTACHMENT11" },
    { GLenum::GL_COLOR_ATTACHMENT12, "GL_COLOR_ATTACHMENT12" },
    { GLenum::GL_COLOR_ATTACHMENT13, "GL_COLOR_ATTACHMENT13" },
    { GLenum::GL_COLOR_ATTACHMENT14, "GL_COLOR_ATTACHMENT14" },
    { GLenum::GL_COLOR_ATTACHMENT15, "GL_COLOR_ATTACHMENT15" },
    { GLenum::GL_COLOR_ATTACHMENT16, "GL_COLOR_ATTACHMENT16" },
    { GLenum::GL_COLOR_ATTACHMENT17, "GL_COLOR_ATTACHMENT17" },
    { GLenum::GL_COLOR_ATTACHMENT18, "GL_COLOR_ATTACHMENT18" },
    { GLenum::GL_COLOR_ATTACHMENT19, "GL_COLOR_ATTACHMENT19" },
    { GLenum::GL_COLOR_ATTACHMENT20, "GL_COLOR_ATTACHMENT20" },
    { GLenum::GL_COLOR_ATTACHMENT21, "GL_COLOR_ATTACHMENT21" },
    { GLenum::GL_COLOR_ATTACHMENT22, "GL_COLOR_ATTACHMENT22" },
    { GLenum::GL_COLOR_ATTACHMENT23, "GL_COLOR_ATTACHMENT23" },
    { GLenum::GL_COLOR_ATTACHMENT24, "GL_COLOR_ATTACHMENT24" },
    { GLenum::GL_COLOR_ATTACHMENT25, "GL_COLOR_ATTACHMENT25" },
    { GLenum::GL_COLOR_ATTACHMENT26, "GL_COLOR_ATTACHMENT26" },
    { GLenum::GL_COLOR_ATTACHMENT27, "GL_COLOR_ATTACHMENT27" },
    { GLenum::GL_COLOR_ATTACHMENT28, "GL_COLOR_ATTACHMENT28" },
    { GLenum::GL_COLOR_ATTACHMENT29, "GL_COLOR_ATTACHMENT29" },
    { GLenum::GL_COLOR_ATTACHMENT30, "GL_COLOR_ATTACHMENT30" },
    { GLenum::GL_COLOR_ATTACHMENT31, "GL_COLOR_ATTACHMENT31" },
    { GLenum::GL_DEPTH_ATTACHMENT, "GL_DEPTH_ATTACHMENT" },
    { GLenum::GL_STENCIL_ATTACHMENT, "GL_STENCIL_ATTACHMENT" },
    { GLenum::GL_FRAMEBUFFER, "GL_FRAMEBUFFER" },
    { GLenum::GL_RENDERBUFFER, "GL_RENDERBUFFER" },
    { GLenum::GL_RENDERBUFFER_WIDTH, "GL_RENDERBUFFER_WIDTH" },
    { GLenum::GL_RENDERBUFFER_HEIGHT, "GL_RENDERBUFFER_HEIGHT" },
    { GLenum::GL_RENDERBUFFER_INTERNAL_FORMAT, "GL_RENDERBUFFER_INTERNAL_FORMAT" },
    { GLenum::GL_STENCIL_INDEX1, "GL_STENCIL_INDEX1" },
    { GLenum::GL_STENCIL_INDEX4, "GL_STENCIL_INDEX4" },
    { GLenum::GL_STENCIL_INDEX8, "GL_STENCIL_INDEX8" },
    { GLenum::GL_STENCIL_INDEX16, "GL_STENCIL_INDEX16" },
    { GLenum::GL_RENDERBUFFER_RED_SIZE, "GL_RENDERBUFFER_RED_SIZE" },
    { GLenum::GL_RENDERBUFFER_GREEN_SIZE, "GL_RENDERBUFFER_GREEN_SIZE" },
    { GLenum::GL_RENDERBUFFER_BLUE_SIZE, "GL_RENDERBUFFER_BLUE_SIZE" },
    { GLenum::GL_RENDERBUFFER_ALPHA_SIZE, "GL_RENDERBUFFER_ALPHA_SIZE" },
    { GLenum::GL_RENDERBUFFER_DEPTH_SIZE, "GL_RENDERBUFFER_DEPTH_SIZE" },
    { GLenum::GL_RENDERBUFFER_STENCIL_SIZE, "GL_RENDERBUFFER_STENCIL_SIZE" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE, "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE" },
    { GLenum::GL_MAX_SAMPLES, "GL_MAX_SAMPLES" },
    { GLenum::GL_RGB565, "GL_RGB565" },
    { GLenum::GL_PRIMITIVE_RESTART_FIXED_INDEX, "GL_PRIMITIVE_RESTART_FIXED_INDEX" },
    { GLenum::GL_ANY_SAMPLES_PASSED_CONSERVATIVE, "GL_ANY_SAMPLES_PASSED_CONSERVATIVE" },
    { GLenum::GL_MAX_ELEMENT_INDEX, "GL_MAX_ELEMENT_INDEX" },
    { GLenum::GL_RGBA32UI, "GL_RGBA32UI" },
    { GLenum::GL_RGB32UI, "GL_RGB32UI" },
    { GLenum::GL_ALPHA32UI_EXT, "GL_ALPHA32UI_EXT" },
    { GLenum::GL_INTENSITY32UI_EXT, "GL_INTENSITY32UI_EXT" },
    { GLenum::GL_LUMINANCE32UI_EXT, "GL_LUMINANCE32UI_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA32UI_EXT, "GL_LUMINANCE_ALPHA32UI_EXT" },
    { GLenum::GL_RGBA16UI, "GL_RGBA16UI" },
    { GLenum::GL_RGB16UI, "GL_RGB16UI" },
    { GLenum::GL_ALPHA16UI_EXT, "GL_ALPHA16UI_EXT" },
    { GLenum::GL_INTENSITY16UI_EXT, "GL_INTENSITY16UI_EXT" },
    { GLenum::GL_LUMINANCE16UI_EXT, "GL_LUMINANCE16UI_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA16UI_EXT, "GL_LUMINANCE_ALPHA16UI_EXT" },
    { GLenum::GL_RGBA8UI, "GL_RGBA8UI" },
    { GLenum::GL_RGB8UI, "GL_RGB8UI" },
    { GLenum::GL_ALPHA8UI_EXT, "GL_ALPHA8UI_EXT" },
    { GLenum::GL_INTENSITY8UI_EXT, "GL_INTENSITY8UI_EXT" },
    { GLenum::GL_LUMINANCE8UI_EXT, "GL_LUMINANCE8UI_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA8UI_EXT, "GL_LUMINANCE_ALPHA8UI_EXT" },
    { GLenum::GL_RGBA32I, "GL_RGBA32I" },
    { GLenum::GL_RGB32I, "GL_RGB32I" },
    { GLenum::GL_ALPHA32I_EXT, "GL_ALPHA32I_EXT" },
    { GLenum::GL_INTENSITY32I_EXT, "GL_INTENSITY32I_EXT" },
    { GLenum::GL_LUMINANCE32I_EXT, "GL_LUMINANCE32I_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA32I_EXT, "GL_LUMINANCE_ALPHA32I_EXT" },
    { GLenum::GL_RGBA16I, "GL_RGBA16I" },
    { GLenum::GL_RGB16I, "GL_RGB16I" },
    { GLenum::GL_ALPHA16I_EXT, "GL_ALPHA16I_EXT" },
    { GLenum::GL_INTENSITY16I_EXT, "GL_INTENSITY16I_EXT" },
    { GLenum::GL_LUMINANCE16I_EXT, "GL_LUMINANCE16I_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA16I_EXT, "GL_LUMINANCE_ALPHA16I_EXT" },
    { GLenum::GL_RGBA8I, "GL_RGBA8I" },
    { GLenum::GL_RGB8I, "GL_RGB8I" },
    { GLenum::GL_ALPHA8I_EXT, "GL_ALPHA8I_EXT" },
    { GLenum::GL_INTENSITY8I_EXT, "GL_INTENSITY8I_EXT" },
    { GLenum::GL_LUMINANCE8I_EXT, "GL_LUMINANCE8I_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA8I_EXT, "GL_LUMINANCE_ALPHA8I_EXT" },
    { GLenum::GL_RED_INTEGER, "GL_RED_INTEGER" },
    { GLenum::GL_GREEN_INTEGER, "GL_GREEN_INTEGER" },
    { GLenum::GL_BLUE_INTEGER, "GL_BLUE_INTEGER" },
    { GLenum::GL_ALPHA_INTEGER, "GL_ALPHA_INTEGER" },
    { GLenum::GL_RGB_INTEGER, "GL_RGB_INTEGER" },
    { GLenum::GL_RGBA_INTEGER, "GL_RGBA_INTEGER" },
    { GLenum::GL_BGR_INTEGER, "GL_BGR_INTEGER" },
    { GLenum::GL_BGRA_INTEGER, "GL_BGRA_INTEGER" },
    { GLenum::GL_LUMINANCE_INTEGER_EXT, "GL_LUMINANCE_INTEGER_EXT" },
    { GLenum::GL_LUMINANCE_ALPHA_INTEGER_EXT, "GL_LUMINANCE_ALPHA_INTEGER_EXT" },
    { GLenum::GL_RGBA_INTEGER_MODE_EXT, "GL_RGBA_INTEGER_MODE_EXT" },
    { GLenum::GL_INT_2_10_10_10_REV, "GL_INT_2_10_10_10_REV" },
    { GLenum::GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV, "GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV" },
    { GLenum::GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV, "GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV" },
    { GLenum::GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV, "GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV, "GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV, "GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV, "GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV" },
    { GLenum::GL_MAX_PROGRAM_GENERIC_RESULTS_NV, "GL_MAX_PROGRAM_GENERIC_RESULTS_NV" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_LAYERED, "GL_FRAMEBUFFER_ATTACHMENT_LAYERED" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS" },
    { GLenum::GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB, "GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB" },
    { GLenum::GL_LAYER_NV, "GL_LAYER_NV" },
    { GLenum::GL_DEPTH_COMPONENT32F_NV, "GL_DEPTH_COMPONENT32F_NV" },
    { GLenum::GL_DEPTH32F_STENCIL8_NV, "GL_DEPTH32F_STENCIL8_NV" },
    { GLenum::GL_FLOAT_32_UNSIGNED_INT_24_8_REV, "GL_FLOAT_32_UNSIGNED_INT_24_8_REV" },
    { GLenum::GL_SHADER_INCLUDE_ARB, "GL_SHADER_INCLUDE_ARB" },
    { GLenum::GL_DEPTH_BUFFER_FLOAT_MODE_NV, "GL_DEPTH_BUFFER_FLOAT_MODE_NV" },
    { GLenum::GL_FRAMEBUFFER_SRGB, "GL_FRAMEBUFFER_SRGB" },
    { GLenum::GL_FRAMEBUFFER_SRGB_CAPABLE_EXT, "GL_FRAMEBUFFER_SRGB_CAPABLE_EXT" },
    { GLenum::GL_COMPRESSED_RED_RGTC1, "GL_COMPRESSED_RED_RGTC1" },
    { GLenum::GL_COMPRESSED_SIGNED_RED_RGTC1, "GL_COMPRESSED_SIGNED_RED_RGTC1" },
    { GLenum::GL_COMPRESSED_RG_RGTC2, "GL_COMPRESSED_RG_RGTC2" },
    { GLenum::GL_COMPRESSED_SIGNED_RG_RGTC2, "GL_COMPRESSED_SIGNED_RG_RGTC2" },
    { GLenum::GL_SAMPLER_1D_ARRAY, "GL_SAMPLER_1D_ARRAY" },
    { GLenum::GL_SAMPLER_2D_ARRAY, "GL_SAMPLER_2D_ARRAY" },
    { GLenum::GL_SAMPLER_BUFFER, "GL_SAMPLER_BUFFER" },
    { GLenum::GL_SAMPLER_1D_ARRAY_SHADOW, "GL_SAMPLER_1D_ARRAY_SHADOW" },
    { GLenum::GL_SAMPLER_2D_ARRAY_SHADOW, "GL_SAMPLER_2D_ARRAY_SHADOW" },
    { GLenum::GL_SAMPLER_CUBE_SHADOW, "GL_SAMPLER_CUBE_SHADOW" },
    { GLenum::GL_UNSIGNED_INT_VEC2, "GL_UNSIGNED_INT_VEC2" },
    { GLenum::GL_UNSIGNED_INT_VEC3, "GL_UNSIGNED_INT_VEC3" },
    { GLenum::GL_UNSIGNED_INT_VEC4, "GL_UNSIGNED_INT_VEC4" },
    { GLenum::GL_INT_SAMPLER_1D, "GL_INT_SAMPLER_1D" },
    { GLenum::GL_INT_SAMPLER_2D, "GL_INT_SAMPLER_2D" },
    { GLenum::GL_INT_SAMPLER_3D, "GL_INT_SAMPLER_3D" },
    { GLenum::GL_INT_SAMPLER_CUBE, "GL_INT_SAMPLER_CUBE" },
    { GLenum::GL_INT_SAMPLER_2D_RECT, "GL_INT_SAMPLER_2D_RECT" },
    { GLenum::GL_INT_SAMPLER_1D_ARRAY, "GL_INT_SAMPLER_1D_ARRAY" },
    { GLenum::GL_INT_SAMPLER_2D_ARRAY, "GL_INT_SAMPLER_2D_ARRAY" },
    { GLenum::GL_INT_SAMPLER_BUFFER, "GL_INT_SAMPLER_BUFFER" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_1D, "GL_UNSIGNED_INT_SAMPLER_1D" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_2D, "GL_UNSIGNED_INT_SAMPLER_2D" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_3D, "GL_UNSIGNED_INT_SAMPLER_3D" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE, "GL_UNSIGNED_INT_SAMPLER_CUBE" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_2D_RECT, "GL_UNSIGNED_INT_SAMPLER_2D_RECT" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_1D_ARRAY, "GL_UNSIGNED_INT_SAMPLER_1D_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_2D_ARRAY, "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_BUFFER, "GL_UNSIGNED_INT_SAMPLER_BUFFER" },
    { GLenum::GL_GEOMETRY_SHADER, "GL_GEOMETRY_SHADER" },
    { GLenum::GL_GEOMETRY_VERTICES_OUT_ARB, "GL_GEOMETRY_VERTICES_OUT_ARB" },
    { GLenum::GL_GEOMETRY_INPUT_TYPE_ARB, "GL_GEOMETRY_INPUT_TYPE_ARB" },
    { GLenum::GL_GEOMETRY_OUTPUT_TYPE_ARB, "GL_GEOMETRY_OUTPUT_TYPE_ARB" },
    { GLenum::GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB, "GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB" },
    { GLenum::GL_MAX_VERTEX_VARYING_COMPONENTS_ARB, "GL_MAX_VERTEX_VARYING_COMPONENTS_ARB" },
    { GLenum::GL_MAX_GEOMETRY_UNIFORM_COMPONENTS, "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_GEOMETRY_OUTPUT_VERTICES, "GL_MAX_GEOMETRY_OUTPUT_VERTICES" },
    { GLenum::GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS, "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS" },
    { GLenum::GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT, "GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT" },
    { GLenum::GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT, "GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT" },
    { GLenum::GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT, "GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT" },
    { GLenum::GL_ACTIVE_SUBROUTINES, "GL_ACTIVE_SUBROUTINES" },
    { GLenum::GL_ACTIVE_SUBROUTINE_UNIFORMS, "GL_ACTIVE_SUBROUTINE_UNIFORMS" },
    { GLenum::GL_MAX_SUBROUTINES, "GL_MAX_SUBROUTINES" },
    { GLenum::GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS, "GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS" },
    { GLenum::GL_NAMED_STRING_LENGTH_ARB, "GL_NAMED_STRING_LENGTH_ARB" },
    { GLenum::GL_NAMED_STRING_TYPE_ARB, "GL_NAMED_STRING_TYPE_ARB" },
    { GLenum::GL_MAX_BINDABLE_UNIFORM_SIZE_EXT, "GL_MAX_BINDABLE_UNIFORM_SIZE_EXT" },
    { GLenum::GL_UNIFORM_BUFFER_EXT, "GL_UNIFORM_BUFFER_EXT" },
    { GLenum::GL_UNIFORM_BUFFER_BINDING_EXT, "GL_UNIFORM_BUFFER_BINDING_EXT" },
    { GLenum::GL_LOW_FLOAT, "GL_LOW_FLOAT" },
    { GLenum::GL_MEDIUM_FLOAT, "GL_MEDIUM_FLOAT" },
    { GLenum::GL_HIGH_FLOAT, "GL_HIGH_FLOAT" },
    { GLenum::GL_LOW_INT, "GL_LOW_INT" },
    { GLenum::GL_MEDIUM_INT, "GL_MEDIUM_INT" },
    { GLenum::GL_HIGH_INT, "GL_HIGH_INT" },
    { GLenum::GL_SHADER_BINARY_FORMATS, "GL_SHADER_BINARY_FORMATS" },
    { GLenum::GL_NUM_SHADER_BINARY_FORMATS, "GL_NUM_SHADER_BINARY_FORMATS" },
    { GLenum::GL_SHADER_COMPILER, "GL_SHADER_COMPILER" },
    { GLenum::GL_MAX_VERTEX_UNIFORM_VECTORS, "GL_MAX_VERTEX_UNIFORM_VECTORS" },
    { GLenum::GL_MAX_VARYING_VECTORS, "GL_MAX_VARYING_VECTORS" },
    { GLenum::GL_MAX_FRAGMENT_UNIFORM_VECTORS, "GL_MAX_FRAGMENT_UNIFORM_VECTORS" },
    { GLenum::GL_RENDERBUFFER_COLOR_SAMPLES_NV, "GL_RENDERBUFFER_COLOR_SAMPLES_NV" },
    { GLenum::GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV, "GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV" },
    { GLenum::GL_MULTISAMPLE_COVERAGE_MODES_NV, "GL_MULTISAMPLE_COVERAGE_MODES_NV" },
    { GLenum::GL_QUERY_WAIT, "GL_QUERY_WAIT" },
    { GLenum::GL_QUERY_NO_WAIT, "GL_QUERY_NO_WAIT" },
    { GLenum::GL_QUERY_BY_REGION_WAIT, "GL_QUERY_BY_REGION_WAIT" },
    { GLenum::GL_QUERY_BY_REGION_NO_WAIT, "GL_QUERY_BY_REGION_NO_WAIT" },
    { GLenum::GL_QUERY_WAIT_INVERTED, "GL_QUERY_WAIT_INVERTED" },
    { GLenum::GL_QUERY_NO_WAIT_INVERTED, "GL_QUERY_NO_WAIT_INVERTED" },
    { GLenum::GL_QUERY_BY_REGION_WAIT_INVERTED, "GL_QUERY_BY_REGION_WAIT_INVERTED" },
    { GLenum::GL_QUERY_BY_REGION_NO_WAIT_INVERTED, "GL_QUERY_BY_REGION_NO_WAIT_INVERTED" },
    { GLenum::GL_POLYGON_OFFSET_CLAMP_EXT, "GL_POLYGON_OFFSET_CLAMP_EXT" },
    { GLenum::GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS, "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS" },
    { GLenum::GL_COLOR_SAMPLES_NV, "GL_COLOR_SAMPLES_NV" },
    { GLenum::GL_TRANSFORM_FEEDBACK, "GL_TRANSFORM_FEEDBACK" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED, "GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED" },
    { GLenum::GL_TRANSFORM_FEEDBACK_ACTIVE, "GL_TRANSFORM_FEEDBACK_ACTIVE" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BINDING, "GL_TRANSFORM_FEEDBACK_BINDING" },
    { GLenum::GL_FRAME_NV, "GL_FRAME_NV" },
    { GLenum::GL_FIELDS_NV, "GL_FIELDS_NV" },
    { GLenum::GL_TIMESTAMP, "GL_TIMESTAMP" },
    { GLenum::GL_NUM_FILL_STREAMS_NV, "GL_NUM_FILL_STREAMS_NV" },
    { GLenum::GL_PRESENT_TIME_NV, "GL_PRESENT_TIME_NV" },
    { GLenum::GL_PRESENT_DURATION_NV, "GL_PRESENT_DURATION_NV" },
    { GLenum::GL_PROGRAM_MATRIX_EXT, "GL_PROGRAM_MATRIX_EXT" },
    { GLenum::GL_TRANSPOSE_PROGRAM_MATRIX_EXT, "GL_TRANSPOSE_PROGRAM_MATRIX_EXT" },
    { GLenum::GL_PROGRAM_MATRIX_STACK_DEPTH_EXT, "GL_PROGRAM_MATRIX_STACK_DEPTH_EXT" },
    { GLenum::GL_TEXTURE_SWIZZLE_R, "GL_TEXTURE_SWIZZLE_R" },
    { GLenum::GL_TEXTURE_SWIZZLE_G, "GL_TEXTURE_SWIZZLE_G" },
    { GLenum::GL_TEXTURE_SWIZZLE_B, "GL_TEXTURE_SWIZZLE_B" },
    { GLenum::GL_TEXTURE_SWIZZLE_A, "GL_TEXTURE_SWIZZLE_A" },
    { GLenum::GL_TEXTURE_SWIZZLE_RGBA, "GL_TEXTURE_SWIZZLE_RGBA" },
    { GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS, "GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS" },
    { GLenum::GL_ACTIVE_SUBROUTINE_MAX_LENGTH, "GL_ACTIVE_SUBROUTINE_MAX_LENGTH" },
    { GLenum::GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH, "GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH" },
    { GLenum::GL_NUM_COMPATIBLE_SUBROUTINES, "GL_NUM_COMPATIBLE_SUBROUTINES" },
    { GLenum::GL_COMPATIBLE_SUBROUTINES, "GL_COMPATIBLE_SUBROUTINES" },
    { GLenum::GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION, "GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION" },
    { GLenum::GL_FIRST_VERTEX_CONVENTION, "GL_FIRST_VERTEX_CONVENTION" },
    { GLenum::GL_LAST_VERTEX_CONVENTION, "GL_LAST_VERTEX_CONVENTION" },
    { GLenum::GL_PROVOKING_VERTEX, "GL_PROVOKING_VERTEX" },
    { GLenum::GL_SAMPLE_POSITION, "GL_SAMPLE_POSITION" },
    { GLenum::GL_SAMPLE_MASK, "GL_SAMPLE_MASK" },
    { GLenum::GL_SAMPLE_MASK_VALUE, "GL_SAMPLE_MASK_VALUE" },
    { GLenum::GL_TEXTURE_BINDING_RENDERBUFFER_NV, "GL_TEXTURE_BINDING_RENDERBUFFER_NV" },
    { GLenum::GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV, "GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV" },
    { GLenum::GL_TEXTURE_RENDERBUFFER_NV, "GL_TEXTURE_RENDERBUFFER_NV" },
    { GLenum::GL_SAMPLER_RENDERBUFFER_NV, "GL_SAMPLER_RENDERBUFFER_NV" },
    { GLenum::GL_INT_SAMPLER_RENDERBUFFER_NV, "GL_INT_SAMPLER_RENDERBUFFER_NV" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV, "GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV" },
    { GLenum::GL_MAX_SAMPLE_MASK_WORDS, "GL_MAX_SAMPLE_MASK_WORDS" },
    { GLenum::GL_MAX_GEOMETRY_SHADER_INVOCATIONS, "GL_MAX_GEOMETRY_SHADER_INVOCATIONS" },
    { GLenum::GL_MIN_FRAGMENT_INTERPOLATION_OFFSET, "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET" },
    { GLenum::GL_MAX_FRAGMENT_INTERPOLATION_OFFSET, "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET" },
    { GLenum::GL_FRAGMENT_INTERPOLATION_OFFSET_BITS, "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS" },
    { GLenum::GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET, "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET" },
    { GLenum::GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET, "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET" },
    { GLenum::GL_MAX_TRANSFORM_FEEDBACK_BUFFERS, "GL_MAX_TRANSFORM_FEEDBACK_BUFFERS" },
    { GLenum::GL_MAX_VERTEX_STREAMS, "GL_MAX_VERTEX_STREAMS" },
    { GLenum::GL_PATCH_VERTICES, "GL_PATCH_VERTICES" },
    { GLenum::GL_PATCH_DEFAULT_INNER_LEVEL, "GL_PATCH_DEFAULT_INNER_LEVEL" },
    { GLenum::GL_PATCH_DEFAULT_OUTER_LEVEL, "GL_PATCH_DEFAULT_OUTER_LEVEL" },
    { GLenum::GL_TESS_CONTROL_OUTPUT_VERTICES, "GL_TESS_CONTROL_OUTPUT_VERTICES" },
    { GLenum::GL_TESS_GEN_MODE, "GL_TESS_GEN_MODE" },
    { GLenum::GL_TESS_GEN_SPACING, "GL_TESS_GEN_SPACING" },
    { GLenum::GL_TESS_GEN_VERTEX_ORDER, "GL_TESS_GEN_VERTEX_ORDER" },
    { GLenum::GL_TESS_GEN_POINT_MODE, "GL_TESS_GEN_POINT_MODE" },
    { GLenum::GL_ISOLINES, "GL_ISOLINES" },
    { GLenum::GL_FRACTIONAL_ODD, "GL_FRACTIONAL_ODD" },
    { GLenum::GL_FRACTIONAL_EVEN, "GL_FRACTIONAL_EVEN" },
    { GLenum::GL_MAX_PATCH_VERTICES, "GL_MAX_PATCH_VERTICES" },
    { GLenum::GL_MAX_TESS_GEN_LEVEL, "GL_MAX_TESS_GEN_LEVEL" },
    { GLenum::GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS, "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS, "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS" },
    { GLenum::GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS, "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS, "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS" },
    { GLenum::GL_MAX_TESS_PATCH_COMPONENTS, "GL_MAX_TESS_PATCH_COMPONENTS" },
    { GLenum::GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS, "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS" },
    { GLenum::GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS, "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS" },
    { GLenum::GL_TESS_EVALUATION_SHADER, "GL_TESS_EVALUATION_SHADER" },
    { GLenum::GL_TESS_CONTROL_SHADER, "GL_TESS_CONTROL_SHADER" },
    { GLenum::GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS, "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS, "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS" },
    { GLenum::GL_COMPRESSED_RGBA_BPTC_UNORM, "GL_COMPRESSED_RGBA_BPTC_UNORM" },
    { GLenum::GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM, "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM" },
    { GLenum::GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT" },
    { GLenum::GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT, "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT" },
    { GLenum::GL_INCLUSIVE_EXT, "GL_INCLUSIVE_EXT" },
    { GLenum::GL_EXCLUSIVE_EXT, "GL_EXCLUSIVE_EXT" },
    { GLenum::GL_WINDOW_RECTANGLE_EXT, "GL_WINDOW_RECTANGLE_EXT" },
    { GLenum::GL_WINDOW_RECTANGLE_MODE_EXT, "GL_WINDOW_RECTANGLE_MODE_EXT" },
    { GLenum::GL_MAX_WINDOW_RECTANGLES_EXT, "GL_MAX_WINDOW_RECTANGLES_EXT" },
    { GLenum::GL_NUM_WINDOW_RECTANGLES_EXT, "GL_NUM_WINDOW_RECTANGLES_EXT" },
    { GLenum::GL_BUFFER_GPU_ADDRESS_NV, "GL_BUFFER_GPU_ADDRESS_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV, "GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV" },
    { GLenum::GL_ELEMENT_ARRAY_UNIFIED_NV, "GL_ELEMENT_ARRAY_UNIFIED_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV, "GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV" },
    { GLenum::GL_VERTEX_ARRAY_ADDRESS_NV, "GL_VERTEX_ARRAY_ADDRESS_NV" },
    { GLenum::GL_NORMAL_ARRAY_ADDRESS_NV, "GL_NORMAL_ARRAY_ADDRESS_NV" },
    { GLenum::GL_COLOR_ARRAY_ADDRESS_NV, "GL_COLOR_ARRAY_ADDRESS_NV" },
    { GLenum::GL_INDEX_ARRAY_ADDRESS_NV, "GL_INDEX_ARRAY_ADDRESS_NV" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_ADDRESS_NV, "GL_TEXTURE_COORD_ARRAY_ADDRESS_NV" },
    { GLenum::GL_EDGE_FLAG_ARRAY_ADDRESS_NV, "GL_EDGE_FLAG_ARRAY_ADDRESS_NV" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV, "GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV" },
    { GLenum::GL_FOG_COORD_ARRAY_ADDRESS_NV, "GL_FOG_COORD_ARRAY_ADDRESS_NV" },
    { GLenum::GL_ELEMENT_ARRAY_ADDRESS_NV, "GL_ELEMENT_ARRAY_ADDRESS_NV" },
    { GLenum::GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV, "GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV" },
    { GLenum::GL_VERTEX_ARRAY_LENGTH_NV, "GL_VERTEX_ARRAY_LENGTH_NV" },
    { GLenum::GL_NORMAL_ARRAY_LENGTH_NV, "GL_NORMAL_ARRAY_LENGTH_NV" },
    { GLenum::GL_COLOR_ARRAY_LENGTH_NV, "GL_COLOR_ARRAY_LENGTH_NV" },
    { GLenum::GL_INDEX_ARRAY_LENGTH_NV, "GL_INDEX_ARRAY_LENGTH_NV" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_LENGTH_NV, "GL_TEXTURE_COORD_ARRAY_LENGTH_NV" },
    { GLenum::GL_EDGE_FLAG_ARRAY_LENGTH_NV, "GL_EDGE_FLAG_ARRAY_LENGTH_NV" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_LENGTH_NV, "GL_SECONDARY_COLOR_ARRAY_LENGTH_NV" },
    { GLenum::GL_FOG_COORD_ARRAY_LENGTH_NV, "GL_FOG_COORD_ARRAY_LENGTH_NV" },
    { GLenum::GL_ELEMENT_ARRAY_LENGTH_NV, "GL_ELEMENT_ARRAY_LENGTH_NV" },
    { GLenum::GL_GPU_ADDRESS_NV, "GL_GPU_ADDRESS_NV" },
    { GLenum::GL_MAX_SHADER_BUFFER_ADDRESS_NV, "GL_MAX_SHADER_BUFFER_ADDRESS_NV" },
    { GLenum::GL_COPY_READ_BUFFER, "GL_COPY_READ_BUFFER" },
    { GLenum::GL_COPY_WRITE_BUFFER, "GL_COPY_WRITE_BUFFER" },
    { GLenum::GL_MAX_IMAGE_UNITS, "GL_MAX_IMAGE_UNITS" },
    { GLenum::GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS, "GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS" },
    { GLenum::GL_IMAGE_BINDING_NAME, "GL_IMAGE_BINDING_NAME" },
    { GLenum::GL_IMAGE_BINDING_LEVEL, "GL_IMAGE_BINDING_LEVEL" },
    { GLenum::GL_IMAGE_BINDING_LAYERED, "GL_IMAGE_BINDING_LAYERED" },
    { GLenum::GL_IMAGE_BINDING_LAYER, "GL_IMAGE_BINDING_LAYER" },
    { GLenum::GL_IMAGE_BINDING_ACCESS, "GL_IMAGE_BINDING_ACCESS" },
    { GLenum::GL_DRAW_INDIRECT_BUFFER, "GL_DRAW_INDIRECT_BUFFER" },
    { GLenum::GL_DRAW_INDIRECT_UNIFIED_NV, "GL_DRAW_INDIRECT_UNIFIED_NV" },
    { GLenum::GL_DRAW_INDIRECT_ADDRESS_NV, "GL_DRAW_INDIRECT_ADDRESS_NV" },
    { GLenum::GL_DRAW_INDIRECT_LENGTH_NV, "GL_DRAW_INDIRECT_LENGTH_NV" },
    { GLenum::GL_DRAW_INDIRECT_BUFFER_BINDING, "GL_DRAW_INDIRECT_BUFFER_BINDING" },
    { GLenum::GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV, "GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV" },
    { GLenum::GL_MAX_PROGRAM_SUBROUTINE_NUM_NV, "GL_MAX_PROGRAM_SUBROUTINE_NUM_NV" },
    { GLenum::GL_DOUBLE_MAT2, "GL_DOUBLE_MAT2" },
    { GLenum::GL_DOUBLE_MAT3, "GL_DOUBLE_MAT3" },
    { GLenum::GL_DOUBLE_MAT4, "GL_DOUBLE_MAT4" },
    { GLenum::GL_DOUBLE_MAT2x3, "GL_DOUBLE_MAT2x3" },
    { GLenum::GL_DOUBLE_MAT2x4, "GL_DOUBLE_MAT2x4" },
    { GLenum::GL_DOUBLE_MAT3x2, "GL_DOUBLE_MAT3x2" },
    { GLenum::GL_DOUBLE_MAT3x4, "GL_DOUBLE_MAT3x4" },
    { GLenum::GL_DOUBLE_MAT4x2, "GL_DOUBLE_MAT4x2" },
    { GLenum::GL_DOUBLE_MAT4x3, "GL_DOUBLE_MAT4x3" },
    { GLenum::GL_VERTEX_BINDING_BUFFER, "GL_VERTEX_BINDING_BUFFER" },
    { GLenum::GL_RED_SNORM, "GL_RED_SNORM" },
    { GLenum::GL_RG_SNORM, "GL_RG_SNORM" },
    { GLenum::GL_RGB_SNORM, "GL_RGB_SNORM" },
    { GLenum::GL_RGBA_SNORM, "GL_RGBA_SNORM" },
    { GLenum::GL_R8_SNORM, "GL_R8_SNORM" },
    { GLenum::GL_RG8_SNORM, "GL_RG8_SNORM" },
    { GLenum::GL_RGB8_SNORM, "GL_RGB8_SNORM" },
    { GLenum::GL_RGBA8_SNORM, "GL_RGBA8_SNORM" },
    { GLenum::GL_R16_SNORM, "GL_R16_SNORM" },
    { GLenum::GL_RG16_SNORM, "GL_RG16_SNORM" },
    { GLenum::GL_RGB16_SNORM, "GL_RGB16_SNORM" },
    { GLenum::GL_RGBA16_SNORM, "GL_RGBA16_SNORM" },
    { GLenum::GL_SIGNED_NORMALIZED, "GL_SIGNED_NORMALIZED" },
    { GLenum::GL_PRIMITIVE_RESTART, "GL_PRIMITIVE_RESTART" },
    { GLenum::GL_PRIMITIVE_RESTART_INDEX, "GL_PRIMITIVE_RESTART_INDEX" },
    { GLenum::GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB, "GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB" },
    { GLenum::GL_INT8_NV, "GL_INT8_NV" },
    { GLenum::GL_INT8_VEC2_NV, "GL_INT8_VEC2_NV" },
    { GLenum::GL_INT8_VEC3_NV, "GL_INT8_VEC3_NV" },
    { GLenum::GL_INT8_VEC4_NV, "GL_INT8_VEC4_NV" },
    { GLenum::GL_INT16_NV, "GL_INT16_NV" },
    { GLenum::GL_INT16_VEC2_NV, "GL_INT16_VEC2_NV" },
    { GLenum::GL_INT16_VEC3_NV, "GL_INT16_VEC3_NV" },
    { GLenum::GL_INT16_VEC4_NV, "GL_INT16_VEC4_NV" },
    { GLenum::GL_INT64_VEC2_ARB, "GL_INT64_VEC2_ARB" },
    { GLenum::GL_INT64_VEC3_ARB, "GL_INT64_VEC3_ARB" },
    { GLenum::GL_INT64_VEC4_ARB, "GL_INT64_VEC4_ARB" },
    { GLenum::GL_UNSIGNED_INT8_NV, "GL_UNSIGNED_INT8_NV" },
    { GLenum::GL_UNSIGNED_INT8_VEC2_NV, "GL_UNSIGNED_INT8_VEC2_NV" },
    { GLenum::GL_UNSIGNED_INT8_VEC3_NV, "GL_UNSIGNED_INT8_VEC3_NV" },
    { GLenum::GL_UNSIGNED_INT8_VEC4_NV, "GL_UNSIGNED_INT8_VEC4_NV" },
    { GLenum::GL_UNSIGNED_INT16_NV, "GL_UNSIGNED_INT16_NV" },
    { GLenum::GL_UNSIGNED_INT16_VEC2_NV, "GL_UNSIGNED_INT16_VEC2_NV" },
    { GLenum::GL_UNSIGNED_INT16_VEC3_NV, "GL_UNSIGNED_INT16_VEC3_NV" },
    { GLenum::GL_UNSIGNED_INT16_VEC4_NV, "GL_UNSIGNED_INT16_VEC4_NV" },
    { GLenum::GL_UNSIGNED_INT64_VEC2_ARB, "GL_UNSIGNED_INT64_VEC2_ARB" },
    { GLenum::GL_UNSIGNED_INT64_VEC3_ARB, "GL_UNSIGNED_INT64_VEC3_ARB" },
    { GLenum::GL_UNSIGNED_INT64_VEC4_ARB, "GL_UNSIGNED_INT64_VEC4_ARB" },
    { GLenum::GL_FLOAT16_NV, "GL_FLOAT16_NV" },
    { GLenum::GL_FLOAT16_VEC2_NV, "GL_FLOAT16_VEC2_NV" },
    { GLenum::GL_FLOAT16_VEC3_NV, "GL_FLOAT16_VEC3_NV" },
    { GLenum::GL_FLOAT16_VEC4_NV, "GL_FLOAT16_VEC4_NV" },
    { GLenum::GL_DOUBLE_VEC2, "GL_DOUBLE_VEC2" },
    { GLenum::GL_DOUBLE_VEC3, "GL_DOUBLE_VEC3" },
    { GLenum::GL_DOUBLE_VEC4, "GL_DOUBLE_VEC4" },
    { GLenum::GL_SAMPLER_BUFFER_AMD, "GL_SAMPLER_BUFFER_AMD" },
    { GLenum::GL_INT_SAMPLER_BUFFER_AMD, "GL_INT_SAMPLER_BUFFER_AMD" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD, "GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD" },
    { GLenum::GL_TESSELLATION_MODE_AMD, "GL_TESSELLATION_MODE_AMD" },
    { GLenum::GL_TESSELLATION_FACTOR_AMD, "GL_TESSELLATION_FACTOR_AMD" },
    { GLenum::GL_DISCRETE_AMD, "GL_DISCRETE_AMD" },
    { GLenum::GL_CONTINUOUS_AMD, "GL_CONTINUOUS_AMD" },
    { GLenum::GL_TEXTURE_CUBE_MAP_ARRAY, "GL_TEXTURE_CUBE_MAP_ARRAY" },
    { GLenum::GL_TEXTURE_BINDING_CUBE_MAP_ARRAY, "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY" },
    { GLenum::GL_PROXY_TEXTURE_CUBE_MAP_ARRAY, "GL_PROXY_TEXTURE_CUBE_MAP_ARRAY" },
    { GLenum::GL_SAMPLER_CUBE_MAP_ARRAY, "GL_SAMPLER_CUBE_MAP_ARRAY" },
    { GLenum::GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW, "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW" },
    { GLenum::GL_INT_SAMPLER_CUBE_MAP_ARRAY, "GL_INT_SAMPLER_CUBE_MAP_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY, "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY" },
    { GLenum::GL_ALPHA_SNORM, "GL_ALPHA_SNORM" },
    { GLenum::GL_LUMINANCE_SNORM, "GL_LUMINANCE_SNORM" },
    { GLenum::GL_LUMINANCE_ALPHA_SNORM, "GL_LUMINANCE_ALPHA_SNORM" },
    { GLenum::GL_INTENSITY_SNORM, "GL_INTENSITY_SNORM" },
    { GLenum::GL_ALPHA8_SNORM, "GL_ALPHA8_SNORM" },
    { GLenum::GL_LUMINANCE8_SNORM, "GL_LUMINANCE8_SNORM" },
    { GLenum::GL_LUMINANCE8_ALPHA8_SNORM, "GL_LUMINANCE8_ALPHA8_SNORM" },
    { GLenum::GL_INTENSITY8_SNORM, "GL_INTENSITY8_SNORM" },
    { GLenum::GL_ALPHA16_SNORM, "GL_ALPHA16_SNORM" },
    { GLenum::GL_LUMINANCE16_SNORM, "GL_LUMINANCE16_SNORM" },
    { GLenum::GL_LUMINANCE16_ALPHA16_SNORM, "GL_LUMINANCE16_ALPHA16_SNORM" },
    { GLenum::GL_INTENSITY16_SNORM, "GL_INTENSITY16_SNORM" },
    { GLenum::GL_FACTOR_MIN_AMD, "GL_FACTOR_MIN_AMD" },
    { GLenum::GL_FACTOR_MAX_AMD, "GL_FACTOR_MAX_AMD" },
    { GLenum::GL_DEPTH_CLAMP_NEAR_AMD, "GL_DEPTH_CLAMP_NEAR_AMD" },
    { GLenum::GL_DEPTH_CLAMP_FAR_AMD, "GL_DEPTH_CLAMP_FAR_AMD" },
    { GLenum::GL_VIDEO_BUFFER_NV, "GL_VIDEO_BUFFER_NV" },
    { GLenum::GL_VIDEO_BUFFER_BINDING_NV, "GL_VIDEO_BUFFER_BINDING_NV" },
    { GLenum::GL_FIELD_UPPER_NV, "GL_FIELD_UPPER_NV" },
    { GLenum::GL_FIELD_LOWER_NV, "GL_FIELD_LOWER_NV" },
    { GLenum::GL_NUM_VIDEO_CAPTURE_STREAMS_NV, "GL_NUM_VIDEO_CAPTURE_STREAMS_NV" },
    { GLenum::GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV, "GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV" },
    { GLenum::GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV, "GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV" },
    { GLenum::GL_LAST_VIDEO_CAPTURE_STATUS_NV, "GL_LAST_VIDEO_CAPTURE_STATUS_NV" },
    { GLenum::GL_VIDEO_BUFFER_PITCH_NV, "GL_VIDEO_BUFFER_PITCH_NV" },
    { GLenum::GL_VIDEO_COLOR_CONVERSION_MATRIX_NV, "GL_VIDEO_COLOR_CONVERSION_MATRIX_NV" },
    { GLenum::GL_VIDEO_COLOR_CONVERSION_MAX_NV, "GL_VIDEO_COLOR_CONVERSION_MAX_NV" },
    { GLenum::GL_VIDEO_COLOR_CONVERSION_MIN_NV, "GL_VIDEO_COLOR_CONVERSION_MIN_NV" },
    { GLenum::GL_VIDEO_COLOR_CONVERSION_OFFSET_NV, "GL_VIDEO_COLOR_CONVERSION_OFFSET_NV" },
    { GLenum::GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV, "GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV" },
    { GLenum::GL_PARTIAL_SUCCESS_NV, "GL_PARTIAL_SUCCESS_NV" },
    { GLenum::GL_SUCCESS_NV, "GL_SUCCESS_NV" },
    { GLenum::GL_FAILURE_NV, "GL_FAILURE_NV" },
    { GLenum::GL_YCBYCR8_422_NV, "GL_YCBYCR8_422_NV" },
    { GLenum::GL_YCBAYCR8A_4224_NV, "GL_YCBAYCR8A_4224_NV" },
    { GLenum::GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV, "GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV" },
    { GLenum::GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV, "GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV" },
    { GLenum::GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV, "GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV" },
    { GLenum::GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV, "GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV" },
    { GLenum::GL_Z4Y12Z4CB12Z4CR12_444_NV, "GL_Z4Y12Z4CB12Z4CR12_444_NV" },
    { GLenum::GL_VIDEO_CAPTURE_FRAME_WIDTH_NV, "GL_VIDEO_CAPTURE_FRAME_WIDTH_NV" },
    { GLenum::GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV, "GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV" },
    { GLenum::GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV, "GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV" },
    { GLenum::GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV, "GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV" },
    { GLenum::GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV, "GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV" },
    { GLenum::GL_TEXTURE_COVERAGE_SAMPLES_NV, "GL_TEXTURE_COVERAGE_SAMPLES_NV" },
    { GLenum::GL_TEXTURE_COLOR_SAMPLES_NV, "GL_TEXTURE_COLOR_SAMPLES_NV" },
    { GLenum::GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX, "GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX" },
    { GLenum::GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX, "GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX" },
    { GLenum::GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX, "GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX" },
    { GLenum::GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX, "GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX" },
    { GLenum::GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX, "GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX" },
    { GLenum::GL_IMAGE_1D, "GL_IMAGE_1D" },
    { GLenum::GL_IMAGE_2D, "GL_IMAGE_2D" },
    { GLenum::GL_IMAGE_3D, "GL_IMAGE_3D" },
    { GLenum::GL_IMAGE_2D_RECT, "GL_IMAGE_2D_RECT" },
    { GLenum::GL_IMAGE_CUBE, "GL_IMAGE_CUBE" },
    { GLenum::GL_IMAGE_BUFFER, "GL_IMAGE_BUFFER" },
    { GLenum::GL_IMAGE_1D_ARRAY, "GL_IMAGE_1D_ARRAY" },
    { GLenum::GL_IMAGE_2D_ARRAY, "GL_IMAGE_2D_ARRAY" },
    { GLenum::GL_IMAGE_CUBE_MAP_ARRAY, "GL_IMAGE_CUBE_MAP_ARRAY" },
    { GLenum::GL_IMAGE_2D_MULTISAMPLE, "GL_IMAGE_2D_MULTISAMPLE" },
    { GLenum::GL_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_IMAGE_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_INT_IMAGE_1D, "GL_INT_IMAGE_1D" },
    { GLenum::GL_INT_IMAGE_2D, "GL_INT_IMAGE_2D" },
    { GLenum::GL_INT_IMAGE_3D, "GL_INT_IMAGE_3D" },
    { GLenum::GL_INT_IMAGE_2D_RECT, "GL_INT_IMAGE_2D_RECT" },
    { GLenum::GL_INT_IMAGE_CUBE, "GL_INT_IMAGE_CUBE" },
    { GLenum::GL_INT_IMAGE_BUFFER, "GL_INT_IMAGE_BUFFER" },
    { GLenum::GL_INT_IMAGE_1D_ARRAY, "GL_INT_IMAGE_1D_ARRAY" },
    { GLenum::GL_INT_IMAGE_2D_ARRAY, "GL_INT_IMAGE_2D_ARRAY" },
    { GLenum::GL_INT_IMAGE_CUBE_MAP_ARRAY, "GL_INT_IMAGE_CUBE_MAP_ARRAY" },
    { GLenum::GL_INT_IMAGE_2D_MULTISAMPLE, "GL_INT_IMAGE_2D_MULTISAMPLE" },
    { GLenum::GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_1D, "GL_UNSIGNED_INT_IMAGE_1D" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_2D, "GL_UNSIGNED_INT_IMAGE_2D" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_3D, "GL_UNSIGNED_INT_IMAGE_3D" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_2D_RECT, "GL_UNSIGNED_INT_IMAGE_2D_RECT" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_CUBE, "GL_UNSIGNED_INT_IMAGE_CUBE" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_BUFFER, "GL_UNSIGNED_INT_IMAGE_BUFFER" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_1D_ARRAY, "GL_UNSIGNED_INT_IMAGE_1D_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_2D_ARRAY, "GL_UNSIGNED_INT_IMAGE_2D_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY, "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE" },
    { GLenum::GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY, "GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_MAX_IMAGE_SAMPLES, "GL_MAX_IMAGE_SAMPLES" },
    { GLenum::GL_IMAGE_BINDING_FORMAT, "GL_IMAGE_BINDING_FORMAT" },
    { GLenum::GL_RGB10_A2UI, "GL_RGB10_A2UI" },
    { GLenum::GL_PATH_FORMAT_SVG_NV, "GL_PATH_FORMAT_SVG_NV" },
    { GLenum::GL_PATH_FORMAT_PS_NV, "GL_PATH_FORMAT_PS_NV" },
    { GLenum::GL_STANDARD_FONT_NAME_NV, "GL_STANDARD_FONT_NAME_NV" },
    { GLenum::GL_SYSTEM_FONT_NAME_NV, "GL_SYSTEM_FONT_NAME_NV" },
    { GLenum::GL_FILE_NAME_NV, "GL_FILE_NAME_NV" },
    { GLenum::GL_PATH_STROKE_WIDTH_NV, "GL_PATH_STROKE_WIDTH_NV" },
    { GLenum::GL_PATH_END_CAPS_NV, "GL_PATH_END_CAPS_NV" },
    { GLenum::GL_PATH_INITIAL_END_CAP_NV, "GL_PATH_INITIAL_END_CAP_NV" },
    { GLenum::GL_PATH_TERMINAL_END_CAP_NV, "GL_PATH_TERMINAL_END_CAP_NV" },
    { GLenum::GL_PATH_JOIN_STYLE_NV, "GL_PATH_JOIN_STYLE_NV" },
    { GLenum::GL_PATH_MITER_LIMIT_NV, "GL_PATH_MITER_LIMIT_NV" },
    { GLenum::GL_PATH_DASH_CAPS_NV, "GL_PATH_DASH_CAPS_NV" },
    { GLenum::GL_PATH_INITIAL_DASH_CAP_NV, "GL_PATH_INITIAL_DASH_CAP_NV" },
    { GLenum::GL_PATH_TERMINAL_DASH_CAP_NV, "GL_PATH_TERMINAL_DASH_CAP_NV" },
    { GLenum::GL_PATH_DASH_OFFSET_NV, "GL_PATH_DASH_OFFSET_NV" },
    { GLenum::GL_PATH_CLIENT_LENGTH_NV, "GL_PATH_CLIENT_LENGTH_NV" },
    { GLenum::GL_PATH_FILL_MODE_NV, "GL_PATH_FILL_MODE_NV" },
    { GLenum::GL_PATH_FILL_MASK_NV, "GL_PATH_FILL_MASK_NV" },
    { GLenum::GL_PATH_FILL_COVER_MODE_NV, "GL_PATH_FILL_COVER_MODE_NV" },
    { GLenum::GL_PATH_STROKE_COVER_MODE_NV, "GL_PATH_STROKE_COVER_MODE_NV" },
    { GLenum::GL_PATH_STROKE_MASK_NV, "GL_PATH_STROKE_MASK_NV" },
    { GLenum::GL_COUNT_UP_NV, "GL_COUNT_UP_NV" },
    { GLenum::GL_COUNT_DOWN_NV, "GL_COUNT_DOWN_NV" },
    { GLenum::GL_PATH_OBJECT_BOUNDING_BOX_NV, "GL_PATH_OBJECT_BOUNDING_BOX_NV" },
    { GLenum::GL_CONVEX_HULL_NV, "GL_CONVEX_HULL_NV" },
    { GLenum::GL_BOUNDING_BOX_NV, "GL_BOUNDING_BOX_NV" },
    { GLenum::GL_TRANSLATE_X_NV, "GL_TRANSLATE_X_NV" },
    { GLenum::GL_TRANSLATE_Y_NV, "GL_TRANSLATE_Y_NV" },
    { GLenum::GL_TRANSLATE_2D_NV, "GL_TRANSLATE_2D_NV" },
    { GLenum::GL_TRANSLATE_3D_NV, "GL_TRANSLATE_3D_NV" },
    { GLenum::GL_AFFINE_2D_NV, "GL_AFFINE_2D_NV" },
    { GLenum::GL_AFFINE_3D_NV, "GL_AFFINE_3D_NV" },
    { GLenum::GL_TRANSPOSE_AFFINE_2D_NV, "GL_TRANSPOSE_AFFINE_2D_NV" },
    { GLenum::GL_TRANSPOSE_AFFINE_3D_NV, "GL_TRANSPOSE_AFFINE_3D_NV" },
    { GLenum::GL_UTF8_NV, "GL_UTF8_NV" },
    { GLenum::GL_UTF16_NV, "GL_UTF16_NV" },
    { GLenum::GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV, "GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV" },
    { GLenum::GL_PATH_COMMAND_COUNT_NV, "GL_PATH_COMMAND_COUNT_NV" },
    { GLenum::GL_PATH_COORD_COUNT_NV, "GL_PATH_COORD_COUNT_NV" },
    { GLenum::GL_PATH_DASH_ARRAY_COUNT_NV, "GL_PATH_DASH_ARRAY_COUNT_NV" },
    { GLenum::GL_PATH_COMPUTED_LENGTH_NV, "GL_PATH_COMPUTED_LENGTH_NV" },
    { GLenum::GL_PATH_FILL_BOUNDING_BOX_NV, "GL_PATH_FILL_BOUNDING_BOX_NV" },
    { GLenum::GL_PATH_STROKE_BOUNDING_BOX_NV, "GL_PATH_STROKE_BOUNDING_BOX_NV" },
    { GLenum::GL_SQUARE_NV, "GL_SQUARE_NV" },
    { GLenum::GL_ROUND_NV, "GL_ROUND_NV" },
    { GLenum::GL_TRIANGULAR_NV, "GL_TRIANGULAR_NV" },
    { GLenum::GL_BEVEL_NV, "GL_BEVEL_NV" },
    { GLenum::GL_MITER_REVERT_NV, "GL_MITER_REVERT_NV" },
    { GLenum::GL_MITER_TRUNCATE_NV, "GL_MITER_TRUNCATE_NV" },
    { GLenum::GL_SKIP_MISSING_GLYPH_NV, "GL_SKIP_MISSING_GLYPH_NV" },
    { GLenum::GL_USE_MISSING_GLYPH_NV, "GL_USE_MISSING_GLYPH_NV" },
    { GLenum::GL_PATH_ERROR_POSITION_NV, "GL_PATH_ERROR_POSITION_NV" },
    { GLenum::GL_PATH_FOG_GEN_MODE_NV, "GL_PATH_FOG_GEN_MODE_NV" },
    { GLenum::GL_ACCUM_ADJACENT_PAIRS_NV, "GL_ACCUM_ADJACENT_PAIRS_NV" },
    { GLenum::GL_ADJACENT_PAIRS_NV, "GL_ADJACENT_PAIRS_NV" },
    { GLenum::GL_FIRST_TO_REST_NV, "GL_FIRST_TO_REST_NV" },
    { GLenum::GL_PATH_GEN_MODE_NV, "GL_PATH_GEN_MODE_NV" },
    { GLenum::GL_PATH_GEN_COEFF_NV, "GL_PATH_GEN_COEFF_NV" },
    { GLenum::GL_PATH_GEN_COLOR_FORMAT_NV, "GL_PATH_GEN_COLOR_FORMAT_NV" },
    { GLenum::GL_PATH_GEN_COMPONENTS_NV, "GL_PATH_GEN_COMPONENTS_NV" },
    { GLenum::GL_PATH_DASH_OFFSET_RESET_NV, "GL_PATH_DASH_OFFSET_RESET_NV" },
    { GLenum::GL_MOVE_TO_RESETS_NV, "GL_MOVE_TO_RESETS_NV" },
    { GLenum::GL_MOVE_TO_CONTINUES_NV, "GL_MOVE_TO_CONTINUES_NV" },
    { GLenum::GL_PATH_STENCIL_FUNC_NV, "GL_PATH_STENCIL_FUNC_NV" },
    { GLenum::GL_PATH_STENCIL_REF_NV, "GL_PATH_STENCIL_REF_NV" },
    { GLenum::GL_PATH_STENCIL_VALUE_MASK_NV, "GL_PATH_STENCIL_VALUE_MASK_NV" },
    { GLenum::GL_SCALED_RESOLVE_FASTEST_EXT, "GL_SCALED_RESOLVE_FASTEST_EXT" },
    { GLenum::GL_SCALED_RESOLVE_NICEST_EXT, "GL_SCALED_RESOLVE_NICEST_EXT" },
    { GLenum::GL_MIN_MAP_BUFFER_ALIGNMENT, "GL_MIN_MAP_BUFFER_ALIGNMENT" },
    { GLenum::GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV, "GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV" },
    { GLenum::GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV, "GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV" },
    { GLenum::GL_PATH_COVER_DEPTH_FUNC_NV, "GL_PATH_COVER_DEPTH_FUNC_NV" },
    { GLenum::GL_IMAGE_FORMAT_COMPATIBILITY_TYPE, "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE" },
    { GLenum::GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE" },
    { GLenum::GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS, "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS" },
    { GLenum::GL_MAX_VERTEX_IMAGE_UNIFORMS, "GL_MAX_VERTEX_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS, "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS, "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_GEOMETRY_IMAGE_UNIFORMS, "GL_MAX_GEOMETRY_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_FRAGMENT_IMAGE_UNIFORMS, "GL_MAX_FRAGMENT_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_COMBINED_IMAGE_UNIFORMS, "GL_MAX_COMBINED_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV, "GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV" },
    { GLenum::GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV, "GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV" },
    { GLenum::GL_SHADER_STORAGE_BUFFER, "GL_SHADER_STORAGE_BUFFER" },
    { GLenum::GL_SHADER_STORAGE_BUFFER_BINDING, "GL_SHADER_STORAGE_BUFFER_BINDING" },
    { GLenum::GL_SHADER_STORAGE_BUFFER_START, "GL_SHADER_STORAGE_BUFFER_START" },
    { GLenum::GL_SHADER_STORAGE_BUFFER_SIZE, "GL_SHADER_STORAGE_BUFFER_SIZE" },
    { GLenum::GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS, "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS, "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS, "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS, "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS, "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS, "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS, "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS" },
    { GLenum::GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS, "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS" },
    { GLenum::GL_MAX_SHADER_STORAGE_BLOCK_SIZE, "GL_MAX_SHADER_STORAGE_BLOCK_SIZE" },
    { GLenum::GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT, "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT" },
    { GLenum::GL_SYNC_X11_FENCE_EXT, "GL_SYNC_X11_FENCE_EXT" },
    { GLenum::GL_DEPTH_STENCIL_TEXTURE_MODE, "GL_DEPTH_STENCIL_TEXTURE_MODE" },
    { GLenum::GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS, "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS" },
    { GLenum::GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER, "GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER" },
    { GLenum::GL_DISPATCH_INDIRECT_BUFFER, "GL_DISPATCH_INDIRECT_BUFFER" },
    { GLenum::GL_DISPATCH_INDIRECT_BUFFER_BINDING, "GL_DISPATCH_INDIRECT_BUFFER_BINDING" },
    { GLenum::GL_CONTEXT_ROBUST_ACCESS, "GL_CONTEXT_ROBUST_ACCESS" },
    { GLenum::GL_COMPUTE_PROGRAM_NV, "GL_COMPUTE_PROGRAM_NV" },
    { GLenum::GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV, "GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV" },
    { GLenum::GL_TEXTURE_2D_MULTISAMPLE, "GL_TEXTURE_2D_MULTISAMPLE" },
    { GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE, "GL_PROXY_TEXTURE_2D_MULTISAMPLE" },
    { GLenum::GL_TEXTURE_2D_MULTISAMPLE_ARRAY, "GL_TEXTURE_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY, "GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_TEXTURE_BINDING_2D_MULTISAMPLE, "GL_TEXTURE_BINDING_2D_MULTISAMPLE" },
    { GLenum::GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY, "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_TEXTURE_SAMPLES, "GL_TEXTURE_SAMPLES" },
    { GLenum::GL_TEXTURE_FIXED_SAMPLE_LOCATIONS, "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS" },
    { GLenum::GL_SAMPLER_2D_MULTISAMPLE, "GL_SAMPLER_2D_MULTISAMPLE" },
    { GLenum::GL_INT_SAMPLER_2D_MULTISAMPLE, "GL_INT_SAMPLER_2D_MULTISAMPLE" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE, "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE" },
    { GLenum::GL_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_SAMPLER_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY, "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY" },
    { GLenum::GL_MAX_COLOR_TEXTURE_SAMPLES, "GL_MAX_COLOR_TEXTURE_SAMPLES" },
    { GLenum::GL_MAX_DEPTH_TEXTURE_SAMPLES, "GL_MAX_DEPTH_TEXTURE_SAMPLES" },
    { GLenum::GL_MAX_INTEGER_SAMPLES, "GL_MAX_INTEGER_SAMPLES" },
    { GLenum::GL_MAX_SERVER_WAIT_TIMEOUT, "GL_MAX_SERVER_WAIT_TIMEOUT" },
    { GLenum::GL_OBJECT_TYPE, "GL_OBJECT_TYPE" },
    { GLenum::GL_SYNC_CONDITION, "GL_SYNC_CONDITION" },
    { GLenum::GL_SYNC_STATUS, "GL_SYNC_STATUS" },
    { GLenum::GL_SYNC_FLAGS, "GL_SYNC_FLAGS" },
    { GLenum::GL_SYNC_FENCE, "GL_SYNC_FENCE" },
    { GLenum::GL_SYNC_GPU_COMMANDS_COMPLETE, "GL_SYNC_GPU_COMMANDS_COMPLETE" },
    { GLenum::GL_UNSIGNALED, "GL_UNSIGNALED" },
    { GLenum::GL_SIGNALED, "GL_SIGNALED" },
    { GLenum::GL_ALREADY_SIGNALED, "GL_ALREADY_SIGNALED" },
    { GLenum::GL_TIMEOUT_EXPIRED, "GL_TIMEOUT_EXPIRED" },
    { GLenum::GL_CONDITION_SATISFIED, "GL_CONDITION_SATISFIED" },
    { GLenum::GL_WAIT_FAILED, "GL_WAIT_FAILED" },
    { GLenum::GL_BUFFER_ACCESS_FLAGS, "GL_BUFFER_ACCESS_FLAGS" },
    { GLenum::GL_BUFFER_MAP_LENGTH, "GL_BUFFER_MAP_LENGTH" },
    { GLenum::GL_BUFFER_MAP_OFFSET, "GL_BUFFER_MAP_OFFSET" },
    { GLenum::GL_MAX_VERTEX_OUTPUT_COMPONENTS, "GL_MAX_VERTEX_OUTPUT_COMPONENTS" },
    { GLenum::GL_MAX_GEOMETRY_INPUT_COMPONENTS, "GL_MAX_GEOMETRY_INPUT_COMPONENTS" },
    { GLenum::GL_MAX_GEOMETRY_OUTPUT_COMPONENTS, "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS" },
    { GLenum::GL_MAX_FRAGMENT_INPUT_COMPONENTS, "GL_MAX_FRAGMENT_INPUT_COMPONENTS" },
    { GLenum::GL_CONTEXT_PROFILE_MASK, "GL_CONTEXT_PROFILE_MASK" },
    { GLenum::GL_UNPACK_COMPRESSED_BLOCK_WIDTH, "GL_UNPACK_COMPRESSED_BLOCK_WIDTH" },
    { GLenum::GL_UNPACK_COMPRESSED_BLOCK_HEIGHT, "GL_UNPACK_COMPRESSED_BLOCK_HEIGHT" },
    { GLenum::GL_UNPACK_COMPRESSED_BLOCK_DEPTH, "GL_UNPACK_COMPRESSED_BLOCK_DEPTH" },
    { GLenum::GL_UNPACK_COMPRESSED_BLOCK_SIZE, "GL_UNPACK_COMPRESSED_BLOCK_SIZE" },
    { GLenum::GL_PACK_COMPRESSED_BLOCK_WIDTH, "GL_PACK_COMPRESSED_BLOCK_WIDTH" },
    { GLenum::GL_PACK_COMPRESSED_BLOCK_HEIGHT, "GL_PACK_COMPRESSED_BLOCK_HEIGHT" },
    { GLenum::GL_PACK_COMPRESSED_BLOCK_DEPTH, "GL_PACK_COMPRESSED_BLOCK_DEPTH" },
    { GLenum::GL_PACK_COMPRESSED_BLOCK_SIZE, "GL_PACK_COMPRESSED_BLOCK_SIZE" },
    { GLenum::GL_TEXTURE_IMMUTABLE_FORMAT, "GL_TEXTURE_IMMUTABLE_FORMAT" },
    { GLenum::GL_MAX_DEBUG_MESSAGE_LENGTH, "GL_MAX_DEBUG_MESSAGE_LENGTH" },
    { GLenum::GL_MAX_DEBUG_LOGGED_MESSAGES, "GL_MAX_DEBUG_LOGGED_MESSAGES" },
    { GLenum::GL_DEBUG_LOGGED_MESSAGES, "GL_DEBUG_LOGGED_MESSAGES" },
    { GLenum::GL_DEBUG_SEVERITY_HIGH, "GL_DEBUG_SEVERITY_HIGH" },
    { GLenum::GL_DEBUG_SEVERITY_MEDIUM, "GL_DEBUG_SEVERITY_MEDIUM" },
    { GLenum::GL_DEBUG_SEVERITY_LOW, "GL_DEBUG_SEVERITY_LOW" },
    { GLenum::GL_DEBUG_CATEGORY_API_ERROR_AMD, "GL_DEBUG_CATEGORY_API_ERROR_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD, "GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_DEPRECATION_AMD, "GL_DEBUG_CATEGORY_DEPRECATION_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD, "GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_PERFORMANCE_AMD, "GL_DEBUG_CATEGORY_PERFORMANCE_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD, "GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_APPLICATION_AMD, "GL_DEBUG_CATEGORY_APPLICATION_AMD" },
    { GLenum::GL_DEBUG_CATEGORY_OTHER_AMD, "GL_DEBUG_CATEGORY_OTHER_AMD" },
    { GLenum::GL_DATA_BUFFER_AMD, "GL_DATA_BUFFER_AMD" },
    { GLenum::GL_PERFORMANCE_MONITOR_AMD, "GL_PERFORMANCE_MONITOR_AMD" },
    { GLenum::GL_QUERY_OBJECT_AMD, "GL_QUERY_OBJECT_AMD" },
    { GLenum::GL_VERTEX_ARRAY_OBJECT_AMD, "GL_VERTEX_ARRAY_OBJECT_AMD" },
    { GLenum::GL_SAMPLER_OBJECT_AMD, "GL_SAMPLER_OBJECT_AMD" },
    { GLenum::GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD, "GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD" },
    { GLenum::GL_QUERY_BUFFER, "GL_QUERY_BUFFER" },
    { GLenum::GL_QUERY_BUFFER_BINDING, "GL_QUERY_BUFFER_BINDING" },
    { GLenum::GL_QUERY_RESULT_NO_WAIT, "GL_QUERY_RESULT_NO_WAIT" },
    { GLenum::GL_VIRTUAL_PAGE_SIZE_X_AMD, "GL_VIRTUAL_PAGE_SIZE_X_AMD" },
    { GLenum::GL_VIRTUAL_PAGE_SIZE_Y_AMD, "GL_VIRTUAL_PAGE_SIZE_Y_AMD" },
    { GLenum::GL_VIRTUAL_PAGE_SIZE_Z_AMD, "GL_VIRTUAL_PAGE_SIZE_Z_AMD" },
    { GLenum::GL_MAX_SPARSE_TEXTURE_SIZE_AMD, "GL_MAX_SPARSE_TEXTURE_SIZE_AMD" },
    { GLenum::GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD, "GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD" },
    { GLenum::GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS, "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS" },
    { GLenum::GL_MIN_SPARSE_LEVEL_AMD, "GL_MIN_SPARSE_LEVEL_AMD" },
    { GLenum::GL_MIN_LOD_WARNING_AMD, "GL_MIN_LOD_WARNING_AMD" },
    { GLenum::GL_TEXTURE_BUFFER_OFFSET, "GL_TEXTURE_BUFFER_OFFSET" },
    { GLenum::GL_TEXTURE_BUFFER_SIZE, "GL_TEXTURE_BUFFER_SIZE" },
    { GLenum::GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT, "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT" },
    { GLenum::GL_STREAM_RASTERIZATION_AMD, "GL_STREAM_RASTERIZATION_AMD" },
    { GLenum::GL_VERTEX_ELEMENT_SWIZZLE_AMD, "GL_VERTEX_ELEMENT_SWIZZLE_AMD" },
    { GLenum::GL_VERTEX_ID_SWIZZLE_AMD, "GL_VERTEX_ID_SWIZZLE_AMD" },
    { GLenum::GL_TEXTURE_SPARSE_ARB, "GL_TEXTURE_SPARSE_ARB" },
    { GLenum::GL_VIRTUAL_PAGE_SIZE_INDEX_ARB, "GL_VIRTUAL_PAGE_SIZE_INDEX_ARB" },
    { GLenum::GL_NUM_VIRTUAL_PAGE_SIZES_ARB, "GL_NUM_VIRTUAL_PAGE_SIZES_ARB" },
    { GLenum::GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB, "GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB" },
    { GLenum::GL_NUM_SPARSE_LEVELS_ARB, "GL_NUM_SPARSE_LEVELS_ARB" },
    { GLenum::GL_MAX_SHADER_COMPILER_THREADS_ARB, "GL_MAX_SHADER_COMPILER_THREADS_ARB" },
    { GLenum::GL_COMPLETION_STATUS_ARB, "GL_COMPLETION_STATUS_ARB" },
    { GLenum::GL_COMPUTE_SHADER, "GL_COMPUTE_SHADER" },
    { GLenum::GL_MAX_COMPUTE_UNIFORM_BLOCKS, "GL_MAX_COMPUTE_UNIFORM_BLOCKS" },
    { GLenum::GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS, "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS" },
    { GLenum::GL_MAX_COMPUTE_IMAGE_UNIFORMS, "GL_MAX_COMPUTE_IMAGE_UNIFORMS" },
    { GLenum::GL_MAX_COMPUTE_WORK_GROUP_COUNT, "GL_MAX_COMPUTE_WORK_GROUP_COUNT" },
    { GLenum::GL_MAX_COMPUTE_WORK_GROUP_SIZE, "GL_MAX_COMPUTE_WORK_GROUP_SIZE" },
    { GLenum::GL_COMPRESSED_R11_EAC, "GL_COMPRESSED_R11_EAC" },
    { GLenum::GL_COMPRESSED_SIGNED_R11_EAC, "GL_COMPRESSED_SIGNED_R11_EAC" },
    { GLenum::GL_COMPRESSED_RG11_EAC, "GL_COMPRESSED_RG11_EAC" },
    { GLenum::GL_COMPRESSED_SIGNED_RG11_EAC, "GL_COMPRESSED_SIGNED_RG11_EAC" },
    { GLenum::GL_COMPRESSED_RGB8_ETC2, "GL_COMPRESSED_RGB8_ETC2" },
    { GLenum::GL_COMPRESSED_SRGB8_ETC2, "GL_COMPRESSED_SRGB8_ETC2" },
    { GLenum::GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2" },
    { GLenum::GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2, "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2" },
    { GLenum::GL_COMPRESSED_RGBA8_ETC2_EAC, "GL_COMPRESSED_RGBA8_ETC2_EAC" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC, "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC" },
    { GLenum::GL_BLEND_PREMULTIPLIED_SRC_NV, "GL_BLEND_PREMULTIPLIED_SRC_NV" },
    { GLenum::GL_BLEND_OVERLAP_NV, "GL_BLEND_OVERLAP_NV" },
    { GLenum::GL_UNCORRELATED_NV, "GL_UNCORRELATED_NV" },
    { GLenum::GL_DISJOINT_NV, "GL_DISJOINT_NV" },
    { GLenum::GL_CONJOINT_NV, "GL_CONJOINT_NV" },
    { GLenum::GL_BLEND_ADVANCED_COHERENT_KHR, "GL_BLEND_ADVANCED_COHERENT_KHR" },
    { GLenum::GL_SRC_NV, "GL_SRC_NV" },
    { GLenum::GL_DST_NV, "GL_DST_NV" },
    { GLenum::GL_SRC_OVER_NV, "GL_SRC_OVER_NV" },
    { GLenum::GL_DST_OVER_NV, "GL_DST_OVER_NV" },
    { GLenum::GL_SRC_IN_NV, "GL_SRC_IN_NV" },
    { GLenum::GL_DST_IN_NV, "GL_DST_IN_NV" },
    { GLenum::GL_SRC_OUT_NV, "GL_SRC_OUT_NV" },
    { GLenum::GL_DST_OUT_NV, "GL_DST_OUT_NV" },
    { GLenum::GL_SRC_ATOP_NV, "GL_SRC_ATOP_NV" },
    { GLenum::GL_DST_ATOP_NV, "GL_DST_ATOP_NV" },
    { GLenum::GL_PLUS_NV, "GL_PLUS_NV" },
    { GLenum::GL_PLUS_DARKER_NV, "GL_PLUS_DARKER_NV" },
    { GLenum::GL_MULTIPLY_KHR, "GL_MULTIPLY_KHR" },
    { GLenum::GL_SCREEN_KHR, "GL_SCREEN_KHR" },
    { GLenum::GL_OVERLAY_KHR, "GL_OVERLAY_KHR" },
    { GLenum::GL_DARKEN_KHR, "GL_DARKEN_KHR" },
    { GLenum::GL_LIGHTEN_KHR, "GL_LIGHTEN_KHR" },
    { GLenum::GL_COLORDODGE_KHR, "GL_COLORDODGE_KHR" },
    { GLenum::GL_COLORBURN_KHR, "GL_COLORBURN_KHR" },
    { GLenum::GL_HARDLIGHT_KHR, "GL_HARDLIGHT_KHR" },
    { GLenum::GL_SOFTLIGHT_KHR, "GL_SOFTLIGHT_KHR" },
    { GLenum::GL_DIFFERENCE_KHR, "GL_DIFFERENCE_KHR" },
    { GLenum::GL_MINUS_NV, "GL_MINUS_NV" },
    { GLenum::GL_EXCLUSION_KHR, "GL_EXCLUSION_KHR" },
    { GLenum::GL_CONTRAST_NV, "GL_CONTRAST_NV" },
    { GLenum::GL_INVERT_RGB_NV, "GL_INVERT_RGB_NV" },
    { GLenum::GL_LINEARDODGE_NV, "GL_LINEARDODGE_NV" },
    { GLenum::GL_LINEARBURN_NV, "GL_LINEARBURN_NV" },
    { GLenum::GL_VIVIDLIGHT_NV, "GL_VIVIDLIGHT_NV" },
    { GLenum::GL_LINEARLIGHT_NV, "GL_LINEARLIGHT_NV" },
    { GLenum::GL_PINLIGHT_NV, "GL_PINLIGHT_NV" },
    { GLenum::GL_HARDMIX_NV, "GL_HARDMIX_NV" },
    { GLenum::GL_HSL_HUE_KHR, "GL_HSL_HUE_KHR" },
    { GLenum::GL_HSL_SATURATION_KHR, "GL_HSL_SATURATION_KHR" },
    { GLenum::GL_HSL_COLOR_KHR, "GL_HSL_COLOR_KHR" },
    { GLenum::GL_HSL_LUMINOSITY_KHR, "GL_HSL_LUMINOSITY_KHR" },
    { GLenum::GL_PLUS_CLAMPED_NV, "GL_PLUS_CLAMPED_NV" },
    { GLenum::GL_PLUS_CLAMPED_ALPHA_NV, "GL_PLUS_CLAMPED_ALPHA_NV" },
    { GLenum::GL_MINUS_CLAMPED_NV, "GL_MINUS_CLAMPED_NV" },
    { GLenum::GL_INVERT_OVG_NV, "GL_INVERT_OVG_NV" },
    { GLenum::GL_PURGED_CONTEXT_RESET_NV, "GL_PURGED_CONTEXT_RESET_NV" },
    { GLenum::GL_PRIMITIVE_BOUNDING_BOX_ARB, "GL_PRIMITIVE_BOUNDING_BOX_ARB" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER, "GL_ATOMIC_COUNTER_BUFFER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_BINDING, "GL_ATOMIC_COUNTER_BUFFER_BINDING" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_START, "GL_ATOMIC_COUNTER_BUFFER_START" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_SIZE, "GL_ATOMIC_COUNTER_BUFFER_SIZE" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE, "GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES, "GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER, "GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER" },
    { GLenum::GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS, "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS, "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS, "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS, "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_MAX_VERTEX_ATOMIC_COUNTERS, "GL_MAX_VERTEX_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS, "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS, "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_GEOMETRY_ATOMIC_COUNTERS, "GL_MAX_GEOMETRY_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_FRAGMENT_ATOMIC_COUNTERS, "GL_MAX_FRAGMENT_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_COMBINED_ATOMIC_COUNTERS, "GL_MAX_COMBINED_ATOMIC_COUNTERS" },
    { GLenum::GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE, "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE" },
    { GLenum::GL_ACTIVE_ATOMIC_COUNTER_BUFFERS, "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS" },
    { GLenum::GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX, "GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX" },
    { GLenum::GL_UNSIGNED_INT_ATOMIC_COUNTER, "GL_UNSIGNED_INT_ATOMIC_COUNTER" },
    { GLenum::GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS, "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS" },
    { GLenum::GL_FRAGMENT_COVERAGE_TO_COLOR_NV, "GL_FRAGMENT_COVERAGE_TO_COLOR_NV" },
    { GLenum::GL_FRAGMENT_COVERAGE_COLOR_NV, "GL_FRAGMENT_COVERAGE_COLOR_NV" },
    { GLenum::GL_DEBUG_OUTPUT, "GL_DEBUG_OUTPUT" },
    { GLenum::GL_UNIFORM, "GL_UNIFORM" },
    { GLenum::GL_UNIFORM_BLOCK, "GL_UNIFORM_BLOCK" },
    { GLenum::GL_PROGRAM_INPUT, "GL_PROGRAM_INPUT" },
    { GLenum::GL_PROGRAM_OUTPUT, "GL_PROGRAM_OUTPUT" },
    { GLenum::GL_BUFFER_VARIABLE, "GL_BUFFER_VARIABLE" },
    { GLenum::GL_SHADER_STORAGE_BLOCK, "GL_SHADER_STORAGE_BLOCK" },
    { GLenum::GL_IS_PER_PATCH, "GL_IS_PER_PATCH" },
    { GLenum::GL_VERTEX_SUBROUTINE, "GL_VERTEX_SUBROUTINE" },
    { GLenum::GL_TESS_CONTROL_SUBROUTINE, "GL_TESS_CONTROL_SUBROUTINE" },
    { GLenum::GL_TESS_EVALUATION_SUBROUTINE, "GL_TESS_EVALUATION_SUBROUTINE" },
    { GLenum::GL_GEOMETRY_SUBROUTINE, "GL_GEOMETRY_SUBROUTINE" },
    { GLenum::GL_FRAGMENT_SUBROUTINE, "GL_FRAGMENT_SUBROUTINE" },
    { GLenum::GL_COMPUTE_SUBROUTINE, "GL_COMPUTE_SUBROUTINE" },
    { GLenum::GL_VERTEX_SUBROUTINE_UNIFORM, "GL_VERTEX_SUBROUTINE_UNIFORM" },
    { GLenum::GL_TESS_CONTROL_SUBROUTINE_UNIFORM, "GL_TESS_CONTROL_SUBROUTINE_UNIFORM" },
    { GLenum::GL_TESS_EVALUATION_SUBROUTINE_UNIFORM, "GL_TESS_EVALUATION_SUBROUTINE_UNIFORM" },
    { GLenum::GL_GEOMETRY_SUBROUTINE_UNIFORM, "GL_GEOMETRY_SUBROUTINE_UNIFORM" },
    { GLenum::GL_FRAGMENT_SUBROUTINE_UNIFORM, "GL_FRAGMENT_SUBROUTINE_UNIFORM" },
    { GLenum::GL_COMPUTE_SUBROUTINE_UNIFORM, "GL_COMPUTE_SUBROUTINE_UNIFORM" },
    { GLenum::GL_TRANSFORM_FEEDBACK_VARYING, "GL_TRANSFORM_FEEDBACK_VARYING" },
    { GLenum::GL_ACTIVE_RESOURCES, "GL_ACTIVE_RESOURCES" },
    { GLenum::GL_MAX_NAME_LENGTH, "GL_MAX_NAME_LENGTH" },
    { GLenum::GL_MAX_NUM_ACTIVE_VARIABLES, "GL_MAX_NUM_ACTIVE_VARIABLES" },
    { GLenum::GL_MAX_NUM_COMPATIBLE_SUBROUTINES, "GL_MAX_NUM_COMPATIBLE_SUBROUTINES" },
    { GLenum::GL_NAME_LENGTH, "GL_NAME_LENGTH" },
    { GLenum::GL_TYPE, "GL_TYPE" },
    { GLenum::GL_ARRAY_SIZE, "GL_ARRAY_SIZE" },
    { GLenum::GL_OFFSET, "GL_OFFSET" },
    { GLenum::GL_BLOCK_INDEX, "GL_BLOCK_INDEX" },
    { GLenum::GL_ARRAY_STRIDE, "GL_ARRAY_STRIDE" },
    { GLenum::GL_MATRIX_STRIDE, "GL_MATRIX_STRIDE" },
    { GLenum::GL_IS_ROW_MAJOR, "GL_IS_ROW_MAJOR" },
    { GLenum::GL_ATOMIC_COUNTER_BUFFER_INDEX, "GL_ATOMIC_COUNTER_BUFFER_INDEX" },
    { GLenum::GL_BUFFER_BINDING, "GL_BUFFER_BINDING" },
    { GLenum::GL_BUFFER_DATA_SIZE, "GL_BUFFER_DATA_SIZE" },
    { GLenum::GL_NUM_ACTIVE_VARIABLES, "GL_NUM_ACTIVE_VARIABLES" },
    { GLenum::GL_ACTIVE_VARIABLES, "GL_ACTIVE_VARIABLES" },
    { GLenum::GL_REFERENCED_BY_VERTEX_SHADER, "GL_REFERENCED_BY_VERTEX_SHADER" },
    { GLenum::GL_REFERENCED_BY_TESS_CONTROL_SHADER, "GL_REFERENCED_BY_TESS_CONTROL_SHADER" },
    { GLenum::GL_REFERENCED_BY_TESS_EVALUATION_SHADER, "GL_REFERENCED_BY_TESS_EVALUATION_SHADER" },
    { GLenum::GL_REFERENCED_BY_GEOMETRY_SHADER, "GL_REFERENCED_BY_GEOMETRY_SHADER" },
    { GLenum::GL_REFERENCED_BY_FRAGMENT_SHADER, "GL_REFERENCED_BY_FRAGMENT_SHADER" },
    { GLenum::GL_REFERENCED_BY_COMPUTE_SHADER, "GL_REFERENCED_BY_COMPUTE_SHADER" },
    { GLenum::GL_TOP_LEVEL_ARRAY_SIZE, "GL_TOP_LEVEL_ARRAY_SIZE" },
    { GLenum::GL_TOP_LEVEL_ARRAY_STRIDE, "GL_TOP_LEVEL_ARRAY_STRIDE" },
    { GLenum::GL_LOCATION, "GL_LOCATION" },
    { GLenum::GL_LOCATION_INDEX, "GL_LOCATION_INDEX" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT_WIDTH, "GL_FRAMEBUFFER_DEFAULT_WIDTH" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT_HEIGHT, "GL_FRAMEBUFFER_DEFAULT_HEIGHT" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT_LAYERS, "GL_FRAMEBUFFER_DEFAULT_LAYERS" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT_SAMPLES, "GL_FRAMEBUFFER_DEFAULT_SAMPLES" },
    { GLenum::GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS, "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS" },
    { GLenum::GL_MAX_FRAMEBUFFER_WIDTH, "GL_MAX_FRAMEBUFFER_WIDTH" },
    { GLenum::GL_MAX_FRAMEBUFFER_HEIGHT, "GL_MAX_FRAMEBUFFER_HEIGHT" },
    { GLenum::GL_MAX_FRAMEBUFFER_LAYERS, "GL_MAX_FRAMEBUFFER_LAYERS" },
    { GLenum::GL_MAX_FRAMEBUFFER_SAMPLES, "GL_MAX_FRAMEBUFFER_SAMPLES" },
    { GLenum::GL_RASTER_MULTISAMPLE_EXT, "GL_RASTER_MULTISAMPLE_EXT" },
    { GLenum::GL_RASTER_SAMPLES_EXT, "GL_RASTER_SAMPLES_EXT" },
    { GLenum::GL_MAX_RASTER_SAMPLES_EXT, "GL_MAX_RASTER_SAMPLES_EXT" },
    { GLenum::GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT, "GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT" },
    { GLenum::GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT, "GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT" },
    { GLenum::GL_EFFECTIVE_RASTER_SAMPLES_EXT, "GL_EFFECTIVE_RASTER_SAMPLES_EXT" },
    { GLenum::GL_DEPTH_SAMPLES_NV, "GL_DEPTH_SAMPLES_NV" },
    { GLenum::GL_STENCIL_SAMPLES_NV, "GL_STENCIL_SAMPLES_NV" },
    { GLenum::GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV, "GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV" },
    { GLenum::GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV, "GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV" },
    { GLenum::GL_COVERAGE_MODULATION_TABLE_NV, "GL_COVERAGE_MODULATION_TABLE_NV" },
    { GLenum::GL_COVERAGE_MODULATION_NV, "GL_COVERAGE_MODULATION_NV" },
    { GLenum::GL_COVERAGE_MODULATION_TABLE_SIZE_NV, "GL_COVERAGE_MODULATION_TABLE_SIZE_NV" },
    { GLenum::GL_WARP_SIZE_NV, "GL_WARP_SIZE_NV" },
    { GLenum::GL_WARPS_PER_SM_NV, "GL_WARPS_PER_SM_NV" },
    { GLenum::GL_SM_COUNT_NV, "GL_SM_COUNT_NV" },
    { GLenum::GL_FILL_RECTANGLE_NV, "GL_FILL_RECTANGLE_NV" },
    { GLenum::GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB, "GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB" },
    { GLenum::GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB, "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB" },
    { GLenum::GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB, "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB" },
    { GLenum::GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB, "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB" },
    { GLenum::GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB, "GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB" },
    { GLenum::GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB, "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB" },
    { GLenum::GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB, "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB" },
    { GLenum::GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB, "GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB" },
    { GLenum::GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB, "GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB" },
    { GLenum::GL_CONSERVATIVE_RASTERIZATION_NV, "GL_CONSERVATIVE_RASTERIZATION_NV" },
    { GLenum::GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV, "GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV" },
    { GLenum::GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV, "GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV" },
    { GLenum::GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV, "GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV" },
    { GLenum::GL_LOCATION_COMPONENT, "GL_LOCATION_COMPONENT" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_INDEX, "GL_TRANSFORM_FEEDBACK_BUFFER_INDEX" },
    { GLenum::GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE, "GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE" },
    { GLenum::GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV, "GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV, "GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_X_NV, "GL_VIEWPORT_SWIZZLE_X_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_Y_NV, "GL_VIEWPORT_SWIZZLE_Y_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_Z_NV, "GL_VIEWPORT_SWIZZLE_Z_NV" },
    { GLenum::GL_VIEWPORT_SWIZZLE_W_NV, "GL_VIEWPORT_SWIZZLE_W_NV" },
    { GLenum::GL_CLIP_ORIGIN, "GL_CLIP_ORIGIN" },
    { GLenum::GL_CLIP_DEPTH_MODE, "GL_CLIP_DEPTH_MODE" },
    { GLenum::GL_NEGATIVE_ONE_TO_ONE, "GL_NEGATIVE_ONE_TO_ONE" },
    { GLenum::GL_ZERO_TO_ONE, "GL_ZERO_TO_ONE" },
    { GLenum::GL_CLEAR_TEXTURE, "GL_CLEAR_TEXTURE" },
    { GLenum::GL_TEXTURE_REDUCTION_MODE_ARB, "GL_TEXTURE_REDUCTION_MODE_ARB" },
    { GLenum::GL_WEIGHTED_AVERAGE_ARB, "GL_WEIGHTED_AVERAGE_ARB" },
    { GLenum::GL_FONT_GLYPHS_AVAILABLE_NV, "GL_FONT_GLYPHS_AVAILABLE_NV" },
    { GLenum::GL_FONT_TARGET_UNAVAILABLE_NV, "GL_FONT_TARGET_UNAVAILABLE_NV" },
    { GLenum::GL_FONT_UNAVAILABLE_NV, "GL_FONT_UNAVAILABLE_NV" },
    { GLenum::GL_FONT_UNINTELLIGIBLE_NV, "GL_FONT_UNINTELLIGIBLE_NV" },
    { GLenum::GL_STANDARD_FONT_FORMAT_NV, "GL_STANDARD_FONT_FORMAT_NV" },
    { GLenum::GL_FRAGMENT_INPUT_NV, "GL_FRAGMENT_INPUT_NV" },
    { GLenum::GL_UNIFORM_BUFFER_UNIFIED_NV, "GL_UNIFORM_BUFFER_UNIFIED_NV" },
    { GLenum::GL_UNIFORM_BUFFER_ADDRESS_NV, "GL_UNIFORM_BUFFER_ADDRESS_NV" },
    { GLenum::GL_UNIFORM_BUFFER_LENGTH_NV, "GL_UNIFORM_BUFFER_LENGTH_NV" },
    { GLenum::GL_MULTISAMPLES_NV, "GL_MULTISAMPLES_NV" },
    { GLenum::GL_SUPERSAMPLE_SCALE_X_NV, "GL_SUPERSAMPLE_SCALE_X_NV" },
    { GLenum::GL_SUPERSAMPLE_SCALE_Y_NV, "GL_SUPERSAMPLE_SCALE_Y_NV" },
    { GLenum::GL_CONFORMANT_NV, "GL_CONFORMANT_NV" },
    { GLenum::GL_CONSERVATIVE_RASTER_DILATE_NV, "GL_CONSERVATIVE_RASTER_DILATE_NV" },
    { GLenum::GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV, "GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV" },
    { GLenum::GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV, "GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV" },
    { GLenum::GL_VIEWPORT_POSITION_W_SCALE_NV, "GL_VIEWPORT_POSITION_W_SCALE_NV" },
    { GLenum::GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV, "GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV" },
    { GLenum::GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV, "GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV" },
    { GLenum::GL_NUM_SAMPLE_COUNTS, "GL_NUM_SAMPLE_COUNTS" },
    { GLenum::GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB, "GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB" },
    { GLenum::GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB, "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_4x4_KHR, "GL_COMPRESSED_RGBA_ASTC_4x4_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_5x4_KHR, "GL_COMPRESSED_RGBA_ASTC_5x4_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_5x5_KHR, "GL_COMPRESSED_RGBA_ASTC_5x5_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_6x5_KHR, "GL_COMPRESSED_RGBA_ASTC_6x5_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_6x6_KHR, "GL_COMPRESSED_RGBA_ASTC_6x6_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_8x5_KHR, "GL_COMPRESSED_RGBA_ASTC_8x5_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_8x6_KHR, "GL_COMPRESSED_RGBA_ASTC_8x6_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_8x8_KHR, "GL_COMPRESSED_RGBA_ASTC_8x8_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_10x5_KHR, "GL_COMPRESSED_RGBA_ASTC_10x5_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_10x6_KHR, "GL_COMPRESSED_RGBA_ASTC_10x6_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_10x8_KHR, "GL_COMPRESSED_RGBA_ASTC_10x8_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_10x10_KHR, "GL_COMPRESSED_RGBA_ASTC_10x10_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_12x10_KHR, "GL_COMPRESSED_RGBA_ASTC_12x10_KHR" },
    { GLenum::GL_COMPRESSED_RGBA_ASTC_12x12_KHR, "GL_COMPRESSED_RGBA_ASTC_12x12_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR" },
    { GLenum::GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR, "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR" },
    { GLenum::GL_PERFQUERY_COUNTER_EVENT_INTEL, "GL_PERFQUERY_COUNTER_EVENT_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL, "GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL, "GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL, "GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_RAW_INTEL, "GL_PERFQUERY_COUNTER_RAW_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL, "GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL, "GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL, "GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL, "GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL, "GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL, "GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL" },
    { GLenum::GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL, "GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL, "GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL" },
    { GLenum::GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL, "GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL" },
    { GLenum::GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL, "GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL" },
    { GLenum::GL_CONSERVATIVE_RASTER_MODE_NV, "GL_CONSERVATIVE_RASTER_MODE_NV" },
    { GLenum::GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV, "GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV" },
    { GLenum::GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV, "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR" },
    { GLenum::GL_MAX_VIEWS_OVR, "GL_MAX_VIEWS_OVR" },
    { GLenum::GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR, "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR" },
    { GLenum::GL_RASTER_POSITION_UNCLIPPED_IBM, "GL_RASTER_POSITION_UNCLIPPED_IBM" },
    { GLenum::GL_CULL_VERTEX_IBM, "GL_CULL_VERTEX_IBM" },
    { GLenum::GL_ALL_STATIC_DATA_IBM, "GL_ALL_STATIC_DATA_IBM" },
    { GLenum::GL_STATIC_VERTEX_ARRAY_IBM, "GL_STATIC_VERTEX_ARRAY_IBM" },
    { GLenum::GL_VERTEX_ARRAY_LIST_IBM, "GL_VERTEX_ARRAY_LIST_IBM" },
    { GLenum::GL_NORMAL_ARRAY_LIST_IBM, "GL_NORMAL_ARRAY_LIST_IBM" },
    { GLenum::GL_COLOR_ARRAY_LIST_IBM, "GL_COLOR_ARRAY_LIST_IBM" },
    { GLenum::GL_INDEX_ARRAY_LIST_IBM, "GL_INDEX_ARRAY_LIST_IBM" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_LIST_IBM, "GL_TEXTURE_COORD_ARRAY_LIST_IBM" },
    { GLenum::GL_EDGE_FLAG_ARRAY_LIST_IBM, "GL_EDGE_FLAG_ARRAY_LIST_IBM" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_LIST_IBM, "GL_FOG_COORDINATE_ARRAY_LIST_IBM" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_LIST_IBM, "GL_SECONDARY_COLOR_ARRAY_LIST_IBM" },
    { GLenum::GL_VERTEX_ARRAY_LIST_STRIDE_IBM, "GL_VERTEX_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_NORMAL_ARRAY_LIST_STRIDE_IBM, "GL_NORMAL_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_COLOR_ARRAY_LIST_STRIDE_IBM, "GL_COLOR_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_INDEX_ARRAY_LIST_STRIDE_IBM, "GL_INDEX_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM, "GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM, "GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM, "GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM, "GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM" },
    { GLenum::GL_PREFER_DOUBLEBUFFER_HINT_PGI, "GL_PREFER_DOUBLEBUFFER_HINT_PGI" },
    { GLenum::GL_CONSERVE_MEMORY_HINT_PGI, "GL_CONSERVE_MEMORY_HINT_PGI" },
    { GLenum::GL_RECLAIM_MEMORY_HINT_PGI, "GL_RECLAIM_MEMORY_HINT_PGI" },
    { GLenum::GL_NATIVE_GRAPHICS_HANDLE_PGI, "GL_NATIVE_GRAPHICS_HANDLE_PGI" },
    { GLenum::GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI, "GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI" },
    { GLenum::GL_NATIVE_GRAPHICS_END_HINT_PGI, "GL_NATIVE_GRAPHICS_END_HINT_PGI" },
    { GLenum::GL_ALWAYS_FAST_HINT_PGI, "GL_ALWAYS_FAST_HINT_PGI" },
    { GLenum::GL_ALWAYS_SOFT_HINT_PGI, "GL_ALWAYS_SOFT_HINT_PGI" },
    { GLenum::GL_ALLOW_DRAW_OBJ_HINT_PGI, "GL_ALLOW_DRAW_OBJ_HINT_PGI" },
    { GLenum::GL_ALLOW_DRAW_WIN_HINT_PGI, "GL_ALLOW_DRAW_WIN_HINT_PGI" },
    { GLenum::GL_ALLOW_DRAW_FRG_HINT_PGI, "GL_ALLOW_DRAW_FRG_HINT_PGI" },
    { GLenum::GL_ALLOW_DRAW_MEM_HINT_PGI, "GL_ALLOW_DRAW_MEM_HINT_PGI" },
    { GLenum::GL_STRICT_DEPTHFUNC_HINT_PGI, "GL_STRICT_DEPTHFUNC_HINT_PGI" },
    { GLenum::GL_STRICT_LIGHTING_HINT_PGI, "GL_STRICT_LIGHTING_HINT_PGI" },
    { GLenum::GL_STRICT_SCISSOR_HINT_PGI, "GL_STRICT_SCISSOR_HINT_PGI" },
    { GLenum::GL_FULL_STIPPLE_HINT_PGI, "GL_FULL_STIPPLE_HINT_PGI" },
    { GLenum::GL_CLIP_NEAR_HINT_PGI, "GL_CLIP_NEAR_HINT_PGI" },
    { GLenum::GL_CLIP_FAR_HINT_PGI, "GL_CLIP_FAR_HINT_PGI" },
    { GLenum::GL_WIDE_LINE_HINT_PGI, "GL_WIDE_LINE_HINT_PGI" },
    { GLenum::GL_BACK_NORMALS_HINT_PGI, "GL_BACK_NORMALS_HINT_PGI" },
    { GLenum::GL_VERTEX_DATA_HINT_PGI, "GL_VERTEX_DATA_HINT_PGI" },
    { GLenum::GL_VERTEX_CONSISTENT_HINT_PGI, "GL_VERTEX_CONSISTENT_HINT_PGI" },
    { GLenum::GL_MATERIAL_SIDE_HINT_PGI, "GL_MATERIAL_SIDE_HINT_PGI" },
    { GLenum::GL_MAX_VERTEX_HINT_PGI, "GL_MAX_VERTEX_HINT_PGI" },
    { GLenum::GL_QUERY_ALL_EVENT_BITS_AMD, "GL_QUERY_ALL_EVENT_BITS_AMD" }
};


} // namespace glbinding
