---
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Vulnerability Findings API

DETAILS:
**Tier:** Ultimate
**Offering:** GitLab.com, Self-managed, GitLab Dedicated

NOTE:
This API resource is renamed from Vulnerabilities to Vulnerability Findings because the Vulnerabilities are reserved
for serving [Vulnerability objects](https://gitlab.com/gitlab-org/gitlab/-/issues/13561).
To fix any broken integrations with the former Vulnerabilities API, change the `vulnerabilities` URL part to be
`vulnerability_findings`.

Every API call to vulnerability findings must be [authenticated](rest/authentication.md).

If a user does not have permission to
[use the Project Security Dashboard](../user/permissions.md#project-members-permissions),
any request for vulnerability findings of this project returns a `403 Forbidden` status code.

WARNING:
This API is in the process of being deprecated and considered unstable.
The response payload may be subject to change or breakage
across GitLab releases. Use the
[GraphQL API](graphql/reference/index.md#queryvulnerabilities) instead. For more information, see [GraphQL examples](../api/vulnerabilities.md#replace-vulnerability-rest-api-with-graphql)

## Vulnerability findings pagination

By default, `GET` requests return 20 results at a time because the API results
are paginated.

Read more on [pagination](rest/index.md#pagination).

## List project vulnerability findings

List all of a project's vulnerability findings.

```plaintext
GET /projects/:id/vulnerability_findings
GET /projects/:id/vulnerability_findings?report_type=sast
GET /projects/:id/vulnerability_findings?report_type=container_scanning
GET /projects/:id/vulnerability_findings?report_type=sast,dast
GET /projects/:id/vulnerability_findings?scope=all
GET /projects/:id/vulnerability_findings?scope=dismissed
GET /projects/:id/vulnerability_findings?severity=high
GET /projects/:id/vulnerability_findings?pipeline_id=42
```

| Attribute     | Type           | Required | Description                                                                                                                                                                         |
| ------------- | -------------- | -------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `id`          | integer/string | yes      | The ID or [URL-encoded path of the project](rest/index.md#namespaced-paths) which the authenticated user is a member of.                                                        |
| `report_type` | string array   | no       | Returns vulnerability findings belonging to specified report type. Valid values: `sast`, `dast`, `dependency_scanning`, or `container_scanning`. Defaults to all.                   |
| `scope`       | string         | no       | Returns vulnerability findings for the given scope: `all` or `dismissed`. Defaults to `dismissed`.                                                                                  |
| `severity`    | string array   | no       | Returns vulnerability findings belonging to specified severity level: `info`, `unknown`, `low`, `medium`, `high`, or `critical`. Defaults to all.                                   |
| `pipeline_id` | integer/string | no       | Returns vulnerability findings belonging to specified pipeline.                                                                                                                     |

```shell
curl --header "PRIVATE-TOKEN: <your_access_token>" "https://gitlab.example.com/api/v4/projects/4/vulnerability_findings"
```

Example response:

```json
[
  {
    "id": null,
    "report_type": "sast",
    "name": "Possible command injection",
    "severity": "high",
    "scanner": {
      "external_id": "brakeman",
      "name": "Brakeman",
      "vendor": "GitLab"
    },
    "identifiers": [
      {
        "external_type": "brakeman_warning_code",
        "external_id": "14",
        "name": "Brakeman Warning Code 14",
        "url": "https://brakemanscanner.org/docs/warning_types/command_injection/"
      }
    ],
    "project_fingerprint": "ac218b1770af030cfeef967752ab803c55afb36d",
    "uuid": "ad5e3be3-a193-55f5-a200-bc12865fb09c",
    "create_jira_issue_url": null,
    "false_positive": true,
    "create_vulnerability_feedback_issue_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_merge_request_path": "/root/test-false-positive/-/vulnerability_feedback",
    "create_vulnerability_feedback_dismissal_path": "/root/test-false-positive/-/vulnerability_feedback",
    "project": {
      "id": 2,
      "name": "Test False Positive",
      "full_path": "/root/test-false-positive",
      "full_name": "Administrator / Test False Positive"
    },
    "dismissal_feedback": null,
    "issue_feedback": null,
    "merge_request_feedback": null,
    "description": null,
    "links": [],
    "location": {
      "file": "app/controllers/users_controller.rb",
      "start_line": 42,
      "class": "UsersController",
      "method": "list_users"
    },
    "remediations": [
      null
    ],
    "solution": null,
    "evidence": null,
    "request": null,
    "response": null,
    "evidence_source": null,
    "supporting_messages": [],
    "assets": [],
    "details": {},
    "state": "detected",
    "scan": {
      "type": "sast",
      "status": "success",
      "start_time": "2021-09-02T20:55:48",
      "end_time": "2021-09-02T20:55:48"
    },
    "blob_path": "/root/test-false-positive/-/blob/dfd75607752a839bbc9c7362d111effaa470fecd/app/controllers/users_controller.rb#L42"
  }
]
```

## Replace Vulnerability Findings REST API with GraphQL

To prepare for the [upcoming deprecation](https://gitlab.com/groups/gitlab-org/-/epics/5118) of
the Vulnerability Findings REST API endpoint, use the examples below to perform the equivalent operations
with the GraphQL API.

### GraphQL - Project vulnerability findings

Use [`Pipeline.securityReportFindings`](graphql/reference/index.md#pipelinesecurityreportfindings).

```graphql
query VulnerabilityFindings {
  project(fullPath: "gitlab-examples/security/security-reports") {
    pipelines(first:1) {
      nodes {
        securityReportFindings(first:1) {
          nodes {
            title
            severity
            state
            scanner {
              externalId
              name
              vendor
            }
            identifiers {
              externalType
              externalId
              name
              url
            }
            uuid
            falsePositive
            description
            location {
              ... on VulnerabilityLocationSast {
                file
                startLine
                endLine
                vulnerableClass
                vulnerableMethod
                blobPath
              }
              
              ... on VulnerabilityLocationContainerScanning {
                dependency {
                  package {
                    name
                  }
                  version
                }
                image
                operatingSystem
              }

              ... on VulnerabilityLocationDependencyScanning {
                file
                blobPath
                dependency {
                  version
                }
              }
            }
            remediations {
              diff
              summary
            }
            solution
            evidence {
              request {
                body
                headers {
                  name
                  value
                }
                method
                url
              }
            }
          }
        }
      }
    }
  }
}
```

Example response:

```json
{
  "data": {
    "project": {
      "pipelines": {
        "nodes": [
          {
            "securityReportFindings": {
              "nodes": [
                {
                  "title": "Deserialization of Untrusted Data",
                  "severity": "CRITICAL",
                  "state": "CONFIRMED",
                  "scanner": {
                    "externalId": "gemnasium",
                    "name": "Gemnasium",
                    "vendor": "GitLab"
                  },
                  "identifiers": [
                    {
                      "externalType": "gemnasium",
                      "externalId": "b60c2d6b-9083-4a97-a1b2-f7dc79bff74c",
                      "name": "Gemnasium-b60c2d6b-9083-4a97-a1b2-f7dc79bff74c",
                      "url": "https://gitlab.com/gitlab-org/security-products/gemnasium-db/-/blob/master/gem/activerecord/CVE-2022-32224.yml"
                    },
                    {
                      "externalType": "cve",
                      "externalId": "CVE-2022-32224",
                      "name": "CVE-2022-32224",
                      "url": "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-32224"
                    },
                    {
                      "externalType": "ghsa",
                      "externalId": "GHSA-3hhc-qp5v-9p2j",
                      "name": "GHSA-3hhc-qp5v-9p2j",
                      "url": "https://github.com/advisories/GHSA-3hhc-qp5v-9p2j"
                    }
                  ],
                  "uuid": "c9e40395-72cd-54f5-962f-e1d52c0dffab",
                  "falsePositive": false,
                  "description": "A possible escalation to RCE vulnerability exists when using YAML serialized columns in Active Record < 7.0.3.1, <6.1.6.1, <6.0.5.1 and <5.2.8.1 which could allow an attacker, that can manipulate data in the database (via means like SQL injection), the ability to escalate to an RCE.",
                  "location": {
                    "file": "dependency-scanning-files/Gemfile.lock",
                    "blobPath": null,
                    "dependency": {
                      "version": "5.0.0"
                    }
                  },
                  "remediations": [],
                  "solution": "Upgrade to versions 5.2.8.1, 6.0.5.1, 6.1.6.1, 7.0.3.1 or above.",
                  "evidence": null
                }
              ]
            }
          }
        ]
      }
    }
  }
}
```
