#############################################################################
##
#W  factorial.g              GAP4 Package `FactInt'               Stefan Kohl
##
##  This file contains a database of factors of numbers of the form k! +/- 1.
##
#############################################################################

BindGlobal( "K_FACTORIAL_M1_FACTORS", MakeImmutable([
  1006789331, 1073916751, 1111658113, 1134403433, 1140656443, 1146407887, 
  1146874411, 1167142577, 1184888071, 1195064903, 1260687781, 1269496727, 
  1314341617, 1323864427, 1326314777, 1326485929, 1519309147, 1573991401, 
  1581808471, 1587322951, 1588747723, 1675932179, 1784928997, 1836539387, 
  1874664751, 1927941391, 1979383639, 2030928391, 2044151323, 2091600221, 
  2168466907, 2270692909, 2289242413, 2342979451, 2343324817, 2348024137, 
  2427406477, 2476204039, 2536803211, 2541520987, 2564865707, 2712325789, 
  2805982951, 2810244233, 2830081459, 2838173633, 2906354783, 2929069651, 
  3097410157, 3167088391, 3339546779, 3343239143, 3474441923, 3570539239, 
  3584315851, 3696858643, 3785410639, 3827823253, 3890907859, 3987488293, 
  4237207577, 4354131499, 4472952371, 4626856337, 4875172153, 4900818037, 
  4904875259, 4931514821, 5407085213, 5495266979, 6000724511, 6154980127, 
  6234836827, 7041393449, 7798078091, 7995547907, 8196568201, 8378865041, 
  8799516533, 8851503527, 9021572407, 9313474991, 9504224399, 9629463887, 
  9659979101, 9746348431, 9939771559, 9952080601, 10621559197, 10627433371, 
  10787966999, 10972949233, 10977774421, 11201620673, 11324858029, 
  12154743613, 12209084533, 12441402821, 12548932379, 12746512267, 
  12795919133, 13257525451, 13506494051, 14655461033, 15077562611, 
  15444976889, 15502016963, 15560760827, 16887428617, 16894558517, 
  17371134509, 17436317323, 18692511599, 18697855199, 20197507147, 
  20805961087, 20816187017, 23114065957, 23495749393, 23660535601, 
  24000245081, 24131217133, 24233257271, 24823473209, 25257305039, 
  26714341469, 29009496401, 29020183861, 29888872129, 30695366231, 
  31243237523, 31301668907, 32719722509, 32901714691, 33127531693, 
  34021254611, 36325750231, 38141331083, 40748019047, 42216582329, 
  43124771101, 48877962521, 49354237393, 51535300067, 52222291063, 
  53851038977, 56398361989, 60951605441, 65627747849, 66375876337, 
  70110259679, 72813468997, 74545641397, 80324620333, 84084558541, 
  93759515797, 95076270827, 95460461669, 96189985121, 99950129179, 
  101330948519, 107095026893, 108407812369, 111730091441, 114564984229, 
  121167937399, 135862406567, 136333209433, 138213297641, 140253792647, 
  142056047801, 146368074299, 148257413069, 148779362717, 150555419957, 
  155166770881, 160494745883, 164521736549, 165231130837, 165535904147, 
  176062931743, 178221766267, 192303711139, 196864545347, 197098973711, 
  197439697451, 198718853819, 202116191549, 216117826229, 219395312527, 
  223517205259, 223734517427, 227871571163, 230052862909, 231302080099, 
  236120113597, 264221937731, 265523263303, 287282678119, 288728583067, 
  295574889899, 315760606303, 316793888197, 339404803993, 341584667447, 
  342861418069, 361217753579, 388784807461, 388797000863, 395446396669, 
  399276571717, 403438838941, 414299629571, 432094955297, 438543326009, 
  439414027069, 443063400071, 446854608469, 450688111583, 467334334487, 
  473054048333, 486676665551, 497441582569, 502186962769, 514724827367, 
  558388863607, 560267903057, 587254335823, 612038098439, 619056193159, 
  625793187653, 631520442803, 730595866267, 732219025067, 743094098309, 
  745463053889, 758543185067, 788285821153, 792329436403, 794401079561, 
  805510115129, 807281173211, 851379151213, 901233060773, 946837147351, 
  951628008911, 988346028049, 997983975851, 1048668380909, 1077300360571, 
  1123071567053, 1143789334777, 1187061746609, 1279408655593, 1285780181453, 
  1298793158431, 1300178958359, 1342445005361, 1359199868881, 1362150039223, 
  1398352561537, 1412350716341, 1443808738433, 1446675116203, 1512996890927, 
  1524646829711, 1552786459153, 1597009693297, 1638982174979, 1656315766873, 
  1721213906371, 1723434462179, 1762720434721, 1927076456633, 2077614339113, 
  2085067923919, 2101520955571, 2107298586989, 2225381414233, 2364377252749, 
  2681632306217, 2809464566891, 2902738834753, 2927200169659, 2940651566779, 
  2986021249553, 3044347452863, 3058087446013, 3069708199541, 3157311100123, 
  3312000043153, 3346712988797, 3388509309973, 3425955554953, 3496116532331, 
  3526480315301, 3707847587683, 3897810954551, 4043346666763, 4113534101221, 
  4159660695629, 4224758601013, 4283936619037, 4467102688073, 4523280465751, 
  4725431264929, 4781081718713, 4945200627833, 5622569042819, 5845361496371, 
  5864920585847, 5985310609393, 6584290605943, 7222312856047, 7541323172041, 
  8120743270259, 8561211498167, 8890241971657, 9637359160553, 11144298156709, 
  11548602744761, 11744158405019, 11932900842851, 12115241068937, 
  12525383884927, 13421883768091, 13840355860511, 13922748239921, 
  13952770586273, 14564948326339, 14623142881637, 14877883952779, 
  14926539009247, 15321587850461, 16475410387661, 16484738626289, 
  16852182574309, 16991946017023, 17306892623939, 17455923993043, 
  17510656134809, 17650207775171, 18149085244573, 18602391770999, 
  18664734014999, 19592941030043, 19893007793377, 19949663277967, 
  20349161688719, 20460120498313, 21510218535451, 22358253673153, 
  22413264518063, 22548701843911, 23672912537221, 23860691807737, 
  24679808464859, 24839854441067, 25184168062957, 27045534180607, 
  27551227906667, 27676045866773, 28213797706441, 28250028921871, 
  28785367609811, 29117630649803, 29695723986343, 31727482666973, 
  32442129901367, 32711166360407, 34037981588441, 34931956380023, 
  35793181936373, 35877993249463, 37566735285011, 39081142224667, 
  40046322031343, 40366054858583, 40458298391029, 40586955883343, 
  41908554250691, 43245492056743, 45353623723271, 47422667053241, 
  49253955870377, 51898094889863, 64196736426947, 64942321565593, 
  78529877697311, 81146381643311, 81904764252911, 84597893773559, 
  98730324628679, 105462119061287, 107782618631003, 107832727526633, 
  112799762189713, 119723002603481, 119987758039453, 124842886328861, 
  134258645360209, 139815142111087, 140125939686871, 144152084971871, 
  146319770634229, 149269157792597, 159610989730649, 165944464269889, 
  168175527933731, 168763482038611, 169785678706073, 175077967898027, 
  175665895092419, 181871750999083, 198861627411613, 210471601552013, 
  211996344974251, 234884242999577, 237329570395553, 266448203286383, 
  268210536369731, 278695265308189, 279601504065761, 295643814828559, 
  316717622835763, 320370730031239, 320577203500987, 321560129211533, 
  333434996390401, 349374718915279, 350127943929857, 359072460921533, 
  370071375566251, 374912712025207, 388335263096857, 429407758526771, 
  458476324671361, 460986220451957, 461023921783541, 466754445505463, 
  494803144423249, 550401729150319, 550979186802929, 565310453158799, 
  571521933856259, 614101605827977, 706669690971983, 745200121750489, 
  893736200671451, 911944012355599, 947993335296017, 1018930285985147, 
  1051008693821299, 1133342478315709, 1144940673278267, 1174419608468209, 
  1192423201745527, 1239197991955867, 1248379806881269, 1323429807384907, 
  1407416468600333, 1455180020327963, 1476418473811349, 1492781071753919, 
  1498131033897203, 1502204898703819, 1576070489916983, 1844246613604511, 
  1848194882238359, 2275708464286597, 2283061147818331, 2698030203176081, 
  2720176003025891, 2809840902017321, 2887178599039477, 3123866068176899, 
  3129641389936669, 3215201016169297, 3724863291360811, 3742124538336017, 
  3892024936038887, 4308230742051329, 4522527920462053, 4835000796590581, 
  5061408382152539, 5510773981943033, 5727742836680257, 5740845665127577, 
  5974618380812329, 6300377987396303, 6358883880600169, 7070144983415467, 
  7403513695136827, 7932928462469011, 8035604011121317, 8134498095345247, 
  8152967347575527, 8224307090981803, 8375728533102409, 10074237079293679, 
  10596188107801343, 10903117886205647, 11442710659245161, 11483646638935817, 
  11917504529976889, 11957283597371929, 12141426851181493, 12194579365296637, 
  12874964001231931, 13777345688887723, 14592408208775933, 14691726049973503, 
  14732039495173139, 15544967201478593, 15824252755580629, 16174223568402499, 
  16539572570406217, 18973588498936879, 19522979183488271, 19586675156018723, 
  20225690517265213, 21295292468844473, 22501799575209259, 22647447907677007, 
  23201995004074693, 24133874316950701, 25089189765479779, 26725241181275099, 
  26923083954138371, 28335195733469837, 29299310136713411, 33040622219332757, 
  33064392258202969, 34968116649159559, 35846727323392523, 36755232554995601, 
  37736359639980919, 37799309610253967, 40109775810479693, 40157953729306943, 
  42801409792933403, 43045617443870827, 43859456780098367, 47301243848126071, 
  47953545047771551, 53354685457192289, 54106663006768609, 57340754815612159, 
  58595462036840653, 59888119631523367, 60604273845335477, 63539098100897207, 
  65092398534211571, 69949547102918459, 71907484857881021, 78958785391722157, 
  80494926344051173, 83643448721801743, 89907499708983113, 93445346740399729, 
  93865764202585703, 95639570878986613, 102747780263888119, 
  116389619971193759, 126378077141514719, 134727069360646123, 
  139999471220739881, 141059753123416151, 171832839817277819, 
  187949671045778309, 189088178519923097, 198068268136236629, 
  223670204279816989, 260216856712221527, 264154566134488903, 
  266924337639576941, 270943026262599013, 279971603362503361, 
  314264884421286209, 321159920984703967, 345469640097637333, 
  370589411702702197, 396459994504174187, 411748451800548169, 
  437544327517951211, 439441248600867599, 485418322264128403, 
  776158097768544581, 809790959365397593, 822842342741267531, 
  901733359958261951, 1087140629648762261, 1092482278925623501, 
  1193084064348628981, 1309854409490156443, 1312828587662078099, 
  1318261066252095131, 1371622366097666677, 1425961793639733169, 
  1556151131905519619, 1583408834147007349, 1662730817761212263, 
  1666209404233585481, 1780667644614097259, 1990086482671125913, 
  2038657125518667569, 2107480277612688661, 2152879768607654267, 
  2245487026689079181, 2537446583448425113, 2654065788714484499, 
  3267492651488172853, 3750739280809981511, 3830341806212863309, 
  4537719798691874303, 4585424368280928581, 5509779922364202473, 
  6355471504979475751, 7249738248311668783, 7533609175373352257, 
  7638975719360340847, 8891741073127615621, 9190813196017748117, 
  10398560889846739639, 11185255518896394101, 11305508112732584383, 
  13210505732145368923, 14122094717737943227, 20897600016486249247, 
  22529893994454165269, 22943901481158506593, 23468454787850270617, 
  23862796437610661581, 25218905278415549413, 25364313702509976239, 
  26409149443379471407, 28973742784428485783, 31657510341133088431, 
  32010160310911274413, 35790323995816331771, 36129068964388425967, 
  36348936816005974711, 36921163006591641509, 38190731685970173883, 
  40663529837104749779, 43221082155858466877, 44361961346484528259, 
  49158367373238186979, 59594742963566784257, 66033127812014946343, 
  88902066312168844499, 94689872102275152179, 100549402395474111271, 
  118349159505769453321, 130983315743694305501, 132583107488749965329, 
  140708169568951154801, 183056051892809313193, 194062104589314875897, 
  230874293223685545059, 256352639355042596057, 266856054895217005577, 
  291374596607656314829, 352849571868724688689, 383137403257740611717, 
  404314271339551874089, 566161495146584181973, 638258216950674387043, 
  775491359190074471981, 831435487847486304157, 872092004687031460727, 
  897062791930953117683, 1050367912600481955097, 1070009678973364956793, 
  1144360138649852039189, 1371619964001615151511, 1396740384923923950601, 
  1527606049769594294477, 2069557541381533209959, 2238857186428827118669, 
  2393584415705844388207, 3154953482573531076029, 3466171374603296979227, 
  3778952010993188878441, 4750460202351791890073, 5185403074803305790881, 
  5414503393501601524553, 5764382871580968999181, 5782864881255013236481, 
  5815404884437230485237, 6064256761153617866563, 6392714043061860543581, 
  6944561254864622437303, 7197081152989978879903, 7392722058214769338943, 
  9151559565316253797499, 10576808395865566718629, 14484345050024627874587, 
  15190118190232448309303, 15612666904592494195997, 16996272005282757867739, 
  19510558483198104942761, 19967303570082360959561, 20238900353203095546743, 
  20798857002105676635599, 22924381295670006234749, 25653335447178545559259, 
  29461962998038961261801, 34181038656975270781829, 35341167267147184648349, 
  55353226459576651599997, 59033973135730750777079, 83613553193212565055629, 
  89292099039066404446583, 93860151591549156672389, 124282359925223680805887, 
  134013277989741695639179, 137608045645814756168459, 
  150152322348158556906709, 165851838256379679726541, 
  170250573323403564401591, 240242690178602150114729, 
  243800986741054776663727, 269356684872488049450827, 
  278113772233834559378887, 281620179905648264831321, 
  334414801195030793616283, 459439053228143696956349, 
  460713667599673925267213, 464525701797917844740221, 
  546815577555057568609561, 714204699750929602600171, 
  790772324341378194783917, 833929275025094822440549, 
  1463348036079038481046361, 2160499552482447506852701, 
  2228107695632279991764789, 2441600989787695967962441, 
  2467564474920700877403677, 2504633659284554189705323, 
  3337973490264797713585777, 3774138932421844131426311, 
  3852306482810075242089227, 3968111331194553575695891, 
  4139884411675565479171577, 4699350260900869065321689, 
  5418404432286059811819647, 7092462956505000296082799, 
  7663267780838454174128897, 8943890733288215088458017, 
  8949328514076098620099633, 10502584489655682791887103, 
  15130181417131447991224699, 15195214207315167261442867, 
  28656802589260197773510623, 40453931486458937516189119, 
  48377627659132602412103759, 78083223787608575156942093, 
  85568927763063037127562433, 141044441574147019511887247, 
  148625605503332322988141969, 180094353979644925715106937, 
  229184842415932720503291253, 240559684028943110677535629, 
  257396657487670398440079539, 380612210868192436431787361, 
  382175392991761188822260633, 405787355833376578700460301, 
  431709910692326954350968533, 433483282454071499630228513, 
  549585323219368602369820121, 789210120777811500568846679, 
  935089819076008155381317399, 991422492725805588154223383, 
  1114817850008199657493434253, 1430382185042605361124441721, 
  1634021415472007266366210817, 1698561722424352389575067749, 
  2007083736859170236448088811, 2136787525465699346260623731, 
  2287818360282984294502441853, 2380509486478171757596001707, 
  4379937280700739249520414229, 4975560684609281103633431477, 
  7101079502353532063312054917, 12873166338171907607087583217, 
  18056085329836675547166722819, 27540617119625946118459403939, 
  37272934189201737869016720929, 46592495579025763749447076981, 
  62477556064267688755099251557, 81574205967622462911640355351, 
  107696815311379729531745838349, 541871045755985600524776694391, 
  546438722226889371614324889973, 572501857609087746044781729557, 
  593016762123272567713327930159, 623013311490263028295153743673, 
  629568685143887122306747853927, 650188895082938496133384569571, 
  767761264702576031559515348521, 833497448239434461315360317121, 
  1443754424824480405672165207097, 3464771911687901539424860777427, 
  8219124367748699129845858634653, 14811418309867156086978569321161, 
  14926206558364500381330548427173, 16393439386673188319925898958293, 
  16735979398325746609543853499929, 27346357482680319232157163552689, 
  38197980429736991738205655885367, 96219075145726707178129001299019, 
  135075706114535316950231097516031, 221624479389787622076772042626649, 
  809394310478457594898676919366517, 859898093417486999252052249867649, 
  1186226926103899822371879437051237, 2723700285362100042230547527778317, 
  2954276561663726731348533829152043, 3531765816278468901225791666230489, 
  3592592306440326131928694995391829, 5397554794221433215092107232321743, 
  5857782783722908444648891741552991, 41321451466032581613501320111901299, 
  67451412775987097229456759114365147, 80480454695883671927072158689953459, 
  86931787124894025899613982958574289, 135094134046186960540571260475926499, 
  265533834722777978804737399584403667, 314013920358759969538584440207708159, 
  365912109763230734114664196329916163, 569018285138785743945090436740972589, 
  993292639325978587222572893472381397, 1593995949106763801004032952259869019,
  1733598256793782223024375220367920953, 4498990032296049864443764715000903587,
  28562816824104372591745915524850476013, 
  45340834916399427401941254087564552901, 
  67713346982387980795461394231203640841, 
  419790526928647246447760544140764445623, 
  10498667669119496541246764547364394150767, 
  17952190519544154606653037740279886064447, 
  50967329609794872813828672909815236088381, 
  60142427312522623487250730465114097841091, 
  174568885579274269812937093465102210976297, 
  190178327955607364367559372040479613565547, 
  2714664409368913077909931272340767694810709, 
  4119842702492043412032706962320115960832703, 
  6362530125276957881204501556485777224877737, 
  21289796287569735866708594882309656982337071, 
  156548140613622977981626666310401198875601601, 
  188688334348298185613260389556326587556468251, 
  1361598929624984516434347590715335332503841981, 
  14380211646881467415803462581621417951534002839, 
  10651838022424183034932542865787273875648790960999, 
  51442741042891005984634751109466441839162295178987, 
  649887067848818772887462916835461246603936294119701, 
  7517596214490051335825344881028792801065608068512131, 
  12567987371175933926362928813184833422003421176616583508547 ] ) );

BindGlobal( "K_FACTORIAL_P1_FACTORS", MakeImmutable([
  1046344171, 1095267869, 1118138237, 1135090301, 1158774269, 1243653599, 
  1258309163, 1258996199, 1304507671, 1316506057, 1421860537, 1462030301, 
  1487583221, 1496221073, 1566883541, 1607544403, 1637925011, 1677089539, 
  1723028641, 1757072171, 1775516983, 1895672717, 1927662679, 1929398957, 
  1959671477, 2058883427, 2065257401, 2078913559, 2135347189, 2309628001, 
  2334988919, 2365477817, 2626189057, 2626395763, 2693823973, 2711686639, 
  2719484587, 2783893447, 2966991389, 2998746313, 3011917759, 3106931083, 
  3118860791, 3119705669, 3119969417, 3184003111, 3239258303, 3295970423, 
  3386274469, 3583441613, 3589406731, 3678300341, 3694069667, 3740177143, 
  3755842159, 3802549117, 3868855709, 3929552503, 4103566837, 4111591543, 
  4183450489, 4651897559, 4706925101, 4815777089, 4976007893, 5041540333, 
  5057025803, 5111936677, 5752198817, 6384426751, 6543983717, 6546486007, 
  6571145513, 6574062137, 6641780083, 6666834089, 6842386513, 6868495901, 
  7390061603, 7500502393, 7583423483, 8083719599, 8258559109, 8544120307, 
  8642830961, 8708445929, 8765484173, 8906328727, 8908692253, 8942374379, 
  9226549903, 9396685567, 9474445051, 9955626281, 10148059367, 10377321839, 
  10384399063, 10384939757, 10595304667, 10690025113, 10730168549, 
  11205887579, 11213112151, 11393549729, 11921175641, 12170448127, 
  12336712319, 12891916633, 12955105817, 13150377943, 13200348101, 
  13207611751, 13314898747, 13819659097, 14275287197, 14554582949, 
  14858314567, 14871104803, 15325756339, 15350200727, 15660353287, 
  15976053859, 16319436799, 16391209501, 16628899487, 17053120373, 
  17124870541, 17392780213, 17435835751, 18336410683, 18671377561, 
  19236668797, 19685850917, 20200705061, 20543213659, 21386061271, 
  22715736289, 22791510179, 23012387071, 23078670211, 23794812343, 
  24058242503, 24273593917, 24424612831, 24686170547, 24939120931, 
  28437820009, 28840185821, 29400647321, 30728104307, 31847327389, 
  32227138313, 32611429849, 33072178127, 34882071611, 35128568467, 
  35451513187, 36362256319, 39688194769, 40717051411, 41053793579, 
  41229338881, 43332403549, 43339400309, 43399023821, 47580631069, 
  47709469211, 48432621947, 49929947471, 50220716303, 51433647469, 
  52107800761, 53249896591, 53344797047, 54730514387, 54823153507, 
  55546200643, 55921523591, 56250422461, 56553646267, 57554485363, 
  57636116003, 60663370591, 62068649807, 63088141777, 66581425853, 
  66663848987, 69084535147, 71818563253, 72028785431, 73226805419, 
  74195127103, 75293920783, 81232044577, 84301016461, 84793423927, 
  86285506597, 88952230021, 89001585557, 90271784567, 93155815513, 
  93167960719, 97981351889, 98362712671, 103673209049, 107067562961, 
  108871061489, 109799165627, 114014275747, 114095267189, 115120190797, 
  125351338457, 126004596449, 127555592683, 127888353091, 128758682077, 
  129990645377, 135490469159, 137482695401, 138588122899, 141959761283, 
  142410167827, 143754173441, 146305688687, 147329442191, 152694556367, 
  154303935647, 156355801633, 157621549979, 162862637417, 166091902343, 
  171788550517, 174679093529, 177447146119, 187624774903, 194768835907, 
  201494820647, 204693813523, 208715842981, 214900167401, 222222674183, 
  241580277689, 242627134829, 247273307689, 258847257209, 259856122109, 
  260513294411, 264889440727, 265037039629, 274175006321, 291866396539, 
  294922118587, 296181610559, 320570466499, 322270265477, 325485855571, 
  327377369261, 336303660527, 349913622161, 351900745811, 354044526083, 
  355171842139, 360868320707, 439938735473, 447221745547, 463056129743, 
  471628828379, 484062961519, 486353434961, 486902694637, 550723870271, 
  551607133513, 554410179437, 570823386283, 580521735671, 641527690229, 
  743672261039, 743773819721, 751691839937, 816244881983, 817117435423, 
  817145546489, 847522380283, 850784174021, 851571097141, 877130437537, 
  886818484597, 894460090273, 896248630313, 898695642583, 910472243897, 
  919777136903, 979568260963, 988410582463, 1055374177153, 1192566201259, 
  1271172188317, 1276825789439, 1278982861469, 1310125217081, 1324498970453, 
  1324807032607, 1328656547983, 1330559707369, 1341880306969, 1381173038633, 
  1395759991303, 1403883526961, 1452486383317, 1498153334239, 1548681413393, 
  1646679849623, 1648696990771, 1742266870067, 1777805410583, 1780080797569, 
  1785361459333, 1946094264251, 1946411739593, 2026696351723, 2274352665379, 
  2292174356839, 2428055186059, 2492041997867, 2530101183179, 2752827316973, 
  2828502026173, 2835571220017, 2936932166293, 3081568164487, 3282216032279, 
  3385356428401, 3477221520127, 3696014416243, 3814287091207, 3855332667341, 
  3945404121097, 4067284180951, 4072733291999, 4226251464829, 4236633769031, 
  4277341908869, 4361803863709, 4458534821399, 4466516456789, 4470193460263, 
  4735705057253, 4812798521767, 4879852783453, 4942133994913, 5233964404939, 
  5509076767613, 5708427502619, 6081598914023, 6141050269801, 6164890522139, 
  6173959948889, 6199456000921, 6340154089427, 6551497519393, 6684964554781, 
  6854870037011, 7949451849197, 8346520835249, 8380252582399, 8724384750233, 
  8757563510467, 8926952911003, 9078021409757, 9335557556599, 9340789617659, 
  9561906969931, 9653787379949, 9695887267973, 9936338092981, 10038918425429, 
  10533868207883, 10707248594177, 11005452216991, 11511397466677, 
  11929325797309, 12273305526799, 12562672650179, 12648210155831, 
  12726419259881, 13310016019393, 14335186652077, 15010601015359, 
  15115228577879, 15117740710621, 15239855980621, 15653342060959, 
  15982628105567, 16501856050969, 16588684519453, 17638349411383, 
  18208374651703, 18331561438319, 18582647601521, 18827541672307, 
  19048838601613, 19399349052647, 19477101004681, 19789544034049, 
  19802919388669, 20454945767189, 21115292881211, 22630765103561, 
  22828994898839, 23194589525207, 24775201578731, 25171760610077, 
  25375861885043, 25443798229961, 26059529425733, 26434181119037, 
  26544504844153, 27377391590959, 28496777005157, 30036970425139, 
  30289915906337, 31167897957799, 31298841057233, 31657587871873, 
  31730713097767, 33220000350617, 34083569542031, 34952079265361, 
  34954962110191, 37853581108223, 38656057636013, 39791036138857, 
  41590604426681, 42652664176963, 44901982139761, 45035312629079, 
  45547456427729, 46329408456281, 52695757786081, 58414920333409, 
  58764571837577, 59852621142437, 60068561450273, 61753031863051, 
  64108549439189, 65114626128593, 65403222906493, 69502233883213, 
  70552493296669, 70701680136817, 71312053273847, 71642315496047, 
  78519207813139, 78763198154867, 79256035378517, 80618555072051, 
  81542460968239, 82536905255821, 85968128856133, 93700476148943, 
  93904932028759, 96412071224951, 97507227518611, 101887242342077, 
  113701871882491, 126143416636813, 127862403804493, 133445457482563, 
  140270832085507, 144163959445217, 144756182656661, 146102648914939, 
  150621536169857, 157784049069817, 160915710745351, 162200673314527, 
  169331303105227, 176447888794157, 176852426053921, 178699627101137, 
  195451382945129, 202595398081729, 206829061191811, 215605356188297, 
  219390398685179, 219704789898053, 225167181698311, 246839731790087, 
  267284835213083, 270206650058131, 281345933294341, 294090818893343, 
  304804776725359, 314274975117541, 321279196895563, 333682675875893, 
  341050591440617, 365909462224567, 379383044256961, 399633080785751, 
  409108931058731, 431165757615499, 438607920369103, 451443932248237, 
  476712601045271, 499528974434761, 520727914120247, 554197431705509, 
  557262536830523, 563740616188273, 582503850997121, 582705808652777, 
  584985188940407, 591710678598089, 626478760127929, 656994688644251, 
  657560396620187, 678693628100561, 694363571415781, 695546278466779, 
  746379341089409, 759199839990847, 768246446694437, 773395662146759, 
  787937119761829, 797293147906819, 803877707976017, 826959652541843, 
  868717256799409, 894386218559287, 924054689605679, 928984360322321, 
  948401055165427, 995121825812791, 996359956218647, 1003437822208369, 
  1003874788568233, 1006654567853171, 1021662592367327, 1033982154442711, 
  1069935431547487, 1079939773637903, 1098482930441153, 1155191001879997, 
  1246063546987271, 1275514688705909, 1298165055168341, 1300841676258797, 
  1329776244115133, 1331538589577401, 1364319064734841, 1374851388985363, 
  1380858783878923, 1436540050269293, 1481642905697771, 1552138748541317, 
  1609470815909687, 1623746399423809, 1770361663926671, 1774595402976059, 
  1802945647246951, 1810222523523497, 1922404172927657, 2029138804448269, 
  2037843288027319, 2113832237878903, 2116417692027883, 2122948167441349, 
  2152369476494477, 2223698632082071, 2319764509398403, 2331840575628217, 
  2396398255928539, 2505426087389711, 2508538123820657, 2651275094538673, 
  2679435367215001, 2715352749106453, 2905573860801323, 2913103722409631, 
  2946946751670443, 2957248655959781, 3142315448367541, 3593119949698231, 
  3909669044842609, 4199462222045947, 4599366044814199, 4599813308163659, 
  4635258713421893, 4877175603887243, 5058961282338853, 5315930613579673, 
  5736584190981331, 5840210284405579, 5842727520019769, 6106801435083487, 
  6139292873646461, 6491531829446767, 6944977549527497, 7337927510181227, 
  7370054660853779, 7957994138419777, 7961420162814473, 8122360639053607, 
  8380033955470129, 8515115894538293, 9386601058365187, 9439214827211399, 
  9921481064186891, 10434410573948503, 10991980648873547, 11269232785451087, 
  12026485665701581, 12126008126464867, 12785987509177583, 12956049231530749, 
  13450257837648283, 13544526741953411, 14111119959702373, 14565592238871503, 
  14843936037776927, 15080721976539103, 15115349969637833, 15143915885748341, 
  15832330474370783, 16944704811657991, 17462673395397331, 18837173718032209, 
  19350292674071519, 19483238411054153, 19491981924157013, 19889554357012861, 
  23532383278507603, 23691863033806937, 23800068335307427, 24179441795615719, 
  25071046250763017, 25596367633007579, 27500136871811311, 27712267198206959, 
  28043309755772791, 28477458387050053, 34784125138808041, 36698175466381703, 
  41888848388208329, 44137623422121847, 44272136244444961, 46039217366584301, 
  46300711406670733, 47294112319101827, 47552364360511181, 49029373569907037, 
  49293254223754561, 51630101246200793, 53753346090831433, 54149650132469467, 
  61430315347417333, 61629487117839103, 66943074411872459, 67300557166608481, 
  71232670773614093, 72320536324405771, 79364263007522231, 89822351853733553, 
  89894966121867217, 100814801609838887, 105369579589326443, 
  108610809560600461, 110399893651537267, 112766922183063713, 
  113057505976248797, 115205557790605547, 118522021069990673, 
  126141828049825589, 127954156877266381, 133403596162614637, 
  139213424967033163, 157869151259266217, 162302127201412721, 
  167268601486949177, 179487469781911331, 198779387050971271, 
  224171016214185221, 225392405559686759, 239880133018958501, 
  261717170102854633, 263778366547103761, 274569569465793893, 
  290903132861599201, 295739827152442091, 295972589013743503, 
  304166964302087533, 307883722266255367, 320119107489059239, 
  322976302754792509, 323379374047223909, 329947295725192757, 
  364422320266623133, 397810018960115681, 415446287119121737, 
  417956954991809297, 447425217775901921, 457574010176946323, 
  493449654266852837, 498026058379136387, 524762490375597611, 
  564141264681777437, 587892172742050177, 635798107383668497, 
  641215530901436189, 650965830822802981, 664001141994484183, 
  702354976168145203, 734140009408353869, 786373083093177571, 
  813017841795883651, 895911257016940391, 936888347579770721, 
  1142003401149069257, 1144070669415534281, 1214911313309752699, 
  1250617424841820223, 1311489401499009659, 1443116048472199187, 
  1459515881523894913, 1507876994465748059, 1649567850960629711, 
  1775386857811331449, 1791611275815862913, 1835661872189408083, 
  1859195747707500523, 1904426589387842059, 1924505699999384797, 
  1998507866225632169, 2020307322325988347, 2355059403980707531, 
  2424850188142442429, 2567507718327197341, 2963989424744056573, 
  3016967791739373991, 3129381319967565077, 3301788665471711293, 
  3376268584648698491, 3568985552459051029, 4220826953750952739, 
  4574099198556980723, 4705801256594682847, 4751100816187922899, 
  5097418736761350157, 5120808509810710051, 5609013585175824617, 
  5976291610245829141, 6539371068918768053, 6581413466856721523, 
  6650818840744861163, 6764059584759631663, 7698401613564085871, 
  8625122129041099687, 9003289924974471563, 9309685292572646351, 
  10133258140454408041, 12108877123078340303, 12403684965449472883, 
  12563517995397696529, 12932464116949825523, 12939044249130906451, 
  13686210555334536389, 13745595325215292093, 14086460577231833809, 
  16197232051022158649, 16484611802737540073, 17051956721294852831, 
  17381792686236943103, 17968492046338767673, 17981537786312392277, 
  18603450098901619459, 19728149221312874101, 20694764667058858841, 
  20974531799668937507, 21154320865805720609, 21444880872789987871, 
  21454284800820495479, 21474662518048000231, 21940922682828238189, 
  23347755292237008313, 23438011100526639347, 23453798339574919867, 
  29430394182212396381, 31204249893153690701, 32638870151507409467, 
  33616321498949973551, 41833348875739446209, 44155228334067028427, 
  44303005942331324899, 47207269733386954921, 48360852575473077217, 
  48795702665964504883, 50299260712376544821, 61054781894566792613, 
  71240255485761981823, 72474815723662517929, 120277120315198246817, 
  126427382526107739991, 126784637507890832609, 127070557050740789579, 
  127337973516879732517, 145401001239259327061, 157021120327565960029, 
  163715789681726250313, 171954628603532399459, 175477953678874427143, 
  180274615053826152589, 186123579006337117921, 228275984971476559303, 
  235945585899158604727, 241353246113589737671, 268662306503771535067, 
  270408744521692830167, 285046734138881270141, 358066589458806339103, 
  380265607840356469213, 382087513530514690553, 385466418346987649983, 
  408531864697409235631, 462623104173532518631, 492534867926502020183, 
  550778451381850383581, 619416095227609996133, 713082932116282056929, 
  737985056615935663259, 826066607206532782007, 877167566015174706017, 
  895804124599619535929, 930472532752519640131, 1001797798761657686197, 
  1029601993375725300599, 1051380949933556068451, 1117490459207715872597, 
  1147286180292128189021, 1296238218260332636063, 1398129310580516973467, 
  1409005833721935025433, 1728402088249959964693, 1891548004136643904823, 
  1959205192755837155497, 2020697876469751527317, 2057674630293318346691, 
  2074588029330518396809, 2217171747715476312877, 2478692437087370832767, 
  2800878497484787157587, 2805277443704144485757, 3042895483776066444059, 
  3668376682437673551073, 4048352161007925129407, 4241620476446042963257, 
  4341002003006228933393, 4757108478032284831087, 4782133477751116767227, 
  4830677288084819457683, 4917668026521356425883, 5274902442374828316091, 
  6367901113521220244987, 6611674458824017943221, 6995647380933218140799, 
  7355609804724074078173, 7615282629332804654587, 7757984413066237612169, 
  8237223658509175872277, 9245226412016162109253, 9633730634920157115491, 
  10792833950516035537109, 10972448627919161710883, 11727664549827402745519, 
  12013869187537953727813, 13077072927379857340523, 13470741897425488899173, 
  14029308060317546154181, 14238070307903903004493, 14465780836616162702969, 
  16381668639660705087277, 18057624081136493013373, 18306076235546040483727, 
  20424710069897360255687, 21064304899912663562717, 24190200603120400079593, 
  25519450219963448560891, 30939152362013003943937, 31522365649017503479993, 
  32275143806331677841719, 33194658402572018837993, 36822601822560211836163, 
  38146243296934299524801, 39343769423125418657311, 52452084584619418138757, 
  53892214199563783393997, 62314442378923476275791, 63596541737899691902099, 
  78931648251814403737907, 80389382161939340579779, 89997055369709074595213, 
  91412476146715394577617, 91980528997116072737371, 109698627130297645731737, 
  114697501279471776003433, 122508808173429896519927, 
  135543171494417594284739, 137507352943171566330791, 
  162344150185473447056639, 217640094668562309185747, 
  220271570718309001994143, 222266313681834078177613, 
  225377192789914071606361, 233757583317928963753753, 
  237430898828085532833919, 262823325782950107438149, 
  310193517716903336653259, 310439227475072061579151, 
  348675928452141398135899, 398795893065946527508607, 
  466144592726124094738093, 470126189850078457480753, 
  494773752852444988003703, 603369288241988624750263, 
  605856062095140566497327, 636663095531045424832409, 
  705963525227330621847091, 1068809383597185812792467, 
  1075309368973977828941431, 1228948704637542812523661, 
  1463394178882315886497777, 1491857041379164672451399, 
  1534386522073430899029679, 1629014524899130438316549, 
  1954111510779966363730739, 1978676207535835392038299, 
  2718709806707182336711829, 3460085765481958659380053, 
  3940902338255886178554161, 4344848349583764329518859, 
  5918693953990816495232959, 6894400277313729488352203, 
  6906986766519639105975269, 10921693285778448839607223, 
  18225815335165829492338871, 36176855520798829161476147, 
  38897317050631716686218801, 47109351493963301285166961, 
  47268349888329447484475123, 47319662120394656536200323, 
  58206589363289319336158713, 63262821205921446730130177, 
  78221891579426352148145471, 83268086882148293619308083, 
  125178725248599444788290087, 145231317391341933365258111, 
  159138408328588807223026973, 257250158683781558436609107, 
  350433007170616328107072379, 421253711938605020303598673, 
  1131669878120932220109197009, 1201834235405915894123195599, 
  1744502186874309020303267203, 1975135224685858368186607277, 
  1986204701950991877920928169, 2047060370044133876870089307, 
  2295722240441894186972320001, 2336016954269730709999017397, 
  2768446785196186864654741163, 3338337807236121363383999021, 
  4167455364191470864079444113, 4300885662707238430686864529, 
  5895030461694531071447805791, 7627511386363984619071229527, 
  10811609604036317029608459617, 11294645177647665140920980967, 
  12311660872660805991388223033, 12318573951317236818169524329, 
  12365412673468289639313600923, 15757561600158505123106686297, 
  21817665100657487402784047413, 68428636341940746996456551633, 
  68466861653843453337981917419, 80075971917165875585023393357, 
  112556388889794980413000342489, 149946479044181757451779865339, 
  290391049934253427466419213861, 403371297210091448866432099433, 
  848561853483930998057196746597, 940712050190319319825141209859, 
  2135211841921729708835308779667, 2914982678571778853567990110381, 
  3574685026014398552934345648209, 4554665692949825778957079924193, 
  5589740040117928890400907674537, 5727297780783502552028823218833, 
  7608449170252404294833488675127, 9222775638826859871832806582289, 
  9769626895044196025426395684739, 10696722701430914857180234507939, 
  13123375977389407161588919694549, 14390547767773598982217841964761, 
  25829710930321439085184019803339, 36081361813429082138183080340753, 
  42607422767369562012435736497443, 132787400175997821332658450198547, 
  138588539704770388589769630082891, 172016541999068516095714768113163, 
  213749061182918881280504944217119, 800671054190905012623951381513587, 
  1153852426073539399073807161189601, 1853160025084147305290124353091229, 
  2865377874799768383026107550148227, 3434232859614593339639579824505129, 
  4962905867602370674248656033468461, 7132885373707342182361401607765717, 
  40921789605490466372108793694261247, 45713088500098075280333234449873453, 
  56639907596588806107088534913492329, 119130723970730205599999675130136357, 
  135308276130383772314018942122772279, 440329859646244565885691592803661547, 
  719950701284037307483851521802927511, 2630232086261680856228655500947297717,
  7001254410846736563763702929325048987, 
  14841043839896940772689086214475144339, 
  16183254660187426238247314936912852351, 
  28558602337007288107981957410138152713, 
  41927653694528092712617642634906412451, 
  97090839750280792098055480829286160009, 
  274686811290564587615329470624434615983, 
  724471637873847058596951440954292527159, 
  1664835665209676257030094220458373596437, 
  4639987070654210193824486852510861647843, 
  5651878146949530735523997358628882351147, 
  97376044141589614099244742802905649039609, 
  145560053920124375316287092261860812171017, 
  161785206248676056929457299898406991572743, 
  984858384210167262655808345015050645243243, 
  3784674494385908337626818372613017901830141, 
  542832179611019786166595777851145909637004301, 
  31661111864542058504602102525015097735381342593, 
  87412028241538313796066638390601052517731154371, 
  7173093502131087209793006965238189223456495955047, 
  11888627126804025025004652051467258556118244612927, 
  103022186552539453299876565634446293492396727184849, 
  14037273880994239756842328675178099106162296456088197, 
  42025070023047325132446149666132026718715669472074383, 
  10647562554019124667478091293300587259958291268234001823, 
  229758023927584562777368125832724248866067995638905559798117, 
  366490840976610304104746977769369661622517455940520616223381, 
  2002896480650155684677061635571976457061002571505493757461762604981 ] ) );

#############################################################################
##
#E  factorial.g . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
