SUBROUTINE GET_LEGENDRE_ASSETS(KRETURNCODE, KSIZEJ, KTRUNC, KSLOEN, KSPOLEGL, KLOEN, KNUMMAXRESOL, &
  &                            KNMENG, PGW, PRPNM)
! ** PURPOSE
!    Simplified wrapper to TRANS_INQ for obtaining arrays necessary for performing Legendre transform
!    (Gaussian weights, Legendre polynomials and NMENG (cutoff zonal wavenumber for each latitude))
!
! ** DUMMY ARGUMENTS
!    KSIZEJ: number of latitudes in grid-point space
!    KTRUNC: troncature
!    KSLOEN: Size of KLOEN
!    KSPOLEGL: Size of second dimension of Legendre polynomials
!    KLOEN: number of points on each latitude row
!    KNUMMAXRESOL: maximum number of troncatures handled
!    KNMENG: cut-off zonal wavenumber
!    PGW: Gaussian weights
!    PRPNM: Legendre polynomials
!
! ** AUTHOR
!    2 July 2025, S. Hatfield
!
! I. Dummy arguments declaration
IMPLICIT NONE
INTEGER(KIND=8), INTENT(OUT) :: KRETURNCODE
INTEGER(KIND=8), INTENT(IN) :: KSIZEJ
INTEGER(KIND=8), INTENT(IN) :: KTRUNC
INTEGER(KIND=8), INTENT(IN) :: KSLOEN
INTEGER(KIND=8), INTENT(IN) :: KSPOLEGL
INTEGER(KIND=8), DIMENSION(KSLOEN), INTENT(IN) :: KLOEN
INTEGER(KIND=8), INTENT(IN) :: KNUMMAXRESOL
INTEGER(KIND=8), DIMENSION(KSLOEN), INTENT(OUT) :: KNMENG
REAL(KIND=8), DIMENSION(KSLOEN), INTENT(OUT) :: PGW
REAL(KIND=8), DIMENSION(KSLOEN/2,KSPOLEGL), INTENT(OUT) :: PRPNM
!
! II. Local variables declaration
INTEGER, DIMENSION(KSLOEN) :: ILOEN
INTEGER :: ISIZEI, ISIZEJ, &
         & IPHYSICALSIZEI, IPHYSICALSIZEJ, &
         & ITRUNCX, ITRUNCY, &
         & INUMMAXRESOL
LOGICAL :: LLSTOP
INTEGER :: IIDENTRESOL
INTEGER, DIMENSION(KSLOEN) :: INMENG
REAL(KIND=8), DIMENSION(KSLOEN) :: ZGW
REAL(KIND=8), DIMENSION(KSLOEN/2,KSPOLEGL) :: ZRPNM
REAL(KIND=8) :: ZDELTAX, ZDELTAY
#include "trans_inq.h"

ILOEN(:)=KLOEN(:)
ISIZEI=0
ISIZEJ=KSIZEJ
IPHYSICALSIZEI=0
IPHYSICALSIZEJ=0
ITRUNCX=KTRUNC
ITRUNCY=0
INUMMAXRESOL=KNUMMAXRESOL
!
! III. Setup
ZDELTAX=0.
ZDELTAY=0.
CALL SPEC_SETUP4PY(KRETURNCODE, ISIZEI, ISIZEJ, IPHYSICALSIZEI, IPHYSICALSIZEJ, &
                  &ITRUNCX, ITRUNCY, INUMMAXRESOL, ILOEN, .FALSE., SIZE(ILOEN), &
                  &ZDELTAX, ZDELTAY, IIDENTRESOL, LLSTOP)
IF (.NOT. LLSTOP) THEN
  CALL TRANS_INQ(KRESOL=IIDENTRESOL, KNMENG=INMENG, PGW=ZGW, PRPNM=ZRPNM)
  KNMENG=INMENG
  PGW=ZGW
  PRPNM=ZRPNM
ENDIF
!
END SUBROUTINE GET_LEGENDRE_ASSETS
