/* Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 *
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 *
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 *
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 */

// This product includes color specifications and designs developed by Cynthia Brewer (http://colorbrewer.org/).
// JavaScript specs as packaged in the D3 library (d3js.org). Please see license at http://colorbrewer.org/export/LICENSE.txt
const colorbrewer = {
  Spectral: {
    '3': ['rgb(252,141,89)', 'rgb(255,255,191)', 'rgb(153,213,148)'],
    '4': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(171,221,164)',
      'rgb(43,131,186)',
    ],
    '5': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(255,255,191)',
      'rgb(171,221,164)',
      'rgb(43,131,186)',
    ],
    '6': [
      'rgb(213,62,79)',
      'rgb(252,141,89)',
      'rgb(254,224,139)',
      'rgb(230,245,152)',
      'rgb(153,213,148)',
      'rgb(50,136,189)',
    ],
    '7': [
      'rgb(213,62,79)',
      'rgb(252,141,89)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(230,245,152)',
      'rgb(153,213,148)',
      'rgb(50,136,189)',
    ],
    '8': [
      'rgb(213,62,79)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(230,245,152)',
      'rgb(171,221,164)',
      'rgb(102,194,165)',
      'rgb(50,136,189)',
    ],
    '9': [
      'rgb(213,62,79)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(230,245,152)',
      'rgb(171,221,164)',
      'rgb(102,194,165)',
      'rgb(50,136,189)',
    ],
    '10': [
      'rgb(158,1,66)',
      'rgb(213,62,79)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(230,245,152)',
      'rgb(171,221,164)',
      'rgb(102,194,165)',
      'rgb(50,136,189)',
      'rgb(94,79,162)',
    ],
    '11': [
      'rgb(158,1,66)',
      'rgb(213,62,79)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(230,245,152)',
      'rgb(171,221,164)',
      'rgb(102,194,165)',
      'rgb(50,136,189)',
      'rgb(94,79,162)',
    ],
    type: 'div',
  },
  RdYlGn: {
    '3': ['rgb(252,141,89)', 'rgb(255,255,191)', 'rgb(145,207,96)'],
    '4': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(166,217,106)',
      'rgb(26,150,65)',
    ],
    '5': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(255,255,191)',
      'rgb(166,217,106)',
      'rgb(26,150,65)',
    ],
    '6': [
      'rgb(215,48,39)',
      'rgb(252,141,89)',
      'rgb(254,224,139)',
      'rgb(217,239,139)',
      'rgb(145,207,96)',
      'rgb(26,152,80)',
    ],
    '7': [
      'rgb(215,48,39)',
      'rgb(252,141,89)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(217,239,139)',
      'rgb(145,207,96)',
      'rgb(26,152,80)',
    ],
    '8': [
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(217,239,139)',
      'rgb(166,217,106)',
      'rgb(102,189,99)',
      'rgb(26,152,80)',
    ],
    '9': [
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(217,239,139)',
      'rgb(166,217,106)',
      'rgb(102,189,99)',
      'rgb(26,152,80)',
    ],
    '10': [
      'rgb(165,0,38)',
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(217,239,139)',
      'rgb(166,217,106)',
      'rgb(102,189,99)',
      'rgb(26,152,80)',
      'rgb(0,104,55)',
    ],
    '11': [
      'rgb(165,0,38)',
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,139)',
      'rgb(255,255,191)',
      'rgb(217,239,139)',
      'rgb(166,217,106)',
      'rgb(102,189,99)',
      'rgb(26,152,80)',
      'rgb(0,104,55)',
    ],
    type: 'div',
  },
  RdBu: {
    '3': ['rgb(239,138,98)', 'rgb(247,247,247)', 'rgb(103,169,207)'],
    '4': [
      'rgb(202,0,32)',
      'rgb(244,165,130)',
      'rgb(146,197,222)',
      'rgb(5,113,176)',
    ],
    '5': [
      'rgb(202,0,32)',
      'rgb(244,165,130)',
      'rgb(247,247,247)',
      'rgb(146,197,222)',
      'rgb(5,113,176)',
    ],
    '6': [
      'rgb(178,24,43)',
      'rgb(239,138,98)',
      'rgb(253,219,199)',
      'rgb(209,229,240)',
      'rgb(103,169,207)',
      'rgb(33,102,172)',
    ],
    '7': [
      'rgb(178,24,43)',
      'rgb(239,138,98)',
      'rgb(253,219,199)',
      'rgb(247,247,247)',
      'rgb(209,229,240)',
      'rgb(103,169,207)',
      'rgb(33,102,172)',
    ],
    '8': [
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(209,229,240)',
      'rgb(146,197,222)',
      'rgb(67,147,195)',
      'rgb(33,102,172)',
    ],
    '9': [
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(247,247,247)',
      'rgb(209,229,240)',
      'rgb(146,197,222)',
      'rgb(67,147,195)',
      'rgb(33,102,172)',
    ],
    '10': [
      'rgb(103,0,31)',
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(209,229,240)',
      'rgb(146,197,222)',
      'rgb(67,147,195)',
      'rgb(33,102,172)',
      'rgb(5,48,97)',
    ],
    '11': [
      'rgb(103,0,31)',
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(247,247,247)',
      'rgb(209,229,240)',
      'rgb(146,197,222)',
      'rgb(67,147,195)',
      'rgb(33,102,172)',
      'rgb(5,48,97)',
    ],
    type: 'div',
  },
  PiYG: {
    '3': ['rgb(233,163,201)', 'rgb(247,247,247)', 'rgb(161,215,106)'],
    '4': [
      'rgb(208,28,139)',
      'rgb(241,182,218)',
      'rgb(184,225,134)',
      'rgb(77,172,38)',
    ],
    '5': [
      'rgb(208,28,139)',
      'rgb(241,182,218)',
      'rgb(247,247,247)',
      'rgb(184,225,134)',
      'rgb(77,172,38)',
    ],
    '6': [
      'rgb(197,27,125)',
      'rgb(233,163,201)',
      'rgb(253,224,239)',
      'rgb(230,245,208)',
      'rgb(161,215,106)',
      'rgb(77,146,33)',
    ],
    '7': [
      'rgb(197,27,125)',
      'rgb(233,163,201)',
      'rgb(253,224,239)',
      'rgb(247,247,247)',
      'rgb(230,245,208)',
      'rgb(161,215,106)',
      'rgb(77,146,33)',
    ],
    '8': [
      'rgb(197,27,125)',
      'rgb(222,119,174)',
      'rgb(241,182,218)',
      'rgb(253,224,239)',
      'rgb(230,245,208)',
      'rgb(184,225,134)',
      'rgb(127,188,65)',
      'rgb(77,146,33)',
    ],
    '9': [
      'rgb(197,27,125)',
      'rgb(222,119,174)',
      'rgb(241,182,218)',
      'rgb(253,224,239)',
      'rgb(247,247,247)',
      'rgb(230,245,208)',
      'rgb(184,225,134)',
      'rgb(127,188,65)',
      'rgb(77,146,33)',
    ],
    '10': [
      'rgb(142,1,82)',
      'rgb(197,27,125)',
      'rgb(222,119,174)',
      'rgb(241,182,218)',
      'rgb(253,224,239)',
      'rgb(230,245,208)',
      'rgb(184,225,134)',
      'rgb(127,188,65)',
      'rgb(77,146,33)',
      'rgb(39,100,25)',
    ],
    '11': [
      'rgb(142,1,82)',
      'rgb(197,27,125)',
      'rgb(222,119,174)',
      'rgb(241,182,218)',
      'rgb(253,224,239)',
      'rgb(247,247,247)',
      'rgb(230,245,208)',
      'rgb(184,225,134)',
      'rgb(127,188,65)',
      'rgb(77,146,33)',
      'rgb(39,100,25)',
    ],
    type: 'div',
  },
  PRGn: {
    '3': ['rgb(175,141,195)', 'rgb(247,247,247)', 'rgb(127,191,123)'],
    '4': [
      'rgb(123,50,148)',
      'rgb(194,165,207)',
      'rgb(166,219,160)',
      'rgb(0,136,55)',
    ],
    '5': [
      'rgb(123,50,148)',
      'rgb(194,165,207)',
      'rgb(247,247,247)',
      'rgb(166,219,160)',
      'rgb(0,136,55)',
    ],
    '6': [
      'rgb(118,42,131)',
      'rgb(175,141,195)',
      'rgb(231,212,232)',
      'rgb(217,240,211)',
      'rgb(127,191,123)',
      'rgb(27,120,55)',
    ],
    '7': [
      'rgb(118,42,131)',
      'rgb(175,141,195)',
      'rgb(231,212,232)',
      'rgb(247,247,247)',
      'rgb(217,240,211)',
      'rgb(127,191,123)',
      'rgb(27,120,55)',
    ],
    '8': [
      'rgb(118,42,131)',
      'rgb(153,112,171)',
      'rgb(194,165,207)',
      'rgb(231,212,232)',
      'rgb(217,240,211)',
      'rgb(166,219,160)',
      'rgb(90,174,97)',
      'rgb(27,120,55)',
    ],
    '9': [
      'rgb(118,42,131)',
      'rgb(153,112,171)',
      'rgb(194,165,207)',
      'rgb(231,212,232)',
      'rgb(247,247,247)',
      'rgb(217,240,211)',
      'rgb(166,219,160)',
      'rgb(90,174,97)',
      'rgb(27,120,55)',
    ],
    '10': [
      'rgb(64,0,75)',
      'rgb(118,42,131)',
      'rgb(153,112,171)',
      'rgb(194,165,207)',
      'rgb(231,212,232)',
      'rgb(217,240,211)',
      'rgb(166,219,160)',
      'rgb(90,174,97)',
      'rgb(27,120,55)',
      'rgb(0,68,27)',
    ],
    '11': [
      'rgb(64,0,75)',
      'rgb(118,42,131)',
      'rgb(153,112,171)',
      'rgb(194,165,207)',
      'rgb(231,212,232)',
      'rgb(247,247,247)',
      'rgb(217,240,211)',
      'rgb(166,219,160)',
      'rgb(90,174,97)',
      'rgb(27,120,55)',
      'rgb(0,68,27)',
    ],
    type: 'div',
  },
  RdYlBu: {
    '3': ['rgb(252,141,89)', 'rgb(255,255,191)', 'rgb(145,191,219)'],
    '4': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(171,217,233)',
      'rgb(44,123,182)',
    ],
    '5': [
      'rgb(215,25,28)',
      'rgb(253,174,97)',
      'rgb(255,255,191)',
      'rgb(171,217,233)',
      'rgb(44,123,182)',
    ],
    '6': [
      'rgb(215,48,39)',
      'rgb(252,141,89)',
      'rgb(254,224,144)',
      'rgb(224,243,248)',
      'rgb(145,191,219)',
      'rgb(69,117,180)',
    ],
    '7': [
      'rgb(215,48,39)',
      'rgb(252,141,89)',
      'rgb(254,224,144)',
      'rgb(255,255,191)',
      'rgb(224,243,248)',
      'rgb(145,191,219)',
      'rgb(69,117,180)',
    ],
    '8': [
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,144)',
      'rgb(224,243,248)',
      'rgb(171,217,233)',
      'rgb(116,173,209)',
      'rgb(69,117,180)',
    ],
    '9': [
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,144)',
      'rgb(255,255,191)',
      'rgb(224,243,248)',
      'rgb(171,217,233)',
      'rgb(116,173,209)',
      'rgb(69,117,180)',
    ],
    '10': [
      'rgb(165,0,38)',
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,144)',
      'rgb(224,243,248)',
      'rgb(171,217,233)',
      'rgb(116,173,209)',
      'rgb(69,117,180)',
      'rgb(49,54,149)',
    ],
    '11': [
      'rgb(165,0,38)',
      'rgb(215,48,39)',
      'rgb(244,109,67)',
      'rgb(253,174,97)',
      'rgb(254,224,144)',
      'rgb(255,255,191)',
      'rgb(224,243,248)',
      'rgb(171,217,233)',
      'rgb(116,173,209)',
      'rgb(69,117,180)',
      'rgb(49,54,149)',
    ],
    type: 'div',
  },
  BrBG: {
    '3': ['rgb(216,179,101)', 'rgb(245,245,245)', 'rgb(90,180,172)'],
    '4': [
      'rgb(166,97,26)',
      'rgb(223,194,125)',
      'rgb(128,205,193)',
      'rgb(1,133,113)',
    ],
    '5': [
      'rgb(166,97,26)',
      'rgb(223,194,125)',
      'rgb(245,245,245)',
      'rgb(128,205,193)',
      'rgb(1,133,113)',
    ],
    '6': [
      'rgb(140,81,10)',
      'rgb(216,179,101)',
      'rgb(246,232,195)',
      'rgb(199,234,229)',
      'rgb(90,180,172)',
      'rgb(1,102,94)',
    ],
    '7': [
      'rgb(140,81,10)',
      'rgb(216,179,101)',
      'rgb(246,232,195)',
      'rgb(245,245,245)',
      'rgb(199,234,229)',
      'rgb(90,180,172)',
      'rgb(1,102,94)',
    ],
    '8': [
      'rgb(140,81,10)',
      'rgb(191,129,45)',
      'rgb(223,194,125)',
      'rgb(246,232,195)',
      'rgb(199,234,229)',
      'rgb(128,205,193)',
      'rgb(53,151,143)',
      'rgb(1,102,94)',
    ],
    '9': [
      'rgb(140,81,10)',
      'rgb(191,129,45)',
      'rgb(223,194,125)',
      'rgb(246,232,195)',
      'rgb(245,245,245)',
      'rgb(199,234,229)',
      'rgb(128,205,193)',
      'rgb(53,151,143)',
      'rgb(1,102,94)',
    ],
    '10': [
      'rgb(84,48,5)',
      'rgb(140,81,10)',
      'rgb(191,129,45)',
      'rgb(223,194,125)',
      'rgb(246,232,195)',
      'rgb(199,234,229)',
      'rgb(128,205,193)',
      'rgb(53,151,143)',
      'rgb(1,102,94)',
      'rgb(0,60,48)',
    ],
    '11': [
      'rgb(84,48,5)',
      'rgb(140,81,10)',
      'rgb(191,129,45)',
      'rgb(223,194,125)',
      'rgb(246,232,195)',
      'rgb(245,245,245)',
      'rgb(199,234,229)',
      'rgb(128,205,193)',
      'rgb(53,151,143)',
      'rgb(1,102,94)',
      'rgb(0,60,48)',
    ],
    type: 'div',
  },
  RdGy: {
    '3': ['rgb(239,138,98)', 'rgb(255,255,255)', 'rgb(153,153,153)'],
    '4': [
      'rgb(202,0,32)',
      'rgb(244,165,130)',
      'rgb(186,186,186)',
      'rgb(64,64,64)',
    ],
    '5': [
      'rgb(202,0,32)',
      'rgb(244,165,130)',
      'rgb(255,255,255)',
      'rgb(186,186,186)',
      'rgb(64,64,64)',
    ],
    '6': [
      'rgb(178,24,43)',
      'rgb(239,138,98)',
      'rgb(253,219,199)',
      'rgb(224,224,224)',
      'rgb(153,153,153)',
      'rgb(77,77,77)',
    ],
    '7': [
      'rgb(178,24,43)',
      'rgb(239,138,98)',
      'rgb(253,219,199)',
      'rgb(255,255,255)',
      'rgb(224,224,224)',
      'rgb(153,153,153)',
      'rgb(77,77,77)',
    ],
    '8': [
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(224,224,224)',
      'rgb(186,186,186)',
      'rgb(135,135,135)',
      'rgb(77,77,77)',
    ],
    '9': [
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(255,255,255)',
      'rgb(224,224,224)',
      'rgb(186,186,186)',
      'rgb(135,135,135)',
      'rgb(77,77,77)',
    ],
    '10': [
      'rgb(103,0,31)',
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(224,224,224)',
      'rgb(186,186,186)',
      'rgb(135,135,135)',
      'rgb(77,77,77)',
      'rgb(26,26,26)',
    ],
    '11': [
      'rgb(103,0,31)',
      'rgb(178,24,43)',
      'rgb(214,96,77)',
      'rgb(244,165,130)',
      'rgb(253,219,199)',
      'rgb(255,255,255)',
      'rgb(224,224,224)',
      'rgb(186,186,186)',
      'rgb(135,135,135)',
      'rgb(77,77,77)',
      'rgb(26,26,26)',
    ],
    type: 'div',
  },
  PuOr: {
    '3': ['rgb(241,163,64)', 'rgb(247,247,247)', 'rgb(153,142,195)'],
    '4': [
      'rgb(230,97,1)',
      'rgb(253,184,99)',
      'rgb(178,171,210)',
      'rgb(94,60,153)',
    ],
    '5': [
      'rgb(230,97,1)',
      'rgb(253,184,99)',
      'rgb(247,247,247)',
      'rgb(178,171,210)',
      'rgb(94,60,153)',
    ],
    '6': [
      'rgb(179,88,6)',
      'rgb(241,163,64)',
      'rgb(254,224,182)',
      'rgb(216,218,235)',
      'rgb(153,142,195)',
      'rgb(84,39,136)',
    ],
    '7': [
      'rgb(179,88,6)',
      'rgb(241,163,64)',
      'rgb(254,224,182)',
      'rgb(247,247,247)',
      'rgb(216,218,235)',
      'rgb(153,142,195)',
      'rgb(84,39,136)',
    ],
    '8': [
      'rgb(179,88,6)',
      'rgb(224,130,20)',
      'rgb(253,184,99)',
      'rgb(254,224,182)',
      'rgb(216,218,235)',
      'rgb(178,171,210)',
      'rgb(128,115,172)',
      'rgb(84,39,136)',
    ],
    '9': [
      'rgb(179,88,6)',
      'rgb(224,130,20)',
      'rgb(253,184,99)',
      'rgb(254,224,182)',
      'rgb(247,247,247)',
      'rgb(216,218,235)',
      'rgb(178,171,210)',
      'rgb(128,115,172)',
      'rgb(84,39,136)',
    ],
    '10': [
      'rgb(127,59,8)',
      'rgb(179,88,6)',
      'rgb(224,130,20)',
      'rgb(253,184,99)',
      'rgb(254,224,182)',
      'rgb(216,218,235)',
      'rgb(178,171,210)',
      'rgb(128,115,172)',
      'rgb(84,39,136)',
      'rgb(45,0,75)',
    ],
    '11': [
      'rgb(127,59,8)',
      'rgb(179,88,6)',
      'rgb(224,130,20)',
      'rgb(253,184,99)',
      'rgb(254,224,182)',
      'rgb(247,247,247)',
      'rgb(216,218,235)',
      'rgb(178,171,210)',
      'rgb(128,115,172)',
      'rgb(84,39,136)',
      'rgb(45,0,75)',
    ],
    type: 'div',
  },

  Set2: {
    '3': ['rgb(102,194,165)', 'rgb(252,141,98)', 'rgb(141,160,203)'],
    '4': [
      'rgb(102,194,165)',
      'rgb(252,141,98)',
      'rgb(141,160,203)',
      'rgb(231,138,195)',
    ],
    '5': [
      'rgb(102,194,165)',
      'rgb(252,141,98)',
      'rgb(141,160,203)',
      'rgb(231,138,195)',
      'rgb(166,216,84)',
    ],
    '6': [
      'rgb(102,194,165)',
      'rgb(252,141,98)',
      'rgb(141,160,203)',
      'rgb(231,138,195)',
      'rgb(166,216,84)',
      'rgb(255,217,47)',
    ],
    '7': [
      'rgb(102,194,165)',
      'rgb(252,141,98)',
      'rgb(141,160,203)',
      'rgb(231,138,195)',
      'rgb(166,216,84)',
      'rgb(255,217,47)',
      'rgb(229,196,148)',
    ],
    '8': [
      'rgb(102,194,165)',
      'rgb(252,141,98)',
      'rgb(141,160,203)',
      'rgb(231,138,195)',
      'rgb(166,216,84)',
      'rgb(255,217,47)',
      'rgb(229,196,148)',
      'rgb(179,179,179)',
    ],
    type: 'qual',
  },
  Accent: {
    '3': ['rgb(127,201,127)', 'rgb(190,174,212)', 'rgb(253,192,134)'],
    '4': [
      'rgb(127,201,127)',
      'rgb(190,174,212)',
      'rgb(253,192,134)',
      'rgb(255,255,153)',
    ],
    '5': [
      'rgb(127,201,127)',
      'rgb(190,174,212)',
      'rgb(253,192,134)',
      'rgb(255,255,153)',
      'rgb(56,108,176)',
    ],
    '6': [
      'rgb(127,201,127)',
      'rgb(190,174,212)',
      'rgb(253,192,134)',
      'rgb(255,255,153)',
      'rgb(56,108,176)',
      'rgb(240,2,127)',
    ],
    '7': [
      'rgb(127,201,127)',
      'rgb(190,174,212)',
      'rgb(253,192,134)',
      'rgb(255,255,153)',
      'rgb(56,108,176)',
      'rgb(240,2,127)',
      'rgb(191,91,23)',
    ],
    '8': [
      'rgb(127,201,127)',
      'rgb(190,174,212)',
      'rgb(253,192,134)',
      'rgb(255,255,153)',
      'rgb(56,108,176)',
      'rgb(240,2,127)',
      'rgb(191,91,23)',
      'rgb(102,102,102)',
    ],
    type: 'qual',
  },
  Set1: {
    '3': ['rgb(228,26,28)', 'rgb(55,126,184)', 'rgb(77,175,74)'],
    '4': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
    ],
    '5': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
      'rgb(255,127,0)',
    ],
    '6': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
      'rgb(255,127,0)',
      'rgb(255,255,51)',
    ],
    '7': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
      'rgb(255,127,0)',
      'rgb(255,255,51)',
      'rgb(166,86,40)',
    ],
    '8': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
      'rgb(255,127,0)',
      'rgb(255,255,51)',
      'rgb(166,86,40)',
      'rgb(247,129,191)',
    ],
    '9': [
      'rgb(228,26,28)',
      'rgb(55,126,184)',
      'rgb(77,175,74)',
      'rgb(152,78,163)',
      'rgb(255,127,0)',
      'rgb(255,255,51)',
      'rgb(166,86,40)',
      'rgb(247,129,191)',
      'rgb(153,153,153)',
    ],
    type: 'qual',
  },
  Set3: {
    '3': ['rgb(141,211,199)', 'rgb(255,255,179)', 'rgb(190,186,218)'],
    '4': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
    ],
    '5': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
    ],
    '6': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
    ],
    '7': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
    ],
    '8': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
      'rgb(252,205,229)',
    ],
    '9': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
      'rgb(252,205,229)',
      'rgb(217,217,217)',
    ],
    '10': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
      'rgb(252,205,229)',
      'rgb(217,217,217)',
      'rgb(188,128,189)',
    ],
    '11': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
      'rgb(252,205,229)',
      'rgb(217,217,217)',
      'rgb(188,128,189)',
      'rgb(204,235,197)',
    ],
    '12': [
      'rgb(141,211,199)',
      'rgb(255,255,179)',
      'rgb(190,186,218)',
      'rgb(251,128,114)',
      'rgb(128,177,211)',
      'rgb(253,180,98)',
      'rgb(179,222,105)',
      'rgb(252,205,229)',
      'rgb(217,217,217)',
      'rgb(188,128,189)',
      'rgb(204,235,197)',
      'rgb(255,237,111)',
    ],
    type: 'qual',
  },
  Dark2: {
    '3': ['rgb(27,158,119)', 'rgb(217,95,2)', 'rgb(117,112,179)'],
    '4': [
      'rgb(27,158,119)',
      'rgb(217,95,2)',
      'rgb(117,112,179)',
      'rgb(231,41,138)',
    ],
    '5': [
      'rgb(27,158,119)',
      'rgb(217,95,2)',
      'rgb(117,112,179)',
      'rgb(231,41,138)',
      'rgb(102,166,30)',
    ],
    '6': [
      'rgb(27,158,119)',
      'rgb(217,95,2)',
      'rgb(117,112,179)',
      'rgb(231,41,138)',
      'rgb(102,166,30)',
      'rgb(230,171,2)',
    ],
    '7': [
      'rgb(27,158,119)',
      'rgb(217,95,2)',
      'rgb(117,112,179)',
      'rgb(231,41,138)',
      'rgb(102,166,30)',
      'rgb(230,171,2)',
      'rgb(166,118,29)',
    ],
    '8': [
      'rgb(27,158,119)',
      'rgb(217,95,2)',
      'rgb(117,112,179)',
      'rgb(231,41,138)',
      'rgb(102,166,30)',
      'rgb(230,171,2)',
      'rgb(166,118,29)',
      'rgb(102,102,102)',
    ],
    type: 'qual',
  },
  Paired: {
    '3': ['rgb(166,206,227)', 'rgb(31,120,180)', 'rgb(178,223,138)'],
    '4': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
    ],
    '5': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
    ],
    '6': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
    ],
    '7': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
    ],
    '8': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
      'rgb(255,127,0)',
    ],
    '9': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
      'rgb(255,127,0)',
      'rgb(202,178,214)',
    ],
    '10': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
      'rgb(255,127,0)',
      'rgb(202,178,214)',
      'rgb(106,61,154)',
    ],
    '11': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
      'rgb(255,127,0)',
      'rgb(202,178,214)',
      'rgb(106,61,154)',
      'rgb(255,255,153)',
    ],
    '12': [
      'rgb(166,206,227)',
      'rgb(31,120,180)',
      'rgb(178,223,138)',
      'rgb(51,160,44)',
      'rgb(251,154,153)',
      'rgb(227,26,28)',
      'rgb(253,191,111)',
      'rgb(255,127,0)',
      'rgb(202,178,214)',
      'rgb(106,61,154)',
      'rgb(255,255,153)',
      'rgb(177,89,40)',
    ],
    type: 'qual',
  },
  Pastel2: {
    '3': ['rgb(179,226,205)', 'rgb(253,205,172)', 'rgb(203,213,232)'],
    '4': [
      'rgb(179,226,205)',
      'rgb(253,205,172)',
      'rgb(203,213,232)',
      'rgb(244,202,228)',
    ],
    '5': [
      'rgb(179,226,205)',
      'rgb(253,205,172)',
      'rgb(203,213,232)',
      'rgb(244,202,228)',
      'rgb(230,245,201)',
    ],
    '6': [
      'rgb(179,226,205)',
      'rgb(253,205,172)',
      'rgb(203,213,232)',
      'rgb(244,202,228)',
      'rgb(230,245,201)',
      'rgb(255,242,174)',
    ],
    '7': [
      'rgb(179,226,205)',
      'rgb(253,205,172)',
      'rgb(203,213,232)',
      'rgb(244,202,228)',
      'rgb(230,245,201)',
      'rgb(255,242,174)',
      'rgb(241,226,204)',
    ],
    '8': [
      'rgb(179,226,205)',
      'rgb(253,205,172)',
      'rgb(203,213,232)',
      'rgb(244,202,228)',
      'rgb(230,245,201)',
      'rgb(255,242,174)',
      'rgb(241,226,204)',
      'rgb(204,204,204)',
    ],
    type: 'qual',
  },
  Pastel1: {
    '3': ['rgb(251,180,174)', 'rgb(179,205,227)', 'rgb(204,235,197)'],
    '4': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
    ],
    '5': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
      'rgb(254,217,166)',
    ],
    '6': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
      'rgb(254,217,166)',
      'rgb(255,255,204)',
    ],
    '7': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
      'rgb(254,217,166)',
      'rgb(255,255,204)',
      'rgb(229,216,189)',
    ],
    '8': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
      'rgb(254,217,166)',
      'rgb(255,255,204)',
      'rgb(229,216,189)',
      'rgb(253,218,236)',
    ],
    '9': [
      'rgb(251,180,174)',
      'rgb(179,205,227)',
      'rgb(204,235,197)',
      'rgb(222,203,228)',
      'rgb(254,217,166)',
      'rgb(255,255,204)',
      'rgb(229,216,189)',
      'rgb(253,218,236)',
      'rgb(242,242,242)',
    ],
    type: 'qual',
  },

  OrRd: {
    '3': ['rgb(254,232,200)', 'rgb(253,187,132)', 'rgb(227,74,51)'],
    '4': [
      'rgb(254,240,217)',
      'rgb(253,204,138)',
      'rgb(252,141,89)',
      'rgb(215,48,31)',
    ],
    '5': [
      'rgb(254,240,217)',
      'rgb(253,204,138)',
      'rgb(252,141,89)',
      'rgb(227,74,51)',
      'rgb(179,0,0)',
    ],
    '6': [
      'rgb(254,240,217)',
      'rgb(253,212,158)',
      'rgb(253,187,132)',
      'rgb(252,141,89)',
      'rgb(227,74,51)',
      'rgb(179,0,0)',
    ],
    '7': [
      'rgb(254,240,217)',
      'rgb(253,212,158)',
      'rgb(253,187,132)',
      'rgb(252,141,89)',
      'rgb(239,101,72)',
      'rgb(215,48,31)',
      'rgb(153,0,0)',
    ],
    '8': [
      'rgb(255,247,236)',
      'rgb(254,232,200)',
      'rgb(253,212,158)',
      'rgb(253,187,132)',
      'rgb(252,141,89)',
      'rgb(239,101,72)',
      'rgb(215,48,31)',
      'rgb(153,0,0)',
    ],
    '9': [
      'rgb(255,247,236)',
      'rgb(254,232,200)',
      'rgb(253,212,158)',
      'rgb(253,187,132)',
      'rgb(252,141,89)',
      'rgb(239,101,72)',
      'rgb(215,48,31)',
      'rgb(179,0,0)',
      'rgb(127,0,0)',
    ],
    type: 'seq',
  },
  PuBu: {
    '3': ['rgb(236,231,242)', 'rgb(166,189,219)', 'rgb(43,140,190)'],
    '4': [
      'rgb(241,238,246)',
      'rgb(189,201,225)',
      'rgb(116,169,207)',
      'rgb(5,112,176)',
    ],
    '5': [
      'rgb(241,238,246)',
      'rgb(189,201,225)',
      'rgb(116,169,207)',
      'rgb(43,140,190)',
      'rgb(4,90,141)',
    ],
    '6': [
      'rgb(241,238,246)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(116,169,207)',
      'rgb(43,140,190)',
      'rgb(4,90,141)',
    ],
    '7': [
      'rgb(241,238,246)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(116,169,207)',
      'rgb(54,144,192)',
      'rgb(5,112,176)',
      'rgb(3,78,123)',
    ],
    '8': [
      'rgb(255,247,251)',
      'rgb(236,231,242)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(116,169,207)',
      'rgb(54,144,192)',
      'rgb(5,112,176)',
      'rgb(3,78,123)',
    ],
    '9': [
      'rgb(255,247,251)',
      'rgb(236,231,242)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(116,169,207)',
      'rgb(54,144,192)',
      'rgb(5,112,176)',
      'rgb(4,90,141)',
      'rgb(2,56,88)',
    ],
    type: 'seq',
  },
  BuPu: {
    '3': ['rgb(224,236,244)', 'rgb(158,188,218)', 'rgb(136,86,167)'],
    '4': [
      'rgb(237,248,251)',
      'rgb(179,205,227)',
      'rgb(140,150,198)',
      'rgb(136,65,157)',
    ],
    '5': [
      'rgb(237,248,251)',
      'rgb(179,205,227)',
      'rgb(140,150,198)',
      'rgb(136,86,167)',
      'rgb(129,15,124)',
    ],
    '6': [
      'rgb(237,248,251)',
      'rgb(191,211,230)',
      'rgb(158,188,218)',
      'rgb(140,150,198)',
      'rgb(136,86,167)',
      'rgb(129,15,124)',
    ],
    '7': [
      'rgb(237,248,251)',
      'rgb(191,211,230)',
      'rgb(158,188,218)',
      'rgb(140,150,198)',
      'rgb(140,107,177)',
      'rgb(136,65,157)',
      'rgb(110,1,107)',
    ],
    '8': [
      'rgb(247,252,253)',
      'rgb(224,236,244)',
      'rgb(191,211,230)',
      'rgb(158,188,218)',
      'rgb(140,150,198)',
      'rgb(140,107,177)',
      'rgb(136,65,157)',
      'rgb(110,1,107)',
    ],
    '9': [
      'rgb(247,252,253)',
      'rgb(224,236,244)',
      'rgb(191,211,230)',
      'rgb(158,188,218)',
      'rgb(140,150,198)',
      'rgb(140,107,177)',
      'rgb(136,65,157)',
      'rgb(129,15,124)',
      'rgb(77,0,75)',
    ],
    type: 'seq',
  },
  Oranges: {
    '3': ['rgb(254,230,206)', 'rgb(253,174,107)', 'rgb(230,85,13)'],
    '4': [
      'rgb(254,237,222)',
      'rgb(253,190,133)',
      'rgb(253,141,60)',
      'rgb(217,71,1)',
    ],
    '5': [
      'rgb(254,237,222)',
      'rgb(253,190,133)',
      'rgb(253,141,60)',
      'rgb(230,85,13)',
      'rgb(166,54,3)',
    ],
    '6': [
      'rgb(254,237,222)',
      'rgb(253,208,162)',
      'rgb(253,174,107)',
      'rgb(253,141,60)',
      'rgb(230,85,13)',
      'rgb(166,54,3)',
    ],
    '7': [
      'rgb(254,237,222)',
      'rgb(253,208,162)',
      'rgb(253,174,107)',
      'rgb(253,141,60)',
      'rgb(241,105,19)',
      'rgb(217,72,1)',
      'rgb(140,45,4)',
    ],
    '8': [
      'rgb(255,245,235)',
      'rgb(254,230,206)',
      'rgb(253,208,162)',
      'rgb(253,174,107)',
      'rgb(253,141,60)',
      'rgb(241,105,19)',
      'rgb(217,72,1)',
      'rgb(140,45,4)',
    ],
    '9': [
      'rgb(255,245,235)',
      'rgb(254,230,206)',
      'rgb(253,208,162)',
      'rgb(253,174,107)',
      'rgb(253,141,60)',
      'rgb(241,105,19)',
      'rgb(217,72,1)',
      'rgb(166,54,3)',
      'rgb(127,39,4)',
    ],
    type: 'seq',
  },
  BuGn: {
    '3': ['rgb(229,245,249)', 'rgb(153,216,201)', 'rgb(44,162,95)'],
    '4': [
      'rgb(237,248,251)',
      'rgb(178,226,226)',
      'rgb(102,194,164)',
      'rgb(35,139,69)',
    ],
    '5': [
      'rgb(237,248,251)',
      'rgb(178,226,226)',
      'rgb(102,194,164)',
      'rgb(44,162,95)',
      'rgb(0,109,44)',
    ],
    '6': [
      'rgb(237,248,251)',
      'rgb(204,236,230)',
      'rgb(153,216,201)',
      'rgb(102,194,164)',
      'rgb(44,162,95)',
      'rgb(0,109,44)',
    ],
    '7': [
      'rgb(237,248,251)',
      'rgb(204,236,230)',
      'rgb(153,216,201)',
      'rgb(102,194,164)',
      'rgb(65,174,118)',
      'rgb(35,139,69)',
      'rgb(0,88,36)',
    ],
    '8': [
      'rgb(247,252,253)',
      'rgb(229,245,249)',
      'rgb(204,236,230)',
      'rgb(153,216,201)',
      'rgb(102,194,164)',
      'rgb(65,174,118)',
      'rgb(35,139,69)',
      'rgb(0,88,36)',
    ],
    '9': [
      'rgb(247,252,253)',
      'rgb(229,245,249)',
      'rgb(204,236,230)',
      'rgb(153,216,201)',
      'rgb(102,194,164)',
      'rgb(65,174,118)',
      'rgb(35,139,69)',
      'rgb(0,109,44)',
      'rgb(0,68,27)',
    ],
    type: 'seq',
  },
  YlOrBr: {
    '3': ['rgb(255,247,188)', 'rgb(254,196,79)', 'rgb(217,95,14)'],
    '4': [
      'rgb(255,255,212)',
      'rgb(254,217,142)',
      'rgb(254,153,41)',
      'rgb(204,76,2)',
    ],
    '5': [
      'rgb(255,255,212)',
      'rgb(254,217,142)',
      'rgb(254,153,41)',
      'rgb(217,95,14)',
      'rgb(153,52,4)',
    ],
    '6': [
      'rgb(255,255,212)',
      'rgb(254,227,145)',
      'rgb(254,196,79)',
      'rgb(254,153,41)',
      'rgb(217,95,14)',
      'rgb(153,52,4)',
    ],
    '7': [
      'rgb(255,255,212)',
      'rgb(254,227,145)',
      'rgb(254,196,79)',
      'rgb(254,153,41)',
      'rgb(236,112,20)',
      'rgb(204,76,2)',
      'rgb(140,45,4)',
    ],
    '8': [
      'rgb(255,255,229)',
      'rgb(255,247,188)',
      'rgb(254,227,145)',
      'rgb(254,196,79)',
      'rgb(254,153,41)',
      'rgb(236,112,20)',
      'rgb(204,76,2)',
      'rgb(140,45,4)',
    ],
    '9': [
      'rgb(255,255,229)',
      'rgb(255,247,188)',
      'rgb(254,227,145)',
      'rgb(254,196,79)',
      'rgb(254,153,41)',
      'rgb(236,112,20)',
      'rgb(204,76,2)',
      'rgb(153,52,4)',
      'rgb(102,37,6)',
    ],
    type: 'seq',
  },
  YlGn: {
    '3': ['rgb(247,252,185)', 'rgb(173,221,142)', 'rgb(49,163,84)'],
    '4': [
      'rgb(255,255,204)',
      'rgb(194,230,153)',
      'rgb(120,198,121)',
      'rgb(35,132,67)',
    ],
    '5': [
      'rgb(255,255,204)',
      'rgb(194,230,153)',
      'rgb(120,198,121)',
      'rgb(49,163,84)',
      'rgb(0,104,55)',
    ],
    '6': [
      'rgb(255,255,204)',
      'rgb(217,240,163)',
      'rgb(173,221,142)',
      'rgb(120,198,121)',
      'rgb(49,163,84)',
      'rgb(0,104,55)',
    ],
    '7': [
      'rgb(255,255,204)',
      'rgb(217,240,163)',
      'rgb(173,221,142)',
      'rgb(120,198,121)',
      'rgb(65,171,93)',
      'rgb(35,132,67)',
      'rgb(0,90,50)',
    ],
    '8': [
      'rgb(255,255,229)',
      'rgb(247,252,185)',
      'rgb(217,240,163)',
      'rgb(173,221,142)',
      'rgb(120,198,121)',
      'rgb(65,171,93)',
      'rgb(35,132,67)',
      'rgb(0,90,50)',
    ],
    '9': [
      'rgb(255,255,229)',
      'rgb(247,252,185)',
      'rgb(217,240,163)',
      'rgb(173,221,142)',
      'rgb(120,198,121)',
      'rgb(65,171,93)',
      'rgb(35,132,67)',
      'rgb(0,104,55)',
      'rgb(0,69,41)',
    ],
    type: 'seq',
  },
  Reds: {
    '3': ['rgb(254,224,210)', 'rgb(252,146,114)', 'rgb(222,45,38)'],
    '4': [
      'rgb(254,229,217)',
      'rgb(252,174,145)',
      'rgb(251,106,74)',
      'rgb(203,24,29)',
    ],
    '5': [
      'rgb(254,229,217)',
      'rgb(252,174,145)',
      'rgb(251,106,74)',
      'rgb(222,45,38)',
      'rgb(165,15,21)',
    ],
    '6': [
      'rgb(254,229,217)',
      'rgb(252,187,161)',
      'rgb(252,146,114)',
      'rgb(251,106,74)',
      'rgb(222,45,38)',
      'rgb(165,15,21)',
    ],
    '7': [
      'rgb(254,229,217)',
      'rgb(252,187,161)',
      'rgb(252,146,114)',
      'rgb(251,106,74)',
      'rgb(239,59,44)',
      'rgb(203,24,29)',
      'rgb(153,0,13)',
    ],
    '8': [
      'rgb(255,245,240)',
      'rgb(254,224,210)',
      'rgb(252,187,161)',
      'rgb(252,146,114)',
      'rgb(251,106,74)',
      'rgb(239,59,44)',
      'rgb(203,24,29)',
      'rgb(153,0,13)',
    ],
    '9': [
      'rgb(255,245,240)',
      'rgb(254,224,210)',
      'rgb(252,187,161)',
      'rgb(252,146,114)',
      'rgb(251,106,74)',
      'rgb(239,59,44)',
      'rgb(203,24,29)',
      'rgb(165,15,21)',
      'rgb(103,0,13)',
    ],
    type: 'seq',
  },
  RdPu: {
    '3': ['rgb(253,224,221)', 'rgb(250,159,181)', 'rgb(197,27,138)'],
    '4': [
      'rgb(254,235,226)',
      'rgb(251,180,185)',
      'rgb(247,104,161)',
      'rgb(174,1,126)',
    ],
    '5': [
      'rgb(254,235,226)',
      'rgb(251,180,185)',
      'rgb(247,104,161)',
      'rgb(197,27,138)',
      'rgb(122,1,119)',
    ],
    '6': [
      'rgb(254,235,226)',
      'rgb(252,197,192)',
      'rgb(250,159,181)',
      'rgb(247,104,161)',
      'rgb(197,27,138)',
      'rgb(122,1,119)',
    ],
    '7': [
      'rgb(254,235,226)',
      'rgb(252,197,192)',
      'rgb(250,159,181)',
      'rgb(247,104,161)',
      'rgb(221,52,151)',
      'rgb(174,1,126)',
      'rgb(122,1,119)',
    ],
    '8': [
      'rgb(255,247,243)',
      'rgb(253,224,221)',
      'rgb(252,197,192)',
      'rgb(250,159,181)',
      'rgb(247,104,161)',
      'rgb(221,52,151)',
      'rgb(174,1,126)',
      'rgb(122,1,119)',
    ],
    '9': [
      'rgb(255,247,243)',
      'rgb(253,224,221)',
      'rgb(252,197,192)',
      'rgb(250,159,181)',
      'rgb(247,104,161)',
      'rgb(221,52,151)',
      'rgb(174,1,126)',
      'rgb(122,1,119)',
      'rgb(73,0,106)',
    ],
    type: 'seq',
  },
  Greens: {
    '3': ['rgb(229,245,224)', 'rgb(161,217,155)', 'rgb(49,163,84)'],
    '4': [
      'rgb(237,248,233)',
      'rgb(186,228,179)',
      'rgb(116,196,118)',
      'rgb(35,139,69)',
    ],
    '5': [
      'rgb(237,248,233)',
      'rgb(186,228,179)',
      'rgb(116,196,118)',
      'rgb(49,163,84)',
      'rgb(0,109,44)',
    ],
    '6': [
      'rgb(237,248,233)',
      'rgb(199,233,192)',
      'rgb(161,217,155)',
      'rgb(116,196,118)',
      'rgb(49,163,84)',
      'rgb(0,109,44)',
    ],
    '7': [
      'rgb(237,248,233)',
      'rgb(199,233,192)',
      'rgb(161,217,155)',
      'rgb(116,196,118)',
      'rgb(65,171,93)',
      'rgb(35,139,69)',
      'rgb(0,90,50)',
    ],
    '8': [
      'rgb(247,252,245)',
      'rgb(229,245,224)',
      'rgb(199,233,192)',
      'rgb(161,217,155)',
      'rgb(116,196,118)',
      'rgb(65,171,93)',
      'rgb(35,139,69)',
      'rgb(0,90,50)',
    ],
    '9': [
      'rgb(247,252,245)',
      'rgb(229,245,224)',
      'rgb(199,233,192)',
      'rgb(161,217,155)',
      'rgb(116,196,118)',
      'rgb(65,171,93)',
      'rgb(35,139,69)',
      'rgb(0,109,44)',
      'rgb(0,68,27)',
    ],
    type: 'seq',
  },
  YlGnBu: {
    '3': ['rgb(237,248,177)', 'rgb(127,205,187)', 'rgb(44,127,184)'],
    '4': [
      'rgb(255,255,204)',
      'rgb(161,218,180)',
      'rgb(65,182,196)',
      'rgb(34,94,168)',
    ],
    '5': [
      'rgb(255,255,204)',
      'rgb(161,218,180)',
      'rgb(65,182,196)',
      'rgb(44,127,184)',
      'rgb(37,52,148)',
    ],
    '6': [
      'rgb(255,255,204)',
      'rgb(199,233,180)',
      'rgb(127,205,187)',
      'rgb(65,182,196)',
      'rgb(44,127,184)',
      'rgb(37,52,148)',
    ],
    '7': [
      'rgb(255,255,204)',
      'rgb(199,233,180)',
      'rgb(127,205,187)',
      'rgb(65,182,196)',
      'rgb(29,145,192)',
      'rgb(34,94,168)',
      'rgb(12,44,132)',
    ],
    '8': [
      'rgb(255,255,217)',
      'rgb(237,248,177)',
      'rgb(199,233,180)',
      'rgb(127,205,187)',
      'rgb(65,182,196)',
      'rgb(29,145,192)',
      'rgb(34,94,168)',
      'rgb(12,44,132)',
    ],
    '9': [
      'rgb(255,255,217)',
      'rgb(237,248,177)',
      'rgb(199,233,180)',
      'rgb(127,205,187)',
      'rgb(65,182,196)',
      'rgb(29,145,192)',
      'rgb(34,94,168)',
      'rgb(37,52,148)',
      'rgb(8,29,88)',
    ],
    type: 'seq',
  },
  Purples: {
    '3': ['rgb(239,237,245)', 'rgb(188,189,220)', 'rgb(117,107,177)'],
    '4': [
      'rgb(242,240,247)',
      'rgb(203,201,226)',
      'rgb(158,154,200)',
      'rgb(106,81,163)',
    ],
    '5': [
      'rgb(242,240,247)',
      'rgb(203,201,226)',
      'rgb(158,154,200)',
      'rgb(117,107,177)',
      'rgb(84,39,143)',
    ],
    '6': [
      'rgb(242,240,247)',
      'rgb(218,218,235)',
      'rgb(188,189,220)',
      'rgb(158,154,200)',
      'rgb(117,107,177)',
      'rgb(84,39,143)',
    ],
    '7': [
      'rgb(242,240,247)',
      'rgb(218,218,235)',
      'rgb(188,189,220)',
      'rgb(158,154,200)',
      'rgb(128,125,186)',
      'rgb(106,81,163)',
      'rgb(74,20,134)',
    ],
    '8': [
      'rgb(252,251,253)',
      'rgb(239,237,245)',
      'rgb(218,218,235)',
      'rgb(188,189,220)',
      'rgb(158,154,200)',
      'rgb(128,125,186)',
      'rgb(106,81,163)',
      'rgb(74,20,134)',
    ],
    '9': [
      'rgb(252,251,253)',
      'rgb(239,237,245)',
      'rgb(218,218,235)',
      'rgb(188,189,220)',
      'rgb(158,154,200)',
      'rgb(128,125,186)',
      'rgb(106,81,163)',
      'rgb(84,39,143)',
      'rgb(63,0,125)',
    ],
    type: 'seq',
  },
  GnBu: {
    '3': ['rgb(224,243,219)', 'rgb(168,221,181)', 'rgb(67,162,202)'],
    '4': [
      'rgb(240,249,232)',
      'rgb(186,228,188)',
      'rgb(123,204,196)',
      'rgb(43,140,190)',
    ],
    '5': [
      'rgb(240,249,232)',
      'rgb(186,228,188)',
      'rgb(123,204,196)',
      'rgb(67,162,202)',
      'rgb(8,104,172)',
    ],
    '6': [
      'rgb(240,249,232)',
      'rgb(204,235,197)',
      'rgb(168,221,181)',
      'rgb(123,204,196)',
      'rgb(67,162,202)',
      'rgb(8,104,172)',
    ],
    '7': [
      'rgb(240,249,232)',
      'rgb(204,235,197)',
      'rgb(168,221,181)',
      'rgb(123,204,196)',
      'rgb(78,179,211)',
      'rgb(43,140,190)',
      'rgb(8,88,158)',
    ],
    '8': [
      'rgb(247,252,240)',
      'rgb(224,243,219)',
      'rgb(204,235,197)',
      'rgb(168,221,181)',
      'rgb(123,204,196)',
      'rgb(78,179,211)',
      'rgb(43,140,190)',
      'rgb(8,88,158)',
    ],
    '9': [
      'rgb(247,252,240)',
      'rgb(224,243,219)',
      'rgb(204,235,197)',
      'rgb(168,221,181)',
      'rgb(123,204,196)',
      'rgb(78,179,211)',
      'rgb(43,140,190)',
      'rgb(8,104,172)',
      'rgb(8,64,129)',
    ],
    type: 'seq',
  },
  Greys: {
    '3': ['rgb(240,240,240)', 'rgb(189,189,189)', 'rgb(99,99,99)'],
    '4': [
      'rgb(247,247,247)',
      'rgb(204,204,204)',
      'rgb(150,150,150)',
      'rgb(82,82,82)',
    ],
    '5': [
      'rgb(247,247,247)',
      'rgb(204,204,204)',
      'rgb(150,150,150)',
      'rgb(99,99,99)',
      'rgb(37,37,37)',
    ],
    '6': [
      'rgb(247,247,247)',
      'rgb(217,217,217)',
      'rgb(189,189,189)',
      'rgb(150,150,150)',
      'rgb(99,99,99)',
      'rgb(37,37,37)',
    ],
    '7': [
      'rgb(247,247,247)',
      'rgb(217,217,217)',
      'rgb(189,189,189)',
      'rgb(150,150,150)',
      'rgb(115,115,115)',
      'rgb(82,82,82)',
      'rgb(37,37,37)',
    ],
    '8': [
      'rgb(255,255,255)',
      'rgb(240,240,240)',
      'rgb(217,217,217)',
      'rgb(189,189,189)',
      'rgb(150,150,150)',
      'rgb(115,115,115)',
      'rgb(82,82,82)',
      'rgb(37,37,37)',
    ],
    '9': [
      'rgb(255,255,255)',
      'rgb(240,240,240)',
      'rgb(217,217,217)',
      'rgb(189,189,189)',
      'rgb(150,150,150)',
      'rgb(115,115,115)',
      'rgb(82,82,82)',
      'rgb(37,37,37)',
      'rgb(0,0,0)',
    ],
    type: 'seq',
  },
  YlOrRd: {
    '3': ['rgb(255,237,160)', 'rgb(254,178,76)', 'rgb(240,59,32)'],
    '4': [
      'rgb(255,255,178)',
      'rgb(254,204,92)',
      'rgb(253,141,60)',
      'rgb(227,26,28)',
    ],
    '5': [
      'rgb(255,255,178)',
      'rgb(254,204,92)',
      'rgb(253,141,60)',
      'rgb(240,59,32)',
      'rgb(189,0,38)',
    ],
    '6': [
      'rgb(255,255,178)',
      'rgb(254,217,118)',
      'rgb(254,178,76)',
      'rgb(253,141,60)',
      'rgb(240,59,32)',
      'rgb(189,0,38)',
    ],
    '7': [
      'rgb(255,255,178)',
      'rgb(254,217,118)',
      'rgb(254,178,76)',
      'rgb(253,141,60)',
      'rgb(252,78,42)',
      'rgb(227,26,28)',
      'rgb(177,0,38)',
    ],
    '8': [
      'rgb(255,255,204)',
      'rgb(255,237,160)',
      'rgb(254,217,118)',
      'rgb(254,178,76)',
      'rgb(253,141,60)',
      'rgb(252,78,42)',
      'rgb(227,26,28)',
      'rgb(177,0,38)',
    ],
    type: 'seq',
  },
  PuRd: {
    '3': ['rgb(231,225,239)', 'rgb(201,148,199)', 'rgb(221,28,119)'],
    '4': [
      'rgb(241,238,246)',
      'rgb(215,181,216)',
      'rgb(223,101,176)',
      'rgb(206,18,86)',
    ],
    '5': [
      'rgb(241,238,246)',
      'rgb(215,181,216)',
      'rgb(223,101,176)',
      'rgb(221,28,119)',
      'rgb(152,0,67)',
    ],
    '6': [
      'rgb(241,238,246)',
      'rgb(212,185,218)',
      'rgb(201,148,199)',
      'rgb(223,101,176)',
      'rgb(221,28,119)',
      'rgb(152,0,67)',
    ],
    '7': [
      'rgb(241,238,246)',
      'rgb(212,185,218)',
      'rgb(201,148,199)',
      'rgb(223,101,176)',
      'rgb(231,41,138)',
      'rgb(206,18,86)',
      'rgb(145,0,63)',
    ],
    '8': [
      'rgb(247,244,249)',
      'rgb(231,225,239)',
      'rgb(212,185,218)',
      'rgb(201,148,199)',
      'rgb(223,101,176)',
      'rgb(231,41,138)',
      'rgb(206,18,86)',
      'rgb(145,0,63)',
    ],
    '9': [
      'rgb(247,244,249)',
      'rgb(231,225,239)',
      'rgb(212,185,218)',
      'rgb(201,148,199)',
      'rgb(223,101,176)',
      'rgb(231,41,138)',
      'rgb(206,18,86)',
      'rgb(152,0,67)',
      'rgb(103,0,31)',
    ],
    type: 'seq',
  },
  Blues: {
    '3': ['rgb(222,235,247)', 'rgb(158,202,225)', 'rgb(49,130,189)'],
    '4': [
      'rgb(239,243,255)',
      'rgb(189,215,231)',
      'rgb(107,174,214)',
      'rgb(33,113,181)',
    ],
    '5': [
      'rgb(239,243,255)',
      'rgb(189,215,231)',
      'rgb(107,174,214)',
      'rgb(49,130,189)',
      'rgb(8,81,156)',
    ],
    '6': [
      'rgb(239,243,255)',
      'rgb(198,219,239)',
      'rgb(158,202,225)',
      'rgb(107,174,214)',
      'rgb(49,130,189)',
      'rgb(8,81,156)',
    ],
    '7': [
      'rgb(239,243,255)',
      'rgb(198,219,239)',
      'rgb(158,202,225)',
      'rgb(107,174,214)',
      'rgb(66,146,198)',
      'rgb(33,113,181)',
      'rgb(8,69,148)',
    ],
    '8': [
      'rgb(247,251,255)',
      'rgb(222,235,247)',
      'rgb(198,219,239)',
      'rgb(158,202,225)',
      'rgb(107,174,214)',
      'rgb(66,146,198)',
      'rgb(33,113,181)',
      'rgb(8,69,148)',
    ],
    '9': [
      'rgb(247,251,255)',
      'rgb(222,235,247)',
      'rgb(198,219,239)',
      'rgb(158,202,225)',
      'rgb(107,174,214)',
      'rgb(66,146,198)',
      'rgb(33,113,181)',
      'rgb(8,81,156)',
      'rgb(8,48,107)',
    ],
    type: 'seq',
  },
  PuBuGn: {
    '3': ['rgb(236,226,240)', 'rgb(166,189,219)', 'rgb(28,144,153)'],
    '4': [
      'rgb(246,239,247)',
      'rgb(189,201,225)',
      'rgb(103,169,207)',
      'rgb(2,129,138)',
    ],
    '5': [
      'rgb(246,239,247)',
      'rgb(189,201,225)',
      'rgb(103,169,207)',
      'rgb(28,144,153)',
      'rgb(1,108,89)',
    ],
    '6': [
      'rgb(246,239,247)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(103,169,207)',
      'rgb(28,144,153)',
      'rgb(1,108,89)',
    ],
    '7': [
      'rgb(246,239,247)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(103,169,207)',
      'rgb(54,144,192)',
      'rgb(2,129,138)',
      'rgb(1,100,80)',
    ],
    '8': [
      'rgb(255,247,251)',
      'rgb(236,226,240)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(103,169,207)',
      'rgb(54,144,192)',
      'rgb(2,129,138)',
      'rgb(1,100,80)',
    ],
    '9': [
      'rgb(255,247,251)',
      'rgb(236,226,240)',
      'rgb(208,209,230)',
      'rgb(166,189,219)',
      'rgb(103,169,207)',
      'rgb(54,144,192)',
      'rgb(2,129,138)',
      'rgb(1,108,89)',
      'rgb(1,70,54)',
    ],
    type: 'seq',
  },

  viridis: {
    '256': [
      '#440154',
      '#440256',
      '#450457',
      '#450559',
      '#46075a',
      '#46085c',
      '#460a5d',
      '#460b5e',
      '#470d60',
      '#470e61',
      '#471063',
      '#471164',
      '#471365',
      '#481467',
      '#481668',
      '#481769',
      '#48186a',
      '#481a6c',
      '#481b6d',
      '#481c6e',
      '#481d6f',
      '#481f70',
      '#482071',
      '#482173',
      '#482374',
      '#482475',
      '#482576',
      '#482677',
      '#482878',
      '#482979',
      '#472a7a',
      '#472c7a',
      '#472d7b',
      '#472e7c',
      '#472f7d',
      '#46307e',
      '#46327e',
      '#46337f',
      '#463480',
      '#453581',
      '#453781',
      '#453882',
      '#443983',
      '#443a83',
      '#443b84',
      '#433d84',
      '#433e85',
      '#423f85',
      '#424086',
      '#424186',
      '#414287',
      '#414487',
      '#404588',
      '#404688',
      '#3f4788',
      '#3f4889',
      '#3e4989',
      '#3e4a89',
      '#3e4c8a',
      '#3d4d8a',
      '#3d4e8a',
      '#3c4f8a',
      '#3c508b',
      '#3b518b',
      '#3b528b',
      '#3a538b',
      '#3a548c',
      '#39558c',
      '#39568c',
      '#38588c',
      '#38598c',
      '#375a8c',
      '#375b8d',
      '#365c8d',
      '#365d8d',
      '#355e8d',
      '#355f8d',
      '#34608d',
      '#34618d',
      '#33628d',
      '#33638d',
      '#32648e',
      '#32658e',
      '#31668e',
      '#31678e',
      '#31688e',
      '#30698e',
      '#306a8e',
      '#2f6b8e',
      '#2f6c8e',
      '#2e6d8e',
      '#2e6e8e',
      '#2e6f8e',
      '#2d708e',
      '#2d718e',
      '#2c718e',
      '#2c728e',
      '#2c738e',
      '#2b748e',
      '#2b758e',
      '#2a768e',
      '#2a778e',
      '#2a788e',
      '#29798e',
      '#297a8e',
      '#297b8e',
      '#287c8e',
      '#287d8e',
      '#277e8e',
      '#277f8e',
      '#27808e',
      '#26818e',
      '#26828e',
      '#26828e',
      '#25838e',
      '#25848e',
      '#25858e',
      '#24868e',
      '#24878e',
      '#23888e',
      '#23898e',
      '#238a8d',
      '#228b8d',
      '#228c8d',
      '#228d8d',
      '#218e8d',
      '#218f8d',
      '#21908d',
      '#21918c',
      '#20928c',
      '#20928c',
      '#20938c',
      '#1f948c',
      '#1f958b',
      '#1f968b',
      '#1f978b',
      '#1f988b',
      '#1f998a',
      '#1f9a8a',
      '#1e9b8a',
      '#1e9c89',
      '#1e9d89',
      '#1f9e89',
      '#1f9f88',
      '#1fa088',
      '#1fa188',
      '#1fa187',
      '#1fa287',
      '#20a386',
      '#20a486',
      '#21a585',
      '#21a685',
      '#22a785',
      '#22a884',
      '#23a983',
      '#24aa83',
      '#25ab82',
      '#25ac82',
      '#26ad81',
      '#27ad81',
      '#28ae80',
      '#29af7f',
      '#2ab07f',
      '#2cb17e',
      '#2db27d',
      '#2eb37c',
      '#2fb47c',
      '#31b57b',
      '#32b67a',
      '#34b679',
      '#35b779',
      '#37b878',
      '#38b977',
      '#3aba76',
      '#3bbb75',
      '#3dbc74',
      '#3fbc73',
      '#40bd72',
      '#42be71',
      '#44bf70',
      '#46c06f',
      '#48c16e',
      '#4ac16d',
      '#4cc26c',
      '#4ec36b',
      '#50c46a',
      '#52c569',
      '#54c568',
      '#56c667',
      '#58c765',
      '#5ac864',
      '#5cc863',
      '#5ec962',
      '#60ca60',
      '#63cb5f',
      '#65cb5e',
      '#67cc5c',
      '#69cd5b',
      '#6ccd5a',
      '#6ece58',
      '#70cf57',
      '#73d056',
      '#75d054',
      '#77d153',
      '#7ad151',
      '#7cd250',
      '#7fd34e',
      '#81d34d',
      '#84d44b',
      '#86d549',
      '#89d548',
      '#8bd646',
      '#8ed645',
      '#90d743',
      '#93d741',
      '#95d840',
      '#98d83e',
      '#9bd93c',
      '#9dd93b',
      '#a0da39',
      '#a2da37',
      '#a5db36',
      '#a8db34',
      '#aadc32',
      '#addc30',
      '#b0dd2f',
      '#b2dd2d',
      '#b5de2b',
      '#b8de29',
      '#bade28',
      '#bddf26',
      '#c0df25',
      '#c2df23',
      '#c5e021',
      '#c8e020',
      '#cae11f',
      '#cde11d',
      '#d0e11c',
      '#d2e21b',
      '#d5e21a',
      '#d8e219',
      '#dae319',
      '#dde318',
      '#dfe318',
      '#e2e418',
      '#e5e419',
      '#e7e419',
      '#eae51a',
      '#ece51b',
      '#efe51c',
      '#f1e51d',
      '#f4e61e',
      '#f6e620',
      '#f8e621',
      '#fbe723',
      '#fde725',
    ],
    type: 'seq',
  },
  plasma: {
    '256': [
      '#0d0887',
      '#100788',
      '#130789',
      '#16078a',
      '#19068c',
      '#1b068d',
      '#1d068e',
      '#20068f',
      '#220690',
      '#240691',
      '#260591',
      '#280592',
      '#2a0593',
      '#2c0594',
      '#2e0595',
      '#2f0596',
      '#310597',
      '#330597',
      '#350498',
      '#370499',
      '#38049a',
      '#3a049a',
      '#3c049b',
      '#3e049c',
      '#3f049c',
      '#41049d',
      '#43039e',
      '#44039e',
      '#46039f',
      '#48039f',
      '#4903a0',
      '#4b03a1',
      '#4c02a1',
      '#4e02a2',
      '#5002a2',
      '#5102a3',
      '#5302a3',
      '#5502a4',
      '#5601a4',
      '#5801a4',
      '#5901a5',
      '#5b01a5',
      '#5c01a6',
      '#5e01a6',
      '#6001a6',
      '#6100a7',
      '#6300a7',
      '#6400a7',
      '#6600a7',
      '#6700a8',
      '#6900a8',
      '#6a00a8',
      '#6c00a8',
      '#6e00a8',
      '#6f00a8',
      '#7100a8',
      '#7201a8',
      '#7401a8',
      '#7501a8',
      '#7701a8',
      '#7801a8',
      '#7a02a8',
      '#7b02a8',
      '#7d03a8',
      '#7e03a8',
      '#8004a8',
      '#8104a7',
      '#8305a7',
      '#8405a7',
      '#8606a6',
      '#8707a6',
      '#8808a6',
      '#8a09a5',
      '#8b0aa5',
      '#8d0ba5',
      '#8e0ca4',
      '#8f0da4',
      '#910ea3',
      '#920fa3',
      '#9410a2',
      '#9511a1',
      '#9613a1',
      '#9814a0',
      '#99159f',
      '#9a169f',
      '#9c179e',
      '#9d189d',
      '#9e199d',
      '#a01a9c',
      '#a11b9b',
      '#a21d9a',
      '#a31e9a',
      '#a51f99',
      '#a62098',
      '#a72197',
      '#a82296',
      '#aa2395',
      '#ab2494',
      '#ac2694',
      '#ad2793',
      '#ae2892',
      '#b02991',
      '#b12a90',
      '#b22b8f',
      '#b32c8e',
      '#b42e8d',
      '#b52f8c',
      '#b6308b',
      '#b7318a',
      '#b83289',
      '#ba3388',
      '#bb3488',
      '#bc3587',
      '#bd3786',
      '#be3885',
      '#bf3984',
      '#c03a83',
      '#c13b82',
      '#c23c81',
      '#c33d80',
      '#c43e7f',
      '#c5407e',
      '#c6417d',
      '#c7427c',
      '#c8437b',
      '#c9447a',
      '#ca457a',
      '#cb4679',
      '#cc4778',
      '#cc4977',
      '#cd4a76',
      '#ce4b75',
      '#cf4c74',
      '#d04d73',
      '#d14e72',
      '#d24f71',
      '#d35171',
      '#d45270',
      '#d5536f',
      '#d5546e',
      '#d6556d',
      '#d7566c',
      '#d8576b',
      '#d9586a',
      '#da5a6a',
      '#da5b69',
      '#db5c68',
      '#dc5d67',
      '#dd5e66',
      '#de5f65',
      '#de6164',
      '#df6263',
      '#e06363',
      '#e16462',
      '#e26561',
      '#e26660',
      '#e3685f',
      '#e4695e',
      '#e56a5d',
      '#e56b5d',
      '#e66c5c',
      '#e76e5b',
      '#e76f5a',
      '#e87059',
      '#e97158',
      '#e97257',
      '#ea7457',
      '#eb7556',
      '#eb7655',
      '#ec7754',
      '#ed7953',
      '#ed7a52',
      '#ee7b51',
      '#ef7c51',
      '#ef7e50',
      '#f07f4f',
      '#f0804e',
      '#f1814d',
      '#f1834c',
      '#f2844b',
      '#f3854b',
      '#f3874a',
      '#f48849',
      '#f48948',
      '#f58b47',
      '#f58c46',
      '#f68d45',
      '#f68f44',
      '#f79044',
      '#f79143',
      '#f79342',
      '#f89441',
      '#f89540',
      '#f9973f',
      '#f9983e',
      '#f99a3e',
      '#fa9b3d',
      '#fa9c3c',
      '#fa9e3b',
      '#fb9f3a',
      '#fba139',
      '#fba238',
      '#fca338',
      '#fca537',
      '#fca636',
      '#fca835',
      '#fca934',
      '#fdab33',
      '#fdac33',
      '#fdae32',
      '#fdaf31',
      '#fdb130',
      '#fdb22f',
      '#fdb42f',
      '#fdb52e',
      '#feb72d',
      '#feb82c',
      '#feba2c',
      '#febb2b',
      '#febd2a',
      '#febe2a',
      '#fec029',
      '#fdc229',
      '#fdc328',
      '#fdc527',
      '#fdc627',
      '#fdc827',
      '#fdca26',
      '#fdcb26',
      '#fccd25',
      '#fcce25',
      '#fcd025',
      '#fcd225',
      '#fbd324',
      '#fbd524',
      '#fbd724',
      '#fad824',
      '#fada24',
      '#f9dc24',
      '#f9dd25',
      '#f8df25',
      '#f8e125',
      '#f7e225',
      '#f7e425',
      '#f6e626',
      '#f6e826',
      '#f5e926',
      '#f5eb27',
      '#f4ed27',
      '#f3ee27',
      '#f3f027',
      '#f2f227',
      '#f1f426',
      '#f1f525',
      '#f0f724',
      '#f0f921',
    ],
    type: 'seq',
  },
  inferno: {
    '256': [
      '#000004',
      '#010005',
      '#010106',
      '#010108',
      '#02010a',
      '#02020c',
      '#02020e',
      '#030210',
      '#040312',
      '#040314',
      '#050417',
      '#060419',
      '#07051b',
      '#08051d',
      '#09061f',
      '#0a0722',
      '#0b0724',
      '#0c0826',
      '#0d0829',
      '#0e092b',
      '#10092d',
      '#110a30',
      '#120a32',
      '#140b34',
      '#150b37',
      '#160b39',
      '#180c3c',
      '#190c3e',
      '#1b0c41',
      '#1c0c43',
      '#1e0c45',
      '#1f0c48',
      '#210c4a',
      '#230c4c',
      '#240c4f',
      '#260c51',
      '#280b53',
      '#290b55',
      '#2b0b57',
      '#2d0b59',
      '#2f0a5b',
      '#310a5c',
      '#320a5e',
      '#340a5f',
      '#360961',
      '#380962',
      '#390963',
      '#3b0964',
      '#3d0965',
      '#3e0966',
      '#400a67',
      '#420a68',
      '#440a68',
      '#450a69',
      '#470b6a',
      '#490b6a',
      '#4a0c6b',
      '#4c0c6b',
      '#4d0d6c',
      '#4f0d6c',
      '#510e6c',
      '#520e6d',
      '#540f6d',
      '#550f6d',
      '#57106e',
      '#59106e',
      '#5a116e',
      '#5c126e',
      '#5d126e',
      '#5f136e',
      '#61136e',
      '#62146e',
      '#64156e',
      '#65156e',
      '#67166e',
      '#69166e',
      '#6a176e',
      '#6c186e',
      '#6d186e',
      '#6f196e',
      '#71196e',
      '#721a6e',
      '#741a6e',
      '#751b6e',
      '#771c6d',
      '#781c6d',
      '#7a1d6d',
      '#7c1d6d',
      '#7d1e6d',
      '#7f1e6c',
      '#801f6c',
      '#82206c',
      '#84206b',
      '#85216b',
      '#87216b',
      '#88226a',
      '#8a226a',
      '#8c2369',
      '#8d2369',
      '#8f2469',
      '#902568',
      '#922568',
      '#932667',
      '#952667',
      '#972766',
      '#982766',
      '#9a2865',
      '#9b2964',
      '#9d2964',
      '#9f2a63',
      '#a02a63',
      '#a22b62',
      '#a32c61',
      '#a52c60',
      '#a62d60',
      '#a82e5f',
      '#a92e5e',
      '#ab2f5e',
      '#ad305d',
      '#ae305c',
      '#b0315b',
      '#b1325a',
      '#b3325a',
      '#b43359',
      '#b63458',
      '#b73557',
      '#b93556',
      '#ba3655',
      '#bc3754',
      '#bd3853',
      '#bf3952',
      '#c03a51',
      '#c13a50',
      '#c33b4f',
      '#c43c4e',
      '#c63d4d',
      '#c73e4c',
      '#c83f4b',
      '#ca404a',
      '#cb4149',
      '#cc4248',
      '#ce4347',
      '#cf4446',
      '#d04545',
      '#d24644',
      '#d34743',
      '#d44842',
      '#d54a41',
      '#d74b3f',
      '#d84c3e',
      '#d94d3d',
      '#da4e3c',
      '#db503b',
      '#dd513a',
      '#de5238',
      '#df5337',
      '#e05536',
      '#e15635',
      '#e25734',
      '#e35933',
      '#e45a31',
      '#e55c30',
      '#e65d2f',
      '#e75e2e',
      '#e8602d',
      '#e9612b',
      '#ea632a',
      '#eb6429',
      '#eb6628',
      '#ec6726',
      '#ed6925',
      '#ee6a24',
      '#ef6c23',
      '#ef6e21',
      '#f06f20',
      '#f1711f',
      '#f1731d',
      '#f2741c',
      '#f3761b',
      '#f37819',
      '#f47918',
      '#f57b17',
      '#f57d15',
      '#f67e14',
      '#f68013',
      '#f78212',
      '#f78410',
      '#f8850f',
      '#f8870e',
      '#f8890c',
      '#f98b0b',
      '#f98c0a',
      '#f98e09',
      '#fa9008',
      '#fa9207',
      '#fa9407',
      '#fb9606',
      '#fb9706',
      '#fb9906',
      '#fb9b06',
      '#fb9d07',
      '#fc9f07',
      '#fca108',
      '#fca309',
      '#fca50a',
      '#fca60c',
      '#fca80d',
      '#fcaa0f',
      '#fcac11',
      '#fcae12',
      '#fcb014',
      '#fcb216',
      '#fcb418',
      '#fbb61a',
      '#fbb81d',
      '#fbba1f',
      '#fbbc21',
      '#fbbe23',
      '#fac026',
      '#fac228',
      '#fac42a',
      '#fac62d',
      '#f9c72f',
      '#f9c932',
      '#f9cb35',
      '#f8cd37',
      '#f8cf3a',
      '#f7d13d',
      '#f7d340',
      '#f6d543',
      '#f6d746',
      '#f5d949',
      '#f5db4c',
      '#f4dd4f',
      '#f4df53',
      '#f4e156',
      '#f3e35a',
      '#f3e55d',
      '#f2e661',
      '#f2e865',
      '#f2ea69',
      '#f1ec6d',
      '#f1ed71',
      '#f1ef75',
      '#f1f179',
      '#f2f27d',
      '#f2f482',
      '#f3f586',
      '#f3f68a',
      '#f4f88e',
      '#f5f992',
      '#f6fa96',
      '#f8fb9a',
      '#f9fc9d',
      '#fafda1',
      '#fcffa4',
    ],
    type: 'seq',
  },
  magma: {
    '256': [
      '#000004',
      '#010005',
      '#010106',
      '#010108',
      '#020109',
      '#02020b',
      '#02020d',
      '#03030f',
      '#030312',
      '#040414',
      '#050416',
      '#060518',
      '#06051a',
      '#07061c',
      '#08071e',
      '#090720',
      '#0a0822',
      '#0b0924',
      '#0c0926',
      '#0d0a29',
      '#0e0b2b',
      '#100b2d',
      '#110c2f',
      '#120d31',
      '#130d34',
      '#140e36',
      '#150e38',
      '#160f3b',
      '#180f3d',
      '#19103f',
      '#1a1042',
      '#1c1044',
      '#1d1147',
      '#1e1149',
      '#20114b',
      '#21114e',
      '#221150',
      '#241253',
      '#251255',
      '#271258',
      '#29115a',
      '#2a115c',
      '#2c115f',
      '#2d1161',
      '#2f1163',
      '#311165',
      '#331067',
      '#341069',
      '#36106b',
      '#38106c',
      '#390f6e',
      '#3b0f70',
      '#3d0f71',
      '#3f0f72',
      '#400f74',
      '#420f75',
      '#440f76',
      '#451077',
      '#471078',
      '#491078',
      '#4a1079',
      '#4c117a',
      '#4e117b',
      '#4f127b',
      '#51127c',
      '#52137c',
      '#54137d',
      '#56147d',
      '#57157e',
      '#59157e',
      '#5a167e',
      '#5c167f',
      '#5d177f',
      '#5f187f',
      '#601880',
      '#621980',
      '#641a80',
      '#651a80',
      '#671b80',
      '#681c81',
      '#6a1c81',
      '#6b1d81',
      '#6d1d81',
      '#6e1e81',
      '#701f81',
      '#721f81',
      '#732081',
      '#752181',
      '#762181',
      '#782281',
      '#792282',
      '#7b2382',
      '#7c2382',
      '#7e2482',
      '#802582',
      '#812581',
      '#832681',
      '#842681',
      '#862781',
      '#882781',
      '#892881',
      '#8b2981',
      '#8c2981',
      '#8e2a81',
      '#902a81',
      '#912b81',
      '#932b80',
      '#942c80',
      '#962c80',
      '#982d80',
      '#992d80',
      '#9b2e7f',
      '#9c2e7f',
      '#9e2f7f',
      '#a02f7f',
      '#a1307e',
      '#a3307e',
      '#a5317e',
      '#a6317d',
      '#a8327d',
      '#aa337d',
      '#ab337c',
      '#ad347c',
      '#ae347b',
      '#b0357b',
      '#b2357b',
      '#b3367a',
      '#b5367a',
      '#b73779',
      '#b83779',
      '#ba3878',
      '#bc3978',
      '#bd3977',
      '#bf3a77',
      '#c03a76',
      '#c23b75',
      '#c43c75',
      '#c53c74',
      '#c73d73',
      '#c83e73',
      '#ca3e72',
      '#cc3f71',
      '#cd4071',
      '#cf4070',
      '#d0416f',
      '#d2426f',
      '#d3436e',
      '#d5446d',
      '#d6456c',
      '#d8456c',
      '#d9466b',
      '#db476a',
      '#dc4869',
      '#de4968',
      '#df4a68',
      '#e04c67',
      '#e24d66',
      '#e34e65',
      '#e44f64',
      '#e55064',
      '#e75263',
      '#e85362',
      '#e95462',
      '#ea5661',
      '#eb5760',
      '#ec5860',
      '#ed5a5f',
      '#ee5b5e',
      '#ef5d5e',
      '#f05f5e',
      '#f1605d',
      '#f2625d',
      '#f2645c',
      '#f3655c',
      '#f4675c',
      '#f4695c',
      '#f56b5c',
      '#f66c5c',
      '#f66e5c',
      '#f7705c',
      '#f7725c',
      '#f8745c',
      '#f8765c',
      '#f9785d',
      '#f9795d',
      '#f97b5d',
      '#fa7d5e',
      '#fa7f5e',
      '#fa815f',
      '#fb835f',
      '#fb8560',
      '#fb8761',
      '#fc8961',
      '#fc8a62',
      '#fc8c63',
      '#fc8e64',
      '#fc9065',
      '#fd9266',
      '#fd9467',
      '#fd9668',
      '#fd9869',
      '#fd9a6a',
      '#fd9b6b',
      '#fe9d6c',
      '#fe9f6d',
      '#fea16e',
      '#fea36f',
      '#fea571',
      '#fea772',
      '#fea973',
      '#feaa74',
      '#feac76',
      '#feae77',
      '#feb078',
      '#feb27a',
      '#feb47b',
      '#feb67c',
      '#feb77e',
      '#feb97f',
      '#febb81',
      '#febd82',
      '#febf84',
      '#fec185',
      '#fec287',
      '#fec488',
      '#fec68a',
      '#fec88c',
      '#feca8d',
      '#fecc8f',
      '#fecd90',
      '#fecf92',
      '#fed194',
      '#fed395',
      '#fed597',
      '#fed799',
      '#fed89a',
      '#fdda9c',
      '#fddc9e',
      '#fddea0',
      '#fde0a1',
      '#fde2a3',
      '#fde3a5',
      '#fde5a7',
      '#fde7a9',
      '#fde9aa',
      '#fdebac',
      '#fcecae',
      '#fceeb0',
      '#fcf0b2',
      '#fcf2b4',
      '#fcf4b6',
      '#fcf6b8',
      '#fcf7b9',
      '#fcf9bb',
      '#fcfbbd',
      '#fcfdbf',
    ],
    type: 'seq',
  },
};

export const matplotlib = {
  viridis: {
    '256': [
      '#440154',
      '#440256',
      '#450457',
      '#450559',
      '#46075a',
      '#46085c',
      '#460a5d',
      '#460b5e',
      '#470d60',
      '#470e61',
      '#471063',
      '#471164',
      '#471365',
      '#481467',
      '#481668',
      '#481769',
      '#48186a',
      '#481a6c',
      '#481b6d',
      '#481c6e',
      '#481d6f',
      '#481f70',
      '#482071',
      '#482173',
      '#482374',
      '#482475',
      '#482576',
      '#482677',
      '#482878',
      '#482979',
      '#472a7a',
      '#472c7a',
      '#472d7b',
      '#472e7c',
      '#472f7d',
      '#46307e',
      '#46327e',
      '#46337f',
      '#463480',
      '#453581',
      '#453781',
      '#453882',
      '#443983',
      '#443a83',
      '#443b84',
      '#433d84',
      '#433e85',
      '#423f85',
      '#424086',
      '#424186',
      '#414287',
      '#414487',
      '#404588',
      '#404688',
      '#3f4788',
      '#3f4889',
      '#3e4989',
      '#3e4a89',
      '#3e4c8a',
      '#3d4d8a',
      '#3d4e8a',
      '#3c4f8a',
      '#3c508b',
      '#3b518b',
      '#3b528b',
      '#3a538b',
      '#3a548c',
      '#39558c',
      '#39568c',
      '#38588c',
      '#38598c',
      '#375a8c',
      '#375b8d',
      '#365c8d',
      '#365d8d',
      '#355e8d',
      '#355f8d',
      '#34608d',
      '#34618d',
      '#33628d',
      '#33638d',
      '#32648e',
      '#32658e',
      '#31668e',
      '#31678e',
      '#31688e',
      '#30698e',
      '#306a8e',
      '#2f6b8e',
      '#2f6c8e',
      '#2e6d8e',
      '#2e6e8e',
      '#2e6f8e',
      '#2d708e',
      '#2d718e',
      '#2c718e',
      '#2c728e',
      '#2c738e',
      '#2b748e',
      '#2b758e',
      '#2a768e',
      '#2a778e',
      '#2a788e',
      '#29798e',
      '#297a8e',
      '#297b8e',
      '#287c8e',
      '#287d8e',
      '#277e8e',
      '#277f8e',
      '#27808e',
      '#26818e',
      '#26828e',
      '#26828e',
      '#25838e',
      '#25848e',
      '#25858e',
      '#24868e',
      '#24878e',
      '#23888e',
      '#23898e',
      '#238a8d',
      '#228b8d',
      '#228c8d',
      '#228d8d',
      '#218e8d',
      '#218f8d',
      '#21908d',
      '#21918c',
      '#20928c',
      '#20928c',
      '#20938c',
      '#1f948c',
      '#1f958b',
      '#1f968b',
      '#1f978b',
      '#1f988b',
      '#1f998a',
      '#1f9a8a',
      '#1e9b8a',
      '#1e9c89',
      '#1e9d89',
      '#1f9e89',
      '#1f9f88',
      '#1fa088',
      '#1fa188',
      '#1fa187',
      '#1fa287',
      '#20a386',
      '#20a486',
      '#21a585',
      '#21a685',
      '#22a785',
      '#22a884',
      '#23a983',
      '#24aa83',
      '#25ab82',
      '#25ac82',
      '#26ad81',
      '#27ad81',
      '#28ae80',
      '#29af7f',
      '#2ab07f',
      '#2cb17e',
      '#2db27d',
      '#2eb37c',
      '#2fb47c',
      '#31b57b',
      '#32b67a',
      '#34b679',
      '#35b779',
      '#37b878',
      '#38b977',
      '#3aba76',
      '#3bbb75',
      '#3dbc74',
      '#3fbc73',
      '#40bd72',
      '#42be71',
      '#44bf70',
      '#46c06f',
      '#48c16e',
      '#4ac16d',
      '#4cc26c',
      '#4ec36b',
      '#50c46a',
      '#52c569',
      '#54c568',
      '#56c667',
      '#58c765',
      '#5ac864',
      '#5cc863',
      '#5ec962',
      '#60ca60',
      '#63cb5f',
      '#65cb5e',
      '#67cc5c',
      '#69cd5b',
      '#6ccd5a',
      '#6ece58',
      '#70cf57',
      '#73d056',
      '#75d054',
      '#77d153',
      '#7ad151',
      '#7cd250',
      '#7fd34e',
      '#81d34d',
      '#84d44b',
      '#86d549',
      '#89d548',
      '#8bd646',
      '#8ed645',
      '#90d743',
      '#93d741',
      '#95d840',
      '#98d83e',
      '#9bd93c',
      '#9dd93b',
      '#a0da39',
      '#a2da37',
      '#a5db36',
      '#a8db34',
      '#aadc32',
      '#addc30',
      '#b0dd2f',
      '#b2dd2d',
      '#b5de2b',
      '#b8de29',
      '#bade28',
      '#bddf26',
      '#c0df25',
      '#c2df23',
      '#c5e021',
      '#c8e020',
      '#cae11f',
      '#cde11d',
      '#d0e11c',
      '#d2e21b',
      '#d5e21a',
      '#d8e219',
      '#dae319',
      '#dde318',
      '#dfe318',
      '#e2e418',
      '#e5e419',
      '#e7e419',
      '#eae51a',
      '#ece51b',
      '#efe51c',
      '#f1e51d',
      '#f4e61e',
      '#f6e620',
      '#f8e621',
      '#fbe723',
      '#fde725',
    ],
    type: 'seq',
  },
};

export default colorbrewer;
