/*
 * @(#)Bevel3dP.h
 *
 * Copyright 2023  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Bevel3d */

#ifndef _Bevel3dP_h
#define _Bevel3dP_h

#include "Bevel3d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Bevel3DClassPart {
	int ignore;
} Bevel3DClassPart;

typedef struct _Bevel3DClassRec {
	CoreClassPart coreClass;
	BevelClassPart bevelClass;
	Bevel3DClassPart bevel3dClass;
} Bevel3DClassRec;

extern Bevel3DClassRec bevel3dClassRec;
#endif

#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define COORD3D 12

#define SQRT_3 1.732050808
#define MULTIPLY(a) ((int)(a*SQRT_3/2.0))
#define DIVIDE(a) ((int)(a*2.0/SQRT_3))

typedef struct _Bevel3DPart {
	Position    cubeDiagonal, cubeDiag, diamondDiagonal, faceDiagonal;
	Point       cubeSize, diamondSize, faceSize, viewSize;
	Point       viewMiddle;
} Bevel3DPart;

typedef struct _Bevel3DRec {
	CorePart    core;
	BevelPart   bevel;
	Bevel3DPart bevel3d;
} Bevel3DRec;

extern Boolean selectPieces3D(Bevel3DWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelection3D(Bevel3DWidget w,
	int *face, int *direction);
extern void drawFrame3D(Bevel3DWidget w, Boolean focus);
extern void drawInnerTriangle3D(Bevel3DWidget w, int face, int position,
	int offset);
extern void drawOuterTriangle3D(Bevel3DWidget w, int face, int position,
	int offset);
#ifdef WINVER
extern void initializePuzzle3D(Bevel3DWidget w);
extern void resizePuzzle3D(Bevel3DWidget w);
extern void exposePuzzle3D(Bevel3DWidget w);
#endif

#endif /* _Bevel3dP_h */
