/*
 * Decompiled with CFR 0.152.
 */
package rene.util.sort;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import rene.util.sort.SortObject;
import rene.util.sort.SortString;

public class Sorter {
    public static void sort(SortObject[] sortObjectArray) {
        Sorter.QuickSort(sortObjectArray, 0, sortObjectArray.length - 1);
    }

    public static void sort(SortObject[] sortObjectArray, int n) {
        Sorter.QuickSort(sortObjectArray, 0, n - 1);
    }

    public static void sort(Vector vector) {
        Object[] objectArray = new SortObject[vector.size()];
        vector.copyInto(objectArray);
        Sorter.sort((SortObject[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.setElementAt(objectArray[i], i);
        }
    }

    public static void QuickSort(SortObject[] sortObjectArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            SortObject sortObject = sortObjectArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && sortObjectArray[n3].compare(sortObject) < 0) {
                    ++n3;
                }
                while (n4 > n && sortObjectArray[n4].compare(sortObject) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                Sorter.swap(sortObjectArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                Sorter.QuickSort(sortObjectArray, n, n4);
            }
            if (n3 < n2) {
                Sorter.QuickSort(sortObjectArray, n3, n2);
            }
        }
    }

    private static void swap(SortObject[] sortObjectArray, int n, int n2) {
        SortObject sortObject = sortObjectArray[n];
        sortObjectArray[n] = sortObjectArray[n2];
        sortObjectArray[n2] = sortObject;
    }

    public static void QuickSort(Object[] objectArray, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            SortObject sortObject = (SortObject)objectArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && ((SortObject)objectArray[n3]).compare(sortObject) < 0) {
                    ++n3;
                }
                while (n4 > n && ((SortObject)objectArray[n4]).compare(sortObject) > 0) {
                    --n4;
                }
                if (n3 > n4) continue;
                Sorter.swap(objectArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                Sorter.QuickSort(objectArray, n, n4);
            }
            if (n3 < n2) {
                Sorter.QuickSort(objectArray, n3, n2);
            }
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        Vector<SortString> vector = new Vector<SortString>();
        while ((object = bufferedReader.readLine()) != null) {
            vector.addElement(new SortString((String)object));
        }
        bufferedReader.close();
        Sorter.sort(vector);
        object = vector.elements();
        String string = null;
        while (object.hasMoreElements()) {
            String string2 = ((SortString)object.nextElement()).toString();
            if (string != null && string2.equals(string)) continue;
            System.out.println(string2);
            string = string2;
        }
    }
}

