---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, renvois, hyperliens, hyperref
---

# Comment obtenir des hyperliens ?

## Avec l'extension <ctanpkg:hyperref>

Sur ce sujet, l'extension <ctanpkg:hyperref> se pose en référence. 
Elle redéfinit les commandes permettant de faire des références croisées, 
afin que ces références créent des liens hypertextes dans la version PDF du document.

L'exemple ci-dessous illustre deux types de liens :
- les liens hypertextes renvoyant à des sites web, introduits par la commande 
  `\href{⟨adresse⟩}{⟨texte⟩}` affichant le `⟨texte⟩` en l'associant à l'`⟨adresse⟩` web ;
- les liens internes (ici mis en bleu), activés pour les comamndes `\ref` mais aussi, 
  par exemple, pour la table des matières.

La commande `\hypersetup{⟨options⟩}` permet de passer des `⟨options⟩` de présentation des liens
ou de réglage du PDF à l'extension. Dans le cas présent, 
les options affichent les liens internes au document en bleu et colorent le texte des liens 
(par défaut, les liens sont encadrés en couleur).


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{hyperref} 

  \hypersetup{linkcolor=blue,colorlinks}

\begin{document}
\section{Première recommandation}

En cas de problème avec \LaTeX, ne paniquez pas. 
Et lisez la section \ref{deux}.

\section{Deuxième recommandation} \label{deux}

Dès que vous rencontrez des difficultés, consultez le 
\href{https://faq.gutenberg-asso.fr}{site de la FAQ}. Si le problème
n'est pas résolu, posez votre question en ligne, par exemple sur 
le site \href{https://texnique.fr/}{TeXnique.fr}.

\newpage
\tableofcontents
\end{document}
```


## Avec l'extension <ctanpkg:hyperlatex>

L'extension <ctanpkg:hyperlatex>, datant de 2005, permet de faire des liens hypertextes. 
Cette extension propose également d'obtenir soit un document DVI, soit un document HTML.