---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, cellules, table, couleur
---

# Comment griser des cellules d'un tableau ?

## Avec l'extension <ctanpkg:colortbl>

L'extension <ctanpkg:colortbl> fournit la commande `\columncolor` 
qui définit la couleur d'une colonne. En la combinant avec la commande 
`\multicolumn`, il est possible de ne colorer qu'une cellule. 
Voici un exemple de cette méthode :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{eurosym}        % Symbole euro avec \euro
  \usepackage{xcolor}
  \usepackage{colortbl}

\begin{document}
\renewcommand\arraystretch{1.2}
\begin{center}
  \begin{tabular}{|>{\columncolor[gray]{.9}}l|
    *{3}{>{\columncolor[gray]{.9}}c|}}
    \hline
    \multicolumn{1}{|>{\columncolor[gray]{1}}l|}{Tarifs} &
    0 -  8h &  8 - 19h & 19 - 24h \\
    \hline
    lundi-vendredi &
    \multicolumn{1}{>{\color{white}\columncolor{blue}}c|}{$0,018$~\euro} &
    \multicolumn{1}{>{\color{white}\columncolor{red}}c|}{$0,033$~\euro}  &
    \multicolumn{1}{>{\color{white}\columncolor{blue}}c|}{$0,018$~\euro}  \\
    \hline
    week-end \& fêtes &
    \multicolumn{3}{>{\color{white}\columncolor{blue}}c|}{$0,018$~\euro}  \\
    \hline
  \end{tabular}
\end{center}
\end{document}
```

Notez que vous pouvez appeler l'extension <ctanpkg:colortbl> avec une option
de <ctanpkg:xcolor> :

```{noedit}
\usepackage[table]{xcolor}
```

Cela va remplacer les deux commandes : 

```{noedit}
\usepackage{xcolor}
\usepackage{colortbl}
```


## Avec l'extension <ctanpkg:tabularray>

:::{todo} Ajouter un exemple.
:::


## Avec l'extension <ctanpkg:colortab>

:::{warning}
L’extension <ctanpkg:colortab> n'est plus recommandée car ancienne (1993). 
Ce qui suit est informatif.
:::

L'extension <ctanpkg:colortab> permet de mettre de la couleur 
dans certaines parties d'un tableau. Elle n'est cependant plus maintenue 
et n'est pas compatible avec l'extension <ctanpkg:longtable> par exemple.