---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, bibliographie,
              style des entrées bibliographiques, unsrt,
              titre de sectionnement
---

# Comment gérer le style bibliographique `unsrt` avec des tables des matières ?

En utilisant le style bibliographique [unsrt](ctanpkg:bibtex), vous vous
attendez à ce que votre bibliographie ne soit *pas* triée : les entrées de la
bibliographie apparaissent alors dans l'ordre dans lequel elles sont apparues
pour la première fois dans votre document.

Cependant, si vous avez la malchance d'avoir besoin d'une citation
bibliographique dans un
[titre de sectionnement](/3_composition/texte/titres/start) et que vous avez
également une table des matières, les citations qui apparaissent alors
dans la table des matières perturberont l'ordre "naturel" produit par le style
[unsrt](ctanpkg:bibtex). La situation sera similaire avec des citations dans
des légendes de figure (ou de table) et que vous avez une liste de figures (ou
de tables).


## Avec des suppressions de fichier

Il existe une méthode manuelle assez simple pour résoudre le problème,
dès lors que le document est stable :

1. supprimez le fichier auxiliaire (fichier AUX) et tous les fichiers
  TOC, LOF ou LOT ;
2. exécutez LaTeX ;
3. exécutez BibTeX ;
4. exécutez LaTeX aussi souvent que nécessaire pour que le document reste
  stable.


## Avec l'extension <ctanpkg:notoccite>

La méthode manuelle peut rapidement devenir fastidieuse.

L'extension <ctanpkg:notoccite> empêche les citations présentes dans les
entrées de la table des matières, de la liste des figures, ou de celle des
tableaux, d'intervenir dans l'ordre de numérotation.

```
% Un fichier BIB créé par le document avec l'environnement filecontents
\begin{filecontents}[overwrite,noheader]{mabiblio.bib}
  @Misc{doc1,
    author = {Cicéron},
    title = {De Finibus Bonorum et Malorum}
  }
  @Misc{doc2,
    author = {MacClintock, Richard},
    title = {Lorem Ipsum},
  }
\end{filecontents}

% Le document LaTeX
\documentclass[french]{article}
  \usepackage[T1]{fontenc}       % Encodage T1 (adapté au français)
  \usepackage{lmodern}           % Caractères plus lisibles
  \usepackage{babel}             % Réglages linguistiques (avec french)
  \usepackage{lipsum}            % Du faux texte
  \usepackage{notoccite}
  \pagestyle{headings}
  \bibliographystyle{unsrt-fr}

\begin{document}
\section{Le Lorem Ipsum persiste et signe \cite{doc1}}

Cf.~\cite{doc1}. \lipsum[1][1-4]

\begin{table}[htbp]
  \centering
  \begin{tabular}{|l|l|}
    \hline
    Lorem & Ipsum      \\
    \hline
    55 & 1,4           \\
    \hline
    85 & 3,7           \\
    \hline
  \end{tabular}
  \caption{Curabitur dictum \cite{doc2}}
\end{table}

\bibliography{mabiblio.bib}
\listoftables
\tableofcontents
\end{document}
```

Dans le passé, il fallait que les clés de citation apparaissant dans des
titres susceptibles de se retrouver dans des en-têtes de pages soient en
haut-de-casse, car elles le devenaient dans l'en-tête à cause d'un
`\MakeUppercase`.  Vous pouviez utiliser l'extension <ctanpkg:textcase>
pour cela. Ce n'est plus nécessaire depuis LaTeX 2022-06-01, comme l'illustre
l'exemple ci-dessus.

:::{todo}
Confirmer que c'est bien depuis LaTeX 2022-06-01 que l'argument
de `\cite` est protégé contre le changement de casse dans les en-têtes.
:::


:::{sources}
- [Table of contents rearranges unsrt ordering](faquk:FAQ-bibtocorder)
:::