## TFSA-2021-174: Access to invalid memory during shape inference in `Cudnn*` ops

### CVE Number
CVE-2021-41221

### Impact
The [shape inference code](https://github.com/tensorflow/tensorflow/blob/9ff27787893f76d6971dcd1552eb5270d254f31b/tensorflow/core/ops/cudnn_rnn_ops.cc) for the `Cudnn*` operations in TensorFlow can be tricked into accessing invalid memory, via a heap buffer overflow:

```python
import tensorflow as tf

@tf.function
def func():
  return tf.raw_ops.CudnnRNNV3(
    input=[0.1, 0.1],
    input_h=[0.5],
    input_c=[0.1, 0.1, 0.1],
    params=[0.5, 0.5],
    sequence_lengths=[-1, 0, 1])

func()
```

This occurs because the ranks of the `input`, `input_h` and `input_c` parameters are not validated, but code assumes they have certain values:

```cc
auto input_shape = c->input(0);
auto input_h_shape = c->input(1);
auto seq_length = c->Dim(input_shape, 0);
auto batch_size = c->Dim(input_shape, 1);  // assumes rank >= 2
auto num_units = c->Dim(input_h_shape, 2); // assumes rank >= 3
```

### Patches
We have patched the issue in GitHub commit [af5fcebb37c8b5d71c237f4e59c6477015c78ce6](https://github.com/tensorflow/tensorflow/commit/af5fcebb37c8b5d71c237f4e59c6477015c78ce6).

The fix will be included in TensorFlow 2.7.0. We will also cherrypick this commit on TensorFlow 2.6.1, TensorFlow 2.5.2, and TensorFlow 2.4.4, as these are also affected and still in supported range.

### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo 360.
