## TFSA-2021-134: Division by 0 in inplace operations

### CVE Number
CVE-2021-37660

### Impact
An attacker can cause a floating point exception by calling inplace operations
with crafted arguments that would result in a division by 0:

```python
import tensorflow as tf

tf.raw_ops.InplaceSub(x=[],i=[-99,-1,-1],v=[1,1,1])
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/84d053187cb80d975ef2b9684d4b61981bca0c41/tensorflow/core/kernels/inplace_ops.cc#L283)
has a logic error: it should skip processing if `x` and `v` are empty but the
code uses `||` instead of `&&`.

### Patches
We have patched the issue in GitHub commit
[e86605c0a336c088b638da02135ea6f9f6753618](https://github.com/tensorflow/tensorflow/commit/e86605c0a336c088b638da02135ea6f9f6753618).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
