## TFSA-2021-108: Segfault in `tf.raw_ops.ImmutableConst`

### CVE Number
CVE-2021-29539

### Impact
Calling
[`tf.raw_ops.ImmutableConst`](https://www.tensorflow.org/api_docs/python/tf/raw_ops/ImmutableConst)
with a `dtype` of `tf.resource` or `tf.variant` results in a segfault in the
implementation as code assumes that the tensor contents are pure scalars.

```python
>>> import tensorflow as tf
>>> tf.raw_ops.ImmutableConst(dtype=tf.resource, shape=[],
>>> memory_region_name="/tmp/test.txt")
...
Segmentation fault
```

### Patches
We have patched the issue in GitHub commit
[4f663d4b8f0bec1b48da6fa091a7d29609980fa4](https://github.com/tensorflow/tensorflow/commit/4f663d4b8f0bec1b48da6fa091a7d29609980fa4).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.
