# 2021-11-02 Triage Log

Summary: The only significant regressions were 1. two PRs that slowed down doc
generation, and 2. some slowdown from the new lints to flag occurrences of
Unicode bidirectional control characters. The doc generation regression is being
investigated.

Triage done by **@pnkfelix**.
Revision range: [3c8f001d454b1b495f7472d8430ef8fdf10aac11..6384dca100f3cedfa031a9204586f94f8612eae5](https://perf.rust-lang.org/?start=3c8f001d454b1b495f7472d8430ef8fdf10aac11&end=6384dca100f3cedfa031a9204586f94f8612eae5&absolute=false&stat=instructions%3Au)

6 Regressions, 3 Improvements, 1 Mixed; 4 of them in rollups
39 comparisons made in total

#### Regressions

Fixes incorrect handling of ADT's drop requirements [#90218](https://github.com/rust-lang/rust/issues/90218)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c4ff03f689c03d73d3a8af49611b1f2b54d6a300&end=85c0558d032e204f4f4ed6137f3119cb92dbc684&stat=instructions:u) (up to 5.3% on `full` builds of `regression-31157`)
- regression-31157 check regressed by 4.7% on incr and 5.3 on full.
- issue-46449 check regressed by 1.89% on incr-full.
- wg-grammar regressed by 1.3-1.4% in a bunch of scenarios.
- but otherwise, this does not seem too bad. I think we should keep this PR approved for backport, while also look into fixing the regression on nightly.
- filed [#90504](https://github.com/rust-lang/rust/issues/90504) as followup investigation issue.

Rollup of 3 pull requests [#90387](https://github.com/rust-lang/rust/issues/90387)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c390d69a615f095208ac94841f3310268521b2ee&end=df76418f1ee1a1973e862828ae8520abb6c3794a&stat=instructions:u) (up to 2.4% on `full` builds of `inflate`)
- 2 of the 3 pull requests appear trivial (fixing typos and removing extra lines in documentation), which leaves [PR #90376](https://github.com/rust-lang/rust/pull/90376) as the main suspect.
- Meanwhile, all [PR #90376](https://github.com/rust-lang/rust/pull/90376) does, according to its description, is move code around, remove dead code, and inline a singly called function.
- treating as alignment artifacts from code rearrangement. We tend not to micro-optimize that in the compiler.

Rollup of 8 pull requests [#90416](https://github.com/rust-lang/rust/issues/90416)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2b643e987173b36cb0279a018579372e31a35776&end=9f13083542cb2b9fce83ed8a50238e4a6386820f&stat=instructions:u) (up to 2.7% on `full` builds of `helloworld`)
- All the significant perf regressions are due to doc generation (many regressed by 1.0-2.7%).
- filed [#90512](https://github.com/rust-lang/rust/issues/90512) as followup investigation issue.

Rollup of 5 pull requests [#90422](https://github.com/rust-lang/rust/issues/90422)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2609fab8e46414333aa68412134df65c7fcd1a77&end=e249ce6b2345587d6e11052779c86adbad626dff&stat=instructions:u) (up to 5.8% on `full` builds of `tokio-webpush-simple`)
- All the significant perf regressions are due to doc generation (many regressed by 1.0-5.8%).
- discussion is ongoing in [PR 90183](https://github.com/rust-lang/rust/pull/90183)

impl Pattern for char array [#86336](https://github.com/rust-lang/rust/issues/86336)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=68b554e6af18726fe6fa8de2134c59c441e0b019&end=c7e4740ec18996e082fe6e29ebf7efdc7dda418f&stat=instructions:u) (up to 0.6% on `full` builds of `deeply-nested-async`)
- The only benchmarks that regressed did so by a small amount, percentage wise 0.2-0.6%; the benchmarks that did regress in that fashion are: `deeply-nested-async`, `helloworld`, `unify-linearly`.
- I don't think its worth investing effort trying to figure out the root cause of this minor regression, unless someone wants to take it on as a self-educating exercise.

Update cargo [#90490](https://github.com/rust-lang/rust/issues/90490)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6225262562f06d8a52624e7898098b58789a6ae5&end=dca3f1b786efd27be3b325ed1e01e247aa589c3b&stat=instructions:u) (up to 2.0% on `incr-patched: println` builds of `regression-31157`)
- Only regression-31157 opt regressed, by 1.6-2.0%.
- It is not worth investing effort trying to figure out the root cause of this limited regression.
- (Note: regression [#31157](https://github.com/rust-lang/rust/issues/31157) was itself put in to catch a performance regression with respect to time and RAM, but that regression was more like 1,882% in time and 10x in space.)

#### Improvements

Rollup of 4 pull requests [#90314](https://github.com/rust-lang/rust/issues/90314)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=612356aa9a0193cb5aee2b668b3893ddf67da2b5&end=e269e6bf47f40c9046cd44ab787881d700099252&stat=instructions:u) (up to -2.1% on `incr-unchanged` builds of `helloworld`)

Use SortedMap in HIR. [#90145](https://github.com/rust-lang/rust/issues/90145)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=f2707fec04f655cdf18388618881748ebbd683e9&end=c4ff03f689c03d73d3a8af49611b1f2b54d6a300&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `unicode_normalization`)

Revert "Add rustc lint, warning when iterating over hashmaps" [#90380](https://github.com/rust-lang/rust/issues/90380)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a9f664f37d62fd255827a416482186308b8e8f7d&end=88a5a984fe95e0411dce4e8364f9630cadd3782c&stat=instructions:u) (up to -8.9% on `incr-full` builds of `deeply-nested-async`)


#### Mixed

[master] Fix CVE-2021-42574 [#90462](https://github.com/rust-lang/rust/issues/90462)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ff0e14829e1806ca0d4226595f7fdf3e8658758f&end=db14a17e69af2a2e241ce149a501a5281811fe06&stat=instructions:u) (up to -0.5% on `full` builds of `deeply-nested-async`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ff0e14829e1806ca0d4226595f7fdf3e8658758f&end=db14a17e69af2a2e241ce149a501a5281811fe06&stat=instructions:u) (up to 14.2% on `incr-unchanged` builds of `coercions`)
- Filed [issue #90514](https://github.com/rust-lang/rust/issues/90514) for follow up investigation of coercions regression.

#### Untriaged Pull Requests

- [#90490 Update cargo](https://github.com/rust-lang/rust/pull/90490)
- [#90462 [master] Fix CVE-2021-42574](https://github.com/rust-lang/rust/pull/90462)
- [#90422 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90422)
- [#90416 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/90416)
- [#90387 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/90387)
- [#90235 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/90235)
- [#90218 Fixes incorrect handling of ADT's drop requirements](https://github.com/rust-lang/rust/pull/90218)
- [#90183 Show all Deref implementations recursively](https://github.com/rust-lang/rust/pull/90183)
- [#90067 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/90067)
- [#89939 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89939)
- [#89858 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89858)
- [#89695 Move top part of print_item to Tera templates](https://github.com/rust-lang/rust/pull/89695)
- [#89608 Rollup of 12 pull requests](https://github.com/rust-lang/rust/pull/89608)
- [#89534 Introduce `tcx.get_diagnostic_name`](https://github.com/rust-lang/rust/pull/89534)
- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89405 Fix clippy lints](https://github.com/rust-lang/rust/pull/89405)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89124 Index and hash HIR as part of lowering](https://github.com/rust-lang/rust/pull/89124)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89100 resolve: Use `NameBinding` for local variables and generic parameters](https://github.com/rust-lang/rust/pull/89100)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88880 Rework HIR API to make invocations of the hir_crate query harder.](https://github.com/rust-lang/rust/pull/88880)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
