#![doc = " fiat-crypto output postprocessed by fiat-constify: <https://github.com/rustcrypto/utils>"]
#![doc = " Autogenerated: './word_by_word_montgomery' --lang Rust --inline p521_scalar 64 0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409"]
#![doc = " curve description: p521_scalar"]
#![doc = " machine_wordsize = 64 (from \"64\")"]
#![doc = " requested operations: (all)"]
#![doc = " m = 0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409 (from \"0x1fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffa51868783bf2f966b7fcc0148f709a5d03bb5c9b8899c47aebb6fb71e91386409\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180) + (z[7] << 0x1c0) + (z[8] << 2^9)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) + (z[48] << 0x180) + (z[49] << 0x188) + (z[50] << 0x190) + (z[51] << 0x198) + (z[52] << 0x1a0) + (z[53] << 0x1a8) + (z[54] << 0x1b0) + (z[55] << 0x1b8) + (z[56] << 0x1c0) + (z[57] << 0x1c8) + (z[58] << 0x1d0) + (z[59] << 0x1d8) + (z[60] << 0x1e0) + (z[61] << 0x1e8) + (z[62] << 0x1f0) + (z[63] << 0x1f8) + (z[64] << 2^9) + (z[65] << 0x208)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) + (z[6] << 0x180) + (z[7] << 0x1c0) + (z[8] << 2^9) in"]
#![doc = "                            if x1 & (2^576-1) < 2^575 then x1 & (2^576-1) else (x1 & (2^576-1)) - 2^576"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    clippy::identity_op,
    clippy::unnecessary_cast,
    dead_code,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p521_scalar_u1 = u8;
pub type fiat_p521_scalar_i1 = i8;
pub type fiat_p521_scalar_u2 = u8;
pub type fiat_p521_scalar_i2 = i8;
pub type fiat_p521_scalar_montgomery_domain_field_element = [u64; 9];
pub type fiat_p521_scalar_non_montgomery_domain_field_element = [u64; 9];
#[doc = " The function fiat_p521_scalar_addcarryx_u64 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^64"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p521_scalar_addcarryx_u64(
    arg1: fiat_p521_scalar_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p521_scalar_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p521_scalar_u1 = 0;
    let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: fiat_p521_scalar_u1 = ((x1 >> 64) as fiat_p521_scalar_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p521_scalar_subborrowx_u64 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^64"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p521_scalar_subborrowx_u64(
    arg1: fiat_p521_scalar_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p521_scalar_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p521_scalar_u1 = 0;
    let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
    let x2: fiat_p521_scalar_i1 = ((x1 >> 64) as fiat_p521_scalar_i1);
    let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
    out1 = x3;
    out2 = (((0x0 as fiat_p521_scalar_i2) - (x2 as fiat_p521_scalar_i2)) as fiat_p521_scalar_u1);
    (out1, out2)
}
#[doc = " The function fiat_p521_scalar_mulx_u64 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^64"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p521_scalar_mulx_u64(arg1: u64, arg2: u64) -> (u64, u64) {
    let mut out1: u64 = 0;
    let mut out2: u64 = 0;
    let x1: u128 = ((arg1 as u128) * (arg2 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: u64 = ((x1 >> 64) as u64);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p521_scalar_cmovznz_u64 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p521_scalar_cmovznz_u64(arg1: fiat_p521_scalar_u1, arg2: u64, arg3: u64) -> u64 {
    let mut out1: u64 = 0;
    let x1: fiat_p521_scalar_u1 = (!(!arg1));
    let x2: u64 = ((((((0x0 as fiat_p521_scalar_i2) - (x1 as fiat_p521_scalar_i2))
        as fiat_p521_scalar_i1) as i128)
        & (0xffffffffffffffff as i128)) as u64);
    let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p521_scalar_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_mul(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[6]);
    let x7: u64 = (arg1[7]);
    let x8: u64 = (arg1[8]);
    let x9: u64 = (arg1[0]);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p521_scalar_mulx_u64(x9, (arg2[8]));
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    let (x12, x13) = fiat_p521_scalar_mulx_u64(x9, (arg2[7]));
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    let (x14, x15) = fiat_p521_scalar_mulx_u64(x9, (arg2[6]));
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    let (x16, x17) = fiat_p521_scalar_mulx_u64(x9, (arg2[5]));
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    let (x18, x19) = fiat_p521_scalar_mulx_u64(x9, (arg2[4]));
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p521_scalar_mulx_u64(x9, (arg2[3]));
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    let (x22, x23) = fiat_p521_scalar_mulx_u64(x9, (arg2[2]));
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    let (x24, x25) = fiat_p521_scalar_mulx_u64(x9, (arg2[1]));
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    let (x26, x27) = fiat_p521_scalar_mulx_u64(x9, (arg2[0]));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    let (x38, x39) = fiat_p521_scalar_addcarryx_u64(x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    let (x40, x41) = fiat_p521_scalar_addcarryx_u64(x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    let (x42, x43) = fiat_p521_scalar_addcarryx_u64(x41, x13, x10);
    let x44: u64 = ((x43 as u64) + x11);
    let mut x45: u64 = 0;
    let mut x46: u64 = 0;
    let (x45, x46) = fiat_p521_scalar_mulx_u64(x26, 0x1d2f5ccd79a995c7);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    let (x47, x48) = fiat_p521_scalar_mulx_u64(x45, 0x1ff);
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    let (x49, x50) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    let (x51, x52) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    let (x53, x54) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x55: u64 = 0;
    let mut x56: u64 = 0;
    let (x55, x56) = fiat_p521_scalar_mulx_u64(x45, 0xfffffffffffffffa);
    let mut x57: u64 = 0;
    let mut x58: u64 = 0;
    let (x57, x58) = fiat_p521_scalar_mulx_u64(x45, 0x51868783bf2f966b);
    let mut x59: u64 = 0;
    let mut x60: u64 = 0;
    let (x59, x60) = fiat_p521_scalar_mulx_u64(x45, 0x7fcc0148f709a5d0);
    let mut x61: u64 = 0;
    let mut x62: u64 = 0;
    let (x61, x62) = fiat_p521_scalar_mulx_u64(x45, 0x3bb5c9b8899c47ae);
    let mut x63: u64 = 0;
    let mut x64: u64 = 0;
    let (x63, x64) = fiat_p521_scalar_mulx_u64(x45, 0xbb6fb71e91386409);
    let mut x65: u64 = 0;
    let mut x66: fiat_p521_scalar_u1 = 0;
    let (x65, x66) = fiat_p521_scalar_addcarryx_u64(0x0, x64, x61);
    let mut x67: u64 = 0;
    let mut x68: fiat_p521_scalar_u1 = 0;
    let (x67, x68) = fiat_p521_scalar_addcarryx_u64(x66, x62, x59);
    let mut x69: u64 = 0;
    let mut x70: fiat_p521_scalar_u1 = 0;
    let (x69, x70) = fiat_p521_scalar_addcarryx_u64(x68, x60, x57);
    let mut x71: u64 = 0;
    let mut x72: fiat_p521_scalar_u1 = 0;
    let (x71, x72) = fiat_p521_scalar_addcarryx_u64(x70, x58, x55);
    let mut x73: u64 = 0;
    let mut x74: fiat_p521_scalar_u1 = 0;
    let (x73, x74) = fiat_p521_scalar_addcarryx_u64(x72, x56, x53);
    let mut x75: u64 = 0;
    let mut x76: fiat_p521_scalar_u1 = 0;
    let (x75, x76) = fiat_p521_scalar_addcarryx_u64(x74, x54, x51);
    let mut x77: u64 = 0;
    let mut x78: fiat_p521_scalar_u1 = 0;
    let (x77, x78) = fiat_p521_scalar_addcarryx_u64(x76, x52, x49);
    let mut x79: u64 = 0;
    let mut x80: fiat_p521_scalar_u1 = 0;
    let (x79, x80) = fiat_p521_scalar_addcarryx_u64(x78, x50, x47);
    let x81: u64 = ((x80 as u64) + x48);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    let (x82, x83) = fiat_p521_scalar_addcarryx_u64(0x0, x26, x63);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    let (x84, x85) = fiat_p521_scalar_addcarryx_u64(x83, x28, x65);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    let (x86, x87) = fiat_p521_scalar_addcarryx_u64(x85, x30, x67);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    let (x88, x89) = fiat_p521_scalar_addcarryx_u64(x87, x32, x69);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    let (x90, x91) = fiat_p521_scalar_addcarryx_u64(x89, x34, x71);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    let (x92, x93) = fiat_p521_scalar_addcarryx_u64(x91, x36, x73);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    let (x94, x95) = fiat_p521_scalar_addcarryx_u64(x93, x38, x75);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    let (x96, x97) = fiat_p521_scalar_addcarryx_u64(x95, x40, x77);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    let (x98, x99) = fiat_p521_scalar_addcarryx_u64(x97, x42, x79);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    let (x100, x101) = fiat_p521_scalar_addcarryx_u64(x99, x44, x81);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p521_scalar_mulx_u64(x1, (arg2[8]));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p521_scalar_mulx_u64(x1, (arg2[7]));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p521_scalar_mulx_u64(x1, (arg2[6]));
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p521_scalar_mulx_u64(x1, (arg2[5]));
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p521_scalar_mulx_u64(x1, (arg2[4]));
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p521_scalar_mulx_u64(x1, (arg2[3]));
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p521_scalar_mulx_u64(x1, (arg2[2]));
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    let (x116, x117) = fiat_p521_scalar_mulx_u64(x1, (arg2[1]));
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    let (x118, x119) = fiat_p521_scalar_mulx_u64(x1, (arg2[0]));
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    let (x120, x121) = fiat_p521_scalar_addcarryx_u64(0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    let (x122, x123) = fiat_p521_scalar_addcarryx_u64(x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    let (x124, x125) = fiat_p521_scalar_addcarryx_u64(x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    let (x126, x127) = fiat_p521_scalar_addcarryx_u64(x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    let (x128, x129) = fiat_p521_scalar_addcarryx_u64(x127, x111, x108);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    let (x130, x131) = fiat_p521_scalar_addcarryx_u64(x129, x109, x106);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    let (x132, x133) = fiat_p521_scalar_addcarryx_u64(x131, x107, x104);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    let (x134, x135) = fiat_p521_scalar_addcarryx_u64(x133, x105, x102);
    let x136: u64 = ((x135 as u64) + x103);
    let mut x137: u64 = 0;
    let mut x138: fiat_p521_scalar_u1 = 0;
    let (x137, x138) = fiat_p521_scalar_addcarryx_u64(0x0, x84, x118);
    let mut x139: u64 = 0;
    let mut x140: fiat_p521_scalar_u1 = 0;
    let (x139, x140) = fiat_p521_scalar_addcarryx_u64(x138, x86, x120);
    let mut x141: u64 = 0;
    let mut x142: fiat_p521_scalar_u1 = 0;
    let (x141, x142) = fiat_p521_scalar_addcarryx_u64(x140, x88, x122);
    let mut x143: u64 = 0;
    let mut x144: fiat_p521_scalar_u1 = 0;
    let (x143, x144) = fiat_p521_scalar_addcarryx_u64(x142, x90, x124);
    let mut x145: u64 = 0;
    let mut x146: fiat_p521_scalar_u1 = 0;
    let (x145, x146) = fiat_p521_scalar_addcarryx_u64(x144, x92, x126);
    let mut x147: u64 = 0;
    let mut x148: fiat_p521_scalar_u1 = 0;
    let (x147, x148) = fiat_p521_scalar_addcarryx_u64(x146, x94, x128);
    let mut x149: u64 = 0;
    let mut x150: fiat_p521_scalar_u1 = 0;
    let (x149, x150) = fiat_p521_scalar_addcarryx_u64(x148, x96, x130);
    let mut x151: u64 = 0;
    let mut x152: fiat_p521_scalar_u1 = 0;
    let (x151, x152) = fiat_p521_scalar_addcarryx_u64(x150, x98, x132);
    let mut x153: u64 = 0;
    let mut x154: fiat_p521_scalar_u1 = 0;
    let (x153, x154) = fiat_p521_scalar_addcarryx_u64(x152, x100, x134);
    let mut x155: u64 = 0;
    let mut x156: fiat_p521_scalar_u1 = 0;
    let (x155, x156) = fiat_p521_scalar_addcarryx_u64(x154, (x101 as u64), x136);
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p521_scalar_mulx_u64(x137, 0x1d2f5ccd79a995c7);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p521_scalar_mulx_u64(x157, 0x1ff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    let (x161, x162) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    let (x163, x164) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    let (x165, x166) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x167: u64 = 0;
    let mut x168: u64 = 0;
    let (x167, x168) = fiat_p521_scalar_mulx_u64(x157, 0xfffffffffffffffa);
    let mut x169: u64 = 0;
    let mut x170: u64 = 0;
    let (x169, x170) = fiat_p521_scalar_mulx_u64(x157, 0x51868783bf2f966b);
    let mut x171: u64 = 0;
    let mut x172: u64 = 0;
    let (x171, x172) = fiat_p521_scalar_mulx_u64(x157, 0x7fcc0148f709a5d0);
    let mut x173: u64 = 0;
    let mut x174: u64 = 0;
    let (x173, x174) = fiat_p521_scalar_mulx_u64(x157, 0x3bb5c9b8899c47ae);
    let mut x175: u64 = 0;
    let mut x176: u64 = 0;
    let (x175, x176) = fiat_p521_scalar_mulx_u64(x157, 0xbb6fb71e91386409);
    let mut x177: u64 = 0;
    let mut x178: fiat_p521_scalar_u1 = 0;
    let (x177, x178) = fiat_p521_scalar_addcarryx_u64(0x0, x176, x173);
    let mut x179: u64 = 0;
    let mut x180: fiat_p521_scalar_u1 = 0;
    let (x179, x180) = fiat_p521_scalar_addcarryx_u64(x178, x174, x171);
    let mut x181: u64 = 0;
    let mut x182: fiat_p521_scalar_u1 = 0;
    let (x181, x182) = fiat_p521_scalar_addcarryx_u64(x180, x172, x169);
    let mut x183: u64 = 0;
    let mut x184: fiat_p521_scalar_u1 = 0;
    let (x183, x184) = fiat_p521_scalar_addcarryx_u64(x182, x170, x167);
    let mut x185: u64 = 0;
    let mut x186: fiat_p521_scalar_u1 = 0;
    let (x185, x186) = fiat_p521_scalar_addcarryx_u64(x184, x168, x165);
    let mut x187: u64 = 0;
    let mut x188: fiat_p521_scalar_u1 = 0;
    let (x187, x188) = fiat_p521_scalar_addcarryx_u64(x186, x166, x163);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    let (x189, x190) = fiat_p521_scalar_addcarryx_u64(x188, x164, x161);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    let (x191, x192) = fiat_p521_scalar_addcarryx_u64(x190, x162, x159);
    let x193: u64 = ((x192 as u64) + x160);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    let (x194, x195) = fiat_p521_scalar_addcarryx_u64(0x0, x137, x175);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    let (x196, x197) = fiat_p521_scalar_addcarryx_u64(x195, x139, x177);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    let (x198, x199) = fiat_p521_scalar_addcarryx_u64(x197, x141, x179);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    let (x200, x201) = fiat_p521_scalar_addcarryx_u64(x199, x143, x181);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    let (x202, x203) = fiat_p521_scalar_addcarryx_u64(x201, x145, x183);
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    let (x204, x205) = fiat_p521_scalar_addcarryx_u64(x203, x147, x185);
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    let (x206, x207) = fiat_p521_scalar_addcarryx_u64(x205, x149, x187);
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    let (x208, x209) = fiat_p521_scalar_addcarryx_u64(x207, x151, x189);
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    let (x210, x211) = fiat_p521_scalar_addcarryx_u64(x209, x153, x191);
    let mut x212: u64 = 0;
    let mut x213: fiat_p521_scalar_u1 = 0;
    let (x212, x213) = fiat_p521_scalar_addcarryx_u64(x211, x155, x193);
    let x214: u64 = ((x213 as u64) + (x156 as u64));
    let mut x215: u64 = 0;
    let mut x216: u64 = 0;
    let (x215, x216) = fiat_p521_scalar_mulx_u64(x2, (arg2[8]));
    let mut x217: u64 = 0;
    let mut x218: u64 = 0;
    let (x217, x218) = fiat_p521_scalar_mulx_u64(x2, (arg2[7]));
    let mut x219: u64 = 0;
    let mut x220: u64 = 0;
    let (x219, x220) = fiat_p521_scalar_mulx_u64(x2, (arg2[6]));
    let mut x221: u64 = 0;
    let mut x222: u64 = 0;
    let (x221, x222) = fiat_p521_scalar_mulx_u64(x2, (arg2[5]));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    let (x223, x224) = fiat_p521_scalar_mulx_u64(x2, (arg2[4]));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    let (x225, x226) = fiat_p521_scalar_mulx_u64(x2, (arg2[3]));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    let (x227, x228) = fiat_p521_scalar_mulx_u64(x2, (arg2[2]));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    let (x229, x230) = fiat_p521_scalar_mulx_u64(x2, (arg2[1]));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    let (x231, x232) = fiat_p521_scalar_mulx_u64(x2, (arg2[0]));
    let mut x233: u64 = 0;
    let mut x234: fiat_p521_scalar_u1 = 0;
    let (x233, x234) = fiat_p521_scalar_addcarryx_u64(0x0, x232, x229);
    let mut x235: u64 = 0;
    let mut x236: fiat_p521_scalar_u1 = 0;
    let (x235, x236) = fiat_p521_scalar_addcarryx_u64(x234, x230, x227);
    let mut x237: u64 = 0;
    let mut x238: fiat_p521_scalar_u1 = 0;
    let (x237, x238) = fiat_p521_scalar_addcarryx_u64(x236, x228, x225);
    let mut x239: u64 = 0;
    let mut x240: fiat_p521_scalar_u1 = 0;
    let (x239, x240) = fiat_p521_scalar_addcarryx_u64(x238, x226, x223);
    let mut x241: u64 = 0;
    let mut x242: fiat_p521_scalar_u1 = 0;
    let (x241, x242) = fiat_p521_scalar_addcarryx_u64(x240, x224, x221);
    let mut x243: u64 = 0;
    let mut x244: fiat_p521_scalar_u1 = 0;
    let (x243, x244) = fiat_p521_scalar_addcarryx_u64(x242, x222, x219);
    let mut x245: u64 = 0;
    let mut x246: fiat_p521_scalar_u1 = 0;
    let (x245, x246) = fiat_p521_scalar_addcarryx_u64(x244, x220, x217);
    let mut x247: u64 = 0;
    let mut x248: fiat_p521_scalar_u1 = 0;
    let (x247, x248) = fiat_p521_scalar_addcarryx_u64(x246, x218, x215);
    let x249: u64 = ((x248 as u64) + x216);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    let (x250, x251) = fiat_p521_scalar_addcarryx_u64(0x0, x196, x231);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    let (x252, x253) = fiat_p521_scalar_addcarryx_u64(x251, x198, x233);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    let (x254, x255) = fiat_p521_scalar_addcarryx_u64(x253, x200, x235);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    let (x256, x257) = fiat_p521_scalar_addcarryx_u64(x255, x202, x237);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    let (x258, x259) = fiat_p521_scalar_addcarryx_u64(x257, x204, x239);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    let (x260, x261) = fiat_p521_scalar_addcarryx_u64(x259, x206, x241);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    let (x262, x263) = fiat_p521_scalar_addcarryx_u64(x261, x208, x243);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    let (x264, x265) = fiat_p521_scalar_addcarryx_u64(x263, x210, x245);
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    let (x266, x267) = fiat_p521_scalar_addcarryx_u64(x265, x212, x247);
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    let (x268, x269) = fiat_p521_scalar_addcarryx_u64(x267, x214, x249);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    let (x270, x271) = fiat_p521_scalar_mulx_u64(x250, 0x1d2f5ccd79a995c7);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    let (x272, x273) = fiat_p521_scalar_mulx_u64(x270, 0x1ff);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    let (x274, x275) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x276: u64 = 0;
    let mut x277: u64 = 0;
    let (x276, x277) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x278: u64 = 0;
    let mut x279: u64 = 0;
    let (x278, x279) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x280: u64 = 0;
    let mut x281: u64 = 0;
    let (x280, x281) = fiat_p521_scalar_mulx_u64(x270, 0xfffffffffffffffa);
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    let (x282, x283) = fiat_p521_scalar_mulx_u64(x270, 0x51868783bf2f966b);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    let (x284, x285) = fiat_p521_scalar_mulx_u64(x270, 0x7fcc0148f709a5d0);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    let (x286, x287) = fiat_p521_scalar_mulx_u64(x270, 0x3bb5c9b8899c47ae);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    let (x288, x289) = fiat_p521_scalar_mulx_u64(x270, 0xbb6fb71e91386409);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    let (x290, x291) = fiat_p521_scalar_addcarryx_u64(0x0, x289, x286);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    let (x292, x293) = fiat_p521_scalar_addcarryx_u64(x291, x287, x284);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    let (x294, x295) = fiat_p521_scalar_addcarryx_u64(x293, x285, x282);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    let (x296, x297) = fiat_p521_scalar_addcarryx_u64(x295, x283, x280);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    let (x298, x299) = fiat_p521_scalar_addcarryx_u64(x297, x281, x278);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    let (x300, x301) = fiat_p521_scalar_addcarryx_u64(x299, x279, x276);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    let (x302, x303) = fiat_p521_scalar_addcarryx_u64(x301, x277, x274);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    let (x304, x305) = fiat_p521_scalar_addcarryx_u64(x303, x275, x272);
    let x306: u64 = ((x305 as u64) + x273);
    let mut x307: u64 = 0;
    let mut x308: fiat_p521_scalar_u1 = 0;
    let (x307, x308) = fiat_p521_scalar_addcarryx_u64(0x0, x250, x288);
    let mut x309: u64 = 0;
    let mut x310: fiat_p521_scalar_u1 = 0;
    let (x309, x310) = fiat_p521_scalar_addcarryx_u64(x308, x252, x290);
    let mut x311: u64 = 0;
    let mut x312: fiat_p521_scalar_u1 = 0;
    let (x311, x312) = fiat_p521_scalar_addcarryx_u64(x310, x254, x292);
    let mut x313: u64 = 0;
    let mut x314: fiat_p521_scalar_u1 = 0;
    let (x313, x314) = fiat_p521_scalar_addcarryx_u64(x312, x256, x294);
    let mut x315: u64 = 0;
    let mut x316: fiat_p521_scalar_u1 = 0;
    let (x315, x316) = fiat_p521_scalar_addcarryx_u64(x314, x258, x296);
    let mut x317: u64 = 0;
    let mut x318: fiat_p521_scalar_u1 = 0;
    let (x317, x318) = fiat_p521_scalar_addcarryx_u64(x316, x260, x298);
    let mut x319: u64 = 0;
    let mut x320: fiat_p521_scalar_u1 = 0;
    let (x319, x320) = fiat_p521_scalar_addcarryx_u64(x318, x262, x300);
    let mut x321: u64 = 0;
    let mut x322: fiat_p521_scalar_u1 = 0;
    let (x321, x322) = fiat_p521_scalar_addcarryx_u64(x320, x264, x302);
    let mut x323: u64 = 0;
    let mut x324: fiat_p521_scalar_u1 = 0;
    let (x323, x324) = fiat_p521_scalar_addcarryx_u64(x322, x266, x304);
    let mut x325: u64 = 0;
    let mut x326: fiat_p521_scalar_u1 = 0;
    let (x325, x326) = fiat_p521_scalar_addcarryx_u64(x324, x268, x306);
    let x327: u64 = ((x326 as u64) + (x269 as u64));
    let mut x328: u64 = 0;
    let mut x329: u64 = 0;
    let (x328, x329) = fiat_p521_scalar_mulx_u64(x3, (arg2[8]));
    let mut x330: u64 = 0;
    let mut x331: u64 = 0;
    let (x330, x331) = fiat_p521_scalar_mulx_u64(x3, (arg2[7]));
    let mut x332: u64 = 0;
    let mut x333: u64 = 0;
    let (x332, x333) = fiat_p521_scalar_mulx_u64(x3, (arg2[6]));
    let mut x334: u64 = 0;
    let mut x335: u64 = 0;
    let (x334, x335) = fiat_p521_scalar_mulx_u64(x3, (arg2[5]));
    let mut x336: u64 = 0;
    let mut x337: u64 = 0;
    let (x336, x337) = fiat_p521_scalar_mulx_u64(x3, (arg2[4]));
    let mut x338: u64 = 0;
    let mut x339: u64 = 0;
    let (x338, x339) = fiat_p521_scalar_mulx_u64(x3, (arg2[3]));
    let mut x340: u64 = 0;
    let mut x341: u64 = 0;
    let (x340, x341) = fiat_p521_scalar_mulx_u64(x3, (arg2[2]));
    let mut x342: u64 = 0;
    let mut x343: u64 = 0;
    let (x342, x343) = fiat_p521_scalar_mulx_u64(x3, (arg2[1]));
    let mut x344: u64 = 0;
    let mut x345: u64 = 0;
    let (x344, x345) = fiat_p521_scalar_mulx_u64(x3, (arg2[0]));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    let (x346, x347) = fiat_p521_scalar_addcarryx_u64(0x0, x345, x342);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    let (x348, x349) = fiat_p521_scalar_addcarryx_u64(x347, x343, x340);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    let (x350, x351) = fiat_p521_scalar_addcarryx_u64(x349, x341, x338);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    let (x352, x353) = fiat_p521_scalar_addcarryx_u64(x351, x339, x336);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    let (x354, x355) = fiat_p521_scalar_addcarryx_u64(x353, x337, x334);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    let (x356, x357) = fiat_p521_scalar_addcarryx_u64(x355, x335, x332);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    let (x358, x359) = fiat_p521_scalar_addcarryx_u64(x357, x333, x330);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    let (x360, x361) = fiat_p521_scalar_addcarryx_u64(x359, x331, x328);
    let x362: u64 = ((x361 as u64) + x329);
    let mut x363: u64 = 0;
    let mut x364: fiat_p521_scalar_u1 = 0;
    let (x363, x364) = fiat_p521_scalar_addcarryx_u64(0x0, x309, x344);
    let mut x365: u64 = 0;
    let mut x366: fiat_p521_scalar_u1 = 0;
    let (x365, x366) = fiat_p521_scalar_addcarryx_u64(x364, x311, x346);
    let mut x367: u64 = 0;
    let mut x368: fiat_p521_scalar_u1 = 0;
    let (x367, x368) = fiat_p521_scalar_addcarryx_u64(x366, x313, x348);
    let mut x369: u64 = 0;
    let mut x370: fiat_p521_scalar_u1 = 0;
    let (x369, x370) = fiat_p521_scalar_addcarryx_u64(x368, x315, x350);
    let mut x371: u64 = 0;
    let mut x372: fiat_p521_scalar_u1 = 0;
    let (x371, x372) = fiat_p521_scalar_addcarryx_u64(x370, x317, x352);
    let mut x373: u64 = 0;
    let mut x374: fiat_p521_scalar_u1 = 0;
    let (x373, x374) = fiat_p521_scalar_addcarryx_u64(x372, x319, x354);
    let mut x375: u64 = 0;
    let mut x376: fiat_p521_scalar_u1 = 0;
    let (x375, x376) = fiat_p521_scalar_addcarryx_u64(x374, x321, x356);
    let mut x377: u64 = 0;
    let mut x378: fiat_p521_scalar_u1 = 0;
    let (x377, x378) = fiat_p521_scalar_addcarryx_u64(x376, x323, x358);
    let mut x379: u64 = 0;
    let mut x380: fiat_p521_scalar_u1 = 0;
    let (x379, x380) = fiat_p521_scalar_addcarryx_u64(x378, x325, x360);
    let mut x381: u64 = 0;
    let mut x382: fiat_p521_scalar_u1 = 0;
    let (x381, x382) = fiat_p521_scalar_addcarryx_u64(x380, x327, x362);
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    let (x383, x384) = fiat_p521_scalar_mulx_u64(x363, 0x1d2f5ccd79a995c7);
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    let (x385, x386) = fiat_p521_scalar_mulx_u64(x383, 0x1ff);
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    let (x387, x388) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x389: u64 = 0;
    let mut x390: u64 = 0;
    let (x389, x390) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x391: u64 = 0;
    let mut x392: u64 = 0;
    let (x391, x392) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x393: u64 = 0;
    let mut x394: u64 = 0;
    let (x393, x394) = fiat_p521_scalar_mulx_u64(x383, 0xfffffffffffffffa);
    let mut x395: u64 = 0;
    let mut x396: u64 = 0;
    let (x395, x396) = fiat_p521_scalar_mulx_u64(x383, 0x51868783bf2f966b);
    let mut x397: u64 = 0;
    let mut x398: u64 = 0;
    let (x397, x398) = fiat_p521_scalar_mulx_u64(x383, 0x7fcc0148f709a5d0);
    let mut x399: u64 = 0;
    let mut x400: u64 = 0;
    let (x399, x400) = fiat_p521_scalar_mulx_u64(x383, 0x3bb5c9b8899c47ae);
    let mut x401: u64 = 0;
    let mut x402: u64 = 0;
    let (x401, x402) = fiat_p521_scalar_mulx_u64(x383, 0xbb6fb71e91386409);
    let mut x403: u64 = 0;
    let mut x404: fiat_p521_scalar_u1 = 0;
    let (x403, x404) = fiat_p521_scalar_addcarryx_u64(0x0, x402, x399);
    let mut x405: u64 = 0;
    let mut x406: fiat_p521_scalar_u1 = 0;
    let (x405, x406) = fiat_p521_scalar_addcarryx_u64(x404, x400, x397);
    let mut x407: u64 = 0;
    let mut x408: fiat_p521_scalar_u1 = 0;
    let (x407, x408) = fiat_p521_scalar_addcarryx_u64(x406, x398, x395);
    let mut x409: u64 = 0;
    let mut x410: fiat_p521_scalar_u1 = 0;
    let (x409, x410) = fiat_p521_scalar_addcarryx_u64(x408, x396, x393);
    let mut x411: u64 = 0;
    let mut x412: fiat_p521_scalar_u1 = 0;
    let (x411, x412) = fiat_p521_scalar_addcarryx_u64(x410, x394, x391);
    let mut x413: u64 = 0;
    let mut x414: fiat_p521_scalar_u1 = 0;
    let (x413, x414) = fiat_p521_scalar_addcarryx_u64(x412, x392, x389);
    let mut x415: u64 = 0;
    let mut x416: fiat_p521_scalar_u1 = 0;
    let (x415, x416) = fiat_p521_scalar_addcarryx_u64(x414, x390, x387);
    let mut x417: u64 = 0;
    let mut x418: fiat_p521_scalar_u1 = 0;
    let (x417, x418) = fiat_p521_scalar_addcarryx_u64(x416, x388, x385);
    let x419: u64 = ((x418 as u64) + x386);
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    let (x420, x421) = fiat_p521_scalar_addcarryx_u64(0x0, x363, x401);
    let mut x422: u64 = 0;
    let mut x423: fiat_p521_scalar_u1 = 0;
    let (x422, x423) = fiat_p521_scalar_addcarryx_u64(x421, x365, x403);
    let mut x424: u64 = 0;
    let mut x425: fiat_p521_scalar_u1 = 0;
    let (x424, x425) = fiat_p521_scalar_addcarryx_u64(x423, x367, x405);
    let mut x426: u64 = 0;
    let mut x427: fiat_p521_scalar_u1 = 0;
    let (x426, x427) = fiat_p521_scalar_addcarryx_u64(x425, x369, x407);
    let mut x428: u64 = 0;
    let mut x429: fiat_p521_scalar_u1 = 0;
    let (x428, x429) = fiat_p521_scalar_addcarryx_u64(x427, x371, x409);
    let mut x430: u64 = 0;
    let mut x431: fiat_p521_scalar_u1 = 0;
    let (x430, x431) = fiat_p521_scalar_addcarryx_u64(x429, x373, x411);
    let mut x432: u64 = 0;
    let mut x433: fiat_p521_scalar_u1 = 0;
    let (x432, x433) = fiat_p521_scalar_addcarryx_u64(x431, x375, x413);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    let (x434, x435) = fiat_p521_scalar_addcarryx_u64(x433, x377, x415);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    let (x436, x437) = fiat_p521_scalar_addcarryx_u64(x435, x379, x417);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    let (x438, x439) = fiat_p521_scalar_addcarryx_u64(x437, x381, x419);
    let x440: u64 = ((x439 as u64) + (x382 as u64));
    let mut x441: u64 = 0;
    let mut x442: u64 = 0;
    let (x441, x442) = fiat_p521_scalar_mulx_u64(x4, (arg2[8]));
    let mut x443: u64 = 0;
    let mut x444: u64 = 0;
    let (x443, x444) = fiat_p521_scalar_mulx_u64(x4, (arg2[7]));
    let mut x445: u64 = 0;
    let mut x446: u64 = 0;
    let (x445, x446) = fiat_p521_scalar_mulx_u64(x4, (arg2[6]));
    let mut x447: u64 = 0;
    let mut x448: u64 = 0;
    let (x447, x448) = fiat_p521_scalar_mulx_u64(x4, (arg2[5]));
    let mut x449: u64 = 0;
    let mut x450: u64 = 0;
    let (x449, x450) = fiat_p521_scalar_mulx_u64(x4, (arg2[4]));
    let mut x451: u64 = 0;
    let mut x452: u64 = 0;
    let (x451, x452) = fiat_p521_scalar_mulx_u64(x4, (arg2[3]));
    let mut x453: u64 = 0;
    let mut x454: u64 = 0;
    let (x453, x454) = fiat_p521_scalar_mulx_u64(x4, (arg2[2]));
    let mut x455: u64 = 0;
    let mut x456: u64 = 0;
    let (x455, x456) = fiat_p521_scalar_mulx_u64(x4, (arg2[1]));
    let mut x457: u64 = 0;
    let mut x458: u64 = 0;
    let (x457, x458) = fiat_p521_scalar_mulx_u64(x4, (arg2[0]));
    let mut x459: u64 = 0;
    let mut x460: fiat_p521_scalar_u1 = 0;
    let (x459, x460) = fiat_p521_scalar_addcarryx_u64(0x0, x458, x455);
    let mut x461: u64 = 0;
    let mut x462: fiat_p521_scalar_u1 = 0;
    let (x461, x462) = fiat_p521_scalar_addcarryx_u64(x460, x456, x453);
    let mut x463: u64 = 0;
    let mut x464: fiat_p521_scalar_u1 = 0;
    let (x463, x464) = fiat_p521_scalar_addcarryx_u64(x462, x454, x451);
    let mut x465: u64 = 0;
    let mut x466: fiat_p521_scalar_u1 = 0;
    let (x465, x466) = fiat_p521_scalar_addcarryx_u64(x464, x452, x449);
    let mut x467: u64 = 0;
    let mut x468: fiat_p521_scalar_u1 = 0;
    let (x467, x468) = fiat_p521_scalar_addcarryx_u64(x466, x450, x447);
    let mut x469: u64 = 0;
    let mut x470: fiat_p521_scalar_u1 = 0;
    let (x469, x470) = fiat_p521_scalar_addcarryx_u64(x468, x448, x445);
    let mut x471: u64 = 0;
    let mut x472: fiat_p521_scalar_u1 = 0;
    let (x471, x472) = fiat_p521_scalar_addcarryx_u64(x470, x446, x443);
    let mut x473: u64 = 0;
    let mut x474: fiat_p521_scalar_u1 = 0;
    let (x473, x474) = fiat_p521_scalar_addcarryx_u64(x472, x444, x441);
    let x475: u64 = ((x474 as u64) + x442);
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    let (x476, x477) = fiat_p521_scalar_addcarryx_u64(0x0, x422, x457);
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    let (x478, x479) = fiat_p521_scalar_addcarryx_u64(x477, x424, x459);
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    let (x480, x481) = fiat_p521_scalar_addcarryx_u64(x479, x426, x461);
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    let (x482, x483) = fiat_p521_scalar_addcarryx_u64(x481, x428, x463);
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    let (x484, x485) = fiat_p521_scalar_addcarryx_u64(x483, x430, x465);
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    let (x486, x487) = fiat_p521_scalar_addcarryx_u64(x485, x432, x467);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    let (x488, x489) = fiat_p521_scalar_addcarryx_u64(x487, x434, x469);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    let (x490, x491) = fiat_p521_scalar_addcarryx_u64(x489, x436, x471);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    let (x492, x493) = fiat_p521_scalar_addcarryx_u64(x491, x438, x473);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    let (x494, x495) = fiat_p521_scalar_addcarryx_u64(x493, x440, x475);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    let (x496, x497) = fiat_p521_scalar_mulx_u64(x476, 0x1d2f5ccd79a995c7);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    let (x498, x499) = fiat_p521_scalar_mulx_u64(x496, 0x1ff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    let (x500, x501) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    let (x502, x503) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    let (x504, x505) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    let (x506, x507) = fiat_p521_scalar_mulx_u64(x496, 0xfffffffffffffffa);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    let (x508, x509) = fiat_p521_scalar_mulx_u64(x496, 0x51868783bf2f966b);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    let (x510, x511) = fiat_p521_scalar_mulx_u64(x496, 0x7fcc0148f709a5d0);
    let mut x512: u64 = 0;
    let mut x513: u64 = 0;
    let (x512, x513) = fiat_p521_scalar_mulx_u64(x496, 0x3bb5c9b8899c47ae);
    let mut x514: u64 = 0;
    let mut x515: u64 = 0;
    let (x514, x515) = fiat_p521_scalar_mulx_u64(x496, 0xbb6fb71e91386409);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    let (x516, x517) = fiat_p521_scalar_addcarryx_u64(0x0, x515, x512);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    let (x518, x519) = fiat_p521_scalar_addcarryx_u64(x517, x513, x510);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    let (x520, x521) = fiat_p521_scalar_addcarryx_u64(x519, x511, x508);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    let (x522, x523) = fiat_p521_scalar_addcarryx_u64(x521, x509, x506);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    let (x524, x525) = fiat_p521_scalar_addcarryx_u64(x523, x507, x504);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    let (x526, x527) = fiat_p521_scalar_addcarryx_u64(x525, x505, x502);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    let (x528, x529) = fiat_p521_scalar_addcarryx_u64(x527, x503, x500);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    let (x530, x531) = fiat_p521_scalar_addcarryx_u64(x529, x501, x498);
    let x532: u64 = ((x531 as u64) + x499);
    let mut x533: u64 = 0;
    let mut x534: fiat_p521_scalar_u1 = 0;
    let (x533, x534) = fiat_p521_scalar_addcarryx_u64(0x0, x476, x514);
    let mut x535: u64 = 0;
    let mut x536: fiat_p521_scalar_u1 = 0;
    let (x535, x536) = fiat_p521_scalar_addcarryx_u64(x534, x478, x516);
    let mut x537: u64 = 0;
    let mut x538: fiat_p521_scalar_u1 = 0;
    let (x537, x538) = fiat_p521_scalar_addcarryx_u64(x536, x480, x518);
    let mut x539: u64 = 0;
    let mut x540: fiat_p521_scalar_u1 = 0;
    let (x539, x540) = fiat_p521_scalar_addcarryx_u64(x538, x482, x520);
    let mut x541: u64 = 0;
    let mut x542: fiat_p521_scalar_u1 = 0;
    let (x541, x542) = fiat_p521_scalar_addcarryx_u64(x540, x484, x522);
    let mut x543: u64 = 0;
    let mut x544: fiat_p521_scalar_u1 = 0;
    let (x543, x544) = fiat_p521_scalar_addcarryx_u64(x542, x486, x524);
    let mut x545: u64 = 0;
    let mut x546: fiat_p521_scalar_u1 = 0;
    let (x545, x546) = fiat_p521_scalar_addcarryx_u64(x544, x488, x526);
    let mut x547: u64 = 0;
    let mut x548: fiat_p521_scalar_u1 = 0;
    let (x547, x548) = fiat_p521_scalar_addcarryx_u64(x546, x490, x528);
    let mut x549: u64 = 0;
    let mut x550: fiat_p521_scalar_u1 = 0;
    let (x549, x550) = fiat_p521_scalar_addcarryx_u64(x548, x492, x530);
    let mut x551: u64 = 0;
    let mut x552: fiat_p521_scalar_u1 = 0;
    let (x551, x552) = fiat_p521_scalar_addcarryx_u64(x550, x494, x532);
    let x553: u64 = ((x552 as u64) + (x495 as u64));
    let mut x554: u64 = 0;
    let mut x555: u64 = 0;
    let (x554, x555) = fiat_p521_scalar_mulx_u64(x5, (arg2[8]));
    let mut x556: u64 = 0;
    let mut x557: u64 = 0;
    let (x556, x557) = fiat_p521_scalar_mulx_u64(x5, (arg2[7]));
    let mut x558: u64 = 0;
    let mut x559: u64 = 0;
    let (x558, x559) = fiat_p521_scalar_mulx_u64(x5, (arg2[6]));
    let mut x560: u64 = 0;
    let mut x561: u64 = 0;
    let (x560, x561) = fiat_p521_scalar_mulx_u64(x5, (arg2[5]));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    let (x562, x563) = fiat_p521_scalar_mulx_u64(x5, (arg2[4]));
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    let (x564, x565) = fiat_p521_scalar_mulx_u64(x5, (arg2[3]));
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    let (x566, x567) = fiat_p521_scalar_mulx_u64(x5, (arg2[2]));
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    let (x568, x569) = fiat_p521_scalar_mulx_u64(x5, (arg2[1]));
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    let (x570, x571) = fiat_p521_scalar_mulx_u64(x5, (arg2[0]));
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    let (x572, x573) = fiat_p521_scalar_addcarryx_u64(0x0, x571, x568);
    let mut x574: u64 = 0;
    let mut x575: fiat_p521_scalar_u1 = 0;
    let (x574, x575) = fiat_p521_scalar_addcarryx_u64(x573, x569, x566);
    let mut x576: u64 = 0;
    let mut x577: fiat_p521_scalar_u1 = 0;
    let (x576, x577) = fiat_p521_scalar_addcarryx_u64(x575, x567, x564);
    let mut x578: u64 = 0;
    let mut x579: fiat_p521_scalar_u1 = 0;
    let (x578, x579) = fiat_p521_scalar_addcarryx_u64(x577, x565, x562);
    let mut x580: u64 = 0;
    let mut x581: fiat_p521_scalar_u1 = 0;
    let (x580, x581) = fiat_p521_scalar_addcarryx_u64(x579, x563, x560);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    let (x582, x583) = fiat_p521_scalar_addcarryx_u64(x581, x561, x558);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    let (x584, x585) = fiat_p521_scalar_addcarryx_u64(x583, x559, x556);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    let (x586, x587) = fiat_p521_scalar_addcarryx_u64(x585, x557, x554);
    let x588: u64 = ((x587 as u64) + x555);
    let mut x589: u64 = 0;
    let mut x590: fiat_p521_scalar_u1 = 0;
    let (x589, x590) = fiat_p521_scalar_addcarryx_u64(0x0, x535, x570);
    let mut x591: u64 = 0;
    let mut x592: fiat_p521_scalar_u1 = 0;
    let (x591, x592) = fiat_p521_scalar_addcarryx_u64(x590, x537, x572);
    let mut x593: u64 = 0;
    let mut x594: fiat_p521_scalar_u1 = 0;
    let (x593, x594) = fiat_p521_scalar_addcarryx_u64(x592, x539, x574);
    let mut x595: u64 = 0;
    let mut x596: fiat_p521_scalar_u1 = 0;
    let (x595, x596) = fiat_p521_scalar_addcarryx_u64(x594, x541, x576);
    let mut x597: u64 = 0;
    let mut x598: fiat_p521_scalar_u1 = 0;
    let (x597, x598) = fiat_p521_scalar_addcarryx_u64(x596, x543, x578);
    let mut x599: u64 = 0;
    let mut x600: fiat_p521_scalar_u1 = 0;
    let (x599, x600) = fiat_p521_scalar_addcarryx_u64(x598, x545, x580);
    let mut x601: u64 = 0;
    let mut x602: fiat_p521_scalar_u1 = 0;
    let (x601, x602) = fiat_p521_scalar_addcarryx_u64(x600, x547, x582);
    let mut x603: u64 = 0;
    let mut x604: fiat_p521_scalar_u1 = 0;
    let (x603, x604) = fiat_p521_scalar_addcarryx_u64(x602, x549, x584);
    let mut x605: u64 = 0;
    let mut x606: fiat_p521_scalar_u1 = 0;
    let (x605, x606) = fiat_p521_scalar_addcarryx_u64(x604, x551, x586);
    let mut x607: u64 = 0;
    let mut x608: fiat_p521_scalar_u1 = 0;
    let (x607, x608) = fiat_p521_scalar_addcarryx_u64(x606, x553, x588);
    let mut x609: u64 = 0;
    let mut x610: u64 = 0;
    let (x609, x610) = fiat_p521_scalar_mulx_u64(x589, 0x1d2f5ccd79a995c7);
    let mut x611: u64 = 0;
    let mut x612: u64 = 0;
    let (x611, x612) = fiat_p521_scalar_mulx_u64(x609, 0x1ff);
    let mut x613: u64 = 0;
    let mut x614: u64 = 0;
    let (x613, x614) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x615: u64 = 0;
    let mut x616: u64 = 0;
    let (x615, x616) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x617: u64 = 0;
    let mut x618: u64 = 0;
    let (x617, x618) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x619: u64 = 0;
    let mut x620: u64 = 0;
    let (x619, x620) = fiat_p521_scalar_mulx_u64(x609, 0xfffffffffffffffa);
    let mut x621: u64 = 0;
    let mut x622: u64 = 0;
    let (x621, x622) = fiat_p521_scalar_mulx_u64(x609, 0x51868783bf2f966b);
    let mut x623: u64 = 0;
    let mut x624: u64 = 0;
    let (x623, x624) = fiat_p521_scalar_mulx_u64(x609, 0x7fcc0148f709a5d0);
    let mut x625: u64 = 0;
    let mut x626: u64 = 0;
    let (x625, x626) = fiat_p521_scalar_mulx_u64(x609, 0x3bb5c9b8899c47ae);
    let mut x627: u64 = 0;
    let mut x628: u64 = 0;
    let (x627, x628) = fiat_p521_scalar_mulx_u64(x609, 0xbb6fb71e91386409);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    let (x629, x630) = fiat_p521_scalar_addcarryx_u64(0x0, x628, x625);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    let (x631, x632) = fiat_p521_scalar_addcarryx_u64(x630, x626, x623);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    let (x633, x634) = fiat_p521_scalar_addcarryx_u64(x632, x624, x621);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    let (x635, x636) = fiat_p521_scalar_addcarryx_u64(x634, x622, x619);
    let mut x637: u64 = 0;
    let mut x638: fiat_p521_scalar_u1 = 0;
    let (x637, x638) = fiat_p521_scalar_addcarryx_u64(x636, x620, x617);
    let mut x639: u64 = 0;
    let mut x640: fiat_p521_scalar_u1 = 0;
    let (x639, x640) = fiat_p521_scalar_addcarryx_u64(x638, x618, x615);
    let mut x641: u64 = 0;
    let mut x642: fiat_p521_scalar_u1 = 0;
    let (x641, x642) = fiat_p521_scalar_addcarryx_u64(x640, x616, x613);
    let mut x643: u64 = 0;
    let mut x644: fiat_p521_scalar_u1 = 0;
    let (x643, x644) = fiat_p521_scalar_addcarryx_u64(x642, x614, x611);
    let x645: u64 = ((x644 as u64) + x612);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    let (x646, x647) = fiat_p521_scalar_addcarryx_u64(0x0, x589, x627);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    let (x648, x649) = fiat_p521_scalar_addcarryx_u64(x647, x591, x629);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    let (x650, x651) = fiat_p521_scalar_addcarryx_u64(x649, x593, x631);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    let (x652, x653) = fiat_p521_scalar_addcarryx_u64(x651, x595, x633);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    let (x654, x655) = fiat_p521_scalar_addcarryx_u64(x653, x597, x635);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    let (x656, x657) = fiat_p521_scalar_addcarryx_u64(x655, x599, x637);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    let (x658, x659) = fiat_p521_scalar_addcarryx_u64(x657, x601, x639);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    let (x660, x661) = fiat_p521_scalar_addcarryx_u64(x659, x603, x641);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    let (x662, x663) = fiat_p521_scalar_addcarryx_u64(x661, x605, x643);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    let (x664, x665) = fiat_p521_scalar_addcarryx_u64(x663, x607, x645);
    let x666: u64 = ((x665 as u64) + (x608 as u64));
    let mut x667: u64 = 0;
    let mut x668: u64 = 0;
    let (x667, x668) = fiat_p521_scalar_mulx_u64(x6, (arg2[8]));
    let mut x669: u64 = 0;
    let mut x670: u64 = 0;
    let (x669, x670) = fiat_p521_scalar_mulx_u64(x6, (arg2[7]));
    let mut x671: u64 = 0;
    let mut x672: u64 = 0;
    let (x671, x672) = fiat_p521_scalar_mulx_u64(x6, (arg2[6]));
    let mut x673: u64 = 0;
    let mut x674: u64 = 0;
    let (x673, x674) = fiat_p521_scalar_mulx_u64(x6, (arg2[5]));
    let mut x675: u64 = 0;
    let mut x676: u64 = 0;
    let (x675, x676) = fiat_p521_scalar_mulx_u64(x6, (arg2[4]));
    let mut x677: u64 = 0;
    let mut x678: u64 = 0;
    let (x677, x678) = fiat_p521_scalar_mulx_u64(x6, (arg2[3]));
    let mut x679: u64 = 0;
    let mut x680: u64 = 0;
    let (x679, x680) = fiat_p521_scalar_mulx_u64(x6, (arg2[2]));
    let mut x681: u64 = 0;
    let mut x682: u64 = 0;
    let (x681, x682) = fiat_p521_scalar_mulx_u64(x6, (arg2[1]));
    let mut x683: u64 = 0;
    let mut x684: u64 = 0;
    let (x683, x684) = fiat_p521_scalar_mulx_u64(x6, (arg2[0]));
    let mut x685: u64 = 0;
    let mut x686: fiat_p521_scalar_u1 = 0;
    let (x685, x686) = fiat_p521_scalar_addcarryx_u64(0x0, x684, x681);
    let mut x687: u64 = 0;
    let mut x688: fiat_p521_scalar_u1 = 0;
    let (x687, x688) = fiat_p521_scalar_addcarryx_u64(x686, x682, x679);
    let mut x689: u64 = 0;
    let mut x690: fiat_p521_scalar_u1 = 0;
    let (x689, x690) = fiat_p521_scalar_addcarryx_u64(x688, x680, x677);
    let mut x691: u64 = 0;
    let mut x692: fiat_p521_scalar_u1 = 0;
    let (x691, x692) = fiat_p521_scalar_addcarryx_u64(x690, x678, x675);
    let mut x693: u64 = 0;
    let mut x694: fiat_p521_scalar_u1 = 0;
    let (x693, x694) = fiat_p521_scalar_addcarryx_u64(x692, x676, x673);
    let mut x695: u64 = 0;
    let mut x696: fiat_p521_scalar_u1 = 0;
    let (x695, x696) = fiat_p521_scalar_addcarryx_u64(x694, x674, x671);
    let mut x697: u64 = 0;
    let mut x698: fiat_p521_scalar_u1 = 0;
    let (x697, x698) = fiat_p521_scalar_addcarryx_u64(x696, x672, x669);
    let mut x699: u64 = 0;
    let mut x700: fiat_p521_scalar_u1 = 0;
    let (x699, x700) = fiat_p521_scalar_addcarryx_u64(x698, x670, x667);
    let x701: u64 = ((x700 as u64) + x668);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    let (x702, x703) = fiat_p521_scalar_addcarryx_u64(0x0, x648, x683);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    let (x704, x705) = fiat_p521_scalar_addcarryx_u64(x703, x650, x685);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    let (x706, x707) = fiat_p521_scalar_addcarryx_u64(x705, x652, x687);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    let (x708, x709) = fiat_p521_scalar_addcarryx_u64(x707, x654, x689);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    let (x710, x711) = fiat_p521_scalar_addcarryx_u64(x709, x656, x691);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    let (x712, x713) = fiat_p521_scalar_addcarryx_u64(x711, x658, x693);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    let (x714, x715) = fiat_p521_scalar_addcarryx_u64(x713, x660, x695);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    let (x716, x717) = fiat_p521_scalar_addcarryx_u64(x715, x662, x697);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    let (x718, x719) = fiat_p521_scalar_addcarryx_u64(x717, x664, x699);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    let (x720, x721) = fiat_p521_scalar_addcarryx_u64(x719, x666, x701);
    let mut x722: u64 = 0;
    let mut x723: u64 = 0;
    let (x722, x723) = fiat_p521_scalar_mulx_u64(x702, 0x1d2f5ccd79a995c7);
    let mut x724: u64 = 0;
    let mut x725: u64 = 0;
    let (x724, x725) = fiat_p521_scalar_mulx_u64(x722, 0x1ff);
    let mut x726: u64 = 0;
    let mut x727: u64 = 0;
    let (x726, x727) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x728: u64 = 0;
    let mut x729: u64 = 0;
    let (x728, x729) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x730: u64 = 0;
    let mut x731: u64 = 0;
    let (x730, x731) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x732: u64 = 0;
    let mut x733: u64 = 0;
    let (x732, x733) = fiat_p521_scalar_mulx_u64(x722, 0xfffffffffffffffa);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    let (x734, x735) = fiat_p521_scalar_mulx_u64(x722, 0x51868783bf2f966b);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    let (x736, x737) = fiat_p521_scalar_mulx_u64(x722, 0x7fcc0148f709a5d0);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    let (x738, x739) = fiat_p521_scalar_mulx_u64(x722, 0x3bb5c9b8899c47ae);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    let (x740, x741) = fiat_p521_scalar_mulx_u64(x722, 0xbb6fb71e91386409);
    let mut x742: u64 = 0;
    let mut x743: fiat_p521_scalar_u1 = 0;
    let (x742, x743) = fiat_p521_scalar_addcarryx_u64(0x0, x741, x738);
    let mut x744: u64 = 0;
    let mut x745: fiat_p521_scalar_u1 = 0;
    let (x744, x745) = fiat_p521_scalar_addcarryx_u64(x743, x739, x736);
    let mut x746: u64 = 0;
    let mut x747: fiat_p521_scalar_u1 = 0;
    let (x746, x747) = fiat_p521_scalar_addcarryx_u64(x745, x737, x734);
    let mut x748: u64 = 0;
    let mut x749: fiat_p521_scalar_u1 = 0;
    let (x748, x749) = fiat_p521_scalar_addcarryx_u64(x747, x735, x732);
    let mut x750: u64 = 0;
    let mut x751: fiat_p521_scalar_u1 = 0;
    let (x750, x751) = fiat_p521_scalar_addcarryx_u64(x749, x733, x730);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    let (x752, x753) = fiat_p521_scalar_addcarryx_u64(x751, x731, x728);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    let (x754, x755) = fiat_p521_scalar_addcarryx_u64(x753, x729, x726);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    let (x756, x757) = fiat_p521_scalar_addcarryx_u64(x755, x727, x724);
    let x758: u64 = ((x757 as u64) + x725);
    let mut x759: u64 = 0;
    let mut x760: fiat_p521_scalar_u1 = 0;
    let (x759, x760) = fiat_p521_scalar_addcarryx_u64(0x0, x702, x740);
    let mut x761: u64 = 0;
    let mut x762: fiat_p521_scalar_u1 = 0;
    let (x761, x762) = fiat_p521_scalar_addcarryx_u64(x760, x704, x742);
    let mut x763: u64 = 0;
    let mut x764: fiat_p521_scalar_u1 = 0;
    let (x763, x764) = fiat_p521_scalar_addcarryx_u64(x762, x706, x744);
    let mut x765: u64 = 0;
    let mut x766: fiat_p521_scalar_u1 = 0;
    let (x765, x766) = fiat_p521_scalar_addcarryx_u64(x764, x708, x746);
    let mut x767: u64 = 0;
    let mut x768: fiat_p521_scalar_u1 = 0;
    let (x767, x768) = fiat_p521_scalar_addcarryx_u64(x766, x710, x748);
    let mut x769: u64 = 0;
    let mut x770: fiat_p521_scalar_u1 = 0;
    let (x769, x770) = fiat_p521_scalar_addcarryx_u64(x768, x712, x750);
    let mut x771: u64 = 0;
    let mut x772: fiat_p521_scalar_u1 = 0;
    let (x771, x772) = fiat_p521_scalar_addcarryx_u64(x770, x714, x752);
    let mut x773: u64 = 0;
    let mut x774: fiat_p521_scalar_u1 = 0;
    let (x773, x774) = fiat_p521_scalar_addcarryx_u64(x772, x716, x754);
    let mut x775: u64 = 0;
    let mut x776: fiat_p521_scalar_u1 = 0;
    let (x775, x776) = fiat_p521_scalar_addcarryx_u64(x774, x718, x756);
    let mut x777: u64 = 0;
    let mut x778: fiat_p521_scalar_u1 = 0;
    let (x777, x778) = fiat_p521_scalar_addcarryx_u64(x776, x720, x758);
    let x779: u64 = ((x778 as u64) + (x721 as u64));
    let mut x780: u64 = 0;
    let mut x781: u64 = 0;
    let (x780, x781) = fiat_p521_scalar_mulx_u64(x7, (arg2[8]));
    let mut x782: u64 = 0;
    let mut x783: u64 = 0;
    let (x782, x783) = fiat_p521_scalar_mulx_u64(x7, (arg2[7]));
    let mut x784: u64 = 0;
    let mut x785: u64 = 0;
    let (x784, x785) = fiat_p521_scalar_mulx_u64(x7, (arg2[6]));
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    let (x786, x787) = fiat_p521_scalar_mulx_u64(x7, (arg2[5]));
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    let (x788, x789) = fiat_p521_scalar_mulx_u64(x7, (arg2[4]));
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    let (x790, x791) = fiat_p521_scalar_mulx_u64(x7, (arg2[3]));
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    let (x792, x793) = fiat_p521_scalar_mulx_u64(x7, (arg2[2]));
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    let (x794, x795) = fiat_p521_scalar_mulx_u64(x7, (arg2[1]));
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    let (x796, x797) = fiat_p521_scalar_mulx_u64(x7, (arg2[0]));
    let mut x798: u64 = 0;
    let mut x799: fiat_p521_scalar_u1 = 0;
    let (x798, x799) = fiat_p521_scalar_addcarryx_u64(0x0, x797, x794);
    let mut x800: u64 = 0;
    let mut x801: fiat_p521_scalar_u1 = 0;
    let (x800, x801) = fiat_p521_scalar_addcarryx_u64(x799, x795, x792);
    let mut x802: u64 = 0;
    let mut x803: fiat_p521_scalar_u1 = 0;
    let (x802, x803) = fiat_p521_scalar_addcarryx_u64(x801, x793, x790);
    let mut x804: u64 = 0;
    let mut x805: fiat_p521_scalar_u1 = 0;
    let (x804, x805) = fiat_p521_scalar_addcarryx_u64(x803, x791, x788);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    let (x806, x807) = fiat_p521_scalar_addcarryx_u64(x805, x789, x786);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    let (x808, x809) = fiat_p521_scalar_addcarryx_u64(x807, x787, x784);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    let (x810, x811) = fiat_p521_scalar_addcarryx_u64(x809, x785, x782);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    let (x812, x813) = fiat_p521_scalar_addcarryx_u64(x811, x783, x780);
    let x814: u64 = ((x813 as u64) + x781);
    let mut x815: u64 = 0;
    let mut x816: fiat_p521_scalar_u1 = 0;
    let (x815, x816) = fiat_p521_scalar_addcarryx_u64(0x0, x761, x796);
    let mut x817: u64 = 0;
    let mut x818: fiat_p521_scalar_u1 = 0;
    let (x817, x818) = fiat_p521_scalar_addcarryx_u64(x816, x763, x798);
    let mut x819: u64 = 0;
    let mut x820: fiat_p521_scalar_u1 = 0;
    let (x819, x820) = fiat_p521_scalar_addcarryx_u64(x818, x765, x800);
    let mut x821: u64 = 0;
    let mut x822: fiat_p521_scalar_u1 = 0;
    let (x821, x822) = fiat_p521_scalar_addcarryx_u64(x820, x767, x802);
    let mut x823: u64 = 0;
    let mut x824: fiat_p521_scalar_u1 = 0;
    let (x823, x824) = fiat_p521_scalar_addcarryx_u64(x822, x769, x804);
    let mut x825: u64 = 0;
    let mut x826: fiat_p521_scalar_u1 = 0;
    let (x825, x826) = fiat_p521_scalar_addcarryx_u64(x824, x771, x806);
    let mut x827: u64 = 0;
    let mut x828: fiat_p521_scalar_u1 = 0;
    let (x827, x828) = fiat_p521_scalar_addcarryx_u64(x826, x773, x808);
    let mut x829: u64 = 0;
    let mut x830: fiat_p521_scalar_u1 = 0;
    let (x829, x830) = fiat_p521_scalar_addcarryx_u64(x828, x775, x810);
    let mut x831: u64 = 0;
    let mut x832: fiat_p521_scalar_u1 = 0;
    let (x831, x832) = fiat_p521_scalar_addcarryx_u64(x830, x777, x812);
    let mut x833: u64 = 0;
    let mut x834: fiat_p521_scalar_u1 = 0;
    let (x833, x834) = fiat_p521_scalar_addcarryx_u64(x832, x779, x814);
    let mut x835: u64 = 0;
    let mut x836: u64 = 0;
    let (x835, x836) = fiat_p521_scalar_mulx_u64(x815, 0x1d2f5ccd79a995c7);
    let mut x837: u64 = 0;
    let mut x838: u64 = 0;
    let (x837, x838) = fiat_p521_scalar_mulx_u64(x835, 0x1ff);
    let mut x839: u64 = 0;
    let mut x840: u64 = 0;
    let (x839, x840) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x841: u64 = 0;
    let mut x842: u64 = 0;
    let (x841, x842) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x843: u64 = 0;
    let mut x844: u64 = 0;
    let (x843, x844) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x845: u64 = 0;
    let mut x846: u64 = 0;
    let (x845, x846) = fiat_p521_scalar_mulx_u64(x835, 0xfffffffffffffffa);
    let mut x847: u64 = 0;
    let mut x848: u64 = 0;
    let (x847, x848) = fiat_p521_scalar_mulx_u64(x835, 0x51868783bf2f966b);
    let mut x849: u64 = 0;
    let mut x850: u64 = 0;
    let (x849, x850) = fiat_p521_scalar_mulx_u64(x835, 0x7fcc0148f709a5d0);
    let mut x851: u64 = 0;
    let mut x852: u64 = 0;
    let (x851, x852) = fiat_p521_scalar_mulx_u64(x835, 0x3bb5c9b8899c47ae);
    let mut x853: u64 = 0;
    let mut x854: u64 = 0;
    let (x853, x854) = fiat_p521_scalar_mulx_u64(x835, 0xbb6fb71e91386409);
    let mut x855: u64 = 0;
    let mut x856: fiat_p521_scalar_u1 = 0;
    let (x855, x856) = fiat_p521_scalar_addcarryx_u64(0x0, x854, x851);
    let mut x857: u64 = 0;
    let mut x858: fiat_p521_scalar_u1 = 0;
    let (x857, x858) = fiat_p521_scalar_addcarryx_u64(x856, x852, x849);
    let mut x859: u64 = 0;
    let mut x860: fiat_p521_scalar_u1 = 0;
    let (x859, x860) = fiat_p521_scalar_addcarryx_u64(x858, x850, x847);
    let mut x861: u64 = 0;
    let mut x862: fiat_p521_scalar_u1 = 0;
    let (x861, x862) = fiat_p521_scalar_addcarryx_u64(x860, x848, x845);
    let mut x863: u64 = 0;
    let mut x864: fiat_p521_scalar_u1 = 0;
    let (x863, x864) = fiat_p521_scalar_addcarryx_u64(x862, x846, x843);
    let mut x865: u64 = 0;
    let mut x866: fiat_p521_scalar_u1 = 0;
    let (x865, x866) = fiat_p521_scalar_addcarryx_u64(x864, x844, x841);
    let mut x867: u64 = 0;
    let mut x868: fiat_p521_scalar_u1 = 0;
    let (x867, x868) = fiat_p521_scalar_addcarryx_u64(x866, x842, x839);
    let mut x869: u64 = 0;
    let mut x870: fiat_p521_scalar_u1 = 0;
    let (x869, x870) = fiat_p521_scalar_addcarryx_u64(x868, x840, x837);
    let x871: u64 = ((x870 as u64) + x838);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    let (x872, x873) = fiat_p521_scalar_addcarryx_u64(0x0, x815, x853);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    let (x874, x875) = fiat_p521_scalar_addcarryx_u64(x873, x817, x855);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    let (x876, x877) = fiat_p521_scalar_addcarryx_u64(x875, x819, x857);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    let (x878, x879) = fiat_p521_scalar_addcarryx_u64(x877, x821, x859);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    let (x880, x881) = fiat_p521_scalar_addcarryx_u64(x879, x823, x861);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    let (x882, x883) = fiat_p521_scalar_addcarryx_u64(x881, x825, x863);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    let (x884, x885) = fiat_p521_scalar_addcarryx_u64(x883, x827, x865);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    let (x886, x887) = fiat_p521_scalar_addcarryx_u64(x885, x829, x867);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    let (x888, x889) = fiat_p521_scalar_addcarryx_u64(x887, x831, x869);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    let (x890, x891) = fiat_p521_scalar_addcarryx_u64(x889, x833, x871);
    let x892: u64 = ((x891 as u64) + (x834 as u64));
    let mut x893: u64 = 0;
    let mut x894: u64 = 0;
    let (x893, x894) = fiat_p521_scalar_mulx_u64(x8, (arg2[8]));
    let mut x895: u64 = 0;
    let mut x896: u64 = 0;
    let (x895, x896) = fiat_p521_scalar_mulx_u64(x8, (arg2[7]));
    let mut x897: u64 = 0;
    let mut x898: u64 = 0;
    let (x897, x898) = fiat_p521_scalar_mulx_u64(x8, (arg2[6]));
    let mut x899: u64 = 0;
    let mut x900: u64 = 0;
    let (x899, x900) = fiat_p521_scalar_mulx_u64(x8, (arg2[5]));
    let mut x901: u64 = 0;
    let mut x902: u64 = 0;
    let (x901, x902) = fiat_p521_scalar_mulx_u64(x8, (arg2[4]));
    let mut x903: u64 = 0;
    let mut x904: u64 = 0;
    let (x903, x904) = fiat_p521_scalar_mulx_u64(x8, (arg2[3]));
    let mut x905: u64 = 0;
    let mut x906: u64 = 0;
    let (x905, x906) = fiat_p521_scalar_mulx_u64(x8, (arg2[2]));
    let mut x907: u64 = 0;
    let mut x908: u64 = 0;
    let (x907, x908) = fiat_p521_scalar_mulx_u64(x8, (arg2[1]));
    let mut x909: u64 = 0;
    let mut x910: u64 = 0;
    let (x909, x910) = fiat_p521_scalar_mulx_u64(x8, (arg2[0]));
    let mut x911: u64 = 0;
    let mut x912: fiat_p521_scalar_u1 = 0;
    let (x911, x912) = fiat_p521_scalar_addcarryx_u64(0x0, x910, x907);
    let mut x913: u64 = 0;
    let mut x914: fiat_p521_scalar_u1 = 0;
    let (x913, x914) = fiat_p521_scalar_addcarryx_u64(x912, x908, x905);
    let mut x915: u64 = 0;
    let mut x916: fiat_p521_scalar_u1 = 0;
    let (x915, x916) = fiat_p521_scalar_addcarryx_u64(x914, x906, x903);
    let mut x917: u64 = 0;
    let mut x918: fiat_p521_scalar_u1 = 0;
    let (x917, x918) = fiat_p521_scalar_addcarryx_u64(x916, x904, x901);
    let mut x919: u64 = 0;
    let mut x920: fiat_p521_scalar_u1 = 0;
    let (x919, x920) = fiat_p521_scalar_addcarryx_u64(x918, x902, x899);
    let mut x921: u64 = 0;
    let mut x922: fiat_p521_scalar_u1 = 0;
    let (x921, x922) = fiat_p521_scalar_addcarryx_u64(x920, x900, x897);
    let mut x923: u64 = 0;
    let mut x924: fiat_p521_scalar_u1 = 0;
    let (x923, x924) = fiat_p521_scalar_addcarryx_u64(x922, x898, x895);
    let mut x925: u64 = 0;
    let mut x926: fiat_p521_scalar_u1 = 0;
    let (x925, x926) = fiat_p521_scalar_addcarryx_u64(x924, x896, x893);
    let x927: u64 = ((x926 as u64) + x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    let (x928, x929) = fiat_p521_scalar_addcarryx_u64(0x0, x874, x909);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    let (x930, x931) = fiat_p521_scalar_addcarryx_u64(x929, x876, x911);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    let (x932, x933) = fiat_p521_scalar_addcarryx_u64(x931, x878, x913);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    let (x934, x935) = fiat_p521_scalar_addcarryx_u64(x933, x880, x915);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    let (x936, x937) = fiat_p521_scalar_addcarryx_u64(x935, x882, x917);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    let (x938, x939) = fiat_p521_scalar_addcarryx_u64(x937, x884, x919);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    let (x940, x941) = fiat_p521_scalar_addcarryx_u64(x939, x886, x921);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    let (x942, x943) = fiat_p521_scalar_addcarryx_u64(x941, x888, x923);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    let (x944, x945) = fiat_p521_scalar_addcarryx_u64(x943, x890, x925);
    let mut x946: u64 = 0;
    let mut x947: fiat_p521_scalar_u1 = 0;
    let (x946, x947) = fiat_p521_scalar_addcarryx_u64(x945, x892, x927);
    let mut x948: u64 = 0;
    let mut x949: u64 = 0;
    let (x948, x949) = fiat_p521_scalar_mulx_u64(x928, 0x1d2f5ccd79a995c7);
    let mut x950: u64 = 0;
    let mut x951: u64 = 0;
    let (x950, x951) = fiat_p521_scalar_mulx_u64(x948, 0x1ff);
    let mut x952: u64 = 0;
    let mut x953: u64 = 0;
    let (x952, x953) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x954: u64 = 0;
    let mut x955: u64 = 0;
    let (x954, x955) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x956: u64 = 0;
    let mut x957: u64 = 0;
    let (x956, x957) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x958: u64 = 0;
    let mut x959: u64 = 0;
    let (x958, x959) = fiat_p521_scalar_mulx_u64(x948, 0xfffffffffffffffa);
    let mut x960: u64 = 0;
    let mut x961: u64 = 0;
    let (x960, x961) = fiat_p521_scalar_mulx_u64(x948, 0x51868783bf2f966b);
    let mut x962: u64 = 0;
    let mut x963: u64 = 0;
    let (x962, x963) = fiat_p521_scalar_mulx_u64(x948, 0x7fcc0148f709a5d0);
    let mut x964: u64 = 0;
    let mut x965: u64 = 0;
    let (x964, x965) = fiat_p521_scalar_mulx_u64(x948, 0x3bb5c9b8899c47ae);
    let mut x966: u64 = 0;
    let mut x967: u64 = 0;
    let (x966, x967) = fiat_p521_scalar_mulx_u64(x948, 0xbb6fb71e91386409);
    let mut x968: u64 = 0;
    let mut x969: fiat_p521_scalar_u1 = 0;
    let (x968, x969) = fiat_p521_scalar_addcarryx_u64(0x0, x967, x964);
    let mut x970: u64 = 0;
    let mut x971: fiat_p521_scalar_u1 = 0;
    let (x970, x971) = fiat_p521_scalar_addcarryx_u64(x969, x965, x962);
    let mut x972: u64 = 0;
    let mut x973: fiat_p521_scalar_u1 = 0;
    let (x972, x973) = fiat_p521_scalar_addcarryx_u64(x971, x963, x960);
    let mut x974: u64 = 0;
    let mut x975: fiat_p521_scalar_u1 = 0;
    let (x974, x975) = fiat_p521_scalar_addcarryx_u64(x973, x961, x958);
    let mut x976: u64 = 0;
    let mut x977: fiat_p521_scalar_u1 = 0;
    let (x976, x977) = fiat_p521_scalar_addcarryx_u64(x975, x959, x956);
    let mut x978: u64 = 0;
    let mut x979: fiat_p521_scalar_u1 = 0;
    let (x978, x979) = fiat_p521_scalar_addcarryx_u64(x977, x957, x954);
    let mut x980: u64 = 0;
    let mut x981: fiat_p521_scalar_u1 = 0;
    let (x980, x981) = fiat_p521_scalar_addcarryx_u64(x979, x955, x952);
    let mut x982: u64 = 0;
    let mut x983: fiat_p521_scalar_u1 = 0;
    let (x982, x983) = fiat_p521_scalar_addcarryx_u64(x981, x953, x950);
    let x984: u64 = ((x983 as u64) + x951);
    let mut x985: u64 = 0;
    let mut x986: fiat_p521_scalar_u1 = 0;
    let (x985, x986) = fiat_p521_scalar_addcarryx_u64(0x0, x928, x966);
    let mut x987: u64 = 0;
    let mut x988: fiat_p521_scalar_u1 = 0;
    let (x987, x988) = fiat_p521_scalar_addcarryx_u64(x986, x930, x968);
    let mut x989: u64 = 0;
    let mut x990: fiat_p521_scalar_u1 = 0;
    let (x989, x990) = fiat_p521_scalar_addcarryx_u64(x988, x932, x970);
    let mut x991: u64 = 0;
    let mut x992: fiat_p521_scalar_u1 = 0;
    let (x991, x992) = fiat_p521_scalar_addcarryx_u64(x990, x934, x972);
    let mut x993: u64 = 0;
    let mut x994: fiat_p521_scalar_u1 = 0;
    let (x993, x994) = fiat_p521_scalar_addcarryx_u64(x992, x936, x974);
    let mut x995: u64 = 0;
    let mut x996: fiat_p521_scalar_u1 = 0;
    let (x995, x996) = fiat_p521_scalar_addcarryx_u64(x994, x938, x976);
    let mut x997: u64 = 0;
    let mut x998: fiat_p521_scalar_u1 = 0;
    let (x997, x998) = fiat_p521_scalar_addcarryx_u64(x996, x940, x978);
    let mut x999: u64 = 0;
    let mut x1000: fiat_p521_scalar_u1 = 0;
    let (x999, x1000) = fiat_p521_scalar_addcarryx_u64(x998, x942, x980);
    let mut x1001: u64 = 0;
    let mut x1002: fiat_p521_scalar_u1 = 0;
    let (x1001, x1002) = fiat_p521_scalar_addcarryx_u64(x1000, x944, x982);
    let mut x1003: u64 = 0;
    let mut x1004: fiat_p521_scalar_u1 = 0;
    let (x1003, x1004) = fiat_p521_scalar_addcarryx_u64(x1002, x946, x984);
    let x1005: u64 = ((x1004 as u64) + (x947 as u64));
    let mut x1006: u64 = 0;
    let mut x1007: fiat_p521_scalar_u1 = 0;
    let (x1006, x1007) = fiat_p521_scalar_subborrowx_u64(0x0, x987, 0xbb6fb71e91386409);
    let mut x1008: u64 = 0;
    let mut x1009: fiat_p521_scalar_u1 = 0;
    let (x1008, x1009) = fiat_p521_scalar_subborrowx_u64(x1007, x989, 0x3bb5c9b8899c47ae);
    let mut x1010: u64 = 0;
    let mut x1011: fiat_p521_scalar_u1 = 0;
    let (x1010, x1011) = fiat_p521_scalar_subborrowx_u64(x1009, x991, 0x7fcc0148f709a5d0);
    let mut x1012: u64 = 0;
    let mut x1013: fiat_p521_scalar_u1 = 0;
    let (x1012, x1013) = fiat_p521_scalar_subborrowx_u64(x1011, x993, 0x51868783bf2f966b);
    let mut x1014: u64 = 0;
    let mut x1015: fiat_p521_scalar_u1 = 0;
    let (x1014, x1015) = fiat_p521_scalar_subborrowx_u64(x1013, x995, 0xfffffffffffffffa);
    let mut x1016: u64 = 0;
    let mut x1017: fiat_p521_scalar_u1 = 0;
    let (x1016, x1017) = fiat_p521_scalar_subborrowx_u64(x1015, x997, 0xffffffffffffffff);
    let mut x1018: u64 = 0;
    let mut x1019: fiat_p521_scalar_u1 = 0;
    let (x1018, x1019) = fiat_p521_scalar_subborrowx_u64(x1017, x999, 0xffffffffffffffff);
    let mut x1020: u64 = 0;
    let mut x1021: fiat_p521_scalar_u1 = 0;
    let (x1020, x1021) = fiat_p521_scalar_subborrowx_u64(x1019, x1001, 0xffffffffffffffff);
    let mut x1022: u64 = 0;
    let mut x1023: fiat_p521_scalar_u1 = 0;
    let (x1022, x1023) = fiat_p521_scalar_subborrowx_u64(x1021, x1003, 0x1ff);
    let mut x1024: u64 = 0;
    let mut x1025: fiat_p521_scalar_u1 = 0;
    let (x1024, x1025) = fiat_p521_scalar_subborrowx_u64(x1023, x1005, (0x0 as u64));
    let mut x1026: u64 = 0;
    let (x1026) = fiat_p521_scalar_cmovznz_u64(x1025, x1006, x987);
    let mut x1027: u64 = 0;
    let (x1027) = fiat_p521_scalar_cmovznz_u64(x1025, x1008, x989);
    let mut x1028: u64 = 0;
    let (x1028) = fiat_p521_scalar_cmovznz_u64(x1025, x1010, x991);
    let mut x1029: u64 = 0;
    let (x1029) = fiat_p521_scalar_cmovznz_u64(x1025, x1012, x993);
    let mut x1030: u64 = 0;
    let (x1030) = fiat_p521_scalar_cmovznz_u64(x1025, x1014, x995);
    let mut x1031: u64 = 0;
    let (x1031) = fiat_p521_scalar_cmovznz_u64(x1025, x1016, x997);
    let mut x1032: u64 = 0;
    let (x1032) = fiat_p521_scalar_cmovznz_u64(x1025, x1018, x999);
    let mut x1033: u64 = 0;
    let (x1033) = fiat_p521_scalar_cmovznz_u64(x1025, x1020, x1001);
    let mut x1034: u64 = 0;
    let (x1034) = fiat_p521_scalar_cmovznz_u64(x1025, x1022, x1003);
    out1[0] = x1026;
    out1[1] = x1027;
    out1[2] = x1028;
    out1[3] = x1029;
    out1[4] = x1030;
    out1[5] = x1031;
    out1[6] = x1032;
    out1[7] = x1033;
    out1[8] = x1034;
    out1
}
#[doc = " The function fiat_p521_scalar_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_square(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[6]);
    let x7: u64 = (arg1[7]);
    let x8: u64 = (arg1[8]);
    let x9: u64 = (arg1[0]);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p521_scalar_mulx_u64(x9, (arg1[8]));
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    let (x12, x13) = fiat_p521_scalar_mulx_u64(x9, (arg1[7]));
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    let (x14, x15) = fiat_p521_scalar_mulx_u64(x9, (arg1[6]));
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    let (x16, x17) = fiat_p521_scalar_mulx_u64(x9, (arg1[5]));
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    let (x18, x19) = fiat_p521_scalar_mulx_u64(x9, (arg1[4]));
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p521_scalar_mulx_u64(x9, (arg1[3]));
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    let (x22, x23) = fiat_p521_scalar_mulx_u64(x9, (arg1[2]));
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    let (x24, x25) = fiat_p521_scalar_mulx_u64(x9, (arg1[1]));
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    let (x26, x27) = fiat_p521_scalar_mulx_u64(x9, (arg1[0]));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    let (x38, x39) = fiat_p521_scalar_addcarryx_u64(x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    let (x40, x41) = fiat_p521_scalar_addcarryx_u64(x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    let (x42, x43) = fiat_p521_scalar_addcarryx_u64(x41, x13, x10);
    let x44: u64 = ((x43 as u64) + x11);
    let mut x45: u64 = 0;
    let mut x46: u64 = 0;
    let (x45, x46) = fiat_p521_scalar_mulx_u64(x26, 0x1d2f5ccd79a995c7);
    let mut x47: u64 = 0;
    let mut x48: u64 = 0;
    let (x47, x48) = fiat_p521_scalar_mulx_u64(x45, 0x1ff);
    let mut x49: u64 = 0;
    let mut x50: u64 = 0;
    let (x49, x50) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x51: u64 = 0;
    let mut x52: u64 = 0;
    let (x51, x52) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x53: u64 = 0;
    let mut x54: u64 = 0;
    let (x53, x54) = fiat_p521_scalar_mulx_u64(x45, 0xffffffffffffffff);
    let mut x55: u64 = 0;
    let mut x56: u64 = 0;
    let (x55, x56) = fiat_p521_scalar_mulx_u64(x45, 0xfffffffffffffffa);
    let mut x57: u64 = 0;
    let mut x58: u64 = 0;
    let (x57, x58) = fiat_p521_scalar_mulx_u64(x45, 0x51868783bf2f966b);
    let mut x59: u64 = 0;
    let mut x60: u64 = 0;
    let (x59, x60) = fiat_p521_scalar_mulx_u64(x45, 0x7fcc0148f709a5d0);
    let mut x61: u64 = 0;
    let mut x62: u64 = 0;
    let (x61, x62) = fiat_p521_scalar_mulx_u64(x45, 0x3bb5c9b8899c47ae);
    let mut x63: u64 = 0;
    let mut x64: u64 = 0;
    let (x63, x64) = fiat_p521_scalar_mulx_u64(x45, 0xbb6fb71e91386409);
    let mut x65: u64 = 0;
    let mut x66: fiat_p521_scalar_u1 = 0;
    let (x65, x66) = fiat_p521_scalar_addcarryx_u64(0x0, x64, x61);
    let mut x67: u64 = 0;
    let mut x68: fiat_p521_scalar_u1 = 0;
    let (x67, x68) = fiat_p521_scalar_addcarryx_u64(x66, x62, x59);
    let mut x69: u64 = 0;
    let mut x70: fiat_p521_scalar_u1 = 0;
    let (x69, x70) = fiat_p521_scalar_addcarryx_u64(x68, x60, x57);
    let mut x71: u64 = 0;
    let mut x72: fiat_p521_scalar_u1 = 0;
    let (x71, x72) = fiat_p521_scalar_addcarryx_u64(x70, x58, x55);
    let mut x73: u64 = 0;
    let mut x74: fiat_p521_scalar_u1 = 0;
    let (x73, x74) = fiat_p521_scalar_addcarryx_u64(x72, x56, x53);
    let mut x75: u64 = 0;
    let mut x76: fiat_p521_scalar_u1 = 0;
    let (x75, x76) = fiat_p521_scalar_addcarryx_u64(x74, x54, x51);
    let mut x77: u64 = 0;
    let mut x78: fiat_p521_scalar_u1 = 0;
    let (x77, x78) = fiat_p521_scalar_addcarryx_u64(x76, x52, x49);
    let mut x79: u64 = 0;
    let mut x80: fiat_p521_scalar_u1 = 0;
    let (x79, x80) = fiat_p521_scalar_addcarryx_u64(x78, x50, x47);
    let x81: u64 = ((x80 as u64) + x48);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    let (x82, x83) = fiat_p521_scalar_addcarryx_u64(0x0, x26, x63);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    let (x84, x85) = fiat_p521_scalar_addcarryx_u64(x83, x28, x65);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    let (x86, x87) = fiat_p521_scalar_addcarryx_u64(x85, x30, x67);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    let (x88, x89) = fiat_p521_scalar_addcarryx_u64(x87, x32, x69);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    let (x90, x91) = fiat_p521_scalar_addcarryx_u64(x89, x34, x71);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    let (x92, x93) = fiat_p521_scalar_addcarryx_u64(x91, x36, x73);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    let (x94, x95) = fiat_p521_scalar_addcarryx_u64(x93, x38, x75);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    let (x96, x97) = fiat_p521_scalar_addcarryx_u64(x95, x40, x77);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    let (x98, x99) = fiat_p521_scalar_addcarryx_u64(x97, x42, x79);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    let (x100, x101) = fiat_p521_scalar_addcarryx_u64(x99, x44, x81);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p521_scalar_mulx_u64(x1, (arg1[8]));
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p521_scalar_mulx_u64(x1, (arg1[7]));
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p521_scalar_mulx_u64(x1, (arg1[6]));
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p521_scalar_mulx_u64(x1, (arg1[5]));
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p521_scalar_mulx_u64(x1, (arg1[4]));
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p521_scalar_mulx_u64(x1, (arg1[3]));
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p521_scalar_mulx_u64(x1, (arg1[2]));
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    let (x116, x117) = fiat_p521_scalar_mulx_u64(x1, (arg1[1]));
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    let (x118, x119) = fiat_p521_scalar_mulx_u64(x1, (arg1[0]));
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    let (x120, x121) = fiat_p521_scalar_addcarryx_u64(0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    let (x122, x123) = fiat_p521_scalar_addcarryx_u64(x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    let (x124, x125) = fiat_p521_scalar_addcarryx_u64(x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    let (x126, x127) = fiat_p521_scalar_addcarryx_u64(x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    let (x128, x129) = fiat_p521_scalar_addcarryx_u64(x127, x111, x108);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    let (x130, x131) = fiat_p521_scalar_addcarryx_u64(x129, x109, x106);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    let (x132, x133) = fiat_p521_scalar_addcarryx_u64(x131, x107, x104);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    let (x134, x135) = fiat_p521_scalar_addcarryx_u64(x133, x105, x102);
    let x136: u64 = ((x135 as u64) + x103);
    let mut x137: u64 = 0;
    let mut x138: fiat_p521_scalar_u1 = 0;
    let (x137, x138) = fiat_p521_scalar_addcarryx_u64(0x0, x84, x118);
    let mut x139: u64 = 0;
    let mut x140: fiat_p521_scalar_u1 = 0;
    let (x139, x140) = fiat_p521_scalar_addcarryx_u64(x138, x86, x120);
    let mut x141: u64 = 0;
    let mut x142: fiat_p521_scalar_u1 = 0;
    let (x141, x142) = fiat_p521_scalar_addcarryx_u64(x140, x88, x122);
    let mut x143: u64 = 0;
    let mut x144: fiat_p521_scalar_u1 = 0;
    let (x143, x144) = fiat_p521_scalar_addcarryx_u64(x142, x90, x124);
    let mut x145: u64 = 0;
    let mut x146: fiat_p521_scalar_u1 = 0;
    let (x145, x146) = fiat_p521_scalar_addcarryx_u64(x144, x92, x126);
    let mut x147: u64 = 0;
    let mut x148: fiat_p521_scalar_u1 = 0;
    let (x147, x148) = fiat_p521_scalar_addcarryx_u64(x146, x94, x128);
    let mut x149: u64 = 0;
    let mut x150: fiat_p521_scalar_u1 = 0;
    let (x149, x150) = fiat_p521_scalar_addcarryx_u64(x148, x96, x130);
    let mut x151: u64 = 0;
    let mut x152: fiat_p521_scalar_u1 = 0;
    let (x151, x152) = fiat_p521_scalar_addcarryx_u64(x150, x98, x132);
    let mut x153: u64 = 0;
    let mut x154: fiat_p521_scalar_u1 = 0;
    let (x153, x154) = fiat_p521_scalar_addcarryx_u64(x152, x100, x134);
    let mut x155: u64 = 0;
    let mut x156: fiat_p521_scalar_u1 = 0;
    let (x155, x156) = fiat_p521_scalar_addcarryx_u64(x154, (x101 as u64), x136);
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p521_scalar_mulx_u64(x137, 0x1d2f5ccd79a995c7);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p521_scalar_mulx_u64(x157, 0x1ff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    let (x161, x162) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    let (x163, x164) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    let (x165, x166) = fiat_p521_scalar_mulx_u64(x157, 0xffffffffffffffff);
    let mut x167: u64 = 0;
    let mut x168: u64 = 0;
    let (x167, x168) = fiat_p521_scalar_mulx_u64(x157, 0xfffffffffffffffa);
    let mut x169: u64 = 0;
    let mut x170: u64 = 0;
    let (x169, x170) = fiat_p521_scalar_mulx_u64(x157, 0x51868783bf2f966b);
    let mut x171: u64 = 0;
    let mut x172: u64 = 0;
    let (x171, x172) = fiat_p521_scalar_mulx_u64(x157, 0x7fcc0148f709a5d0);
    let mut x173: u64 = 0;
    let mut x174: u64 = 0;
    let (x173, x174) = fiat_p521_scalar_mulx_u64(x157, 0x3bb5c9b8899c47ae);
    let mut x175: u64 = 0;
    let mut x176: u64 = 0;
    let (x175, x176) = fiat_p521_scalar_mulx_u64(x157, 0xbb6fb71e91386409);
    let mut x177: u64 = 0;
    let mut x178: fiat_p521_scalar_u1 = 0;
    let (x177, x178) = fiat_p521_scalar_addcarryx_u64(0x0, x176, x173);
    let mut x179: u64 = 0;
    let mut x180: fiat_p521_scalar_u1 = 0;
    let (x179, x180) = fiat_p521_scalar_addcarryx_u64(x178, x174, x171);
    let mut x181: u64 = 0;
    let mut x182: fiat_p521_scalar_u1 = 0;
    let (x181, x182) = fiat_p521_scalar_addcarryx_u64(x180, x172, x169);
    let mut x183: u64 = 0;
    let mut x184: fiat_p521_scalar_u1 = 0;
    let (x183, x184) = fiat_p521_scalar_addcarryx_u64(x182, x170, x167);
    let mut x185: u64 = 0;
    let mut x186: fiat_p521_scalar_u1 = 0;
    let (x185, x186) = fiat_p521_scalar_addcarryx_u64(x184, x168, x165);
    let mut x187: u64 = 0;
    let mut x188: fiat_p521_scalar_u1 = 0;
    let (x187, x188) = fiat_p521_scalar_addcarryx_u64(x186, x166, x163);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    let (x189, x190) = fiat_p521_scalar_addcarryx_u64(x188, x164, x161);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    let (x191, x192) = fiat_p521_scalar_addcarryx_u64(x190, x162, x159);
    let x193: u64 = ((x192 as u64) + x160);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    let (x194, x195) = fiat_p521_scalar_addcarryx_u64(0x0, x137, x175);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    let (x196, x197) = fiat_p521_scalar_addcarryx_u64(x195, x139, x177);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    let (x198, x199) = fiat_p521_scalar_addcarryx_u64(x197, x141, x179);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    let (x200, x201) = fiat_p521_scalar_addcarryx_u64(x199, x143, x181);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    let (x202, x203) = fiat_p521_scalar_addcarryx_u64(x201, x145, x183);
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    let (x204, x205) = fiat_p521_scalar_addcarryx_u64(x203, x147, x185);
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    let (x206, x207) = fiat_p521_scalar_addcarryx_u64(x205, x149, x187);
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    let (x208, x209) = fiat_p521_scalar_addcarryx_u64(x207, x151, x189);
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    let (x210, x211) = fiat_p521_scalar_addcarryx_u64(x209, x153, x191);
    let mut x212: u64 = 0;
    let mut x213: fiat_p521_scalar_u1 = 0;
    let (x212, x213) = fiat_p521_scalar_addcarryx_u64(x211, x155, x193);
    let x214: u64 = ((x213 as u64) + (x156 as u64));
    let mut x215: u64 = 0;
    let mut x216: u64 = 0;
    let (x215, x216) = fiat_p521_scalar_mulx_u64(x2, (arg1[8]));
    let mut x217: u64 = 0;
    let mut x218: u64 = 0;
    let (x217, x218) = fiat_p521_scalar_mulx_u64(x2, (arg1[7]));
    let mut x219: u64 = 0;
    let mut x220: u64 = 0;
    let (x219, x220) = fiat_p521_scalar_mulx_u64(x2, (arg1[6]));
    let mut x221: u64 = 0;
    let mut x222: u64 = 0;
    let (x221, x222) = fiat_p521_scalar_mulx_u64(x2, (arg1[5]));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    let (x223, x224) = fiat_p521_scalar_mulx_u64(x2, (arg1[4]));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    let (x225, x226) = fiat_p521_scalar_mulx_u64(x2, (arg1[3]));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    let (x227, x228) = fiat_p521_scalar_mulx_u64(x2, (arg1[2]));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    let (x229, x230) = fiat_p521_scalar_mulx_u64(x2, (arg1[1]));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    let (x231, x232) = fiat_p521_scalar_mulx_u64(x2, (arg1[0]));
    let mut x233: u64 = 0;
    let mut x234: fiat_p521_scalar_u1 = 0;
    let (x233, x234) = fiat_p521_scalar_addcarryx_u64(0x0, x232, x229);
    let mut x235: u64 = 0;
    let mut x236: fiat_p521_scalar_u1 = 0;
    let (x235, x236) = fiat_p521_scalar_addcarryx_u64(x234, x230, x227);
    let mut x237: u64 = 0;
    let mut x238: fiat_p521_scalar_u1 = 0;
    let (x237, x238) = fiat_p521_scalar_addcarryx_u64(x236, x228, x225);
    let mut x239: u64 = 0;
    let mut x240: fiat_p521_scalar_u1 = 0;
    let (x239, x240) = fiat_p521_scalar_addcarryx_u64(x238, x226, x223);
    let mut x241: u64 = 0;
    let mut x242: fiat_p521_scalar_u1 = 0;
    let (x241, x242) = fiat_p521_scalar_addcarryx_u64(x240, x224, x221);
    let mut x243: u64 = 0;
    let mut x244: fiat_p521_scalar_u1 = 0;
    let (x243, x244) = fiat_p521_scalar_addcarryx_u64(x242, x222, x219);
    let mut x245: u64 = 0;
    let mut x246: fiat_p521_scalar_u1 = 0;
    let (x245, x246) = fiat_p521_scalar_addcarryx_u64(x244, x220, x217);
    let mut x247: u64 = 0;
    let mut x248: fiat_p521_scalar_u1 = 0;
    let (x247, x248) = fiat_p521_scalar_addcarryx_u64(x246, x218, x215);
    let x249: u64 = ((x248 as u64) + x216);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    let (x250, x251) = fiat_p521_scalar_addcarryx_u64(0x0, x196, x231);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    let (x252, x253) = fiat_p521_scalar_addcarryx_u64(x251, x198, x233);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    let (x254, x255) = fiat_p521_scalar_addcarryx_u64(x253, x200, x235);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    let (x256, x257) = fiat_p521_scalar_addcarryx_u64(x255, x202, x237);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    let (x258, x259) = fiat_p521_scalar_addcarryx_u64(x257, x204, x239);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    let (x260, x261) = fiat_p521_scalar_addcarryx_u64(x259, x206, x241);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    let (x262, x263) = fiat_p521_scalar_addcarryx_u64(x261, x208, x243);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    let (x264, x265) = fiat_p521_scalar_addcarryx_u64(x263, x210, x245);
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    let (x266, x267) = fiat_p521_scalar_addcarryx_u64(x265, x212, x247);
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    let (x268, x269) = fiat_p521_scalar_addcarryx_u64(x267, x214, x249);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    let (x270, x271) = fiat_p521_scalar_mulx_u64(x250, 0x1d2f5ccd79a995c7);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    let (x272, x273) = fiat_p521_scalar_mulx_u64(x270, 0x1ff);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    let (x274, x275) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x276: u64 = 0;
    let mut x277: u64 = 0;
    let (x276, x277) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x278: u64 = 0;
    let mut x279: u64 = 0;
    let (x278, x279) = fiat_p521_scalar_mulx_u64(x270, 0xffffffffffffffff);
    let mut x280: u64 = 0;
    let mut x281: u64 = 0;
    let (x280, x281) = fiat_p521_scalar_mulx_u64(x270, 0xfffffffffffffffa);
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    let (x282, x283) = fiat_p521_scalar_mulx_u64(x270, 0x51868783bf2f966b);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    let (x284, x285) = fiat_p521_scalar_mulx_u64(x270, 0x7fcc0148f709a5d0);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    let (x286, x287) = fiat_p521_scalar_mulx_u64(x270, 0x3bb5c9b8899c47ae);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    let (x288, x289) = fiat_p521_scalar_mulx_u64(x270, 0xbb6fb71e91386409);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    let (x290, x291) = fiat_p521_scalar_addcarryx_u64(0x0, x289, x286);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    let (x292, x293) = fiat_p521_scalar_addcarryx_u64(x291, x287, x284);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    let (x294, x295) = fiat_p521_scalar_addcarryx_u64(x293, x285, x282);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    let (x296, x297) = fiat_p521_scalar_addcarryx_u64(x295, x283, x280);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    let (x298, x299) = fiat_p521_scalar_addcarryx_u64(x297, x281, x278);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    let (x300, x301) = fiat_p521_scalar_addcarryx_u64(x299, x279, x276);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    let (x302, x303) = fiat_p521_scalar_addcarryx_u64(x301, x277, x274);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    let (x304, x305) = fiat_p521_scalar_addcarryx_u64(x303, x275, x272);
    let x306: u64 = ((x305 as u64) + x273);
    let mut x307: u64 = 0;
    let mut x308: fiat_p521_scalar_u1 = 0;
    let (x307, x308) = fiat_p521_scalar_addcarryx_u64(0x0, x250, x288);
    let mut x309: u64 = 0;
    let mut x310: fiat_p521_scalar_u1 = 0;
    let (x309, x310) = fiat_p521_scalar_addcarryx_u64(x308, x252, x290);
    let mut x311: u64 = 0;
    let mut x312: fiat_p521_scalar_u1 = 0;
    let (x311, x312) = fiat_p521_scalar_addcarryx_u64(x310, x254, x292);
    let mut x313: u64 = 0;
    let mut x314: fiat_p521_scalar_u1 = 0;
    let (x313, x314) = fiat_p521_scalar_addcarryx_u64(x312, x256, x294);
    let mut x315: u64 = 0;
    let mut x316: fiat_p521_scalar_u1 = 0;
    let (x315, x316) = fiat_p521_scalar_addcarryx_u64(x314, x258, x296);
    let mut x317: u64 = 0;
    let mut x318: fiat_p521_scalar_u1 = 0;
    let (x317, x318) = fiat_p521_scalar_addcarryx_u64(x316, x260, x298);
    let mut x319: u64 = 0;
    let mut x320: fiat_p521_scalar_u1 = 0;
    let (x319, x320) = fiat_p521_scalar_addcarryx_u64(x318, x262, x300);
    let mut x321: u64 = 0;
    let mut x322: fiat_p521_scalar_u1 = 0;
    let (x321, x322) = fiat_p521_scalar_addcarryx_u64(x320, x264, x302);
    let mut x323: u64 = 0;
    let mut x324: fiat_p521_scalar_u1 = 0;
    let (x323, x324) = fiat_p521_scalar_addcarryx_u64(x322, x266, x304);
    let mut x325: u64 = 0;
    let mut x326: fiat_p521_scalar_u1 = 0;
    let (x325, x326) = fiat_p521_scalar_addcarryx_u64(x324, x268, x306);
    let x327: u64 = ((x326 as u64) + (x269 as u64));
    let mut x328: u64 = 0;
    let mut x329: u64 = 0;
    let (x328, x329) = fiat_p521_scalar_mulx_u64(x3, (arg1[8]));
    let mut x330: u64 = 0;
    let mut x331: u64 = 0;
    let (x330, x331) = fiat_p521_scalar_mulx_u64(x3, (arg1[7]));
    let mut x332: u64 = 0;
    let mut x333: u64 = 0;
    let (x332, x333) = fiat_p521_scalar_mulx_u64(x3, (arg1[6]));
    let mut x334: u64 = 0;
    let mut x335: u64 = 0;
    let (x334, x335) = fiat_p521_scalar_mulx_u64(x3, (arg1[5]));
    let mut x336: u64 = 0;
    let mut x337: u64 = 0;
    let (x336, x337) = fiat_p521_scalar_mulx_u64(x3, (arg1[4]));
    let mut x338: u64 = 0;
    let mut x339: u64 = 0;
    let (x338, x339) = fiat_p521_scalar_mulx_u64(x3, (arg1[3]));
    let mut x340: u64 = 0;
    let mut x341: u64 = 0;
    let (x340, x341) = fiat_p521_scalar_mulx_u64(x3, (arg1[2]));
    let mut x342: u64 = 0;
    let mut x343: u64 = 0;
    let (x342, x343) = fiat_p521_scalar_mulx_u64(x3, (arg1[1]));
    let mut x344: u64 = 0;
    let mut x345: u64 = 0;
    let (x344, x345) = fiat_p521_scalar_mulx_u64(x3, (arg1[0]));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    let (x346, x347) = fiat_p521_scalar_addcarryx_u64(0x0, x345, x342);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    let (x348, x349) = fiat_p521_scalar_addcarryx_u64(x347, x343, x340);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    let (x350, x351) = fiat_p521_scalar_addcarryx_u64(x349, x341, x338);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    let (x352, x353) = fiat_p521_scalar_addcarryx_u64(x351, x339, x336);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    let (x354, x355) = fiat_p521_scalar_addcarryx_u64(x353, x337, x334);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    let (x356, x357) = fiat_p521_scalar_addcarryx_u64(x355, x335, x332);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    let (x358, x359) = fiat_p521_scalar_addcarryx_u64(x357, x333, x330);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    let (x360, x361) = fiat_p521_scalar_addcarryx_u64(x359, x331, x328);
    let x362: u64 = ((x361 as u64) + x329);
    let mut x363: u64 = 0;
    let mut x364: fiat_p521_scalar_u1 = 0;
    let (x363, x364) = fiat_p521_scalar_addcarryx_u64(0x0, x309, x344);
    let mut x365: u64 = 0;
    let mut x366: fiat_p521_scalar_u1 = 0;
    let (x365, x366) = fiat_p521_scalar_addcarryx_u64(x364, x311, x346);
    let mut x367: u64 = 0;
    let mut x368: fiat_p521_scalar_u1 = 0;
    let (x367, x368) = fiat_p521_scalar_addcarryx_u64(x366, x313, x348);
    let mut x369: u64 = 0;
    let mut x370: fiat_p521_scalar_u1 = 0;
    let (x369, x370) = fiat_p521_scalar_addcarryx_u64(x368, x315, x350);
    let mut x371: u64 = 0;
    let mut x372: fiat_p521_scalar_u1 = 0;
    let (x371, x372) = fiat_p521_scalar_addcarryx_u64(x370, x317, x352);
    let mut x373: u64 = 0;
    let mut x374: fiat_p521_scalar_u1 = 0;
    let (x373, x374) = fiat_p521_scalar_addcarryx_u64(x372, x319, x354);
    let mut x375: u64 = 0;
    let mut x376: fiat_p521_scalar_u1 = 0;
    let (x375, x376) = fiat_p521_scalar_addcarryx_u64(x374, x321, x356);
    let mut x377: u64 = 0;
    let mut x378: fiat_p521_scalar_u1 = 0;
    let (x377, x378) = fiat_p521_scalar_addcarryx_u64(x376, x323, x358);
    let mut x379: u64 = 0;
    let mut x380: fiat_p521_scalar_u1 = 0;
    let (x379, x380) = fiat_p521_scalar_addcarryx_u64(x378, x325, x360);
    let mut x381: u64 = 0;
    let mut x382: fiat_p521_scalar_u1 = 0;
    let (x381, x382) = fiat_p521_scalar_addcarryx_u64(x380, x327, x362);
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    let (x383, x384) = fiat_p521_scalar_mulx_u64(x363, 0x1d2f5ccd79a995c7);
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    let (x385, x386) = fiat_p521_scalar_mulx_u64(x383, 0x1ff);
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    let (x387, x388) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x389: u64 = 0;
    let mut x390: u64 = 0;
    let (x389, x390) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x391: u64 = 0;
    let mut x392: u64 = 0;
    let (x391, x392) = fiat_p521_scalar_mulx_u64(x383, 0xffffffffffffffff);
    let mut x393: u64 = 0;
    let mut x394: u64 = 0;
    let (x393, x394) = fiat_p521_scalar_mulx_u64(x383, 0xfffffffffffffffa);
    let mut x395: u64 = 0;
    let mut x396: u64 = 0;
    let (x395, x396) = fiat_p521_scalar_mulx_u64(x383, 0x51868783bf2f966b);
    let mut x397: u64 = 0;
    let mut x398: u64 = 0;
    let (x397, x398) = fiat_p521_scalar_mulx_u64(x383, 0x7fcc0148f709a5d0);
    let mut x399: u64 = 0;
    let mut x400: u64 = 0;
    let (x399, x400) = fiat_p521_scalar_mulx_u64(x383, 0x3bb5c9b8899c47ae);
    let mut x401: u64 = 0;
    let mut x402: u64 = 0;
    let (x401, x402) = fiat_p521_scalar_mulx_u64(x383, 0xbb6fb71e91386409);
    let mut x403: u64 = 0;
    let mut x404: fiat_p521_scalar_u1 = 0;
    let (x403, x404) = fiat_p521_scalar_addcarryx_u64(0x0, x402, x399);
    let mut x405: u64 = 0;
    let mut x406: fiat_p521_scalar_u1 = 0;
    let (x405, x406) = fiat_p521_scalar_addcarryx_u64(x404, x400, x397);
    let mut x407: u64 = 0;
    let mut x408: fiat_p521_scalar_u1 = 0;
    let (x407, x408) = fiat_p521_scalar_addcarryx_u64(x406, x398, x395);
    let mut x409: u64 = 0;
    let mut x410: fiat_p521_scalar_u1 = 0;
    let (x409, x410) = fiat_p521_scalar_addcarryx_u64(x408, x396, x393);
    let mut x411: u64 = 0;
    let mut x412: fiat_p521_scalar_u1 = 0;
    let (x411, x412) = fiat_p521_scalar_addcarryx_u64(x410, x394, x391);
    let mut x413: u64 = 0;
    let mut x414: fiat_p521_scalar_u1 = 0;
    let (x413, x414) = fiat_p521_scalar_addcarryx_u64(x412, x392, x389);
    let mut x415: u64 = 0;
    let mut x416: fiat_p521_scalar_u1 = 0;
    let (x415, x416) = fiat_p521_scalar_addcarryx_u64(x414, x390, x387);
    let mut x417: u64 = 0;
    let mut x418: fiat_p521_scalar_u1 = 0;
    let (x417, x418) = fiat_p521_scalar_addcarryx_u64(x416, x388, x385);
    let x419: u64 = ((x418 as u64) + x386);
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    let (x420, x421) = fiat_p521_scalar_addcarryx_u64(0x0, x363, x401);
    let mut x422: u64 = 0;
    let mut x423: fiat_p521_scalar_u1 = 0;
    let (x422, x423) = fiat_p521_scalar_addcarryx_u64(x421, x365, x403);
    let mut x424: u64 = 0;
    let mut x425: fiat_p521_scalar_u1 = 0;
    let (x424, x425) = fiat_p521_scalar_addcarryx_u64(x423, x367, x405);
    let mut x426: u64 = 0;
    let mut x427: fiat_p521_scalar_u1 = 0;
    let (x426, x427) = fiat_p521_scalar_addcarryx_u64(x425, x369, x407);
    let mut x428: u64 = 0;
    let mut x429: fiat_p521_scalar_u1 = 0;
    let (x428, x429) = fiat_p521_scalar_addcarryx_u64(x427, x371, x409);
    let mut x430: u64 = 0;
    let mut x431: fiat_p521_scalar_u1 = 0;
    let (x430, x431) = fiat_p521_scalar_addcarryx_u64(x429, x373, x411);
    let mut x432: u64 = 0;
    let mut x433: fiat_p521_scalar_u1 = 0;
    let (x432, x433) = fiat_p521_scalar_addcarryx_u64(x431, x375, x413);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    let (x434, x435) = fiat_p521_scalar_addcarryx_u64(x433, x377, x415);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    let (x436, x437) = fiat_p521_scalar_addcarryx_u64(x435, x379, x417);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    let (x438, x439) = fiat_p521_scalar_addcarryx_u64(x437, x381, x419);
    let x440: u64 = ((x439 as u64) + (x382 as u64));
    let mut x441: u64 = 0;
    let mut x442: u64 = 0;
    let (x441, x442) = fiat_p521_scalar_mulx_u64(x4, (arg1[8]));
    let mut x443: u64 = 0;
    let mut x444: u64 = 0;
    let (x443, x444) = fiat_p521_scalar_mulx_u64(x4, (arg1[7]));
    let mut x445: u64 = 0;
    let mut x446: u64 = 0;
    let (x445, x446) = fiat_p521_scalar_mulx_u64(x4, (arg1[6]));
    let mut x447: u64 = 0;
    let mut x448: u64 = 0;
    let (x447, x448) = fiat_p521_scalar_mulx_u64(x4, (arg1[5]));
    let mut x449: u64 = 0;
    let mut x450: u64 = 0;
    let (x449, x450) = fiat_p521_scalar_mulx_u64(x4, (arg1[4]));
    let mut x451: u64 = 0;
    let mut x452: u64 = 0;
    let (x451, x452) = fiat_p521_scalar_mulx_u64(x4, (arg1[3]));
    let mut x453: u64 = 0;
    let mut x454: u64 = 0;
    let (x453, x454) = fiat_p521_scalar_mulx_u64(x4, (arg1[2]));
    let mut x455: u64 = 0;
    let mut x456: u64 = 0;
    let (x455, x456) = fiat_p521_scalar_mulx_u64(x4, (arg1[1]));
    let mut x457: u64 = 0;
    let mut x458: u64 = 0;
    let (x457, x458) = fiat_p521_scalar_mulx_u64(x4, (arg1[0]));
    let mut x459: u64 = 0;
    let mut x460: fiat_p521_scalar_u1 = 0;
    let (x459, x460) = fiat_p521_scalar_addcarryx_u64(0x0, x458, x455);
    let mut x461: u64 = 0;
    let mut x462: fiat_p521_scalar_u1 = 0;
    let (x461, x462) = fiat_p521_scalar_addcarryx_u64(x460, x456, x453);
    let mut x463: u64 = 0;
    let mut x464: fiat_p521_scalar_u1 = 0;
    let (x463, x464) = fiat_p521_scalar_addcarryx_u64(x462, x454, x451);
    let mut x465: u64 = 0;
    let mut x466: fiat_p521_scalar_u1 = 0;
    let (x465, x466) = fiat_p521_scalar_addcarryx_u64(x464, x452, x449);
    let mut x467: u64 = 0;
    let mut x468: fiat_p521_scalar_u1 = 0;
    let (x467, x468) = fiat_p521_scalar_addcarryx_u64(x466, x450, x447);
    let mut x469: u64 = 0;
    let mut x470: fiat_p521_scalar_u1 = 0;
    let (x469, x470) = fiat_p521_scalar_addcarryx_u64(x468, x448, x445);
    let mut x471: u64 = 0;
    let mut x472: fiat_p521_scalar_u1 = 0;
    let (x471, x472) = fiat_p521_scalar_addcarryx_u64(x470, x446, x443);
    let mut x473: u64 = 0;
    let mut x474: fiat_p521_scalar_u1 = 0;
    let (x473, x474) = fiat_p521_scalar_addcarryx_u64(x472, x444, x441);
    let x475: u64 = ((x474 as u64) + x442);
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    let (x476, x477) = fiat_p521_scalar_addcarryx_u64(0x0, x422, x457);
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    let (x478, x479) = fiat_p521_scalar_addcarryx_u64(x477, x424, x459);
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    let (x480, x481) = fiat_p521_scalar_addcarryx_u64(x479, x426, x461);
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    let (x482, x483) = fiat_p521_scalar_addcarryx_u64(x481, x428, x463);
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    let (x484, x485) = fiat_p521_scalar_addcarryx_u64(x483, x430, x465);
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    let (x486, x487) = fiat_p521_scalar_addcarryx_u64(x485, x432, x467);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    let (x488, x489) = fiat_p521_scalar_addcarryx_u64(x487, x434, x469);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    let (x490, x491) = fiat_p521_scalar_addcarryx_u64(x489, x436, x471);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    let (x492, x493) = fiat_p521_scalar_addcarryx_u64(x491, x438, x473);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    let (x494, x495) = fiat_p521_scalar_addcarryx_u64(x493, x440, x475);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    let (x496, x497) = fiat_p521_scalar_mulx_u64(x476, 0x1d2f5ccd79a995c7);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    let (x498, x499) = fiat_p521_scalar_mulx_u64(x496, 0x1ff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    let (x500, x501) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    let (x502, x503) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    let (x504, x505) = fiat_p521_scalar_mulx_u64(x496, 0xffffffffffffffff);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    let (x506, x507) = fiat_p521_scalar_mulx_u64(x496, 0xfffffffffffffffa);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    let (x508, x509) = fiat_p521_scalar_mulx_u64(x496, 0x51868783bf2f966b);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    let (x510, x511) = fiat_p521_scalar_mulx_u64(x496, 0x7fcc0148f709a5d0);
    let mut x512: u64 = 0;
    let mut x513: u64 = 0;
    let (x512, x513) = fiat_p521_scalar_mulx_u64(x496, 0x3bb5c9b8899c47ae);
    let mut x514: u64 = 0;
    let mut x515: u64 = 0;
    let (x514, x515) = fiat_p521_scalar_mulx_u64(x496, 0xbb6fb71e91386409);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    let (x516, x517) = fiat_p521_scalar_addcarryx_u64(0x0, x515, x512);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    let (x518, x519) = fiat_p521_scalar_addcarryx_u64(x517, x513, x510);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    let (x520, x521) = fiat_p521_scalar_addcarryx_u64(x519, x511, x508);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    let (x522, x523) = fiat_p521_scalar_addcarryx_u64(x521, x509, x506);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    let (x524, x525) = fiat_p521_scalar_addcarryx_u64(x523, x507, x504);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    let (x526, x527) = fiat_p521_scalar_addcarryx_u64(x525, x505, x502);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    let (x528, x529) = fiat_p521_scalar_addcarryx_u64(x527, x503, x500);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    let (x530, x531) = fiat_p521_scalar_addcarryx_u64(x529, x501, x498);
    let x532: u64 = ((x531 as u64) + x499);
    let mut x533: u64 = 0;
    let mut x534: fiat_p521_scalar_u1 = 0;
    let (x533, x534) = fiat_p521_scalar_addcarryx_u64(0x0, x476, x514);
    let mut x535: u64 = 0;
    let mut x536: fiat_p521_scalar_u1 = 0;
    let (x535, x536) = fiat_p521_scalar_addcarryx_u64(x534, x478, x516);
    let mut x537: u64 = 0;
    let mut x538: fiat_p521_scalar_u1 = 0;
    let (x537, x538) = fiat_p521_scalar_addcarryx_u64(x536, x480, x518);
    let mut x539: u64 = 0;
    let mut x540: fiat_p521_scalar_u1 = 0;
    let (x539, x540) = fiat_p521_scalar_addcarryx_u64(x538, x482, x520);
    let mut x541: u64 = 0;
    let mut x542: fiat_p521_scalar_u1 = 0;
    let (x541, x542) = fiat_p521_scalar_addcarryx_u64(x540, x484, x522);
    let mut x543: u64 = 0;
    let mut x544: fiat_p521_scalar_u1 = 0;
    let (x543, x544) = fiat_p521_scalar_addcarryx_u64(x542, x486, x524);
    let mut x545: u64 = 0;
    let mut x546: fiat_p521_scalar_u1 = 0;
    let (x545, x546) = fiat_p521_scalar_addcarryx_u64(x544, x488, x526);
    let mut x547: u64 = 0;
    let mut x548: fiat_p521_scalar_u1 = 0;
    let (x547, x548) = fiat_p521_scalar_addcarryx_u64(x546, x490, x528);
    let mut x549: u64 = 0;
    let mut x550: fiat_p521_scalar_u1 = 0;
    let (x549, x550) = fiat_p521_scalar_addcarryx_u64(x548, x492, x530);
    let mut x551: u64 = 0;
    let mut x552: fiat_p521_scalar_u1 = 0;
    let (x551, x552) = fiat_p521_scalar_addcarryx_u64(x550, x494, x532);
    let x553: u64 = ((x552 as u64) + (x495 as u64));
    let mut x554: u64 = 0;
    let mut x555: u64 = 0;
    let (x554, x555) = fiat_p521_scalar_mulx_u64(x5, (arg1[8]));
    let mut x556: u64 = 0;
    let mut x557: u64 = 0;
    let (x556, x557) = fiat_p521_scalar_mulx_u64(x5, (arg1[7]));
    let mut x558: u64 = 0;
    let mut x559: u64 = 0;
    let (x558, x559) = fiat_p521_scalar_mulx_u64(x5, (arg1[6]));
    let mut x560: u64 = 0;
    let mut x561: u64 = 0;
    let (x560, x561) = fiat_p521_scalar_mulx_u64(x5, (arg1[5]));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    let (x562, x563) = fiat_p521_scalar_mulx_u64(x5, (arg1[4]));
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    let (x564, x565) = fiat_p521_scalar_mulx_u64(x5, (arg1[3]));
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    let (x566, x567) = fiat_p521_scalar_mulx_u64(x5, (arg1[2]));
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    let (x568, x569) = fiat_p521_scalar_mulx_u64(x5, (arg1[1]));
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    let (x570, x571) = fiat_p521_scalar_mulx_u64(x5, (arg1[0]));
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    let (x572, x573) = fiat_p521_scalar_addcarryx_u64(0x0, x571, x568);
    let mut x574: u64 = 0;
    let mut x575: fiat_p521_scalar_u1 = 0;
    let (x574, x575) = fiat_p521_scalar_addcarryx_u64(x573, x569, x566);
    let mut x576: u64 = 0;
    let mut x577: fiat_p521_scalar_u1 = 0;
    let (x576, x577) = fiat_p521_scalar_addcarryx_u64(x575, x567, x564);
    let mut x578: u64 = 0;
    let mut x579: fiat_p521_scalar_u1 = 0;
    let (x578, x579) = fiat_p521_scalar_addcarryx_u64(x577, x565, x562);
    let mut x580: u64 = 0;
    let mut x581: fiat_p521_scalar_u1 = 0;
    let (x580, x581) = fiat_p521_scalar_addcarryx_u64(x579, x563, x560);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    let (x582, x583) = fiat_p521_scalar_addcarryx_u64(x581, x561, x558);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    let (x584, x585) = fiat_p521_scalar_addcarryx_u64(x583, x559, x556);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    let (x586, x587) = fiat_p521_scalar_addcarryx_u64(x585, x557, x554);
    let x588: u64 = ((x587 as u64) + x555);
    let mut x589: u64 = 0;
    let mut x590: fiat_p521_scalar_u1 = 0;
    let (x589, x590) = fiat_p521_scalar_addcarryx_u64(0x0, x535, x570);
    let mut x591: u64 = 0;
    let mut x592: fiat_p521_scalar_u1 = 0;
    let (x591, x592) = fiat_p521_scalar_addcarryx_u64(x590, x537, x572);
    let mut x593: u64 = 0;
    let mut x594: fiat_p521_scalar_u1 = 0;
    let (x593, x594) = fiat_p521_scalar_addcarryx_u64(x592, x539, x574);
    let mut x595: u64 = 0;
    let mut x596: fiat_p521_scalar_u1 = 0;
    let (x595, x596) = fiat_p521_scalar_addcarryx_u64(x594, x541, x576);
    let mut x597: u64 = 0;
    let mut x598: fiat_p521_scalar_u1 = 0;
    let (x597, x598) = fiat_p521_scalar_addcarryx_u64(x596, x543, x578);
    let mut x599: u64 = 0;
    let mut x600: fiat_p521_scalar_u1 = 0;
    let (x599, x600) = fiat_p521_scalar_addcarryx_u64(x598, x545, x580);
    let mut x601: u64 = 0;
    let mut x602: fiat_p521_scalar_u1 = 0;
    let (x601, x602) = fiat_p521_scalar_addcarryx_u64(x600, x547, x582);
    let mut x603: u64 = 0;
    let mut x604: fiat_p521_scalar_u1 = 0;
    let (x603, x604) = fiat_p521_scalar_addcarryx_u64(x602, x549, x584);
    let mut x605: u64 = 0;
    let mut x606: fiat_p521_scalar_u1 = 0;
    let (x605, x606) = fiat_p521_scalar_addcarryx_u64(x604, x551, x586);
    let mut x607: u64 = 0;
    let mut x608: fiat_p521_scalar_u1 = 0;
    let (x607, x608) = fiat_p521_scalar_addcarryx_u64(x606, x553, x588);
    let mut x609: u64 = 0;
    let mut x610: u64 = 0;
    let (x609, x610) = fiat_p521_scalar_mulx_u64(x589, 0x1d2f5ccd79a995c7);
    let mut x611: u64 = 0;
    let mut x612: u64 = 0;
    let (x611, x612) = fiat_p521_scalar_mulx_u64(x609, 0x1ff);
    let mut x613: u64 = 0;
    let mut x614: u64 = 0;
    let (x613, x614) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x615: u64 = 0;
    let mut x616: u64 = 0;
    let (x615, x616) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x617: u64 = 0;
    let mut x618: u64 = 0;
    let (x617, x618) = fiat_p521_scalar_mulx_u64(x609, 0xffffffffffffffff);
    let mut x619: u64 = 0;
    let mut x620: u64 = 0;
    let (x619, x620) = fiat_p521_scalar_mulx_u64(x609, 0xfffffffffffffffa);
    let mut x621: u64 = 0;
    let mut x622: u64 = 0;
    let (x621, x622) = fiat_p521_scalar_mulx_u64(x609, 0x51868783bf2f966b);
    let mut x623: u64 = 0;
    let mut x624: u64 = 0;
    let (x623, x624) = fiat_p521_scalar_mulx_u64(x609, 0x7fcc0148f709a5d0);
    let mut x625: u64 = 0;
    let mut x626: u64 = 0;
    let (x625, x626) = fiat_p521_scalar_mulx_u64(x609, 0x3bb5c9b8899c47ae);
    let mut x627: u64 = 0;
    let mut x628: u64 = 0;
    let (x627, x628) = fiat_p521_scalar_mulx_u64(x609, 0xbb6fb71e91386409);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    let (x629, x630) = fiat_p521_scalar_addcarryx_u64(0x0, x628, x625);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    let (x631, x632) = fiat_p521_scalar_addcarryx_u64(x630, x626, x623);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    let (x633, x634) = fiat_p521_scalar_addcarryx_u64(x632, x624, x621);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    let (x635, x636) = fiat_p521_scalar_addcarryx_u64(x634, x622, x619);
    let mut x637: u64 = 0;
    let mut x638: fiat_p521_scalar_u1 = 0;
    let (x637, x638) = fiat_p521_scalar_addcarryx_u64(x636, x620, x617);
    let mut x639: u64 = 0;
    let mut x640: fiat_p521_scalar_u1 = 0;
    let (x639, x640) = fiat_p521_scalar_addcarryx_u64(x638, x618, x615);
    let mut x641: u64 = 0;
    let mut x642: fiat_p521_scalar_u1 = 0;
    let (x641, x642) = fiat_p521_scalar_addcarryx_u64(x640, x616, x613);
    let mut x643: u64 = 0;
    let mut x644: fiat_p521_scalar_u1 = 0;
    let (x643, x644) = fiat_p521_scalar_addcarryx_u64(x642, x614, x611);
    let x645: u64 = ((x644 as u64) + x612);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    let (x646, x647) = fiat_p521_scalar_addcarryx_u64(0x0, x589, x627);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    let (x648, x649) = fiat_p521_scalar_addcarryx_u64(x647, x591, x629);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    let (x650, x651) = fiat_p521_scalar_addcarryx_u64(x649, x593, x631);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    let (x652, x653) = fiat_p521_scalar_addcarryx_u64(x651, x595, x633);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    let (x654, x655) = fiat_p521_scalar_addcarryx_u64(x653, x597, x635);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    let (x656, x657) = fiat_p521_scalar_addcarryx_u64(x655, x599, x637);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    let (x658, x659) = fiat_p521_scalar_addcarryx_u64(x657, x601, x639);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    let (x660, x661) = fiat_p521_scalar_addcarryx_u64(x659, x603, x641);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    let (x662, x663) = fiat_p521_scalar_addcarryx_u64(x661, x605, x643);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    let (x664, x665) = fiat_p521_scalar_addcarryx_u64(x663, x607, x645);
    let x666: u64 = ((x665 as u64) + (x608 as u64));
    let mut x667: u64 = 0;
    let mut x668: u64 = 0;
    let (x667, x668) = fiat_p521_scalar_mulx_u64(x6, (arg1[8]));
    let mut x669: u64 = 0;
    let mut x670: u64 = 0;
    let (x669, x670) = fiat_p521_scalar_mulx_u64(x6, (arg1[7]));
    let mut x671: u64 = 0;
    let mut x672: u64 = 0;
    let (x671, x672) = fiat_p521_scalar_mulx_u64(x6, (arg1[6]));
    let mut x673: u64 = 0;
    let mut x674: u64 = 0;
    let (x673, x674) = fiat_p521_scalar_mulx_u64(x6, (arg1[5]));
    let mut x675: u64 = 0;
    let mut x676: u64 = 0;
    let (x675, x676) = fiat_p521_scalar_mulx_u64(x6, (arg1[4]));
    let mut x677: u64 = 0;
    let mut x678: u64 = 0;
    let (x677, x678) = fiat_p521_scalar_mulx_u64(x6, (arg1[3]));
    let mut x679: u64 = 0;
    let mut x680: u64 = 0;
    let (x679, x680) = fiat_p521_scalar_mulx_u64(x6, (arg1[2]));
    let mut x681: u64 = 0;
    let mut x682: u64 = 0;
    let (x681, x682) = fiat_p521_scalar_mulx_u64(x6, (arg1[1]));
    let mut x683: u64 = 0;
    let mut x684: u64 = 0;
    let (x683, x684) = fiat_p521_scalar_mulx_u64(x6, (arg1[0]));
    let mut x685: u64 = 0;
    let mut x686: fiat_p521_scalar_u1 = 0;
    let (x685, x686) = fiat_p521_scalar_addcarryx_u64(0x0, x684, x681);
    let mut x687: u64 = 0;
    let mut x688: fiat_p521_scalar_u1 = 0;
    let (x687, x688) = fiat_p521_scalar_addcarryx_u64(x686, x682, x679);
    let mut x689: u64 = 0;
    let mut x690: fiat_p521_scalar_u1 = 0;
    let (x689, x690) = fiat_p521_scalar_addcarryx_u64(x688, x680, x677);
    let mut x691: u64 = 0;
    let mut x692: fiat_p521_scalar_u1 = 0;
    let (x691, x692) = fiat_p521_scalar_addcarryx_u64(x690, x678, x675);
    let mut x693: u64 = 0;
    let mut x694: fiat_p521_scalar_u1 = 0;
    let (x693, x694) = fiat_p521_scalar_addcarryx_u64(x692, x676, x673);
    let mut x695: u64 = 0;
    let mut x696: fiat_p521_scalar_u1 = 0;
    let (x695, x696) = fiat_p521_scalar_addcarryx_u64(x694, x674, x671);
    let mut x697: u64 = 0;
    let mut x698: fiat_p521_scalar_u1 = 0;
    let (x697, x698) = fiat_p521_scalar_addcarryx_u64(x696, x672, x669);
    let mut x699: u64 = 0;
    let mut x700: fiat_p521_scalar_u1 = 0;
    let (x699, x700) = fiat_p521_scalar_addcarryx_u64(x698, x670, x667);
    let x701: u64 = ((x700 as u64) + x668);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    let (x702, x703) = fiat_p521_scalar_addcarryx_u64(0x0, x648, x683);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    let (x704, x705) = fiat_p521_scalar_addcarryx_u64(x703, x650, x685);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    let (x706, x707) = fiat_p521_scalar_addcarryx_u64(x705, x652, x687);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    let (x708, x709) = fiat_p521_scalar_addcarryx_u64(x707, x654, x689);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    let (x710, x711) = fiat_p521_scalar_addcarryx_u64(x709, x656, x691);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    let (x712, x713) = fiat_p521_scalar_addcarryx_u64(x711, x658, x693);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    let (x714, x715) = fiat_p521_scalar_addcarryx_u64(x713, x660, x695);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    let (x716, x717) = fiat_p521_scalar_addcarryx_u64(x715, x662, x697);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    let (x718, x719) = fiat_p521_scalar_addcarryx_u64(x717, x664, x699);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    let (x720, x721) = fiat_p521_scalar_addcarryx_u64(x719, x666, x701);
    let mut x722: u64 = 0;
    let mut x723: u64 = 0;
    let (x722, x723) = fiat_p521_scalar_mulx_u64(x702, 0x1d2f5ccd79a995c7);
    let mut x724: u64 = 0;
    let mut x725: u64 = 0;
    let (x724, x725) = fiat_p521_scalar_mulx_u64(x722, 0x1ff);
    let mut x726: u64 = 0;
    let mut x727: u64 = 0;
    let (x726, x727) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x728: u64 = 0;
    let mut x729: u64 = 0;
    let (x728, x729) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x730: u64 = 0;
    let mut x731: u64 = 0;
    let (x730, x731) = fiat_p521_scalar_mulx_u64(x722, 0xffffffffffffffff);
    let mut x732: u64 = 0;
    let mut x733: u64 = 0;
    let (x732, x733) = fiat_p521_scalar_mulx_u64(x722, 0xfffffffffffffffa);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    let (x734, x735) = fiat_p521_scalar_mulx_u64(x722, 0x51868783bf2f966b);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    let (x736, x737) = fiat_p521_scalar_mulx_u64(x722, 0x7fcc0148f709a5d0);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    let (x738, x739) = fiat_p521_scalar_mulx_u64(x722, 0x3bb5c9b8899c47ae);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    let (x740, x741) = fiat_p521_scalar_mulx_u64(x722, 0xbb6fb71e91386409);
    let mut x742: u64 = 0;
    let mut x743: fiat_p521_scalar_u1 = 0;
    let (x742, x743) = fiat_p521_scalar_addcarryx_u64(0x0, x741, x738);
    let mut x744: u64 = 0;
    let mut x745: fiat_p521_scalar_u1 = 0;
    let (x744, x745) = fiat_p521_scalar_addcarryx_u64(x743, x739, x736);
    let mut x746: u64 = 0;
    let mut x747: fiat_p521_scalar_u1 = 0;
    let (x746, x747) = fiat_p521_scalar_addcarryx_u64(x745, x737, x734);
    let mut x748: u64 = 0;
    let mut x749: fiat_p521_scalar_u1 = 0;
    let (x748, x749) = fiat_p521_scalar_addcarryx_u64(x747, x735, x732);
    let mut x750: u64 = 0;
    let mut x751: fiat_p521_scalar_u1 = 0;
    let (x750, x751) = fiat_p521_scalar_addcarryx_u64(x749, x733, x730);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    let (x752, x753) = fiat_p521_scalar_addcarryx_u64(x751, x731, x728);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    let (x754, x755) = fiat_p521_scalar_addcarryx_u64(x753, x729, x726);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    let (x756, x757) = fiat_p521_scalar_addcarryx_u64(x755, x727, x724);
    let x758: u64 = ((x757 as u64) + x725);
    let mut x759: u64 = 0;
    let mut x760: fiat_p521_scalar_u1 = 0;
    let (x759, x760) = fiat_p521_scalar_addcarryx_u64(0x0, x702, x740);
    let mut x761: u64 = 0;
    let mut x762: fiat_p521_scalar_u1 = 0;
    let (x761, x762) = fiat_p521_scalar_addcarryx_u64(x760, x704, x742);
    let mut x763: u64 = 0;
    let mut x764: fiat_p521_scalar_u1 = 0;
    let (x763, x764) = fiat_p521_scalar_addcarryx_u64(x762, x706, x744);
    let mut x765: u64 = 0;
    let mut x766: fiat_p521_scalar_u1 = 0;
    let (x765, x766) = fiat_p521_scalar_addcarryx_u64(x764, x708, x746);
    let mut x767: u64 = 0;
    let mut x768: fiat_p521_scalar_u1 = 0;
    let (x767, x768) = fiat_p521_scalar_addcarryx_u64(x766, x710, x748);
    let mut x769: u64 = 0;
    let mut x770: fiat_p521_scalar_u1 = 0;
    let (x769, x770) = fiat_p521_scalar_addcarryx_u64(x768, x712, x750);
    let mut x771: u64 = 0;
    let mut x772: fiat_p521_scalar_u1 = 0;
    let (x771, x772) = fiat_p521_scalar_addcarryx_u64(x770, x714, x752);
    let mut x773: u64 = 0;
    let mut x774: fiat_p521_scalar_u1 = 0;
    let (x773, x774) = fiat_p521_scalar_addcarryx_u64(x772, x716, x754);
    let mut x775: u64 = 0;
    let mut x776: fiat_p521_scalar_u1 = 0;
    let (x775, x776) = fiat_p521_scalar_addcarryx_u64(x774, x718, x756);
    let mut x777: u64 = 0;
    let mut x778: fiat_p521_scalar_u1 = 0;
    let (x777, x778) = fiat_p521_scalar_addcarryx_u64(x776, x720, x758);
    let x779: u64 = ((x778 as u64) + (x721 as u64));
    let mut x780: u64 = 0;
    let mut x781: u64 = 0;
    let (x780, x781) = fiat_p521_scalar_mulx_u64(x7, (arg1[8]));
    let mut x782: u64 = 0;
    let mut x783: u64 = 0;
    let (x782, x783) = fiat_p521_scalar_mulx_u64(x7, (arg1[7]));
    let mut x784: u64 = 0;
    let mut x785: u64 = 0;
    let (x784, x785) = fiat_p521_scalar_mulx_u64(x7, (arg1[6]));
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    let (x786, x787) = fiat_p521_scalar_mulx_u64(x7, (arg1[5]));
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    let (x788, x789) = fiat_p521_scalar_mulx_u64(x7, (arg1[4]));
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    let (x790, x791) = fiat_p521_scalar_mulx_u64(x7, (arg1[3]));
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    let (x792, x793) = fiat_p521_scalar_mulx_u64(x7, (arg1[2]));
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    let (x794, x795) = fiat_p521_scalar_mulx_u64(x7, (arg1[1]));
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    let (x796, x797) = fiat_p521_scalar_mulx_u64(x7, (arg1[0]));
    let mut x798: u64 = 0;
    let mut x799: fiat_p521_scalar_u1 = 0;
    let (x798, x799) = fiat_p521_scalar_addcarryx_u64(0x0, x797, x794);
    let mut x800: u64 = 0;
    let mut x801: fiat_p521_scalar_u1 = 0;
    let (x800, x801) = fiat_p521_scalar_addcarryx_u64(x799, x795, x792);
    let mut x802: u64 = 0;
    let mut x803: fiat_p521_scalar_u1 = 0;
    let (x802, x803) = fiat_p521_scalar_addcarryx_u64(x801, x793, x790);
    let mut x804: u64 = 0;
    let mut x805: fiat_p521_scalar_u1 = 0;
    let (x804, x805) = fiat_p521_scalar_addcarryx_u64(x803, x791, x788);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    let (x806, x807) = fiat_p521_scalar_addcarryx_u64(x805, x789, x786);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    let (x808, x809) = fiat_p521_scalar_addcarryx_u64(x807, x787, x784);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    let (x810, x811) = fiat_p521_scalar_addcarryx_u64(x809, x785, x782);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    let (x812, x813) = fiat_p521_scalar_addcarryx_u64(x811, x783, x780);
    let x814: u64 = ((x813 as u64) + x781);
    let mut x815: u64 = 0;
    let mut x816: fiat_p521_scalar_u1 = 0;
    let (x815, x816) = fiat_p521_scalar_addcarryx_u64(0x0, x761, x796);
    let mut x817: u64 = 0;
    let mut x818: fiat_p521_scalar_u1 = 0;
    let (x817, x818) = fiat_p521_scalar_addcarryx_u64(x816, x763, x798);
    let mut x819: u64 = 0;
    let mut x820: fiat_p521_scalar_u1 = 0;
    let (x819, x820) = fiat_p521_scalar_addcarryx_u64(x818, x765, x800);
    let mut x821: u64 = 0;
    let mut x822: fiat_p521_scalar_u1 = 0;
    let (x821, x822) = fiat_p521_scalar_addcarryx_u64(x820, x767, x802);
    let mut x823: u64 = 0;
    let mut x824: fiat_p521_scalar_u1 = 0;
    let (x823, x824) = fiat_p521_scalar_addcarryx_u64(x822, x769, x804);
    let mut x825: u64 = 0;
    let mut x826: fiat_p521_scalar_u1 = 0;
    let (x825, x826) = fiat_p521_scalar_addcarryx_u64(x824, x771, x806);
    let mut x827: u64 = 0;
    let mut x828: fiat_p521_scalar_u1 = 0;
    let (x827, x828) = fiat_p521_scalar_addcarryx_u64(x826, x773, x808);
    let mut x829: u64 = 0;
    let mut x830: fiat_p521_scalar_u1 = 0;
    let (x829, x830) = fiat_p521_scalar_addcarryx_u64(x828, x775, x810);
    let mut x831: u64 = 0;
    let mut x832: fiat_p521_scalar_u1 = 0;
    let (x831, x832) = fiat_p521_scalar_addcarryx_u64(x830, x777, x812);
    let mut x833: u64 = 0;
    let mut x834: fiat_p521_scalar_u1 = 0;
    let (x833, x834) = fiat_p521_scalar_addcarryx_u64(x832, x779, x814);
    let mut x835: u64 = 0;
    let mut x836: u64 = 0;
    let (x835, x836) = fiat_p521_scalar_mulx_u64(x815, 0x1d2f5ccd79a995c7);
    let mut x837: u64 = 0;
    let mut x838: u64 = 0;
    let (x837, x838) = fiat_p521_scalar_mulx_u64(x835, 0x1ff);
    let mut x839: u64 = 0;
    let mut x840: u64 = 0;
    let (x839, x840) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x841: u64 = 0;
    let mut x842: u64 = 0;
    let (x841, x842) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x843: u64 = 0;
    let mut x844: u64 = 0;
    let (x843, x844) = fiat_p521_scalar_mulx_u64(x835, 0xffffffffffffffff);
    let mut x845: u64 = 0;
    let mut x846: u64 = 0;
    let (x845, x846) = fiat_p521_scalar_mulx_u64(x835, 0xfffffffffffffffa);
    let mut x847: u64 = 0;
    let mut x848: u64 = 0;
    let (x847, x848) = fiat_p521_scalar_mulx_u64(x835, 0x51868783bf2f966b);
    let mut x849: u64 = 0;
    let mut x850: u64 = 0;
    let (x849, x850) = fiat_p521_scalar_mulx_u64(x835, 0x7fcc0148f709a5d0);
    let mut x851: u64 = 0;
    let mut x852: u64 = 0;
    let (x851, x852) = fiat_p521_scalar_mulx_u64(x835, 0x3bb5c9b8899c47ae);
    let mut x853: u64 = 0;
    let mut x854: u64 = 0;
    let (x853, x854) = fiat_p521_scalar_mulx_u64(x835, 0xbb6fb71e91386409);
    let mut x855: u64 = 0;
    let mut x856: fiat_p521_scalar_u1 = 0;
    let (x855, x856) = fiat_p521_scalar_addcarryx_u64(0x0, x854, x851);
    let mut x857: u64 = 0;
    let mut x858: fiat_p521_scalar_u1 = 0;
    let (x857, x858) = fiat_p521_scalar_addcarryx_u64(x856, x852, x849);
    let mut x859: u64 = 0;
    let mut x860: fiat_p521_scalar_u1 = 0;
    let (x859, x860) = fiat_p521_scalar_addcarryx_u64(x858, x850, x847);
    let mut x861: u64 = 0;
    let mut x862: fiat_p521_scalar_u1 = 0;
    let (x861, x862) = fiat_p521_scalar_addcarryx_u64(x860, x848, x845);
    let mut x863: u64 = 0;
    let mut x864: fiat_p521_scalar_u1 = 0;
    let (x863, x864) = fiat_p521_scalar_addcarryx_u64(x862, x846, x843);
    let mut x865: u64 = 0;
    let mut x866: fiat_p521_scalar_u1 = 0;
    let (x865, x866) = fiat_p521_scalar_addcarryx_u64(x864, x844, x841);
    let mut x867: u64 = 0;
    let mut x868: fiat_p521_scalar_u1 = 0;
    let (x867, x868) = fiat_p521_scalar_addcarryx_u64(x866, x842, x839);
    let mut x869: u64 = 0;
    let mut x870: fiat_p521_scalar_u1 = 0;
    let (x869, x870) = fiat_p521_scalar_addcarryx_u64(x868, x840, x837);
    let x871: u64 = ((x870 as u64) + x838);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    let (x872, x873) = fiat_p521_scalar_addcarryx_u64(0x0, x815, x853);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    let (x874, x875) = fiat_p521_scalar_addcarryx_u64(x873, x817, x855);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    let (x876, x877) = fiat_p521_scalar_addcarryx_u64(x875, x819, x857);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    let (x878, x879) = fiat_p521_scalar_addcarryx_u64(x877, x821, x859);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    let (x880, x881) = fiat_p521_scalar_addcarryx_u64(x879, x823, x861);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    let (x882, x883) = fiat_p521_scalar_addcarryx_u64(x881, x825, x863);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    let (x884, x885) = fiat_p521_scalar_addcarryx_u64(x883, x827, x865);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    let (x886, x887) = fiat_p521_scalar_addcarryx_u64(x885, x829, x867);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    let (x888, x889) = fiat_p521_scalar_addcarryx_u64(x887, x831, x869);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    let (x890, x891) = fiat_p521_scalar_addcarryx_u64(x889, x833, x871);
    let x892: u64 = ((x891 as u64) + (x834 as u64));
    let mut x893: u64 = 0;
    let mut x894: u64 = 0;
    let (x893, x894) = fiat_p521_scalar_mulx_u64(x8, (arg1[8]));
    let mut x895: u64 = 0;
    let mut x896: u64 = 0;
    let (x895, x896) = fiat_p521_scalar_mulx_u64(x8, (arg1[7]));
    let mut x897: u64 = 0;
    let mut x898: u64 = 0;
    let (x897, x898) = fiat_p521_scalar_mulx_u64(x8, (arg1[6]));
    let mut x899: u64 = 0;
    let mut x900: u64 = 0;
    let (x899, x900) = fiat_p521_scalar_mulx_u64(x8, (arg1[5]));
    let mut x901: u64 = 0;
    let mut x902: u64 = 0;
    let (x901, x902) = fiat_p521_scalar_mulx_u64(x8, (arg1[4]));
    let mut x903: u64 = 0;
    let mut x904: u64 = 0;
    let (x903, x904) = fiat_p521_scalar_mulx_u64(x8, (arg1[3]));
    let mut x905: u64 = 0;
    let mut x906: u64 = 0;
    let (x905, x906) = fiat_p521_scalar_mulx_u64(x8, (arg1[2]));
    let mut x907: u64 = 0;
    let mut x908: u64 = 0;
    let (x907, x908) = fiat_p521_scalar_mulx_u64(x8, (arg1[1]));
    let mut x909: u64 = 0;
    let mut x910: u64 = 0;
    let (x909, x910) = fiat_p521_scalar_mulx_u64(x8, (arg1[0]));
    let mut x911: u64 = 0;
    let mut x912: fiat_p521_scalar_u1 = 0;
    let (x911, x912) = fiat_p521_scalar_addcarryx_u64(0x0, x910, x907);
    let mut x913: u64 = 0;
    let mut x914: fiat_p521_scalar_u1 = 0;
    let (x913, x914) = fiat_p521_scalar_addcarryx_u64(x912, x908, x905);
    let mut x915: u64 = 0;
    let mut x916: fiat_p521_scalar_u1 = 0;
    let (x915, x916) = fiat_p521_scalar_addcarryx_u64(x914, x906, x903);
    let mut x917: u64 = 0;
    let mut x918: fiat_p521_scalar_u1 = 0;
    let (x917, x918) = fiat_p521_scalar_addcarryx_u64(x916, x904, x901);
    let mut x919: u64 = 0;
    let mut x920: fiat_p521_scalar_u1 = 0;
    let (x919, x920) = fiat_p521_scalar_addcarryx_u64(x918, x902, x899);
    let mut x921: u64 = 0;
    let mut x922: fiat_p521_scalar_u1 = 0;
    let (x921, x922) = fiat_p521_scalar_addcarryx_u64(x920, x900, x897);
    let mut x923: u64 = 0;
    let mut x924: fiat_p521_scalar_u1 = 0;
    let (x923, x924) = fiat_p521_scalar_addcarryx_u64(x922, x898, x895);
    let mut x925: u64 = 0;
    let mut x926: fiat_p521_scalar_u1 = 0;
    let (x925, x926) = fiat_p521_scalar_addcarryx_u64(x924, x896, x893);
    let x927: u64 = ((x926 as u64) + x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    let (x928, x929) = fiat_p521_scalar_addcarryx_u64(0x0, x874, x909);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    let (x930, x931) = fiat_p521_scalar_addcarryx_u64(x929, x876, x911);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    let (x932, x933) = fiat_p521_scalar_addcarryx_u64(x931, x878, x913);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    let (x934, x935) = fiat_p521_scalar_addcarryx_u64(x933, x880, x915);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    let (x936, x937) = fiat_p521_scalar_addcarryx_u64(x935, x882, x917);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    let (x938, x939) = fiat_p521_scalar_addcarryx_u64(x937, x884, x919);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    let (x940, x941) = fiat_p521_scalar_addcarryx_u64(x939, x886, x921);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    let (x942, x943) = fiat_p521_scalar_addcarryx_u64(x941, x888, x923);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    let (x944, x945) = fiat_p521_scalar_addcarryx_u64(x943, x890, x925);
    let mut x946: u64 = 0;
    let mut x947: fiat_p521_scalar_u1 = 0;
    let (x946, x947) = fiat_p521_scalar_addcarryx_u64(x945, x892, x927);
    let mut x948: u64 = 0;
    let mut x949: u64 = 0;
    let (x948, x949) = fiat_p521_scalar_mulx_u64(x928, 0x1d2f5ccd79a995c7);
    let mut x950: u64 = 0;
    let mut x951: u64 = 0;
    let (x950, x951) = fiat_p521_scalar_mulx_u64(x948, 0x1ff);
    let mut x952: u64 = 0;
    let mut x953: u64 = 0;
    let (x952, x953) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x954: u64 = 0;
    let mut x955: u64 = 0;
    let (x954, x955) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x956: u64 = 0;
    let mut x957: u64 = 0;
    let (x956, x957) = fiat_p521_scalar_mulx_u64(x948, 0xffffffffffffffff);
    let mut x958: u64 = 0;
    let mut x959: u64 = 0;
    let (x958, x959) = fiat_p521_scalar_mulx_u64(x948, 0xfffffffffffffffa);
    let mut x960: u64 = 0;
    let mut x961: u64 = 0;
    let (x960, x961) = fiat_p521_scalar_mulx_u64(x948, 0x51868783bf2f966b);
    let mut x962: u64 = 0;
    let mut x963: u64 = 0;
    let (x962, x963) = fiat_p521_scalar_mulx_u64(x948, 0x7fcc0148f709a5d0);
    let mut x964: u64 = 0;
    let mut x965: u64 = 0;
    let (x964, x965) = fiat_p521_scalar_mulx_u64(x948, 0x3bb5c9b8899c47ae);
    let mut x966: u64 = 0;
    let mut x967: u64 = 0;
    let (x966, x967) = fiat_p521_scalar_mulx_u64(x948, 0xbb6fb71e91386409);
    let mut x968: u64 = 0;
    let mut x969: fiat_p521_scalar_u1 = 0;
    let (x968, x969) = fiat_p521_scalar_addcarryx_u64(0x0, x967, x964);
    let mut x970: u64 = 0;
    let mut x971: fiat_p521_scalar_u1 = 0;
    let (x970, x971) = fiat_p521_scalar_addcarryx_u64(x969, x965, x962);
    let mut x972: u64 = 0;
    let mut x973: fiat_p521_scalar_u1 = 0;
    let (x972, x973) = fiat_p521_scalar_addcarryx_u64(x971, x963, x960);
    let mut x974: u64 = 0;
    let mut x975: fiat_p521_scalar_u1 = 0;
    let (x974, x975) = fiat_p521_scalar_addcarryx_u64(x973, x961, x958);
    let mut x976: u64 = 0;
    let mut x977: fiat_p521_scalar_u1 = 0;
    let (x976, x977) = fiat_p521_scalar_addcarryx_u64(x975, x959, x956);
    let mut x978: u64 = 0;
    let mut x979: fiat_p521_scalar_u1 = 0;
    let (x978, x979) = fiat_p521_scalar_addcarryx_u64(x977, x957, x954);
    let mut x980: u64 = 0;
    let mut x981: fiat_p521_scalar_u1 = 0;
    let (x980, x981) = fiat_p521_scalar_addcarryx_u64(x979, x955, x952);
    let mut x982: u64 = 0;
    let mut x983: fiat_p521_scalar_u1 = 0;
    let (x982, x983) = fiat_p521_scalar_addcarryx_u64(x981, x953, x950);
    let x984: u64 = ((x983 as u64) + x951);
    let mut x985: u64 = 0;
    let mut x986: fiat_p521_scalar_u1 = 0;
    let (x985, x986) = fiat_p521_scalar_addcarryx_u64(0x0, x928, x966);
    let mut x987: u64 = 0;
    let mut x988: fiat_p521_scalar_u1 = 0;
    let (x987, x988) = fiat_p521_scalar_addcarryx_u64(x986, x930, x968);
    let mut x989: u64 = 0;
    let mut x990: fiat_p521_scalar_u1 = 0;
    let (x989, x990) = fiat_p521_scalar_addcarryx_u64(x988, x932, x970);
    let mut x991: u64 = 0;
    let mut x992: fiat_p521_scalar_u1 = 0;
    let (x991, x992) = fiat_p521_scalar_addcarryx_u64(x990, x934, x972);
    let mut x993: u64 = 0;
    let mut x994: fiat_p521_scalar_u1 = 0;
    let (x993, x994) = fiat_p521_scalar_addcarryx_u64(x992, x936, x974);
    let mut x995: u64 = 0;
    let mut x996: fiat_p521_scalar_u1 = 0;
    let (x995, x996) = fiat_p521_scalar_addcarryx_u64(x994, x938, x976);
    let mut x997: u64 = 0;
    let mut x998: fiat_p521_scalar_u1 = 0;
    let (x997, x998) = fiat_p521_scalar_addcarryx_u64(x996, x940, x978);
    let mut x999: u64 = 0;
    let mut x1000: fiat_p521_scalar_u1 = 0;
    let (x999, x1000) = fiat_p521_scalar_addcarryx_u64(x998, x942, x980);
    let mut x1001: u64 = 0;
    let mut x1002: fiat_p521_scalar_u1 = 0;
    let (x1001, x1002) = fiat_p521_scalar_addcarryx_u64(x1000, x944, x982);
    let mut x1003: u64 = 0;
    let mut x1004: fiat_p521_scalar_u1 = 0;
    let (x1003, x1004) = fiat_p521_scalar_addcarryx_u64(x1002, x946, x984);
    let x1005: u64 = ((x1004 as u64) + (x947 as u64));
    let mut x1006: u64 = 0;
    let mut x1007: fiat_p521_scalar_u1 = 0;
    let (x1006, x1007) = fiat_p521_scalar_subborrowx_u64(0x0, x987, 0xbb6fb71e91386409);
    let mut x1008: u64 = 0;
    let mut x1009: fiat_p521_scalar_u1 = 0;
    let (x1008, x1009) = fiat_p521_scalar_subborrowx_u64(x1007, x989, 0x3bb5c9b8899c47ae);
    let mut x1010: u64 = 0;
    let mut x1011: fiat_p521_scalar_u1 = 0;
    let (x1010, x1011) = fiat_p521_scalar_subborrowx_u64(x1009, x991, 0x7fcc0148f709a5d0);
    let mut x1012: u64 = 0;
    let mut x1013: fiat_p521_scalar_u1 = 0;
    let (x1012, x1013) = fiat_p521_scalar_subborrowx_u64(x1011, x993, 0x51868783bf2f966b);
    let mut x1014: u64 = 0;
    let mut x1015: fiat_p521_scalar_u1 = 0;
    let (x1014, x1015) = fiat_p521_scalar_subborrowx_u64(x1013, x995, 0xfffffffffffffffa);
    let mut x1016: u64 = 0;
    let mut x1017: fiat_p521_scalar_u1 = 0;
    let (x1016, x1017) = fiat_p521_scalar_subborrowx_u64(x1015, x997, 0xffffffffffffffff);
    let mut x1018: u64 = 0;
    let mut x1019: fiat_p521_scalar_u1 = 0;
    let (x1018, x1019) = fiat_p521_scalar_subborrowx_u64(x1017, x999, 0xffffffffffffffff);
    let mut x1020: u64 = 0;
    let mut x1021: fiat_p521_scalar_u1 = 0;
    let (x1020, x1021) = fiat_p521_scalar_subborrowx_u64(x1019, x1001, 0xffffffffffffffff);
    let mut x1022: u64 = 0;
    let mut x1023: fiat_p521_scalar_u1 = 0;
    let (x1022, x1023) = fiat_p521_scalar_subborrowx_u64(x1021, x1003, 0x1ff);
    let mut x1024: u64 = 0;
    let mut x1025: fiat_p521_scalar_u1 = 0;
    let (x1024, x1025) = fiat_p521_scalar_subborrowx_u64(x1023, x1005, (0x0 as u64));
    let mut x1026: u64 = 0;
    let (x1026) = fiat_p521_scalar_cmovznz_u64(x1025, x1006, x987);
    let mut x1027: u64 = 0;
    let (x1027) = fiat_p521_scalar_cmovznz_u64(x1025, x1008, x989);
    let mut x1028: u64 = 0;
    let (x1028) = fiat_p521_scalar_cmovznz_u64(x1025, x1010, x991);
    let mut x1029: u64 = 0;
    let (x1029) = fiat_p521_scalar_cmovznz_u64(x1025, x1012, x993);
    let mut x1030: u64 = 0;
    let (x1030) = fiat_p521_scalar_cmovznz_u64(x1025, x1014, x995);
    let mut x1031: u64 = 0;
    let (x1031) = fiat_p521_scalar_cmovznz_u64(x1025, x1016, x997);
    let mut x1032: u64 = 0;
    let (x1032) = fiat_p521_scalar_cmovznz_u64(x1025, x1018, x999);
    let mut x1033: u64 = 0;
    let (x1033) = fiat_p521_scalar_cmovznz_u64(x1025, x1020, x1001);
    let mut x1034: u64 = 0;
    let (x1034) = fiat_p521_scalar_cmovznz_u64(x1025, x1022, x1003);
    out1[0] = x1026;
    out1[1] = x1027;
    out1[2] = x1028;
    out1[3] = x1029;
    out1[4] = x1030;
    out1[5] = x1031;
    out1[6] = x1032;
    out1[7] = x1033;
    out1[8] = x1034;
    out1
}
#[doc = " The function fiat_p521_scalar_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_add(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    let (x1, x2) = fiat_p521_scalar_addcarryx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    let (x3, x4) = fiat_p521_scalar_addcarryx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    let (x5, x6) = fiat_p521_scalar_addcarryx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    let (x7, x8) = fiat_p521_scalar_addcarryx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    let (x9, x10) = fiat_p521_scalar_addcarryx_u64(x8, (arg1[4]), (arg2[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    let (x11, x12) = fiat_p521_scalar_addcarryx_u64(x10, (arg1[5]), (arg2[5]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    let (x13, x14) = fiat_p521_scalar_addcarryx_u64(x12, (arg1[6]), (arg2[6]));
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    let (x15, x16) = fiat_p521_scalar_addcarryx_u64(x14, (arg1[7]), (arg2[7]));
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    let (x17, x18) = fiat_p521_scalar_addcarryx_u64(x16, (arg1[8]), (arg2[8]));
    let mut x19: u64 = 0;
    let mut x20: fiat_p521_scalar_u1 = 0;
    let (x19, x20) = fiat_p521_scalar_subborrowx_u64(0x0, x1, 0xbb6fb71e91386409);
    let mut x21: u64 = 0;
    let mut x22: fiat_p521_scalar_u1 = 0;
    let (x21, x22) = fiat_p521_scalar_subborrowx_u64(x20, x3, 0x3bb5c9b8899c47ae);
    let mut x23: u64 = 0;
    let mut x24: fiat_p521_scalar_u1 = 0;
    let (x23, x24) = fiat_p521_scalar_subborrowx_u64(x22, x5, 0x7fcc0148f709a5d0);
    let mut x25: u64 = 0;
    let mut x26: fiat_p521_scalar_u1 = 0;
    let (x25, x26) = fiat_p521_scalar_subborrowx_u64(x24, x7, 0x51868783bf2f966b);
    let mut x27: u64 = 0;
    let mut x28: fiat_p521_scalar_u1 = 0;
    let (x27, x28) = fiat_p521_scalar_subborrowx_u64(x26, x9, 0xfffffffffffffffa);
    let mut x29: u64 = 0;
    let mut x30: fiat_p521_scalar_u1 = 0;
    let (x29, x30) = fiat_p521_scalar_subborrowx_u64(x28, x11, 0xffffffffffffffff);
    let mut x31: u64 = 0;
    let mut x32: fiat_p521_scalar_u1 = 0;
    let (x31, x32) = fiat_p521_scalar_subborrowx_u64(x30, x13, 0xffffffffffffffff);
    let mut x33: u64 = 0;
    let mut x34: fiat_p521_scalar_u1 = 0;
    let (x33, x34) = fiat_p521_scalar_subborrowx_u64(x32, x15, 0xffffffffffffffff);
    let mut x35: u64 = 0;
    let mut x36: fiat_p521_scalar_u1 = 0;
    let (x35, x36) = fiat_p521_scalar_subborrowx_u64(x34, x17, 0x1ff);
    let mut x37: u64 = 0;
    let mut x38: fiat_p521_scalar_u1 = 0;
    let (x37, x38) = fiat_p521_scalar_subborrowx_u64(x36, (x18 as u64), (0x0 as u64));
    let mut x39: u64 = 0;
    let (x39) = fiat_p521_scalar_cmovznz_u64(x38, x19, x1);
    let mut x40: u64 = 0;
    let (x40) = fiat_p521_scalar_cmovznz_u64(x38, x21, x3);
    let mut x41: u64 = 0;
    let (x41) = fiat_p521_scalar_cmovznz_u64(x38, x23, x5);
    let mut x42: u64 = 0;
    let (x42) = fiat_p521_scalar_cmovznz_u64(x38, x25, x7);
    let mut x43: u64 = 0;
    let (x43) = fiat_p521_scalar_cmovznz_u64(x38, x27, x9);
    let mut x44: u64 = 0;
    let (x44) = fiat_p521_scalar_cmovznz_u64(x38, x29, x11);
    let mut x45: u64 = 0;
    let (x45) = fiat_p521_scalar_cmovznz_u64(x38, x31, x13);
    let mut x46: u64 = 0;
    let (x46) = fiat_p521_scalar_cmovznz_u64(x38, x33, x15);
    let mut x47: u64 = 0;
    let (x47) = fiat_p521_scalar_cmovznz_u64(x38, x35, x17);
    out1[0] = x39;
    out1[1] = x40;
    out1[2] = x41;
    out1[3] = x42;
    out1[4] = x43;
    out1[5] = x44;
    out1[6] = x45;
    out1[7] = x46;
    out1[8] = x47;
    out1
}
#[doc = " The function fiat_p521_scalar_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_sub(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
    arg2: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    let (x1, x2) = fiat_p521_scalar_subborrowx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    let (x3, x4) = fiat_p521_scalar_subborrowx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    let (x5, x6) = fiat_p521_scalar_subborrowx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    let (x7, x8) = fiat_p521_scalar_subborrowx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    let (x9, x10) = fiat_p521_scalar_subborrowx_u64(x8, (arg1[4]), (arg2[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    let (x11, x12) = fiat_p521_scalar_subborrowx_u64(x10, (arg1[5]), (arg2[5]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    let (x13, x14) = fiat_p521_scalar_subborrowx_u64(x12, (arg1[6]), (arg2[6]));
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    let (x15, x16) = fiat_p521_scalar_subborrowx_u64(x14, (arg1[7]), (arg2[7]));
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    let (x17, x18) = fiat_p521_scalar_subborrowx_u64(x16, (arg1[8]), (arg2[8]));
    let mut x19: u64 = 0;
    let (x19) = fiat_p521_scalar_cmovznz_u64(x18, (0x0 as u64), 0xffffffffffffffff);
    let mut x20: u64 = 0;
    let mut x21: fiat_p521_scalar_u1 = 0;
    let (x20, x21) = fiat_p521_scalar_addcarryx_u64(0x0, x1, (x19 & 0xbb6fb71e91386409));
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    let (x22, x23) = fiat_p521_scalar_addcarryx_u64(x21, x3, (x19 & 0x3bb5c9b8899c47ae));
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    let (x24, x25) = fiat_p521_scalar_addcarryx_u64(x23, x5, (x19 & 0x7fcc0148f709a5d0));
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    let (x26, x27) = fiat_p521_scalar_addcarryx_u64(x25, x7, (x19 & 0x51868783bf2f966b));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(x27, x9, (x19 & 0xfffffffffffffffa));
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x11, x19);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x13, x19);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x15, x19);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x17, (x19 & 0x1ff));
    out1[0] = x20;
    out1[1] = x22;
    out1[2] = x24;
    out1[3] = x26;
    out1[4] = x28;
    out1[5] = x30;
    out1[6] = x32;
    out1[7] = x34;
    out1[8] = x36;
    out1
}
#[doc = " The function fiat_p521_scalar_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_opp(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    let (x1, x2) = fiat_p521_scalar_subborrowx_u64(0x0, (0x0 as u64), (arg1[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p521_scalar_u1 = 0;
    let (x3, x4) = fiat_p521_scalar_subborrowx_u64(x2, (0x0 as u64), (arg1[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p521_scalar_u1 = 0;
    let (x5, x6) = fiat_p521_scalar_subborrowx_u64(x4, (0x0 as u64), (arg1[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p521_scalar_u1 = 0;
    let (x7, x8) = fiat_p521_scalar_subborrowx_u64(x6, (0x0 as u64), (arg1[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p521_scalar_u1 = 0;
    let (x9, x10) = fiat_p521_scalar_subborrowx_u64(x8, (0x0 as u64), (arg1[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p521_scalar_u1 = 0;
    let (x11, x12) = fiat_p521_scalar_subborrowx_u64(x10, (0x0 as u64), (arg1[5]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p521_scalar_u1 = 0;
    let (x13, x14) = fiat_p521_scalar_subborrowx_u64(x12, (0x0 as u64), (arg1[6]));
    let mut x15: u64 = 0;
    let mut x16: fiat_p521_scalar_u1 = 0;
    let (x15, x16) = fiat_p521_scalar_subborrowx_u64(x14, (0x0 as u64), (arg1[7]));
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    let (x17, x18) = fiat_p521_scalar_subborrowx_u64(x16, (0x0 as u64), (arg1[8]));
    let mut x19: u64 = 0;
    let (x19) = fiat_p521_scalar_cmovznz_u64(x18, (0x0 as u64), 0xffffffffffffffff);
    let mut x20: u64 = 0;
    let mut x21: fiat_p521_scalar_u1 = 0;
    let (x20, x21) = fiat_p521_scalar_addcarryx_u64(0x0, x1, (x19 & 0xbb6fb71e91386409));
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    let (x22, x23) = fiat_p521_scalar_addcarryx_u64(x21, x3, (x19 & 0x3bb5c9b8899c47ae));
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    let (x24, x25) = fiat_p521_scalar_addcarryx_u64(x23, x5, (x19 & 0x7fcc0148f709a5d0));
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    let (x26, x27) = fiat_p521_scalar_addcarryx_u64(x25, x7, (x19 & 0x51868783bf2f966b));
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(x27, x9, (x19 & 0xfffffffffffffffa));
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x11, x19);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x13, x19);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x15, x19);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x17, (x19 & 0x1ff));
    out1[0] = x20;
    out1[1] = x22;
    out1[2] = x24;
    out1[3] = x26;
    out1[4] = x28;
    out1[5] = x30;
    out1[6] = x32;
    out1[7] = x34;
    out1[8] = x36;
    out1
}
#[doc = " The function fiat_p521_scalar_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^9) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_from_montgomery(
    arg1: &fiat_p521_scalar_montgomery_domain_field_element,
) -> fiat_p521_scalar_non_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_non_montgomery_domain_field_element = [0; 9];
    let x1: u64 = (arg1[0]);
    let mut x2: u64 = 0;
    let mut x3: u64 = 0;
    let (x2, x3) = fiat_p521_scalar_mulx_u64(x1, 0x1d2f5ccd79a995c7);
    let mut x4: u64 = 0;
    let mut x5: u64 = 0;
    let (x4, x5) = fiat_p521_scalar_mulx_u64(x2, 0x1ff);
    let mut x6: u64 = 0;
    let mut x7: u64 = 0;
    let (x6, x7) = fiat_p521_scalar_mulx_u64(x2, 0xffffffffffffffff);
    let mut x8: u64 = 0;
    let mut x9: u64 = 0;
    let (x8, x9) = fiat_p521_scalar_mulx_u64(x2, 0xffffffffffffffff);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p521_scalar_mulx_u64(x2, 0xffffffffffffffff);
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    let (x12, x13) = fiat_p521_scalar_mulx_u64(x2, 0xfffffffffffffffa);
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    let (x14, x15) = fiat_p521_scalar_mulx_u64(x2, 0x51868783bf2f966b);
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    let (x16, x17) = fiat_p521_scalar_mulx_u64(x2, 0x7fcc0148f709a5d0);
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    let (x18, x19) = fiat_p521_scalar_mulx_u64(x2, 0x3bb5c9b8899c47ae);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p521_scalar_mulx_u64(x2, 0xbb6fb71e91386409);
    let mut x22: u64 = 0;
    let mut x23: fiat_p521_scalar_u1 = 0;
    let (x22, x23) = fiat_p521_scalar_addcarryx_u64(0x0, x21, x18);
    let mut x24: u64 = 0;
    let mut x25: fiat_p521_scalar_u1 = 0;
    let (x24, x25) = fiat_p521_scalar_addcarryx_u64(x23, x19, x16);
    let mut x26: u64 = 0;
    let mut x27: fiat_p521_scalar_u1 = 0;
    let (x26, x27) = fiat_p521_scalar_addcarryx_u64(x25, x17, x14);
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(x27, x15, x12);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x13, x10);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x11, x8);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x9, x6);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x7, x4);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    let (x38, x39) = fiat_p521_scalar_addcarryx_u64(0x0, x1, x20);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    let (x40, x41) = fiat_p521_scalar_addcarryx_u64(x39, (0x0 as u64), x22);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    let (x42, x43) = fiat_p521_scalar_addcarryx_u64(x41, (0x0 as u64), x24);
    let mut x44: u64 = 0;
    let mut x45: fiat_p521_scalar_u1 = 0;
    let (x44, x45) = fiat_p521_scalar_addcarryx_u64(x43, (0x0 as u64), x26);
    let mut x46: u64 = 0;
    let mut x47: fiat_p521_scalar_u1 = 0;
    let (x46, x47) = fiat_p521_scalar_addcarryx_u64(x45, (0x0 as u64), x28);
    let mut x48: u64 = 0;
    let mut x49: fiat_p521_scalar_u1 = 0;
    let (x48, x49) = fiat_p521_scalar_addcarryx_u64(x47, (0x0 as u64), x30);
    let mut x50: u64 = 0;
    let mut x51: fiat_p521_scalar_u1 = 0;
    let (x50, x51) = fiat_p521_scalar_addcarryx_u64(x49, (0x0 as u64), x32);
    let mut x52: u64 = 0;
    let mut x53: fiat_p521_scalar_u1 = 0;
    let (x52, x53) = fiat_p521_scalar_addcarryx_u64(x51, (0x0 as u64), x34);
    let mut x54: u64 = 0;
    let mut x55: fiat_p521_scalar_u1 = 0;
    let (x54, x55) = fiat_p521_scalar_addcarryx_u64(x53, (0x0 as u64), x36);
    let mut x56: u64 = 0;
    let mut x57: fiat_p521_scalar_u1 = 0;
    let (x56, x57) = fiat_p521_scalar_addcarryx_u64(0x0, x40, (arg1[1]));
    let mut x58: u64 = 0;
    let mut x59: fiat_p521_scalar_u1 = 0;
    let (x58, x59) = fiat_p521_scalar_addcarryx_u64(x57, x42, (0x0 as u64));
    let mut x60: u64 = 0;
    let mut x61: fiat_p521_scalar_u1 = 0;
    let (x60, x61) = fiat_p521_scalar_addcarryx_u64(x59, x44, (0x0 as u64));
    let mut x62: u64 = 0;
    let mut x63: fiat_p521_scalar_u1 = 0;
    let (x62, x63) = fiat_p521_scalar_addcarryx_u64(x61, x46, (0x0 as u64));
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    let (x64, x65) = fiat_p521_scalar_addcarryx_u64(x63, x48, (0x0 as u64));
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    let (x66, x67) = fiat_p521_scalar_addcarryx_u64(x65, x50, (0x0 as u64));
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    let (x68, x69) = fiat_p521_scalar_addcarryx_u64(x67, x52, (0x0 as u64));
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    let (x70, x71) = fiat_p521_scalar_addcarryx_u64(x69, x54, (0x0 as u64));
    let mut x72: u64 = 0;
    let mut x73: u64 = 0;
    let (x72, x73) = fiat_p521_scalar_mulx_u64(x56, 0x1d2f5ccd79a995c7);
    let mut x74: u64 = 0;
    let mut x75: u64 = 0;
    let (x74, x75) = fiat_p521_scalar_mulx_u64(x72, 0x1ff);
    let mut x76: u64 = 0;
    let mut x77: u64 = 0;
    let (x76, x77) = fiat_p521_scalar_mulx_u64(x72, 0xffffffffffffffff);
    let mut x78: u64 = 0;
    let mut x79: u64 = 0;
    let (x78, x79) = fiat_p521_scalar_mulx_u64(x72, 0xffffffffffffffff);
    let mut x80: u64 = 0;
    let mut x81: u64 = 0;
    let (x80, x81) = fiat_p521_scalar_mulx_u64(x72, 0xffffffffffffffff);
    let mut x82: u64 = 0;
    let mut x83: u64 = 0;
    let (x82, x83) = fiat_p521_scalar_mulx_u64(x72, 0xfffffffffffffffa);
    let mut x84: u64 = 0;
    let mut x85: u64 = 0;
    let (x84, x85) = fiat_p521_scalar_mulx_u64(x72, 0x51868783bf2f966b);
    let mut x86: u64 = 0;
    let mut x87: u64 = 0;
    let (x86, x87) = fiat_p521_scalar_mulx_u64(x72, 0x7fcc0148f709a5d0);
    let mut x88: u64 = 0;
    let mut x89: u64 = 0;
    let (x88, x89) = fiat_p521_scalar_mulx_u64(x72, 0x3bb5c9b8899c47ae);
    let mut x90: u64 = 0;
    let mut x91: u64 = 0;
    let (x90, x91) = fiat_p521_scalar_mulx_u64(x72, 0xbb6fb71e91386409);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    let (x92, x93) = fiat_p521_scalar_addcarryx_u64(0x0, x91, x88);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    let (x94, x95) = fiat_p521_scalar_addcarryx_u64(x93, x89, x86);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    let (x96, x97) = fiat_p521_scalar_addcarryx_u64(x95, x87, x84);
    let mut x98: u64 = 0;
    let mut x99: fiat_p521_scalar_u1 = 0;
    let (x98, x99) = fiat_p521_scalar_addcarryx_u64(x97, x85, x82);
    let mut x100: u64 = 0;
    let mut x101: fiat_p521_scalar_u1 = 0;
    let (x100, x101) = fiat_p521_scalar_addcarryx_u64(x99, x83, x80);
    let mut x102: u64 = 0;
    let mut x103: fiat_p521_scalar_u1 = 0;
    let (x102, x103) = fiat_p521_scalar_addcarryx_u64(x101, x81, x78);
    let mut x104: u64 = 0;
    let mut x105: fiat_p521_scalar_u1 = 0;
    let (x104, x105) = fiat_p521_scalar_addcarryx_u64(x103, x79, x76);
    let mut x106: u64 = 0;
    let mut x107: fiat_p521_scalar_u1 = 0;
    let (x106, x107) = fiat_p521_scalar_addcarryx_u64(x105, x77, x74);
    let mut x108: u64 = 0;
    let mut x109: fiat_p521_scalar_u1 = 0;
    let (x108, x109) = fiat_p521_scalar_addcarryx_u64(0x0, x56, x90);
    let mut x110: u64 = 0;
    let mut x111: fiat_p521_scalar_u1 = 0;
    let (x110, x111) = fiat_p521_scalar_addcarryx_u64(x109, x58, x92);
    let mut x112: u64 = 0;
    let mut x113: fiat_p521_scalar_u1 = 0;
    let (x112, x113) = fiat_p521_scalar_addcarryx_u64(x111, x60, x94);
    let mut x114: u64 = 0;
    let mut x115: fiat_p521_scalar_u1 = 0;
    let (x114, x115) = fiat_p521_scalar_addcarryx_u64(x113, x62, x96);
    let mut x116: u64 = 0;
    let mut x117: fiat_p521_scalar_u1 = 0;
    let (x116, x117) = fiat_p521_scalar_addcarryx_u64(x115, x64, x98);
    let mut x118: u64 = 0;
    let mut x119: fiat_p521_scalar_u1 = 0;
    let (x118, x119) = fiat_p521_scalar_addcarryx_u64(x117, x66, x100);
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    let (x120, x121) = fiat_p521_scalar_addcarryx_u64(x119, x68, x102);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    let (x122, x123) = fiat_p521_scalar_addcarryx_u64(x121, x70, x104);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    let (x124, x125) = fiat_p521_scalar_addcarryx_u64(
        x123,
        ((x71 as u64) + ((x55 as u64) + ((x37 as u64) + x5))),
        x106,
    );
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    let (x126, x127) = fiat_p521_scalar_addcarryx_u64(0x0, x110, (arg1[2]));
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    let (x128, x129) = fiat_p521_scalar_addcarryx_u64(x127, x112, (0x0 as u64));
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    let (x130, x131) = fiat_p521_scalar_addcarryx_u64(x129, x114, (0x0 as u64));
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    let (x132, x133) = fiat_p521_scalar_addcarryx_u64(x131, x116, (0x0 as u64));
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    let (x134, x135) = fiat_p521_scalar_addcarryx_u64(x133, x118, (0x0 as u64));
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    let (x136, x137) = fiat_p521_scalar_addcarryx_u64(x135, x120, (0x0 as u64));
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    let (x138, x139) = fiat_p521_scalar_addcarryx_u64(x137, x122, (0x0 as u64));
    let mut x140: u64 = 0;
    let mut x141: fiat_p521_scalar_u1 = 0;
    let (x140, x141) = fiat_p521_scalar_addcarryx_u64(x139, x124, (0x0 as u64));
    let mut x142: u64 = 0;
    let mut x143: u64 = 0;
    let (x142, x143) = fiat_p521_scalar_mulx_u64(x126, 0x1d2f5ccd79a995c7);
    let mut x144: u64 = 0;
    let mut x145: u64 = 0;
    let (x144, x145) = fiat_p521_scalar_mulx_u64(x142, 0x1ff);
    let mut x146: u64 = 0;
    let mut x147: u64 = 0;
    let (x146, x147) = fiat_p521_scalar_mulx_u64(x142, 0xffffffffffffffff);
    let mut x148: u64 = 0;
    let mut x149: u64 = 0;
    let (x148, x149) = fiat_p521_scalar_mulx_u64(x142, 0xffffffffffffffff);
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    let (x150, x151) = fiat_p521_scalar_mulx_u64(x142, 0xffffffffffffffff);
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    let (x152, x153) = fiat_p521_scalar_mulx_u64(x142, 0xfffffffffffffffa);
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    let (x154, x155) = fiat_p521_scalar_mulx_u64(x142, 0x51868783bf2f966b);
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    let (x156, x157) = fiat_p521_scalar_mulx_u64(x142, 0x7fcc0148f709a5d0);
    let mut x158: u64 = 0;
    let mut x159: u64 = 0;
    let (x158, x159) = fiat_p521_scalar_mulx_u64(x142, 0x3bb5c9b8899c47ae);
    let mut x160: u64 = 0;
    let mut x161: u64 = 0;
    let (x160, x161) = fiat_p521_scalar_mulx_u64(x142, 0xbb6fb71e91386409);
    let mut x162: u64 = 0;
    let mut x163: fiat_p521_scalar_u1 = 0;
    let (x162, x163) = fiat_p521_scalar_addcarryx_u64(0x0, x161, x158);
    let mut x164: u64 = 0;
    let mut x165: fiat_p521_scalar_u1 = 0;
    let (x164, x165) = fiat_p521_scalar_addcarryx_u64(x163, x159, x156);
    let mut x166: u64 = 0;
    let mut x167: fiat_p521_scalar_u1 = 0;
    let (x166, x167) = fiat_p521_scalar_addcarryx_u64(x165, x157, x154);
    let mut x168: u64 = 0;
    let mut x169: fiat_p521_scalar_u1 = 0;
    let (x168, x169) = fiat_p521_scalar_addcarryx_u64(x167, x155, x152);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    let (x170, x171) = fiat_p521_scalar_addcarryx_u64(x169, x153, x150);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    let (x172, x173) = fiat_p521_scalar_addcarryx_u64(x171, x151, x148);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    let (x174, x175) = fiat_p521_scalar_addcarryx_u64(x173, x149, x146);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    let (x176, x177) = fiat_p521_scalar_addcarryx_u64(x175, x147, x144);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    let (x178, x179) = fiat_p521_scalar_addcarryx_u64(0x0, x126, x160);
    let mut x180: u64 = 0;
    let mut x181: fiat_p521_scalar_u1 = 0;
    let (x180, x181) = fiat_p521_scalar_addcarryx_u64(x179, x128, x162);
    let mut x182: u64 = 0;
    let mut x183: fiat_p521_scalar_u1 = 0;
    let (x182, x183) = fiat_p521_scalar_addcarryx_u64(x181, x130, x164);
    let mut x184: u64 = 0;
    let mut x185: fiat_p521_scalar_u1 = 0;
    let (x184, x185) = fiat_p521_scalar_addcarryx_u64(x183, x132, x166);
    let mut x186: u64 = 0;
    let mut x187: fiat_p521_scalar_u1 = 0;
    let (x186, x187) = fiat_p521_scalar_addcarryx_u64(x185, x134, x168);
    let mut x188: u64 = 0;
    let mut x189: fiat_p521_scalar_u1 = 0;
    let (x188, x189) = fiat_p521_scalar_addcarryx_u64(x187, x136, x170);
    let mut x190: u64 = 0;
    let mut x191: fiat_p521_scalar_u1 = 0;
    let (x190, x191) = fiat_p521_scalar_addcarryx_u64(x189, x138, x172);
    let mut x192: u64 = 0;
    let mut x193: fiat_p521_scalar_u1 = 0;
    let (x192, x193) = fiat_p521_scalar_addcarryx_u64(x191, x140, x174);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    let (x194, x195) = fiat_p521_scalar_addcarryx_u64(
        x193,
        ((x141 as u64) + ((x125 as u64) + ((x107 as u64) + x75))),
        x176,
    );
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    let (x196, x197) = fiat_p521_scalar_addcarryx_u64(0x0, x180, (arg1[3]));
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    let (x198, x199) = fiat_p521_scalar_addcarryx_u64(x197, x182, (0x0 as u64));
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    let (x200, x201) = fiat_p521_scalar_addcarryx_u64(x199, x184, (0x0 as u64));
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    let (x202, x203) = fiat_p521_scalar_addcarryx_u64(x201, x186, (0x0 as u64));
    let mut x204: u64 = 0;
    let mut x205: fiat_p521_scalar_u1 = 0;
    let (x204, x205) = fiat_p521_scalar_addcarryx_u64(x203, x188, (0x0 as u64));
    let mut x206: u64 = 0;
    let mut x207: fiat_p521_scalar_u1 = 0;
    let (x206, x207) = fiat_p521_scalar_addcarryx_u64(x205, x190, (0x0 as u64));
    let mut x208: u64 = 0;
    let mut x209: fiat_p521_scalar_u1 = 0;
    let (x208, x209) = fiat_p521_scalar_addcarryx_u64(x207, x192, (0x0 as u64));
    let mut x210: u64 = 0;
    let mut x211: fiat_p521_scalar_u1 = 0;
    let (x210, x211) = fiat_p521_scalar_addcarryx_u64(x209, x194, (0x0 as u64));
    let mut x212: u64 = 0;
    let mut x213: u64 = 0;
    let (x212, x213) = fiat_p521_scalar_mulx_u64(x196, 0x1d2f5ccd79a995c7);
    let mut x214: u64 = 0;
    let mut x215: u64 = 0;
    let (x214, x215) = fiat_p521_scalar_mulx_u64(x212, 0x1ff);
    let mut x216: u64 = 0;
    let mut x217: u64 = 0;
    let (x216, x217) = fiat_p521_scalar_mulx_u64(x212, 0xffffffffffffffff);
    let mut x218: u64 = 0;
    let mut x219: u64 = 0;
    let (x218, x219) = fiat_p521_scalar_mulx_u64(x212, 0xffffffffffffffff);
    let mut x220: u64 = 0;
    let mut x221: u64 = 0;
    let (x220, x221) = fiat_p521_scalar_mulx_u64(x212, 0xffffffffffffffff);
    let mut x222: u64 = 0;
    let mut x223: u64 = 0;
    let (x222, x223) = fiat_p521_scalar_mulx_u64(x212, 0xfffffffffffffffa);
    let mut x224: u64 = 0;
    let mut x225: u64 = 0;
    let (x224, x225) = fiat_p521_scalar_mulx_u64(x212, 0x51868783bf2f966b);
    let mut x226: u64 = 0;
    let mut x227: u64 = 0;
    let (x226, x227) = fiat_p521_scalar_mulx_u64(x212, 0x7fcc0148f709a5d0);
    let mut x228: u64 = 0;
    let mut x229: u64 = 0;
    let (x228, x229) = fiat_p521_scalar_mulx_u64(x212, 0x3bb5c9b8899c47ae);
    let mut x230: u64 = 0;
    let mut x231: u64 = 0;
    let (x230, x231) = fiat_p521_scalar_mulx_u64(x212, 0xbb6fb71e91386409);
    let mut x232: u64 = 0;
    let mut x233: fiat_p521_scalar_u1 = 0;
    let (x232, x233) = fiat_p521_scalar_addcarryx_u64(0x0, x231, x228);
    let mut x234: u64 = 0;
    let mut x235: fiat_p521_scalar_u1 = 0;
    let (x234, x235) = fiat_p521_scalar_addcarryx_u64(x233, x229, x226);
    let mut x236: u64 = 0;
    let mut x237: fiat_p521_scalar_u1 = 0;
    let (x236, x237) = fiat_p521_scalar_addcarryx_u64(x235, x227, x224);
    let mut x238: u64 = 0;
    let mut x239: fiat_p521_scalar_u1 = 0;
    let (x238, x239) = fiat_p521_scalar_addcarryx_u64(x237, x225, x222);
    let mut x240: u64 = 0;
    let mut x241: fiat_p521_scalar_u1 = 0;
    let (x240, x241) = fiat_p521_scalar_addcarryx_u64(x239, x223, x220);
    let mut x242: u64 = 0;
    let mut x243: fiat_p521_scalar_u1 = 0;
    let (x242, x243) = fiat_p521_scalar_addcarryx_u64(x241, x221, x218);
    let mut x244: u64 = 0;
    let mut x245: fiat_p521_scalar_u1 = 0;
    let (x244, x245) = fiat_p521_scalar_addcarryx_u64(x243, x219, x216);
    let mut x246: u64 = 0;
    let mut x247: fiat_p521_scalar_u1 = 0;
    let (x246, x247) = fiat_p521_scalar_addcarryx_u64(x245, x217, x214);
    let mut x248: u64 = 0;
    let mut x249: fiat_p521_scalar_u1 = 0;
    let (x248, x249) = fiat_p521_scalar_addcarryx_u64(0x0, x196, x230);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    let (x250, x251) = fiat_p521_scalar_addcarryx_u64(x249, x198, x232);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    let (x252, x253) = fiat_p521_scalar_addcarryx_u64(x251, x200, x234);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    let (x254, x255) = fiat_p521_scalar_addcarryx_u64(x253, x202, x236);
    let mut x256: u64 = 0;
    let mut x257: fiat_p521_scalar_u1 = 0;
    let (x256, x257) = fiat_p521_scalar_addcarryx_u64(x255, x204, x238);
    let mut x258: u64 = 0;
    let mut x259: fiat_p521_scalar_u1 = 0;
    let (x258, x259) = fiat_p521_scalar_addcarryx_u64(x257, x206, x240);
    let mut x260: u64 = 0;
    let mut x261: fiat_p521_scalar_u1 = 0;
    let (x260, x261) = fiat_p521_scalar_addcarryx_u64(x259, x208, x242);
    let mut x262: u64 = 0;
    let mut x263: fiat_p521_scalar_u1 = 0;
    let (x262, x263) = fiat_p521_scalar_addcarryx_u64(x261, x210, x244);
    let mut x264: u64 = 0;
    let mut x265: fiat_p521_scalar_u1 = 0;
    let (x264, x265) = fiat_p521_scalar_addcarryx_u64(
        x263,
        ((x211 as u64) + ((x195 as u64) + ((x177 as u64) + x145))),
        x246,
    );
    let mut x266: u64 = 0;
    let mut x267: fiat_p521_scalar_u1 = 0;
    let (x266, x267) = fiat_p521_scalar_addcarryx_u64(0x0, x250, (arg1[4]));
    let mut x268: u64 = 0;
    let mut x269: fiat_p521_scalar_u1 = 0;
    let (x268, x269) = fiat_p521_scalar_addcarryx_u64(x267, x252, (0x0 as u64));
    let mut x270: u64 = 0;
    let mut x271: fiat_p521_scalar_u1 = 0;
    let (x270, x271) = fiat_p521_scalar_addcarryx_u64(x269, x254, (0x0 as u64));
    let mut x272: u64 = 0;
    let mut x273: fiat_p521_scalar_u1 = 0;
    let (x272, x273) = fiat_p521_scalar_addcarryx_u64(x271, x256, (0x0 as u64));
    let mut x274: u64 = 0;
    let mut x275: fiat_p521_scalar_u1 = 0;
    let (x274, x275) = fiat_p521_scalar_addcarryx_u64(x273, x258, (0x0 as u64));
    let mut x276: u64 = 0;
    let mut x277: fiat_p521_scalar_u1 = 0;
    let (x276, x277) = fiat_p521_scalar_addcarryx_u64(x275, x260, (0x0 as u64));
    let mut x278: u64 = 0;
    let mut x279: fiat_p521_scalar_u1 = 0;
    let (x278, x279) = fiat_p521_scalar_addcarryx_u64(x277, x262, (0x0 as u64));
    let mut x280: u64 = 0;
    let mut x281: fiat_p521_scalar_u1 = 0;
    let (x280, x281) = fiat_p521_scalar_addcarryx_u64(x279, x264, (0x0 as u64));
    let mut x282: u64 = 0;
    let mut x283: u64 = 0;
    let (x282, x283) = fiat_p521_scalar_mulx_u64(x266, 0x1d2f5ccd79a995c7);
    let mut x284: u64 = 0;
    let mut x285: u64 = 0;
    let (x284, x285) = fiat_p521_scalar_mulx_u64(x282, 0x1ff);
    let mut x286: u64 = 0;
    let mut x287: u64 = 0;
    let (x286, x287) = fiat_p521_scalar_mulx_u64(x282, 0xffffffffffffffff);
    let mut x288: u64 = 0;
    let mut x289: u64 = 0;
    let (x288, x289) = fiat_p521_scalar_mulx_u64(x282, 0xffffffffffffffff);
    let mut x290: u64 = 0;
    let mut x291: u64 = 0;
    let (x290, x291) = fiat_p521_scalar_mulx_u64(x282, 0xffffffffffffffff);
    let mut x292: u64 = 0;
    let mut x293: u64 = 0;
    let (x292, x293) = fiat_p521_scalar_mulx_u64(x282, 0xfffffffffffffffa);
    let mut x294: u64 = 0;
    let mut x295: u64 = 0;
    let (x294, x295) = fiat_p521_scalar_mulx_u64(x282, 0x51868783bf2f966b);
    let mut x296: u64 = 0;
    let mut x297: u64 = 0;
    let (x296, x297) = fiat_p521_scalar_mulx_u64(x282, 0x7fcc0148f709a5d0);
    let mut x298: u64 = 0;
    let mut x299: u64 = 0;
    let (x298, x299) = fiat_p521_scalar_mulx_u64(x282, 0x3bb5c9b8899c47ae);
    let mut x300: u64 = 0;
    let mut x301: u64 = 0;
    let (x300, x301) = fiat_p521_scalar_mulx_u64(x282, 0xbb6fb71e91386409);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    let (x302, x303) = fiat_p521_scalar_addcarryx_u64(0x0, x301, x298);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    let (x304, x305) = fiat_p521_scalar_addcarryx_u64(x303, x299, x296);
    let mut x306: u64 = 0;
    let mut x307: fiat_p521_scalar_u1 = 0;
    let (x306, x307) = fiat_p521_scalar_addcarryx_u64(x305, x297, x294);
    let mut x308: u64 = 0;
    let mut x309: fiat_p521_scalar_u1 = 0;
    let (x308, x309) = fiat_p521_scalar_addcarryx_u64(x307, x295, x292);
    let mut x310: u64 = 0;
    let mut x311: fiat_p521_scalar_u1 = 0;
    let (x310, x311) = fiat_p521_scalar_addcarryx_u64(x309, x293, x290);
    let mut x312: u64 = 0;
    let mut x313: fiat_p521_scalar_u1 = 0;
    let (x312, x313) = fiat_p521_scalar_addcarryx_u64(x311, x291, x288);
    let mut x314: u64 = 0;
    let mut x315: fiat_p521_scalar_u1 = 0;
    let (x314, x315) = fiat_p521_scalar_addcarryx_u64(x313, x289, x286);
    let mut x316: u64 = 0;
    let mut x317: fiat_p521_scalar_u1 = 0;
    let (x316, x317) = fiat_p521_scalar_addcarryx_u64(x315, x287, x284);
    let mut x318: u64 = 0;
    let mut x319: fiat_p521_scalar_u1 = 0;
    let (x318, x319) = fiat_p521_scalar_addcarryx_u64(0x0, x266, x300);
    let mut x320: u64 = 0;
    let mut x321: fiat_p521_scalar_u1 = 0;
    let (x320, x321) = fiat_p521_scalar_addcarryx_u64(x319, x268, x302);
    let mut x322: u64 = 0;
    let mut x323: fiat_p521_scalar_u1 = 0;
    let (x322, x323) = fiat_p521_scalar_addcarryx_u64(x321, x270, x304);
    let mut x324: u64 = 0;
    let mut x325: fiat_p521_scalar_u1 = 0;
    let (x324, x325) = fiat_p521_scalar_addcarryx_u64(x323, x272, x306);
    let mut x326: u64 = 0;
    let mut x327: fiat_p521_scalar_u1 = 0;
    let (x326, x327) = fiat_p521_scalar_addcarryx_u64(x325, x274, x308);
    let mut x328: u64 = 0;
    let mut x329: fiat_p521_scalar_u1 = 0;
    let (x328, x329) = fiat_p521_scalar_addcarryx_u64(x327, x276, x310);
    let mut x330: u64 = 0;
    let mut x331: fiat_p521_scalar_u1 = 0;
    let (x330, x331) = fiat_p521_scalar_addcarryx_u64(x329, x278, x312);
    let mut x332: u64 = 0;
    let mut x333: fiat_p521_scalar_u1 = 0;
    let (x332, x333) = fiat_p521_scalar_addcarryx_u64(x331, x280, x314);
    let mut x334: u64 = 0;
    let mut x335: fiat_p521_scalar_u1 = 0;
    let (x334, x335) = fiat_p521_scalar_addcarryx_u64(
        x333,
        ((x281 as u64) + ((x265 as u64) + ((x247 as u64) + x215))),
        x316,
    );
    let mut x336: u64 = 0;
    let mut x337: fiat_p521_scalar_u1 = 0;
    let (x336, x337) = fiat_p521_scalar_addcarryx_u64(0x0, x320, (arg1[5]));
    let mut x338: u64 = 0;
    let mut x339: fiat_p521_scalar_u1 = 0;
    let (x338, x339) = fiat_p521_scalar_addcarryx_u64(x337, x322, (0x0 as u64));
    let mut x340: u64 = 0;
    let mut x341: fiat_p521_scalar_u1 = 0;
    let (x340, x341) = fiat_p521_scalar_addcarryx_u64(x339, x324, (0x0 as u64));
    let mut x342: u64 = 0;
    let mut x343: fiat_p521_scalar_u1 = 0;
    let (x342, x343) = fiat_p521_scalar_addcarryx_u64(x341, x326, (0x0 as u64));
    let mut x344: u64 = 0;
    let mut x345: fiat_p521_scalar_u1 = 0;
    let (x344, x345) = fiat_p521_scalar_addcarryx_u64(x343, x328, (0x0 as u64));
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    let (x346, x347) = fiat_p521_scalar_addcarryx_u64(x345, x330, (0x0 as u64));
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    let (x348, x349) = fiat_p521_scalar_addcarryx_u64(x347, x332, (0x0 as u64));
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    let (x350, x351) = fiat_p521_scalar_addcarryx_u64(x349, x334, (0x0 as u64));
    let mut x352: u64 = 0;
    let mut x353: u64 = 0;
    let (x352, x353) = fiat_p521_scalar_mulx_u64(x336, 0x1d2f5ccd79a995c7);
    let mut x354: u64 = 0;
    let mut x355: u64 = 0;
    let (x354, x355) = fiat_p521_scalar_mulx_u64(x352, 0x1ff);
    let mut x356: u64 = 0;
    let mut x357: u64 = 0;
    let (x356, x357) = fiat_p521_scalar_mulx_u64(x352, 0xffffffffffffffff);
    let mut x358: u64 = 0;
    let mut x359: u64 = 0;
    let (x358, x359) = fiat_p521_scalar_mulx_u64(x352, 0xffffffffffffffff);
    let mut x360: u64 = 0;
    let mut x361: u64 = 0;
    let (x360, x361) = fiat_p521_scalar_mulx_u64(x352, 0xffffffffffffffff);
    let mut x362: u64 = 0;
    let mut x363: u64 = 0;
    let (x362, x363) = fiat_p521_scalar_mulx_u64(x352, 0xfffffffffffffffa);
    let mut x364: u64 = 0;
    let mut x365: u64 = 0;
    let (x364, x365) = fiat_p521_scalar_mulx_u64(x352, 0x51868783bf2f966b);
    let mut x366: u64 = 0;
    let mut x367: u64 = 0;
    let (x366, x367) = fiat_p521_scalar_mulx_u64(x352, 0x7fcc0148f709a5d0);
    let mut x368: u64 = 0;
    let mut x369: u64 = 0;
    let (x368, x369) = fiat_p521_scalar_mulx_u64(x352, 0x3bb5c9b8899c47ae);
    let mut x370: u64 = 0;
    let mut x371: u64 = 0;
    let (x370, x371) = fiat_p521_scalar_mulx_u64(x352, 0xbb6fb71e91386409);
    let mut x372: u64 = 0;
    let mut x373: fiat_p521_scalar_u1 = 0;
    let (x372, x373) = fiat_p521_scalar_addcarryx_u64(0x0, x371, x368);
    let mut x374: u64 = 0;
    let mut x375: fiat_p521_scalar_u1 = 0;
    let (x374, x375) = fiat_p521_scalar_addcarryx_u64(x373, x369, x366);
    let mut x376: u64 = 0;
    let mut x377: fiat_p521_scalar_u1 = 0;
    let (x376, x377) = fiat_p521_scalar_addcarryx_u64(x375, x367, x364);
    let mut x378: u64 = 0;
    let mut x379: fiat_p521_scalar_u1 = 0;
    let (x378, x379) = fiat_p521_scalar_addcarryx_u64(x377, x365, x362);
    let mut x380: u64 = 0;
    let mut x381: fiat_p521_scalar_u1 = 0;
    let (x380, x381) = fiat_p521_scalar_addcarryx_u64(x379, x363, x360);
    let mut x382: u64 = 0;
    let mut x383: fiat_p521_scalar_u1 = 0;
    let (x382, x383) = fiat_p521_scalar_addcarryx_u64(x381, x361, x358);
    let mut x384: u64 = 0;
    let mut x385: fiat_p521_scalar_u1 = 0;
    let (x384, x385) = fiat_p521_scalar_addcarryx_u64(x383, x359, x356);
    let mut x386: u64 = 0;
    let mut x387: fiat_p521_scalar_u1 = 0;
    let (x386, x387) = fiat_p521_scalar_addcarryx_u64(x385, x357, x354);
    let mut x388: u64 = 0;
    let mut x389: fiat_p521_scalar_u1 = 0;
    let (x388, x389) = fiat_p521_scalar_addcarryx_u64(0x0, x336, x370);
    let mut x390: u64 = 0;
    let mut x391: fiat_p521_scalar_u1 = 0;
    let (x390, x391) = fiat_p521_scalar_addcarryx_u64(x389, x338, x372);
    let mut x392: u64 = 0;
    let mut x393: fiat_p521_scalar_u1 = 0;
    let (x392, x393) = fiat_p521_scalar_addcarryx_u64(x391, x340, x374);
    let mut x394: u64 = 0;
    let mut x395: fiat_p521_scalar_u1 = 0;
    let (x394, x395) = fiat_p521_scalar_addcarryx_u64(x393, x342, x376);
    let mut x396: u64 = 0;
    let mut x397: fiat_p521_scalar_u1 = 0;
    let (x396, x397) = fiat_p521_scalar_addcarryx_u64(x395, x344, x378);
    let mut x398: u64 = 0;
    let mut x399: fiat_p521_scalar_u1 = 0;
    let (x398, x399) = fiat_p521_scalar_addcarryx_u64(x397, x346, x380);
    let mut x400: u64 = 0;
    let mut x401: fiat_p521_scalar_u1 = 0;
    let (x400, x401) = fiat_p521_scalar_addcarryx_u64(x399, x348, x382);
    let mut x402: u64 = 0;
    let mut x403: fiat_p521_scalar_u1 = 0;
    let (x402, x403) = fiat_p521_scalar_addcarryx_u64(x401, x350, x384);
    let mut x404: u64 = 0;
    let mut x405: fiat_p521_scalar_u1 = 0;
    let (x404, x405) = fiat_p521_scalar_addcarryx_u64(
        x403,
        ((x351 as u64) + ((x335 as u64) + ((x317 as u64) + x285))),
        x386,
    );
    let mut x406: u64 = 0;
    let mut x407: fiat_p521_scalar_u1 = 0;
    let (x406, x407) = fiat_p521_scalar_addcarryx_u64(0x0, x390, (arg1[6]));
    let mut x408: u64 = 0;
    let mut x409: fiat_p521_scalar_u1 = 0;
    let (x408, x409) = fiat_p521_scalar_addcarryx_u64(x407, x392, (0x0 as u64));
    let mut x410: u64 = 0;
    let mut x411: fiat_p521_scalar_u1 = 0;
    let (x410, x411) = fiat_p521_scalar_addcarryx_u64(x409, x394, (0x0 as u64));
    let mut x412: u64 = 0;
    let mut x413: fiat_p521_scalar_u1 = 0;
    let (x412, x413) = fiat_p521_scalar_addcarryx_u64(x411, x396, (0x0 as u64));
    let mut x414: u64 = 0;
    let mut x415: fiat_p521_scalar_u1 = 0;
    let (x414, x415) = fiat_p521_scalar_addcarryx_u64(x413, x398, (0x0 as u64));
    let mut x416: u64 = 0;
    let mut x417: fiat_p521_scalar_u1 = 0;
    let (x416, x417) = fiat_p521_scalar_addcarryx_u64(x415, x400, (0x0 as u64));
    let mut x418: u64 = 0;
    let mut x419: fiat_p521_scalar_u1 = 0;
    let (x418, x419) = fiat_p521_scalar_addcarryx_u64(x417, x402, (0x0 as u64));
    let mut x420: u64 = 0;
    let mut x421: fiat_p521_scalar_u1 = 0;
    let (x420, x421) = fiat_p521_scalar_addcarryx_u64(x419, x404, (0x0 as u64));
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    let (x422, x423) = fiat_p521_scalar_mulx_u64(x406, 0x1d2f5ccd79a995c7);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    let (x424, x425) = fiat_p521_scalar_mulx_u64(x422, 0x1ff);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    let (x426, x427) = fiat_p521_scalar_mulx_u64(x422, 0xffffffffffffffff);
    let mut x428: u64 = 0;
    let mut x429: u64 = 0;
    let (x428, x429) = fiat_p521_scalar_mulx_u64(x422, 0xffffffffffffffff);
    let mut x430: u64 = 0;
    let mut x431: u64 = 0;
    let (x430, x431) = fiat_p521_scalar_mulx_u64(x422, 0xffffffffffffffff);
    let mut x432: u64 = 0;
    let mut x433: u64 = 0;
    let (x432, x433) = fiat_p521_scalar_mulx_u64(x422, 0xfffffffffffffffa);
    let mut x434: u64 = 0;
    let mut x435: u64 = 0;
    let (x434, x435) = fiat_p521_scalar_mulx_u64(x422, 0x51868783bf2f966b);
    let mut x436: u64 = 0;
    let mut x437: u64 = 0;
    let (x436, x437) = fiat_p521_scalar_mulx_u64(x422, 0x7fcc0148f709a5d0);
    let mut x438: u64 = 0;
    let mut x439: u64 = 0;
    let (x438, x439) = fiat_p521_scalar_mulx_u64(x422, 0x3bb5c9b8899c47ae);
    let mut x440: u64 = 0;
    let mut x441: u64 = 0;
    let (x440, x441) = fiat_p521_scalar_mulx_u64(x422, 0xbb6fb71e91386409);
    let mut x442: u64 = 0;
    let mut x443: fiat_p521_scalar_u1 = 0;
    let (x442, x443) = fiat_p521_scalar_addcarryx_u64(0x0, x441, x438);
    let mut x444: u64 = 0;
    let mut x445: fiat_p521_scalar_u1 = 0;
    let (x444, x445) = fiat_p521_scalar_addcarryx_u64(x443, x439, x436);
    let mut x446: u64 = 0;
    let mut x447: fiat_p521_scalar_u1 = 0;
    let (x446, x447) = fiat_p521_scalar_addcarryx_u64(x445, x437, x434);
    let mut x448: u64 = 0;
    let mut x449: fiat_p521_scalar_u1 = 0;
    let (x448, x449) = fiat_p521_scalar_addcarryx_u64(x447, x435, x432);
    let mut x450: u64 = 0;
    let mut x451: fiat_p521_scalar_u1 = 0;
    let (x450, x451) = fiat_p521_scalar_addcarryx_u64(x449, x433, x430);
    let mut x452: u64 = 0;
    let mut x453: fiat_p521_scalar_u1 = 0;
    let (x452, x453) = fiat_p521_scalar_addcarryx_u64(x451, x431, x428);
    let mut x454: u64 = 0;
    let mut x455: fiat_p521_scalar_u1 = 0;
    let (x454, x455) = fiat_p521_scalar_addcarryx_u64(x453, x429, x426);
    let mut x456: u64 = 0;
    let mut x457: fiat_p521_scalar_u1 = 0;
    let (x456, x457) = fiat_p521_scalar_addcarryx_u64(x455, x427, x424);
    let mut x458: u64 = 0;
    let mut x459: fiat_p521_scalar_u1 = 0;
    let (x458, x459) = fiat_p521_scalar_addcarryx_u64(0x0, x406, x440);
    let mut x460: u64 = 0;
    let mut x461: fiat_p521_scalar_u1 = 0;
    let (x460, x461) = fiat_p521_scalar_addcarryx_u64(x459, x408, x442);
    let mut x462: u64 = 0;
    let mut x463: fiat_p521_scalar_u1 = 0;
    let (x462, x463) = fiat_p521_scalar_addcarryx_u64(x461, x410, x444);
    let mut x464: u64 = 0;
    let mut x465: fiat_p521_scalar_u1 = 0;
    let (x464, x465) = fiat_p521_scalar_addcarryx_u64(x463, x412, x446);
    let mut x466: u64 = 0;
    let mut x467: fiat_p521_scalar_u1 = 0;
    let (x466, x467) = fiat_p521_scalar_addcarryx_u64(x465, x414, x448);
    let mut x468: u64 = 0;
    let mut x469: fiat_p521_scalar_u1 = 0;
    let (x468, x469) = fiat_p521_scalar_addcarryx_u64(x467, x416, x450);
    let mut x470: u64 = 0;
    let mut x471: fiat_p521_scalar_u1 = 0;
    let (x470, x471) = fiat_p521_scalar_addcarryx_u64(x469, x418, x452);
    let mut x472: u64 = 0;
    let mut x473: fiat_p521_scalar_u1 = 0;
    let (x472, x473) = fiat_p521_scalar_addcarryx_u64(x471, x420, x454);
    let mut x474: u64 = 0;
    let mut x475: fiat_p521_scalar_u1 = 0;
    let (x474, x475) = fiat_p521_scalar_addcarryx_u64(
        x473,
        ((x421 as u64) + ((x405 as u64) + ((x387 as u64) + x355))),
        x456,
    );
    let mut x476: u64 = 0;
    let mut x477: fiat_p521_scalar_u1 = 0;
    let (x476, x477) = fiat_p521_scalar_addcarryx_u64(0x0, x460, (arg1[7]));
    let mut x478: u64 = 0;
    let mut x479: fiat_p521_scalar_u1 = 0;
    let (x478, x479) = fiat_p521_scalar_addcarryx_u64(x477, x462, (0x0 as u64));
    let mut x480: u64 = 0;
    let mut x481: fiat_p521_scalar_u1 = 0;
    let (x480, x481) = fiat_p521_scalar_addcarryx_u64(x479, x464, (0x0 as u64));
    let mut x482: u64 = 0;
    let mut x483: fiat_p521_scalar_u1 = 0;
    let (x482, x483) = fiat_p521_scalar_addcarryx_u64(x481, x466, (0x0 as u64));
    let mut x484: u64 = 0;
    let mut x485: fiat_p521_scalar_u1 = 0;
    let (x484, x485) = fiat_p521_scalar_addcarryx_u64(x483, x468, (0x0 as u64));
    let mut x486: u64 = 0;
    let mut x487: fiat_p521_scalar_u1 = 0;
    let (x486, x487) = fiat_p521_scalar_addcarryx_u64(x485, x470, (0x0 as u64));
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    let (x488, x489) = fiat_p521_scalar_addcarryx_u64(x487, x472, (0x0 as u64));
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    let (x490, x491) = fiat_p521_scalar_addcarryx_u64(x489, x474, (0x0 as u64));
    let mut x492: u64 = 0;
    let mut x493: u64 = 0;
    let (x492, x493) = fiat_p521_scalar_mulx_u64(x476, 0x1d2f5ccd79a995c7);
    let mut x494: u64 = 0;
    let mut x495: u64 = 0;
    let (x494, x495) = fiat_p521_scalar_mulx_u64(x492, 0x1ff);
    let mut x496: u64 = 0;
    let mut x497: u64 = 0;
    let (x496, x497) = fiat_p521_scalar_mulx_u64(x492, 0xffffffffffffffff);
    let mut x498: u64 = 0;
    let mut x499: u64 = 0;
    let (x498, x499) = fiat_p521_scalar_mulx_u64(x492, 0xffffffffffffffff);
    let mut x500: u64 = 0;
    let mut x501: u64 = 0;
    let (x500, x501) = fiat_p521_scalar_mulx_u64(x492, 0xffffffffffffffff);
    let mut x502: u64 = 0;
    let mut x503: u64 = 0;
    let (x502, x503) = fiat_p521_scalar_mulx_u64(x492, 0xfffffffffffffffa);
    let mut x504: u64 = 0;
    let mut x505: u64 = 0;
    let (x504, x505) = fiat_p521_scalar_mulx_u64(x492, 0x51868783bf2f966b);
    let mut x506: u64 = 0;
    let mut x507: u64 = 0;
    let (x506, x507) = fiat_p521_scalar_mulx_u64(x492, 0x7fcc0148f709a5d0);
    let mut x508: u64 = 0;
    let mut x509: u64 = 0;
    let (x508, x509) = fiat_p521_scalar_mulx_u64(x492, 0x3bb5c9b8899c47ae);
    let mut x510: u64 = 0;
    let mut x511: u64 = 0;
    let (x510, x511) = fiat_p521_scalar_mulx_u64(x492, 0xbb6fb71e91386409);
    let mut x512: u64 = 0;
    let mut x513: fiat_p521_scalar_u1 = 0;
    let (x512, x513) = fiat_p521_scalar_addcarryx_u64(0x0, x511, x508);
    let mut x514: u64 = 0;
    let mut x515: fiat_p521_scalar_u1 = 0;
    let (x514, x515) = fiat_p521_scalar_addcarryx_u64(x513, x509, x506);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    let (x516, x517) = fiat_p521_scalar_addcarryx_u64(x515, x507, x504);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    let (x518, x519) = fiat_p521_scalar_addcarryx_u64(x517, x505, x502);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    let (x520, x521) = fiat_p521_scalar_addcarryx_u64(x519, x503, x500);
    let mut x522: u64 = 0;
    let mut x523: fiat_p521_scalar_u1 = 0;
    let (x522, x523) = fiat_p521_scalar_addcarryx_u64(x521, x501, x498);
    let mut x524: u64 = 0;
    let mut x525: fiat_p521_scalar_u1 = 0;
    let (x524, x525) = fiat_p521_scalar_addcarryx_u64(x523, x499, x496);
    let mut x526: u64 = 0;
    let mut x527: fiat_p521_scalar_u1 = 0;
    let (x526, x527) = fiat_p521_scalar_addcarryx_u64(x525, x497, x494);
    let mut x528: u64 = 0;
    let mut x529: fiat_p521_scalar_u1 = 0;
    let (x528, x529) = fiat_p521_scalar_addcarryx_u64(0x0, x476, x510);
    let mut x530: u64 = 0;
    let mut x531: fiat_p521_scalar_u1 = 0;
    let (x530, x531) = fiat_p521_scalar_addcarryx_u64(x529, x478, x512);
    let mut x532: u64 = 0;
    let mut x533: fiat_p521_scalar_u1 = 0;
    let (x532, x533) = fiat_p521_scalar_addcarryx_u64(x531, x480, x514);
    let mut x534: u64 = 0;
    let mut x535: fiat_p521_scalar_u1 = 0;
    let (x534, x535) = fiat_p521_scalar_addcarryx_u64(x533, x482, x516);
    let mut x536: u64 = 0;
    let mut x537: fiat_p521_scalar_u1 = 0;
    let (x536, x537) = fiat_p521_scalar_addcarryx_u64(x535, x484, x518);
    let mut x538: u64 = 0;
    let mut x539: fiat_p521_scalar_u1 = 0;
    let (x538, x539) = fiat_p521_scalar_addcarryx_u64(x537, x486, x520);
    let mut x540: u64 = 0;
    let mut x541: fiat_p521_scalar_u1 = 0;
    let (x540, x541) = fiat_p521_scalar_addcarryx_u64(x539, x488, x522);
    let mut x542: u64 = 0;
    let mut x543: fiat_p521_scalar_u1 = 0;
    let (x542, x543) = fiat_p521_scalar_addcarryx_u64(x541, x490, x524);
    let mut x544: u64 = 0;
    let mut x545: fiat_p521_scalar_u1 = 0;
    let (x544, x545) = fiat_p521_scalar_addcarryx_u64(
        x543,
        ((x491 as u64) + ((x475 as u64) + ((x457 as u64) + x425))),
        x526,
    );
    let mut x546: u64 = 0;
    let mut x547: fiat_p521_scalar_u1 = 0;
    let (x546, x547) = fiat_p521_scalar_addcarryx_u64(0x0, x530, (arg1[8]));
    let mut x548: u64 = 0;
    let mut x549: fiat_p521_scalar_u1 = 0;
    let (x548, x549) = fiat_p521_scalar_addcarryx_u64(x547, x532, (0x0 as u64));
    let mut x550: u64 = 0;
    let mut x551: fiat_p521_scalar_u1 = 0;
    let (x550, x551) = fiat_p521_scalar_addcarryx_u64(x549, x534, (0x0 as u64));
    let mut x552: u64 = 0;
    let mut x553: fiat_p521_scalar_u1 = 0;
    let (x552, x553) = fiat_p521_scalar_addcarryx_u64(x551, x536, (0x0 as u64));
    let mut x554: u64 = 0;
    let mut x555: fiat_p521_scalar_u1 = 0;
    let (x554, x555) = fiat_p521_scalar_addcarryx_u64(x553, x538, (0x0 as u64));
    let mut x556: u64 = 0;
    let mut x557: fiat_p521_scalar_u1 = 0;
    let (x556, x557) = fiat_p521_scalar_addcarryx_u64(x555, x540, (0x0 as u64));
    let mut x558: u64 = 0;
    let mut x559: fiat_p521_scalar_u1 = 0;
    let (x558, x559) = fiat_p521_scalar_addcarryx_u64(x557, x542, (0x0 as u64));
    let mut x560: u64 = 0;
    let mut x561: fiat_p521_scalar_u1 = 0;
    let (x560, x561) = fiat_p521_scalar_addcarryx_u64(x559, x544, (0x0 as u64));
    let mut x562: u64 = 0;
    let mut x563: u64 = 0;
    let (x562, x563) = fiat_p521_scalar_mulx_u64(x546, 0x1d2f5ccd79a995c7);
    let mut x564: u64 = 0;
    let mut x565: u64 = 0;
    let (x564, x565) = fiat_p521_scalar_mulx_u64(x562, 0x1ff);
    let mut x566: u64 = 0;
    let mut x567: u64 = 0;
    let (x566, x567) = fiat_p521_scalar_mulx_u64(x562, 0xffffffffffffffff);
    let mut x568: u64 = 0;
    let mut x569: u64 = 0;
    let (x568, x569) = fiat_p521_scalar_mulx_u64(x562, 0xffffffffffffffff);
    let mut x570: u64 = 0;
    let mut x571: u64 = 0;
    let (x570, x571) = fiat_p521_scalar_mulx_u64(x562, 0xffffffffffffffff);
    let mut x572: u64 = 0;
    let mut x573: u64 = 0;
    let (x572, x573) = fiat_p521_scalar_mulx_u64(x562, 0xfffffffffffffffa);
    let mut x574: u64 = 0;
    let mut x575: u64 = 0;
    let (x574, x575) = fiat_p521_scalar_mulx_u64(x562, 0x51868783bf2f966b);
    let mut x576: u64 = 0;
    let mut x577: u64 = 0;
    let (x576, x577) = fiat_p521_scalar_mulx_u64(x562, 0x7fcc0148f709a5d0);
    let mut x578: u64 = 0;
    let mut x579: u64 = 0;
    let (x578, x579) = fiat_p521_scalar_mulx_u64(x562, 0x3bb5c9b8899c47ae);
    let mut x580: u64 = 0;
    let mut x581: u64 = 0;
    let (x580, x581) = fiat_p521_scalar_mulx_u64(x562, 0xbb6fb71e91386409);
    let mut x582: u64 = 0;
    let mut x583: fiat_p521_scalar_u1 = 0;
    let (x582, x583) = fiat_p521_scalar_addcarryx_u64(0x0, x581, x578);
    let mut x584: u64 = 0;
    let mut x585: fiat_p521_scalar_u1 = 0;
    let (x584, x585) = fiat_p521_scalar_addcarryx_u64(x583, x579, x576);
    let mut x586: u64 = 0;
    let mut x587: fiat_p521_scalar_u1 = 0;
    let (x586, x587) = fiat_p521_scalar_addcarryx_u64(x585, x577, x574);
    let mut x588: u64 = 0;
    let mut x589: fiat_p521_scalar_u1 = 0;
    let (x588, x589) = fiat_p521_scalar_addcarryx_u64(x587, x575, x572);
    let mut x590: u64 = 0;
    let mut x591: fiat_p521_scalar_u1 = 0;
    let (x590, x591) = fiat_p521_scalar_addcarryx_u64(x589, x573, x570);
    let mut x592: u64 = 0;
    let mut x593: fiat_p521_scalar_u1 = 0;
    let (x592, x593) = fiat_p521_scalar_addcarryx_u64(x591, x571, x568);
    let mut x594: u64 = 0;
    let mut x595: fiat_p521_scalar_u1 = 0;
    let (x594, x595) = fiat_p521_scalar_addcarryx_u64(x593, x569, x566);
    let mut x596: u64 = 0;
    let mut x597: fiat_p521_scalar_u1 = 0;
    let (x596, x597) = fiat_p521_scalar_addcarryx_u64(x595, x567, x564);
    let mut x598: u64 = 0;
    let mut x599: fiat_p521_scalar_u1 = 0;
    let (x598, x599) = fiat_p521_scalar_addcarryx_u64(0x0, x546, x580);
    let mut x600: u64 = 0;
    let mut x601: fiat_p521_scalar_u1 = 0;
    let (x600, x601) = fiat_p521_scalar_addcarryx_u64(x599, x548, x582);
    let mut x602: u64 = 0;
    let mut x603: fiat_p521_scalar_u1 = 0;
    let (x602, x603) = fiat_p521_scalar_addcarryx_u64(x601, x550, x584);
    let mut x604: u64 = 0;
    let mut x605: fiat_p521_scalar_u1 = 0;
    let (x604, x605) = fiat_p521_scalar_addcarryx_u64(x603, x552, x586);
    let mut x606: u64 = 0;
    let mut x607: fiat_p521_scalar_u1 = 0;
    let (x606, x607) = fiat_p521_scalar_addcarryx_u64(x605, x554, x588);
    let mut x608: u64 = 0;
    let mut x609: fiat_p521_scalar_u1 = 0;
    let (x608, x609) = fiat_p521_scalar_addcarryx_u64(x607, x556, x590);
    let mut x610: u64 = 0;
    let mut x611: fiat_p521_scalar_u1 = 0;
    let (x610, x611) = fiat_p521_scalar_addcarryx_u64(x609, x558, x592);
    let mut x612: u64 = 0;
    let mut x613: fiat_p521_scalar_u1 = 0;
    let (x612, x613) = fiat_p521_scalar_addcarryx_u64(x611, x560, x594);
    let mut x614: u64 = 0;
    let mut x615: fiat_p521_scalar_u1 = 0;
    let (x614, x615) = fiat_p521_scalar_addcarryx_u64(
        x613,
        ((x561 as u64) + ((x545 as u64) + ((x527 as u64) + x495))),
        x596,
    );
    let x616: u64 = ((x615 as u64) + ((x597 as u64) + x565));
    let mut x617: u64 = 0;
    let mut x618: fiat_p521_scalar_u1 = 0;
    let (x617, x618) = fiat_p521_scalar_subborrowx_u64(0x0, x600, 0xbb6fb71e91386409);
    let mut x619: u64 = 0;
    let mut x620: fiat_p521_scalar_u1 = 0;
    let (x619, x620) = fiat_p521_scalar_subborrowx_u64(x618, x602, 0x3bb5c9b8899c47ae);
    let mut x621: u64 = 0;
    let mut x622: fiat_p521_scalar_u1 = 0;
    let (x621, x622) = fiat_p521_scalar_subborrowx_u64(x620, x604, 0x7fcc0148f709a5d0);
    let mut x623: u64 = 0;
    let mut x624: fiat_p521_scalar_u1 = 0;
    let (x623, x624) = fiat_p521_scalar_subborrowx_u64(x622, x606, 0x51868783bf2f966b);
    let mut x625: u64 = 0;
    let mut x626: fiat_p521_scalar_u1 = 0;
    let (x625, x626) = fiat_p521_scalar_subborrowx_u64(x624, x608, 0xfffffffffffffffa);
    let mut x627: u64 = 0;
    let mut x628: fiat_p521_scalar_u1 = 0;
    let (x627, x628) = fiat_p521_scalar_subborrowx_u64(x626, x610, 0xffffffffffffffff);
    let mut x629: u64 = 0;
    let mut x630: fiat_p521_scalar_u1 = 0;
    let (x629, x630) = fiat_p521_scalar_subborrowx_u64(x628, x612, 0xffffffffffffffff);
    let mut x631: u64 = 0;
    let mut x632: fiat_p521_scalar_u1 = 0;
    let (x631, x632) = fiat_p521_scalar_subborrowx_u64(x630, x614, 0xffffffffffffffff);
    let mut x633: u64 = 0;
    let mut x634: fiat_p521_scalar_u1 = 0;
    let (x633, x634) = fiat_p521_scalar_subborrowx_u64(x632, x616, 0x1ff);
    let mut x635: u64 = 0;
    let mut x636: fiat_p521_scalar_u1 = 0;
    let (x635, x636) = fiat_p521_scalar_subborrowx_u64(x634, (0x0 as u64), (0x0 as u64));
    let mut x637: u64 = 0;
    let (x637) = fiat_p521_scalar_cmovznz_u64(x636, x617, x600);
    let mut x638: u64 = 0;
    let (x638) = fiat_p521_scalar_cmovznz_u64(x636, x619, x602);
    let mut x639: u64 = 0;
    let (x639) = fiat_p521_scalar_cmovznz_u64(x636, x621, x604);
    let mut x640: u64 = 0;
    let (x640) = fiat_p521_scalar_cmovznz_u64(x636, x623, x606);
    let mut x641: u64 = 0;
    let (x641) = fiat_p521_scalar_cmovznz_u64(x636, x625, x608);
    let mut x642: u64 = 0;
    let (x642) = fiat_p521_scalar_cmovznz_u64(x636, x627, x610);
    let mut x643: u64 = 0;
    let (x643) = fiat_p521_scalar_cmovznz_u64(x636, x629, x612);
    let mut x644: u64 = 0;
    let (x644) = fiat_p521_scalar_cmovznz_u64(x636, x631, x614);
    let mut x645: u64 = 0;
    let (x645) = fiat_p521_scalar_cmovznz_u64(x636, x633, x616);
    out1[0] = x637;
    out1[1] = x638;
    out1[2] = x639;
    out1[3] = x640;
    out1[4] = x641;
    out1[5] = x642;
    out1[6] = x643;
    out1[7] = x644;
    out1[8] = x645;
    out1
}
#[doc = " The function fiat_p521_scalar_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_to_montgomery(
    arg1: &fiat_p521_scalar_non_montgomery_domain_field_element,
) -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[6]);
    let x7: u64 = (arg1[7]);
    let x8: u64 = (arg1[8]);
    let x9: u64 = (arg1[0]);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p521_scalar_mulx_u64(x9, 0x3d);
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    let (x12, x13) = fiat_p521_scalar_mulx_u64(x9, 0x2d8e03d1492d0d45);
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    let (x14, x15) = fiat_p521_scalar_mulx_u64(x9, 0x5bcc6d61a8e567bc);
    let mut x16: u64 = 0;
    let mut x17: u64 = 0;
    let (x16, x17) = fiat_p521_scalar_mulx_u64(x9, 0xcff3d142b7756e3e);
    let mut x18: u64 = 0;
    let mut x19: u64 = 0;
    let (x18, x19) = fiat_p521_scalar_mulx_u64(x9, 0xdd6e23d82e49c7db);
    let mut x20: u64 = 0;
    let mut x21: u64 = 0;
    let (x20, x21) = fiat_p521_scalar_mulx_u64(x9, 0xd3721ef557f75e06);
    let mut x22: u64 = 0;
    let mut x23: u64 = 0;
    let (x22, x23) = fiat_p521_scalar_mulx_u64(x9, 0x12a78d38794573ff);
    let mut x24: u64 = 0;
    let mut x25: u64 = 0;
    let (x24, x25) = fiat_p521_scalar_mulx_u64(x9, 0xf707badce5547ea3);
    let mut x26: u64 = 0;
    let mut x27: u64 = 0;
    let (x26, x27) = fiat_p521_scalar_mulx_u64(x9, 0x137cd04dcf15dd04);
    let mut x28: u64 = 0;
    let mut x29: fiat_p521_scalar_u1 = 0;
    let (x28, x29) = fiat_p521_scalar_addcarryx_u64(0x0, x27, x24);
    let mut x30: u64 = 0;
    let mut x31: fiat_p521_scalar_u1 = 0;
    let (x30, x31) = fiat_p521_scalar_addcarryx_u64(x29, x25, x22);
    let mut x32: u64 = 0;
    let mut x33: fiat_p521_scalar_u1 = 0;
    let (x32, x33) = fiat_p521_scalar_addcarryx_u64(x31, x23, x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p521_scalar_u1 = 0;
    let (x34, x35) = fiat_p521_scalar_addcarryx_u64(x33, x21, x18);
    let mut x36: u64 = 0;
    let mut x37: fiat_p521_scalar_u1 = 0;
    let (x36, x37) = fiat_p521_scalar_addcarryx_u64(x35, x19, x16);
    let mut x38: u64 = 0;
    let mut x39: fiat_p521_scalar_u1 = 0;
    let (x38, x39) = fiat_p521_scalar_addcarryx_u64(x37, x17, x14);
    let mut x40: u64 = 0;
    let mut x41: fiat_p521_scalar_u1 = 0;
    let (x40, x41) = fiat_p521_scalar_addcarryx_u64(x39, x15, x12);
    let mut x42: u64 = 0;
    let mut x43: fiat_p521_scalar_u1 = 0;
    let (x42, x43) = fiat_p521_scalar_addcarryx_u64(x41, x13, x10);
    let mut x44: u64 = 0;
    let mut x45: u64 = 0;
    let (x44, x45) = fiat_p521_scalar_mulx_u64(x26, 0x1d2f5ccd79a995c7);
    let mut x46: u64 = 0;
    let mut x47: u64 = 0;
    let (x46, x47) = fiat_p521_scalar_mulx_u64(x44, 0x1ff);
    let mut x48: u64 = 0;
    let mut x49: u64 = 0;
    let (x48, x49) = fiat_p521_scalar_mulx_u64(x44, 0xffffffffffffffff);
    let mut x50: u64 = 0;
    let mut x51: u64 = 0;
    let (x50, x51) = fiat_p521_scalar_mulx_u64(x44, 0xffffffffffffffff);
    let mut x52: u64 = 0;
    let mut x53: u64 = 0;
    let (x52, x53) = fiat_p521_scalar_mulx_u64(x44, 0xffffffffffffffff);
    let mut x54: u64 = 0;
    let mut x55: u64 = 0;
    let (x54, x55) = fiat_p521_scalar_mulx_u64(x44, 0xfffffffffffffffa);
    let mut x56: u64 = 0;
    let mut x57: u64 = 0;
    let (x56, x57) = fiat_p521_scalar_mulx_u64(x44, 0x51868783bf2f966b);
    let mut x58: u64 = 0;
    let mut x59: u64 = 0;
    let (x58, x59) = fiat_p521_scalar_mulx_u64(x44, 0x7fcc0148f709a5d0);
    let mut x60: u64 = 0;
    let mut x61: u64 = 0;
    let (x60, x61) = fiat_p521_scalar_mulx_u64(x44, 0x3bb5c9b8899c47ae);
    let mut x62: u64 = 0;
    let mut x63: u64 = 0;
    let (x62, x63) = fiat_p521_scalar_mulx_u64(x44, 0xbb6fb71e91386409);
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    let (x64, x65) = fiat_p521_scalar_addcarryx_u64(0x0, x63, x60);
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    let (x66, x67) = fiat_p521_scalar_addcarryx_u64(x65, x61, x58);
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    let (x68, x69) = fiat_p521_scalar_addcarryx_u64(x67, x59, x56);
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    let (x70, x71) = fiat_p521_scalar_addcarryx_u64(x69, x57, x54);
    let mut x72: u64 = 0;
    let mut x73: fiat_p521_scalar_u1 = 0;
    let (x72, x73) = fiat_p521_scalar_addcarryx_u64(x71, x55, x52);
    let mut x74: u64 = 0;
    let mut x75: fiat_p521_scalar_u1 = 0;
    let (x74, x75) = fiat_p521_scalar_addcarryx_u64(x73, x53, x50);
    let mut x76: u64 = 0;
    let mut x77: fiat_p521_scalar_u1 = 0;
    let (x76, x77) = fiat_p521_scalar_addcarryx_u64(x75, x51, x48);
    let mut x78: u64 = 0;
    let mut x79: fiat_p521_scalar_u1 = 0;
    let (x78, x79) = fiat_p521_scalar_addcarryx_u64(x77, x49, x46);
    let mut x80: u64 = 0;
    let mut x81: fiat_p521_scalar_u1 = 0;
    let (x80, x81) = fiat_p521_scalar_addcarryx_u64(0x0, x26, x62);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    let (x82, x83) = fiat_p521_scalar_addcarryx_u64(x81, x28, x64);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    let (x84, x85) = fiat_p521_scalar_addcarryx_u64(x83, x30, x66);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    let (x86, x87) = fiat_p521_scalar_addcarryx_u64(x85, x32, x68);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    let (x88, x89) = fiat_p521_scalar_addcarryx_u64(x87, x34, x70);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    let (x90, x91) = fiat_p521_scalar_addcarryx_u64(x89, x36, x72);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    let (x92, x93) = fiat_p521_scalar_addcarryx_u64(x91, x38, x74);
    let mut x94: u64 = 0;
    let mut x95: fiat_p521_scalar_u1 = 0;
    let (x94, x95) = fiat_p521_scalar_addcarryx_u64(x93, x40, x76);
    let mut x96: u64 = 0;
    let mut x97: fiat_p521_scalar_u1 = 0;
    let (x96, x97) = fiat_p521_scalar_addcarryx_u64(x95, x42, x78);
    let mut x98: u64 = 0;
    let mut x99: u64 = 0;
    let (x98, x99) = fiat_p521_scalar_mulx_u64(x1, 0x3d);
    let mut x100: u64 = 0;
    let mut x101: u64 = 0;
    let (x100, x101) = fiat_p521_scalar_mulx_u64(x1, 0x2d8e03d1492d0d45);
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p521_scalar_mulx_u64(x1, 0x5bcc6d61a8e567bc);
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p521_scalar_mulx_u64(x1, 0xcff3d142b7756e3e);
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p521_scalar_mulx_u64(x1, 0xdd6e23d82e49c7db);
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p521_scalar_mulx_u64(x1, 0xd3721ef557f75e06);
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p521_scalar_mulx_u64(x1, 0x12a78d38794573ff);
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p521_scalar_mulx_u64(x1, 0xf707badce5547ea3);
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p521_scalar_mulx_u64(x1, 0x137cd04dcf15dd04);
    let mut x116: u64 = 0;
    let mut x117: fiat_p521_scalar_u1 = 0;
    let (x116, x117) = fiat_p521_scalar_addcarryx_u64(0x0, x115, x112);
    let mut x118: u64 = 0;
    let mut x119: fiat_p521_scalar_u1 = 0;
    let (x118, x119) = fiat_p521_scalar_addcarryx_u64(x117, x113, x110);
    let mut x120: u64 = 0;
    let mut x121: fiat_p521_scalar_u1 = 0;
    let (x120, x121) = fiat_p521_scalar_addcarryx_u64(x119, x111, x108);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    let (x122, x123) = fiat_p521_scalar_addcarryx_u64(x121, x109, x106);
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    let (x124, x125) = fiat_p521_scalar_addcarryx_u64(x123, x107, x104);
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    let (x126, x127) = fiat_p521_scalar_addcarryx_u64(x125, x105, x102);
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    let (x128, x129) = fiat_p521_scalar_addcarryx_u64(x127, x103, x100);
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    let (x130, x131) = fiat_p521_scalar_addcarryx_u64(x129, x101, x98);
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    let (x132, x133) = fiat_p521_scalar_addcarryx_u64(0x0, x82, x114);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    let (x134, x135) = fiat_p521_scalar_addcarryx_u64(x133, x84, x116);
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    let (x136, x137) = fiat_p521_scalar_addcarryx_u64(x135, x86, x118);
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    let (x138, x139) = fiat_p521_scalar_addcarryx_u64(x137, x88, x120);
    let mut x140: u64 = 0;
    let mut x141: fiat_p521_scalar_u1 = 0;
    let (x140, x141) = fiat_p521_scalar_addcarryx_u64(x139, x90, x122);
    let mut x142: u64 = 0;
    let mut x143: fiat_p521_scalar_u1 = 0;
    let (x142, x143) = fiat_p521_scalar_addcarryx_u64(x141, x92, x124);
    let mut x144: u64 = 0;
    let mut x145: fiat_p521_scalar_u1 = 0;
    let (x144, x145) = fiat_p521_scalar_addcarryx_u64(x143, x94, x126);
    let mut x146: u64 = 0;
    let mut x147: fiat_p521_scalar_u1 = 0;
    let (x146, x147) = fiat_p521_scalar_addcarryx_u64(x145, x96, x128);
    let mut x148: u64 = 0;
    let mut x149: fiat_p521_scalar_u1 = 0;
    let (x148, x149) = fiat_p521_scalar_addcarryx_u64(
        x147,
        (((x97 as u64) + ((x43 as u64) + x11)) + ((x79 as u64) + x47)),
        x130,
    );
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    let (x150, x151) = fiat_p521_scalar_mulx_u64(x132, 0x1d2f5ccd79a995c7);
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    let (x152, x153) = fiat_p521_scalar_mulx_u64(x150, 0x1ff);
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    let (x154, x155) = fiat_p521_scalar_mulx_u64(x150, 0xffffffffffffffff);
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    let (x156, x157) = fiat_p521_scalar_mulx_u64(x150, 0xffffffffffffffff);
    let mut x158: u64 = 0;
    let mut x159: u64 = 0;
    let (x158, x159) = fiat_p521_scalar_mulx_u64(x150, 0xffffffffffffffff);
    let mut x160: u64 = 0;
    let mut x161: u64 = 0;
    let (x160, x161) = fiat_p521_scalar_mulx_u64(x150, 0xfffffffffffffffa);
    let mut x162: u64 = 0;
    let mut x163: u64 = 0;
    let (x162, x163) = fiat_p521_scalar_mulx_u64(x150, 0x51868783bf2f966b);
    let mut x164: u64 = 0;
    let mut x165: u64 = 0;
    let (x164, x165) = fiat_p521_scalar_mulx_u64(x150, 0x7fcc0148f709a5d0);
    let mut x166: u64 = 0;
    let mut x167: u64 = 0;
    let (x166, x167) = fiat_p521_scalar_mulx_u64(x150, 0x3bb5c9b8899c47ae);
    let mut x168: u64 = 0;
    let mut x169: u64 = 0;
    let (x168, x169) = fiat_p521_scalar_mulx_u64(x150, 0xbb6fb71e91386409);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    let (x170, x171) = fiat_p521_scalar_addcarryx_u64(0x0, x169, x166);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    let (x172, x173) = fiat_p521_scalar_addcarryx_u64(x171, x167, x164);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    let (x174, x175) = fiat_p521_scalar_addcarryx_u64(x173, x165, x162);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    let (x176, x177) = fiat_p521_scalar_addcarryx_u64(x175, x163, x160);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    let (x178, x179) = fiat_p521_scalar_addcarryx_u64(x177, x161, x158);
    let mut x180: u64 = 0;
    let mut x181: fiat_p521_scalar_u1 = 0;
    let (x180, x181) = fiat_p521_scalar_addcarryx_u64(x179, x159, x156);
    let mut x182: u64 = 0;
    let mut x183: fiat_p521_scalar_u1 = 0;
    let (x182, x183) = fiat_p521_scalar_addcarryx_u64(x181, x157, x154);
    let mut x184: u64 = 0;
    let mut x185: fiat_p521_scalar_u1 = 0;
    let (x184, x185) = fiat_p521_scalar_addcarryx_u64(x183, x155, x152);
    let mut x186: u64 = 0;
    let mut x187: fiat_p521_scalar_u1 = 0;
    let (x186, x187) = fiat_p521_scalar_addcarryx_u64(0x0, x132, x168);
    let mut x188: u64 = 0;
    let mut x189: fiat_p521_scalar_u1 = 0;
    let (x188, x189) = fiat_p521_scalar_addcarryx_u64(x187, x134, x170);
    let mut x190: u64 = 0;
    let mut x191: fiat_p521_scalar_u1 = 0;
    let (x190, x191) = fiat_p521_scalar_addcarryx_u64(x189, x136, x172);
    let mut x192: u64 = 0;
    let mut x193: fiat_p521_scalar_u1 = 0;
    let (x192, x193) = fiat_p521_scalar_addcarryx_u64(x191, x138, x174);
    let mut x194: u64 = 0;
    let mut x195: fiat_p521_scalar_u1 = 0;
    let (x194, x195) = fiat_p521_scalar_addcarryx_u64(x193, x140, x176);
    let mut x196: u64 = 0;
    let mut x197: fiat_p521_scalar_u1 = 0;
    let (x196, x197) = fiat_p521_scalar_addcarryx_u64(x195, x142, x178);
    let mut x198: u64 = 0;
    let mut x199: fiat_p521_scalar_u1 = 0;
    let (x198, x199) = fiat_p521_scalar_addcarryx_u64(x197, x144, x180);
    let mut x200: u64 = 0;
    let mut x201: fiat_p521_scalar_u1 = 0;
    let (x200, x201) = fiat_p521_scalar_addcarryx_u64(x199, x146, x182);
    let mut x202: u64 = 0;
    let mut x203: fiat_p521_scalar_u1 = 0;
    let (x202, x203) = fiat_p521_scalar_addcarryx_u64(x201, x148, x184);
    let mut x204: u64 = 0;
    let mut x205: u64 = 0;
    let (x204, x205) = fiat_p521_scalar_mulx_u64(x2, 0x3d);
    let mut x206: u64 = 0;
    let mut x207: u64 = 0;
    let (x206, x207) = fiat_p521_scalar_mulx_u64(x2, 0x2d8e03d1492d0d45);
    let mut x208: u64 = 0;
    let mut x209: u64 = 0;
    let (x208, x209) = fiat_p521_scalar_mulx_u64(x2, 0x5bcc6d61a8e567bc);
    let mut x210: u64 = 0;
    let mut x211: u64 = 0;
    let (x210, x211) = fiat_p521_scalar_mulx_u64(x2, 0xcff3d142b7756e3e);
    let mut x212: u64 = 0;
    let mut x213: u64 = 0;
    let (x212, x213) = fiat_p521_scalar_mulx_u64(x2, 0xdd6e23d82e49c7db);
    let mut x214: u64 = 0;
    let mut x215: u64 = 0;
    let (x214, x215) = fiat_p521_scalar_mulx_u64(x2, 0xd3721ef557f75e06);
    let mut x216: u64 = 0;
    let mut x217: u64 = 0;
    let (x216, x217) = fiat_p521_scalar_mulx_u64(x2, 0x12a78d38794573ff);
    let mut x218: u64 = 0;
    let mut x219: u64 = 0;
    let (x218, x219) = fiat_p521_scalar_mulx_u64(x2, 0xf707badce5547ea3);
    let mut x220: u64 = 0;
    let mut x221: u64 = 0;
    let (x220, x221) = fiat_p521_scalar_mulx_u64(x2, 0x137cd04dcf15dd04);
    let mut x222: u64 = 0;
    let mut x223: fiat_p521_scalar_u1 = 0;
    let (x222, x223) = fiat_p521_scalar_addcarryx_u64(0x0, x221, x218);
    let mut x224: u64 = 0;
    let mut x225: fiat_p521_scalar_u1 = 0;
    let (x224, x225) = fiat_p521_scalar_addcarryx_u64(x223, x219, x216);
    let mut x226: u64 = 0;
    let mut x227: fiat_p521_scalar_u1 = 0;
    let (x226, x227) = fiat_p521_scalar_addcarryx_u64(x225, x217, x214);
    let mut x228: u64 = 0;
    let mut x229: fiat_p521_scalar_u1 = 0;
    let (x228, x229) = fiat_p521_scalar_addcarryx_u64(x227, x215, x212);
    let mut x230: u64 = 0;
    let mut x231: fiat_p521_scalar_u1 = 0;
    let (x230, x231) = fiat_p521_scalar_addcarryx_u64(x229, x213, x210);
    let mut x232: u64 = 0;
    let mut x233: fiat_p521_scalar_u1 = 0;
    let (x232, x233) = fiat_p521_scalar_addcarryx_u64(x231, x211, x208);
    let mut x234: u64 = 0;
    let mut x235: fiat_p521_scalar_u1 = 0;
    let (x234, x235) = fiat_p521_scalar_addcarryx_u64(x233, x209, x206);
    let mut x236: u64 = 0;
    let mut x237: fiat_p521_scalar_u1 = 0;
    let (x236, x237) = fiat_p521_scalar_addcarryx_u64(x235, x207, x204);
    let mut x238: u64 = 0;
    let mut x239: fiat_p521_scalar_u1 = 0;
    let (x238, x239) = fiat_p521_scalar_addcarryx_u64(0x0, x188, x220);
    let mut x240: u64 = 0;
    let mut x241: fiat_p521_scalar_u1 = 0;
    let (x240, x241) = fiat_p521_scalar_addcarryx_u64(x239, x190, x222);
    let mut x242: u64 = 0;
    let mut x243: fiat_p521_scalar_u1 = 0;
    let (x242, x243) = fiat_p521_scalar_addcarryx_u64(x241, x192, x224);
    let mut x244: u64 = 0;
    let mut x245: fiat_p521_scalar_u1 = 0;
    let (x244, x245) = fiat_p521_scalar_addcarryx_u64(x243, x194, x226);
    let mut x246: u64 = 0;
    let mut x247: fiat_p521_scalar_u1 = 0;
    let (x246, x247) = fiat_p521_scalar_addcarryx_u64(x245, x196, x228);
    let mut x248: u64 = 0;
    let mut x249: fiat_p521_scalar_u1 = 0;
    let (x248, x249) = fiat_p521_scalar_addcarryx_u64(x247, x198, x230);
    let mut x250: u64 = 0;
    let mut x251: fiat_p521_scalar_u1 = 0;
    let (x250, x251) = fiat_p521_scalar_addcarryx_u64(x249, x200, x232);
    let mut x252: u64 = 0;
    let mut x253: fiat_p521_scalar_u1 = 0;
    let (x252, x253) = fiat_p521_scalar_addcarryx_u64(x251, x202, x234);
    let mut x254: u64 = 0;
    let mut x255: fiat_p521_scalar_u1 = 0;
    let (x254, x255) = fiat_p521_scalar_addcarryx_u64(
        x253,
        (((x203 as u64) + ((x149 as u64) + ((x131 as u64) + x99))) + ((x185 as u64) + x153)),
        x236,
    );
    let mut x256: u64 = 0;
    let mut x257: u64 = 0;
    let (x256, x257) = fiat_p521_scalar_mulx_u64(x238, 0x1d2f5ccd79a995c7);
    let mut x258: u64 = 0;
    let mut x259: u64 = 0;
    let (x258, x259) = fiat_p521_scalar_mulx_u64(x256, 0x1ff);
    let mut x260: u64 = 0;
    let mut x261: u64 = 0;
    let (x260, x261) = fiat_p521_scalar_mulx_u64(x256, 0xffffffffffffffff);
    let mut x262: u64 = 0;
    let mut x263: u64 = 0;
    let (x262, x263) = fiat_p521_scalar_mulx_u64(x256, 0xffffffffffffffff);
    let mut x264: u64 = 0;
    let mut x265: u64 = 0;
    let (x264, x265) = fiat_p521_scalar_mulx_u64(x256, 0xffffffffffffffff);
    let mut x266: u64 = 0;
    let mut x267: u64 = 0;
    let (x266, x267) = fiat_p521_scalar_mulx_u64(x256, 0xfffffffffffffffa);
    let mut x268: u64 = 0;
    let mut x269: u64 = 0;
    let (x268, x269) = fiat_p521_scalar_mulx_u64(x256, 0x51868783bf2f966b);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    let (x270, x271) = fiat_p521_scalar_mulx_u64(x256, 0x7fcc0148f709a5d0);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    let (x272, x273) = fiat_p521_scalar_mulx_u64(x256, 0x3bb5c9b8899c47ae);
    let mut x274: u64 = 0;
    let mut x275: u64 = 0;
    let (x274, x275) = fiat_p521_scalar_mulx_u64(x256, 0xbb6fb71e91386409);
    let mut x276: u64 = 0;
    let mut x277: fiat_p521_scalar_u1 = 0;
    let (x276, x277) = fiat_p521_scalar_addcarryx_u64(0x0, x275, x272);
    let mut x278: u64 = 0;
    let mut x279: fiat_p521_scalar_u1 = 0;
    let (x278, x279) = fiat_p521_scalar_addcarryx_u64(x277, x273, x270);
    let mut x280: u64 = 0;
    let mut x281: fiat_p521_scalar_u1 = 0;
    let (x280, x281) = fiat_p521_scalar_addcarryx_u64(x279, x271, x268);
    let mut x282: u64 = 0;
    let mut x283: fiat_p521_scalar_u1 = 0;
    let (x282, x283) = fiat_p521_scalar_addcarryx_u64(x281, x269, x266);
    let mut x284: u64 = 0;
    let mut x285: fiat_p521_scalar_u1 = 0;
    let (x284, x285) = fiat_p521_scalar_addcarryx_u64(x283, x267, x264);
    let mut x286: u64 = 0;
    let mut x287: fiat_p521_scalar_u1 = 0;
    let (x286, x287) = fiat_p521_scalar_addcarryx_u64(x285, x265, x262);
    let mut x288: u64 = 0;
    let mut x289: fiat_p521_scalar_u1 = 0;
    let (x288, x289) = fiat_p521_scalar_addcarryx_u64(x287, x263, x260);
    let mut x290: u64 = 0;
    let mut x291: fiat_p521_scalar_u1 = 0;
    let (x290, x291) = fiat_p521_scalar_addcarryx_u64(x289, x261, x258);
    let mut x292: u64 = 0;
    let mut x293: fiat_p521_scalar_u1 = 0;
    let (x292, x293) = fiat_p521_scalar_addcarryx_u64(0x0, x238, x274);
    let mut x294: u64 = 0;
    let mut x295: fiat_p521_scalar_u1 = 0;
    let (x294, x295) = fiat_p521_scalar_addcarryx_u64(x293, x240, x276);
    let mut x296: u64 = 0;
    let mut x297: fiat_p521_scalar_u1 = 0;
    let (x296, x297) = fiat_p521_scalar_addcarryx_u64(x295, x242, x278);
    let mut x298: u64 = 0;
    let mut x299: fiat_p521_scalar_u1 = 0;
    let (x298, x299) = fiat_p521_scalar_addcarryx_u64(x297, x244, x280);
    let mut x300: u64 = 0;
    let mut x301: fiat_p521_scalar_u1 = 0;
    let (x300, x301) = fiat_p521_scalar_addcarryx_u64(x299, x246, x282);
    let mut x302: u64 = 0;
    let mut x303: fiat_p521_scalar_u1 = 0;
    let (x302, x303) = fiat_p521_scalar_addcarryx_u64(x301, x248, x284);
    let mut x304: u64 = 0;
    let mut x305: fiat_p521_scalar_u1 = 0;
    let (x304, x305) = fiat_p521_scalar_addcarryx_u64(x303, x250, x286);
    let mut x306: u64 = 0;
    let mut x307: fiat_p521_scalar_u1 = 0;
    let (x306, x307) = fiat_p521_scalar_addcarryx_u64(x305, x252, x288);
    let mut x308: u64 = 0;
    let mut x309: fiat_p521_scalar_u1 = 0;
    let (x308, x309) = fiat_p521_scalar_addcarryx_u64(x307, x254, x290);
    let mut x310: u64 = 0;
    let mut x311: u64 = 0;
    let (x310, x311) = fiat_p521_scalar_mulx_u64(x3, 0x3d);
    let mut x312: u64 = 0;
    let mut x313: u64 = 0;
    let (x312, x313) = fiat_p521_scalar_mulx_u64(x3, 0x2d8e03d1492d0d45);
    let mut x314: u64 = 0;
    let mut x315: u64 = 0;
    let (x314, x315) = fiat_p521_scalar_mulx_u64(x3, 0x5bcc6d61a8e567bc);
    let mut x316: u64 = 0;
    let mut x317: u64 = 0;
    let (x316, x317) = fiat_p521_scalar_mulx_u64(x3, 0xcff3d142b7756e3e);
    let mut x318: u64 = 0;
    let mut x319: u64 = 0;
    let (x318, x319) = fiat_p521_scalar_mulx_u64(x3, 0xdd6e23d82e49c7db);
    let mut x320: u64 = 0;
    let mut x321: u64 = 0;
    let (x320, x321) = fiat_p521_scalar_mulx_u64(x3, 0xd3721ef557f75e06);
    let mut x322: u64 = 0;
    let mut x323: u64 = 0;
    let (x322, x323) = fiat_p521_scalar_mulx_u64(x3, 0x12a78d38794573ff);
    let mut x324: u64 = 0;
    let mut x325: u64 = 0;
    let (x324, x325) = fiat_p521_scalar_mulx_u64(x3, 0xf707badce5547ea3);
    let mut x326: u64 = 0;
    let mut x327: u64 = 0;
    let (x326, x327) = fiat_p521_scalar_mulx_u64(x3, 0x137cd04dcf15dd04);
    let mut x328: u64 = 0;
    let mut x329: fiat_p521_scalar_u1 = 0;
    let (x328, x329) = fiat_p521_scalar_addcarryx_u64(0x0, x327, x324);
    let mut x330: u64 = 0;
    let mut x331: fiat_p521_scalar_u1 = 0;
    let (x330, x331) = fiat_p521_scalar_addcarryx_u64(x329, x325, x322);
    let mut x332: u64 = 0;
    let mut x333: fiat_p521_scalar_u1 = 0;
    let (x332, x333) = fiat_p521_scalar_addcarryx_u64(x331, x323, x320);
    let mut x334: u64 = 0;
    let mut x335: fiat_p521_scalar_u1 = 0;
    let (x334, x335) = fiat_p521_scalar_addcarryx_u64(x333, x321, x318);
    let mut x336: u64 = 0;
    let mut x337: fiat_p521_scalar_u1 = 0;
    let (x336, x337) = fiat_p521_scalar_addcarryx_u64(x335, x319, x316);
    let mut x338: u64 = 0;
    let mut x339: fiat_p521_scalar_u1 = 0;
    let (x338, x339) = fiat_p521_scalar_addcarryx_u64(x337, x317, x314);
    let mut x340: u64 = 0;
    let mut x341: fiat_p521_scalar_u1 = 0;
    let (x340, x341) = fiat_p521_scalar_addcarryx_u64(x339, x315, x312);
    let mut x342: u64 = 0;
    let mut x343: fiat_p521_scalar_u1 = 0;
    let (x342, x343) = fiat_p521_scalar_addcarryx_u64(x341, x313, x310);
    let mut x344: u64 = 0;
    let mut x345: fiat_p521_scalar_u1 = 0;
    let (x344, x345) = fiat_p521_scalar_addcarryx_u64(0x0, x294, x326);
    let mut x346: u64 = 0;
    let mut x347: fiat_p521_scalar_u1 = 0;
    let (x346, x347) = fiat_p521_scalar_addcarryx_u64(x345, x296, x328);
    let mut x348: u64 = 0;
    let mut x349: fiat_p521_scalar_u1 = 0;
    let (x348, x349) = fiat_p521_scalar_addcarryx_u64(x347, x298, x330);
    let mut x350: u64 = 0;
    let mut x351: fiat_p521_scalar_u1 = 0;
    let (x350, x351) = fiat_p521_scalar_addcarryx_u64(x349, x300, x332);
    let mut x352: u64 = 0;
    let mut x353: fiat_p521_scalar_u1 = 0;
    let (x352, x353) = fiat_p521_scalar_addcarryx_u64(x351, x302, x334);
    let mut x354: u64 = 0;
    let mut x355: fiat_p521_scalar_u1 = 0;
    let (x354, x355) = fiat_p521_scalar_addcarryx_u64(x353, x304, x336);
    let mut x356: u64 = 0;
    let mut x357: fiat_p521_scalar_u1 = 0;
    let (x356, x357) = fiat_p521_scalar_addcarryx_u64(x355, x306, x338);
    let mut x358: u64 = 0;
    let mut x359: fiat_p521_scalar_u1 = 0;
    let (x358, x359) = fiat_p521_scalar_addcarryx_u64(x357, x308, x340);
    let mut x360: u64 = 0;
    let mut x361: fiat_p521_scalar_u1 = 0;
    let (x360, x361) = fiat_p521_scalar_addcarryx_u64(
        x359,
        (((x309 as u64) + ((x255 as u64) + ((x237 as u64) + x205))) + ((x291 as u64) + x259)),
        x342,
    );
    let mut x362: u64 = 0;
    let mut x363: u64 = 0;
    let (x362, x363) = fiat_p521_scalar_mulx_u64(x344, 0x1d2f5ccd79a995c7);
    let mut x364: u64 = 0;
    let mut x365: u64 = 0;
    let (x364, x365) = fiat_p521_scalar_mulx_u64(x362, 0x1ff);
    let mut x366: u64 = 0;
    let mut x367: u64 = 0;
    let (x366, x367) = fiat_p521_scalar_mulx_u64(x362, 0xffffffffffffffff);
    let mut x368: u64 = 0;
    let mut x369: u64 = 0;
    let (x368, x369) = fiat_p521_scalar_mulx_u64(x362, 0xffffffffffffffff);
    let mut x370: u64 = 0;
    let mut x371: u64 = 0;
    let (x370, x371) = fiat_p521_scalar_mulx_u64(x362, 0xffffffffffffffff);
    let mut x372: u64 = 0;
    let mut x373: u64 = 0;
    let (x372, x373) = fiat_p521_scalar_mulx_u64(x362, 0xfffffffffffffffa);
    let mut x374: u64 = 0;
    let mut x375: u64 = 0;
    let (x374, x375) = fiat_p521_scalar_mulx_u64(x362, 0x51868783bf2f966b);
    let mut x376: u64 = 0;
    let mut x377: u64 = 0;
    let (x376, x377) = fiat_p521_scalar_mulx_u64(x362, 0x7fcc0148f709a5d0);
    let mut x378: u64 = 0;
    let mut x379: u64 = 0;
    let (x378, x379) = fiat_p521_scalar_mulx_u64(x362, 0x3bb5c9b8899c47ae);
    let mut x380: u64 = 0;
    let mut x381: u64 = 0;
    let (x380, x381) = fiat_p521_scalar_mulx_u64(x362, 0xbb6fb71e91386409);
    let mut x382: u64 = 0;
    let mut x383: fiat_p521_scalar_u1 = 0;
    let (x382, x383) = fiat_p521_scalar_addcarryx_u64(0x0, x381, x378);
    let mut x384: u64 = 0;
    let mut x385: fiat_p521_scalar_u1 = 0;
    let (x384, x385) = fiat_p521_scalar_addcarryx_u64(x383, x379, x376);
    let mut x386: u64 = 0;
    let mut x387: fiat_p521_scalar_u1 = 0;
    let (x386, x387) = fiat_p521_scalar_addcarryx_u64(x385, x377, x374);
    let mut x388: u64 = 0;
    let mut x389: fiat_p521_scalar_u1 = 0;
    let (x388, x389) = fiat_p521_scalar_addcarryx_u64(x387, x375, x372);
    let mut x390: u64 = 0;
    let mut x391: fiat_p521_scalar_u1 = 0;
    let (x390, x391) = fiat_p521_scalar_addcarryx_u64(x389, x373, x370);
    let mut x392: u64 = 0;
    let mut x393: fiat_p521_scalar_u1 = 0;
    let (x392, x393) = fiat_p521_scalar_addcarryx_u64(x391, x371, x368);
    let mut x394: u64 = 0;
    let mut x395: fiat_p521_scalar_u1 = 0;
    let (x394, x395) = fiat_p521_scalar_addcarryx_u64(x393, x369, x366);
    let mut x396: u64 = 0;
    let mut x397: fiat_p521_scalar_u1 = 0;
    let (x396, x397) = fiat_p521_scalar_addcarryx_u64(x395, x367, x364);
    let mut x398: u64 = 0;
    let mut x399: fiat_p521_scalar_u1 = 0;
    let (x398, x399) = fiat_p521_scalar_addcarryx_u64(0x0, x344, x380);
    let mut x400: u64 = 0;
    let mut x401: fiat_p521_scalar_u1 = 0;
    let (x400, x401) = fiat_p521_scalar_addcarryx_u64(x399, x346, x382);
    let mut x402: u64 = 0;
    let mut x403: fiat_p521_scalar_u1 = 0;
    let (x402, x403) = fiat_p521_scalar_addcarryx_u64(x401, x348, x384);
    let mut x404: u64 = 0;
    let mut x405: fiat_p521_scalar_u1 = 0;
    let (x404, x405) = fiat_p521_scalar_addcarryx_u64(x403, x350, x386);
    let mut x406: u64 = 0;
    let mut x407: fiat_p521_scalar_u1 = 0;
    let (x406, x407) = fiat_p521_scalar_addcarryx_u64(x405, x352, x388);
    let mut x408: u64 = 0;
    let mut x409: fiat_p521_scalar_u1 = 0;
    let (x408, x409) = fiat_p521_scalar_addcarryx_u64(x407, x354, x390);
    let mut x410: u64 = 0;
    let mut x411: fiat_p521_scalar_u1 = 0;
    let (x410, x411) = fiat_p521_scalar_addcarryx_u64(x409, x356, x392);
    let mut x412: u64 = 0;
    let mut x413: fiat_p521_scalar_u1 = 0;
    let (x412, x413) = fiat_p521_scalar_addcarryx_u64(x411, x358, x394);
    let mut x414: u64 = 0;
    let mut x415: fiat_p521_scalar_u1 = 0;
    let (x414, x415) = fiat_p521_scalar_addcarryx_u64(x413, x360, x396);
    let mut x416: u64 = 0;
    let mut x417: u64 = 0;
    let (x416, x417) = fiat_p521_scalar_mulx_u64(x4, 0x3d);
    let mut x418: u64 = 0;
    let mut x419: u64 = 0;
    let (x418, x419) = fiat_p521_scalar_mulx_u64(x4, 0x2d8e03d1492d0d45);
    let mut x420: u64 = 0;
    let mut x421: u64 = 0;
    let (x420, x421) = fiat_p521_scalar_mulx_u64(x4, 0x5bcc6d61a8e567bc);
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    let (x422, x423) = fiat_p521_scalar_mulx_u64(x4, 0xcff3d142b7756e3e);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    let (x424, x425) = fiat_p521_scalar_mulx_u64(x4, 0xdd6e23d82e49c7db);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    let (x426, x427) = fiat_p521_scalar_mulx_u64(x4, 0xd3721ef557f75e06);
    let mut x428: u64 = 0;
    let mut x429: u64 = 0;
    let (x428, x429) = fiat_p521_scalar_mulx_u64(x4, 0x12a78d38794573ff);
    let mut x430: u64 = 0;
    let mut x431: u64 = 0;
    let (x430, x431) = fiat_p521_scalar_mulx_u64(x4, 0xf707badce5547ea3);
    let mut x432: u64 = 0;
    let mut x433: u64 = 0;
    let (x432, x433) = fiat_p521_scalar_mulx_u64(x4, 0x137cd04dcf15dd04);
    let mut x434: u64 = 0;
    let mut x435: fiat_p521_scalar_u1 = 0;
    let (x434, x435) = fiat_p521_scalar_addcarryx_u64(0x0, x433, x430);
    let mut x436: u64 = 0;
    let mut x437: fiat_p521_scalar_u1 = 0;
    let (x436, x437) = fiat_p521_scalar_addcarryx_u64(x435, x431, x428);
    let mut x438: u64 = 0;
    let mut x439: fiat_p521_scalar_u1 = 0;
    let (x438, x439) = fiat_p521_scalar_addcarryx_u64(x437, x429, x426);
    let mut x440: u64 = 0;
    let mut x441: fiat_p521_scalar_u1 = 0;
    let (x440, x441) = fiat_p521_scalar_addcarryx_u64(x439, x427, x424);
    let mut x442: u64 = 0;
    let mut x443: fiat_p521_scalar_u1 = 0;
    let (x442, x443) = fiat_p521_scalar_addcarryx_u64(x441, x425, x422);
    let mut x444: u64 = 0;
    let mut x445: fiat_p521_scalar_u1 = 0;
    let (x444, x445) = fiat_p521_scalar_addcarryx_u64(x443, x423, x420);
    let mut x446: u64 = 0;
    let mut x447: fiat_p521_scalar_u1 = 0;
    let (x446, x447) = fiat_p521_scalar_addcarryx_u64(x445, x421, x418);
    let mut x448: u64 = 0;
    let mut x449: fiat_p521_scalar_u1 = 0;
    let (x448, x449) = fiat_p521_scalar_addcarryx_u64(x447, x419, x416);
    let mut x450: u64 = 0;
    let mut x451: fiat_p521_scalar_u1 = 0;
    let (x450, x451) = fiat_p521_scalar_addcarryx_u64(0x0, x400, x432);
    let mut x452: u64 = 0;
    let mut x453: fiat_p521_scalar_u1 = 0;
    let (x452, x453) = fiat_p521_scalar_addcarryx_u64(x451, x402, x434);
    let mut x454: u64 = 0;
    let mut x455: fiat_p521_scalar_u1 = 0;
    let (x454, x455) = fiat_p521_scalar_addcarryx_u64(x453, x404, x436);
    let mut x456: u64 = 0;
    let mut x457: fiat_p521_scalar_u1 = 0;
    let (x456, x457) = fiat_p521_scalar_addcarryx_u64(x455, x406, x438);
    let mut x458: u64 = 0;
    let mut x459: fiat_p521_scalar_u1 = 0;
    let (x458, x459) = fiat_p521_scalar_addcarryx_u64(x457, x408, x440);
    let mut x460: u64 = 0;
    let mut x461: fiat_p521_scalar_u1 = 0;
    let (x460, x461) = fiat_p521_scalar_addcarryx_u64(x459, x410, x442);
    let mut x462: u64 = 0;
    let mut x463: fiat_p521_scalar_u1 = 0;
    let (x462, x463) = fiat_p521_scalar_addcarryx_u64(x461, x412, x444);
    let mut x464: u64 = 0;
    let mut x465: fiat_p521_scalar_u1 = 0;
    let (x464, x465) = fiat_p521_scalar_addcarryx_u64(x463, x414, x446);
    let mut x466: u64 = 0;
    let mut x467: fiat_p521_scalar_u1 = 0;
    let (x466, x467) = fiat_p521_scalar_addcarryx_u64(
        x465,
        (((x415 as u64) + ((x361 as u64) + ((x343 as u64) + x311))) + ((x397 as u64) + x365)),
        x448,
    );
    let mut x468: u64 = 0;
    let mut x469: u64 = 0;
    let (x468, x469) = fiat_p521_scalar_mulx_u64(x450, 0x1d2f5ccd79a995c7);
    let mut x470: u64 = 0;
    let mut x471: u64 = 0;
    let (x470, x471) = fiat_p521_scalar_mulx_u64(x468, 0x1ff);
    let mut x472: u64 = 0;
    let mut x473: u64 = 0;
    let (x472, x473) = fiat_p521_scalar_mulx_u64(x468, 0xffffffffffffffff);
    let mut x474: u64 = 0;
    let mut x475: u64 = 0;
    let (x474, x475) = fiat_p521_scalar_mulx_u64(x468, 0xffffffffffffffff);
    let mut x476: u64 = 0;
    let mut x477: u64 = 0;
    let (x476, x477) = fiat_p521_scalar_mulx_u64(x468, 0xffffffffffffffff);
    let mut x478: u64 = 0;
    let mut x479: u64 = 0;
    let (x478, x479) = fiat_p521_scalar_mulx_u64(x468, 0xfffffffffffffffa);
    let mut x480: u64 = 0;
    let mut x481: u64 = 0;
    let (x480, x481) = fiat_p521_scalar_mulx_u64(x468, 0x51868783bf2f966b);
    let mut x482: u64 = 0;
    let mut x483: u64 = 0;
    let (x482, x483) = fiat_p521_scalar_mulx_u64(x468, 0x7fcc0148f709a5d0);
    let mut x484: u64 = 0;
    let mut x485: u64 = 0;
    let (x484, x485) = fiat_p521_scalar_mulx_u64(x468, 0x3bb5c9b8899c47ae);
    let mut x486: u64 = 0;
    let mut x487: u64 = 0;
    let (x486, x487) = fiat_p521_scalar_mulx_u64(x468, 0xbb6fb71e91386409);
    let mut x488: u64 = 0;
    let mut x489: fiat_p521_scalar_u1 = 0;
    let (x488, x489) = fiat_p521_scalar_addcarryx_u64(0x0, x487, x484);
    let mut x490: u64 = 0;
    let mut x491: fiat_p521_scalar_u1 = 0;
    let (x490, x491) = fiat_p521_scalar_addcarryx_u64(x489, x485, x482);
    let mut x492: u64 = 0;
    let mut x493: fiat_p521_scalar_u1 = 0;
    let (x492, x493) = fiat_p521_scalar_addcarryx_u64(x491, x483, x480);
    let mut x494: u64 = 0;
    let mut x495: fiat_p521_scalar_u1 = 0;
    let (x494, x495) = fiat_p521_scalar_addcarryx_u64(x493, x481, x478);
    let mut x496: u64 = 0;
    let mut x497: fiat_p521_scalar_u1 = 0;
    let (x496, x497) = fiat_p521_scalar_addcarryx_u64(x495, x479, x476);
    let mut x498: u64 = 0;
    let mut x499: fiat_p521_scalar_u1 = 0;
    let (x498, x499) = fiat_p521_scalar_addcarryx_u64(x497, x477, x474);
    let mut x500: u64 = 0;
    let mut x501: fiat_p521_scalar_u1 = 0;
    let (x500, x501) = fiat_p521_scalar_addcarryx_u64(x499, x475, x472);
    let mut x502: u64 = 0;
    let mut x503: fiat_p521_scalar_u1 = 0;
    let (x502, x503) = fiat_p521_scalar_addcarryx_u64(x501, x473, x470);
    let mut x504: u64 = 0;
    let mut x505: fiat_p521_scalar_u1 = 0;
    let (x504, x505) = fiat_p521_scalar_addcarryx_u64(0x0, x450, x486);
    let mut x506: u64 = 0;
    let mut x507: fiat_p521_scalar_u1 = 0;
    let (x506, x507) = fiat_p521_scalar_addcarryx_u64(x505, x452, x488);
    let mut x508: u64 = 0;
    let mut x509: fiat_p521_scalar_u1 = 0;
    let (x508, x509) = fiat_p521_scalar_addcarryx_u64(x507, x454, x490);
    let mut x510: u64 = 0;
    let mut x511: fiat_p521_scalar_u1 = 0;
    let (x510, x511) = fiat_p521_scalar_addcarryx_u64(x509, x456, x492);
    let mut x512: u64 = 0;
    let mut x513: fiat_p521_scalar_u1 = 0;
    let (x512, x513) = fiat_p521_scalar_addcarryx_u64(x511, x458, x494);
    let mut x514: u64 = 0;
    let mut x515: fiat_p521_scalar_u1 = 0;
    let (x514, x515) = fiat_p521_scalar_addcarryx_u64(x513, x460, x496);
    let mut x516: u64 = 0;
    let mut x517: fiat_p521_scalar_u1 = 0;
    let (x516, x517) = fiat_p521_scalar_addcarryx_u64(x515, x462, x498);
    let mut x518: u64 = 0;
    let mut x519: fiat_p521_scalar_u1 = 0;
    let (x518, x519) = fiat_p521_scalar_addcarryx_u64(x517, x464, x500);
    let mut x520: u64 = 0;
    let mut x521: fiat_p521_scalar_u1 = 0;
    let (x520, x521) = fiat_p521_scalar_addcarryx_u64(x519, x466, x502);
    let mut x522: u64 = 0;
    let mut x523: u64 = 0;
    let (x522, x523) = fiat_p521_scalar_mulx_u64(x5, 0x3d);
    let mut x524: u64 = 0;
    let mut x525: u64 = 0;
    let (x524, x525) = fiat_p521_scalar_mulx_u64(x5, 0x2d8e03d1492d0d45);
    let mut x526: u64 = 0;
    let mut x527: u64 = 0;
    let (x526, x527) = fiat_p521_scalar_mulx_u64(x5, 0x5bcc6d61a8e567bc);
    let mut x528: u64 = 0;
    let mut x529: u64 = 0;
    let (x528, x529) = fiat_p521_scalar_mulx_u64(x5, 0xcff3d142b7756e3e);
    let mut x530: u64 = 0;
    let mut x531: u64 = 0;
    let (x530, x531) = fiat_p521_scalar_mulx_u64(x5, 0xdd6e23d82e49c7db);
    let mut x532: u64 = 0;
    let mut x533: u64 = 0;
    let (x532, x533) = fiat_p521_scalar_mulx_u64(x5, 0xd3721ef557f75e06);
    let mut x534: u64 = 0;
    let mut x535: u64 = 0;
    let (x534, x535) = fiat_p521_scalar_mulx_u64(x5, 0x12a78d38794573ff);
    let mut x536: u64 = 0;
    let mut x537: u64 = 0;
    let (x536, x537) = fiat_p521_scalar_mulx_u64(x5, 0xf707badce5547ea3);
    let mut x538: u64 = 0;
    let mut x539: u64 = 0;
    let (x538, x539) = fiat_p521_scalar_mulx_u64(x5, 0x137cd04dcf15dd04);
    let mut x540: u64 = 0;
    let mut x541: fiat_p521_scalar_u1 = 0;
    let (x540, x541) = fiat_p521_scalar_addcarryx_u64(0x0, x539, x536);
    let mut x542: u64 = 0;
    let mut x543: fiat_p521_scalar_u1 = 0;
    let (x542, x543) = fiat_p521_scalar_addcarryx_u64(x541, x537, x534);
    let mut x544: u64 = 0;
    let mut x545: fiat_p521_scalar_u1 = 0;
    let (x544, x545) = fiat_p521_scalar_addcarryx_u64(x543, x535, x532);
    let mut x546: u64 = 0;
    let mut x547: fiat_p521_scalar_u1 = 0;
    let (x546, x547) = fiat_p521_scalar_addcarryx_u64(x545, x533, x530);
    let mut x548: u64 = 0;
    let mut x549: fiat_p521_scalar_u1 = 0;
    let (x548, x549) = fiat_p521_scalar_addcarryx_u64(x547, x531, x528);
    let mut x550: u64 = 0;
    let mut x551: fiat_p521_scalar_u1 = 0;
    let (x550, x551) = fiat_p521_scalar_addcarryx_u64(x549, x529, x526);
    let mut x552: u64 = 0;
    let mut x553: fiat_p521_scalar_u1 = 0;
    let (x552, x553) = fiat_p521_scalar_addcarryx_u64(x551, x527, x524);
    let mut x554: u64 = 0;
    let mut x555: fiat_p521_scalar_u1 = 0;
    let (x554, x555) = fiat_p521_scalar_addcarryx_u64(x553, x525, x522);
    let mut x556: u64 = 0;
    let mut x557: fiat_p521_scalar_u1 = 0;
    let (x556, x557) = fiat_p521_scalar_addcarryx_u64(0x0, x506, x538);
    let mut x558: u64 = 0;
    let mut x559: fiat_p521_scalar_u1 = 0;
    let (x558, x559) = fiat_p521_scalar_addcarryx_u64(x557, x508, x540);
    let mut x560: u64 = 0;
    let mut x561: fiat_p521_scalar_u1 = 0;
    let (x560, x561) = fiat_p521_scalar_addcarryx_u64(x559, x510, x542);
    let mut x562: u64 = 0;
    let mut x563: fiat_p521_scalar_u1 = 0;
    let (x562, x563) = fiat_p521_scalar_addcarryx_u64(x561, x512, x544);
    let mut x564: u64 = 0;
    let mut x565: fiat_p521_scalar_u1 = 0;
    let (x564, x565) = fiat_p521_scalar_addcarryx_u64(x563, x514, x546);
    let mut x566: u64 = 0;
    let mut x567: fiat_p521_scalar_u1 = 0;
    let (x566, x567) = fiat_p521_scalar_addcarryx_u64(x565, x516, x548);
    let mut x568: u64 = 0;
    let mut x569: fiat_p521_scalar_u1 = 0;
    let (x568, x569) = fiat_p521_scalar_addcarryx_u64(x567, x518, x550);
    let mut x570: u64 = 0;
    let mut x571: fiat_p521_scalar_u1 = 0;
    let (x570, x571) = fiat_p521_scalar_addcarryx_u64(x569, x520, x552);
    let mut x572: u64 = 0;
    let mut x573: fiat_p521_scalar_u1 = 0;
    let (x572, x573) = fiat_p521_scalar_addcarryx_u64(
        x571,
        (((x521 as u64) + ((x467 as u64) + ((x449 as u64) + x417))) + ((x503 as u64) + x471)),
        x554,
    );
    let mut x574: u64 = 0;
    let mut x575: u64 = 0;
    let (x574, x575) = fiat_p521_scalar_mulx_u64(x556, 0x1d2f5ccd79a995c7);
    let mut x576: u64 = 0;
    let mut x577: u64 = 0;
    let (x576, x577) = fiat_p521_scalar_mulx_u64(x574, 0x1ff);
    let mut x578: u64 = 0;
    let mut x579: u64 = 0;
    let (x578, x579) = fiat_p521_scalar_mulx_u64(x574, 0xffffffffffffffff);
    let mut x580: u64 = 0;
    let mut x581: u64 = 0;
    let (x580, x581) = fiat_p521_scalar_mulx_u64(x574, 0xffffffffffffffff);
    let mut x582: u64 = 0;
    let mut x583: u64 = 0;
    let (x582, x583) = fiat_p521_scalar_mulx_u64(x574, 0xffffffffffffffff);
    let mut x584: u64 = 0;
    let mut x585: u64 = 0;
    let (x584, x585) = fiat_p521_scalar_mulx_u64(x574, 0xfffffffffffffffa);
    let mut x586: u64 = 0;
    let mut x587: u64 = 0;
    let (x586, x587) = fiat_p521_scalar_mulx_u64(x574, 0x51868783bf2f966b);
    let mut x588: u64 = 0;
    let mut x589: u64 = 0;
    let (x588, x589) = fiat_p521_scalar_mulx_u64(x574, 0x7fcc0148f709a5d0);
    let mut x590: u64 = 0;
    let mut x591: u64 = 0;
    let (x590, x591) = fiat_p521_scalar_mulx_u64(x574, 0x3bb5c9b8899c47ae);
    let mut x592: u64 = 0;
    let mut x593: u64 = 0;
    let (x592, x593) = fiat_p521_scalar_mulx_u64(x574, 0xbb6fb71e91386409);
    let mut x594: u64 = 0;
    let mut x595: fiat_p521_scalar_u1 = 0;
    let (x594, x595) = fiat_p521_scalar_addcarryx_u64(0x0, x593, x590);
    let mut x596: u64 = 0;
    let mut x597: fiat_p521_scalar_u1 = 0;
    let (x596, x597) = fiat_p521_scalar_addcarryx_u64(x595, x591, x588);
    let mut x598: u64 = 0;
    let mut x599: fiat_p521_scalar_u1 = 0;
    let (x598, x599) = fiat_p521_scalar_addcarryx_u64(x597, x589, x586);
    let mut x600: u64 = 0;
    let mut x601: fiat_p521_scalar_u1 = 0;
    let (x600, x601) = fiat_p521_scalar_addcarryx_u64(x599, x587, x584);
    let mut x602: u64 = 0;
    let mut x603: fiat_p521_scalar_u1 = 0;
    let (x602, x603) = fiat_p521_scalar_addcarryx_u64(x601, x585, x582);
    let mut x604: u64 = 0;
    let mut x605: fiat_p521_scalar_u1 = 0;
    let (x604, x605) = fiat_p521_scalar_addcarryx_u64(x603, x583, x580);
    let mut x606: u64 = 0;
    let mut x607: fiat_p521_scalar_u1 = 0;
    let (x606, x607) = fiat_p521_scalar_addcarryx_u64(x605, x581, x578);
    let mut x608: u64 = 0;
    let mut x609: fiat_p521_scalar_u1 = 0;
    let (x608, x609) = fiat_p521_scalar_addcarryx_u64(x607, x579, x576);
    let mut x610: u64 = 0;
    let mut x611: fiat_p521_scalar_u1 = 0;
    let (x610, x611) = fiat_p521_scalar_addcarryx_u64(0x0, x556, x592);
    let mut x612: u64 = 0;
    let mut x613: fiat_p521_scalar_u1 = 0;
    let (x612, x613) = fiat_p521_scalar_addcarryx_u64(x611, x558, x594);
    let mut x614: u64 = 0;
    let mut x615: fiat_p521_scalar_u1 = 0;
    let (x614, x615) = fiat_p521_scalar_addcarryx_u64(x613, x560, x596);
    let mut x616: u64 = 0;
    let mut x617: fiat_p521_scalar_u1 = 0;
    let (x616, x617) = fiat_p521_scalar_addcarryx_u64(x615, x562, x598);
    let mut x618: u64 = 0;
    let mut x619: fiat_p521_scalar_u1 = 0;
    let (x618, x619) = fiat_p521_scalar_addcarryx_u64(x617, x564, x600);
    let mut x620: u64 = 0;
    let mut x621: fiat_p521_scalar_u1 = 0;
    let (x620, x621) = fiat_p521_scalar_addcarryx_u64(x619, x566, x602);
    let mut x622: u64 = 0;
    let mut x623: fiat_p521_scalar_u1 = 0;
    let (x622, x623) = fiat_p521_scalar_addcarryx_u64(x621, x568, x604);
    let mut x624: u64 = 0;
    let mut x625: fiat_p521_scalar_u1 = 0;
    let (x624, x625) = fiat_p521_scalar_addcarryx_u64(x623, x570, x606);
    let mut x626: u64 = 0;
    let mut x627: fiat_p521_scalar_u1 = 0;
    let (x626, x627) = fiat_p521_scalar_addcarryx_u64(x625, x572, x608);
    let mut x628: u64 = 0;
    let mut x629: u64 = 0;
    let (x628, x629) = fiat_p521_scalar_mulx_u64(x6, 0x3d);
    let mut x630: u64 = 0;
    let mut x631: u64 = 0;
    let (x630, x631) = fiat_p521_scalar_mulx_u64(x6, 0x2d8e03d1492d0d45);
    let mut x632: u64 = 0;
    let mut x633: u64 = 0;
    let (x632, x633) = fiat_p521_scalar_mulx_u64(x6, 0x5bcc6d61a8e567bc);
    let mut x634: u64 = 0;
    let mut x635: u64 = 0;
    let (x634, x635) = fiat_p521_scalar_mulx_u64(x6, 0xcff3d142b7756e3e);
    let mut x636: u64 = 0;
    let mut x637: u64 = 0;
    let (x636, x637) = fiat_p521_scalar_mulx_u64(x6, 0xdd6e23d82e49c7db);
    let mut x638: u64 = 0;
    let mut x639: u64 = 0;
    let (x638, x639) = fiat_p521_scalar_mulx_u64(x6, 0xd3721ef557f75e06);
    let mut x640: u64 = 0;
    let mut x641: u64 = 0;
    let (x640, x641) = fiat_p521_scalar_mulx_u64(x6, 0x12a78d38794573ff);
    let mut x642: u64 = 0;
    let mut x643: u64 = 0;
    let (x642, x643) = fiat_p521_scalar_mulx_u64(x6, 0xf707badce5547ea3);
    let mut x644: u64 = 0;
    let mut x645: u64 = 0;
    let (x644, x645) = fiat_p521_scalar_mulx_u64(x6, 0x137cd04dcf15dd04);
    let mut x646: u64 = 0;
    let mut x647: fiat_p521_scalar_u1 = 0;
    let (x646, x647) = fiat_p521_scalar_addcarryx_u64(0x0, x645, x642);
    let mut x648: u64 = 0;
    let mut x649: fiat_p521_scalar_u1 = 0;
    let (x648, x649) = fiat_p521_scalar_addcarryx_u64(x647, x643, x640);
    let mut x650: u64 = 0;
    let mut x651: fiat_p521_scalar_u1 = 0;
    let (x650, x651) = fiat_p521_scalar_addcarryx_u64(x649, x641, x638);
    let mut x652: u64 = 0;
    let mut x653: fiat_p521_scalar_u1 = 0;
    let (x652, x653) = fiat_p521_scalar_addcarryx_u64(x651, x639, x636);
    let mut x654: u64 = 0;
    let mut x655: fiat_p521_scalar_u1 = 0;
    let (x654, x655) = fiat_p521_scalar_addcarryx_u64(x653, x637, x634);
    let mut x656: u64 = 0;
    let mut x657: fiat_p521_scalar_u1 = 0;
    let (x656, x657) = fiat_p521_scalar_addcarryx_u64(x655, x635, x632);
    let mut x658: u64 = 0;
    let mut x659: fiat_p521_scalar_u1 = 0;
    let (x658, x659) = fiat_p521_scalar_addcarryx_u64(x657, x633, x630);
    let mut x660: u64 = 0;
    let mut x661: fiat_p521_scalar_u1 = 0;
    let (x660, x661) = fiat_p521_scalar_addcarryx_u64(x659, x631, x628);
    let mut x662: u64 = 0;
    let mut x663: fiat_p521_scalar_u1 = 0;
    let (x662, x663) = fiat_p521_scalar_addcarryx_u64(0x0, x612, x644);
    let mut x664: u64 = 0;
    let mut x665: fiat_p521_scalar_u1 = 0;
    let (x664, x665) = fiat_p521_scalar_addcarryx_u64(x663, x614, x646);
    let mut x666: u64 = 0;
    let mut x667: fiat_p521_scalar_u1 = 0;
    let (x666, x667) = fiat_p521_scalar_addcarryx_u64(x665, x616, x648);
    let mut x668: u64 = 0;
    let mut x669: fiat_p521_scalar_u1 = 0;
    let (x668, x669) = fiat_p521_scalar_addcarryx_u64(x667, x618, x650);
    let mut x670: u64 = 0;
    let mut x671: fiat_p521_scalar_u1 = 0;
    let (x670, x671) = fiat_p521_scalar_addcarryx_u64(x669, x620, x652);
    let mut x672: u64 = 0;
    let mut x673: fiat_p521_scalar_u1 = 0;
    let (x672, x673) = fiat_p521_scalar_addcarryx_u64(x671, x622, x654);
    let mut x674: u64 = 0;
    let mut x675: fiat_p521_scalar_u1 = 0;
    let (x674, x675) = fiat_p521_scalar_addcarryx_u64(x673, x624, x656);
    let mut x676: u64 = 0;
    let mut x677: fiat_p521_scalar_u1 = 0;
    let (x676, x677) = fiat_p521_scalar_addcarryx_u64(x675, x626, x658);
    let mut x678: u64 = 0;
    let mut x679: fiat_p521_scalar_u1 = 0;
    let (x678, x679) = fiat_p521_scalar_addcarryx_u64(
        x677,
        (((x627 as u64) + ((x573 as u64) + ((x555 as u64) + x523))) + ((x609 as u64) + x577)),
        x660,
    );
    let mut x680: u64 = 0;
    let mut x681: u64 = 0;
    let (x680, x681) = fiat_p521_scalar_mulx_u64(x662, 0x1d2f5ccd79a995c7);
    let mut x682: u64 = 0;
    let mut x683: u64 = 0;
    let (x682, x683) = fiat_p521_scalar_mulx_u64(x680, 0x1ff);
    let mut x684: u64 = 0;
    let mut x685: u64 = 0;
    let (x684, x685) = fiat_p521_scalar_mulx_u64(x680, 0xffffffffffffffff);
    let mut x686: u64 = 0;
    let mut x687: u64 = 0;
    let (x686, x687) = fiat_p521_scalar_mulx_u64(x680, 0xffffffffffffffff);
    let mut x688: u64 = 0;
    let mut x689: u64 = 0;
    let (x688, x689) = fiat_p521_scalar_mulx_u64(x680, 0xffffffffffffffff);
    let mut x690: u64 = 0;
    let mut x691: u64 = 0;
    let (x690, x691) = fiat_p521_scalar_mulx_u64(x680, 0xfffffffffffffffa);
    let mut x692: u64 = 0;
    let mut x693: u64 = 0;
    let (x692, x693) = fiat_p521_scalar_mulx_u64(x680, 0x51868783bf2f966b);
    let mut x694: u64 = 0;
    let mut x695: u64 = 0;
    let (x694, x695) = fiat_p521_scalar_mulx_u64(x680, 0x7fcc0148f709a5d0);
    let mut x696: u64 = 0;
    let mut x697: u64 = 0;
    let (x696, x697) = fiat_p521_scalar_mulx_u64(x680, 0x3bb5c9b8899c47ae);
    let mut x698: u64 = 0;
    let mut x699: u64 = 0;
    let (x698, x699) = fiat_p521_scalar_mulx_u64(x680, 0xbb6fb71e91386409);
    let mut x700: u64 = 0;
    let mut x701: fiat_p521_scalar_u1 = 0;
    let (x700, x701) = fiat_p521_scalar_addcarryx_u64(0x0, x699, x696);
    let mut x702: u64 = 0;
    let mut x703: fiat_p521_scalar_u1 = 0;
    let (x702, x703) = fiat_p521_scalar_addcarryx_u64(x701, x697, x694);
    let mut x704: u64 = 0;
    let mut x705: fiat_p521_scalar_u1 = 0;
    let (x704, x705) = fiat_p521_scalar_addcarryx_u64(x703, x695, x692);
    let mut x706: u64 = 0;
    let mut x707: fiat_p521_scalar_u1 = 0;
    let (x706, x707) = fiat_p521_scalar_addcarryx_u64(x705, x693, x690);
    let mut x708: u64 = 0;
    let mut x709: fiat_p521_scalar_u1 = 0;
    let (x708, x709) = fiat_p521_scalar_addcarryx_u64(x707, x691, x688);
    let mut x710: u64 = 0;
    let mut x711: fiat_p521_scalar_u1 = 0;
    let (x710, x711) = fiat_p521_scalar_addcarryx_u64(x709, x689, x686);
    let mut x712: u64 = 0;
    let mut x713: fiat_p521_scalar_u1 = 0;
    let (x712, x713) = fiat_p521_scalar_addcarryx_u64(x711, x687, x684);
    let mut x714: u64 = 0;
    let mut x715: fiat_p521_scalar_u1 = 0;
    let (x714, x715) = fiat_p521_scalar_addcarryx_u64(x713, x685, x682);
    let mut x716: u64 = 0;
    let mut x717: fiat_p521_scalar_u1 = 0;
    let (x716, x717) = fiat_p521_scalar_addcarryx_u64(0x0, x662, x698);
    let mut x718: u64 = 0;
    let mut x719: fiat_p521_scalar_u1 = 0;
    let (x718, x719) = fiat_p521_scalar_addcarryx_u64(x717, x664, x700);
    let mut x720: u64 = 0;
    let mut x721: fiat_p521_scalar_u1 = 0;
    let (x720, x721) = fiat_p521_scalar_addcarryx_u64(x719, x666, x702);
    let mut x722: u64 = 0;
    let mut x723: fiat_p521_scalar_u1 = 0;
    let (x722, x723) = fiat_p521_scalar_addcarryx_u64(x721, x668, x704);
    let mut x724: u64 = 0;
    let mut x725: fiat_p521_scalar_u1 = 0;
    let (x724, x725) = fiat_p521_scalar_addcarryx_u64(x723, x670, x706);
    let mut x726: u64 = 0;
    let mut x727: fiat_p521_scalar_u1 = 0;
    let (x726, x727) = fiat_p521_scalar_addcarryx_u64(x725, x672, x708);
    let mut x728: u64 = 0;
    let mut x729: fiat_p521_scalar_u1 = 0;
    let (x728, x729) = fiat_p521_scalar_addcarryx_u64(x727, x674, x710);
    let mut x730: u64 = 0;
    let mut x731: fiat_p521_scalar_u1 = 0;
    let (x730, x731) = fiat_p521_scalar_addcarryx_u64(x729, x676, x712);
    let mut x732: u64 = 0;
    let mut x733: fiat_p521_scalar_u1 = 0;
    let (x732, x733) = fiat_p521_scalar_addcarryx_u64(x731, x678, x714);
    let mut x734: u64 = 0;
    let mut x735: u64 = 0;
    let (x734, x735) = fiat_p521_scalar_mulx_u64(x7, 0x3d);
    let mut x736: u64 = 0;
    let mut x737: u64 = 0;
    let (x736, x737) = fiat_p521_scalar_mulx_u64(x7, 0x2d8e03d1492d0d45);
    let mut x738: u64 = 0;
    let mut x739: u64 = 0;
    let (x738, x739) = fiat_p521_scalar_mulx_u64(x7, 0x5bcc6d61a8e567bc);
    let mut x740: u64 = 0;
    let mut x741: u64 = 0;
    let (x740, x741) = fiat_p521_scalar_mulx_u64(x7, 0xcff3d142b7756e3e);
    let mut x742: u64 = 0;
    let mut x743: u64 = 0;
    let (x742, x743) = fiat_p521_scalar_mulx_u64(x7, 0xdd6e23d82e49c7db);
    let mut x744: u64 = 0;
    let mut x745: u64 = 0;
    let (x744, x745) = fiat_p521_scalar_mulx_u64(x7, 0xd3721ef557f75e06);
    let mut x746: u64 = 0;
    let mut x747: u64 = 0;
    let (x746, x747) = fiat_p521_scalar_mulx_u64(x7, 0x12a78d38794573ff);
    let mut x748: u64 = 0;
    let mut x749: u64 = 0;
    let (x748, x749) = fiat_p521_scalar_mulx_u64(x7, 0xf707badce5547ea3);
    let mut x750: u64 = 0;
    let mut x751: u64 = 0;
    let (x750, x751) = fiat_p521_scalar_mulx_u64(x7, 0x137cd04dcf15dd04);
    let mut x752: u64 = 0;
    let mut x753: fiat_p521_scalar_u1 = 0;
    let (x752, x753) = fiat_p521_scalar_addcarryx_u64(0x0, x751, x748);
    let mut x754: u64 = 0;
    let mut x755: fiat_p521_scalar_u1 = 0;
    let (x754, x755) = fiat_p521_scalar_addcarryx_u64(x753, x749, x746);
    let mut x756: u64 = 0;
    let mut x757: fiat_p521_scalar_u1 = 0;
    let (x756, x757) = fiat_p521_scalar_addcarryx_u64(x755, x747, x744);
    let mut x758: u64 = 0;
    let mut x759: fiat_p521_scalar_u1 = 0;
    let (x758, x759) = fiat_p521_scalar_addcarryx_u64(x757, x745, x742);
    let mut x760: u64 = 0;
    let mut x761: fiat_p521_scalar_u1 = 0;
    let (x760, x761) = fiat_p521_scalar_addcarryx_u64(x759, x743, x740);
    let mut x762: u64 = 0;
    let mut x763: fiat_p521_scalar_u1 = 0;
    let (x762, x763) = fiat_p521_scalar_addcarryx_u64(x761, x741, x738);
    let mut x764: u64 = 0;
    let mut x765: fiat_p521_scalar_u1 = 0;
    let (x764, x765) = fiat_p521_scalar_addcarryx_u64(x763, x739, x736);
    let mut x766: u64 = 0;
    let mut x767: fiat_p521_scalar_u1 = 0;
    let (x766, x767) = fiat_p521_scalar_addcarryx_u64(x765, x737, x734);
    let mut x768: u64 = 0;
    let mut x769: fiat_p521_scalar_u1 = 0;
    let (x768, x769) = fiat_p521_scalar_addcarryx_u64(0x0, x718, x750);
    let mut x770: u64 = 0;
    let mut x771: fiat_p521_scalar_u1 = 0;
    let (x770, x771) = fiat_p521_scalar_addcarryx_u64(x769, x720, x752);
    let mut x772: u64 = 0;
    let mut x773: fiat_p521_scalar_u1 = 0;
    let (x772, x773) = fiat_p521_scalar_addcarryx_u64(x771, x722, x754);
    let mut x774: u64 = 0;
    let mut x775: fiat_p521_scalar_u1 = 0;
    let (x774, x775) = fiat_p521_scalar_addcarryx_u64(x773, x724, x756);
    let mut x776: u64 = 0;
    let mut x777: fiat_p521_scalar_u1 = 0;
    let (x776, x777) = fiat_p521_scalar_addcarryx_u64(x775, x726, x758);
    let mut x778: u64 = 0;
    let mut x779: fiat_p521_scalar_u1 = 0;
    let (x778, x779) = fiat_p521_scalar_addcarryx_u64(x777, x728, x760);
    let mut x780: u64 = 0;
    let mut x781: fiat_p521_scalar_u1 = 0;
    let (x780, x781) = fiat_p521_scalar_addcarryx_u64(x779, x730, x762);
    let mut x782: u64 = 0;
    let mut x783: fiat_p521_scalar_u1 = 0;
    let (x782, x783) = fiat_p521_scalar_addcarryx_u64(x781, x732, x764);
    let mut x784: u64 = 0;
    let mut x785: fiat_p521_scalar_u1 = 0;
    let (x784, x785) = fiat_p521_scalar_addcarryx_u64(
        x783,
        (((x733 as u64) + ((x679 as u64) + ((x661 as u64) + x629))) + ((x715 as u64) + x683)),
        x766,
    );
    let mut x786: u64 = 0;
    let mut x787: u64 = 0;
    let (x786, x787) = fiat_p521_scalar_mulx_u64(x768, 0x1d2f5ccd79a995c7);
    let mut x788: u64 = 0;
    let mut x789: u64 = 0;
    let (x788, x789) = fiat_p521_scalar_mulx_u64(x786, 0x1ff);
    let mut x790: u64 = 0;
    let mut x791: u64 = 0;
    let (x790, x791) = fiat_p521_scalar_mulx_u64(x786, 0xffffffffffffffff);
    let mut x792: u64 = 0;
    let mut x793: u64 = 0;
    let (x792, x793) = fiat_p521_scalar_mulx_u64(x786, 0xffffffffffffffff);
    let mut x794: u64 = 0;
    let mut x795: u64 = 0;
    let (x794, x795) = fiat_p521_scalar_mulx_u64(x786, 0xffffffffffffffff);
    let mut x796: u64 = 0;
    let mut x797: u64 = 0;
    let (x796, x797) = fiat_p521_scalar_mulx_u64(x786, 0xfffffffffffffffa);
    let mut x798: u64 = 0;
    let mut x799: u64 = 0;
    let (x798, x799) = fiat_p521_scalar_mulx_u64(x786, 0x51868783bf2f966b);
    let mut x800: u64 = 0;
    let mut x801: u64 = 0;
    let (x800, x801) = fiat_p521_scalar_mulx_u64(x786, 0x7fcc0148f709a5d0);
    let mut x802: u64 = 0;
    let mut x803: u64 = 0;
    let (x802, x803) = fiat_p521_scalar_mulx_u64(x786, 0x3bb5c9b8899c47ae);
    let mut x804: u64 = 0;
    let mut x805: u64 = 0;
    let (x804, x805) = fiat_p521_scalar_mulx_u64(x786, 0xbb6fb71e91386409);
    let mut x806: u64 = 0;
    let mut x807: fiat_p521_scalar_u1 = 0;
    let (x806, x807) = fiat_p521_scalar_addcarryx_u64(0x0, x805, x802);
    let mut x808: u64 = 0;
    let mut x809: fiat_p521_scalar_u1 = 0;
    let (x808, x809) = fiat_p521_scalar_addcarryx_u64(x807, x803, x800);
    let mut x810: u64 = 0;
    let mut x811: fiat_p521_scalar_u1 = 0;
    let (x810, x811) = fiat_p521_scalar_addcarryx_u64(x809, x801, x798);
    let mut x812: u64 = 0;
    let mut x813: fiat_p521_scalar_u1 = 0;
    let (x812, x813) = fiat_p521_scalar_addcarryx_u64(x811, x799, x796);
    let mut x814: u64 = 0;
    let mut x815: fiat_p521_scalar_u1 = 0;
    let (x814, x815) = fiat_p521_scalar_addcarryx_u64(x813, x797, x794);
    let mut x816: u64 = 0;
    let mut x817: fiat_p521_scalar_u1 = 0;
    let (x816, x817) = fiat_p521_scalar_addcarryx_u64(x815, x795, x792);
    let mut x818: u64 = 0;
    let mut x819: fiat_p521_scalar_u1 = 0;
    let (x818, x819) = fiat_p521_scalar_addcarryx_u64(x817, x793, x790);
    let mut x820: u64 = 0;
    let mut x821: fiat_p521_scalar_u1 = 0;
    let (x820, x821) = fiat_p521_scalar_addcarryx_u64(x819, x791, x788);
    let mut x822: u64 = 0;
    let mut x823: fiat_p521_scalar_u1 = 0;
    let (x822, x823) = fiat_p521_scalar_addcarryx_u64(0x0, x768, x804);
    let mut x824: u64 = 0;
    let mut x825: fiat_p521_scalar_u1 = 0;
    let (x824, x825) = fiat_p521_scalar_addcarryx_u64(x823, x770, x806);
    let mut x826: u64 = 0;
    let mut x827: fiat_p521_scalar_u1 = 0;
    let (x826, x827) = fiat_p521_scalar_addcarryx_u64(x825, x772, x808);
    let mut x828: u64 = 0;
    let mut x829: fiat_p521_scalar_u1 = 0;
    let (x828, x829) = fiat_p521_scalar_addcarryx_u64(x827, x774, x810);
    let mut x830: u64 = 0;
    let mut x831: fiat_p521_scalar_u1 = 0;
    let (x830, x831) = fiat_p521_scalar_addcarryx_u64(x829, x776, x812);
    let mut x832: u64 = 0;
    let mut x833: fiat_p521_scalar_u1 = 0;
    let (x832, x833) = fiat_p521_scalar_addcarryx_u64(x831, x778, x814);
    let mut x834: u64 = 0;
    let mut x835: fiat_p521_scalar_u1 = 0;
    let (x834, x835) = fiat_p521_scalar_addcarryx_u64(x833, x780, x816);
    let mut x836: u64 = 0;
    let mut x837: fiat_p521_scalar_u1 = 0;
    let (x836, x837) = fiat_p521_scalar_addcarryx_u64(x835, x782, x818);
    let mut x838: u64 = 0;
    let mut x839: fiat_p521_scalar_u1 = 0;
    let (x838, x839) = fiat_p521_scalar_addcarryx_u64(x837, x784, x820);
    let mut x840: u64 = 0;
    let mut x841: u64 = 0;
    let (x840, x841) = fiat_p521_scalar_mulx_u64(x8, 0x3d);
    let mut x842: u64 = 0;
    let mut x843: u64 = 0;
    let (x842, x843) = fiat_p521_scalar_mulx_u64(x8, 0x2d8e03d1492d0d45);
    let mut x844: u64 = 0;
    let mut x845: u64 = 0;
    let (x844, x845) = fiat_p521_scalar_mulx_u64(x8, 0x5bcc6d61a8e567bc);
    let mut x846: u64 = 0;
    let mut x847: u64 = 0;
    let (x846, x847) = fiat_p521_scalar_mulx_u64(x8, 0xcff3d142b7756e3e);
    let mut x848: u64 = 0;
    let mut x849: u64 = 0;
    let (x848, x849) = fiat_p521_scalar_mulx_u64(x8, 0xdd6e23d82e49c7db);
    let mut x850: u64 = 0;
    let mut x851: u64 = 0;
    let (x850, x851) = fiat_p521_scalar_mulx_u64(x8, 0xd3721ef557f75e06);
    let mut x852: u64 = 0;
    let mut x853: u64 = 0;
    let (x852, x853) = fiat_p521_scalar_mulx_u64(x8, 0x12a78d38794573ff);
    let mut x854: u64 = 0;
    let mut x855: u64 = 0;
    let (x854, x855) = fiat_p521_scalar_mulx_u64(x8, 0xf707badce5547ea3);
    let mut x856: u64 = 0;
    let mut x857: u64 = 0;
    let (x856, x857) = fiat_p521_scalar_mulx_u64(x8, 0x137cd04dcf15dd04);
    let mut x858: u64 = 0;
    let mut x859: fiat_p521_scalar_u1 = 0;
    let (x858, x859) = fiat_p521_scalar_addcarryx_u64(0x0, x857, x854);
    let mut x860: u64 = 0;
    let mut x861: fiat_p521_scalar_u1 = 0;
    let (x860, x861) = fiat_p521_scalar_addcarryx_u64(x859, x855, x852);
    let mut x862: u64 = 0;
    let mut x863: fiat_p521_scalar_u1 = 0;
    let (x862, x863) = fiat_p521_scalar_addcarryx_u64(x861, x853, x850);
    let mut x864: u64 = 0;
    let mut x865: fiat_p521_scalar_u1 = 0;
    let (x864, x865) = fiat_p521_scalar_addcarryx_u64(x863, x851, x848);
    let mut x866: u64 = 0;
    let mut x867: fiat_p521_scalar_u1 = 0;
    let (x866, x867) = fiat_p521_scalar_addcarryx_u64(x865, x849, x846);
    let mut x868: u64 = 0;
    let mut x869: fiat_p521_scalar_u1 = 0;
    let (x868, x869) = fiat_p521_scalar_addcarryx_u64(x867, x847, x844);
    let mut x870: u64 = 0;
    let mut x871: fiat_p521_scalar_u1 = 0;
    let (x870, x871) = fiat_p521_scalar_addcarryx_u64(x869, x845, x842);
    let mut x872: u64 = 0;
    let mut x873: fiat_p521_scalar_u1 = 0;
    let (x872, x873) = fiat_p521_scalar_addcarryx_u64(x871, x843, x840);
    let mut x874: u64 = 0;
    let mut x875: fiat_p521_scalar_u1 = 0;
    let (x874, x875) = fiat_p521_scalar_addcarryx_u64(0x0, x824, x856);
    let mut x876: u64 = 0;
    let mut x877: fiat_p521_scalar_u1 = 0;
    let (x876, x877) = fiat_p521_scalar_addcarryx_u64(x875, x826, x858);
    let mut x878: u64 = 0;
    let mut x879: fiat_p521_scalar_u1 = 0;
    let (x878, x879) = fiat_p521_scalar_addcarryx_u64(x877, x828, x860);
    let mut x880: u64 = 0;
    let mut x881: fiat_p521_scalar_u1 = 0;
    let (x880, x881) = fiat_p521_scalar_addcarryx_u64(x879, x830, x862);
    let mut x882: u64 = 0;
    let mut x883: fiat_p521_scalar_u1 = 0;
    let (x882, x883) = fiat_p521_scalar_addcarryx_u64(x881, x832, x864);
    let mut x884: u64 = 0;
    let mut x885: fiat_p521_scalar_u1 = 0;
    let (x884, x885) = fiat_p521_scalar_addcarryx_u64(x883, x834, x866);
    let mut x886: u64 = 0;
    let mut x887: fiat_p521_scalar_u1 = 0;
    let (x886, x887) = fiat_p521_scalar_addcarryx_u64(x885, x836, x868);
    let mut x888: u64 = 0;
    let mut x889: fiat_p521_scalar_u1 = 0;
    let (x888, x889) = fiat_p521_scalar_addcarryx_u64(x887, x838, x870);
    let mut x890: u64 = 0;
    let mut x891: fiat_p521_scalar_u1 = 0;
    let (x890, x891) = fiat_p521_scalar_addcarryx_u64(
        x889,
        (((x839 as u64) + ((x785 as u64) + ((x767 as u64) + x735))) + ((x821 as u64) + x789)),
        x872,
    );
    let mut x892: u64 = 0;
    let mut x893: u64 = 0;
    let (x892, x893) = fiat_p521_scalar_mulx_u64(x874, 0x1d2f5ccd79a995c7);
    let mut x894: u64 = 0;
    let mut x895: u64 = 0;
    let (x894, x895) = fiat_p521_scalar_mulx_u64(x892, 0x1ff);
    let mut x896: u64 = 0;
    let mut x897: u64 = 0;
    let (x896, x897) = fiat_p521_scalar_mulx_u64(x892, 0xffffffffffffffff);
    let mut x898: u64 = 0;
    let mut x899: u64 = 0;
    let (x898, x899) = fiat_p521_scalar_mulx_u64(x892, 0xffffffffffffffff);
    let mut x900: u64 = 0;
    let mut x901: u64 = 0;
    let (x900, x901) = fiat_p521_scalar_mulx_u64(x892, 0xffffffffffffffff);
    let mut x902: u64 = 0;
    let mut x903: u64 = 0;
    let (x902, x903) = fiat_p521_scalar_mulx_u64(x892, 0xfffffffffffffffa);
    let mut x904: u64 = 0;
    let mut x905: u64 = 0;
    let (x904, x905) = fiat_p521_scalar_mulx_u64(x892, 0x51868783bf2f966b);
    let mut x906: u64 = 0;
    let mut x907: u64 = 0;
    let (x906, x907) = fiat_p521_scalar_mulx_u64(x892, 0x7fcc0148f709a5d0);
    let mut x908: u64 = 0;
    let mut x909: u64 = 0;
    let (x908, x909) = fiat_p521_scalar_mulx_u64(x892, 0x3bb5c9b8899c47ae);
    let mut x910: u64 = 0;
    let mut x911: u64 = 0;
    let (x910, x911) = fiat_p521_scalar_mulx_u64(x892, 0xbb6fb71e91386409);
    let mut x912: u64 = 0;
    let mut x913: fiat_p521_scalar_u1 = 0;
    let (x912, x913) = fiat_p521_scalar_addcarryx_u64(0x0, x911, x908);
    let mut x914: u64 = 0;
    let mut x915: fiat_p521_scalar_u1 = 0;
    let (x914, x915) = fiat_p521_scalar_addcarryx_u64(x913, x909, x906);
    let mut x916: u64 = 0;
    let mut x917: fiat_p521_scalar_u1 = 0;
    let (x916, x917) = fiat_p521_scalar_addcarryx_u64(x915, x907, x904);
    let mut x918: u64 = 0;
    let mut x919: fiat_p521_scalar_u1 = 0;
    let (x918, x919) = fiat_p521_scalar_addcarryx_u64(x917, x905, x902);
    let mut x920: u64 = 0;
    let mut x921: fiat_p521_scalar_u1 = 0;
    let (x920, x921) = fiat_p521_scalar_addcarryx_u64(x919, x903, x900);
    let mut x922: u64 = 0;
    let mut x923: fiat_p521_scalar_u1 = 0;
    let (x922, x923) = fiat_p521_scalar_addcarryx_u64(x921, x901, x898);
    let mut x924: u64 = 0;
    let mut x925: fiat_p521_scalar_u1 = 0;
    let (x924, x925) = fiat_p521_scalar_addcarryx_u64(x923, x899, x896);
    let mut x926: u64 = 0;
    let mut x927: fiat_p521_scalar_u1 = 0;
    let (x926, x927) = fiat_p521_scalar_addcarryx_u64(x925, x897, x894);
    let mut x928: u64 = 0;
    let mut x929: fiat_p521_scalar_u1 = 0;
    let (x928, x929) = fiat_p521_scalar_addcarryx_u64(0x0, x874, x910);
    let mut x930: u64 = 0;
    let mut x931: fiat_p521_scalar_u1 = 0;
    let (x930, x931) = fiat_p521_scalar_addcarryx_u64(x929, x876, x912);
    let mut x932: u64 = 0;
    let mut x933: fiat_p521_scalar_u1 = 0;
    let (x932, x933) = fiat_p521_scalar_addcarryx_u64(x931, x878, x914);
    let mut x934: u64 = 0;
    let mut x935: fiat_p521_scalar_u1 = 0;
    let (x934, x935) = fiat_p521_scalar_addcarryx_u64(x933, x880, x916);
    let mut x936: u64 = 0;
    let mut x937: fiat_p521_scalar_u1 = 0;
    let (x936, x937) = fiat_p521_scalar_addcarryx_u64(x935, x882, x918);
    let mut x938: u64 = 0;
    let mut x939: fiat_p521_scalar_u1 = 0;
    let (x938, x939) = fiat_p521_scalar_addcarryx_u64(x937, x884, x920);
    let mut x940: u64 = 0;
    let mut x941: fiat_p521_scalar_u1 = 0;
    let (x940, x941) = fiat_p521_scalar_addcarryx_u64(x939, x886, x922);
    let mut x942: u64 = 0;
    let mut x943: fiat_p521_scalar_u1 = 0;
    let (x942, x943) = fiat_p521_scalar_addcarryx_u64(x941, x888, x924);
    let mut x944: u64 = 0;
    let mut x945: fiat_p521_scalar_u1 = 0;
    let (x944, x945) = fiat_p521_scalar_addcarryx_u64(x943, x890, x926);
    let x946: u64 =
        (((x945 as u64) + ((x891 as u64) + ((x873 as u64) + x841))) + ((x927 as u64) + x895));
    let mut x947: u64 = 0;
    let mut x948: fiat_p521_scalar_u1 = 0;
    let (x947, x948) = fiat_p521_scalar_subborrowx_u64(0x0, x930, 0xbb6fb71e91386409);
    let mut x949: u64 = 0;
    let mut x950: fiat_p521_scalar_u1 = 0;
    let (x949, x950) = fiat_p521_scalar_subborrowx_u64(x948, x932, 0x3bb5c9b8899c47ae);
    let mut x951: u64 = 0;
    let mut x952: fiat_p521_scalar_u1 = 0;
    let (x951, x952) = fiat_p521_scalar_subborrowx_u64(x950, x934, 0x7fcc0148f709a5d0);
    let mut x953: u64 = 0;
    let mut x954: fiat_p521_scalar_u1 = 0;
    let (x953, x954) = fiat_p521_scalar_subborrowx_u64(x952, x936, 0x51868783bf2f966b);
    let mut x955: u64 = 0;
    let mut x956: fiat_p521_scalar_u1 = 0;
    let (x955, x956) = fiat_p521_scalar_subborrowx_u64(x954, x938, 0xfffffffffffffffa);
    let mut x957: u64 = 0;
    let mut x958: fiat_p521_scalar_u1 = 0;
    let (x957, x958) = fiat_p521_scalar_subborrowx_u64(x956, x940, 0xffffffffffffffff);
    let mut x959: u64 = 0;
    let mut x960: fiat_p521_scalar_u1 = 0;
    let (x959, x960) = fiat_p521_scalar_subborrowx_u64(x958, x942, 0xffffffffffffffff);
    let mut x961: u64 = 0;
    let mut x962: fiat_p521_scalar_u1 = 0;
    let (x961, x962) = fiat_p521_scalar_subborrowx_u64(x960, x944, 0xffffffffffffffff);
    let mut x963: u64 = 0;
    let mut x964: fiat_p521_scalar_u1 = 0;
    let (x963, x964) = fiat_p521_scalar_subborrowx_u64(x962, x946, 0x1ff);
    let mut x965: u64 = 0;
    let mut x966: fiat_p521_scalar_u1 = 0;
    let (x965, x966) = fiat_p521_scalar_subborrowx_u64(x964, (0x0 as u64), (0x0 as u64));
    let mut x967: u64 = 0;
    let (x967) = fiat_p521_scalar_cmovznz_u64(x966, x947, x930);
    let mut x968: u64 = 0;
    let (x968) = fiat_p521_scalar_cmovznz_u64(x966, x949, x932);
    let mut x969: u64 = 0;
    let (x969) = fiat_p521_scalar_cmovznz_u64(x966, x951, x934);
    let mut x970: u64 = 0;
    let (x970) = fiat_p521_scalar_cmovznz_u64(x966, x953, x936);
    let mut x971: u64 = 0;
    let (x971) = fiat_p521_scalar_cmovznz_u64(x966, x955, x938);
    let mut x972: u64 = 0;
    let (x972) = fiat_p521_scalar_cmovznz_u64(x966, x957, x940);
    let mut x973: u64 = 0;
    let (x973) = fiat_p521_scalar_cmovznz_u64(x966, x959, x942);
    let mut x974: u64 = 0;
    let (x974) = fiat_p521_scalar_cmovznz_u64(x966, x961, x944);
    let mut x975: u64 = 0;
    let (x975) = fiat_p521_scalar_cmovznz_u64(x966, x963, x946);
    out1[0] = x967;
    out1[1] = x968;
    out1[2] = x969;
    out1[3] = x970;
    out1[4] = x971;
    out1[5] = x972;
    out1[6] = x973;
    out1[7] = x974;
    out1[8] = x975;
    out1
}
#[doc = " The function fiat_p521_scalar_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p521_scalar_nonzero(arg1: &[u64; 9]) -> u64 {
    let mut out1: u64 = 0;
    let x1: u64 = ((arg1[0])
        | ((arg1[1])
            | ((arg1[2])
                | ((arg1[3])
                    | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | ((arg1[7]) | (arg1[8])))))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p521_scalar_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p521_scalar_selectznz(
    arg1: fiat_p521_scalar_u1,
    arg2: &[u64; 9],
    arg3: &[u64; 9],
) -> [u64; 9] {
    let mut out1: [u64; 9] = [0; 9];
    let mut x1: u64 = 0;
    let (x1) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[0]), (arg3[0]));
    let mut x2: u64 = 0;
    let (x2) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[1]), (arg3[1]));
    let mut x3: u64 = 0;
    let (x3) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[2]), (arg3[2]));
    let mut x4: u64 = 0;
    let (x4) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[3]), (arg3[3]));
    let mut x5: u64 = 0;
    let (x5) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[4]), (arg3[4]));
    let mut x6: u64 = 0;
    let (x6) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[5]), (arg3[5]));
    let mut x7: u64 = 0;
    let (x7) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[6]), (arg3[6]));
    let mut x8: u64 = 0;
    let (x8) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[7]), (arg3[7]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p521_scalar_cmovznz_u64(arg1, (arg2[8]), (arg3[8]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1
}
#[doc = " The function fiat_p521_scalar_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..65]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1ff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]"]
#[inline]
pub const fn fiat_p521_scalar_to_bytes(arg1: &[u64; 9]) -> [u8; 66] {
    let mut out1: [u8; 66] = [0; 66];
    let x1: u64 = (arg1[8]);
    let x2: u64 = (arg1[7]);
    let x3: u64 = (arg1[6]);
    let x4: u64 = (arg1[5]);
    let x5: u64 = (arg1[4]);
    let x6: u64 = (arg1[3]);
    let x7: u64 = (arg1[2]);
    let x8: u64 = (arg1[1]);
    let x9: u64 = (arg1[0]);
    let x10: u8 = ((x9 & (0xff as u64)) as u8);
    let x11: u64 = (x9 >> 8);
    let x12: u8 = ((x11 & (0xff as u64)) as u8);
    let x13: u64 = (x11 >> 8);
    let x14: u8 = ((x13 & (0xff as u64)) as u8);
    let x15: u64 = (x13 >> 8);
    let x16: u8 = ((x15 & (0xff as u64)) as u8);
    let x17: u64 = (x15 >> 8);
    let x18: u8 = ((x17 & (0xff as u64)) as u8);
    let x19: u64 = (x17 >> 8);
    let x20: u8 = ((x19 & (0xff as u64)) as u8);
    let x21: u64 = (x19 >> 8);
    let x22: u8 = ((x21 & (0xff as u64)) as u8);
    let x23: u8 = ((x21 >> 8) as u8);
    let x24: u8 = ((x8 & (0xff as u64)) as u8);
    let x25: u64 = (x8 >> 8);
    let x26: u8 = ((x25 & (0xff as u64)) as u8);
    let x27: u64 = (x25 >> 8);
    let x28: u8 = ((x27 & (0xff as u64)) as u8);
    let x29: u64 = (x27 >> 8);
    let x30: u8 = ((x29 & (0xff as u64)) as u8);
    let x31: u64 = (x29 >> 8);
    let x32: u8 = ((x31 & (0xff as u64)) as u8);
    let x33: u64 = (x31 >> 8);
    let x34: u8 = ((x33 & (0xff as u64)) as u8);
    let x35: u64 = (x33 >> 8);
    let x36: u8 = ((x35 & (0xff as u64)) as u8);
    let x37: u8 = ((x35 >> 8) as u8);
    let x38: u8 = ((x7 & (0xff as u64)) as u8);
    let x39: u64 = (x7 >> 8);
    let x40: u8 = ((x39 & (0xff as u64)) as u8);
    let x41: u64 = (x39 >> 8);
    let x42: u8 = ((x41 & (0xff as u64)) as u8);
    let x43: u64 = (x41 >> 8);
    let x44: u8 = ((x43 & (0xff as u64)) as u8);
    let x45: u64 = (x43 >> 8);
    let x46: u8 = ((x45 & (0xff as u64)) as u8);
    let x47: u64 = (x45 >> 8);
    let x48: u8 = ((x47 & (0xff as u64)) as u8);
    let x49: u64 = (x47 >> 8);
    let x50: u8 = ((x49 & (0xff as u64)) as u8);
    let x51: u8 = ((x49 >> 8) as u8);
    let x52: u8 = ((x6 & (0xff as u64)) as u8);
    let x53: u64 = (x6 >> 8);
    let x54: u8 = ((x53 & (0xff as u64)) as u8);
    let x55: u64 = (x53 >> 8);
    let x56: u8 = ((x55 & (0xff as u64)) as u8);
    let x57: u64 = (x55 >> 8);
    let x58: u8 = ((x57 & (0xff as u64)) as u8);
    let x59: u64 = (x57 >> 8);
    let x60: u8 = ((x59 & (0xff as u64)) as u8);
    let x61: u64 = (x59 >> 8);
    let x62: u8 = ((x61 & (0xff as u64)) as u8);
    let x63: u64 = (x61 >> 8);
    let x64: u8 = ((x63 & (0xff as u64)) as u8);
    let x65: u8 = ((x63 >> 8) as u8);
    let x66: u8 = ((x5 & (0xff as u64)) as u8);
    let x67: u64 = (x5 >> 8);
    let x68: u8 = ((x67 & (0xff as u64)) as u8);
    let x69: u64 = (x67 >> 8);
    let x70: u8 = ((x69 & (0xff as u64)) as u8);
    let x71: u64 = (x69 >> 8);
    let x72: u8 = ((x71 & (0xff as u64)) as u8);
    let x73: u64 = (x71 >> 8);
    let x74: u8 = ((x73 & (0xff as u64)) as u8);
    let x75: u64 = (x73 >> 8);
    let x76: u8 = ((x75 & (0xff as u64)) as u8);
    let x77: u64 = (x75 >> 8);
    let x78: u8 = ((x77 & (0xff as u64)) as u8);
    let x79: u8 = ((x77 >> 8) as u8);
    let x80: u8 = ((x4 & (0xff as u64)) as u8);
    let x81: u64 = (x4 >> 8);
    let x82: u8 = ((x81 & (0xff as u64)) as u8);
    let x83: u64 = (x81 >> 8);
    let x84: u8 = ((x83 & (0xff as u64)) as u8);
    let x85: u64 = (x83 >> 8);
    let x86: u8 = ((x85 & (0xff as u64)) as u8);
    let x87: u64 = (x85 >> 8);
    let x88: u8 = ((x87 & (0xff as u64)) as u8);
    let x89: u64 = (x87 >> 8);
    let x90: u8 = ((x89 & (0xff as u64)) as u8);
    let x91: u64 = (x89 >> 8);
    let x92: u8 = ((x91 & (0xff as u64)) as u8);
    let x93: u8 = ((x91 >> 8) as u8);
    let x94: u8 = ((x3 & (0xff as u64)) as u8);
    let x95: u64 = (x3 >> 8);
    let x96: u8 = ((x95 & (0xff as u64)) as u8);
    let x97: u64 = (x95 >> 8);
    let x98: u8 = ((x97 & (0xff as u64)) as u8);
    let x99: u64 = (x97 >> 8);
    let x100: u8 = ((x99 & (0xff as u64)) as u8);
    let x101: u64 = (x99 >> 8);
    let x102: u8 = ((x101 & (0xff as u64)) as u8);
    let x103: u64 = (x101 >> 8);
    let x104: u8 = ((x103 & (0xff as u64)) as u8);
    let x105: u64 = (x103 >> 8);
    let x106: u8 = ((x105 & (0xff as u64)) as u8);
    let x107: u8 = ((x105 >> 8) as u8);
    let x108: u8 = ((x2 & (0xff as u64)) as u8);
    let x109: u64 = (x2 >> 8);
    let x110: u8 = ((x109 & (0xff as u64)) as u8);
    let x111: u64 = (x109 >> 8);
    let x112: u8 = ((x111 & (0xff as u64)) as u8);
    let x113: u64 = (x111 >> 8);
    let x114: u8 = ((x113 & (0xff as u64)) as u8);
    let x115: u64 = (x113 >> 8);
    let x116: u8 = ((x115 & (0xff as u64)) as u8);
    let x117: u64 = (x115 >> 8);
    let x118: u8 = ((x117 & (0xff as u64)) as u8);
    let x119: u64 = (x117 >> 8);
    let x120: u8 = ((x119 & (0xff as u64)) as u8);
    let x121: u8 = ((x119 >> 8) as u8);
    let x122: u8 = ((x1 & (0xff as u64)) as u8);
    let x123: fiat_p521_scalar_u1 = ((x1 >> 8) as fiat_p521_scalar_u1);
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
    out1[4] = x18;
    out1[5] = x20;
    out1[6] = x22;
    out1[7] = x23;
    out1[8] = x24;
    out1[9] = x26;
    out1[10] = x28;
    out1[11] = x30;
    out1[12] = x32;
    out1[13] = x34;
    out1[14] = x36;
    out1[15] = x37;
    out1[16] = x38;
    out1[17] = x40;
    out1[18] = x42;
    out1[19] = x44;
    out1[20] = x46;
    out1[21] = x48;
    out1[22] = x50;
    out1[23] = x51;
    out1[24] = x52;
    out1[25] = x54;
    out1[26] = x56;
    out1[27] = x58;
    out1[28] = x60;
    out1[29] = x62;
    out1[30] = x64;
    out1[31] = x65;
    out1[32] = x66;
    out1[33] = x68;
    out1[34] = x70;
    out1[35] = x72;
    out1[36] = x74;
    out1[37] = x76;
    out1[38] = x78;
    out1[39] = x79;
    out1[40] = x80;
    out1[41] = x82;
    out1[42] = x84;
    out1[43] = x86;
    out1[44] = x88;
    out1[45] = x90;
    out1[46] = x92;
    out1[47] = x93;
    out1[48] = x94;
    out1[49] = x96;
    out1[50] = x98;
    out1[51] = x100;
    out1[52] = x102;
    out1[53] = x104;
    out1[54] = x106;
    out1[55] = x107;
    out1[56] = x108;
    out1[57] = x110;
    out1[58] = x112;
    out1[59] = x114;
    out1[60] = x116;
    out1[61] = x118;
    out1[62] = x120;
    out1[63] = x121;
    out1[64] = x122;
    out1[65] = (x123 as u8);
    out1
}
#[doc = " The function fiat_p521_scalar_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0x1]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0x1ff]]"]
#[inline]
pub const fn fiat_p521_scalar_from_bytes(arg1: &[u8; 66]) -> [u64; 9] {
    let mut out1: [u64; 9] = [0; 9];
    let x1: u64 = ((((arg1[65]) as fiat_p521_scalar_u1) as u64) << 8);
    let x2: u8 = (arg1[64]);
    let x3: u64 = (((arg1[63]) as u64) << 56);
    let x4: u64 = (((arg1[62]) as u64) << 48);
    let x5: u64 = (((arg1[61]) as u64) << 40);
    let x6: u64 = (((arg1[60]) as u64) << 32);
    let x7: u64 = (((arg1[59]) as u64) << 24);
    let x8: u64 = (((arg1[58]) as u64) << 16);
    let x9: u64 = (((arg1[57]) as u64) << 8);
    let x10: u8 = (arg1[56]);
    let x11: u64 = (((arg1[55]) as u64) << 56);
    let x12: u64 = (((arg1[54]) as u64) << 48);
    let x13: u64 = (((arg1[53]) as u64) << 40);
    let x14: u64 = (((arg1[52]) as u64) << 32);
    let x15: u64 = (((arg1[51]) as u64) << 24);
    let x16: u64 = (((arg1[50]) as u64) << 16);
    let x17: u64 = (((arg1[49]) as u64) << 8);
    let x18: u8 = (arg1[48]);
    let x19: u64 = (((arg1[47]) as u64) << 56);
    let x20: u64 = (((arg1[46]) as u64) << 48);
    let x21: u64 = (((arg1[45]) as u64) << 40);
    let x22: u64 = (((arg1[44]) as u64) << 32);
    let x23: u64 = (((arg1[43]) as u64) << 24);
    let x24: u64 = (((arg1[42]) as u64) << 16);
    let x25: u64 = (((arg1[41]) as u64) << 8);
    let x26: u8 = (arg1[40]);
    let x27: u64 = (((arg1[39]) as u64) << 56);
    let x28: u64 = (((arg1[38]) as u64) << 48);
    let x29: u64 = (((arg1[37]) as u64) << 40);
    let x30: u64 = (((arg1[36]) as u64) << 32);
    let x31: u64 = (((arg1[35]) as u64) << 24);
    let x32: u64 = (((arg1[34]) as u64) << 16);
    let x33: u64 = (((arg1[33]) as u64) << 8);
    let x34: u8 = (arg1[32]);
    let x35: u64 = (((arg1[31]) as u64) << 56);
    let x36: u64 = (((arg1[30]) as u64) << 48);
    let x37: u64 = (((arg1[29]) as u64) << 40);
    let x38: u64 = (((arg1[28]) as u64) << 32);
    let x39: u64 = (((arg1[27]) as u64) << 24);
    let x40: u64 = (((arg1[26]) as u64) << 16);
    let x41: u64 = (((arg1[25]) as u64) << 8);
    let x42: u8 = (arg1[24]);
    let x43: u64 = (((arg1[23]) as u64) << 56);
    let x44: u64 = (((arg1[22]) as u64) << 48);
    let x45: u64 = (((arg1[21]) as u64) << 40);
    let x46: u64 = (((arg1[20]) as u64) << 32);
    let x47: u64 = (((arg1[19]) as u64) << 24);
    let x48: u64 = (((arg1[18]) as u64) << 16);
    let x49: u64 = (((arg1[17]) as u64) << 8);
    let x50: u8 = (arg1[16]);
    let x51: u64 = (((arg1[15]) as u64) << 56);
    let x52: u64 = (((arg1[14]) as u64) << 48);
    let x53: u64 = (((arg1[13]) as u64) << 40);
    let x54: u64 = (((arg1[12]) as u64) << 32);
    let x55: u64 = (((arg1[11]) as u64) << 24);
    let x56: u64 = (((arg1[10]) as u64) << 16);
    let x57: u64 = (((arg1[9]) as u64) << 8);
    let x58: u8 = (arg1[8]);
    let x59: u64 = (((arg1[7]) as u64) << 56);
    let x60: u64 = (((arg1[6]) as u64) << 48);
    let x61: u64 = (((arg1[5]) as u64) << 40);
    let x62: u64 = (((arg1[4]) as u64) << 32);
    let x63: u64 = (((arg1[3]) as u64) << 24);
    let x64: u64 = (((arg1[2]) as u64) << 16);
    let x65: u64 = (((arg1[1]) as u64) << 8);
    let x66: u8 = (arg1[0]);
    let x67: u64 = (x65 + (x66 as u64));
    let x68: u64 = (x64 + x67);
    let x69: u64 = (x63 + x68);
    let x70: u64 = (x62 + x69);
    let x71: u64 = (x61 + x70);
    let x72: u64 = (x60 + x71);
    let x73: u64 = (x59 + x72);
    let x74: u64 = (x57 + (x58 as u64));
    let x75: u64 = (x56 + x74);
    let x76: u64 = (x55 + x75);
    let x77: u64 = (x54 + x76);
    let x78: u64 = (x53 + x77);
    let x79: u64 = (x52 + x78);
    let x80: u64 = (x51 + x79);
    let x81: u64 = (x49 + (x50 as u64));
    let x82: u64 = (x48 + x81);
    let x83: u64 = (x47 + x82);
    let x84: u64 = (x46 + x83);
    let x85: u64 = (x45 + x84);
    let x86: u64 = (x44 + x85);
    let x87: u64 = (x43 + x86);
    let x88: u64 = (x41 + (x42 as u64));
    let x89: u64 = (x40 + x88);
    let x90: u64 = (x39 + x89);
    let x91: u64 = (x38 + x90);
    let x92: u64 = (x37 + x91);
    let x93: u64 = (x36 + x92);
    let x94: u64 = (x35 + x93);
    let x95: u64 = (x33 + (x34 as u64));
    let x96: u64 = (x32 + x95);
    let x97: u64 = (x31 + x96);
    let x98: u64 = (x30 + x97);
    let x99: u64 = (x29 + x98);
    let x100: u64 = (x28 + x99);
    let x101: u64 = (x27 + x100);
    let x102: u64 = (x25 + (x26 as u64));
    let x103: u64 = (x24 + x102);
    let x104: u64 = (x23 + x103);
    let x105: u64 = (x22 + x104);
    let x106: u64 = (x21 + x105);
    let x107: u64 = (x20 + x106);
    let x108: u64 = (x19 + x107);
    let x109: u64 = (x17 + (x18 as u64));
    let x110: u64 = (x16 + x109);
    let x111: u64 = (x15 + x110);
    let x112: u64 = (x14 + x111);
    let x113: u64 = (x13 + x112);
    let x114: u64 = (x12 + x113);
    let x115: u64 = (x11 + x114);
    let x116: u64 = (x9 + (x10 as u64));
    let x117: u64 = (x8 + x116);
    let x118: u64 = (x7 + x117);
    let x119: u64 = (x6 + x118);
    let x120: u64 = (x5 + x119);
    let x121: u64 = (x4 + x120);
    let x122: u64 = (x3 + x121);
    let x123: u64 = (x1 + (x2 as u64));
    out1[0] = x73;
    out1[1] = x80;
    out1[2] = x87;
    out1[3] = x94;
    out1[4] = x101;
    out1[5] = x108;
    out1[6] = x115;
    out1[7] = x122;
    out1[8] = x123;
    out1
}
#[doc = " The function fiat_p521_scalar_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p521_scalar_set_one() -> fiat_p521_scalar_montgomery_domain_field_element {
    let mut out1: fiat_p521_scalar_montgomery_domain_field_element = [0; 9];
    out1[0] = 0xfb80000000000000;
    out1[1] = 0x28a2482470b763cd;
    out1[2] = 0x17e2251b23bb31dc;
    out1[3] = 0xca4019ff5b847b2d;
    out1[4] = 0x2d73cbc3e206834;
    out1[5] = (0x0 as u64);
    out1[6] = (0x0 as u64);
    out1[7] = (0x0 as u64);
    out1[8] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p521_scalar_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p521_scalar_msat() -> [u64; 10] {
    let mut out1: [u64; 10] = [0; 10];
    out1[0] = 0xbb6fb71e91386409;
    out1[1] = 0x3bb5c9b8899c47ae;
    out1[2] = 0x7fcc0148f709a5d0;
    out1[3] = 0x51868783bf2f966b;
    out1[4] = 0xfffffffffffffffa;
    out1[5] = 0xffffffffffffffff;
    out1[6] = 0xffffffffffffffff;
    out1[7] = 0xffffffffffffffff;
    out1[8] = 0x1ff;
    out1[9] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p521_scalar_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p521_scalar_divstep_precomp() -> [u64; 9] {
    let mut out1: [u64; 9] = [0; 9];
    out1[0] = 0x7b27a0cb33d1884b;
    out1[1] = 0x9ef6cb011f2467d8;
    out1[2] = 0x5fbc88e1d6e7fce;
    out1[3] = 0xb08222d0fe97e1dc;
    out1[4] = 0x1624870c44df3fce;
    out1[5] = 0xb7f07b8eedbce602;
    out1[6] = 0x62da93cf721f63bc;
    out1[7] = 0xafd209c16c4f0d20;
    out1[8] = 0x1c7;
    out1
}
#[doc = " The function fiat_p521_scalar_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p521_scalar_divstep(
    arg1: u64,
    arg2: &[u64; 10],
    arg3: &[u64; 10],
    arg4: &[u64; 9],
    arg5: &[u64; 9],
) -> (u64, [u64; 10], [u64; 10], [u64; 9], [u64; 9]) {
    let mut out1: u64 = 0;
    let mut out2: [u64; 10] = [0; 10];
    let mut out3: [u64; 10] = [0; 10];
    let mut out4: [u64; 9] = [0; 9];
    let mut out5: [u64; 9] = [0; 9];
    let mut x1: u64 = 0;
    let mut x2: fiat_p521_scalar_u1 = 0;
    let (x1, x2) = fiat_p521_scalar_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let x3: fiat_p521_scalar_u1 =
        (((x1 >> 63) as fiat_p521_scalar_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_p521_scalar_u1));
    let mut x4: u64 = 0;
    let mut x5: fiat_p521_scalar_u1 = 0;
    let (x4, x5) = fiat_p521_scalar_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let mut x6: u64 = 0;
    let (x6) = fiat_p521_scalar_cmovznz_u64(x3, arg1, x4);
    let mut x7: u64 = 0;
    let (x7) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[0]), (arg3[0]));
    let mut x8: u64 = 0;
    let (x8) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[1]), (arg3[1]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[2]), (arg3[2]));
    let mut x10: u64 = 0;
    let (x10) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[3]), (arg3[3]));
    let mut x11: u64 = 0;
    let (x11) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[4]), (arg3[4]));
    let mut x12: u64 = 0;
    let (x12) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[5]), (arg3[5]));
    let mut x13: u64 = 0;
    let (x13) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[6]), (arg3[6]));
    let mut x14: u64 = 0;
    let (x14) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[7]), (arg3[7]));
    let mut x15: u64 = 0;
    let (x15) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[8]), (arg3[8]));
    let mut x16: u64 = 0;
    let (x16) = fiat_p521_scalar_cmovznz_u64(x3, (arg2[9]), (arg3[9]));
    let mut x17: u64 = 0;
    let mut x18: fiat_p521_scalar_u1 = 0;
    let (x17, x18) = fiat_p521_scalar_addcarryx_u64(0x0, (0x1 as u64), (!(arg2[0])));
    let mut x19: u64 = 0;
    let mut x20: fiat_p521_scalar_u1 = 0;
    let (x19, x20) = fiat_p521_scalar_addcarryx_u64(x18, (0x0 as u64), (!(arg2[1])));
    let mut x21: u64 = 0;
    let mut x22: fiat_p521_scalar_u1 = 0;
    let (x21, x22) = fiat_p521_scalar_addcarryx_u64(x20, (0x0 as u64), (!(arg2[2])));
    let mut x23: u64 = 0;
    let mut x24: fiat_p521_scalar_u1 = 0;
    let (x23, x24) = fiat_p521_scalar_addcarryx_u64(x22, (0x0 as u64), (!(arg2[3])));
    let mut x25: u64 = 0;
    let mut x26: fiat_p521_scalar_u1 = 0;
    let (x25, x26) = fiat_p521_scalar_addcarryx_u64(x24, (0x0 as u64), (!(arg2[4])));
    let mut x27: u64 = 0;
    let mut x28: fiat_p521_scalar_u1 = 0;
    let (x27, x28) = fiat_p521_scalar_addcarryx_u64(x26, (0x0 as u64), (!(arg2[5])));
    let mut x29: u64 = 0;
    let mut x30: fiat_p521_scalar_u1 = 0;
    let (x29, x30) = fiat_p521_scalar_addcarryx_u64(x28, (0x0 as u64), (!(arg2[6])));
    let mut x31: u64 = 0;
    let mut x32: fiat_p521_scalar_u1 = 0;
    let (x31, x32) = fiat_p521_scalar_addcarryx_u64(x30, (0x0 as u64), (!(arg2[7])));
    let mut x33: u64 = 0;
    let mut x34: fiat_p521_scalar_u1 = 0;
    let (x33, x34) = fiat_p521_scalar_addcarryx_u64(x32, (0x0 as u64), (!(arg2[8])));
    let mut x35: u64 = 0;
    let mut x36: fiat_p521_scalar_u1 = 0;
    let (x35, x36) = fiat_p521_scalar_addcarryx_u64(x34, (0x0 as u64), (!(arg2[9])));
    let mut x37: u64 = 0;
    let (x37) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[0]), x17);
    let mut x38: u64 = 0;
    let (x38) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[1]), x19);
    let mut x39: u64 = 0;
    let (x39) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[2]), x21);
    let mut x40: u64 = 0;
    let (x40) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[3]), x23);
    let mut x41: u64 = 0;
    let (x41) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[4]), x25);
    let mut x42: u64 = 0;
    let (x42) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[5]), x27);
    let mut x43: u64 = 0;
    let (x43) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[6]), x29);
    let mut x44: u64 = 0;
    let (x44) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[7]), x31);
    let mut x45: u64 = 0;
    let (x45) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[8]), x33);
    let mut x46: u64 = 0;
    let (x46) = fiat_p521_scalar_cmovznz_u64(x3, (arg3[9]), x35);
    let mut x47: u64 = 0;
    let (x47) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[0]), (arg5[0]));
    let mut x48: u64 = 0;
    let (x48) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[1]), (arg5[1]));
    let mut x49: u64 = 0;
    let (x49) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[2]), (arg5[2]));
    let mut x50: u64 = 0;
    let (x50) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[3]), (arg5[3]));
    let mut x51: u64 = 0;
    let (x51) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[4]), (arg5[4]));
    let mut x52: u64 = 0;
    let (x52) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[5]), (arg5[5]));
    let mut x53: u64 = 0;
    let (x53) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[6]), (arg5[6]));
    let mut x54: u64 = 0;
    let (x54) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[7]), (arg5[7]));
    let mut x55: u64 = 0;
    let (x55) = fiat_p521_scalar_cmovznz_u64(x3, (arg4[8]), (arg5[8]));
    let mut x56: u64 = 0;
    let mut x57: fiat_p521_scalar_u1 = 0;
    let (x56, x57) = fiat_p521_scalar_addcarryx_u64(0x0, x47, x47);
    let mut x58: u64 = 0;
    let mut x59: fiat_p521_scalar_u1 = 0;
    let (x58, x59) = fiat_p521_scalar_addcarryx_u64(x57, x48, x48);
    let mut x60: u64 = 0;
    let mut x61: fiat_p521_scalar_u1 = 0;
    let (x60, x61) = fiat_p521_scalar_addcarryx_u64(x59, x49, x49);
    let mut x62: u64 = 0;
    let mut x63: fiat_p521_scalar_u1 = 0;
    let (x62, x63) = fiat_p521_scalar_addcarryx_u64(x61, x50, x50);
    let mut x64: u64 = 0;
    let mut x65: fiat_p521_scalar_u1 = 0;
    let (x64, x65) = fiat_p521_scalar_addcarryx_u64(x63, x51, x51);
    let mut x66: u64 = 0;
    let mut x67: fiat_p521_scalar_u1 = 0;
    let (x66, x67) = fiat_p521_scalar_addcarryx_u64(x65, x52, x52);
    let mut x68: u64 = 0;
    let mut x69: fiat_p521_scalar_u1 = 0;
    let (x68, x69) = fiat_p521_scalar_addcarryx_u64(x67, x53, x53);
    let mut x70: u64 = 0;
    let mut x71: fiat_p521_scalar_u1 = 0;
    let (x70, x71) = fiat_p521_scalar_addcarryx_u64(x69, x54, x54);
    let mut x72: u64 = 0;
    let mut x73: fiat_p521_scalar_u1 = 0;
    let (x72, x73) = fiat_p521_scalar_addcarryx_u64(x71, x55, x55);
    let mut x74: u64 = 0;
    let mut x75: fiat_p521_scalar_u1 = 0;
    let (x74, x75) = fiat_p521_scalar_subborrowx_u64(0x0, x56, 0xbb6fb71e91386409);
    let mut x76: u64 = 0;
    let mut x77: fiat_p521_scalar_u1 = 0;
    let (x76, x77) = fiat_p521_scalar_subborrowx_u64(x75, x58, 0x3bb5c9b8899c47ae);
    let mut x78: u64 = 0;
    let mut x79: fiat_p521_scalar_u1 = 0;
    let (x78, x79) = fiat_p521_scalar_subborrowx_u64(x77, x60, 0x7fcc0148f709a5d0);
    let mut x80: u64 = 0;
    let mut x81: fiat_p521_scalar_u1 = 0;
    let (x80, x81) = fiat_p521_scalar_subborrowx_u64(x79, x62, 0x51868783bf2f966b);
    let mut x82: u64 = 0;
    let mut x83: fiat_p521_scalar_u1 = 0;
    let (x82, x83) = fiat_p521_scalar_subborrowx_u64(x81, x64, 0xfffffffffffffffa);
    let mut x84: u64 = 0;
    let mut x85: fiat_p521_scalar_u1 = 0;
    let (x84, x85) = fiat_p521_scalar_subborrowx_u64(x83, x66, 0xffffffffffffffff);
    let mut x86: u64 = 0;
    let mut x87: fiat_p521_scalar_u1 = 0;
    let (x86, x87) = fiat_p521_scalar_subborrowx_u64(x85, x68, 0xffffffffffffffff);
    let mut x88: u64 = 0;
    let mut x89: fiat_p521_scalar_u1 = 0;
    let (x88, x89) = fiat_p521_scalar_subborrowx_u64(x87, x70, 0xffffffffffffffff);
    let mut x90: u64 = 0;
    let mut x91: fiat_p521_scalar_u1 = 0;
    let (x90, x91) = fiat_p521_scalar_subborrowx_u64(x89, x72, 0x1ff);
    let mut x92: u64 = 0;
    let mut x93: fiat_p521_scalar_u1 = 0;
    let (x92, x93) = fiat_p521_scalar_subborrowx_u64(x91, (x73 as u64), (0x0 as u64));
    let x94: u64 = (arg4[8]);
    let x95: u64 = (arg4[7]);
    let x96: u64 = (arg4[6]);
    let x97: u64 = (arg4[5]);
    let x98: u64 = (arg4[4]);
    let x99: u64 = (arg4[3]);
    let x100: u64 = (arg4[2]);
    let x101: u64 = (arg4[1]);
    let x102: u64 = (arg4[0]);
    let mut x103: u64 = 0;
    let mut x104: fiat_p521_scalar_u1 = 0;
    let (x103, x104) = fiat_p521_scalar_subborrowx_u64(0x0, (0x0 as u64), x102);
    let mut x105: u64 = 0;
    let mut x106: fiat_p521_scalar_u1 = 0;
    let (x105, x106) = fiat_p521_scalar_subborrowx_u64(x104, (0x0 as u64), x101);
    let mut x107: u64 = 0;
    let mut x108: fiat_p521_scalar_u1 = 0;
    let (x107, x108) = fiat_p521_scalar_subborrowx_u64(x106, (0x0 as u64), x100);
    let mut x109: u64 = 0;
    let mut x110: fiat_p521_scalar_u1 = 0;
    let (x109, x110) = fiat_p521_scalar_subborrowx_u64(x108, (0x0 as u64), x99);
    let mut x111: u64 = 0;
    let mut x112: fiat_p521_scalar_u1 = 0;
    let (x111, x112) = fiat_p521_scalar_subborrowx_u64(x110, (0x0 as u64), x98);
    let mut x113: u64 = 0;
    let mut x114: fiat_p521_scalar_u1 = 0;
    let (x113, x114) = fiat_p521_scalar_subborrowx_u64(x112, (0x0 as u64), x97);
    let mut x115: u64 = 0;
    let mut x116: fiat_p521_scalar_u1 = 0;
    let (x115, x116) = fiat_p521_scalar_subborrowx_u64(x114, (0x0 as u64), x96);
    let mut x117: u64 = 0;
    let mut x118: fiat_p521_scalar_u1 = 0;
    let (x117, x118) = fiat_p521_scalar_subborrowx_u64(x116, (0x0 as u64), x95);
    let mut x119: u64 = 0;
    let mut x120: fiat_p521_scalar_u1 = 0;
    let (x119, x120) = fiat_p521_scalar_subborrowx_u64(x118, (0x0 as u64), x94);
    let mut x121: u64 = 0;
    let (x121) = fiat_p521_scalar_cmovznz_u64(x120, (0x0 as u64), 0xffffffffffffffff);
    let mut x122: u64 = 0;
    let mut x123: fiat_p521_scalar_u1 = 0;
    let (x122, x123) = fiat_p521_scalar_addcarryx_u64(0x0, x103, (x121 & 0xbb6fb71e91386409));
    let mut x124: u64 = 0;
    let mut x125: fiat_p521_scalar_u1 = 0;
    let (x124, x125) = fiat_p521_scalar_addcarryx_u64(x123, x105, (x121 & 0x3bb5c9b8899c47ae));
    let mut x126: u64 = 0;
    let mut x127: fiat_p521_scalar_u1 = 0;
    let (x126, x127) = fiat_p521_scalar_addcarryx_u64(x125, x107, (x121 & 0x7fcc0148f709a5d0));
    let mut x128: u64 = 0;
    let mut x129: fiat_p521_scalar_u1 = 0;
    let (x128, x129) = fiat_p521_scalar_addcarryx_u64(x127, x109, (x121 & 0x51868783bf2f966b));
    let mut x130: u64 = 0;
    let mut x131: fiat_p521_scalar_u1 = 0;
    let (x130, x131) = fiat_p521_scalar_addcarryx_u64(x129, x111, (x121 & 0xfffffffffffffffa));
    let mut x132: u64 = 0;
    let mut x133: fiat_p521_scalar_u1 = 0;
    let (x132, x133) = fiat_p521_scalar_addcarryx_u64(x131, x113, x121);
    let mut x134: u64 = 0;
    let mut x135: fiat_p521_scalar_u1 = 0;
    let (x134, x135) = fiat_p521_scalar_addcarryx_u64(x133, x115, x121);
    let mut x136: u64 = 0;
    let mut x137: fiat_p521_scalar_u1 = 0;
    let (x136, x137) = fiat_p521_scalar_addcarryx_u64(x135, x117, x121);
    let mut x138: u64 = 0;
    let mut x139: fiat_p521_scalar_u1 = 0;
    let (x138, x139) = fiat_p521_scalar_addcarryx_u64(x137, x119, (x121 & 0x1ff));
    let mut x140: u64 = 0;
    let (x140) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[0]), x122);
    let mut x141: u64 = 0;
    let (x141) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[1]), x124);
    let mut x142: u64 = 0;
    let (x142) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[2]), x126);
    let mut x143: u64 = 0;
    let (x143) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[3]), x128);
    let mut x144: u64 = 0;
    let (x144) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[4]), x130);
    let mut x145: u64 = 0;
    let (x145) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[5]), x132);
    let mut x146: u64 = 0;
    let (x146) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[6]), x134);
    let mut x147: u64 = 0;
    let (x147) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[7]), x136);
    let mut x148: u64 = 0;
    let (x148) = fiat_p521_scalar_cmovznz_u64(x3, (arg5[8]), x138);
    let x149: fiat_p521_scalar_u1 = ((x37 & (0x1 as u64)) as fiat_p521_scalar_u1);
    let mut x150: u64 = 0;
    let (x150) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x7);
    let mut x151: u64 = 0;
    let (x151) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x8);
    let mut x152: u64 = 0;
    let (x152) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x9);
    let mut x153: u64 = 0;
    let (x153) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x10);
    let mut x154: u64 = 0;
    let (x154) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x11);
    let mut x155: u64 = 0;
    let (x155) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x12);
    let mut x156: u64 = 0;
    let (x156) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x13);
    let mut x157: u64 = 0;
    let (x157) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x14);
    let mut x158: u64 = 0;
    let (x158) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x15);
    let mut x159: u64 = 0;
    let (x159) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x16);
    let mut x160: u64 = 0;
    let mut x161: fiat_p521_scalar_u1 = 0;
    let (x160, x161) = fiat_p521_scalar_addcarryx_u64(0x0, x37, x150);
    let mut x162: u64 = 0;
    let mut x163: fiat_p521_scalar_u1 = 0;
    let (x162, x163) = fiat_p521_scalar_addcarryx_u64(x161, x38, x151);
    let mut x164: u64 = 0;
    let mut x165: fiat_p521_scalar_u1 = 0;
    let (x164, x165) = fiat_p521_scalar_addcarryx_u64(x163, x39, x152);
    let mut x166: u64 = 0;
    let mut x167: fiat_p521_scalar_u1 = 0;
    let (x166, x167) = fiat_p521_scalar_addcarryx_u64(x165, x40, x153);
    let mut x168: u64 = 0;
    let mut x169: fiat_p521_scalar_u1 = 0;
    let (x168, x169) = fiat_p521_scalar_addcarryx_u64(x167, x41, x154);
    let mut x170: u64 = 0;
    let mut x171: fiat_p521_scalar_u1 = 0;
    let (x170, x171) = fiat_p521_scalar_addcarryx_u64(x169, x42, x155);
    let mut x172: u64 = 0;
    let mut x173: fiat_p521_scalar_u1 = 0;
    let (x172, x173) = fiat_p521_scalar_addcarryx_u64(x171, x43, x156);
    let mut x174: u64 = 0;
    let mut x175: fiat_p521_scalar_u1 = 0;
    let (x174, x175) = fiat_p521_scalar_addcarryx_u64(x173, x44, x157);
    let mut x176: u64 = 0;
    let mut x177: fiat_p521_scalar_u1 = 0;
    let (x176, x177) = fiat_p521_scalar_addcarryx_u64(x175, x45, x158);
    let mut x178: u64 = 0;
    let mut x179: fiat_p521_scalar_u1 = 0;
    let (x178, x179) = fiat_p521_scalar_addcarryx_u64(x177, x46, x159);
    let mut x180: u64 = 0;
    let (x180) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x47);
    let mut x181: u64 = 0;
    let (x181) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x48);
    let mut x182: u64 = 0;
    let (x182) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x49);
    let mut x183: u64 = 0;
    let (x183) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x50);
    let mut x184: u64 = 0;
    let (x184) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x51);
    let mut x185: u64 = 0;
    let (x185) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x52);
    let mut x186: u64 = 0;
    let (x186) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x53);
    let mut x187: u64 = 0;
    let (x187) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x54);
    let mut x188: u64 = 0;
    let (x188) = fiat_p521_scalar_cmovznz_u64(x149, (0x0 as u64), x55);
    let mut x189: u64 = 0;
    let mut x190: fiat_p521_scalar_u1 = 0;
    let (x189, x190) = fiat_p521_scalar_addcarryx_u64(0x0, x140, x180);
    let mut x191: u64 = 0;
    let mut x192: fiat_p521_scalar_u1 = 0;
    let (x191, x192) = fiat_p521_scalar_addcarryx_u64(x190, x141, x181);
    let mut x193: u64 = 0;
    let mut x194: fiat_p521_scalar_u1 = 0;
    let (x193, x194) = fiat_p521_scalar_addcarryx_u64(x192, x142, x182);
    let mut x195: u64 = 0;
    let mut x196: fiat_p521_scalar_u1 = 0;
    let (x195, x196) = fiat_p521_scalar_addcarryx_u64(x194, x143, x183);
    let mut x197: u64 = 0;
    let mut x198: fiat_p521_scalar_u1 = 0;
    let (x197, x198) = fiat_p521_scalar_addcarryx_u64(x196, x144, x184);
    let mut x199: u64 = 0;
    let mut x200: fiat_p521_scalar_u1 = 0;
    let (x199, x200) = fiat_p521_scalar_addcarryx_u64(x198, x145, x185);
    let mut x201: u64 = 0;
    let mut x202: fiat_p521_scalar_u1 = 0;
    let (x201, x202) = fiat_p521_scalar_addcarryx_u64(x200, x146, x186);
    let mut x203: u64 = 0;
    let mut x204: fiat_p521_scalar_u1 = 0;
    let (x203, x204) = fiat_p521_scalar_addcarryx_u64(x202, x147, x187);
    let mut x205: u64 = 0;
    let mut x206: fiat_p521_scalar_u1 = 0;
    let (x205, x206) = fiat_p521_scalar_addcarryx_u64(x204, x148, x188);
    let mut x207: u64 = 0;
    let mut x208: fiat_p521_scalar_u1 = 0;
    let (x207, x208) = fiat_p521_scalar_subborrowx_u64(0x0, x189, 0xbb6fb71e91386409);
    let mut x209: u64 = 0;
    let mut x210: fiat_p521_scalar_u1 = 0;
    let (x209, x210) = fiat_p521_scalar_subborrowx_u64(x208, x191, 0x3bb5c9b8899c47ae);
    let mut x211: u64 = 0;
    let mut x212: fiat_p521_scalar_u1 = 0;
    let (x211, x212) = fiat_p521_scalar_subborrowx_u64(x210, x193, 0x7fcc0148f709a5d0);
    let mut x213: u64 = 0;
    let mut x214: fiat_p521_scalar_u1 = 0;
    let (x213, x214) = fiat_p521_scalar_subborrowx_u64(x212, x195, 0x51868783bf2f966b);
    let mut x215: u64 = 0;
    let mut x216: fiat_p521_scalar_u1 = 0;
    let (x215, x216) = fiat_p521_scalar_subborrowx_u64(x214, x197, 0xfffffffffffffffa);
    let mut x217: u64 = 0;
    let mut x218: fiat_p521_scalar_u1 = 0;
    let (x217, x218) = fiat_p521_scalar_subborrowx_u64(x216, x199, 0xffffffffffffffff);
    let mut x219: u64 = 0;
    let mut x220: fiat_p521_scalar_u1 = 0;
    let (x219, x220) = fiat_p521_scalar_subborrowx_u64(x218, x201, 0xffffffffffffffff);
    let mut x221: u64 = 0;
    let mut x222: fiat_p521_scalar_u1 = 0;
    let (x221, x222) = fiat_p521_scalar_subborrowx_u64(x220, x203, 0xffffffffffffffff);
    let mut x223: u64 = 0;
    let mut x224: fiat_p521_scalar_u1 = 0;
    let (x223, x224) = fiat_p521_scalar_subborrowx_u64(x222, x205, 0x1ff);
    let mut x225: u64 = 0;
    let mut x226: fiat_p521_scalar_u1 = 0;
    let (x225, x226) = fiat_p521_scalar_subborrowx_u64(x224, (x206 as u64), (0x0 as u64));
    let mut x227: u64 = 0;
    let mut x228: fiat_p521_scalar_u1 = 0;
    let (x227, x228) = fiat_p521_scalar_addcarryx_u64(0x0, x6, (0x1 as u64));
    let x229: u64 = ((x160 >> 1) | ((x162 << 63) & 0xffffffffffffffff));
    let x230: u64 = ((x162 >> 1) | ((x164 << 63) & 0xffffffffffffffff));
    let x231: u64 = ((x164 >> 1) | ((x166 << 63) & 0xffffffffffffffff));
    let x232: u64 = ((x166 >> 1) | ((x168 << 63) & 0xffffffffffffffff));
    let x233: u64 = ((x168 >> 1) | ((x170 << 63) & 0xffffffffffffffff));
    let x234: u64 = ((x170 >> 1) | ((x172 << 63) & 0xffffffffffffffff));
    let x235: u64 = ((x172 >> 1) | ((x174 << 63) & 0xffffffffffffffff));
    let x236: u64 = ((x174 >> 1) | ((x176 << 63) & 0xffffffffffffffff));
    let x237: u64 = ((x176 >> 1) | ((x178 << 63) & 0xffffffffffffffff));
    let x238: u64 = ((x178 & 0x8000000000000000) | (x178 >> 1));
    let mut x239: u64 = 0;
    let (x239) = fiat_p521_scalar_cmovznz_u64(x93, x74, x56);
    let mut x240: u64 = 0;
    let (x240) = fiat_p521_scalar_cmovznz_u64(x93, x76, x58);
    let mut x241: u64 = 0;
    let (x241) = fiat_p521_scalar_cmovznz_u64(x93, x78, x60);
    let mut x242: u64 = 0;
    let (x242) = fiat_p521_scalar_cmovznz_u64(x93, x80, x62);
    let mut x243: u64 = 0;
    let (x243) = fiat_p521_scalar_cmovznz_u64(x93, x82, x64);
    let mut x244: u64 = 0;
    let (x244) = fiat_p521_scalar_cmovznz_u64(x93, x84, x66);
    let mut x245: u64 = 0;
    let (x245) = fiat_p521_scalar_cmovznz_u64(x93, x86, x68);
    let mut x246: u64 = 0;
    let (x246) = fiat_p521_scalar_cmovznz_u64(x93, x88, x70);
    let mut x247: u64 = 0;
    let (x247) = fiat_p521_scalar_cmovznz_u64(x93, x90, x72);
    let mut x248: u64 = 0;
    let (x248) = fiat_p521_scalar_cmovznz_u64(x226, x207, x189);
    let mut x249: u64 = 0;
    let (x249) = fiat_p521_scalar_cmovznz_u64(x226, x209, x191);
    let mut x250: u64 = 0;
    let (x250) = fiat_p521_scalar_cmovznz_u64(x226, x211, x193);
    let mut x251: u64 = 0;
    let (x251) = fiat_p521_scalar_cmovznz_u64(x226, x213, x195);
    let mut x252: u64 = 0;
    let (x252) = fiat_p521_scalar_cmovznz_u64(x226, x215, x197);
    let mut x253: u64 = 0;
    let (x253) = fiat_p521_scalar_cmovznz_u64(x226, x217, x199);
    let mut x254: u64 = 0;
    let (x254) = fiat_p521_scalar_cmovznz_u64(x226, x219, x201);
    let mut x255: u64 = 0;
    let (x255) = fiat_p521_scalar_cmovznz_u64(x226, x221, x203);
    let mut x256: u64 = 0;
    let (x256) = fiat_p521_scalar_cmovznz_u64(x226, x223, x205);
    out1 = x227;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out2[7] = x14;
    out2[8] = x15;
    out2[9] = x16;
    out3[0] = x229;
    out3[1] = x230;
    out3[2] = x231;
    out3[3] = x232;
    out3[4] = x233;
    out3[5] = x234;
    out3[6] = x235;
    out3[7] = x236;
    out3[8] = x237;
    out3[9] = x238;
    out4[0] = x239;
    out4[1] = x240;
    out4[2] = x241;
    out4[3] = x242;
    out4[4] = x243;
    out4[5] = x244;
    out4[6] = x245;
    out4[7] = x246;
    out4[8] = x247;
    out5[0] = x248;
    out5[1] = x249;
    out5[2] = x250;
    out5[3] = x251;
    out5[4] = x252;
    out5[5] = x253;
    out5[6] = x254;
    out5[7] = x255;
    out5[8] = x256;
    (out1, out2, out3, out4, out5)
}
