% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-zones.r
\name{local_time}
\alias{local_time}
\title{Get local time from a date-time vector.}
\usage{
local_time(dt, tz = NULL, units = "secs")
}
\arguments{
\item{dt}{a date-time object.}

\item{tz}{a character vector of timezones for which to compute the local time.}

\item{units}{passed directly to \code{\link[=as.difftime]{as.difftime()}}.}
}
\description{
\code{local_time} retrieves day clock time in specified time zones. Computation is
vectorized over both \code{dt} and \code{tz} arguments, the shortest is recycled in
accordance with standard R rules.
}
\examples{

x <- ymd_hms(c("2009-08-07 01:02:03", "2009-08-07 10:20:30"))
local_time(x, units = "secs")
local_time(x, units = "hours")
local_time(x, "Europe/Amsterdam")
local_time(x, "Europe/Amsterdam") == local_time(with_tz(x, "Europe/Amsterdam"))

x <- ymd_hms("2009-08-07 01:02:03")
local_time(x, c("America/New_York", "Europe/Amsterdam", "Asia/Shanghai"), unit = "hours")
}
