% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-jwt.R
\name{oauth_flow_bearer_jwt}
\alias{oauth_flow_bearer_jwt}
\title{OAuth flow: Bearer JWT}
\usage{
oauth_flow_bearer_jwt(
  client,
  claim,
  signature = "jwt_encode_sig",
  signature_params = list(),
  scope = NULL,
  token_params = list()
)
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{claim}{A list of claims. If all elements of the claim set are static
apart from \code{iat}, \code{nbf}, \code{exp}, or \code{jti}, provide a list and
\code{\link[=jwt_claim]{jwt_claim()}} will automatically fill in the dynamic components.
If other components need to vary, you can instead provide a zero-argument
callback function which should call \code{jwt_claim()}.}

\item{signature}{Function use to sign \code{claim}, e.g. \code{\link[=jwt_encode_sig]{jwt_encode_sig()}}.}

\item{signature_params}{Additional arguments passed to \code{signature}, e.g.
\code{size}, \code{header}.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}
}
\value{
An \link{oauth_token}.
}
\description{
This function uses a Bearer JWT as an authorization grant to get an access
token, as defined by \href{https://datatracker.ietf.org/doc/html/rfc7523#section-2.1}{rfc7523},
Section 2.1. It is often used for service accounts, accounts that are
used primarily in automated environments.
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_auth_code}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_device}()},
\code{\link{oauth_flow_password}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
