% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_student_t.R
\name{dist_student_t}
\alias{dist_student_t}
\title{The (non-central) location-scale Student t Distribution}
\usage{
dist_student_t(df, mu = 0, sigma = 1, ncp = NULL)
}
\arguments{
\item{df}{degrees of freedom (\eqn{> 0}, maybe non-integer).  \code{df
      = Inf} is allowed.}

\item{mu}{The location parameter of the distribution.
If \code{ncp == 0} (or \code{NULL}), this is the median.}

\item{sigma}{The scale parameter of the distribution.}

\item{ncp}{non-centrality parameter \eqn{\delta}{delta};
    currently except for \code{rt()}, only for \code{abs(ncp) <= 37.62}.
    If omitted, use the central t distribution.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The Student's T distribution is closely related to the \code{\link[=Normal]{Normal()}}
distribution, but has heavier tails. As \eqn{\nu} increases to \eqn{\infty},
the Student's T converges to a Normal. The T distribution appears
repeatedly throughout classic frequentist hypothesis testing when
comparing group means.
}
\details{
We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a \strong{central} Students T random variable
with \code{df} = \eqn{\nu}.

\strong{Support}: \eqn{R}, the set of all real numbers

\strong{Mean}: Undefined unless \eqn{\nu \ge 2}, in which case the mean is
zero.

\strong{Variance}:

\deqn{
    \frac{\nu}{\nu - 2}
  }{
    \nu / (\nu - 2)
  }

Undefined if \eqn{\nu < 1}, infinite when \eqn{1 < \nu \le 2}.

\strong{Probability density function (p.d.f)}:

\deqn{
    f(x) = \frac{\Gamma(\frac{\nu + 1}{2})}{\sqrt{\nu \pi} \Gamma(\frac{\nu}{2})} (1 + \frac{x^2}{\nu} )^{- \frac{\nu + 1}{2}}
  }{
    f(x) = \Gamma((\nu + 1) / 2) / (\sqrt(\nu \pi) \Gamma(\nu / 2)) (1 + x^2 / \nu)^(- (\nu + 1) / 2)
  }
}
\examples{
dist <- dist_student_t(df = c(1,2,5), mu = c(0,1,2), sigma = c(1,2,3))

dist
mean(dist)
variance(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:TDist]{stats::TDist}
}
