# coding: utf-8

"""
Copyright 2015 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from pprint import pformat
from six import iteritems


class V1PodSecurityContext(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Swagger model

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'se_linux_options': 'V1SELinuxOptions',
            'run_as_user': 'int',
            'run_as_non_root': 'bool',
            'supplemental_groups': 'list[int]',
            'fs_group': 'int'
        }

        self.attribute_map = {
            'se_linux_options': 'seLinuxOptions',
            'run_as_user': 'runAsUser',
            'run_as_non_root': 'runAsNonRoot',
            'supplemental_groups': 'supplementalGroups',
            'fs_group': 'fsGroup'
        }

        self._se_linux_options = None
        self._run_as_user = None
        self._run_as_non_root = None
        self._supplemental_groups = None
        self._fs_group = None

    @property
    def se_linux_options(self):
        """
        Gets the se_linux_options of this V1PodSecurityContext.
        The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.

        :return: The se_linux_options of this V1PodSecurityContext.
        :rtype: V1SELinuxOptions
        """
        return self._se_linux_options

    @se_linux_options.setter
    def se_linux_options(self, se_linux_options):
        """
        Sets the se_linux_options of this V1PodSecurityContext.
        The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.

        :param se_linux_options: The se_linux_options of this V1PodSecurityContext.
        :type: V1SELinuxOptions
        """
        self._se_linux_options = se_linux_options

    @property
    def run_as_user(self):
        """
        Gets the run_as_user of this V1PodSecurityContext.
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.

        :return: The run_as_user of this V1PodSecurityContext.
        :rtype: int
        """
        return self._run_as_user

    @run_as_user.setter
    def run_as_user(self, run_as_user):
        """
        Sets the run_as_user of this V1PodSecurityContext.
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.

        :param run_as_user: The run_as_user of this V1PodSecurityContext.
        :type: int
        """
        self._run_as_user = run_as_user

    @property
    def run_as_non_root(self):
        """
        Gets the run_as_non_root of this V1PodSecurityContext.
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :return: The run_as_non_root of this V1PodSecurityContext.
        :rtype: bool
        """
        return self._run_as_non_root

    @run_as_non_root.setter
    def run_as_non_root(self, run_as_non_root):
        """
        Sets the run_as_non_root of this V1PodSecurityContext.
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.

        :param run_as_non_root: The run_as_non_root of this V1PodSecurityContext.
        :type: bool
        """
        self._run_as_non_root = run_as_non_root

    @property
    def supplemental_groups(self):
        """
        Gets the supplemental_groups of this V1PodSecurityContext.
        A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.

        :return: The supplemental_groups of this V1PodSecurityContext.
        :rtype: list[int]
        """
        return self._supplemental_groups

    @supplemental_groups.setter
    def supplemental_groups(self, supplemental_groups):
        """
        Sets the supplemental_groups of this V1PodSecurityContext.
        A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.

        :param supplemental_groups: The supplemental_groups of this V1PodSecurityContext.
        :type: list[int]
        """
        self._supplemental_groups = supplemental_groups

    @property
    def fs_group(self):
        """
        Gets the fs_group of this V1PodSecurityContext.
        A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw

        :return: The fs_group of this V1PodSecurityContext.
        :rtype: int
        """
        return self._fs_group

    @fs_group.setter
    def fs_group(self, fs_group):
        """
        Sets the fs_group of this V1PodSecurityContext.
        A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:\n\n1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw

        :param fs_group: The fs_group of this V1PodSecurityContext.
        :type: int
        """
        self._fs_group = fs_group

    def to_dict(self):
        """
        Return model properties dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Return model properties str
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()
