# coding: utf-8

"""
ApivApi.py
Copyright 2015 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ApivApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient('https://127.0.0.1:443/')
            self.api_client = config.api_client

    def get_api_resources(self, **kwargs):
        """
        get available resources
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_api_resources(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_resources" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json', 'application/yaml'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_component_status(self, **kwargs):
        """
        list objects of kind ComponentStatus
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_component_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ComponentStatusList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_component_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/componentstatuses'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ComponentStatusList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_component_status(self, name, **kwargs):
        """
        read the specified ComponentStatus
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_component_status(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the ComponentStatus (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ComponentStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_component_status`")

        all_params = ['name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_component_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/componentstatuses/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ComponentStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_config_map(self, **kwargs):
        """
        list or watch objects of kind ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_config_map(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ConfigMapList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/configmaps'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMapList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_endpoints(self, **kwargs):
        """
        list or watch objects of kind Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_endpoints(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1EndpointsList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/endpoints'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1EndpointsList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_event(self, **kwargs):
        """
        list or watch objects of kind Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_event(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/events'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1EventList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_limit_range(self, **kwargs):
        """
        list or watch objects of kind LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_limit_range(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1LimitRangeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/limitranges'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRangeList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_namespace(self, **kwargs):
        """
        list or watch objects of kind Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_namespace(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1NamespaceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1NamespaceList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_namespace(self, body, **kwargs):
        """
        create a Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_namespace(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Namespace body:  (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_namespace`")

        all_params = ['body', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_namespace(self, **kwargs):
        """
        delete collection of Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_namespace(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_binding(self, body, namespace, **kwargs):
        """
        create a Binding
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_binding(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Binding body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Binding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_binding`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_binding`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_binding" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/bindings'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Binding',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_config_map(self, namespace, **kwargs):
        """
        list or watch objects of kind ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_config_map(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ConfigMapList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_config_map`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMapList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_config_map(self, body, namespace, **kwargs):
        """
        create a ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_config_map(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ConfigMap body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ConfigMap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_config_map`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_config_map`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_config_map(self, namespace, **kwargs):
        """
        delete collection of ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_config_map(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_config_map`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_config_map(self, namespace, name, **kwargs):
        """
        read the specified ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_config_map(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ConfigMap (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1ConfigMap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_config_map`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_config_map`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_config_map(self, body, namespace, name, **kwargs):
        """
        replace the specified ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_config_map(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ConfigMap body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ConfigMap (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ConfigMap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_config_map`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_config_map`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_config_map`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_config_map(self, body, namespace, name, **kwargs):
        """
        delete a ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_config_map(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ConfigMap (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_config_map`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_config_map`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_config_map`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_config_map(self, body, namespace, name, **kwargs):
        """
        partially update the specified ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_config_map(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ConfigMap (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ConfigMap
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_config_map`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_config_map`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_config_map`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/configmaps/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ConfigMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_endpoints(self, namespace, **kwargs):
        """
        list or watch objects of kind Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_endpoints(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1EndpointsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_endpoints`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1EndpointsList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_endpoints(self, body, namespace, **kwargs):
        """
        create a Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_endpoints(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Endpoints body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Endpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_endpoints`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_endpoints`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Endpoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_endpoints(self, namespace, **kwargs):
        """
        delete collection of Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_endpoints(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_endpoints`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_endpoints(self, namespace, name, **kwargs):
        """
        read the specified Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_endpoints(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Endpoints (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Endpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_endpoints`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_endpoints`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Endpoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_endpoints(self, body, namespace, name, **kwargs):
        """
        replace the specified Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_endpoints(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Endpoints body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Endpoints (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Endpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_endpoints`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_endpoints`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_endpoints`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Endpoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_endpoints(self, body, namespace, name, **kwargs):
        """
        delete a Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_endpoints(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Endpoints (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_endpoints`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_endpoints`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_endpoints`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_endpoints(self, body, namespace, name, **kwargs):
        """
        partially update the specified Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_endpoints(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Endpoints (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Endpoints
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_endpoints`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_endpoints`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_endpoints`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/endpoints/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Endpoints',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_event(self, namespace, **kwargs):
        """
        list or watch objects of kind Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_event(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1EventList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_event`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1EventList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_event(self, body, namespace, **kwargs):
        """
        create a Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_event(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Event body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_event`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_event`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Event',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_event(self, namespace, **kwargs):
        """
        delete collection of Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_event(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_event`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_event(self, namespace, name, **kwargs):
        """
        read the specified Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_event(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Event (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_event`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_event`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Event',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_event(self, body, namespace, name, **kwargs):
        """
        replace the specified Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_event(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Event body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Event (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_event`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_event`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_event`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Event',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_event(self, body, namespace, name, **kwargs):
        """
        delete a Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_event(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Event (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_event`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_event`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_event`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_event(self, body, namespace, name, **kwargs):
        """
        partially update the specified Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_event(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Event (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Event
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_event`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_event`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_event`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/events/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Event',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_limit_range(self, namespace, **kwargs):
        """
        list or watch objects of kind LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_limit_range(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1LimitRangeList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_limit_range`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRangeList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_limit_range(self, body, namespace, **kwargs):
        """
        create a LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_limit_range(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1LimitRange body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1LimitRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_limit_range`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_limit_range`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRange',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_limit_range(self, namespace, **kwargs):
        """
        delete collection of LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_limit_range(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_limit_range`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_limit_range(self, namespace, name, **kwargs):
        """
        read the specified LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_limit_range(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the LimitRange (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1LimitRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_limit_range`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_limit_range`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRange',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_limit_range(self, body, namespace, name, **kwargs):
        """
        replace the specified LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_limit_range(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1LimitRange body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the LimitRange (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1LimitRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_limit_range`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_limit_range`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_limit_range`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRange',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_limit_range(self, body, namespace, name, **kwargs):
        """
        delete a LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_limit_range(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the LimitRange (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_limit_range`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_limit_range`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_limit_range`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_limit_range(self, body, namespace, name, **kwargs):
        """
        partially update the specified LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_limit_range(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the LimitRange (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1LimitRange
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_limit_range`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_limit_range`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_limit_range`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/limitranges/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1LimitRange',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_persistent_volume_claim(self, namespace, **kwargs):
        """
        list or watch objects of kind PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_persistent_volume_claim(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PersistentVolumeClaimList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_persistent_volume_claim`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaimList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_persistent_volume_claim(self, body, namespace, **kwargs):
        """
        create a PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_persistent_volume_claim(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolumeClaim body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolumeClaim
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_persistent_volume_claim`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_persistent_volume_claim`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaim',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_persistent_volume_claim(self, namespace, **kwargs):
        """
        delete collection of PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_persistent_volume_claim(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_persistent_volume_claim`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_persistent_volume_claim(self, namespace, name, **kwargs):
        """
        read the specified PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_persistent_volume_claim(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1PersistentVolumeClaim
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_persistent_volume_claim`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_persistent_volume_claim`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaim',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_persistent_volume_claim(self, body, namespace, name, **kwargs):
        """
        replace the specified PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_persistent_volume_claim(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolumeClaim body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolumeClaim
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_persistent_volume_claim`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_persistent_volume_claim`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_persistent_volume_claim`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaim',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_persistent_volume_claim(self, body, namespace, name, **kwargs):
        """
        delete a PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_persistent_volume_claim(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_persistent_volume_claim`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_persistent_volume_claim`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_persistent_volume_claim`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_persistent_volume_claim(self, body, namespace, name, **kwargs):
        """
        partially update the specified PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_persistent_volume_claim(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolumeClaim
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_persistent_volume_claim`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_persistent_volume_claim`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_persistent_volume_claim`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaim',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_persistent_volume_claim_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_persistent_volume_claim_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolumeClaim body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolumeClaim
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_persistent_volume_claim_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_persistent_volume_claim_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_persistent_volume_claim_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_persistent_volume_claim_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/persistentvolumeclaims/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaim',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_pod(self, namespace, **kwargs):
        """
        list or watch objects of kind Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_pod(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PodList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_pod`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_pod(self, body, namespace, **kwargs):
        """
        create a Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_pod(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Pod body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_pod`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_pod`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_pod(self, namespace, **kwargs):
        """
        delete collection of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_pod(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_pod`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_pod(self, namespace, name, **kwargs):
        """
        read the specified Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_pod`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_pod(self, body, namespace, name, **kwargs):
        """
        replace the specified Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_pod(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Pod body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_pod`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_pod`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_pod(self, body, namespace, name, **kwargs):
        """
        delete a Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_pod(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_pod`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_pod`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_pod(self, body, namespace, name, **kwargs):
        """
        partially update the specified Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_pod(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_pod`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_pod`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_pod_attach(self, namespace, name, **kwargs):
        """
        connect GET requests to attach of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_pod_attach(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param bool stdin: Stdin if true, redirects the standard input stream of the pod for this call. Defaults to false.
        :param bool stdout: Stdout if true indicates that stdout is to be redirected for the attach call. Defaults to true.
        :param bool stderr: Stderr if true indicates that stderr is to be redirected for the attach call. Defaults to true.
        :param bool tty: TTY if true indicates that a tty will be allocated for the attach call. This is passed through the container runtime so the tty is allocated on the worker node by the container runtime. Defaults to false.
        :param str container: The container in which to execute the command. Defaults to only container if there is only one container in the pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_pod_attach`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_pod_attach`")

        all_params = ['namespace', 'name', 'stdin', 'stdout', 'stderr', 'tty', 'container']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_pod_attach" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/attach'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'stdin' in params:
            query_params['stdin'] = params['stdin']
        if 'stdout' in params:
            query_params['stdout'] = params['stdout']
        if 'stderr' in params:
            query_params['stderr'] = params['stderr']
        if 'tty' in params:
            query_params['tty'] = params['tty']
        if 'container' in params:
            query_params['container'] = params['container']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_pod_attach(self, namespace, name, **kwargs):
        """
        connect POST requests to attach of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_pod_attach(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param bool stdin: Stdin if true, redirects the standard input stream of the pod for this call. Defaults to false.
        :param bool stdout: Stdout if true indicates that stdout is to be redirected for the attach call. Defaults to true.
        :param bool stderr: Stderr if true indicates that stderr is to be redirected for the attach call. Defaults to true.
        :param bool tty: TTY if true indicates that a tty will be allocated for the attach call. This is passed through the container runtime so the tty is allocated on the worker node by the container runtime. Defaults to false.
        :param str container: The container in which to execute the command. Defaults to only container if there is only one container in the pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_pod_attach`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_pod_attach`")

        all_params = ['namespace', 'name', 'stdin', 'stdout', 'stderr', 'tty', 'container']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_pod_attach" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/attach'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'stdin' in params:
            query_params['stdin'] = params['stdin']
        if 'stdout' in params:
            query_params['stdout'] = params['stdout']
        if 'stderr' in params:
            query_params['stderr'] = params['stderr']
        if 'tty' in params:
            query_params['tty'] = params['tty']
        if 'container' in params:
            query_params['container'] = params['container']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_binding_binding(self, body, namespace, name, **kwargs):
        """
        create binding of a Binding
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_binding_binding(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Binding body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Binding (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Binding
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_binding_binding`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_binding_binding`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `create_namespaced_binding_binding`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_binding_binding" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/binding'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Binding',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_pod_exec(self, namespace, name, **kwargs):
        """
        connect GET requests to exec of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_pod_exec(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param bool stdin: Redirect the standard input stream of the pod for this call. Defaults to false.
        :param bool stdout: Redirect the standard output stream of the pod for this call. Defaults to true.
        :param bool stderr: Redirect the standard error stream of the pod for this call. Defaults to true.
        :param bool tty: TTY if true indicates that a tty will be allocated for the exec call. Defaults to false.
        :param str container: Container in which to execute the command. Defaults to only container if there is only one container in the pod.
        :param str command: Command is the remote command to execute. argv array. Not executed within a shell.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_pod_exec`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_pod_exec`")

        all_params = ['namespace', 'name', 'stdin', 'stdout', 'stderr', 'tty', 'container', 'command']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_pod_exec" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/exec'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'stdin' in params:
            query_params['stdin'] = params['stdin']
        if 'stdout' in params:
            query_params['stdout'] = params['stdout']
        if 'stderr' in params:
            query_params['stderr'] = params['stderr']
        if 'tty' in params:
            query_params['tty'] = params['tty']
        if 'container' in params:
            query_params['container'] = params['container']
        if 'command' in params:
            query_params['command'] = params['command']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_pod_exec(self, namespace, name, **kwargs):
        """
        connect POST requests to exec of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_pod_exec(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param bool stdin: Redirect the standard input stream of the pod for this call. Defaults to false.
        :param bool stdout: Redirect the standard output stream of the pod for this call. Defaults to true.
        :param bool stderr: Redirect the standard error stream of the pod for this call. Defaults to true.
        :param bool tty: TTY if true indicates that a tty will be allocated for the exec call. Defaults to false.
        :param str container: Container in which to execute the command. Defaults to only container if there is only one container in the pod.
        :param str command: Command is the remote command to execute. argv array. Not executed within a shell.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_pod_exec`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_pod_exec`")

        all_params = ['namespace', 'name', 'stdin', 'stdout', 'stderr', 'tty', 'container', 'command']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_pod_exec" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/exec'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'stdin' in params:
            query_params['stdin'] = params['stdin']
        if 'stdout' in params:
            query_params['stdout'] = params['stdout']
        if 'stderr' in params:
            query_params['stderr'] = params['stderr']
        if 'tty' in params:
            query_params['tty'] = params['tty']
        if 'container' in params:
            query_params['container'] = params['container']
        if 'command' in params:
            query_params['command'] = params['command']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_pod_log(self, namespace, name, **kwargs):
        """
        read log of the specified Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_pod_log(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str container: The container for which to stream logs. Defaults to only container if there is one container in the pod.
        :param bool follow: Follow the log stream of the pod. Defaults to false.
        :param bool previous: Return previous terminated container logs. Defaults to false.
        :param int since_seconds: A relative time in seconds before the current time from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.
        :param str since_time: An RFC3339 timestamp from which to show logs. If this value precedes the time a pod was started, only logs since the pod start will be returned. If this value is in the future, no logs will be returned. Only one of sinceSeconds or sinceTime may be specified.
        :param bool timestamps: If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line of log output. Defaults to false.
        :param int tail_lines: If set, the number of lines from the end of the logs to show. If not specified, logs are shown from the creation of the container or sinceSeconds or sinceTime
        :param int limit_bytes: If set, the number of bytes to read from the server before terminating the log output. This may not display a complete final line of logging, and may return slightly more or slightly less than the specified limit.
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_pod_log`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_pod_log`")

        all_params = ['namespace', 'name', 'pretty', 'container', 'follow', 'previous', 'since_seconds', 'since_time', 'timestamps', 'tail_lines', 'limit_bytes']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_pod_log" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/log'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'container' in params:
            query_params['container'] = params['container']
        if 'follow' in params:
            query_params['follow'] = params['follow']
        if 'previous' in params:
            query_params['previous'] = params['previous']
        if 'since_seconds' in params:
            query_params['sinceSeconds'] = params['since_seconds']
        if 'since_time' in params:
            query_params['sinceTime'] = params['since_time']
        if 'timestamps' in params:
            query_params['timestamps'] = params['timestamps']
        if 'tail_lines' in params:
            query_params['tailLines'] = params['tail_lines']
        if 'limit_bytes' in params:
            query_params['limitBytes'] = params['limit_bytes']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_pod_portforward(self, namespace, name, **kwargs):
        """
        connect GET requests to portforward of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_pod_portforward(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_pod_portforward`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_pod_portforward`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_pod_portforward" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/portforward'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_pod_portforward(self, namespace, name, **kwargs):
        """
        connect POST requests to portforward of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_pod_portforward(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_pod_portforward`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_pod_portforward`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_pod_portforward" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/portforward'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_pod_proxy(self, namespace, name, **kwargs):
        """
        connect GET requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_pod_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_pod_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_pod_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_pod_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_pod_proxy(self, namespace, name, **kwargs):
        """
        connect PUT requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_pod_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_put_namespaced_pod_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_pod_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_pod_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_pod_proxy(self, namespace, name, **kwargs):
        """
        connect POST requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_pod_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_pod_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_pod_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_pod_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_pod_proxy(self, namespace, name, **kwargs):
        """
        connect DELETE requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_pod_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_delete_namespaced_pod_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_pod_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_pod_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_pod_proxy(self, namespace, name, **kwargs):
        """
        connect OPTIONS requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_pod_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_options_namespaced_pod_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_pod_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_pod_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_pod_proxy_1(self, namespace, name, path, **kwargs):
        """
        connect GET requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_pod_proxy_1(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_pod_proxy_1`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_pod_proxy_1`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_get_namespaced_pod_proxy_1`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_pod_proxy_1" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_pod_proxy_2(self, namespace, name, path, **kwargs):
        """
        connect PUT requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_pod_proxy_2(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_put_namespaced_pod_proxy_2`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_pod_proxy_2`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_put_namespaced_pod_proxy_2`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_pod_proxy_2" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_pod_proxy_3(self, namespace, name, path, **kwargs):
        """
        connect POST requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_pod_proxy_3(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_pod_proxy_3`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_pod_proxy_3`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_post_namespaced_pod_proxy_3`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_pod_proxy_3" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_pod_proxy_4(self, namespace, name, path, **kwargs):
        """
        connect DELETE requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_pod_proxy_4(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_delete_namespaced_pod_proxy_4`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_pod_proxy_4`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_delete_namespaced_pod_proxy_4`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_pod_proxy_4" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_pod_proxy_5(self, namespace, name, path, **kwargs):
        """
        connect OPTIONS requests to proxy of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_pod_proxy_5(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to pod.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_options_namespaced_pod_proxy_5`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_pod_proxy_5`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_options_namespaced_pod_proxy_5`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_pod_proxy_5" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_pod_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_pod_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Pod body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Pod
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_pod_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_pod_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_pod_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_pod_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/pods/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Pod',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_pod_template(self, namespace, **kwargs):
        """
        list or watch objects of kind PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_pod_template(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PodTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_pod_template`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplateList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_pod_template(self, body, namespace, **kwargs):
        """
        create a PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_pod_template(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PodTemplate body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PodTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_pod_template`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_pod_template`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_pod_template(self, namespace, **kwargs):
        """
        delete collection of PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_pod_template(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_pod_template`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_pod_template(self, namespace, name, **kwargs):
        """
        read the specified PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_pod_template(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PodTemplate (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1PodTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_pod_template`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_pod_template`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_pod_template(self, body, namespace, name, **kwargs):
        """
        replace the specified PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_pod_template(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PodTemplate body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PodTemplate (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PodTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_pod_template`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_pod_template`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_pod_template`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_pod_template(self, body, namespace, name, **kwargs):
        """
        delete a PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_pod_template(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PodTemplate (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_pod_template`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_pod_template`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_pod_template`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_pod_template(self, body, namespace, name, **kwargs):
        """
        partially update the specified PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_pod_template(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PodTemplate (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PodTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_pod_template`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_pod_template`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_pod_template`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/podtemplates/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_replication_controller(self, namespace, **kwargs):
        """
        list or watch objects of kind ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_replication_controller(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ReplicationControllerList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_replication_controller`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationControllerList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_replication_controller(self, body, namespace, **kwargs):
        """
        create a ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_replication_controller(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ReplicationController body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ReplicationController
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_replication_controller`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_replication_controller`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationController',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_replication_controller(self, namespace, **kwargs):
        """
        delete collection of ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_replication_controller(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_replication_controller`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_replication_controller(self, namespace, name, **kwargs):
        """
        read the specified ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_replication_controller(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1ReplicationController
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_replication_controller`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_replication_controller`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationController',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_replication_controller(self, body, namespace, name, **kwargs):
        """
        replace the specified ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replication_controller(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ReplicationController body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ReplicationController
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replication_controller`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replication_controller`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replication_controller`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationController',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_replication_controller(self, body, namespace, name, **kwargs):
        """
        delete a ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_replication_controller(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_replication_controller`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_replication_controller`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_replication_controller`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_replication_controller(self, body, namespace, name, **kwargs):
        """
        partially update the specified ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_replication_controller(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ReplicationController
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_replication_controller`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_replication_controller`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_replication_controller`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationController',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_scale_scale(self, namespace, name, **kwargs):
        """
        read scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_scale_scale(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_scale_scale`")

        all_params = ['namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_scale_scale(self, body, namespace, name, **kwargs):
        """
        replace scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_scale_scale(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Scale body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_scale_scale`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_scale_scale`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_scale_scale(self, body, namespace, name, **kwargs):
        """
        partially update scale of the specified Scale
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_scale_scale(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Scale (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Scale
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_scale_scale`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_scale_scale`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_scale_scale`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_scale_scale" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}/scale'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Scale',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_replication_controller_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_replication_controller_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ReplicationController body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ReplicationController
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_replication_controller_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_replication_controller_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_replication_controller_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_replication_controller_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/replicationcontrollers/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationController',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_resource_quota(self, namespace, **kwargs):
        """
        list or watch objects of kind ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_resource_quota(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ResourceQuotaList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_resource_quota`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuotaList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_resource_quota(self, body, namespace, **kwargs):
        """
        create a ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_resource_quota(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ResourceQuota body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ResourceQuota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_resource_quota`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_resource_quota`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuota',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_resource_quota(self, namespace, **kwargs):
        """
        delete collection of ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_resource_quota(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_resource_quota`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_resource_quota(self, namespace, name, **kwargs):
        """
        read the specified ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_resource_quota(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1ResourceQuota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_resource_quota`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_resource_quota`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuota',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_resource_quota(self, body, namespace, name, **kwargs):
        """
        replace the specified ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_resource_quota(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ResourceQuota body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ResourceQuota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_resource_quota`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_resource_quota`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_resource_quota`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuota',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_resource_quota(self, body, namespace, name, **kwargs):
        """
        delete a ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_resource_quota(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_resource_quota`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_resource_quota`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_resource_quota`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_resource_quota(self, body, namespace, name, **kwargs):
        """
        partially update the specified ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_resource_quota(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ResourceQuota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_resource_quota`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_resource_quota`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_resource_quota`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuota',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_resource_quota_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_resource_quota_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ResourceQuota body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ResourceQuota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_resource_quota_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_resource_quota_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_resource_quota_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_resource_quota_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/resourcequotas/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuota',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_secret(self, namespace, **kwargs):
        """
        list or watch objects of kind Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_secret(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1SecretList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_secret`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1SecretList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_secret(self, body, namespace, **kwargs):
        """
        create a Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_secret(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Secret body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Secret
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_secret`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_secret`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Secret',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_secret(self, namespace, **kwargs):
        """
        delete collection of Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_secret(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_secret`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_secret(self, namespace, name, **kwargs):
        """
        read the specified Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_secret(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Secret (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Secret
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_secret`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_secret`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Secret',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_secret(self, body, namespace, name, **kwargs):
        """
        replace the specified Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_secret(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Secret body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Secret (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Secret
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_secret`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_secret`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_secret`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Secret',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_secret(self, body, namespace, name, **kwargs):
        """
        delete a Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_secret(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Secret (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_secret`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_secret`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_secret`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_secret(self, body, namespace, name, **kwargs):
        """
        partially update the specified Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_secret(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Secret (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Secret
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_secret`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_secret`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_secret`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/secrets/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Secret',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_service_account(self, namespace, **kwargs):
        """
        list or watch objects of kind ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_service_account(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ServiceAccountList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_service_account`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccountList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_service_account(self, body, namespace, **kwargs):
        """
        create a ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_service_account(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ServiceAccount body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_service_account`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_service_account`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccount',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_service_account(self, namespace, **kwargs):
        """
        delete collection of ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_service_account(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `deletecollection_namespaced_service_account`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_service_account(self, namespace, name, **kwargs):
        """
        read the specified ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_service_account(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ServiceAccount (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1ServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_service_account`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_service_account`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccount',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_service_account(self, body, namespace, name, **kwargs):
        """
        replace the specified ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_service_account(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1ServiceAccount body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ServiceAccount (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_service_account`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_service_account`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_service_account`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccount',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_service_account(self, body, namespace, name, **kwargs):
        """
        delete a ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_service_account(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ServiceAccount (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_service_account`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_service_account`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_service_account`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_service_account(self, body, namespace, name, **kwargs):
        """
        partially update the specified ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_service_account(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ServiceAccount (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1ServiceAccount
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_service_account`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_service_account`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_service_account`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/serviceaccounts/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccount',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_service(self, namespace, **kwargs):
        """
        list or watch objects of kind Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_service(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `list_namespaced_service`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_service(self, body, namespace, **kwargs):
        """
        create a Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_service(body, namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Service body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_service`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `create_namespaced_service`")

        all_params = ['body', 'namespace', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Service',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_service(self, namespace, name, **kwargs):
        """
        read the specified Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `read_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_service`")

        all_params = ['namespace', 'name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Service',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_service(self, body, namespace, name, **kwargs):
        """
        replace the specified Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_service(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Service body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_service`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_service`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Service',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_service(self, namespace, name, **kwargs):
        """
        delete a Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `delete_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_service`")

        all_params = ['namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_service(self, body, namespace, name, **kwargs):
        """
        partially update the specified Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_service(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_service`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `patch_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_service`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Service',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_service_proxy(self, namespace, name, **kwargs):
        """
        connect GET requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_service_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_service_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_service_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_service_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_service_proxy(self, namespace, name, **kwargs):
        """
        connect PUT requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_service_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_put_namespaced_service_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_service_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_service_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_service_proxy(self, namespace, name, **kwargs):
        """
        connect POST requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_service_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_service_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_service_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_service_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_service_proxy(self, namespace, name, **kwargs):
        """
        connect DELETE requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_service_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_delete_namespaced_service_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_service_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_service_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_service_proxy(self, namespace, name, **kwargs):
        """
        connect OPTIONS requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_service_proxy(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_options_namespaced_service_proxy`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_service_proxy`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_service_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_service_proxy_6(self, namespace, name, path, **kwargs):
        """
        connect GET requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_service_proxy_6(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_get_namespaced_service_proxy_6`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_service_proxy_6`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_get_namespaced_service_proxy_6`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_service_proxy_6" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_service_proxy_7(self, namespace, name, path, **kwargs):
        """
        connect PUT requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_service_proxy_7(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_put_namespaced_service_proxy_7`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_service_proxy_7`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_put_namespaced_service_proxy_7`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_service_proxy_7" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_service_proxy_8(self, namespace, name, path, **kwargs):
        """
        connect POST requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_service_proxy_8(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_post_namespaced_service_proxy_8`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_service_proxy_8`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_post_namespaced_service_proxy_8`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_service_proxy_8" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_service_proxy_9(self, namespace, name, path, **kwargs):
        """
        connect DELETE requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_service_proxy_9(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_delete_namespaced_service_proxy_9`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_service_proxy_9`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_delete_namespaced_service_proxy_9`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_service_proxy_9" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_service_proxy_10(self, namespace, name, path, **kwargs):
        """
        connect OPTIONS requests to proxy of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_service_proxy_10(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :param str path: Path is the part of URLs that include service endpoints, suffixes, and parameters to use for the current proxy request to service. For example, the whole request URL is http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy. Path is _search?q=user:kimchy.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `connect_options_namespaced_service_proxy_10`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_service_proxy_10`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_options_namespaced_service_proxy_10`")

        all_params = ['namespace', 'name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_service_proxy_10" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_service_status(self, body, namespace, name, **kwargs):
        """
        replace status of the specified Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_service_status(body, namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Service body:  (required)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Service
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_service_status`")
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `replace_namespaced_service_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_service_status`")

        all_params = ['body', 'namespace', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_service_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{namespace}/services/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Service',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_namespace(self, name, **kwargs):
        """
        read the specified Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_namespace(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_namespace`")

        all_params = ['name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_namespace(self, body, name, **kwargs):
        """
        replace the specified Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_namespace(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Namespace body:  (required)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_namespace`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_namespace`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_namespace(self, body, name, **kwargs):
        """
        delete a Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_namespace(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_namespace`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_namespace`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_namespace(self, body, name, **kwargs):
        """
        partially update the specified Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_namespace(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_namespace`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_namespace`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_namespace_finalize(self, body, name, **kwargs):
        """
        replace finalize of the specified Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_namespace_finalize(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Namespace body:  (required)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_namespace_finalize`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_namespace_finalize`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_namespace_finalize" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}/finalize'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_namespace_status(self, body, name, **kwargs):
        """
        replace status of the specified Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_namespace_status(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Namespace body:  (required)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Namespace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_namespace_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_namespace_status`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_namespace_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/namespaces/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Namespace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_node(self, **kwargs):
        """
        list or watch objects of kind Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_node(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1NodeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1NodeList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_node(self, body, **kwargs):
        """
        create a Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_node(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Node body:  (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_node`")

        all_params = ['body', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Node',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_node(self, **kwargs):
        """
        delete collection of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_node(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_node(self, name, **kwargs):
        """
        read the specified Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_node`")

        all_params = ['name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Node',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_node(self, body, name, **kwargs):
        """
        replace the specified Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_node(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Node body:  (required)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_node`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_node`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Node',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_node(self, body, name, **kwargs):
        """
        delete a Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_node(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_node`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_node`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_node(self, body, name, **kwargs):
        """
        partially update the specified Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_node(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_node`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_node`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Node',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_node_proxy(self, name, **kwargs):
        """
        connect GET requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_node_proxy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_node_proxy`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_node_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_node_proxy(self, name, **kwargs):
        """
        connect PUT requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_node_proxy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_node_proxy`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_node_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_node_proxy(self, name, **kwargs):
        """
        connect POST requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_node_proxy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_node_proxy`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_node_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_node_proxy(self, name, **kwargs):
        """
        connect DELETE requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_node_proxy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_node_proxy`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_node_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_node_proxy(self, name, **kwargs):
        """
        connect OPTIONS requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_node_proxy(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_node_proxy`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_node_proxy" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_get_namespaced_node_proxy_11(self, name, path, **kwargs):
        """
        connect GET requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_get_namespaced_node_proxy_11(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_get_namespaced_node_proxy_11`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_get_namespaced_node_proxy_11`")

        all_params = ['name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_get_namespaced_node_proxy_11" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_put_namespaced_node_proxy_12(self, name, path, **kwargs):
        """
        connect PUT requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_put_namespaced_node_proxy_12(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_put_namespaced_node_proxy_12`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_put_namespaced_node_proxy_12`")

        all_params = ['name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_put_namespaced_node_proxy_12" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_post_namespaced_node_proxy_13(self, name, path, **kwargs):
        """
        connect POST requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_post_namespaced_node_proxy_13(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_post_namespaced_node_proxy_13`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_post_namespaced_node_proxy_13`")

        all_params = ['name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_post_namespaced_node_proxy_13" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_delete_namespaced_node_proxy_14(self, name, path, **kwargs):
        """
        connect DELETE requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_delete_namespaced_node_proxy_14(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_delete_namespaced_node_proxy_14`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_delete_namespaced_node_proxy_14`")

        all_params = ['name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_delete_namespaced_node_proxy_14" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def connect_options_namespaced_node_proxy_15(self, name, path, **kwargs):
        """
        connect OPTIONS requests to proxy of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.connect_options_namespaced_node_proxy_15(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :param str path: Path is the URL path to use for the current proxy request to node.
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `connect_options_namespaced_node_proxy_15`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `connect_options_namespaced_node_proxy_15`")

        all_params = ['name', 'path', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method connect_options_namespaced_node_proxy_15" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/proxy/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}
        if 'path' in params:
            query_params['path'] = params['path']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_node_status(self, body, name, **kwargs):
        """
        replace status of the specified Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_node_status(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1Node body:  (required)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1Node
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_node_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_node_status`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_node_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/nodes/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1Node',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_persistent_volume_claim(self, **kwargs):
        """
        list or watch objects of kind PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_persistent_volume_claim(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PersistentVolumeClaimList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeClaimList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_namespaced_persistent_volume(self, **kwargs):
        """
        list or watch objects of kind PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_namespaced_persistent_volume(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PersistentVolumeList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolumeList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def create_namespaced_persistent_volume(self, body, **kwargs):
        """
        create a PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.create_namespaced_persistent_volume(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolume body:  (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `create_namespaced_persistent_volume`")

        all_params = ['body', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolume',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def deletecollection_namespaced_persistent_volume(self, **kwargs):
        """
        delete collection of PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.deletecollection_namespaced_persistent_volume(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method deletecollection_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def read_namespaced_persistent_volume(self, name, **kwargs):
        """
        read the specified PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.read_namespaced_persistent_volume(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param bool export: Should this value be exported.  Export strips fields that a user can not specify.
        :param bool exact: Should the export be exact.  Exact export maintains cluster-specific fields like 'Namespace'
        :return: V1PersistentVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `read_namespaced_persistent_volume`")

        all_params = ['name', 'pretty', 'export', 'exact']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'export' in params:
            query_params['export'] = params['export']
        if 'exact' in params:
            query_params['exact'] = params['exact']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolume',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_persistent_volume(self, body, name, **kwargs):
        """
        replace the specified PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_persistent_volume(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolume body:  (required)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_persistent_volume`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_persistent_volume`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolume',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_namespaced_persistent_volume(self, body, name, **kwargs):
        """
        delete a PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_namespaced_persistent_volume(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1DeleteOptions body:  (required)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: UnversionedStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `delete_namespaced_persistent_volume`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `delete_namespaced_persistent_volume`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='UnversionedStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_namespaced_persistent_volume(self, body, name, **kwargs):
        """
        partially update the specified PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_namespaced_persistent_volume(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UnversionedPatch body:  (required)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `patch_namespaced_persistent_volume`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `patch_namespaced_persistent_volume`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes/{name}'.replace('{format}', 'json')
        method = 'PATCH'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/merge-patch+json', 'application/strategic-merge-patch+json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolume',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def replace_namespaced_persistent_volume_status(self, body, name, **kwargs):
        """
        replace status of the specified PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.replace_namespaced_persistent_volume_status(body, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param V1PersistentVolume body:  (required)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :return: V1PersistentVolume
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'body' is set
        if body is None:
            raise ValueError("Missing the required parameter `body` when calling `replace_namespaced_persistent_volume_status`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `replace_namespaced_persistent_volume_status`")

        all_params = ['body', 'name', 'pretty']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method replace_namespaced_persistent_volume_status" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/persistentvolumes/{name}/status'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PersistentVolume',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_pod(self, **kwargs):
        """
        list or watch objects of kind Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pod(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PodList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/pods'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_pod_template(self, **kwargs):
        """
        list or watch objects of kind PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_pod_template(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1PodTemplateList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/podtemplates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1PodTemplateList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_pod(self, namespace, name, **kwargs):
        """
        proxy GET requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_get_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_pod`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_pod(self, namespace, name, **kwargs):
        """
        proxy PUT requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_put_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_pod`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_pod(self, namespace, name, **kwargs):
        """
        proxy POST requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_post_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_pod`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_pod(self, namespace, name, **kwargs):
        """
        proxy DELETE requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_delete_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_pod`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_pod(self, namespace, name, **kwargs):
        """
        proxy OPTIONS requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_options_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_pod`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_pod_16(self, namespace, name, path, **kwargs):
        """
        proxy GET requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_pod_16(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_get_namespaced_pod_16`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_pod_16`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_get_namespaced_pod_16`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_pod_16" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_pod_17(self, namespace, name, path, **kwargs):
        """
        proxy PUT requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_pod_17(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_put_namespaced_pod_17`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_pod_17`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_put_namespaced_pod_17`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_pod_17" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_pod_18(self, namespace, name, path, **kwargs):
        """
        proxy POST requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_pod_18(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_post_namespaced_pod_18`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_pod_18`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_post_namespaced_pod_18`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_pod_18" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_pod_19(self, namespace, name, path, **kwargs):
        """
        proxy DELETE requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_pod_19(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_delete_namespaced_pod_19`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_pod_19`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_delete_namespaced_pod_19`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_pod_19" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_pod_20(self, namespace, name, path, **kwargs):
        """
        proxy OPTIONS requests to Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_pod_20(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_options_namespaced_pod_20`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_pod_20`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_options_namespaced_pod_20`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_pod_20" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/pods/{name}/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_service(self, namespace, name, **kwargs):
        """
        proxy GET requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_get_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_service`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_service(self, namespace, name, **kwargs):
        """
        proxy PUT requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_put_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_service`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_service(self, namespace, name, **kwargs):
        """
        proxy POST requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_post_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_service`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_service(self, namespace, name, **kwargs):
        """
        proxy DELETE requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_delete_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_service`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_service(self, namespace, name, **kwargs):
        """
        proxy OPTIONS requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_options_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_service`")

        all_params = ['namespace', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_service_21(self, namespace, name, path, **kwargs):
        """
        proxy GET requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_service_21(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_get_namespaced_service_21`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_service_21`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_get_namespaced_service_21`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_service_21" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_service_22(self, namespace, name, path, **kwargs):
        """
        proxy PUT requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_service_22(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_put_namespaced_service_22`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_service_22`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_put_namespaced_service_22`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_service_22" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_service_23(self, namespace, name, path, **kwargs):
        """
        proxy POST requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_service_23(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_post_namespaced_service_23`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_service_23`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_post_namespaced_service_23`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_service_23" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_service_24(self, namespace, name, path, **kwargs):
        """
        proxy DELETE requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_service_24(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_delete_namespaced_service_24`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_service_24`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_delete_namespaced_service_24`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_service_24" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_service_25(self, namespace, name, path, **kwargs):
        """
        proxy OPTIONS requests to Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_service_25(namespace, name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `proxy_options_namespaced_service_25`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_service_25`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_options_namespaced_service_25`")

        all_params = ['namespace', 'name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_service_25" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/namespaces/{namespace}/services/{name}/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_node(self, name, **kwargs):
        """
        proxy GET requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_node`")

        all_params = ['name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_node(self, name, **kwargs):
        """
        proxy PUT requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_node`")

        all_params = ['name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_node(self, name, **kwargs):
        """
        proxy POST requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_node`")

        all_params = ['name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_node(self, name, **kwargs):
        """
        proxy DELETE requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_node`")

        all_params = ['name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_node(self, name, **kwargs):
        """
        proxy OPTIONS requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_node`")

        all_params = ['name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_get_namespaced_node_26(self, name, path, **kwargs):
        """
        proxy GET requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_get_namespaced_node_26(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_get_namespaced_node_26`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_get_namespaced_node_26`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_get_namespaced_node_26" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}/{path}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_put_namespaced_node_27(self, name, path, **kwargs):
        """
        proxy PUT requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_put_namespaced_node_27(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_put_namespaced_node_27`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_put_namespaced_node_27`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_put_namespaced_node_27" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}/{path}'.replace('{format}', 'json')
        method = 'PUT'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_post_namespaced_node_28(self, name, path, **kwargs):
        """
        proxy POST requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_post_namespaced_node_28(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_post_namespaced_node_28`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_post_namespaced_node_28`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_post_namespaced_node_28" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}/{path}'.replace('{format}', 'json')
        method = 'POST'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_delete_namespaced_node_29(self, name, path, **kwargs):
        """
        proxy DELETE requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_delete_namespaced_node_29(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_delete_namespaced_node_29`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_delete_namespaced_node_29`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_delete_namespaced_node_29" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}/{path}'.replace('{format}', 'json')
        method = 'DELETE'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def proxy_options_namespaced_node_30(self, name, path, **kwargs):
        """
        proxy OPTIONS requests to Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.proxy_options_namespaced_node_30(name, path, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str path: path to the resource (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `proxy_options_namespaced_node_30`")
        # verify the required parameter 'path' is set
        if path is None:
            raise ValueError("Missing the required parameter `path` when calling `proxy_options_namespaced_node_30`")

        all_params = ['name', 'path']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method proxy_options_namespaced_node_30" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/proxy/nodes/{name}/{path}'.replace('{format}', 'json')
        method = 'OPTIONS'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']
        if 'path' in params:
            path_params['path'] = params['path']

        query_params = {}

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['*/*'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_replication_controller(self, **kwargs):
        """
        list or watch objects of kind ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_replication_controller(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ReplicationControllerList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/replicationcontrollers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ReplicationControllerList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_resource_quota(self, **kwargs):
        """
        list or watch objects of kind ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_resource_quota(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ResourceQuotaList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/resourcequotas'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ResourceQuotaList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_secret(self, **kwargs):
        """
        list or watch objects of kind Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_secret(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1SecretList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/secrets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1SecretList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_service_account(self, **kwargs):
        """
        list or watch objects of kind ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service_account(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ServiceAccountList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/serviceaccounts'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceAccountList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def list_service(self, **kwargs):
        """
        list or watch objects of kind Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.list_service(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: V1ServiceList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/services'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json', 'application/yaml'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='V1ServiceList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_config_map_list(self, **kwargs):
        """
        watch individual changes to a list of ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_config_map_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_config_map_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/configmaps'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_endpoints_list(self, **kwargs):
        """
        watch individual changes to a list of Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_endpoints_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_endpoints_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/endpoints'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_event_list(self, **kwargs):
        """
        watch individual changes to a list of Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_event_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_event_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/events'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_limit_range_list(self, **kwargs):
        """
        watch individual changes to a list of LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_limit_range_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_limit_range_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/limitranges'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_namespace_list(self, **kwargs):
        """
        watch individual changes to a list of Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_namespace_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_namespace_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_config_map_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_config_map_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_config_map_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_config_map_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/configmaps'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_config_map(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind ConfigMap
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_config_map(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ConfigMap (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_config_map`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_config_map`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_config_map" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/configmaps/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_endpoints_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_endpoints_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_endpoints_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_endpoints_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/endpoints'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_endpoints(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Endpoints
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_endpoints(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Endpoints (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_endpoints`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_endpoints`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_endpoints" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/endpoints/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_event_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_event_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_event_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_event_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/events'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_event(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Event
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_event(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Event (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_event`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_event`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_event" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/events/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_limit_range_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_limit_range_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_limit_range_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_limit_range_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/limitranges'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_limit_range(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind LimitRange
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_limit_range(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the LimitRange (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_limit_range`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_limit_range`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_limit_range" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/limitranges/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_persistent_volume_claim_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_persistent_volume_claim_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_persistent_volume_claim_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_persistent_volume_claim_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_persistent_volume_claim(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_persistent_volume_claim(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PersistentVolumeClaim (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_persistent_volume_claim`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_persistent_volume_claim`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_persistent_volume_claim" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/persistentvolumeclaims/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_pod_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_pod_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_pod_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_pod_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/pods'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_pod(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_pod(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Pod (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_pod`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_pod`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_pod" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/pods/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_pod_template_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_pod_template_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_pod_template_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_pod_template_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/podtemplates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_pod_template(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_pod_template(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the PodTemplate (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_pod_template`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_pod_template`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_pod_template" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/podtemplates/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_replication_controller_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_replication_controller_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_replication_controller_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_replication_controller_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/replicationcontrollers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_replication_controller(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_replication_controller(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ReplicationController (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_replication_controller`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_replication_controller`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_replication_controller" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/replicationcontrollers/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_resource_quota_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_resource_quota_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_resource_quota_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_resource_quota_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/resourcequotas'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_resource_quota(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_resource_quota(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ResourceQuota (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_resource_quota`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_resource_quota`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_resource_quota" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/resourcequotas/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_secret_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_secret_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_secret_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_secret_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/secrets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_secret(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_secret(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Secret (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_secret`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_secret`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_secret" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/secrets/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_service_account_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_service_account_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_service_account_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_service_account_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/serviceaccounts'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_service_account(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_service_account(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the ServiceAccount (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_service_account`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_service_account`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_service_account" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/serviceaccounts/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_service_list(self, namespace, **kwargs):
        """
        watch individual changes to a list of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_service_list(namespace, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_service_list`")

        all_params = ['namespace', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_service_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/services'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_service(self, namespace, name, **kwargs):
        """
        watch changes to an object of kind Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_service(namespace, name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace: object name and auth scope, such as for teams and projects (required)
        :param str name: name of the Service (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'namespace' is set
        if namespace is None:
            raise ValueError("Missing the required parameter `namespace` when calling `watch_namespaced_service`")
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_service`")

        all_params = ['namespace', 'name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_service" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{namespace}/services/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_namespace(self, name, **kwargs):
        """
        watch changes to an object of kind Namespace
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_namespace(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Namespace (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_namespace`")

        all_params = ['name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/namespaces/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_node_list(self, **kwargs):
        """
        watch individual changes to a list of Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_node_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_node_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/nodes'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_node(self, name, **kwargs):
        """
        watch changes to an object of kind Node
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_node(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the Node (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_node`")

        all_params = ['name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_node" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/nodes/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_persistent_volume_claim_list(self, **kwargs):
        """
        watch individual changes to a list of PersistentVolumeClaim
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_persistent_volume_claim_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_persistent_volume_claim_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/persistentvolumeclaims'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_persistent_volume_list(self, **kwargs):
        """
        watch individual changes to a list of PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_persistent_volume_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_persistent_volume_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/persistentvolumes'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_namespaced_persistent_volume(self, name, **kwargs):
        """
        watch changes to an object of kind PersistentVolume
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_namespaced_persistent_volume(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: name of the PersistentVolume (required)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        # verify the required parameter 'name' is set
        if name is None:
            raise ValueError("Missing the required parameter `name` when calling `watch_namespaced_persistent_volume`")

        all_params = ['name', 'pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_namespaced_persistent_volume" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/persistentvolumes/{name}'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_pod_list(self, **kwargs):
        """
        watch individual changes to a list of Pod
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_pod_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_pod_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/pods'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_pod_template_list(self, **kwargs):
        """
        watch individual changes to a list of PodTemplate
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_pod_template_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_pod_template_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/podtemplates'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_replication_controller_list(self, **kwargs):
        """
        watch individual changes to a list of ReplicationController
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_replication_controller_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_replication_controller_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/replicationcontrollers'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_resource_quota_list(self, **kwargs):
        """
        watch individual changes to a list of ResourceQuota
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_resource_quota_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_resource_quota_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/resourcequotas'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_secret_list(self, **kwargs):
        """
        watch individual changes to a list of Secret
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_secret_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_secret_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/secrets'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_service_account_list(self, **kwargs):
        """
        watch individual changes to a list of ServiceAccount
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_service_account_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_service_account_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/serviceaccounts'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def watch_service_list(self, **kwargs):
        """
        watch individual changes to a list of Service
        

        This method makes a synchronous HTTP request by default.To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.watch_service_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str pretty: If 'true', then the output is pretty printed.
        :param str label_selector: A selector to restrict the list of returned objects by their labels. Defaults to everything.
        :param str field_selector: A selector to restrict the list of returned objects by their fields. Defaults to everything.
        :param bool watch: Watch for changes to the described resources and return them as a stream of add, update, and remove notifications. Specify resourceVersion.
        :param str resource_version: When specified with a watch call, shows changes that occur after that particular version of a resource. Defaults to changes from the beginning of history.
        :param int timeout_seconds: Timeout for the list/watch call.
        :return: JsonWatchEvent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['pretty', 'label_selector', 'field_selector', 'watch', 'resource_version', 'timeout_seconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method watch_service_list" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/api/v1/watch/services'.replace('{format}', 'json')
        method = 'GET'

        path_params = {}

        query_params = {}
        if 'pretty' in params:
            query_params['pretty'] = params['pretty']
        if 'label_selector' in params:
            query_params['labelSelector'] = params['label_selector']
        if 'field_selector' in params:
            query_params['fieldSelector'] = params['field_selector']
        if 'watch' in params:
            query_params['watch'] = params['watch']
        if 'resource_version' in params:
            query_params['resourceVersion'] = params['resource_version']
        if 'timeout_seconds' in params:
            query_params['timeoutSeconds'] = params['timeout_seconds']

        header_params = {}

        form_params = {}
        files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['*/*'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, method,
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=files,
                                            response_type='JsonWatchEvent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
