# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIManagedEnvironmentsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_list_by_subscription(self, resource_group):
        response = self.client.managed_environments.list_by_subscription(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_list_by_resource_group(self, resource_group):
        response = self.client.managed_environments.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_get(self, resource_group):
        response = self.client.managed_environments.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_begin_create_or_update(self, resource_group):
        response = self.client.managed_environments.begin_create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            environment_envelope={
                "location": "str",
                "appLogsConfiguration": {
                    "destination": "str",
                    "logAnalyticsConfiguration": {"customerId": "str", "sharedKey": "str"},
                },
                "customDomainConfiguration": {
                    "certificateKeyVaultProperties": {"identity": "str", "keyVaultUrl": "str"},
                    "certificatePassword": "str",
                    "certificateValue": bytes("bytes", encoding="utf-8"),
                    "customDomainVerificationId": "str",
                    "dnsSuffix": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "subjectName": "str",
                    "thumbprint": "str",
                },
                "daprAIConnectionString": "str",
                "daprAIInstrumentationKey": "str",
                "daprConfiguration": {"version": "str"},
                "defaultDomain": "str",
                "deploymentErrors": "str",
                "eventStreamEndpoint": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "infrastructureResourceGroup": "str",
                "kedaConfiguration": {"version": "str"},
                "kind": "str",
                "name": "str",
                "peerAuthentication": {"mtls": {"enabled": bool}},
                "peerTrafficConfiguration": {"encryption": {"enabled": bool}},
                "provisioningState": "str",
                "staticIp": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "vnetConfiguration": {
                    "dockerBridgeCidr": "str",
                    "infrastructureSubnetId": "str",
                    "internal": bool,
                    "platformReservedCidr": "str",
                    "platformReservedDnsIP": "str",
                },
                "workloadProfiles": [
                    {"name": "str", "workloadProfileType": "str", "maximumCount": 0, "minimumCount": 0}
                ],
                "zoneRedundant": bool,
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_begin_delete(self, resource_group):
        response = self.client.managed_environments.begin_delete(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_begin_update(self, resource_group):
        response = self.client.managed_environments.begin_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            environment_envelope={
                "location": "str",
                "appLogsConfiguration": {
                    "destination": "str",
                    "logAnalyticsConfiguration": {"customerId": "str", "sharedKey": "str"},
                },
                "customDomainConfiguration": {
                    "certificateKeyVaultProperties": {"identity": "str", "keyVaultUrl": "str"},
                    "certificatePassword": "str",
                    "certificateValue": bytes("bytes", encoding="utf-8"),
                    "customDomainVerificationId": "str",
                    "dnsSuffix": "str",
                    "expirationDate": "2020-02-20 00:00:00",
                    "subjectName": "str",
                    "thumbprint": "str",
                },
                "daprAIConnectionString": "str",
                "daprAIInstrumentationKey": "str",
                "daprConfiguration": {"version": "str"},
                "defaultDomain": "str",
                "deploymentErrors": "str",
                "eventStreamEndpoint": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "infrastructureResourceGroup": "str",
                "kedaConfiguration": {"version": "str"},
                "kind": "str",
                "name": "str",
                "peerAuthentication": {"mtls": {"enabled": bool}},
                "peerTrafficConfiguration": {"encryption": {"enabled": bool}},
                "provisioningState": "str",
                "staticIp": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "vnetConfiguration": {
                    "dockerBridgeCidr": "str",
                    "infrastructureSubnetId": "str",
                    "internal": bool,
                    "platformReservedCidr": "str",
                    "platformReservedDnsIP": "str",
                },
                "workloadProfiles": [
                    {"name": "str", "workloadProfileType": "str", "maximumCount": 0, "minimumCount": 0}
                ],
                "zoneRedundant": bool,
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_get_auth_token(self, resource_group):
        response = self.client.managed_environments.get_auth_token(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_managed_environments_list_workload_profile_states(self, resource_group):
        response = self.client.managed_environments.list_workload_profile_states(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
