(*
    Copyright (c) 2000
        Cambridge University Technical Services Limited

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.
    
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.
    
    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)


structure XKeySyms: XKEYSYMS_SIG = struct

  val XK_VoidSymbol = 16777215 ;

(*
 * TTY Functions, cleverly chosen to map to ascii, for convenience of
 * programming, but could have been arbitrary (at the cost of lookup
 * tables in client code.
 *)

  val XK_BackSpace    = 65288 ;
  val XK_Tab          = 65289 ;
  val XK_Linefeed     = 65290 ;
  val XK_Clear        = 65291 ;
  val XK_Return       = 65293 ;
  val XK_Pause        = 65299 ;
  val XK_Scroll_Lock  = 65300 ;
  val XK_Escape       = 65307 ;
  val XK_Delete       = 65535 ;

(* International & multi-key character composition *)

  val XK_Multi_key = 65312 ;

(* Japanese keyboard support *)

  val XK_Kanji              = 65313 ;
  val XK_Muhenkan           = 65314 ;
  val XK_Henkan_Mode        = 65315 ;
  val XK_Henkan             = 65315 ;
  val XK_Romaji             = 65316 ;
  val XK_Hiragana           = 65317 ;
  val XK_Katakana           = 65318 ;
  val XK_Hiragana_Katakana  = 65319 ;
  val XK_Zenkaku            = 65320 ;
  val XK_Hankaku            = 65321 ;
  val XK_Zenkaku_Hankaku    = 65322 ;
  val XK_Touroku            = 65323 ;
  val XK_Massyo             = 65324 ;
  val XK_Kana_Lock          = 65325 ;
  val XK_Kana_Shift         = 65326 ;
  val XK_Eisu_Shift         = 65327 ;
  val XK_Eisu_toggle        = 65328 ;

(* Cursor control & motion *)

  val XK_Home   = 65360 ;
  val XK_Left   = 65361 ;
  val XK_Up     = 65362 ;
  val XK_Right  = 65363 ;
  val XK_Down   = 65364 ;
  val XK_Prior  = 65365 ;
  val XK_Next   = 65366 ;
  val XK_End    = 65367 ;
  val XK_Begin  = 65368 ;

(* Misc Functions *)

  val XK_Select         = 65376 ;
  val XK_Print          = 65377 ;
  val XK_Execute        = 65378 ;
  val XK_Insert         = 65379 ;
  val XK_Undo           = 65381 ;
  val XK_Redo           = 65382 ;
  val XK_Menu           = 65383 ;
  val XK_Find           = 65384 ;
  val XK_Cancel         = 65385 ;
  val XK_Help           = 65386 ;
  val XK_Break          = 65387 ;
  val XK_Mode_switch    = 65406 ;
  val XK_script_switch  = 65406 ;
  val XK_Num_Lock       = 65407 ;

(* Keypad Functions, keypad numbers cleverly chosen to map to ascii *)

  val XK_KP_Space      = 65408 ;
  val XK_KP_Tab        = 65417 ;
  val XK_KP_Enter      = 65421 ;
  val XK_KP_F1         = 65425 ;
  val XK_KP_F2         = 65426 ;
  val XK_KP_F3         = 65427 ;
  val XK_KP_F4         = 65428 ;
  val XK_KP_Equal      = 65469 ;
  val XK_KP_Multiply   = 65450 ;
  val XK_KP_Add        = 65451 ;
  val XK_KP_Separator  = 65452 ;
  val XK_KP_Subtract   = 65453 ;
  val XK_KP_Decimal    = 65454 ;
  val XK_KP_Divide     = 65455 ;

  val XK_KP_0 = 65456 ;
  val XK_KP_1 = 65457 ;
  val XK_KP_2 = 65458 ;
  val XK_KP_3 = 65459 ;
  val XK_KP_4 = 65460 ;
  val XK_KP_5 = 65461 ;
  val XK_KP_6 = 65462 ;
  val XK_KP_7 = 65463 ;
  val XK_KP_8 = 65464 ;
  val XK_KP_9 = 65465 ;

(*
 * Auxilliary Functions; note the duplicate definitions for left and right
 * function keys;  Sun keyboards and a few other manufactures have such
 * function key groups on the left and/or right sides of the keyboard.
 * We've not found a keyboard with more than 35 function keys total.
 *)

  val XK_F1   = 65470 ;
  val XK_F2   = 65471 ;
  val XK_F3   = 65472 ;
  val XK_F4   = 65473 ;
  val XK_F5   = 65474 ;
  val XK_F6   = 65475 ;
  val XK_F7   = 65476 ;
  val XK_F8   = 65477 ;
  val XK_F9   = 65478 ;
  val XK_F10  = 65479 ;
  val XK_F11  = 65480 ;
  val XK_L1   = 65480 ;
  val XK_F12  = 65481 ;
  val XK_L2   = 65481 ;
  val XK_F13  = 65482 ;
  val XK_L3   = 65482 ;
  val XK_F14  = 65483 ;
  val XK_L4   = 65483 ;
  val XK_F15  = 65484 ;
  val XK_L5   = 65484 ;
  val XK_F16  = 65485 ;
  val XK_L6   = 65485 ;
  val XK_F17  = 65486 ;
  val XK_L7   = 65486 ;
  val XK_F18  = 65487 ;
  val XK_L8   = 65487 ;
  val XK_F19  = 65488 ;
  val XK_L9   = 65488 ;
  val XK_F20  = 65489 ;
  val XK_L10  = 65489 ;
  val XK_F21  = 65490 ;
  val XK_R1   = 65490 ;
  val XK_F22  = 65491 ;
  val XK_R2   = 65491 ;
  val XK_F23  = 65492 ;
  val XK_R3   = 65492 ;
  val XK_F24  = 65493 ;
  val XK_R4   = 65493 ;
  val XK_F25  = 65494 ;
  val XK_R5   = 65494 ;
  val XK_F26  = 65495 ;
  val XK_R6   = 65495 ;
  val XK_F27  = 65496 ;
  val XK_R7   = 65496 ;
  val XK_F28  = 65497 ;
  val XK_R8   = 65497 ;
  val XK_F29  = 65498 ;
  val XK_R9   = 65498 ;
  val XK_F30  = 65499 ;
  val XK_R10  = 65499 ;
  val XK_F31  = 65500 ;
  val XK_R11  = 65500 ;
  val XK_F32  = 65501 ;
  val XK_R12  = 65501 ;
  val XK_R13  = 65502 ;
  val XK_F33  = 65502 ;
  val XK_F34  = 65503 ;
  val XK_R14  = 65503 ;
  val XK_F35  = 65504 ;
  val XK_R15  = 65504 ;

(* Modifiers *)

  val XK_Shift_L     = 65505 ;
  val XK_Shift_R     = 65506 ;
  val XK_Control_L   = 65507 ;
  val XK_Control_R   = 65508 ;
  val XK_Caps_Lock   = 65509 ;
  val XK_Shift_Lock  = 65510 ;
  val XK_Meta_L      = 65511 ;
  val XK_Meta_R      = 65512 ;
  val XK_Alt_L       = 65513 ;
  val XK_Alt_R       = 65514 ;
  val XK_Super_L     = 65515 ;
  val XK_Super_R     = 65516 ;
  val XK_Hyper_L     = 65517 ;
  val XK_Hyper_R     = 65518 ;

(* Latin 1 *)

  val XK_space           = 32 ;
  val XK_exclam          = 33 ;
  val XK_quotedbl        = 34 ;
  val XK_numbersign      = 35 ;
  val XK_dollar          = 36 ;
  val XK_percent         = 37 ;
  val XK_ampersand       = 38 ;
  val XK_apostrophe      = 39 ;
  val XK_quoteright      = 39 ;
  val XK_parenleft       = 40 ;
  val XK_parenright      = 41 ;
  val XK_asterisk        = 42 ;
  val XK_plus            = 43 ;
  val XK_comma           = 44 ;
  val XK_minus           = 45 ;
  val XK_period          = 46 ;
  val XK_slash           = 47 ;
  val XK_0               = 48 ;
  val XK_1               = 49 ;
  val XK_2               = 50 ;
  val XK_3               = 51 ;
  val XK_4               = 52 ;
  val XK_5               = 53 ;
  val XK_6               = 54 ;
  val XK_7               = 55 ;
  val XK_8               = 56 ;
  val XK_9               = 57 ;
  val XK_colon           = 58 ;
  val XK_semicolon       = 59 ;
  val XK_less            = 60 ;
  val XK_equal           = 61 ;
  val XK_greater         = 62 ;
  val XK_question        = 63 ;
  val XK_at              = 64 ;
  val XK_A               = 65 ;
  val XK_B               = 66 ;
  val XK_C               = 67 ;
  val XK_D               = 68 ;
  val XK_E               = 69 ;
  val XK_F               = 70 ;
  val XK_G               = 71 ;
  val XK_H               = 72 ;
  val XK_I               = 73 ;
  val XK_J               = 74 ;
  val XK_K               = 75 ;
  val XK_L               = 76 ;
  val XK_M               = 77 ;
  val XK_N               = 78 ;
  val XK_O               = 79 ;
  val XK_P               = 80 ;
  val XK_Q               = 81 ;
  val XK_R               = 82 ;
  val XK_S               = 83 ;
  val XK_T               = 84 ;
  val XK_U               = 85 ;
  val XK_V               = 86 ;
  val XK_W               = 87 ;
  val XK_X               = 88 ;
  val XK_Y               = 89 ;
  val XK_Z               = 90 ;
  val XK_bracketleft     = 91 ;
  val XK_backslash       = 92 ;
  val XK_bracketright    = 93 ;
  val XK_asciicircum     = 94 ;
  val XK_underscore      = 95 ;
  val XK_grave           = 96 ;
  val XK_quoteleft       = 96 ;
  val XK_a               = 97 ;
  val XK_b               = 98 ;
  val XK_c               = 99 ;
  val XK_d               = 100 ;
  val XK_e               = 101 ;
  val XK_f               = 102 ;
  val XK_g               = 103 ;
  val XK_h               = 104 ;
  val XK_i               = 105 ;
  val XK_j               = 106 ;
  val XK_k               = 107 ;
  val XK_l               = 108 ;
  val XK_m               = 109 ;
  val XK_n               = 110 ;
  val XK_o               = 111 ;
  val XK_p               = 112 ;
  val XK_q               = 113 ;
  val XK_r               = 114 ;
  val XK_s               = 115 ;
  val XK_t               = 116 ;
  val XK_u               = 117 ;
  val XK_v               = 118 ;
  val XK_w               = 119 ;
  val XK_x               = 120 ;
  val XK_y               = 121 ;
  val XK_z               = 122 ;
  val XK_braceleft       = 123 ;
  val XK_bar             = 124 ;
  val XK_braceright      = 125 ;
  val XK_asciitilde      = 126 ;
  val XK_nobreakspace    = 160 ;
  val XK_exclamdown      = 161 ;
  val XK_cent            = 162 ;
  val XK_sterling        = 163 ;
  val XK_currency        = 164 ;
  val XK_yen             = 165 ;
  val XK_brokenbar       = 166 ;
  val XK_section         = 167 ;
  val XK_diaeresis       = 168 ;
  val XK_copyright       = 169 ;
  val XK_ordfeminine     = 170 ;
  val XK_guillemotleft   = 171 ;
  val XK_notsign         = 172 ;
  val XK_hyphen          = 173 ;
  val XK_registered      = 174 ;
  val XK_macron          = 175 ;
  val XK_degree          = 176 ;
  val XK_plusminus       = 177 ;
  val XK_twosuperior     = 178 ;
  val XK_threesuperior   = 179 ;
  val XK_acute           = 180 ;
  val XK_mu              = 181 ;
  val XK_paragraph       = 182 ;
  val XK_periodcentered  = 183 ;
  val XK_cedilla         = 184 ;
  val XK_onesuperior     = 185 ;
  val XK_masculine       = 186 ;
  val XK_guillemotright  = 187 ;
  val XK_onequarter      = 188 ;
  val XK_onehalf         = 189 ;
  val XK_threequarters   = 190 ;
  val XK_questiondown    = 191 ;
  val XK_Agrave          = 192 ;
  val XK_Aacute          = 193 ;
  val XK_Acircumflex     = 194 ;
  val XK_Atilde          = 195 ;
  val XK_Adiaeresis      = 196 ;
  val XK_Aring           = 197 ;
  val XK_AE              = 198 ;
  val XK_Ccedilla        = 199 ;
  val XK_Egrave          = 200 ;
  val XK_Eacute          = 201 ;
  val XK_Ecircumflex     = 202 ;
  val XK_Ediaeresis      = 203 ;
  val XK_Igrave          = 204 ;
  val XK_Iacute          = 205 ;
  val XK_Icircumflex     = 206 ;
  val XK_Idiaeresis      = 207 ;
  val XK_ETH             = 208 ;
  val XK_Eth             = 208 ;
  val XK_Ntilde          = 209 ;
  val XK_Ograve          = 210 ;
  val XK_Oacute          = 211 ;
  val XK_Ocircumflex     = 212 ;
  val XK_Otilde          = 213 ;
  val XK_Odiaeresis      = 214 ;
  val XK_multiply        = 215 ;
  val XK_Ooblique        = 216 ;
  val XK_Ugrave          = 217 ;
  val XK_Uacute          = 218 ;
  val XK_Ucircumflex     = 219 ;
  val XK_Udiaeresis      = 220 ;
  val XK_Yacute          = 221 ;
  val XK_THORN           = 222 ;
  val XK_Thorn           = 222 ;
  val XK_ssharp          = 223 ;
  val XK_agrave          = 224 ;
  val XK_aacute          = 225 ;
  val XK_acircumflex     = 226 ;
  val XK_atilde          = 227 ;
  val XK_adiaeresis      = 228 ;
  val XK_aring           = 229 ;
  val XK_ae              = 230 ;
  val XK_ccedilla        = 231 ;
  val XK_egrave          = 232 ;
  val XK_eacute          = 233 ;
  val XK_ecircumflex     = 234 ;
  val XK_ediaeresis      = 235 ;
  val XK_igrave          = 236 ;
  val XK_iacute          = 237 ;
  val XK_icircumflex     = 238 ;
  val XK_idiaeresis      = 239 ;
  val XK_eth             = 240 ;
  val XK_ntilde          = 241 ;
  val XK_ograve          = 242 ;
  val XK_oacute          = 243 ;
  val XK_ocircumflex     = 244 ;
  val XK_otilde          = 245 ;
  val XK_odiaeresis      = 246 ;
  val XK_division        = 247 ;
  val XK_oslash          = 248 ;
  val XK_ugrave          = 249 ;
  val XK_uacute          = 250 ;
  val XK_ucircumflex     = 251 ;
  val XK_udiaeresis      = 252 ;
  val XK_yacute          = 253 ;
  val XK_thorn           = 254 ;
  val XK_ydiaeresis      = 255 ;

(* Latin 2 *)

  val XK_Aogonek       = 417 ;
  val XK_breve         = 418 ;
  val XK_Lstroke       = 419 ;
  val XK_Lcaron        = 421 ;
  val XK_Sacute        = 422 ;
  val XK_Scaron        = 425 ;
  val XK_Scedilla      = 426 ;
  val XK_Tcaron        = 427 ;
  val XK_Zacute        = 428 ;
  val XK_Zcaron        = 430 ;
  val XK_Zabovedot     = 431 ;
  val XK_aogonek       = 433 ;
  val XK_ogonek        = 434 ;
  val XK_lstroke       = 435 ;
  val XK_lcaron        = 437 ;
  val XK_sacute        = 438 ;
  val XK_caron         = 439 ;
  val XK_scaron        = 441 ;
  val XK_scedilla      = 442 ;
  val XK_tcaron        = 443 ;
  val XK_zacute        = 444 ;
  val XK_doubleacute   = 445 ;
  val XK_zcaron        = 446 ;
  val XK_zabovedot     = 447 ;
  val XK_Racute        = 448 ;
  val XK_Abreve        = 451 ;
  val XK_Lacute        = 453 ;
  val XK_Cacute        = 454 ;
  val XK_Ccaron        = 456 ;
  val XK_Eogonek       = 458 ;
  val XK_Ecaron        = 460 ;
  val XK_Dcaron        = 463 ;
  val XK_Dstroke       = 464 ;
  val XK_Nacute        = 465 ;
  val XK_Ncaron        = 466 ;
  val XK_Odoubleacute  = 469 ;
  val XK_Rcaron        = 472 ;
  val XK_Uring         = 473 ;
  val XK_Udoubleacute  = 475 ;
  val XK_Tcedilla      = 478 ;
  val XK_racute        = 480 ;
  val XK_abreve        = 483 ;
  val XK_lacute        = 485 ;
  val XK_cacute        = 486 ;
  val XK_ccaron        = 488 ;
  val XK_eogonek       = 490 ;
  val XK_ecaron        = 492 ;
  val XK_dcaron        = 495 ;
  val XK_dstroke       = 496 ;
  val XK_nacute        = 497 ;
  val XK_ncaron        = 498 ;
  val XK_odoubleacute  = 501 ;
  val XK_udoubleacute  = 507 ;
  val XK_rcaron        = 504 ;
  val XK_uring         = 505 ;
  val XK_tcedilla      = 510 ;
  val XK_abovedot      = 511 ;

(* Latin 3 *)

  val XK_Hstroke      = 673 ;
  val XK_Hcircumflex  = 678 ;
  val XK_Iabovedot    = 681 ;
  val XK_Gbreve       = 683 ;
  val XK_Jcircumflex  = 684 ;
  val XK_hstroke      = 689 ;
  val XK_hcircumflex  = 694 ;
  val XK_idotless     = 697 ;
  val XK_gbreve       = 699 ;
  val XK_jcircumflex  = 700 ;
  val XK_Cabovedot    = 709 ;
  val XK_Ccircumflex  = 710 ;
  val XK_Gabovedot    = 725 ;
  val XK_Gcircumflex  = 728 ;
  val XK_Ubreve       = 733 ;
  val XK_Scircumflex  = 734 ;
  val XK_cabovedot    = 741 ;
  val XK_ccircumflex  = 742 ;
  val XK_gabovedot    = 757 ;
  val XK_gcircumflex  = 760 ;
  val XK_ubreve       = 765 ;
  val XK_scircumflex  = 766 ;

(* Latin 4 *)

  val XK_kra        = 930 ;
  val XK_kappa      = 930 ;
  val XK_Rcedilla   = 931 ;
  val XK_Itilde     = 933 ;
  val XK_Lcedilla   = 934 ;
  val XK_Emacron    = 938 ;
  val XK_Gcedilla   = 939 ;
  val XK_Tslash     = 940 ;
  val XK_rcedilla   = 947 ;
  val XK_itilde     = 949 ;
  val XK_lcedilla   = 950 ;
  val XK_emacron    = 954 ;
  val XK_gcedilla   = 955 ;
  val XK_tslash     = 956 ;
  val XK_ENG        = 957 ;
  val XK_eng        = 959 ;
  val XK_Amacron    = 960 ;
  val XK_Iogonek    = 967 ;
  val XK_Eabovedot  = 972 ;
  val XK_Imacron    = 975 ;
  val XK_Ncedilla   = 977 ;
  val XK_Omacron    = 978 ;
  val XK_Kcedilla   = 979 ;
  val XK_Uogonek    = 985 ;
  val XK_Utilde     = 989 ;
  val XK_Umacron    = 990 ;
  val XK_amacron    = 992 ;
  val XK_iogonek    = 999 ;
  val XK_eabovedot  = 1004 ;
  val XK_imacron    = 1007 ;
  val XK_ncedilla   = 1009 ;
  val XK_omacron    = 1010 ;
  val XK_kcedilla   = 1011 ;
  val XK_uogonek    = 1017 ;
  val XK_utilde     = 1021 ;
  val XK_umacron    = 1022 ;

(* Katakana *)

  val XK_overline             = 1150 ;
  val XK_kana_fullstop        = 1185 ;
  val XK_kana_openingbracket  = 1186 ;
  val XK_kana_closingbracket  = 1187 ;
  val XK_kana_comma           = 1188 ;
  val XK_kana_conjunctive     = 1189 ;
  val XK_kana_middledot       = 1189 ;
  val XK_kana_WO              = 1190 ;
  val XK_kana_a               = 1191 ;
  val XK_kana_i               = 1192 ;
  val XK_kana_u               = 1193 ;
  val XK_kana_e               = 1194 ;
  val XK_kana_o               = 1195 ;
  val XK_kana_ya              = 1196 ;
  val XK_kana_yu              = 1197 ;
  val XK_kana_yo              = 1198 ;
  val XK_kana_tsu             = 1199 ;
  val XK_kana_tu              = 1199 ;
  val XK_prolongedsound       = 1200 ;
  val XK_kana_A               = 1201 ;
  val XK_kana_I               = 1202 ;
  val XK_kana_U               = 1203 ;
  val XK_kana_E               = 1204 ;
  val XK_kana_O               = 1205 ;
  val XK_kana_KA              = 1206 ;
  val XK_kana_KI              = 1207 ;
  val XK_kana_KU              = 1208 ;
  val XK_kana_KE              = 1209 ;
  val XK_kana_KO              = 1210 ;
  val XK_kana_SA              = 1211 ;
  val XK_kana_SHI             = 1212 ;
  val XK_kana_SU              = 1213 ;
  val XK_kana_SE              = 1214 ;
  val XK_kana_SO              = 1215 ;
  val XK_kana_TA              = 1216 ;
  val XK_kana_CHI             = 1217 ;
  val XK_kana_TI              = 1217 ;
  val XK_kana_TSU             = 1218 ;
  val XK_kana_TU              = 1218 ;
  val XK_kana_TE              = 1219 ;
  val XK_kana_TO              = 1220 ;
  val XK_kana_NA              = 1221 ;
  val XK_kana_NI              = 1222 ;
  val XK_kana_NU              = 1223 ;
  val XK_kana_NE              = 1224 ;
  val XK_kana_NO              = 1225 ;
  val XK_kana_HA              = 1226 ;
  val XK_kana_HI              = 1227 ;
  val XK_kana_FU              = 1228 ;
  val XK_kana_HU              = 1228 ;
  val XK_kana_HE              = 1229 ;
  val XK_kana_HO              = 1230 ;
  val XK_kana_MA              = 1231 ;
  val XK_kana_MI              = 1232 ;
  val XK_kana_MU              = 1233 ;
  val XK_kana_ME              = 1234 ;
  val XK_kana_MO              = 1235 ;
  val XK_kana_YA              = 1236 ;
  val XK_kana_YU              = 1237 ;
  val XK_kana_YO              = 1238 ;
  val XK_kana_RA              = 1239 ;
  val XK_kana_RI              = 1240 ;
  val XK_kana_RU              = 1241 ;
  val XK_kana_RE              = 1242 ;
  val XK_kana_RO              = 1243 ;
  val XK_kana_WA              = 1244 ;
  val XK_kana_N               = 1245 ;
  val XK_voicedsound          = 1246 ;
  val XK_semivoicedsound      = 1247 ;
  val XK_kana_switch          = 65406 ;

(* Arabic *)

  val XK_Arabic_comma           = 1452 ;
  val XK_Arabic_semicolon       = 1467 ;
  val XK_Arabic_question_mark   = 1471 ;
  val XK_Arabic_hamza           = 1473 ;
  val XK_Arabic_maddaonalef     = 1474 ;
  val XK_Arabic_hamzaonalef     = 1475 ;
  val XK_Arabic_hamzaonwaw      = 1476 ;
  val XK_Arabic_hamzaunderalef  = 1477 ;
  val XK_Arabic_hamzaonyeh      = 1478 ;
  val XK_Arabic_alef            = 1479 ;
  val XK_Arabic_beh             = 1480 ;
  val XK_Arabic_tehmarbuta      = 1481 ;
  val XK_Arabic_teh             = 1482 ;
  val XK_Arabic_theh            = 1483 ;
  val XK_Arabic_jeem            = 1484 ;
  val XK_Arabic_hah             = 1485 ;
  val XK_Arabic_khah            = 1486 ;
  val XK_Arabic_dal             = 1487 ;
  val XK_Arabic_thal            = 1488 ;
  val XK_Arabic_ra              = 1489 ;
  val XK_Arabic_zain            = 1490 ;
  val XK_Arabic_seen            = 1491 ;
  val XK_Arabic_sheen           = 1492 ;
  val XK_Arabic_sad             = 1493 ;
  val XK_Arabic_dad             = 1494 ;
  val XK_Arabic_tah             = 1495 ;
  val XK_Arabic_zah             = 1496 ;
  val XK_Arabic_ain             = 1497 ;
  val XK_Arabic_ghain           = 1498 ;
  val XK_Arabic_tatweel         = 1504 ;
  val XK_Arabic_feh             = 1505 ;
  val XK_Arabic_qaf             = 1506 ;
  val XK_Arabic_kaf             = 1507 ;
  val XK_Arabic_lam             = 1508 ;
  val XK_Arabic_meem            = 1509 ;
  val XK_Arabic_noon            = 1510 ;
  val XK_Arabic_ha              = 1511 ;
  val XK_Arabic_heh             = 1511 ;
  val XK_Arabic_waw             = 1512 ;
  val XK_Arabic_alefmaksura     = 1513 ;
  val XK_Arabic_yeh             = 1514 ;
  val XK_Arabic_fathatan        = 1515 ;
  val XK_Arabic_dammatan        = 1516 ;
  val XK_Arabic_kasratan        = 1517 ;
  val XK_Arabic_fatha           = 1518 ;
  val XK_Arabic_damma           = 1519 ;
  val XK_Arabic_kasra           = 1520 ;
  val XK_Arabic_shadda          = 1521 ;
  val XK_Arabic_sukun           = 1522 ;
  val XK_Arabic_switch          = 65406 ;

(* Cyrillic *)

  val XK_Serbian_dje          = 1697 ;
  val XK_Macedonia_gje        = 1698 ;
  val XK_Cyrillic_io          = 1699 ;
  val XK_Ukrainian_ie         = 1700 ;
  val XK_Ukranian_je          = 1700 ;
  val XK_Macedonia_dse        = 1701 ;
  val XK_Ukrainian_i          = 1702 ;
  val XK_Ukranian_i           = 1702 ;
  val XK_Ukrainian_yi         = 1703 ;
  val XK_Ukranian_yi          = 1703 ;
  val XK_Cyrillic_je          = 1704 ;
  val XK_Serbian_je           = 1704 ;
  val XK_Cyrillic_lje         = 1705 ;
  val XK_Serbian_lje          = 1705 ;
  val XK_Cyrillic_nje         = 1706 ;
  val XK_Serbian_nje          = 1706 ;
  val XK_Serbian_tshe         = 1707 ;
  val XK_Macedonia_kje        = 1708 ;
  val XK_Byelorussian_shortu  = 1710 ;
  val XK_Cyrillic_dzhe        = 1711 ;
  val XK_Serbian_dze          = 1711 ;
  val XK_numerosign           = 1712 ;
  val XK_Serbian_DJE          = 1713 ;
  val XK_Macedonia_GJE        = 1714 ;
  val XK_Cyrillic_IO          = 1715 ;
  val XK_Ukrainian_IE         = 1716 ;
  val XK_Ukranian_JE          = 1716 ;
  val XK_Macedonia_DSE        = 1717 ;
  val XK_Ukrainian_I          = 1718 ;
  val XK_Ukranian_I           = 1718 ;
  val XK_Ukrainian_YI         = 1719 ;
  val XK_Ukranian_YI          = 1719 ;
  val XK_Cyrillic_JE          = 1720 ;
  val XK_Serbian_JE           = 1720 ;
  val XK_Cyrillic_LJE         = 1721 ;
  val XK_Serbian_LJE          = 1721 ;
  val XK_Cyrillic_NJE         = 1722 ;
  val XK_Serbian_NJE          = 1722 ;
  val XK_Serbian_TSHE         = 1723 ;
  val XK_Macedonia_KJE        = 1724 ;
  val XK_Byelorussian_SHORTU  = 1726 ;
  val XK_Cyrillic_DZHE        = 1727 ;
  val XK_Serbian_DZE          = 1727 ;
  val XK_Cyrillic_yu          = 1728 ;
  val XK_Cyrillic_a           = 1729 ;
  val XK_Cyrillic_be          = 1730 ;
  val XK_Cyrillic_tse         = 1731 ;
  val XK_Cyrillic_de          = 1732 ;
  val XK_Cyrillic_ie          = 1733 ;
  val XK_Cyrillic_ef          = 1734 ;
  val XK_Cyrillic_ghe         = 1735 ;
  val XK_Cyrillic_ha          = 1736 ;
  val XK_Cyrillic_i           = 1737 ;
  val XK_Cyrillic_shorti      = 1738 ;
  val XK_Cyrillic_ka          = 1739 ;
  val XK_Cyrillic_el          = 1740 ;
  val XK_Cyrillic_em          = 1741 ;
  val XK_Cyrillic_en          = 1742 ;
  val XK_Cyrillic_o           = 1743 ;
  val XK_Cyrillic_pe          = 1744 ;
  val XK_Cyrillic_ya          = 1745 ;
  val XK_Cyrillic_er          = 1746 ;
  val XK_Cyrillic_es          = 1747 ;
  val XK_Cyrillic_te          = 1748 ;
  val XK_Cyrillic_u           = 1749 ;
  val XK_Cyrillic_zhe         = 1750 ;
  val XK_Cyrillic_ve          = 1751 ;
  val XK_Cyrillic_softsign    = 1752 ;
  val XK_Cyrillic_yeru        = 1753 ;
  val XK_Cyrillic_ze          = 1754 ;
  val XK_Cyrillic_sha         = 1755 ;
  val XK_Cyrillic_e           = 1756 ;
  val XK_Cyrillic_shcha       = 1757 ;
  val XK_Cyrillic_che         = 1758 ;
  val XK_Cyrillic_hardsign    = 1759 ;
  val XK_Cyrillic_YU          = 1760 ;
  val XK_Cyrillic_A           = 1761 ;
  val XK_Cyrillic_BE          = 1762 ;
  val XK_Cyrillic_TSE         = 1763 ;
  val XK_Cyrillic_DE          = 1764 ;
  val XK_Cyrillic_IE          = 1765 ;
  val XK_Cyrillic_EF          = 1766 ;
  val XK_Cyrillic_GHE         = 1767 ;
  val XK_Cyrillic_HA          = 1768 ;
  val XK_Cyrillic_I           = 1769 ;
  val XK_Cyrillic_SHORTI      = 1770 ;
  val XK_Cyrillic_KA          = 1771 ;
  val XK_Cyrillic_EL          = 1772 ;
  val XK_Cyrillic_EM          = 1773 ;
  val XK_Cyrillic_EN          = 1774 ;
  val XK_Cyrillic_O           = 1775 ;
  val XK_Cyrillic_PE          = 1776 ;
  val XK_Cyrillic_YA          = 1777 ;
  val XK_Cyrillic_ER          = 1778 ;
  val XK_Cyrillic_ES          = 1779 ;
  val XK_Cyrillic_TE          = 1780 ;
  val XK_Cyrillic_U           = 1781 ;
  val XK_Cyrillic_ZHE         = 1782 ;
  val XK_Cyrillic_VE          = 1783 ;
  val XK_Cyrillic_SOFTSIGN    = 1784 ;
  val XK_Cyrillic_YERU        = 1785 ;
  val XK_Cyrillic_ZE          = 1786 ;
  val XK_Cyrillic_SHA         = 1787 ;
  val XK_Cyrillic_E           = 1788 ;
  val XK_Cyrillic_SHCHA       = 1789 ;
  val XK_Cyrillic_CHE         = 1790 ;
  val XK_Cyrillic_HARDSIGN    = 1791 ;

(* Greek *)

  val XK_Greek_ALPHAaccent            = 1953 ;
  val XK_Greek_EPSILONaccent          = 1954 ;
  val XK_Greek_ETAaccent              = 1955 ;
  val XK_Greek_IOTAaccent             = 1956 ;
  val XK_Greek_IOTAdiaeresis          = 1957 ;
  val XK_Greek_OMICRONaccent          = 1959 ;
  val XK_Greek_UPSILONaccent          = 1960 ;
  val XK_Greek_UPSILONdieresis        = 1961 ;
  val XK_Greek_OMEGAaccent            = 1963 ;
  val XK_Greek_accentdieresis         = 1966 ;
  val XK_Greek_horizbar               = 1967 ;
  val XK_Greek_alphaaccent            = 1969 ;
  val XK_Greek_epsilonaccent          = 1970 ;
  val XK_Greek_etaaccent              = 1971 ;
  val XK_Greek_iotaaccent             = 1972 ;
  val XK_Greek_iotadieresis           = 1973 ;
  val XK_Greek_iotaaccentdieresis     = 1974 ;
  val XK_Greek_omicronaccent          = 1975 ;
  val XK_Greek_upsilonaccent          = 1976 ;
  val XK_Greek_upsilondieresis        = 1977 ;
  val XK_Greek_upsilonaccentdieresis  = 1978 ;
  val XK_Greek_omegaaccent            = 1979 ;
  val XK_Greek_ALPHA                  = 1985 ;
  val XK_Greek_BETA                   = 1986 ;
  val XK_Greek_GAMMA                  = 1987 ;
  val XK_Greek_DELTA                  = 1988 ;
  val XK_Greek_EPSILON                = 1989 ;
  val XK_Greek_ZETA                   = 1990 ;
  val XK_Greek_ETA                    = 1991 ;
  val XK_Greek_THETA                  = 1992 ;
  val XK_Greek_IOTA                   = 1993 ;
  val XK_Greek_KAPPA                  = 1994 ;
  val XK_Greek_LAMDA                  = 1995 ;
  val XK_Greek_LAMBDA                 = 1995 ;
  val XK_Greek_MU                     = 1996 ;
  val XK_Greek_NU                     = 1997 ;
  val XK_Greek_XI                     = 1998 ;
  val XK_Greek_OMICRON                = 1999 ;
  val XK_Greek_PI                     = 2000 ;
  val XK_Greek_RHO                    = 2001 ;
  val XK_Greek_SIGMA                  = 2002 ;
  val XK_Greek_TAU                    = 2004 ;
  val XK_Greek_UPSILON                = 2005 ;
  val XK_Greek_PHI                    = 2006 ;
  val XK_Greek_CHI                    = 2007 ;
  val XK_Greek_PSI                    = 2008 ;
  val XK_Greek_OMEGA                  = 2009 ;
  val XK_Greek_alpha                  = 2017 ;
  val XK_Greek_beta                   = 2018 ;
  val XK_Greek_gamma                  = 2019 ;
  val XK_Greek_delta                  = 2020 ;
  val XK_Greek_epsilon                = 2021 ;
  val XK_Greek_zeta                   = 2022 ;
  val XK_Greek_eta                    = 2023 ;
  val XK_Greek_theta                  = 2024 ;
  val XK_Greek_iota                   = 2025 ;
  val XK_Greek_kappa                  = 2026 ;
  val XK_Greek_lamda                  = 2027 ;
  val XK_Greek_lambda                 = 2027 ;
  val XK_Greek_mu                     = 2028 ;
  val XK_Greek_nu                     = 2029 ;
  val XK_Greek_xi                     = 2030 ;
  val XK_Greek_omicron                = 2031 ;
  val XK_Greek_pi                     = 2032 ;
  val XK_Greek_rho                    = 2033 ;
  val XK_Greek_sigma                  = 2034 ;
  val XK_Greek_finalsmallsigma        = 2035 ;
  val XK_Greek_tau                    = 2036 ;
  val XK_Greek_upsilon                = 2037 ;
  val XK_Greek_phi                    = 2038 ;
  val XK_Greek_chi                    = 2039 ;
  val XK_Greek_psi                    = 2040 ;
  val XK_Greek_omega                  = 2041 ;
  val XK_Greek_switch                 = 65406 ;

(* Technical *)

  val XK_leftradical                = 2209 ;
  val XK_topleftradical             = 2210 ;
  val XK_horizconnector             = 2211 ;
  val XK_topintegral                = 2212 ;
  val XK_botintegral                = 2213 ;
  val XK_vertconnector              = 2214 ;
  val XK_topleftsqbracket           = 2215 ;
  val XK_botleftsqbracket           = 2216 ;
  val XK_toprightsqbracket          = 2217 ;
  val XK_botrightsqbracket          = 2218 ;
  val XK_topleftparens              = 2219 ;
  val XK_botleftparens              = 2220 ;
  val XK_toprightparens             = 2221 ;
  val XK_botrightparens             = 2222 ;
  val XK_leftmiddlecurlybrace       = 2223 ;
  val XK_rightmiddlecurlybrace      = 2224 ;
  val XK_topleftsummation           = 2225 ;
  val XK_botleftsummation           = 2226 ;
  val XK_topvertsummationconnector  = 2227 ;
  val XK_botvertsummationconnector  = 2228 ;
  val XK_toprightsummation          = 2229 ;
  val XK_botrightsummation          = 2230 ;
  val XK_rightmiddlesummation       = 2231 ;
  val XK_lessthanequal              = 2236 ;
  val XK_notequal                   = 2237 ;
  val XK_greaterthanequal           = 2238 ;
  val XK_integral                   = 2239 ;
  val XK_therefore                  = 2240 ;
  val XK_variation                  = 2241 ;
  val XK_infinity                   = 2242 ;
  val XK_nabla                      = 2245 ;
  val XK_approximate                = 2248 ;
  val XK_similarequal               = 2249 ;
  val XK_ifonlyif                   = 2253 ;
  val XK_implies                    = 2254 ;
  val XK_identical                  = 2255 ;
  val XK_radical                    = 2262 ;
  val XK_includedin                 = 2266 ;
  val XK_includes                   = 2267 ;
  val XK_intersection               = 2268 ;
  val XK_union                      = 2269 ;
  val XK_logicaland                 = 2270 ;
  val XK_logicalor                  = 2271 ;
  val XK_partialderivative          = 2287 ;
  val XK_function                   = 2294 ;
  val XK_leftarrow                  = 2299 ;
  val XK_uparrow                    = 2300 ;
  val XK_rightarrow                 = 2301 ;
  val XK_downarrow                  = 2302 ;

(* Special *)

  val XK_blank           = 2527 ;
  val XK_soliddiamond    = 2528 ;
  val XK_checkerboard    = 2529 ;
  val XK_ht              = 2530 ;
  val XK_ff              = 2531 ;
  val XK_cr              = 2532 ;
  val XK_lf              = 2533 ;
  val XK_nl              = 2536 ;
  val XK_vt              = 2537 ;
  val XK_lowrightcorner  = 2538 ;
  val XK_uprightcorner   = 2539 ;
  val XK_upleftcorner    = 2540 ;
  val XK_lowleftcorner   = 2541 ;
  val XK_crossinglines   = 2542 ;
  val XK_horizlinescan1  = 2543 ;
  val XK_horizlinescan3  = 2544 ;
  val XK_horizlinescan5  = 2545 ;
  val XK_horizlinescan7  = 2546 ;
  val XK_horizlinescan9  = 2547 ;
  val XK_leftt           = 2548 ;
  val XK_rightt          = 2549 ;
  val XK_bott            = 2550 ;
  val XK_topt            = 2551 ;
  val XK_vertbar         = 2552 ;

(* Publishing *)

  val XK_emspace               = 2721 ;
  val XK_enspace               = 2722 ;
  val XK_em3space              = 2723 ;
  val XK_em4space              = 2724 ;
  val XK_digitspace            = 2725 ;
  val XK_punctspace            = 2726 ;
  val XK_thinspace             = 2727 ;
  val XK_hairspace             = 2728 ;
  val XK_emdash                = 2729 ;
  val XK_endash                = 2730 ;
  val XK_signifblank           = 2732 ;
  val XK_ellipsis              = 2734 ;
  val XK_doubbaselinedot       = 2735 ;
  val XK_onethird              = 2736 ;
  val XK_twothirds             = 2737 ;
  val XK_onefifth              = 2738 ;
  val XK_twofifths             = 2739 ;
  val XK_threefifths           = 2740 ;
  val XK_fourfifths            = 2741 ;
  val XK_onesixth              = 2742 ;
  val XK_fivesixths            = 2743 ;
  val XK_careof                = 2744 ;
  val XK_figdash               = 2747 ;
  val XK_leftanglebracket      = 2748 ;
  val XK_decimalpoint          = 2749 ;
  val XK_rightanglebracket     = 2750 ;
  val XK_marker                = 2751 ;
  val XK_oneeighth             = 2755 ;
  val XK_threeeighths          = 2756 ;
  val XK_fiveeighths           = 2757 ;
  val XK_seveneighths          = 2758 ;
  val XK_trademark             = 2761 ;
  val XK_signaturemark         = 2762 ;
  val XK_trademarkincircle     = 2763 ;
  val XK_leftopentriangle      = 2764 ;
  val XK_rightopentriangle     = 2765 ;
  val XK_emopencircle          = 2766 ;
  val XK_emopenrectangle       = 2767 ;
  val XK_leftsinglequotemark   = 2768 ;
  val XK_rightsinglequotemark  = 2769 ;
  val XK_leftdoublequotemark   = 2770 ;
  val XK_rightdoublequotemark  = 2771 ;
  val XK_prescription          = 2772 ;
  val XK_minutes               = 2774 ;
  val XK_seconds               = 2775 ;
  val XK_latincross            = 2777 ;
  val XK_hexagram              = 2778 ;
  val XK_filledrectbullet      = 2779 ;
  val XK_filledlefttribullet   = 2780 ;
  val XK_filledrighttribullet  = 2781 ;
  val XK_emfilledcircle        = 2782 ;
  val XK_emfilledrect          = 2783 ;
  val XK_enopencircbullet      = 2784 ;
  val XK_enopensquarebullet    = 2785 ;
  val XK_openrectbullet        = 2786 ;
  val XK_opentribulletup       = 2787 ;
  val XK_opentribulletdown     = 2788 ;
  val XK_openstar              = 2789 ;
  val XK_enfilledcircbullet    = 2790 ;
  val XK_enfilledsqbullet      = 2791 ;
  val XK_filledtribulletup     = 2792 ;
  val XK_filledtribulletdown   = 2793 ;
  val XK_leftpointer           = 2794 ;
  val XK_rightpointer          = 2795 ;
  val XK_club                  = 2796 ;
  val XK_diamond               = 2797 ;
  val XK_heart                 = 2798 ;
  val XK_maltesecross          = 2800 ;
  val XK_dagger                = 2801 ;
  val XK_doubledagger          = 2802 ;
  val XK_checkmark             = 2803 ;
  val XK_ballotcross           = 2804 ;
  val XK_musicalsharp          = 2805 ;
  val XK_musicalflat           = 2806 ;
  val XK_malesymbol            = 2807 ;
  val XK_femalesymbol          = 2808 ;
  val XK_telephone             = 2809 ;
  val XK_telephonerecorder     = 2810 ;
  val XK_phonographcopyright   = 2811 ;
  val XK_caret                 = 2812 ;
  val XK_singlelowquotemark    = 2813 ;
  val XK_doublelowquotemark    = 2814 ;
  val XK_cursor                = 2815 ;

(* APL *)

  val XK_leftcaret   = 2979 ;
  val XK_rightcaret  = 2982 ;
  val XK_downcaret   = 2984 ;
  val XK_upcaret     = 2985 ;
  val XK_overbar     = 3008 ;
  val XK_downtack    = 3010 ;
  val XK_upshoe      = 3011 ;
  val XK_downstile   = 3012 ;
  val XK_underbar    = 3014 ;
  val XK_jot         = 3018 ;
  val XK_quad        = 3020 ;
  val XK_uptack      = 3022 ;
  val XK_circle      = 3023 ;
  val XK_upstile     = 3027 ;
  val XK_downshoe    = 3030 ;
  val XK_rightshoe   = 3032 ;
  val XK_leftshoe    = 3034 ;
  val XK_lefttack    = 3036 ;
  val XK_righttack   = 3068 ;

(* Hebrew *)

  val XK_hebrew_doublelowline  = 3295 ;
  val XK_hebrew_aleph          = 3296 ;
  val XK_hebrew_bet            = 3297 ;
  val XK_hebrew_beth           = 3297 ;
  val XK_hebrew_gimel          = 3298 ;
  val XK_hebrew_gimmel         = 3298 ;
  val XK_hebrew_dalet          = 3299 ;
  val XK_hebrew_daleth         = 3299 ;
  val XK_hebrew_he             = 3300 ;
  val XK_hebrew_waw            = 3301 ;
  val XK_hebrew_zain           = 3302 ;
  val XK_hebrew_zayin          = 3302 ;
  val XK_hebrew_chet           = 3303 ;
  val XK_hebrew_het            = 3303 ;
  val XK_hebrew_tet            = 3304 ;
  val XK_hebrew_teth           = 3304 ;
  val XK_hebrew_yod            = 3305 ;
  val XK_hebrew_finalkaph      = 3306 ;
  val XK_hebrew_kaph           = 3307 ;
  val XK_hebrew_lamed          = 3308 ;
  val XK_hebrew_finalmem       = 3309 ;
  val XK_hebrew_mem            = 3310 ;
  val XK_hebrew_finalnun       = 3311 ;
  val XK_hebrew_nun            = 3312 ;
  val XK_hebrew_samech         = 3313 ;
  val XK_hebrew_samekh         = 3313 ;
  val XK_hebrew_ayin           = 3314 ;
  val XK_hebrew_finalpe        = 3315 ;
  val XK_hebrew_pe             = 3316 ;
  val XK_hebrew_finalzade      = 3317 ;
  val XK_hebrew_finalzadi      = 3317 ;
  val XK_hebrew_zade           = 3318 ;
  val XK_hebrew_zadi           = 3318 ;
  val XK_hebrew_qoph           = 3319 ;
  val XK_hebrew_kuf            = 3319 ;
  val XK_hebrew_resh           = 3320 ;
  val XK_hebrew_shin           = 3321 ;
  val XK_hebrew_taw            = 3322 ;
  val XK_hebrew_taf            = 3322 ;
  val XK_Hebrew_switch         = 65406 ;

end (* XKeySyms *) ;
