# FISH completions for OneDrive Linux Client
# License: GPLv3+ (as with the rest of the OneDrive Linux client project)

complete -c onedrive -f

complete -c onedrive -l auth-files -d "Authenticate using input/output files"
complete -c onedrive -l auth-response -d "Authenticate using the response URL"
complete -c onedrive -l check-for-nomount -d "Skip sync if .nosync found in sync dir root"
complete -c onedrive -l check-for-nosync -d "Skip directories containing .nosync"
complete -c onedrive -l classify-as-big-delete -d "Classify as big delete when children exceed number"
complete -c onedrive -l cleanup-local-files -d "Cleanup local files when using --download-only"
complete -c onedrive -l confdir -d "Directory for configuration files"
complete -c onedrive -l create-directory -d "Create directory on OneDrive"
complete -c onedrive -l create-share-link -d "Create a shareable link for a file"
complete -c onedrive -l debug-https -d "Debug HTTPS communication"
complete -c onedrive -l destination-directory -d "Target directory for move/rename operations"
complete -c onedrive -l disable-download-validation -d "Disable validation of downloaded files"
complete -c onedrive -l disable-notifications -d "Disable desktop notifications in monitor mode"
complete -c onedrive -l disable-upload-validation -d "Disable validation of uploaded files"
complete -c onedrive -l display-config -d "Display current config"
complete -c onedrive -l display-quota -d "Display OneDrive quota"
complete -c onedrive -l display-running-config -d "Display config used at startup"
complete -c onedrive -l display-sync-status -d "Show current sync status"
complete -c onedrive -l download-only -d "Only download remote changes"
complete -c onedrive -l dry-run -d "Simulate sync without making changes"
complete -c onedrive -l enable-logging -d "Enable logging to a file"
complete -c onedrive -l force -d "Force delete on big delete detection"
complete -c onedrive -l force-http-11 -d "Force HTTP 1.1 usage"
complete -c onedrive -l force-sync -d "Force sync of specified folder"
complete -c onedrive -l get-O365-drive-id -d "Get Drive ID for O365 SharePoint (deprecated)"
complete -c onedrive -l get-file-link -d "Get shareable link for a file"
complete -c onedrive -l get-sharepoint-drive-id -d "Get Drive ID for SharePoint"
complete -c onedrive -l help -d "Show help message"
complete -c onedrive -l list-shared-items -d "List shared OneDrive items"
complete -c onedrive -l local-first -d "Prefer local changes during sync"
complete -c onedrive -l log-dir -d "Directory for logs"
complete -c onedrive -l logout -d "Logout current session"
complete -c onedrive -l modified-by -d "Show who last modified a file"
complete -c onedrive -l monitor -d "Run in monitor mode"
complete -c onedrive -l monitor-fullscan-frequency -d "Full scan every N runs"
complete -c onedrive -l monitor-interval -d "Sync interval in monitor mode"
complete -c onedrive -l monitor-log-frequency -d "Log status every N seconds in monitor mode"
complete -c onedrive -l no-remote-delete -d "Don't delete remote files in --upload-only"
complete -c onedrive -l print-access-token -d "Show access token"
complete -c onedrive -l reauth -d "Reauthenticate client"
complete -c onedrive -l remove-directory -d "Delete remote directory"
complete -c onedrive -l remove-source-files -d "Remove uploaded local files"
complete -c onedrive -l resync -d "Perform full resync"
complete -c onedrive -l resync-auth -d "Confirm resync action"
complete -c onedrive -l share-password -d "Password-protect shared link"
complete -c onedrive -l single-directory -d "Sync a single local directory"
complete -c onedrive -l skip-dir -d "Skip matching directories"
complete -c onedrive -l skip-dir-strict-match -d "Strict matching for skipped dirs"
complete -c onedrive -l skip-dot-files -d "Skip hidden files and folders"
complete -c onedrive -l skip-file -d "Skip matching files"
complete -c onedrive -l skip-size -d "Skip files above given size"
complete -c onedrive -l skip-symlinks -d "Ignore symlinks"
complete -c onedrive -l source-directory -d "Source path for move/rename"
complete -c onedrive -l space-reservation -d "Reserve disk space (MB)"
complete -c onedrive -l sync -d "Start sync operation"
complete -c onedrive -l sync-root-files -d "Sync root files with sync_list"
complete -c onedrive -l sync-shared-files -d "Sync shared business files"
complete -c onedrive -l syncdir -d "Local sync directory"
complete -c onedrive -l synchronize -d "Deprecated alias for --sync"
complete -c onedrive -l upload-only -d "Only upload local changes"
complete -c onedrive -l verbose -d "Increase verbosity"
complete -c onedrive -l version -d "Show version"
complete -c onedrive -l with-editing-perms -d "Create read-write shared link"

