/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import javax.servlet.ServletConfig;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class JabberService
extends TurbineBaseService
implements Runnable {
    private static final int PORT = 5222;
    private static final int SLEEPTIME = 3000;
    private static final int NUMBUFFERS = 16;
    private static final int BUFFERSIZE = 4192;
    private static final int EndOfStream = -1;
    private static boolean ServerIsRunning;
    private Thread m_thread = null;
    private boolean m_threadStop = false;
    private Selector selector;
    private ByteBuffer[] inbuffer;
    private ByteBuffer[] outbuffer;
    private ServerSocketChannel server;
    private SelectionKey serverkey;

    private void start() {
        this.m_threadStop = false;
        this.m_thread = new Thread((Runnable)this, this.getClass().getName());
        this.m_thread.start();
    }

    private void stop() {
        if (this.m_thread == null) {
            return;
        }
        this.m_threadStop = true;
        this.m_thread.interrupt();
        this.m_thread = null;
    }

    public void init(ServletConfig config) throws InitializationException {
        super.init(config);
        Log.info("chef", this + ".init(ServletConfig)");
        if (this.m_thread == null) {
            this.start();
        }
    }

    public void init(RunData data) throws InitializationException {
        super.init(data);
        Log.info("chef", this + ".init(RunData)");
        if (this.m_thread == null) {
            this.start();
        }
    }

    public void init() throws InitializationException {
        super.init();
        Log.info("chef", this + ".init()  We're never supposed to call this one");
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        Log.info("chef", this.toString() + ".run() Jabber instance starting");
        this.inbuffer = new ByteBuffer[16];
        this.outbuffer = new ByteBuffer[16];
        i = 0;
        while (i < 16) {
            this.inbuffer[i] = ByteBuffer.allocateDirect(4192);
            this.outbuffer[i] = ByteBuffer.allocateDirect(4192);
            ++i;
        }
        try {
            this.selector = Selector.open();
            System.out.println(this.toString() + "  initializing server-socket-channel");
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            this.server.socket().bind(new InetSocketAddress(5222));
            System.out.println(this.toString() + "  registering server-socket-channel");
            this.serverkey = this.server.register(this.selector, 16);
            if (true) ** GOTO lbl75
        }
        catch (IOException e) {
            Log.warn("chef", this + " -- Unable to create socket", (Throwable)e);
            System.out.println("ERROR: " + this + " -- Unable to create socket -- No Jabber service");
            return;
        }
        do {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                Log.warn("chef", this + ".run()", (Throwable)e);
            }
            try {
                numKeys = this.selector.selectNow();
                System.out.println("Jabber server: Selector found " + numKeys + " keys selected");
                if (numKeys <= 0) continue;
                keys = this.selector.selectedKeys();
                i = keys.iterator();
                while (i.hasNext()) {
                    key = i.next();
                    i.remove();
                    if (this.serverkey == key) {
                        System.out.println("Jabber server: processing a ServerSocketChannel ");
                        if (!key.isAcceptable()) continue;
                        client = ((ServerSocketChannel)key.channel()).accept();
                        client.configureBlocking(false);
                        clientkey = client.register(this.selector, 1);
                        continue;
                    }
                    System.out.println("Jabber server: processing a client's SocketChannel ");
                    if (!key.isReadable()) continue;
                    client = (SocketChannel)key.channel();
                    bytesread = client.read(this.inbuffer);
                    if (bytesread == -1L) {
                        System.out.println("Jabber server: Client disconnected ");
                        key.cancel();
                        client.close();
                        continue;
                    }
                    this.inbuffer[0].flip();
                    System.out.println("Jabber server: Server received message:\n" + this.inbuffer[0].toString());
                    this.inbuffer[0].clear();
                    outstr = "Hello there.  You sent " + bytesread + " bytes.\r\n";
                    this.outbuffer[0].put(outstr.getBytes());
                    this.outbuffer[0].flip();
                    client.write(this.outbuffer);
                    this.outbuffer[0].clear();
                }
            }
            catch (Exception e) {
                Log.warn("chef", this + ".run()", (Throwable)e);
            }
lbl75:
            // 4 sources

        } while (JabberService.ServerIsRunning);
    }

    static {
        PORT = 5222;
        SLEEPTIME = 3000;
        NUMBUFFERS = 16;
        BUFFERSIZE = 4192;
        EndOfStream = -1;
        ServerIsRunning = true;
    }
}

