/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;

public class LisaacWordRule
extends WordRule {
    private IToken localVariableToken;
    private StringBuffer fBuffer = new StringBuffer();

    public LisaacWordRule(IWordDetector detector, IToken defaultToken, IToken localVariableToken) {
        super(detector, defaultToken);
        this.localVariableToken = localVariableToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        IToken result = this.doEvaluate(scanner);
        if (result == this.fDefaultToken) {
            Slot slot;
            Prototype prototype = null;
            try {
                prototype = LisaacModel.getCurrentPrototype();
            }
            catch (CoreException coreException) {}
            if (prototype == null) {
                return result;
            }
            int offset = ((LisaacScanner)scanner).getOffset();
            String word = this.fBuffer.toString();
            try {
                slot = prototype.getSlotFromKeyword(word, prototype.openParser(), offset - word.length());
                if (slot != null) {
                    return result;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            slot = prototype.getSlot(offset);
            if (slot != null) {
                if (slot.hasArgument(word)) {
                    return this.localVariableToken;
                }
                if (slot.hasVariableDefinition(word, offset)) {
                    return this.localVariableToken;
                }
            }
        }
        return result;
    }

    public IToken doEvaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c != -1 && this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
            scanner.unread();
            String buffer = this.fBuffer.toString();
            IToken token = (IToken)this.fWords.get(buffer);
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

