# Notebooks
## Introduction

### Using the notebooks locally

Clone this repository with `git clone` first. Then, locally start the Jupyter notebook
server from the command line in the `doc/notebooks/` directory containing the `*.ipynb` files with:
`jupyter notebook`

This will open a new browser tab or window with a list of the contents of the current
working directory. Clicking on one of the `*.ipynb` files will start the notebook.

See also the official documentation for [The Jupyter Notebook](https://jupyter-notebook.readthedocs.io/en/latest/).

### Introductory notebooks to GRASS GIS and Jupyter

* GRASS GIS in Jupyter Notebook with Python and grass.jupyter: [jupyter_example.ipynb](jupyter_example.ipynb)
* The grass.jupyter Package: [jupyter_tutorial.ipynb](jupyter_tutorial.ipynb)

## Thematic Jupyter notebooks

* Viewshed Analysis: [viewshed_analysis.ipynb](viewshed_analysis.ipynb)
* Spatio-Temporal Analysis with grass.jupyter: [temporal.ipynb](temporal.ipynb)
* Solar Energy Potential Analysis: [solar_potential.ipynb](solar_potential.ipynb)
* GRASS GIS Scripting with Python: [scripting_example.ipynb](scripting_example.ipynb)
* Hydrology with GRASS GIS: [hydrology.ipynb](hydrology.ipynb)

