<p align="center">
  <br>
  <b>创造不息，交付不止</b>
  <br>
  <a href="https://www.yousails.com">
    <img src="https://yousails.com/banners/brand.png" width=350>
  </a>
</p>

# iOS 学习资料整理

这份学习资料是为 iOS 初学者所准备的, 旨在帮助 iOS 初学者们快速找到适合自己的学习资料, 节省他们搜索资料的时间, 使他们更好的规划好自己的 iOS 学习路线, 更快的入门, 更准确的定位的目前所处的位置.

该文档会持续更新, 同时也欢迎更多具有丰富经验的 iOS 开发者将自己的常用的一些工具, 学习资料, 学习心得等分享上来, 我将定期筛选合并, 文档尚有一些不完善之处, 也请不吝指出, 感谢您对 iOS 所做的贡献, 让我们一起把国内的 iOS 做得更好,  谢谢.

> - 本文章由 [@Aufree](http://github.com/aufree) 整理而成, 转载请注明出处。
> - 本人著作的书籍[《Laravel 入门教程》](https://laravel-china.org/laravel-tutorial/5.1)已正式发布，有兴趣的朋友可点击 [此处](https://laravel-china.org/topics/3383) 作进一步了解。

---

**如果您有任何意见或建议也可以通过我的微博 [@李锦发](http://weibo.com/jinfali) 或微信（lijinfa894330982）联系我**    

## 视频教程(英文)

视频  |  简介
---- | ----
[Developing iOS 7 Apps for iPhone and iPad](https://itunes.apple.com/us/course/developing-ios-7-apps-for/id733644550) | 斯坦福开放教程之一, 课程主要讲解了一些 iOS 开发工具和 API 以及 iOS SDK 的使用, 属于 iOS 基础视频
[iPad and iPhone Application Development](https://itunes.apple.com/itunes-u/ipad-iphone-application-development/id473757255) | 该课程的讲师 Paul Hegarty 是斯坦福大学软件工程学教授, 视频内容讲解得深入, 权威, 深受好评
[Advanced iPhone Development - Fall 2010](https://itunes.apple.com/itunes-u/advanced-iphone-development/id407243028) | iOS 开发的进阶课程, 开始涉及到 Core Animation, Core Data, OpenGL 等框架的应用
[iOS Dev Center](https://developer.apple.com/devcenter/ios/index.action) | 苹果官方提供的 iOS 学习视频
[Lynda](http://www.lynda.com/search?q=ios) | Lynda 上面 iOS 和 Objective-C 的学习资料比较多, 从初级到高级的都有, 覆盖面比较广, 无论 iOS 走到哪个层次, 都可以在上面挑到适合自己的课程
[Code School](https://www.codeschool.com/paths/ios) | CodeSchool 上面的 iOS 不多, 不过质量都不错, 一些课程也挺有趣的
[Udemy](https://www.udemy.com/topic/learn-objective-c) | Udemy 帮助初学者规划了视频学习路线, 从新手到高级分的比较详细
[Developing iOS 8 Apps with Swift](https://itunes.apple.com/us/course/developing-ios-8-apps-swift/id961180099) | 斯坦福白胡子老爷爷的 iOS8 和 Swift 课程, 已经翻译完成 [GitHub](https://github.com/x140yu/Developing_iOS_8_Apps_With_Swift)
[Developing iOS 9 Apps with Swift](https://itunes.apple.com/us/course/developing-ios-9-apps-swift/id1104579961) | 斯坦福白胡子老爷爷最新的 iOS9 和 Swift 课程, 现在 [GitHub](https://github.com/X140Yu/Developing-iOS-9-Apps-with-Swift) 正在翻译

## 视频教程(中文)

视频  |  简介
---- | ----
[iOS 7 应用开发](http://v.163.com/special/opencourse/ios7.html) | 斯坦福白胡子老爷爷的系列视频, 所有视频皆完成翻译, 视频较新, 翻译质量也很高
[iPhone 开发教程 2010 年冬](http://v.163.com/special/opencourse/iphonekaifa.html) | 全部视频翻译完毕, 较为深入的讲解 iPhone 开发, 视频适合给有一定 Objective-C 基础的人观看
[使用 Swift 开发 iOS8 App 实战](http://www.imooc.com/learn/173) | 慕课网的视频, 主要讲 Swift 的一些基本使用, 并在讲解的过程中做了几个小 APP, 最后还讲了 Sketch 制作分享按钮
[征战 Objective-C](http://www.imooc.com/learn/218) | 视频还未完结, 讲了一些 C 和 Objective-C 的基本语法, 适合零基础的人观看
[Developing iOS 8 Apps with Swift](https://github.com/x140yu/Developing_iOS_8_Apps_With_Swift) | GitHub 上正在翻译的斯坦福最新的 iOS8 课程, 目前正在翻译, 未完结

## 书籍

书籍名称 | 推荐理由
------- | -------
[Objective-C Programming](http://www.amazon.com/dp/032194206X/ref=cm_sw_r_tw_dp_fWrPub0BGRHJ3) | 内容不多, 却都是精华, 有了一点 C 语言基础可以快速阅读此书, 大概一天时间就可以看完, 看完后对 iOS 开发能够有个基本的印象, 该书的[官方论坛](http://forums.bignerdranch.com)有各个章节习题的解答.
[iOS Programming](http://book.douban.com/subject/24538384) | 这本书在 Quora 上被评为 iOS 入门最佳书籍,  具体评价可见豆瓣下方该书籍的评论
[Cocoa Design Patterns](http://book.douban.com/subject/3688896) | 适合打算深入了解 Cocoa 的人看
[Learn Objective-C](http://cocoadevcentral.com/d/learn_objectivec/) | 短小精练, 适合有编程基础的人在半小时内对 Objective-C 有个一定了解
[Programming with Objective-C](https://developer.apple.com/library/ios/documentation/Cocoa/Conceptual/ProgrammingWithObjectiveC/Introduction/Introduction.html) | 看完 Learn Objective-C 可以接着看这个官方对 Objective-C 更为深入的介绍
[Objective-C 基础教程](http://www.amazon.cn/dp/B00COG40Y0/ref=cm_sw_r_qz_2_dp_l2OPub0N45R0Q) | 该书作者 Scott Knaster 是 Mac 开发界的传奇人物, 目前在 Google 出过多数书籍都广受许多程序员好评, 此书适合从初级跳到中级的 iOS 开发者阅读
[iOS 开发进阶](http://www.amazon.cn/dp/B00R43XG9S/ref=cm_sw_r_qz_pi_T2A_jdp_fCPPub0VBF67T) | 该书作者唐巧是国内 iOS 开发界的名人, 曾参与多个知名软件的开发, 目前该书尚在预售中, 书本内容由浅入深, 将读者一步一步引入到 iOS 中去, 同样适合初级跳到中级的 iOS 开发者阅读
[Programming in Objective-C](http://www.amazon.com/Programming-Objective-C-Edition-Developers-Library/dp/0321967607) | 这本书在亚马逊上面深受欢迎, 有关 Objective-C 的东西讲得非常详细
[iOS 测试指南](http://www.amazon.cn/dp/B00JPVNFKM/ref=cm_sw_r_qz_4_dp_tdPPub14X59PV) | 该书作者是豆瓣的员工, 书中写的多数内容都是作者在平时的工作实践当中提炼出来的测试经验, 重点讲述了各个测试阶段的具体实践方法, 并且通过持续集成串联了各个测试阶段的活动。
[Objective-C 编程之道](http://book.douban.com/subject/6920082) | 解析 iOS 的开山之作, 详细介绍了 MVC 在 Cocoa Touch 上的运作过程, 该书适用于 iOS 中级开发者阅读
[Objective-C 高级编程](http://www.amazon.cn/dp/B00DE60G3S/ref=cm_sw_r_qz_2_dp_hdPPub11MFE6G) | 本书主要介绍 iOS 与 OS X 多线程和内存管理, 深入破析了苹果官方公布的源代码,  告诉你一些苹果公司官方文档中不会出现的知识, 适合中级以上 iOS 开发人员阅读
[Effective Objective C 2.0](http://www.amazon.cn/dp/B00IDSGY06/ref=cm_sw_r_qz_2_dp_A2OPub0CH96YH) | 书里写了编写高质量 iOS 与 OS X 代码的 52 个有效方法, 适合 iOS 开发的进阶使用
[Swift Fundamentals](http://www.amazon.com/dp/0990402053/ref=cm_sw_r_tw_dp_louPub127Q1YP) | 估计将来这本书会成为 Swift 的经典入门书籍, 它的 Stars 数说明了一切
[The Swift Programming Language 中文版](https://numbbbbb.gitbooks.io/-the-swift-programming-language-/content/) | 90 后开发者梁杰组织翻译的 Swift 编程语言中文版
[Motion Design for iOS](https://designthencode.com/motion-sample-1.html) | 一本讲解 iOS 动画的书，介绍了很多的动画开发实例，以及三种开发动画的方式，有[中文翻译版](https://github.com/Cloudox/Motion-Design-for-iOS)

## 博客

博客地址 | 博主信息
------- | -------
[OneV's Den](http://onevcat.com/#blog) | 王巍(喵神), 现居日本, 就职于 LINE, 知名 iOS 开发者, 写的文章大多深入浅出, 内容广泛, 目前在维护的 [Swifter](http://swifter.tips) 也值得收藏
[唐巧的技术博客](http://blog.devtang.com) | 唐巧, 国内知名 iOS 开发者, 现就职于猿题库, 博客推出的 iOS 移动开发周报很受欢迎, 更新频繁
[txx's blog](http://blog.txx.im) | 90 后 iOS 开发者, 人称虾神, 文章内容讲解大多浅白易懂, 很值得看
[破船之家](http://beyondvincent.com) | 博主也是 iOS 大神一个, 经常更新一些 iOS 教程, 文章的质量都很高, 非常值得看
[NSHipster](http://nshipster.cn) | NSHipster 的中文网站, 主要对 NSHipster 的英文网站进行翻译, 博文出自 Mattt 大神之手, 文章大都写得很深入, 详细, 每周一更
[Limboy 无网不剩](http://limboy.me/) | 李忠, 知乎前员工, 目前在负责花瓣 iOS 开发, 不少文章里面有介绍博主个人的学习方法, 让读者在学到技术的同时也掌握学习的技巧
[念茜的博客](http://blog.csdn.net/yiyaaixuexi) | iOS 圈的女神人物, 写的关于安全问题的文章都值得一看, 由于新博客刚开通不久, 目前文章较少, 可以去看下她以前的[博客](http://blog.csdn.net/yiyaaixuexi)
[iOS技术周报](http://weekly.ios-wiki.com/history) | 吴发伟, 天猫资深软件开发工程师, iOS 技术周报每周一更, 推送一些 iOS 技巧, 代码库, 设计等资讯.
[iWangKe.me](http://www.iwangke.me) | 王轲, IndieBros Studio 创始人, 优秀的 iOS 开发工程师, 写的文章深入浅出, 很多问题分析透彻, 非常有条理性
[叶孤城](http://www.jianshu.com/p/99e8b3f6f377) | 叶孤城, 优秀 iOS 开发工程师, 发表的文章都有很多干货, 对源码解析类文章写得浅显易懂, 并时常总结一些 iOS 开发技巧, 值得一读
[Kevin Blog](http://zhowkev.in) | 周楷雯, 秒视创始人, 知名 iOS 工程师, 做出了 [PNChart](https://github.com/kevinzhow/PNChart) 和 [Waver](https://github.com/kevinzhow/Waver) 这样的好项目, 在博客中也有谈到具体的实现过程
[IMTX](http://imtx.me) | 图拉鼎, 知名 Apple 平台开发者, 曾经的 Ubuntu 平台开发者, 文章有不少干货, 大多讲解技术实现和学习经验
[更多](https://github.com/tangqiaoboy/iOSBlogCN) | 唐巧收集的中文 iOS/Mac 开发博客列表, 更新频繁, 值得收藏

## 文章

标题  | 内容简介
---- | -----
[Learn Objective C: The Path to iPhone Development](https://blog.udemy.com/learn-objective-c/) | Udemy 写的文章, 说明了一些学习 Objective-C 的前提条件, Objective-C 的发展历史, 学习方法以及学习资源
[I Want to Write iOS Apps. Where Do I Start?](http://lifehacker.com/i-want-to-write-ios-apps-where-do-i-start-1644802175) | 主要对 iOS 的开发环境进行了介绍, 并且涉及到了 Swift 的学习, iOS 上架的注意事项, iOS 的设计, 测试, 代码托管等, 讲解较为广泛, 同时也给出不少学习资源
[How to become a professional iOS developer](http://roadfiresoftware.com/2014/04/how-to-become-a-professional-ios-developer/) | 文章写的很有条理, 文中多次强调了版本控制系统的重要性, 主要内容是对学习 iOS 开发到就职, 给出了自己的建议
[Learning iOS Programming](http://codewithchris.com/learning-ios-programming/) | 作者总结了一些自己学习 iOS 的血的教训, 最后给出了一些不错学习建议
[Become an iOS Developer](https://www.udacity.com/career-paths/ios-developer) | 作者列举了一些学习 iOS 的方法以及常用的库, 以及自学 iOS 的一些建议
[iOS 开发如何提高](http://www.devtang.com/blog/2014/07/27/ios-levelup-tips/) | 唐巧写的一篇文章, 主要是对 iOS 技术的提高做的一个总结, 文中不少资源, 工具, 学习方法
[自学 iOS 开发的一些经验](http://limboy.me/tech/2014/12/31/learning-ios.html) | 文章从入门到进阶到高级, 分为三个阶段, 有条理的讲出了 iOS 的整个学习过程中开发者可能遇到的问题, 并给出了解决办法, 奉献了不少好工具, 资源还有珍贵的学习经验
[如何从 0 开始学 iOS 开发](http://readful.com/post/101914515826/0-ios) | 作者给出了学习 iOS 的流程, 并给出一些不错的学习资源
[如果我可以重新学习 iOS 开发](http://www.cocoachina.com/programmer/20141128/10353.html) | 作者在文中给出了学习的一些建议, 也谈到了自己的学习方法
[iOS 开发学习路径的一些建议](http://www.cocoachina.com/ios/20141106/10147.html) | 文中谈到了英语的重要性, 以及写博客, 看源代码的好处
[iOS 开发入门](http://www.jianshu.com/p/KSuDqb) | 作者分享了自己学习 iOS 的经验和资源
[Mac 和 iOS 开发资源汇总](http://beyondvincent.com/blog/2013/07/18/106) | 破船之家发布的资源汇总
[CocoaPods 使用教程](http://www.raywenderlich.com/64546/introduction-to-cocoapods-2) | 文章讲解了 CocoaPods 的基本使用, 并且配上 AFNetworking 做出了一个小 Demo, 值得一看
[iOS 开发路线简述](http://www.coderyi.com/archives/397) | 作者简单介绍了一下自己 iOS 开发的感受，也是他学习 iOS 开发的一个体系架构.
[iOS 干货文章、blog](http://www.jianshu.com/p/818d121363dd) | 作者收集的 iOS 干货文章、blog.

## 相关网站

网站  |  简介
---- | ----
[tutsplus](http://tutsplus.com/tutorials/search?utf8=%E2%9C%93&search%5Btopic%5D=&search%5Bterms%5D=ios&button=) | 不定时更新一些 iOS 教程
[WWDC](https://developer.apple.com/videos) | 苹果官方每年一度的 WWDC 视频, 可以了解历年有关 iOS 发布的内容
[ASCIIwwdc](http://asciiwwdc.com) | WWDC 的文字版
[Awesome Swift](https://swift.zeef.com/robin.eggenkamp) | 该网站收集了很多关于 Swift 的学习资料, 新闻
[Appcoda](http://www.appcoda.com) | 经常发布一些 iOS 编程教程, 更新比较频繁, 想了解更多可以查看该网站的 About 界面
[NSHipster](http://nshipster.com) | NSHipster is a journal of the overlooked bits in Objective-C, Swift, and Cocoa. Updated weekly.
[Think and Build](http://www.thinkandbuild.it) | Some tutorials about Core Graphic and Core Animation.
[Tutorials](http://www.raywenderlich.com/tutorials) | 大把的 Objective-C, Swift, iOS 教程, 且全部免费, Raywenderlich 真是业界良心, 赞!

## 社区

社区  |  简介
---- | ----
[CocoaChina](http://www.cocoachina.com) | 全球最大苹果开发者中文社区
[code4app](http://code4app.com) | 经常更新一些很不错的 iOS 代码片段和一些 iOS 资源
[objc](https://www.objc.io/) | 定期发布一些有关 Objective-C 的高质量的文章
[objc中国](http://objccn.io) | 喵神组织的对 objc.io 的翻译网站, 旨在推进国内技术圈整体水平, 翻译质量非常高
[DevDiv](http://www.devdiv.com) | 发布一些 iOS 的最新资讯及教程
[Cocos2d-x](http://discuss.cocos2d-x.org) | Cocos2d-x 论坛
[iPhone Dev SDK](http://iphonedevsdk.com) | 国外较有名的 iOS 开发者论坛
[Learn Cocoa and iOS Development Forum](http://forum.learncocoa.org) | [Learn Cocoa on the Mac](http://www.amazon.com/Learn-Cocoa-Mac-Jack-Nutting/dp/1430245425) 和 [Beginning iOS 7 Development](http://www.amazon.com/Beginning-iOS-Development-Exploring-SDK/dp/143026022X) 这两本书籍的官方论坛, 用户活跃度较高
[Apple Developer Forums](http://devforums.apple.com) | 苹果官方的开发者论坛
[Swiftist](http://www.swiftist.org) | Swift 中文社区
[掘金](https://www.juejin.im/tag/iOS) | 掘金技术社区的 iOS 分类

## 工具/插件

工具/插件  |  简介
---- | ----
[CocoaPods](https://cocoapods.org/) | 开发 OS X 和 iOS 应用程序的一个第三方库的依赖管理工具, 本身是 Ruby 的一个 Gem, 极大的简化了 Objective-C 的开发流程
[Alcatraz](http://alcatraz.io) | Alcatraz 是一款管理 Xcode 插件、模版以及颜色配置的工具
[XcodeColors](https://github.com/robbiehanson/XcodeColors) | 使 Xcode 调试控制台色彩更丰富
[xctool](https://github.com/facebook/xctool) | Facebook 开源的一个 iOS 编译和测试的工具
[XToDo](https://github.com/trawor/XToDo) | 一款注释辅助插件，主要用于收集并列出项目中的`TODO`, `FIXME`, `???`, `!!!`
[KSImageNamed-Xcode](https://github.com/ksuther/KSImageNamed-Xcode) | 自动补全图片命名的一款插件
[VVDocumenter](https://github.com/onevcat/VVDocumenter-Xcode) | 一个自动生成代码注释的工具
[ImageOptim](https://imageoptim.com) | 用于压缩图片一款工具
[fastlane](https://github.com/fastlane/fastlane) | 开发流程工具，将开发过程流程化，极大提高开发效率
[iOS 必备的 75 个工具](http://benscheirman.com/2013/08/the-ios-developers-toolbelt/) | 其中包含了非常多好用的工具, 涉及到设计, 分析, 部署等, 总结的十分详细, 有[中文翻译](http://blog.jobbole.com/46799/)
[更多](http://blog.devtang.com/blog/2014/06/29/ios-dev-tools/) | 唐巧总结的一些图形应用工具, 命令行工具, Xcode 插件, 并介绍了一点基础的用法

## 指南/教程

网址  |  简介
---- | ----
[App Store Review Guidelines](https://developer.apple.com/app-store/review/guidelines) | iOS 应用商店审核指南, 有[中文翻译版](http://www.cocoachina.com/ios/20140227/7892.html)
[Swift 语言指南](http://dev.swiftguide.cn) | 有很多丰富的 Swift 学习资料, 学习 Swift 有这份资料可以省下很多力气
[苹果 Xcode 帮助文档阅读指南](http://ourcoders.com/thread/show/117) | Tinyfool 推出的一篇对于帮助新手阅读官方文档的指南
[Get started with your iOS developer pragram](https://developer.apple.com/programs/ios/gettingstarted) | 苹果写的一篇入门指南, 粗略讲解了 iOS 程序从开发到上架的整个流程
[Teamtreehouse](http://blog.teamtreehouse.com/the-beginners-guide-to-objective-c-language-and-variables) | 文章主要讲解 Objective-C 的一些语法, 文章内容有趣且通俗易懂
[A map for iOS development](http://www.appdeveloperatlas.com) | 一张 iOS 开发地图, 做得很赞, 看完对 iOS 开发流程有一定的认知
[Start Developing iOS Apps Today](https://developer.apple.com/library/ios/referencelibrary/GettingStarted/RoadMapiOS) | 苹果官方给出的 iOS 入门教程, 看过之后能够做一个 To-Do 小程序
[Ry’s Objective-C Tutorial](http://rypress.com/tutorials/objective-c) | 讲解 Objective-C 的教程, 图文并茂, 适合新手阅读
[Objective-C Style Guide](https://github.com/raywenderlich/objective-c-style-guide) | Ray Wenderlich 推出的 Objective-C 风格指南
[iOS8 Day-by-Day](https://www.shinobicontrols.com/blog/introducing-ios8-day-by-day) | 每日一个 iOS8 的小教程, 所有的 DEMO 都可以在其 [GitHub](https://github.com/ShinobiControls/iOS8-day-by-day) 上面的找到相关代码
[iOS9 Day-by-Day](https://www.shinobicontrols.com/blog/ios9-day-by-day-index) | 每日一个 iOS9 的小教程, 所有的 DEMO 都可以在其 [GitHub](https://github.com/ShinobiControls/iOS9-day-by-day) 上面的找到相关代码

## 邮件订阅

- [iOS Dev Weekly](http://iosdevweekly.com) (每周一期，内容多为这一星期里值得关注的 GitHub 项目、文章、工具等)
- [iOS Design Weekly](http://iosdesign.co) (Tips, news and inspiration delivered each week)

## 文档

- [iOS Developer Library](https://developer.apple.com/library/ios/navigation) (iOS 开发必看, 有此文档足矣, 内容非常之详细)

## Awesome 系列

- [Awesome iOS](https://github.com/vsouza/awesome-ios)
- [Awesome-Swift(1)](https://github.com/matteocrippa/awesome-swift)
- [Awesome-Swift(2)](https://github.com/Wolg/awesome-swift)
- [Awesome-watchOS](https://github.com/yenchenlin1994/awesome-watchos)

## Raywenderlich 系列 (以下书籍目前均已更新至xcode7.0和swift2.0)
书籍名称  |  简介
----  |  ----
[Swift Apprentice](http://www.raywenderlich.com/store/swift-apprentice) | 非常棒的 Swift 入门书籍，同时也提及了函数式编程，泛型，面向协议编程等话题
[The iOS Apprentice](http://www.raywenderlich.com/store/ios-apprentice) | 从零构建 4 个不同类型的 App，深入浅出各种 iOS 开发的技术，配合上面那本 [Swift Apprentice](http://www.raywenderlich.com/store/swift-apprentice) 效果更佳
[tvOS Apprentice](http://www.raywenderlich.com/store/tvos-apprentice) | 开发 Apple TV 应用的入门教程
[iOS 9 by Tutorials](http://www.raywenderlich.com/store/ios-9-by-tutorials) | iOS9.0 的新特性的介绍与实践
[watchOS 2 by Tutorials](http://www.raywenderlich.com/store/watchos-2-by-tutorials) | 开发 Apple Watch 应用的入门教程
[Core Data by Tutorials](http://www.raywenderlich.com/store/core-data-by-tutorials) | 深入浅出 Core Data
[iOS Animations by Tutorials](http://www.raywenderlich.com/store/ios-animations-by-tutorials) | 深入浅出 iOS 动画
[2D iOS & tvOS Games by Tutorials](http://www.raywenderlich.com/store/2d-ios-tvos-games-by-tutorials) | iOS 与 tvOS 2D 游戏开发入门教程
[3d-ios-games-by-tutorials](https://www.raywenderlich.com/store/3d-ios-games-by-tutorials) | iOS 3D 游戏开发教程

## 知乎上的讨论

- [如何才能系统的学习 iOS 开发，理解一些规则和深层次的机制原理？](http://www.zhihu.com/question/20016551)
- [没有 C 和 Objective-C 基础如何快速学习 iOS 开发？](http://www.zhihu.com/question/19627420)
- [iOS 开发怎么入门?](http://www.zhihu.com/question/20264108)
- [iOS 开发入门需要学习哪些知识，从一无所知到精通需要多长时间？](http://www.zhihu.com/question/20130048)
- [12 岁如何入门 iOS 编程？](http://www.zhihu.com/question/20919784)
- [GitHub 上都有哪些值得关注学习的 iOS 开源项目？](http://www.zhihu.com/question/22914651)

## Quora 上的讨论

- [What are the best resources to learn iOS development?](http://www.quora.com/What-are-the-best-resources-to-learn-iOS-development)
- [What are the best new resources for learning iOS development in 2014?](https://www.quora.com/What-are-the-best-new-resources-for-learning-iOS-development-in-2014)

## 国内知名的程序员开发日报

- [稀土掘金](http://gold.xitu.io/#/tag/iOS)
- [App 开发日报](http://app.memect.com)
- [开发者头条](http://toutiao.io)
- [码农周刊](http://weekly.manong.io)
- [伯乐头条](http://top.jobbole.com/)
- [极客头条](http://geek.csdn.net/)
- [移动开发周报](https://github.com/PaicHyperionDev/MobileDevWeekly)

## 贡献者

点击[该链接](https://github.com/Aufree/trip-to-iOS/graphs/contributors)查看该项目的所有贡献者

## License

以上内容采用 [CC BY-NC-SA 3.0](http://creativecommons.org/licenses/by-nc-sa/3.0/deed.zh) 进行许可, 转载请注明出处, 版权归本人及所有贡献者所有
