//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/timeseriesinsights/armtimeseriesinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ReferenceDataSetsServer is a fake server for instances of the armtimeseriesinsights.ReferenceDataSetsClient type.
type ReferenceDataSetsServer struct {
	// CreateOrUpdate is the fake for method ReferenceDataSetsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, parameters armtimeseriesinsights.ReferenceDataSetCreateOrUpdateParameters, options *armtimeseriesinsights.ReferenceDataSetsClientCreateOrUpdateOptions) (resp azfake.Responder[armtimeseriesinsights.ReferenceDataSetsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ReferenceDataSetsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, options *armtimeseriesinsights.ReferenceDataSetsClientDeleteOptions) (resp azfake.Responder[armtimeseriesinsights.ReferenceDataSetsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReferenceDataSetsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, options *armtimeseriesinsights.ReferenceDataSetsClientGetOptions) (resp azfake.Responder[armtimeseriesinsights.ReferenceDataSetsClientGetResponse], errResp azfake.ErrorResponder)

	// ListByEnvironment is the fake for method ReferenceDataSetsClient.ListByEnvironment
	// HTTP status codes to indicate success: http.StatusOK
	ListByEnvironment func(ctx context.Context, resourceGroupName string, environmentName string, options *armtimeseriesinsights.ReferenceDataSetsClientListByEnvironmentOptions) (resp azfake.Responder[armtimeseriesinsights.ReferenceDataSetsClientListByEnvironmentResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method ReferenceDataSetsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, environmentName string, referenceDataSetName string, referenceDataSetUpdateParameters armtimeseriesinsights.ReferenceDataSetUpdateParameters, options *armtimeseriesinsights.ReferenceDataSetsClientUpdateOptions) (resp azfake.Responder[armtimeseriesinsights.ReferenceDataSetsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewReferenceDataSetsServerTransport creates a new instance of ReferenceDataSetsServerTransport with the provided implementation.
// The returned ReferenceDataSetsServerTransport instance is connected to an instance of armtimeseriesinsights.ReferenceDataSetsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReferenceDataSetsServerTransport(srv *ReferenceDataSetsServer) *ReferenceDataSetsServerTransport {
	return &ReferenceDataSetsServerTransport{srv: srv}
}

// ReferenceDataSetsServerTransport connects instances of armtimeseriesinsights.ReferenceDataSetsClient to instances of ReferenceDataSetsServer.
// Don't use this type directly, use NewReferenceDataSetsServerTransport instead.
type ReferenceDataSetsServerTransport struct {
	srv *ReferenceDataSetsServer
}

// Do implements the policy.Transporter interface for ReferenceDataSetsServerTransport.
func (r *ReferenceDataSetsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReferenceDataSetsClient.CreateOrUpdate":
		resp, err = r.dispatchCreateOrUpdate(req)
	case "ReferenceDataSetsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "ReferenceDataSetsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReferenceDataSetsClient.ListByEnvironment":
		resp, err = r.dispatchListByEnvironment(req)
	case "ReferenceDataSetsClient.Update":
		resp, err = r.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReferenceDataSetsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/referenceDataSets/(?P<referenceDataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armtimeseriesinsights.ReferenceDataSetCreateOrUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	referenceDataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("referenceDataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, environmentNameParam, referenceDataSetNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReferenceDataSetResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReferenceDataSetsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/referenceDataSets/(?P<referenceDataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	referenceDataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("referenceDataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), resourceGroupNameParam, environmentNameParam, referenceDataSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReferenceDataSetsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/referenceDataSets/(?P<referenceDataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	referenceDataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("referenceDataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, environmentNameParam, referenceDataSetNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReferenceDataSetResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReferenceDataSetsServerTransport) dispatchListByEnvironment(req *http.Request) (*http.Response, error) {
	if r.srv.ListByEnvironment == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByEnvironment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/referenceDataSets`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.ListByEnvironment(req.Context(), resourceGroupNameParam, environmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReferenceDataSetListResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReferenceDataSetsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.TimeSeriesInsights/environments/(?P<environmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/referenceDataSets/(?P<referenceDataSetName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armtimeseriesinsights.ReferenceDataSetUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	environmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("environmentName")])
	if err != nil {
		return nil, err
	}
	referenceDataSetNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("referenceDataSetName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Update(req.Context(), resourceGroupNameParam, environmentNameParam, referenceDataSetNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ReferenceDataSetResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
