//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ServerConfigurationOptionsServer is a fake server for instances of the armsql.ServerConfigurationOptionsClient type.
type ServerConfigurationOptionsServer struct {
	// BeginCreateOrUpdate is the fake for method ServerConfigurationOptionsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, managedInstanceName string, serverConfigurationOptionName armsql.ServerConfigurationOptionName, parameters armsql.ServerConfigurationOption, options *armsql.ServerConfigurationOptionsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armsql.ServerConfigurationOptionsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerConfigurationOptionsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, serverConfigurationOptionName armsql.ServerConfigurationOptionName, options *armsql.ServerConfigurationOptionsClientGetOptions) (resp azfake.Responder[armsql.ServerConfigurationOptionsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedInstancePager is the fake for method ServerConfigurationOptionsClient.NewListByManagedInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ServerConfigurationOptionsClientListByManagedInstanceOptions) (resp azfake.PagerResponder[armsql.ServerConfigurationOptionsClientListByManagedInstanceResponse])
}

// NewServerConfigurationOptionsServerTransport creates a new instance of ServerConfigurationOptionsServerTransport with the provided implementation.
// The returned ServerConfigurationOptionsServerTransport instance is connected to an instance of armsql.ServerConfigurationOptionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerConfigurationOptionsServerTransport(srv *ServerConfigurationOptionsServer) *ServerConfigurationOptionsServerTransport {
	return &ServerConfigurationOptionsServerTransport{
		srv:                           srv,
		beginCreateOrUpdate:           newTracker[azfake.PollerResponder[armsql.ServerConfigurationOptionsClientCreateOrUpdateResponse]](),
		newListByManagedInstancePager: newTracker[azfake.PagerResponder[armsql.ServerConfigurationOptionsClientListByManagedInstanceResponse]](),
	}
}

// ServerConfigurationOptionsServerTransport connects instances of armsql.ServerConfigurationOptionsClient to instances of ServerConfigurationOptionsServer.
// Don't use this type directly, use NewServerConfigurationOptionsServerTransport instead.
type ServerConfigurationOptionsServerTransport struct {
	srv                           *ServerConfigurationOptionsServer
	beginCreateOrUpdate           *tracker[azfake.PollerResponder[armsql.ServerConfigurationOptionsClientCreateOrUpdateResponse]]
	newListByManagedInstancePager *tracker[azfake.PagerResponder[armsql.ServerConfigurationOptionsClientListByManagedInstanceResponse]]
}

// Do implements the policy.Transporter interface for ServerConfigurationOptionsServerTransport.
func (s *ServerConfigurationOptionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerConfigurationOptionsClient.BeginCreateOrUpdate":
		resp, err = s.dispatchBeginCreateOrUpdate(req)
	case "ServerConfigurationOptionsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerConfigurationOptionsClient.NewListByManagedInstancePager":
		resp, err = s.dispatchNewListByManagedInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerConfigurationOptionsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := s.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverConfigurationOptions/(?P<serverConfigurationOptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsql.ServerConfigurationOption](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		serverConfigurationOptionNameParam, err := parseWithCast(matches[regex.SubexpIndex("serverConfigurationOptionName")], func(v string) (armsql.ServerConfigurationOptionName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.ServerConfigurationOptionName(p), nil
		})
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, managedInstanceNameParam, serverConfigurationOptionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		s.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		s.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (s *ServerConfigurationOptionsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverConfigurationOptions/(?P<serverConfigurationOptionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	serverConfigurationOptionNameParam, err := parseWithCast(matches[regex.SubexpIndex("serverConfigurationOptionName")], func(v string) (armsql.ServerConfigurationOptionName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.ServerConfigurationOptionName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, serverConfigurationOptionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerConfigurationOption, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerConfigurationOptionsServerTransport) dispatchNewListByManagedInstancePager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByManagedInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedInstancePager not implemented")}
	}
	newListByManagedInstancePager := s.newListByManagedInstancePager.get(req)
	if newListByManagedInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/serverConfigurationOptions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByManagedInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByManagedInstancePager = &resp
		s.newListByManagedInstancePager.add(req, newListByManagedInstancePager)
		server.PagerResponderInjectNextLinks(newListByManagedInstancePager, req, func(page *armsql.ServerConfigurationOptionsClientListByManagedInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByManagedInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedInstancePager) {
		s.newListByManagedInstancePager.remove(req)
	}
	return resp, nil
}
