//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsql

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DatabaseSQLVulnerabilityAssessmentBaselinesClient contains the methods for the DatabaseSQLVulnerabilityAssessmentBaselines group.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentBaselinesClient() instead.
type DatabaseSQLVulnerabilityAssessmentBaselinesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDatabaseSQLVulnerabilityAssessmentBaselinesClient creates a new instance of DatabaseSQLVulnerabilityAssessmentBaselinesClient with the specified values.
//   - subscriptionID - The subscription ID that identifies an Azure subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDatabaseSQLVulnerabilityAssessmentBaselinesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DatabaseSQLVulnerabilityAssessmentBaselinesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DatabaseSQLVulnerabilityAssessmentBaselinesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Add a database's vulnerability assessment rule baseline list.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - parameters - The requested rule baseline resource.
//   - options - DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateOptions contains the optional parameters for the
//     DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate method.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateOptions) (DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, parameters, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, parameters DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) createOrUpdateHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentBaselineSet); err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Get - Gets a list of database's sql vulnerability assessment rule baselines.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - DatabaseSQLVulnerabilityAssessmentBaselinesClientGetOptions contains the optional parameters for the DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get
//     method.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientGetOptions) (DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse, error) {
	var err error
	const operationName = "DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, options)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) getCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, baselineName BaselineName, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if baselineName == "" {
		return nil, errors.New("parameter baselineName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{baselineName}", url.PathEscape(string(baselineName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) getHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentBaselineSet); err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse{}, err
	}
	return result, nil
}

// NewListBySQLVulnerabilityAssessmentPager - Gets a list of database's sql vulnerability assessment rule baselines.
//
// Generated from API version 2022-11-01-preview
//   - resourceGroupName - The name of the resource group that contains the resource. You can obtain this value from the Azure
//     Resource Manager API or the portal.
//   - serverName - The name of the server.
//   - databaseName - The name of the database.
//   - vulnerabilityAssessmentName - The name of the vulnerability assessment.
//   - options - DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentOptions contains the optional
//     parameters for the DatabaseSQLVulnerabilityAssessmentBaselinesClient.NewListBySQLVulnerabilityAssessmentPager method.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) NewListBySQLVulnerabilityAssessmentPager(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentOptions) *runtime.Pager[DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse] {
	return runtime.NewPager(runtime.PagingHandler[DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse]{
		More: func(page DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse) (DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DatabaseSQLVulnerabilityAssessmentBaselinesClient.NewListBySQLVulnerabilityAssessmentPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySQLVulnerabilityAssessmentCreateRequest(ctx, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, options)
			}, nil)
			if err != nil {
				return DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse{}, err
			}
			return client.listBySQLVulnerabilityAssessmentHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySQLVulnerabilityAssessmentCreateRequest creates the ListBySQLVulnerabilityAssessment request.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) listBySQLVulnerabilityAssessmentCreateRequest(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName VulnerabilityAssessmentName, options *DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if serverName == "" {
		return nil, errors.New("parameter serverName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{serverName}", url.PathEscape(serverName))
	if databaseName == "" {
		return nil, errors.New("parameter databaseName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{databaseName}", url.PathEscape(databaseName))
	if vulnerabilityAssessmentName == "" {
		return nil, errors.New("parameter vulnerabilityAssessmentName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vulnerabilityAssessmentName}", url.PathEscape(string(vulnerabilityAssessmentName)))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySQLVulnerabilityAssessmentHandleResponse handles the ListBySQLVulnerabilityAssessment response.
func (client *DatabaseSQLVulnerabilityAssessmentBaselinesClient) listBySQLVulnerabilityAssessmentHandleResponse(resp *http.Response) (DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse, error) {
	result := DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DatabaseSQLVulnerabilityAssessmentBaselineSetListResult); err != nil {
		return DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse{}, err
	}
	return result, nil
}
